/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ValueReference;

public class ObjectIdentifierValue
extends MibValue {
    private FileLocation location = null;
    private MibValue parent;
    private ArrayList children = new ArrayList();
    private String name;
    private int value;
    private MibValueSymbol symbol = null;
    private String cachedNumericValue = null;

    public ObjectIdentifierValue(String name, int value) {
        super("OBJECT IDENTIFIER");
        this.parent = null;
        this.name = name;
        this.value = value;
    }

    public ObjectIdentifierValue(FileLocation location, ObjectIdentifierValue parent, String name, int value) throws MibException {
        super("OBJECT IDENTIFIER");
        this.parent = parent;
        this.name = name;
        this.value = value;
        if (parent.getChildByValue(value) != null) {
            throw new MibException(location, "cannot add duplicate OID children with value " + value);
        }
        parent.addChild(null, location, this);
    }

    public ObjectIdentifierValue(FileLocation location, ValueReference parent, String name, int value) {
        super("OBJECT IDENTIFIER");
        this.location = location;
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) throws MibException {
        ValueReference ref = null;
        if (this.parent == null) {
            return this;
        }
        if (this.parent instanceof ValueReference) {
            ref = (ValueReference)this.parent;
        }
        this.parent = this.parent.initialize(log, type);
        if (ref != null) {
            if (this.parent instanceof ObjectIdentifierValue) {
                ObjectIdentifierValue oid = (ObjectIdentifierValue)this.parent;
                oid.addChild(log, this.location, this);
            } else {
                throw new MibException(ref.getLocation(), "referenced value is not an object identifier");
            }
        }
        this.location = null;
        if (this.parent instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.parent).getChildByValue(this.value);
        }
        return this;
    }

    @Override
    public MibValue createReference() {
        return this;
    }

    @Override
    protected void clear() {
        if (this.children != null) {
            Mib mib = this.getMib();
            ArrayList copy = (ArrayList)this.children.clone();
            int i = 0;
            while (i < copy.size()) {
                ObjectIdentifierValue child = (ObjectIdentifierValue)copy.get(i);
                if (mib == null || mib == child.getMib()) {
                    child.clear();
                }
                ++i;
            }
        }
        if (this.getChildCount() <= 0) {
            if (this.parent != null) {
                this.getParent().children.remove(this);
                this.parent = null;
            }
            this.children = null;
        }
        this.symbol = null;
        super.clear();
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ObjectIdentifierValue getParent() {
        if (this.parent != null && this.parent instanceof ObjectIdentifierValue) {
            return (ObjectIdentifierValue)this.parent;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public MibValueSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(MibValueSymbol symbol) {
        if (this.name == null) {
            this.name = symbol.getName();
        }
        this.symbol = symbol;
    }

    private Mib getMib() {
        return this.symbol == null ? null : this.symbol.getMib();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public ObjectIdentifierValue getChild(int index) {
        return (ObjectIdentifierValue)this.children.get(index);
    }

    public ObjectIdentifierValue getChildByName(String name) {
        int i = 0;
        while (i < this.children.size()) {
            ObjectIdentifierValue child = (ObjectIdentifierValue)this.children.get(i);
            if (name.equals(child.getName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public ObjectIdentifierValue getChildByValue(int value) {
        int low = 0;
        int high = this.children.size();
        int pos = low < value && value <= high ? value - 1 : (low + high) / 2;
        while (low < high) {
            ObjectIdentifierValue child = (ObjectIdentifierValue)this.children.get(pos);
            if (child.getValue() == value) {
                return child;
            }
            if (child.getValue() < value) {
                low = pos + 1;
            } else {
                high = pos;
            }
            pos = (low + high) / 2;
        }
        return null;
    }

    public ObjectIdentifierValue[] getAllChildren() {
        ObjectIdentifierValue[] values = new ObjectIdentifierValue[this.children.size()];
        this.children.toArray(values);
        return values;
    }

    private ObjectIdentifierValue addChild(MibLoaderLog log, FileLocation location, ObjectIdentifierValue child) throws MibException {
        int i = this.children.size();
        while (i > 0) {
            ObjectIdentifierValue value = (ObjectIdentifierValue)this.children.get(i - 1);
            if (value.getValue() == child.getValue()) {
                value = value.merge(log, location, child);
                this.children.set(i - 1, value);
                return value;
            }
            if (value.getValue() < child.getValue()) break;
            --i;
        }
        this.children.add(i, child);
        return child;
    }

    private void addChildren(MibLoaderLog log, FileLocation location, ObjectIdentifierValue parent) throws MibException {
        if (this.name == null) {
            this.name = parent.name;
        } else if (parent.name != null && !parent.name.equals(this.name)) {
            String msg = "OID component '" + parent.name + "' was previously " + "defined as '" + this.name + "'";
            if (log == null) {
                throw new MibException(location, msg);
            }
            log.addWarning(location, msg);
        }
        if (parent.symbol != null) {
            throw new MibException(location, "INTERNAL ERROR: OID merge with symbol reference already set");
        }
        int i = 0;
        while (i < parent.children.size()) {
            ObjectIdentifierValue child = (ObjectIdentifierValue)parent.children.get(i);
            child.parent = this;
            this.addChild(log, location, child);
            ++i;
        }
        parent.children = null;
    }

    private ObjectIdentifierValue merge(MibLoaderLog log, FileLocation location, ObjectIdentifierValue value) throws MibException {
        if (this.symbol != null || value.symbol == null && this.children.size() > 0) {
            this.addChildren(log, location, value);
            return this;
        }
        value.addChildren(log, location, this);
        return value;
    }

    @Override
    public Object toObject() {
        return this.toString();
    }

    public String toString() {
        if (this.cachedNumericValue == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.parent != null) {
                buffer.append(this.parent.toString());
                buffer.append(".");
            }
            buffer.append(this.value);
            this.cachedNumericValue = buffer.toString();
        }
        return this.cachedNumericValue;
    }

    public String toDetailString() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent instanceof ObjectIdentifierValue) {
            buffer.append(((ObjectIdentifierValue)this.parent).toDetailString());
            buffer.append(".");
        }
        if (this.name == null) {
            buffer.append(this.value);
        } else {
            buffer.append(this.name);
            buffer.append("(");
            buffer.append(this.value);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String toAsn1String() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue ref = (ObjectIdentifierValue)this.parent;
            if (ref.getSymbol() == null) {
                buffer.append(ref.toAsn1String());
            } else {
                buffer.append(ref.getSymbol().getName());
            }
            buffer.append(" ");
        }
        if (this.name == null || this.getSymbol() != null) {
            buffer.append(this.value);
        } else {
            buffer.append(this.name);
            buffer.append("(");
            buffer.append(this.value);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

