/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class GraphUpdateManager
extends UpdateManager {
    private Rectangle damage;
    private Map<IFigure, Rectangle> dirtyRegions = new HashMap<IFigure, Rectangle>();
    private GraphicsSource graphicsSource;
    private Map<IFigure, Rectangle> invalidFigures = new LinkedHashMap<IFigure, Rectangle>();
    private IFigure root;
    private boolean updateQueued;
    private boolean updating;
    private boolean validating;
    private RunnableChain afterUpdate;

    public GraphUpdateManager(GraphicsSource gs) {
        this.setGraphicsSource(gs);
    }

    public GraphUpdateManager() {
    }

    public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        if (w == 0 || h == 0 || !figure.isShowing()) {
            return;
        }
        Rectangle rect = this.dirtyRegions.get(figure);
        if (rect == null) {
            rect = new Rectangle(x, y, w, h);
            this.dirtyRegions.put(figure, rect);
        } else {
            rect.union(x, y, w, h);
        }
        this.queueWork();
    }

    public synchronized void addInvalidFigure(IFigure f) {
        if (this.invalidFigures.containsKey(f)) {
            return;
        }
        this.queueWork();
        this.invalidFigures.put(f, null);
    }

    protected Graphics getGraphics(Rectangle region) {
        if (this.graphicsSource == null) {
            return null;
        }
        return this.graphicsSource.getGraphics(region);
    }

    public void paint(GC gc) {
        if (this.root == null) {
            return;
        }
        if (!this.validating) {
            SWTGraphics graphics = new SWTGraphics(gc);
            if (!this.updating) {
                Rectangle rect = graphics.getClip(new Rectangle());
                HashMap<IFigure, Rectangle> map = new HashMap<IFigure, Rectangle>();
                map.put(this.root, rect);
                this.firePainting(rect, map);
            }
            this.performValidation();
            this.root.paint((Graphics)graphics);
            graphics.dispose();
            gc.dispose();
        } else {
            this.addDirtyRegion(this.root, new Rectangle(gc.getClipping()));
        }
    }

    public synchronized void performUpdate() {
        if (this.isDisposed() || this.updating) {
            return;
        }
        this.updating = true;
        try {
            this.performValidation();
            this.updateQueued = false;
            this.repairDamage();
            if (this.afterUpdate != null) {
                RunnableChain chain = this.afterUpdate;
                this.afterUpdate = null;
                chain.run();
                if (this.afterUpdate != null) {
                    this.queueWork();
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    public void performValidation() {
        if (this.invalidFigures.isEmpty() || this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.fireValidating();
            Iterator<IFigure> it = this.invalidFigures.keySet().iterator();
            while (it.hasNext()) {
                IFigure fig = it.next();
                it.remove();
                fig.validate();
            }
        }
        finally {
            this.invalidFigures.clear();
            this.validating = false;
        }
    }

    public synchronized void performUpdate(Rectangle exposed) {
        if (this.root == null) {
            return;
        }
        this.addDirtyRegion(this.root, exposed);
        this.performUpdate();
    }

    protected void queueWork() {
        if (!this.updateQueued) {
            this.sendUpdateRequest();
            this.updateQueued = true;
        }
    }

    protected void sendUpdateRequest() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new SWTException(22);
        }
        display.asyncExec((Runnable)new UpdateRequest());
    }

    protected void releaseGraphics(Graphics graphics) {
        graphics.dispose();
        this.graphicsSource.flushGraphics(this.damage);
    }

    protected void repairDamage() {
        Graphics graphics;
        for (IFigure figure : this.dirtyRegions.keySet()) {
            IFigure walker = figure.getParent();
            Rectangle contribution = this.dirtyRegions.get(figure);
            contribution.intersect(figure.getBounds());
            while (!contribution.isEmpty() && walker != null) {
                walker.translateToParent((Translatable)contribution);
                contribution.intersect(walker.getBounds());
                walker = walker.getParent();
            }
            if (this.damage == null) {
                this.damage = new Rectangle(contribution);
                continue;
            }
            this.damage.union(contribution);
        }
        if (!this.dirtyRegions.isEmpty()) {
            Map<IFigure, Rectangle> oldRegions = this.dirtyRegions;
            this.dirtyRegions = new HashMap<IFigure, Rectangle>();
            this.firePainting(this.damage, oldRegions);
        }
        if (this.damage != null && !this.damage.isEmpty() && (graphics = this.getGraphics(this.damage)) != null) {
            this.root.paint(graphics);
            this.releaseGraphics(graphics);
        }
        this.damage = null;
    }

    public synchronized void runWithUpdate(Runnable runnable) {
        this.afterUpdate = new RunnableChain(runnable, this.afterUpdate);
        if (!this.updating) {
            this.queueWork();
        }
    }

    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }

    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    protected void validateFigures() {
        this.performValidation();
    }

    private static class RunnableChain {
        RunnableChain next;
        Runnable run;

        RunnableChain(Runnable run, RunnableChain next) {
            this.run = run;
            this.next = next;
        }

        void run() {
            if (this.next != null) {
                this.next.run();
            }
            this.run.run();
        }
    }

    protected class UpdateRequest
    implements Runnable {
        @Override
        public void run() {
            GraphUpdateManager.this.performUpdate();
        }
    }
}

