/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import com.blixx.boom.gui.graph.LWS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.RevealListener;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class Graph
extends FigureCanvas
implements IContainer {
    public static final int ANIMATION_TIME = 500;
    public static final int FISHEYE_ANIMATION_TIME = 100;
    public Color LIGHT_BLUE = new Color(null, 216, 228, 248);
    public Color LIGHT_BLUE_CYAN = new Color(null, 213, 243, 255);
    public Color GREY_BLUE = new Color(null, 139, 150, 171);
    public Color DARK_BLUE = new Color(null, 1, 70, 122);
    public Color LIGHT_YELLOW = new Color(null, 255, 255, 206);
    public Color HIGHLIGHT_COLOR = ColorConstants.yellow;
    public Color HIGHLIGHT_ADJACENT_COLOR = ColorConstants.orange;
    public Color DEFAULT_NODE_COLOR = this.LIGHT_BLUE;
    protected Map nodes;
    protected Map connections;
    protected List selectedItems = null;
    protected IFigure fisheyedFigure = null;
    protected List selectionListeners = null;
    protected HashMap figure2ItemMap = null;
    protected int connectionStyle;
    protected int nodeStyle;
    protected List constraintAdapters;
    protected List revealListeners = null;
    protected LayoutAlgorithm layoutAlgorithm = null;
    protected Dimension preferredSize = null;
    protected int style = 0;
    protected ScalableFreeformLayeredPane rootlayer;
    protected ZestRootLayer zestRootLayer;

    public Graph(Composite parent, int style, LWS lws) {
        super(parent, style | 0x20000000, (LightweightSystem)lws);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.LIGHT_BLUE = new Color((Device)Display.getDefault(), 216, 228, 248);
        this.LIGHT_BLUE_CYAN = new Color((Device)Display.getDefault(), 213, 243, 255);
        this.GREY_BLUE = new Color((Device)Display.getDefault(), 139, 150, 171);
        this.DARK_BLUE = new Color((Device)Display.getDefault(), 1, 70, 122);
        this.LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 206);
        this.setViewport((Viewport)new FreeformViewport());
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents((IFigure)this.createLayers());
        DragSupport dragSupport = new DragSupport(this);
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new LinkedHashMap(200, 0.95f);
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new HashMap(200, 0.95f);
        this.constraintAdapters = new ArrayList();
        this.selectedItems = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.figure2ItemMap = new HashMap(200, 0.95f);
        this.revealListeners = new ArrayList(1);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!Graph.this.revealListeners.isEmpty()) {
                    Iterator iterator = Graph.this.revealListeners.iterator();
                    while (iterator.hasNext()) {
                        RevealListener reveallisetner = (RevealListener)iterator.next();
                        reveallisetner.revealed((Control)Graph.this);
                        iterator.remove();
                    }
                }
            }
        });
    }

    public Graph(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.LIGHT_BLUE = new Color((Device)Display.getDefault(), 216, 228, 248);
        this.LIGHT_BLUE_CYAN = new Color((Device)Display.getDefault(), 213, 243, 255);
        this.GREY_BLUE = new Color((Device)Display.getDefault(), 139, 150, 171);
        this.DARK_BLUE = new Color((Device)Display.getDefault(), 1, 70, 122);
        this.LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 206);
        this.setViewport((Viewport)new FreeformViewport());
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents((IFigure)this.createLayers());
        DragSupport dragSupport = new DragSupport(this);
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new LinkedHashMap(200, 0.95f);
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new HashMap(200, 0.95f);
        this.constraintAdapters = new ArrayList();
        this.selectedItems = new ArrayList();
        this.selectionListeners = new ArrayList();
        this.figure2ItemMap = new HashMap(200, 0.95f);
        this.revealListeners = new ArrayList(1);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!Graph.this.revealListeners.isEmpty()) {
                    Iterator iterator = Graph.this.revealListeners.iterator();
                    while (iterator.hasNext()) {
                        RevealListener reveallisetner = (RevealListener)iterator.next();
                        reveallisetner.revealed((Control)Graph.this);
                        iterator.remove();
                    }
                }
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    @Override
    public Map getNodes() {
        return this.nodes;
    }

    public void addConstraintAdapter(ConstraintAdapter constraintAdapter) {
        this.constraintAdapters.add(constraintAdapter);
    }

    public void setConstraintAdapters(List constraintAdapters) {
        this.constraintAdapters = constraintAdapters;
    }

    public ScalableFigure getRootLayer() {
        return this.rootlayer;
    }

    public void setConnectionStyle(int connectionStyle) {
        this.connectionStyle = connectionStyle;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public Map getConnections() {
        return this.connections;
    }

    public void setSelection(GraphItem[] nodes) {
        this.clearSelection();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] != null && nodes[i] instanceof GraphItem) {
                    this.selectedItems.add(nodes[i]);
                    nodes[i].highlight();
                }
                ++i;
            }
        }
    }

    public void selectAll() {
        this.clearSelection();
        for (GraphNode gn : this.nodes.keySet()) {
            this.selectedItems.add(gn);
            gn.highlight();
        }
    }

    public List getSelection() {
        return this.selectedItems;
    }

    public String toString() {
        return "GraphModel {" + this.nodes.size() + " nodes, " + this.connections.size() + " connections}";
    }

    public Graph getGraphModel() {
        return this;
    }

    public void dispose() {
        for (GraphNode node : this.nodes.keySet()) {
            if (node == null || node.isDisposed()) continue;
            node.dispose();
        }
        for (GraphConnection connection : this.connections.keySet()) {
            if (connection == null || connection.isDisposed()) continue;
            connection.dispose();
        }
        this.nodes.clear();
        this.connections.clear();
        super.dispose();
        this.LIGHT_BLUE.dispose();
        this.LIGHT_BLUE_CYAN.dispose();
        this.GREY_BLUE.dispose();
        this.DARK_BLUE.dispose();
        this.LIGHT_YELLOW.dispose();
    }

    public void clean() {
        try {
            for (GraphNode node : this.nodes.keySet()) {
                if (node == null || node.isDisposed()) continue;
                node.dispose();
            }
            for (GraphConnection connection : this.connections.keySet()) {
                if (connection == null || connection.isDisposed()) continue;
                connection.dispose();
            }
            this.figure2ItemMap.clear();
            this.nodes.clear();
            this.connections.clear();
            this.zestRootLayer.removeAll();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void applyLayout() {
        this.addRevealListener(new RevealListener(){

            @Override
            public void revealed(Control c) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Graph.this.applyLayoutInternal();
                    }
                });
            }
        });
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.layoutAlgorithm = algorithm;
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public IFigure getFigureAt(int x, int y) {
        IFigure figureUnderMouse = this.getContents().findFigureAt(x, y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return true;
            }

            public boolean prune(IFigure figure) {
                IFigure parent = figure.getParent();
                if (parent instanceof ContainerFigure && figure instanceof PolylineConnection) {
                    return false;
                }
                if (parent == Graph.this.zestRootLayer || parent == Graph.this.zestRootLayer.getParent() || parent == Graph.this.zestRootLayer.getParent().getParent()) {
                    return false;
                }
                GraphItem item = (GraphItem)((Object)Graph.this.figure2ItemMap.get(figure));
                if (item != null && item.getItemType() == 3) {
                    return false;
                }
                return !(figure instanceof FreeformLayer) && !(parent instanceof FreeformLayer) && !(figure instanceof ScrollPane) && !(parent instanceof ScrollPane) && !(parent instanceof ScalableFreeformLayeredPane) && !(figure instanceof ScalableFreeformLayeredPane) && !(figure instanceof FreeformViewport) && !(parent instanceof FreeformViewport);
            }
        });
        return figureUnderMouse;
    }

    private void clearSelection() {
        if (this.selectedItems.size() > 0) {
            for (GraphItem item : this.selectedItems) {
                item.unhighlight();
            }
            this.selectedItems.clear();
        }
    }

    private void fireWidgetSelectedEvent(Item item) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            Event swtEvent = new Event();
            swtEvent.item = item;
            swtEvent.widget = this;
            SelectionEvent event = new SelectionEvent(swtEvent);
            selectionListener.widgetSelected(event);
        }
    }

    void highlightEdge(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        if (figure != null && !connection.isHighlighted()) {
            this.zestRootLayer.highlightConnection((IFigure)figure);
        }
    }

    void unhighlightEdge(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        if (figure != null && connection.isHighlighted()) {
            this.zestRootLayer.unHighlightConnection((IFigure)figure);
        }
    }

    void highlightNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && !node.isHighlighted()) {
            this.zestRootLayer.highlightNode(figure);
        }
    }

    void highlightNode(GraphContainer node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && !node.isHighlighted()) {
            this.zestRootLayer.highlightNode(figure);
        }
    }

    void unhighlightNode(GraphContainer node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && node.isHighlighted()) {
            this.zestRootLayer.unHighlightNode(figure);
        }
    }

    void unhighlightNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && node.isHighlighted()) {
            this.zestRootLayer.unHighlightNode(figure);
        }
    }

    protected GraphConnection[] getConnectionsArray() {
        GraphConnection[] connsArray = new GraphConnection[this.connections.size()];
        connsArray = this.connections.keySet().toArray(connsArray);
        return connsArray;
    }

    protected LayoutRelationship[] getConnectionsToLayout(Map nodesToLayout) {
        LayoutRelationship[] entities;
        Set keySet = nodesToLayout.keySet();
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutRelationship> connectionList = new LinkedList<LayoutRelationship>();
            for (GraphConnection next : this.getConnections().keySet()) {
                if (!next.isVisible() || !keySet.contains((Object)next.getSource()) || !keySet.contains((Object)next.getDestination())) continue;
                connectionList.add(next.getLayoutRelationship());
            }
            entities = connectionList.toArray(new LayoutRelationship[0]);
        } else {
            LinkedList<LayoutRelationship> nodeList = new LinkedList<LayoutRelationship>();
            for (GraphConnection next : this.getConnections().keySet()) {
                if (!keySet.contains((Object)next.getSource()) || !keySet.contains((Object)next.getDestination())) continue;
                nodeList.add(next.getLayoutRelationship());
            }
            entities = nodeList.toArray(new LayoutRelationship[0]);
        }
        return entities;
    }

    protected LayoutEntity[] getNodesToLayout(Map nodes) {
        LayoutEntity[] entities;
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode next : nodes.keySet()) {
                if (!next.isVisible()) continue;
                nodeList.add(next.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        } else {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode next : nodes.keySet()) {
                nodeList.add(next.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        }
        return entities;
    }

    protected void removeConnection(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        PolylineConnection sourceContainerConnectionFigure = connection.getSourceContainerConnectionFigure();
        PolylineConnection targetContainerConnectionFigure = connection.getTargetContainerConnectionFigure();
        connection.removeFigure();
        this.getConnections().remove((Object)connection);
        this.figure2ItemMap.remove(figure);
        if (sourceContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(sourceContainerConnectionFigure);
        }
        if (targetContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(targetContainerConnectionFigure);
        }
    }

    void removeNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure.getParent() != null) {
            if (figure.getParent() instanceof ZestRootLayer) {
                ((ZestRootLayer)figure.getParent()).removeNode(figure);
            } else {
                figure.getParent().remove(figure);
            }
        }
        this.getNodes().remove((Object)node);
        this.figure2ItemMap.remove(figure);
    }

    void addConnection(GraphConnection connection, boolean addToEdgeLayer) {
        this.connections.put(connection, null);
        if (addToEdgeLayer) {
            this.zestRootLayer.addConnection(connection.getFigure());
        }
    }

    void addNode(GraphNode node) {
        this.getNodes().put(node, null);
        this.zestRootLayer.addNode(node.getFigure());
    }

    void addNode(GraphContainer graphContainer) {
        this.getNodes().put(graphContainer, null);
        this.zestRootLayer.addNode(graphContainer.getFigure());
    }

    void registerItem(GraphItem item) {
        if (item.getItemType() == 1) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else if (item.getItemType() == 2) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
            if (((GraphConnection)item).getSourceContainerConnectionFigure() != null) {
                this.figure2ItemMap.put(((GraphConnection)item).getSourceContainerConnectionFigure(), item);
            }
            if (((GraphConnection)item).getTargetContainerConnectionFigure() != null) {
                this.figure2ItemMap.put(((GraphConnection)item).getTargetContainerConnectionFigure(), item);
            }
        } else if (item.getItemType() == 3) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
        } else {
            throw new RuntimeException("Unknown item type: " + item.getItemType());
        }
    }

    void changeNodeFigure(IFigure oldValue, IFigure newFigure, GraphNode graphItem) {
        if (this.zestRootLayer.getChildren().contains(oldValue)) {
            this.zestRootLayer.remove(oldValue);
            this.figure2ItemMap.remove(oldValue);
        }
        this.figure2ItemMap.put(newFigure, graphItem);
        this.zestRootLayer.add(newFigure);
    }

    void invokeConstraintAdapters(Object object, LayoutConstraint constraint) {
        if (this.constraintAdapters == null) {
            return;
        }
        for (ConstraintAdapter constraintAdapter : this.constraintAdapters) {
            constraintAdapter.populateConstraint(object, constraint);
        }
    }

    private void applyLayoutInternal() {
        if (this.getNodes().size() == 0) {
            return;
        }
        int layoutStyle = 0;
        if ((this.nodeStyle & 0x10) > 0) {
            layoutStyle = 1;
        }
        if (this.layoutAlgorithm == null) {
            this.layoutAlgorithm = new TreeLayoutAlgorithm(layoutStyle);
        }
        this.layoutAlgorithm.setStyle(this.layoutAlgorithm.getStyle() | layoutStyle);
        Dimension d = this.getViewport().getSize();
        d.width -= 10;
        d.height -= 10;
        if (this.preferredSize.width >= 0) {
            d.width = this.preferredSize.width;
        }
        if (this.preferredSize.height >= 0) {
            d.height = this.preferredSize.height;
        }
        if (d.isEmpty()) {
            return;
        }
        LayoutRelationship[] connectionsToLayout = this.getConnectionsToLayout(this.nodes);
        LayoutEntity[] nodesToLayout = this.getNodesToLayout(this.getNodes());
        try {
            Animation.markBegin();
            this.layoutAlgorithm.applyLayout(nodesToLayout, connectionsToLayout, 0.0, 0.0, (double)d.width, (double)d.height, false, false);
            Animation.run((int)500);
            this.getLightweightSystem().getUpdateManager().performUpdate();
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
        }
    }

    private void addRevealListener(RevealListener revealListener) {
        MyRunnable myRunnable = new MyRunnable(){
            boolean isVisible;

            @Override
            public boolean isVisible() {
                return this.isVisible;
            }

            @Override
            public void run() {
                this.isVisible = Graph.this.isVisible();
            }
        };
        Display.getDefault().syncExec((Runnable)myRunnable);
        if (myRunnable.isVisible()) {
            revealListener.revealed((Control)this);
        } else {
            this.revealListeners.add(revealListener);
        }
    }

    private ScalableFigure createLayers() {
        this.rootlayer = new ScalableFreeformLayeredPane();
        this.rootlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.zestRootLayer = new ZestRootLayer();
        this.zestRootLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootlayer.add((IFigure)this.zestRootLayer);
        this.zestRootLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        return this.rootlayer;
    }

    @Override
    public Graph getGraph() {
        return this.getGraphModel();
    }

    @Override
    public int getItemType() {
        return 0;
    }

    GraphItem getGraphItem(IFigure figure) {
        return (GraphItem)((Object)this.figure2ItemMap.get(figure));
    }

    public void commitAdded() {
        this.zestRootLayer.commitAdded();
    }

    class DragSupport
    implements MouseMotionListener,
    MouseListener {
        Graph graph = null;
        Point lastLocation = null;
        GraphItem fisheyedItem = null;
        boolean isDragging = false;

        DragSupport(Graph graph2) {
            this.graph = graph2;
        }

        public void mouseDragged(MouseEvent me) {
            if (!this.isDragging) {
                return;
            }
            Point mousePoint = new Point(me.x, me.y);
            Point tempPoint = mousePoint.getCopy();
            if (Graph.this.selectedItems.size() > 0) {
                for (GraphItem item : Graph.this.selectedItems) {
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    Point pointCopy = mousePoint.getCopy();
                    Point tempLastLocation = this.lastLocation.getCopy();
                    item.getFigure().getParent().translateToRelative((Translatable)tempLastLocation);
                    item.getFigure().getParent().translateFromParent((Translatable)tempLastLocation);
                    item.getFigure().getParent().translateToRelative((Translatable)pointCopy);
                    item.getFigure().getParent().translateFromParent((Translatable)pointCopy);
                    Point delta = new Point(pointCopy.x - tempLastLocation.x, pointCopy.y - tempLastLocation.y);
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    GraphNode node = (GraphNode)item;
                    int x = node.getLocation().x + delta.x;
                    int y = node.getLocation().y + delta.y;
                    node.setLocation(x, y);
                }
                if (Graph.this.fisheyedFigure != null) {
                    Point pointCopy = mousePoint.getCopy();
                    Point tempLastLocation = this.lastLocation.getCopy();
                    Graph.this.fisheyedFigure.translateToRelative((Translatable)tempLastLocation);
                    Graph.this.fisheyedFigure.translateFromParent((Translatable)tempLastLocation);
                    Graph.this.fisheyedFigure.translateToRelative((Translatable)pointCopy);
                    Graph.this.fisheyedFigure.translateFromParent((Translatable)pointCopy);
                    Point delta = new Point(pointCopy.x - tempLastLocation.x, pointCopy.y - tempLastLocation.y);
                    new Point(Graph.this.fisheyedFigure.getBounds().x + delta.x, Graph.this.fisheyedFigure.getBounds().y + delta.y);
                }
            }
            Graph.this.getRootLayer().getScale();
            Graph.this.getRootLayer().validate();
            this.lastLocation = tempPoint;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.isDragging = true;
            Point mousePoint = new Point(me.x, me.y);
            this.lastLocation = mousePoint.getCopy();
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            if (me.getState() == 65536) {
                double scale = Graph.this.getRootLayer().getScale();
                Graph.this.getRootLayer().setScale(scale *= 1.05);
                Point newMousePoint = mousePoint.getCopy().scale(1.05);
                Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                Graph.this.getViewport().setViewLocation(newViewLocation);
                this.lastLocation.scale(scale);
                Graph.this.clearSelection();
                return;
            }
            if (me.getState() == 196608) {
                double scale = Graph.this.getRootLayer().getScale();
                Graph.this.getRootLayer().setScale(scale /= 1.05);
                Point newMousePoint = mousePoint.getCopy().scale(0.9523809523809523);
                Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                Graph.this.getViewport().setViewLocation(newViewLocation);
                Graph.this.clearSelection();
                return;
            }
            boolean hasSelection = Graph.this.selectedItems.size() > 0;
            System.currentTimeMillis();
            IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
            if (figureUnderMouse == null || figureUnderMouse == this.graph) {
                if (me.getState() != 131072) {
                    Graph.this.clearSelection();
                    if (hasSelection) {
                        Graph.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            GraphItem itemUnderMouse = (GraphItem)((Object)Graph.this.figure2ItemMap.get(figureUnderMouse));
            if (itemUnderMouse == null) {
                if (me.getState() != 131072) {
                    Graph.this.clearSelection();
                    if (hasSelection) {
                        Graph.this.fireWidgetSelectedEvent(null);
                        hasSelection = false;
                    }
                }
                return;
            }
            if (Graph.this.selectedItems.contains((Object)itemUnderMouse)) {
                if (me.getState() == 131072) {
                    Graph.this.selectedItems.remove((Object)itemUnderMouse);
                    itemUnderMouse.unhighlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                }
                return;
            }
            if (me.getState() != 131072) {
                Graph.this.clearSelection();
            }
            if (itemUnderMouse.getItemType() == 1) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphNode)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 2) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphConnection)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            } else if (itemUnderMouse.getItemType() == 3) {
                Graph.this.selectedItems.add(itemUnderMouse);
                ((GraphContainer)itemUnderMouse).highlight();
                Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.isDragging = false;
        }
    }

    static interface MyRunnable
    extends Runnable {
        public boolean isVisible();
    }
}

