/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.graph.GConnection;
import com.blixx.shared.space.Connection;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.core.widgets.internal.LoopAnchor;
import org.eclipse.zest.core.widgets.internal.PolylineArcConnection;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class GraphConnection
extends GraphItem {
    private Font font;
    private GraphNode sourceNode;
    private GraphNode destinationNode;
    private double weight;
    private Color color;
    private Color highlightColor;
    private Color foreground;
    private int lineWidth;
    private int lineStyle;
    private Graph graphModel;
    private int connectionStyle;
    private int curveDepth;
    private boolean isDisposed = false;
    private Label connectionLabel = null;
    private org.eclipse.draw2d.Connection connectionFigure = null;
    private org.eclipse.draw2d.Connection sourceContainerConnectionFigure = null;
    private org.eclipse.draw2d.Connection targetContainerConnectionFigure = null;
    private boolean visible;
    private IFigure tooltip;
    private boolean highlighted;
    private GraphLayoutConnection layoutConnection = null;
    private boolean hasCustomTooltip;

    public GraphConnection(Graph graphModel, int style, GraphNode source, GraphNode destination) {
        super((Widget)graphModel, style);
        this.connectionStyle |= graphModel.getConnectionStyle();
        this.connectionStyle |= style;
        this.sourceNode = source;
        this.destinationNode = destination;
        this.visible = true;
        this.color = ColorConstants.lightGray;
        this.foreground = ColorConstants.lightGray;
        this.highlightColor = graphModel.DARK_BLUE;
        this.lineWidth = 1;
        this.lineStyle = 1;
        this.graphModel = graphModel;
        this.curveDepth = 0;
        this.layoutConnection = new GraphLayoutConnection();
        this.font = Display.getDefault().getSystemFont();
        this.registerConnection(source, destination);
    }

    private void registerConnection(GraphNode source, GraphNode destination) {
        source.addSourceConnection(this);
        destination.addTargetConnection(this);
        this.graphModel.addConnection(this, true);
        this.graphModel.registerItem(this);
    }

    void removeFigure() {
        if (this.connectionFigure.getParent() != null) {
            if (this.connectionFigure.getParent() instanceof ZestRootLayer) {
                ((ZestRootLayer)this.connectionFigure.getParent()).removeConnection((IFigure)this.connectionFigure);
            } else {
                this.connectionFigure.getParent().remove((IFigure)this.connectionFigure);
            }
        }
        this.connectionFigure = null;
        if (this.sourceContainerConnectionFigure != null) {
            this.sourceContainerConnectionFigure.getParent().remove((IFigure)this.sourceContainerConnectionFigure);
            this.sourceContainerConnectionFigure = null;
        }
        if (this.targetContainerConnectionFigure != null) {
            this.targetContainerConnectionFigure.getParent().remove((IFigure)this.targetContainerConnectionFigure);
            this.targetContainerConnectionFigure = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.isDisposed = true;
        this.sourceNode = null;
        this.destinationNode = null;
        this.graphModel = null;
        try {
            this.connectionFigure.setSourceAnchor(null);
            this.connectionFigure.setTargetAnchor(null);
            this.connectionFigure = null;
            this.connectionLabel = null;
        }
        catch (Throwable throwable) {}
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public org.eclipse.draw2d.Connection getConnectionFigure() {
        if (this.connectionFigure == null) {
            this.connectionFigure = this.createFigure();
        }
        return this.connectionFigure;
    }

    public LayoutRelationship getLayoutRelationship() {
        return this.layoutConnection;
    }

    public Object getExternalConnection() {
        return this.getData();
    }

    public String toString() {
        String arrow = this.isBidirectionalInLayout() ? " <--> " : " --> ";
        String src = this.sourceNode != null ? this.sourceNode.getText() : "null";
        String dest = this.destinationNode != null ? this.destinationNode.getText() : "null";
        String weight = "  (weight=" + this.getWeightInLayout() + ")";
        return "GraphModelConnection: " + src + arrow + dest + weight;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setConnectionStyle(int style) {
        this.connectionStyle = style;
        this.updateFigure(this.connectionFigure);
    }

    public double getWeightInLayout() {
        return this.weight;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setWeight(double weight) {
        this.weight = weight < 0.0 ? -1.0 : (weight > 1.0 ? 1.0 : weight);
    }

    public Color getLineColor() {
        return this.color;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setLineColor(Color color) {
        this.foreground = color;
        this.changeLineColor(this.foreground);
    }

    public void changeLineColor(Color color) {
        Connection c;
        Object o = this.getData();
        if (o instanceof Connection && (c = (Connection)o).isFiltered()) {
            this.color = BMUI.color_magenta;
            this.updateFigure(this.connectionFigure);
            return;
        }
        this.color = color;
        this.updateFigure(this.connectionFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigure(this.connectionFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.updateFigure(this.connectionFigure);
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.updateFigure(this.connectionFigure);
    }

    public GraphNode getSource() {
        return this.sourceNode;
    }

    public GraphNode getDestination() {
        return this.destinationNode;
    }

    @Override
    public void highlight() {
        if (this.highlighted || this.isDisposed) {
            return;
        }
        this.highlighted = true;
        this.updateFigure(this.connectionFigure);
        this.graphModel.highlightEdge(this);
    }

    @Override
    public void unhighlight() {
        if (!this.highlighted || this.isDisposed) {
            return;
        }
        this.highlighted = false;
        this.updateFigure(this.connectionFigure);
        this.graphModel.unhighlightEdge(this);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public Graph getGraphModel() {
        return this.graphModel;
    }

    public void setCurveDepth(int depth) {
        if (this.curveDepth == 0 && depth != 0 || this.curveDepth != 0 && depth == 0) {
            this.graphModel.removeConnection(this);
            this.curveDepth = depth;
            this.connectionFigure = this.createFigure();
            this.registerConnection(this.sourceNode, this.destinationNode);
            this.updateFigure(this.connectionFigure);
        } else {
            this.curveDepth = depth;
            this.updateFigure(this.connectionFigure);
        }
    }

    @Override
    public int getItemType() {
        return 2;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.getSource().isVisible() && this.getDestination().isVisible() && visible) {
            this.getFigure().setVisible(visible);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(visible);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(visible);
            }
            this.visible = visible;
        } else {
            this.getFigure().setVisible(false);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(false);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(false);
            }
            this.visible = false;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setText(String string) {
        super.setText(string);
        if (this.connectionFigure != null) {
            this.updateFigure(this.connectionFigure);
        }
    }

    public String getText() {
        Connection c;
        Object o;
        if (this.getData() != null && (o = this.getData()) instanceof Connection && (c = (Connection)o).isFiltered()) {
            return c.getFilter().toString();
        }
        return null;
    }

    PolylineConnection getSourceContainerConnectionFigure() {
        return (PolylineConnection)this.sourceContainerConnectionFigure;
    }

    PolylineConnection getTargetContainerConnectionFigure() {
        return (PolylineConnection)this.targetContainerConnectionFigure;
    }

    private void updateFigure(org.eclipse.draw2d.Connection connection) {
        if (this.sourceContainerConnectionFigure != null) {
            this.doUpdateFigure(this.sourceContainerConnectionFigure);
        }
        if (this.targetContainerConnectionFigure != null) {
            this.doUpdateFigure(this.targetContainerConnectionFigure);
        }
        this.doUpdateFigure(connection);
    }

    private void doUpdateFigure(org.eclipse.draw2d.Connection connection) {
        IFigure toolTip;
        if (connection == null) {
            return;
        }
        Shape connectionShape = (Shape)connection;
        connectionShape.setLineStyle(this.getLineStyle());
        if (this.getText() != null || this.getImage() != null) {
            if (this.getImage() != null) {
                this.connectionLabel.setIcon(this.getImage());
            }
            if (this.getText() != null) {
                this.connectionLabel.setText(this.getText());
            }
            this.connectionLabel.setFont(this.getFont());
        }
        if (this.highlighted) {
            connectionShape.setForegroundColor(this.getHighlightColor());
            connectionShape.setLineWidth(this.getLineWidth() * 2);
        } else {
            connectionShape.setForegroundColor(this.getLineColor());
            connectionShape.setLineWidth(this.getLineWidth());
        }
        if (connection instanceof PolylineArcConnection) {
            PolylineArcConnection arcConnection = (PolylineArcConnection)connection;
            arcConnection.setDepth(this.curveDepth);
        }
        if (this.getTooltip() == null && this.getText() != null && this.getText().length() > 0 && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        connection.setToolTip(toolTip);
    }

    private org.eclipse.draw2d.Connection createFigure() {
        return this.doCreateFigure();
    }

    private org.eclipse.draw2d.Connection doCreateFigure() {
        Object connectionFigure = null;
        LoopAnchor sourceAnchor = null;
        LoopAnchor targetAnchor = null;
        this.connectionLabel = new Label();
        if (this.getSource() == this.getDestination()) {
            connectionFigure = new PolylineArcConnection();
            sourceAnchor = new LoopAnchor(this.getSource().getNodeFigure());
            targetAnchor = new LoopAnchor(this.getDestination().getNodeFigure());
            new MidpointLocator((org.eclipse.draw2d.Connection)connectionFigure, 0){

                protected Point getReferencePoint() {
                    Point p = Point.SINGLETON;
                    p.x = this.getConnection().getPoints().getPoint((int)this.getIndex()).x;
                    p.y = (int)((double)this.getConnection().getPoints().getPoint((int)this.getIndex()).y - (double)GraphConnection.this.curveDepth * 1.5);
                    return p;
                }
            };
        } else {
            if (this.curveDepth != 0) {
                connectionFigure = new PolylineArcConnection();
                connectionFigure.setDepth(this.curveDepth);
            } else {
                connectionFigure = new GConnection((IFigure)this.graphModel.zestRootLayer);
            }
            sourceAnchor = new ChopboxAnchor(this.getSource().getNodeFigure());
            targetAnchor = new ChopboxAnchor(this.getDestination().getNodeFigure());
        }
        connectionFigure.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        connectionFigure.setTargetAnchor((ConnectionAnchor)targetAnchor);
        this.doUpdateFigure((org.eclipse.draw2d.Connection)connectionFigure);
        return connectionFigure;
    }

    private boolean isBidirectionalInLayout() {
        return !ZestStyles.checkStyle(this.connectionStyle, 2);
    }

    @Override
    IFigure getFigure() {
        return this.getConnectionFigure();
    }

    public void setData(Object data) {
        super.setData(data);
        if (data instanceof Connection) {
            Connection c = (Connection)data;
            if (c.isFiltered()) {
                this.color = BMUI.color_magenta;
                this.updateFigure(this.connectionFigure);
            } else {
                this.color = BMUI.color_lightGrey;
            }
        }
    }

    class GraphLayoutConnection
    implements LayoutRelationship {
        Object layoutInformation = null;

        GraphLayoutConnection() {
        }

        public void clearBendPoints() {
        }

        public LayoutEntity getDestinationInLayout() {
            return GraphConnection.this.getDestination().getLayoutEntity();
        }

        public Object getLayoutInformation() {
            return this.layoutInformation;
        }

        public LayoutEntity getSourceInLayout() {
            return GraphConnection.this.getSource().getLayoutEntity();
        }

        public void populateLayoutConstraint(LayoutConstraint constraint) {
            GraphConnection.this.graphModel.invokeConstraintAdapters((Object)GraphConnection.this, constraint);
        }

        public void setBendPoints(LayoutBendPoint[] bendPoints) {
        }

        public void setLayoutInformation(Object layoutInformation) {
            this.layoutInformation = layoutInformation;
        }

        public Object getGraphData() {
            return GraphConnection.this;
        }

        public void setGraphData(Object o) {
        }
    }
}

