/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import com.blixx.boom.gui.graph.FreeformHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class ZestRootLayer
extends FreeformLayer {
    public static final boolean EDGES_ON_TOP = false;
    public int numberOfNodes = 0;
    private int numberOfConnections = 0;
    private int numberOfHighlightedNodes = 0;
    private int numberOfHighlightedConnections = 0;
    static final int FLAG_REALIZED = Integer.MIN_VALUE;
    private Map connections = new LinkedHashMap(200);
    private Map nodes = new LinkedHashMap(200);
    private FreeformHelper helper = new FreeformHelper((FreeformFigure)this);

    public void addNode(IFigure nodeFigure) {
        int nodePosition = this.getNodePosition();
        ++this.numberOfNodes;
        if (this.getChildren() == Collections.EMPTY_LIST) {
            this.add(nodeFigure, nodePosition);
        } else {
            nodeFigure.setParent((IFigure)this);
            this.helper.hookChild(nodeFigure);
            this.nodes.put(nodeFigure, nodePosition);
        }
    }

    public void removeNode(IFigure nodeFigure) {
        if (!this.getChildren().contains(nodeFigure)) {
            throw new RuntimeException("Node not contained on the ZestRootLayer");
        }
        int nodePosition = this.getChildren().indexOf(nodeFigure);
        if (nodePosition > this.getHighlightNodeStartPosition()) {
            --this.numberOfHighlightedNodes;
        } else {
            --this.numberOfNodes;
        }
        this.remove(nodeFigure);
    }

    public void removeConnection(IFigure connectionFigure) {
        int connectionPosition = this.getChildren().indexOf(connectionFigure);
        if (connectionPosition > this.getHighlightConnectionStartPosition()) {
            --this.numberOfHighlightedConnections;
        } else {
            --this.numberOfConnections;
        }
        this.remove(connectionFigure);
    }

    public void addConnection(IFigure connectionFigure) {
        int connectionPosition = this.getConnectionPosition();
        ++this.numberOfConnections;
        connectionFigure.setParent((IFigure)this);
        if (this.getFlag(Integer.MIN_VALUE)) {
            connectionFigure.addNotify();
        }
        this.connections.put(connectionFigure, connectionPosition);
    }

    public void commitAdded() {
        System.currentTimeMillis();
        this.getChildren().addAll(this.connections.keySet());
        this.getChildren().addAll(this.nodes.keySet());
        this.connections.clear();
        this.nodes.clear();
    }

    public void highlightNode(IFigure nodeFigure) {
        --this.numberOfNodes;
        int highlightNodePosition = this.getHighlightNodePosition();
        ++this.numberOfHighlightedNodes;
        this.getChildren().remove(nodeFigure);
        this.getChildren().add(highlightNodePosition, nodeFigure);
        this.invalidate();
        this.repaint();
    }

    public void highlightConnection(IFigure connectionFigure) {
        --this.numberOfConnections;
        int highlightConnectionPosition = this.getHighlightConnectionPosition();
        ++this.numberOfHighlightedConnections;
        this.getChildren().remove(connectionFigure);
        this.getChildren().add(highlightConnectionPosition, connectionFigure);
        this.invalidate();
        this.repaint();
    }

    public void unHighlightNode(IFigure nodeFigure) {
        int nodePosition = this.getChildren().indexOf(nodeFigure);
        if (nodePosition > this.getHighlightNodePosition()) {
            return;
        }
        --this.numberOfHighlightedNodes;
        nodePosition = this.getNodePosition();
        ++this.numberOfNodes;
        this.getChildren().remove(nodeFigure);
        this.getChildren().add(nodePosition, nodeFigure);
        this.invalidate();
        this.repaint();
    }

    public void unHighlightConnection(IFigure connectionFigure) {
        int connectionPosition = this.getChildren().indexOf(connectionFigure);
        if (connectionPosition > this.getHighlightConnectionPosition()) {
            return;
        }
        --this.numberOfHighlightedConnections;
        ++this.numberOfConnections;
        connectionPosition = this.getConnectionPosition();
        this.getChildren().remove(connectionFigure);
        if (connectionPosition > this.getChildren().size()) {
            this.getChildren().add(connectionFigure);
        } else {
            this.getChildren().add(connectionPosition, connectionFigure);
        }
        this.invalidate();
        this.repaint();
    }

    private int getNodePosition() {
        return this.numberOfConnections + this.numberOfNodes;
    }

    private int getConnectionPosition() {
        return 0 + this.numberOfConnections;
    }

    private int getHighlightNodePosition() {
        return this.numberOfConnections + this.numberOfHighlightedConnections + this.numberOfNodes + this.numberOfHighlightedNodes;
    }

    private int getHighlightConnectionPosition() {
        return this.numberOfConnections + this.numberOfNodes + this.numberOfHighlightedConnections;
    }

    private int getHighlightConnectionStartPosition() {
        return this.numberOfConnections + this.numberOfNodes;
    }

    private int getHighlightNodeStartPosition() {
        return this.numberOfConnections + this.numberOfHighlightedConnections + this.numberOfNodes;
    }

    public void removeAll() {
        super.removeAll();
        this.getChildren().clear();
        this.nodes.clear();
        this.connections.clear();
        this.numberOfConnections = 0;
        this.numberOfHighlightedConnections = 0;
        this.numberOfHighlightedNodes = 0;
        this.numberOfNodes = 0;
    }

    public Rectangle getFreeformExtent() {
        return this.helper.getFreeformExtent();
    }

    public void remove(IFigure child) {
        this.helper.unhookChild(child);
        super.remove(child);
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.helper.setFreeformBounds(bounds);
    }
}

