/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import org.snmp4j.smi.OID;

public final class SnmpConstants {
    public static final int DEFAULT_COMMAND_RESPONDER_PORT = 161;
    public static final int DEFAULT_NOTIFICATION_RECEIVER_PORT = 162;
    public static final int MIN_PDU_LENGTH = 484;
    public static final int MILLISECOND_TO_NANOSECOND = 1000000;
    public static final int HUNDREDTHS_TO_NANOSECOND = 10000000;
    public static final int version1 = 0;
    public static final int version2c = 1;
    public static final int version3 = 3;
    public static final int SNMP_ERROR_TIMEOUT = -1;
    public static final int SNMP_ERROR_LEXICOGRAPHIC_ORDER = -2;
    public static final int SNMP_ERROR_REPORT = -3;
    public static final int SNMP_ERROR_IO = -4;
    public static final int SNMP_ERROR_SUCCESS = 0;
    public static final int SNMP_ERROR_TOO_BIG = 1;
    public static final int SNMP_ERROR_NO_SUCH_NAME = 2;
    public static final int SNMP_ERROR_BAD_VALUE = 3;
    public static final int SNMP_ERROR_READ_ONLY = 4;
    public static final int SNMP_ERROR_GENERAL_ERROR = 5;
    public static final int SNMP_ERROR_NO_ACCESS = 6;
    public static final int SNMP_ERROR_WRONG_TYPE = 7;
    public static final int SNMP_ERROR_WRONG_LENGTH = 8;
    public static final int SNMP_ERROR_WRONG_ENCODING = 9;
    public static final int SNMP_ERROR_WRONG_VALUE = 10;
    public static final int SNMP_ERROR_NO_CREATION = 11;
    public static final int SNMP_ERROR_INCONSISTENT_VALUE = 12;
    public static final int SNMP_ERROR_RESOURCE_UNAVAILABLE = 13;
    public static final int SNMP_ERROR_COMMIT_FAILED = 14;
    public static final int SNMP_ERROR_UNDO_FAILED = 15;
    public static final int SNMP_ERROR_AUTHORIZATION_ERROR = 16;
    public static final int SNMP_ERROR_NOT_WRITEABLE = 17;
    public static final int SNMP_ERROR_INCONSISTENT_NAME = 18;
    public static final int SNMP_MP_OK = 0;
    public static final int SNMP_MP_ERROR = -1400;
    public static final int SNMP_MP_UNSUPPORTED_SECURITY_MODEL = -1402;
    public static final int SNMP_MP_NOT_IN_TIME_WINDOW = -1403;
    public static final int SNMP_MP_DOUBLED_MESSAGE = -1404;
    public static final int SNMP_MP_INVALID_MESSAGE = -1405;
    public static final int SNMP_MP_INVALID_ENGINEID = -1406;
    public static final int SNMP_MP_NOT_INITIALIZED = -1407;
    public static final int SNMP_MP_PARSE_ERROR = -1408;
    public static final int SNMP_MP_UNKNOWN_MSGID = -1409;
    public static final int SNMP_MP_MATCH_ERROR = -1410;
    public static final int SNMP_MP_COMMUNITY_ERROR = -1411;
    public static final int SNMP_MP_WRONG_USER_NAME = -1412;
    public static final int SNMP_MP_BUILD_ERROR = -1413;
    public static final int SNMP_MP_USM_ERROR = -1414;
    public static final int SNMP_MP_UNKNOWN_PDU_HANDLERS = -1415;
    public static final int SNMP_MP_UNAVAILABLE_CONTEXT = -1416;
    public static final int SNMP_MP_UNKNOWN_CONTEXT = -1417;
    public static final int SNMP_MP_REPORT_SENT = -1418;
    public static final int SNMPv1v2c_CSM_OK = 0;
    public static final int SNMPv1v2c_CSM_BAD_COMMUNITY_NAME = 1501;
    public static final int SNMPv1v2c_CSM_BAD_COMMUNITY_USE = 1502;
    public static final int SNMPv3_USM_OK = 0;
    public static final int SNMPv3_USM_ERROR = 1401;
    public static final int SNMPv3_USM_UNSUPPORTED_SECURITY_LEVEL = 1403;
    public static final int SNMPv3_USM_UNKNOWN_SECURITY_NAME = 1404;
    public static final int SNMPv3_USM_ENCRYPTION_ERROR = 1405;
    public static final int SNMPv3_USM_DECRYPTION_ERROR = 1406;
    public static final int SNMPv3_USM_AUTHENTICATION_ERROR = 1407;
    public static final int SNMPv3_USM_AUTHENTICATION_FAILURE = 1408;
    public static final int SNMPv3_USM_PARSE_ERROR = 1409;
    public static final int SNMPv3_USM_UNKNOWN_ENGINEID = 1410;
    public static final int SNMPv3_USM_NOT_IN_TIME_WINDOW = 1411;
    public static final int SNMPv3_USM_UNSUPPORTED_AUTHPROTOCOL = 1412;
    public static final int SNMPv3_USM_UNSUPPORTED_PRIVPROTOCOL = 1413;
    public static final int SNMPv3_USM_ADDRESS_ERROR = 1414;
    public static final int SNMPv3_USM_ENGINE_ID_TOO_LONG = 1415;
    public static final int SNMPv3_USM_SECURITY_NAME_TOO_LONG = 1416;
    public static final int SNMPv3_TSM_OK = 0;
    public static final int SNMPv3_TSM_UNKNOWN_PREFIXES = 1601;
    public static final int SNMPv3_TSM_INVALID_CACHES = 1602;
    public static final int SNMPv3_TSM_INADEQUATE_SECURITY_LEVELS = 1603;
    public static final int SNMP_MD_OK = 0;
    public static final int SNMP_MD_ERROR = 1701;
    public static final int SNMP_MD_UNSUPPORTED_MP_MODEL = 1702;
    public static final int SNMP_MD_UNSUPPORTED_ADDRESS_CLASS = 1703;
    public static final int SNMP_MD_UNSUPPORTED_SNMP_VERSION = 1704;
    public static final OID usmNoAuthProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 1, 1});
    public static final OID usmHMACMD5AuthProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 1, 2});
    public static final OID usmHMACSHAAuthProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 1, 3});
    public static final OID usmNoPrivProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 1});
    public static final OID usmDESPrivProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 2});
    public static final OID usm3DESEDEPrivProtocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 3});
    public static final OID usmAesCfb128Protocol = new OID(new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 4});
    public static final OID oosnmpUsmAesCfb192Protocol = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 2, 2, 1, 1, 1});
    public static final OID oosnmpUsmAesCfb256Protocol = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 2, 2, 1, 1, 2});
    public static final OID oosnmpUsmAesCfb192ProtocolWith3DESKeyExtension = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 2, 2, 1, 2, 1});
    public static final OID oosnmpUsmAesCfb256ProtocolWith3DESKeyExtension = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 2, 2, 1, 2, 2});
    public static final OID usmStatsUnsupportedSecLevels;
    public static final OID usmStatsNotInTimeWindows;
    public static final OID usmStatsUnknownUserNames;
    public static final OID usmStatsUnknownEngineIDs;
    public static final OID usmStatsWrongDigests;
    public static final OID usmStatsDecryptionErrors;
    public static final OID snmpEngineID;
    public static final OID snmpUnknownSecurityModels;
    public static final OID snmpInvalidMsgs;
    public static final OID snmpUnknownPDUHandlers;
    public static final OID snmpInPkts;
    public static final OID snmpInBadVersions;
    public static final OID snmpInBadCommunityNames;
    public static final OID snmpInBadCommunityUses;
    public static final OID snmpInASNParseErrs;
    public static final OID snmpSilentDrops;
    public static final OID snmpProxyDrops;
    public static final OID snmpTrapOID;
    public static final OID snmpTrapEnterprise;
    public static final OID snmpTraps;
    public static final OID coldStart;
    public static final OID warmStart;
    public static final OID authenticationFailure;
    public static final OID linkDown;
    public static final OID linkUp;
    public static final OID sysDescr;
    public static final OID sysObjectID;
    public static final OID sysUpTime;
    public static final OID sysContact;
    public static final OID sysName;
    public static final OID sysLocation;
    public static final OID sysServices;
    public static final OID sysOREntry;
    public static final OID snmpUnavailableContexts;
    public static final OID snmpUnknownContexts;
    public static final OID snmpTrapAddress;
    public static final OID snmpTrapCommunity;
    public static final OID zeroDotZero;
    public static final OID snmpTsmInvalidCaches;
    public static final OID snmpTsmInadequateSecurityLevels;
    public static final OID snmpTsmUnknownPrefixes;
    public static final OID snmpTsmInvalidPrefixes;
    public static final OID snmpTsmConfigurationUsePrefix;
    public static final OID snmpTlstmSessionOpens;
    public static final OID snmpTlstmSessionClientCloses;
    public static final OID snmpTlstmSessionOpenErrors;
    public static final OID snmpTlstmSessionAccepts;
    public static final OID snmpTlstmSessionServerCloses;
    public static final OID snmpTlstmSessionNoSessions;
    public static final OID snmpTlstmSessionInvalidClientCertificates;
    public static final OID snmpTlstmSessionUnknownServerCertificate;
    public static final OID snmpTlstmSessionInvalidServerCertificates;
    public static final OID snmpTlstmSessionInvalidCaches;
    public static final OID snmpSshtmSessionOpens;
    public static final OID snmpSshtmSessionCloses;
    public static final OID snmpSshtmSessionOpenErrors;
    public static final OID snmpSshtmSessionUserAuthFailures;
    public static final OID snmpSshtmSessionNoChannels;
    public static final OID snmpSshtmSessionNoSubsystems;
    public static final OID snmpSshtmSessionNoSessions;
    public static final OID snmpSshtmSessionInvalidCaches;
    public static final OID snmp4jStatsRequestTimeouts;
    public static final OID snmp4jStatsRequestRetries;
    public static final OID snmp4jStatsRequestWaitTime;
    public static final OID snmp4jStatsRequestRuntime;
    public static final OID snmp4jStatsReqTableTimeouts;
    public static final OID snmp4jStatsReqTableRetries;
    public static final OID snmp4jStatsReqTableWaitTime;
    public static final OID snmp4jStatsReqTableRuntime;
    public static final OID snmp4jStatsResponseTimeouts;
    public static final OID snmp4jStatsResponseIgnoredRetries;
    public static final OID snmp4jStatsResponseProcessTime;
    public static final OID snmpSetSerialNo;
    public static final String[] SNMP_TP_ERROR_MESSAGES;
    public static final String[] SNMP_ERROR_MESSAGES;
    public static String[][] MD_ERROR_MESSAGES;
    public static String[][] MP_ERROR_MESSAGES;
    public static String[][] USM_ERROR_MESSAGES;

    static {
        int[] nArray = new int[11];
        nArray[0] = 1;
        nArray[1] = 3;
        nArray[2] = 6;
        nArray[3] = 1;
        nArray[4] = 6;
        nArray[5] = 3;
        nArray[6] = 15;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        usmStatsUnsupportedSecLevels = new OID(nArray);
        int[] nArray2 = new int[11];
        nArray2[0] = 1;
        nArray2[1] = 3;
        nArray2[2] = 6;
        nArray2[3] = 1;
        nArray2[4] = 6;
        nArray2[5] = 3;
        nArray2[6] = 15;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 2;
        usmStatsNotInTimeWindows = new OID(nArray2);
        int[] nArray3 = new int[11];
        nArray3[0] = 1;
        nArray3[1] = 3;
        nArray3[2] = 6;
        nArray3[3] = 1;
        nArray3[4] = 6;
        nArray3[5] = 3;
        nArray3[6] = 15;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 3;
        usmStatsUnknownUserNames = new OID(nArray3);
        int[] nArray4 = new int[11];
        nArray4[0] = 1;
        nArray4[1] = 3;
        nArray4[2] = 6;
        nArray4[3] = 1;
        nArray4[4] = 6;
        nArray4[5] = 3;
        nArray4[6] = 15;
        nArray4[7] = 1;
        nArray4[8] = 1;
        nArray4[9] = 4;
        usmStatsUnknownEngineIDs = new OID(nArray4);
        int[] nArray5 = new int[11];
        nArray5[0] = 1;
        nArray5[1] = 3;
        nArray5[2] = 6;
        nArray5[3] = 1;
        nArray5[4] = 6;
        nArray5[5] = 3;
        nArray5[6] = 15;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[9] = 5;
        usmStatsWrongDigests = new OID(nArray5);
        int[] nArray6 = new int[11];
        nArray6[0] = 1;
        nArray6[1] = 3;
        nArray6[2] = 6;
        nArray6[3] = 1;
        nArray6[4] = 6;
        nArray6[5] = 3;
        nArray6[6] = 15;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = 6;
        usmStatsDecryptionErrors = new OID(nArray6);
        int[] nArray7 = new int[11];
        nArray7[0] = 1;
        nArray7[1] = 3;
        nArray7[2] = 6;
        nArray7[3] = 1;
        nArray7[4] = 6;
        nArray7[5] = 3;
        nArray7[6] = 10;
        nArray7[7] = 2;
        nArray7[8] = 1;
        nArray7[9] = 1;
        snmpEngineID = new OID(nArray7);
        int[] nArray8 = new int[11];
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 6;
        nArray8[3] = 1;
        nArray8[4] = 6;
        nArray8[5] = 3;
        nArray8[6] = 11;
        nArray8[7] = 2;
        nArray8[8] = 1;
        nArray8[9] = 1;
        snmpUnknownSecurityModels = new OID(nArray8);
        int[] nArray9 = new int[11];
        nArray9[0] = 1;
        nArray9[1] = 3;
        nArray9[2] = 6;
        nArray9[3] = 1;
        nArray9[4] = 6;
        nArray9[5] = 3;
        nArray9[6] = 11;
        nArray9[7] = 2;
        nArray9[8] = 1;
        nArray9[9] = 2;
        snmpInvalidMsgs = new OID(nArray9);
        int[] nArray10 = new int[11];
        nArray10[0] = 1;
        nArray10[1] = 3;
        nArray10[2] = 6;
        nArray10[3] = 1;
        nArray10[4] = 6;
        nArray10[5] = 3;
        nArray10[6] = 11;
        nArray10[7] = 2;
        nArray10[8] = 1;
        nArray10[9] = 3;
        snmpUnknownPDUHandlers = new OID(nArray10);
        int[] nArray11 = new int[9];
        nArray11[0] = 1;
        nArray11[1] = 3;
        nArray11[2] = 6;
        nArray11[3] = 1;
        nArray11[4] = 2;
        nArray11[5] = 1;
        nArray11[6] = 11;
        nArray11[7] = 1;
        snmpInPkts = new OID(nArray11);
        int[] nArray12 = new int[9];
        nArray12[0] = 1;
        nArray12[1] = 3;
        nArray12[2] = 6;
        nArray12[3] = 1;
        nArray12[4] = 2;
        nArray12[5] = 1;
        nArray12[6] = 11;
        nArray12[7] = 3;
        snmpInBadVersions = new OID(nArray12);
        int[] nArray13 = new int[9];
        nArray13[0] = 1;
        nArray13[1] = 3;
        nArray13[2] = 6;
        nArray13[3] = 1;
        nArray13[4] = 2;
        nArray13[5] = 1;
        nArray13[6] = 11;
        nArray13[7] = 4;
        snmpInBadCommunityNames = new OID(nArray13);
        int[] nArray14 = new int[9];
        nArray14[0] = 1;
        nArray14[1] = 3;
        nArray14[2] = 6;
        nArray14[3] = 1;
        nArray14[4] = 2;
        nArray14[5] = 1;
        nArray14[6] = 11;
        nArray14[7] = 5;
        snmpInBadCommunityUses = new OID(nArray14);
        int[] nArray15 = new int[9];
        nArray15[0] = 1;
        nArray15[1] = 3;
        nArray15[2] = 6;
        nArray15[3] = 1;
        nArray15[4] = 2;
        nArray15[5] = 1;
        nArray15[6] = 11;
        nArray15[7] = 6;
        snmpInASNParseErrs = new OID(nArray15);
        int[] nArray16 = new int[9];
        nArray16[0] = 1;
        nArray16[1] = 3;
        nArray16[2] = 6;
        nArray16[3] = 1;
        nArray16[4] = 2;
        nArray16[5] = 1;
        nArray16[6] = 11;
        nArray16[7] = 31;
        snmpSilentDrops = new OID(nArray16);
        int[] nArray17 = new int[9];
        nArray17[0] = 1;
        nArray17[1] = 3;
        nArray17[2] = 6;
        nArray17[3] = 1;
        nArray17[4] = 2;
        nArray17[5] = 1;
        nArray17[6] = 11;
        nArray17[7] = 32;
        snmpProxyDrops = new OID(nArray17);
        int[] nArray18 = new int[11];
        nArray18[0] = 1;
        nArray18[1] = 3;
        nArray18[2] = 6;
        nArray18[3] = 1;
        nArray18[4] = 6;
        nArray18[5] = 3;
        nArray18[6] = 1;
        nArray18[7] = 1;
        nArray18[8] = 4;
        nArray18[9] = 1;
        snmpTrapOID = new OID(nArray18);
        int[] nArray19 = new int[11];
        nArray19[0] = 1;
        nArray19[1] = 3;
        nArray19[2] = 6;
        nArray19[3] = 1;
        nArray19[4] = 6;
        nArray19[5] = 3;
        nArray19[6] = 1;
        nArray19[7] = 1;
        nArray19[8] = 4;
        nArray19[9] = 3;
        snmpTrapEnterprise = new OID(nArray19);
        snmpTraps = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5});
        coldStart = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 1});
        warmStart = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 2});
        authenticationFailure = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 5});
        linkDown = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 3});
        linkUp = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 4});
        int[] nArray20 = new int[9];
        nArray20[0] = 1;
        nArray20[1] = 3;
        nArray20[2] = 6;
        nArray20[3] = 1;
        nArray20[4] = 2;
        nArray20[5] = 1;
        nArray20[6] = 1;
        nArray20[7] = 1;
        sysDescr = new OID(nArray20);
        int[] nArray21 = new int[9];
        nArray21[0] = 1;
        nArray21[1] = 3;
        nArray21[2] = 6;
        nArray21[3] = 1;
        nArray21[4] = 2;
        nArray21[5] = 1;
        nArray21[6] = 1;
        nArray21[7] = 2;
        sysObjectID = new OID(nArray21);
        int[] nArray22 = new int[9];
        nArray22[0] = 1;
        nArray22[1] = 3;
        nArray22[2] = 6;
        nArray22[3] = 1;
        nArray22[4] = 2;
        nArray22[5] = 1;
        nArray22[6] = 1;
        nArray22[7] = 3;
        sysUpTime = new OID(nArray22);
        int[] nArray23 = new int[9];
        nArray23[0] = 1;
        nArray23[1] = 3;
        nArray23[2] = 6;
        nArray23[3] = 1;
        nArray23[4] = 2;
        nArray23[5] = 1;
        nArray23[6] = 1;
        nArray23[7] = 4;
        sysContact = new OID(nArray23);
        int[] nArray24 = new int[9];
        nArray24[0] = 1;
        nArray24[1] = 3;
        nArray24[2] = 6;
        nArray24[3] = 1;
        nArray24[4] = 2;
        nArray24[5] = 1;
        nArray24[6] = 1;
        nArray24[7] = 5;
        sysName = new OID(nArray24);
        int[] nArray25 = new int[9];
        nArray25[0] = 1;
        nArray25[1] = 3;
        nArray25[2] = 6;
        nArray25[3] = 1;
        nArray25[4] = 2;
        nArray25[5] = 1;
        nArray25[6] = 1;
        nArray25[7] = 6;
        sysLocation = new OID(nArray25);
        int[] nArray26 = new int[9];
        nArray26[0] = 1;
        nArray26[1] = 3;
        nArray26[2] = 6;
        nArray26[3] = 1;
        nArray26[4] = 2;
        nArray26[5] = 1;
        nArray26[6] = 1;
        nArray26[7] = 7;
        sysServices = new OID(nArray26);
        sysOREntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 9, 1});
        int[] nArray27 = new int[10];
        nArray27[0] = 1;
        nArray27[1] = 3;
        nArray27[2] = 6;
        nArray27[3] = 1;
        nArray27[4] = 6;
        nArray27[5] = 3;
        nArray27[6] = 12;
        nArray27[7] = 1;
        nArray27[8] = 4;
        snmpUnavailableContexts = new OID(nArray27);
        int[] nArray28 = new int[10];
        nArray28[0] = 1;
        nArray28[1] = 3;
        nArray28[2] = 6;
        nArray28[3] = 1;
        nArray28[4] = 6;
        nArray28[5] = 3;
        nArray28[6] = 12;
        nArray28[7] = 1;
        nArray28[8] = 5;
        snmpUnknownContexts = new OID(nArray28);
        int[] nArray29 = new int[10];
        nArray29[0] = 1;
        nArray29[1] = 3;
        nArray29[2] = 6;
        nArray29[3] = 1;
        nArray29[4] = 6;
        nArray29[5] = 3;
        nArray29[6] = 18;
        nArray29[7] = 1;
        nArray29[8] = 3;
        snmpTrapAddress = new OID(nArray29);
        int[] nArray30 = new int[10];
        nArray30[0] = 1;
        nArray30[1] = 3;
        nArray30[2] = 6;
        nArray30[3] = 1;
        nArray30[4] = 6;
        nArray30[5] = 3;
        nArray30[6] = 18;
        nArray30[7] = 1;
        nArray30[8] = 4;
        snmpTrapCommunity = new OID(nArray30);
        zeroDotZero = new OID(new int[2]);
        int[] nArray31 = new int[11];
        nArray31[0] = 1;
        nArray31[1] = 3;
        nArray31[2] = 6;
        nArray31[3] = 1;
        nArray31[4] = 2;
        nArray31[5] = 1;
        nArray31[6] = 190;
        nArray31[7] = 1;
        nArray31[8] = 1;
        nArray31[9] = 1;
        snmpTsmInvalidCaches = new OID(nArray31);
        int[] nArray32 = new int[11];
        nArray32[0] = 1;
        nArray32[1] = 3;
        nArray32[2] = 6;
        nArray32[3] = 1;
        nArray32[4] = 2;
        nArray32[5] = 1;
        nArray32[6] = 190;
        nArray32[7] = 1;
        nArray32[8] = 1;
        nArray32[9] = 2;
        snmpTsmInadequateSecurityLevels = new OID(nArray32);
        int[] nArray33 = new int[11];
        nArray33[0] = 1;
        nArray33[1] = 3;
        nArray33[2] = 6;
        nArray33[3] = 1;
        nArray33[4] = 2;
        nArray33[5] = 1;
        nArray33[6] = 190;
        nArray33[7] = 1;
        nArray33[8] = 1;
        nArray33[9] = 3;
        snmpTsmUnknownPrefixes = new OID(nArray33);
        int[] nArray34 = new int[11];
        nArray34[0] = 1;
        nArray34[1] = 3;
        nArray34[2] = 6;
        nArray34[3] = 1;
        nArray34[4] = 2;
        nArray34[5] = 1;
        nArray34[6] = 190;
        nArray34[7] = 1;
        nArray34[8] = 1;
        nArray34[9] = 4;
        snmpTsmInvalidPrefixes = new OID(nArray34);
        int[] nArray35 = new int[11];
        nArray35[0] = 1;
        nArray35[1] = 3;
        nArray35[2] = 6;
        nArray35[3] = 1;
        nArray35[4] = 2;
        nArray35[5] = 1;
        nArray35[6] = 190;
        nArray35[7] = 1;
        nArray35[8] = 2;
        nArray35[9] = 1;
        snmpTsmConfigurationUsePrefix = new OID(nArray35);
        int[] nArray36 = new int[11];
        nArray36[0] = 1;
        nArray36[1] = 3;
        nArray36[2] = 6;
        nArray36[3] = 1;
        nArray36[4] = 2;
        nArray36[5] = 1;
        nArray36[6] = 198;
        nArray36[7] = 2;
        nArray36[8] = 1;
        nArray36[9] = 1;
        snmpTlstmSessionOpens = new OID(nArray36);
        int[] nArray37 = new int[11];
        nArray37[0] = 1;
        nArray37[1] = 3;
        nArray37[2] = 6;
        nArray37[3] = 1;
        nArray37[4] = 2;
        nArray37[5] = 1;
        nArray37[6] = 198;
        nArray37[7] = 2;
        nArray37[8] = 1;
        nArray37[9] = 2;
        snmpTlstmSessionClientCloses = new OID(nArray37);
        int[] nArray38 = new int[11];
        nArray38[0] = 1;
        nArray38[1] = 3;
        nArray38[2] = 6;
        nArray38[3] = 1;
        nArray38[4] = 2;
        nArray38[5] = 1;
        nArray38[6] = 198;
        nArray38[7] = 2;
        nArray38[8] = 1;
        nArray38[9] = 3;
        snmpTlstmSessionOpenErrors = new OID(nArray38);
        int[] nArray39 = new int[11];
        nArray39[0] = 1;
        nArray39[1] = 3;
        nArray39[2] = 6;
        nArray39[3] = 1;
        nArray39[4] = 2;
        nArray39[5] = 1;
        nArray39[6] = 198;
        nArray39[7] = 2;
        nArray39[8] = 1;
        nArray39[9] = 4;
        snmpTlstmSessionAccepts = new OID(nArray39);
        int[] nArray40 = new int[11];
        nArray40[0] = 1;
        nArray40[1] = 3;
        nArray40[2] = 6;
        nArray40[3] = 1;
        nArray40[4] = 2;
        nArray40[5] = 1;
        nArray40[6] = 198;
        nArray40[7] = 2;
        nArray40[8] = 1;
        nArray40[9] = 5;
        snmpTlstmSessionServerCloses = new OID(nArray40);
        int[] nArray41 = new int[11];
        nArray41[0] = 1;
        nArray41[1] = 3;
        nArray41[2] = 6;
        nArray41[3] = 1;
        nArray41[4] = 2;
        nArray41[5] = 1;
        nArray41[6] = 198;
        nArray41[7] = 2;
        nArray41[8] = 1;
        nArray41[9] = 6;
        snmpTlstmSessionNoSessions = new OID(nArray41);
        int[] nArray42 = new int[11];
        nArray42[0] = 1;
        nArray42[1] = 3;
        nArray42[2] = 6;
        nArray42[3] = 1;
        nArray42[4] = 2;
        nArray42[5] = 1;
        nArray42[6] = 198;
        nArray42[7] = 2;
        nArray42[8] = 1;
        nArray42[9] = 7;
        snmpTlstmSessionInvalidClientCertificates = new OID(nArray42);
        int[] nArray43 = new int[11];
        nArray43[0] = 1;
        nArray43[1] = 3;
        nArray43[2] = 6;
        nArray43[3] = 1;
        nArray43[4] = 2;
        nArray43[5] = 1;
        nArray43[6] = 198;
        nArray43[7] = 2;
        nArray43[8] = 1;
        nArray43[9] = 8;
        snmpTlstmSessionUnknownServerCertificate = new OID(nArray43);
        int[] nArray44 = new int[11];
        nArray44[0] = 1;
        nArray44[1] = 3;
        nArray44[2] = 6;
        nArray44[3] = 1;
        nArray44[4] = 2;
        nArray44[5] = 1;
        nArray44[6] = 198;
        nArray44[7] = 2;
        nArray44[8] = 1;
        nArray44[9] = 9;
        snmpTlstmSessionInvalidServerCertificates = new OID(nArray44);
        int[] nArray45 = new int[11];
        nArray45[0] = 1;
        nArray45[1] = 3;
        nArray45[2] = 6;
        nArray45[3] = 1;
        nArray45[4] = 2;
        nArray45[5] = 1;
        nArray45[6] = 198;
        nArray45[7] = 2;
        nArray45[8] = 1;
        nArray45[9] = 10;
        snmpTlstmSessionInvalidCaches = new OID(nArray45);
        int[] nArray46 = new int[11];
        nArray46[0] = 1;
        nArray46[1] = 3;
        nArray46[2] = 6;
        nArray46[3] = 1;
        nArray46[4] = 2;
        nArray46[5] = 1;
        nArray46[6] = 189;
        nArray46[7] = 1;
        nArray46[8] = 1;
        nArray46[9] = 1;
        snmpSshtmSessionOpens = new OID(nArray46);
        int[] nArray47 = new int[11];
        nArray47[0] = 1;
        nArray47[1] = 3;
        nArray47[2] = 6;
        nArray47[3] = 1;
        nArray47[4] = 2;
        nArray47[5] = 1;
        nArray47[6] = 189;
        nArray47[7] = 1;
        nArray47[8] = 1;
        nArray47[9] = 2;
        snmpSshtmSessionCloses = new OID(nArray47);
        int[] nArray48 = new int[11];
        nArray48[0] = 1;
        nArray48[1] = 3;
        nArray48[2] = 6;
        nArray48[3] = 1;
        nArray48[4] = 2;
        nArray48[5] = 1;
        nArray48[6] = 189;
        nArray48[7] = 1;
        nArray48[8] = 1;
        nArray48[9] = 3;
        snmpSshtmSessionOpenErrors = new OID(nArray48);
        int[] nArray49 = new int[11];
        nArray49[0] = 1;
        nArray49[1] = 3;
        nArray49[2] = 6;
        nArray49[3] = 1;
        nArray49[4] = 2;
        nArray49[5] = 1;
        nArray49[6] = 189;
        nArray49[7] = 1;
        nArray49[8] = 1;
        nArray49[9] = 4;
        snmpSshtmSessionUserAuthFailures = new OID(nArray49);
        int[] nArray50 = new int[11];
        nArray50[0] = 1;
        nArray50[1] = 3;
        nArray50[2] = 6;
        nArray50[3] = 1;
        nArray50[4] = 2;
        nArray50[5] = 1;
        nArray50[6] = 189;
        nArray50[7] = 1;
        nArray50[8] = 1;
        nArray50[9] = 5;
        snmpSshtmSessionNoChannels = new OID(nArray50);
        int[] nArray51 = new int[11];
        nArray51[0] = 1;
        nArray51[1] = 3;
        nArray51[2] = 6;
        nArray51[3] = 1;
        nArray51[4] = 2;
        nArray51[5] = 1;
        nArray51[6] = 189;
        nArray51[7] = 1;
        nArray51[8] = 1;
        nArray51[9] = 6;
        snmpSshtmSessionNoSubsystems = new OID(nArray51);
        int[] nArray52 = new int[11];
        nArray52[0] = 1;
        nArray52[1] = 3;
        nArray52[2] = 6;
        nArray52[3] = 1;
        nArray52[4] = 2;
        nArray52[5] = 1;
        nArray52[6] = 189;
        nArray52[7] = 1;
        nArray52[8] = 1;
        nArray52[9] = 7;
        snmpSshtmSessionNoSessions = new OID(nArray52);
        int[] nArray53 = new int[11];
        nArray53[0] = 1;
        nArray53[1] = 3;
        nArray53[2] = 6;
        nArray53[3] = 1;
        nArray53[4] = 2;
        nArray53[5] = 1;
        nArray53[6] = 189;
        nArray53[7] = 1;
        nArray53[8] = 1;
        nArray53[9] = 8;
        snmpSshtmSessionInvalidCaches = new OID(nArray53);
        int[] nArray54 = new int[15];
        nArray54[0] = 1;
        nArray54[1] = 3;
        nArray54[2] = 6;
        nArray54[3] = 1;
        nArray54[4] = 4;
        nArray54[5] = 1;
        nArray54[6] = 4976;
        nArray54[7] = 10;
        nArray54[8] = 1;
        nArray54[9] = 1;
        nArray54[10] = 4;
        nArray54[11] = 1;
        nArray54[12] = 1;
        nArray54[13] = 1;
        snmp4jStatsRequestTimeouts = new OID(nArray54);
        int[] nArray55 = new int[15];
        nArray55[0] = 1;
        nArray55[1] = 3;
        nArray55[2] = 6;
        nArray55[3] = 1;
        nArray55[4] = 4;
        nArray55[5] = 1;
        nArray55[6] = 4976;
        nArray55[7] = 10;
        nArray55[8] = 1;
        nArray55[9] = 1;
        nArray55[10] = 4;
        nArray55[11] = 1;
        nArray55[12] = 1;
        nArray55[13] = 2;
        snmp4jStatsRequestRetries = new OID(nArray55);
        int[] nArray56 = new int[15];
        nArray56[0] = 1;
        nArray56[1] = 3;
        nArray56[2] = 6;
        nArray56[3] = 1;
        nArray56[4] = 4;
        nArray56[5] = 1;
        nArray56[6] = 4976;
        nArray56[7] = 10;
        nArray56[8] = 1;
        nArray56[9] = 1;
        nArray56[10] = 4;
        nArray56[11] = 1;
        nArray56[12] = 1;
        nArray56[13] = 3;
        snmp4jStatsRequestWaitTime = new OID(nArray56);
        int[] nArray57 = new int[15];
        nArray57[0] = 1;
        nArray57[1] = 3;
        nArray57[2] = 6;
        nArray57[3] = 1;
        nArray57[4] = 4;
        nArray57[5] = 1;
        nArray57[6] = 4976;
        nArray57[7] = 10;
        nArray57[8] = 1;
        nArray57[9] = 1;
        nArray57[10] = 4;
        nArray57[11] = 1;
        nArray57[12] = 1;
        nArray57[13] = 4;
        snmp4jStatsRequestRuntime = new OID(nArray57);
        snmp4jStatsReqTableTimeouts = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 4, 1, 1, 10, 3, 1, 4});
        snmp4jStatsReqTableRetries = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 4, 1, 1, 10, 3, 1, 5});
        snmp4jStatsReqTableWaitTime = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 4, 1, 1, 10, 3, 1, 6});
        snmp4jStatsReqTableRuntime = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 10, 1, 1, 4, 1, 1, 10, 3, 1, 7});
        int[] nArray58 = new int[15];
        nArray58[0] = 1;
        nArray58[1] = 3;
        nArray58[2] = 6;
        nArray58[3] = 1;
        nArray58[4] = 4;
        nArray58[5] = 1;
        nArray58[6] = 4976;
        nArray58[7] = 10;
        nArray58[8] = 1;
        nArray58[9] = 1;
        nArray58[10] = 4;
        nArray58[11] = 1;
        nArray58[12] = 2;
        nArray58[13] = 1;
        snmp4jStatsResponseTimeouts = new OID(nArray58);
        int[] nArray59 = new int[15];
        nArray59[0] = 1;
        nArray59[1] = 3;
        nArray59[2] = 6;
        nArray59[3] = 1;
        nArray59[4] = 4;
        nArray59[5] = 1;
        nArray59[6] = 4976;
        nArray59[7] = 10;
        nArray59[8] = 1;
        nArray59[9] = 1;
        nArray59[10] = 4;
        nArray59[11] = 1;
        nArray59[12] = 2;
        nArray59[13] = 2;
        snmp4jStatsResponseIgnoredRetries = new OID(nArray59);
        int[] nArray60 = new int[15];
        nArray60[0] = 1;
        nArray60[1] = 3;
        nArray60[2] = 6;
        nArray60[3] = 1;
        nArray60[4] = 4;
        nArray60[5] = 1;
        nArray60[6] = 4976;
        nArray60[7] = 10;
        nArray60[8] = 1;
        nArray60[9] = 1;
        nArray60[10] = 4;
        nArray60[11] = 1;
        nArray60[12] = 2;
        nArray60[13] = 3;
        snmp4jStatsResponseProcessTime = new OID(nArray60);
        int[] nArray61 = new int[11];
        nArray61[0] = 1;
        nArray61[1] = 3;
        nArray61[2] = 6;
        nArray61[3] = 1;
        nArray61[4] = 6;
        nArray61[5] = 3;
        nArray61[6] = 1;
        nArray61[7] = 1;
        nArray61[8] = 6;
        nArray61[9] = 1;
        snmpSetSerialNo = new OID(nArray61);
        SNMP_TP_ERROR_MESSAGES = new String[]{"Request timed out"};
        SNMP_ERROR_MESSAGES = new String[]{"Success", "PDU encoding too big", "No such name", "Bad value", "Variable is read-only", "General variable binding error", "No access", "Wrong type", "Variable binding data with incorrect length", "Variable binding data with wrong encoding", "Wrong value", "Unable to create object", "Inconsistent value", "Resource unavailable", "Commit failed", "Undo failed", "Authorization error", "Not writable", "Inconsistent naming used"};
        MD_ERROR_MESSAGES = new String[][]{{"1701", "Message Dispatcher error"}, {"1702", "Unsupported message processing model"}, {"1703", "Unsupported address class"}, {"1704", "Unsupported address class"}};
        MP_ERROR_MESSAGES = new String[][]{{"-1400", "MP error"}, {"-1402", "Unsupported security model"}, {"-1403", "Message not in time window"}, {"-1404", "Doubled message"}, {"-1405", "Invalid message"}, {"-1406", "Invalid engine ID"}, {"-1407", "MP not initialized"}, {"-1408", "MP parse error"}, {"-1409", "Unknown message ID"}, {"-1410", "MP match error"}, {"-1411", "MP community error"}, {"-1412", "Wrong user name"}, {"-1413", "MP build error"}, {"-1414", "USM error"}, {"-1415", "Unknown PDU handles"}, {"-1416", "Unavailable context"}, {"-1417", "Unknown context"}, {"-1418", "Report sent"}};
        USM_ERROR_MESSAGES = new String[][]{{"0", "USM OK"}, {"1401", "USM error"}, {"1403", "Unsupported security level"}, {"1404", "Unknown security name"}, {"1405", "Encryption error"}, {"1406", "Decryption error"}, {"1407", "Authentication error"}, {"1408", "Authentication failure"}, {"1409", "USM parse error"}, {"1410", "Unknown engine ID"}, {"1411", "Not in time window"}, {"1412", "Unsupported authentication protocol"}, {"1413", "Unsupported privacy protocol"}, {"1414", "Address error"}, {"1415", "Engine ID too long"}, {"1416", "Security name too long"}};
    }

    public static String mpErrorMessage(int status) {
        String s = "" + status;
        String[][] stringArray = MP_ERROR_MESSAGES;
        int n = MP_ERROR_MESSAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] MP_ERROR_MESSAGE = stringArray[n2];
            if (s.equals(MP_ERROR_MESSAGE[0])) {
                return MP_ERROR_MESSAGE[1];
            }
            ++n2;
        }
        s = SnmpConstants.errorMessage(status, USM_ERROR_MESSAGES);
        if (s == null) {
            s = SnmpConstants.errorMessage(status, MD_ERROR_MESSAGES);
            return s == null ? "" + status : s;
        }
        return s;
    }

    public static String usmErrorMessage(int status) {
        String s = SnmpConstants.errorMessage(status, USM_ERROR_MESSAGES);
        return s == null ? "" + status : s;
    }

    private static String errorMessage(int status, String[][] errorMessages) {
        String s = "" + status;
        String[][] stringArray = errorMessages;
        int n = errorMessages.length;
        int n2 = 0;
        while (n2 < n) {
            String[] errorMessage = stringArray[n2];
            if (s.equals(errorMessage[0])) {
                return errorMessage[1];
            }
            ++n2;
        }
        return null;
    }

    public static int getGenericTrapID(OID oid) {
        if (oid == null || oid.size() != snmpTraps.size() + 1) {
            return -1;
        }
        if (oid.leftMostCompare(snmpTraps.size(), snmpTraps) == 0) {
            return oid.get(oid.size() - 1) - 1;
        }
        return -1;
    }

    public static OID getTrapOID(OID enterprise, int genericID, int specificID) {
        OID oid;
        if (genericID != 6) {
            oid = new OID(snmpTraps);
            oid.append(genericID + 1);
        } else {
            oid = new OID(enterprise);
            oid.append(0);
            oid.append(specificID);
        }
        return oid;
    }
}

