/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.smi.OctetString;

public abstract class AuthGeneric
implements AuthenticationProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(AuthGeneric.class);
    private static int HMAC_BLOCK_SIZE = 64;
    private static int DEFAULT_AUTHENTICATION_CODE_LENGTH = 12;
    private final int hmacBlockSize = HMAC_BLOCK_SIZE;
    private int authenticationCodeLength = DEFAULT_AUTHENTICATION_CODE_LENGTH;
    private final int digestLength;
    private final String protoName;

    public AuthGeneric(String protoName, int digestLength) {
        this.protoName = protoName;
        this.digestLength = digestLength;
    }

    public AuthGeneric(String protoName, int digestLength, int authenticationCodeLength) {
        this(protoName, digestLength);
        this.authenticationCodeLength = authenticationCodeLength;
    }

    @Override
    public int getDigestLength() {
        return this.digestLength;
    }

    @Override
    public int getAuthenticationCodeLength() {
        return this.authenticationCodeLength;
    }

    protected MessageDigest getDigestObject() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.protoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(String.valueOf(this.protoName) + " not supported in this VM.");
        }
        return md;
    }

    @Override
    public boolean isSupported() {
        try {
            MessageDigest.getInstance(this.protoName);
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    @Override
    public boolean authenticate(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        MessageDigest md = this.getDigestObject();
        byte[] authKey = authenticationKey;
        byte[] k_ipad = new byte[this.hmacBlockSize];
        byte[] k_opad = new byte[this.hmacBlockSize];
        int i = 0;
        while (i < this.authenticationCodeLength) {
            digest.set(i, (byte)0);
            ++i;
        }
        if (authKey.length > this.hmacBlockSize) {
            authKey = md.digest(authenticationKey);
        }
        i = 0;
        while (i < authKey.length) {
            k_ipad[i] = (byte)(authKey[i] ^ 0x36);
            k_opad[i] = (byte)(authKey[i] ^ 0x5C);
            ++i;
        }
        i = authKey.length;
        while (i < this.hmacBlockSize) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
            ++i;
        }
        md.update(k_ipad);
        md.update(message, messageOffset, messageLength);
        byte[] newDigest = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(newDigest);
        newDigest = md.digest();
        i = 0;
        while (i < this.authenticationCodeLength) {
            digest.set(i, newDigest[i]);
            ++i;
        }
        return true;
    }

    @Override
    public boolean isAuthentic(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        ByteArrayWindow origDigest = new ByteArrayWindow(new byte[this.authenticationCodeLength], 0, this.authenticationCodeLength);
        System.arraycopy(digest.getValue(), digest.getOffset(), origDigest.getValue(), 0, this.authenticationCodeLength);
        if (!this.authenticate(authenticationKey, message, messageOffset, messageLength, digest)) {
            return false;
        }
        return digest.equals(origDigest, this.authenticationCodeLength);
    }

    @Override
    public byte[] changeDelta(byte[] oldKey, byte[] newKey, byte[] random) {
        MessageDigest hash = this.getDigestObject();
        int digestLength = hash.getDigestLength();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "oldKey: " + new OctetString(oldKey).toHexString())));
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "newKey: " + new OctetString(newKey).toHexString())));
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "random: " + new OctetString(random).toHexString())));
        }
        int iterations = (oldKey.length - 1) / hash.getDigestLength();
        OctetString tmp = new OctetString(oldKey);
        OctetString delta = new OctetString();
        int k = 0;
        while (k < iterations) {
            tmp.append(random);
            hash.update(tmp.getValue());
            tmp.setValue(hash.digest());
            delta.append(new byte[digestLength]);
            int kk = 0;
            while (kk < digestLength) {
                delta.set(k * digestLength + kk, (byte)(tmp.get(kk) ^ newKey[k * digestLength + kk]));
                ++kk;
            }
            ++k;
        }
        tmp.append(random);
        hash.update(tmp.getValue());
        tmp = new OctetString(hash.digest(), 0, oldKey.length - delta.length());
        int j = 0;
        while (j < tmp.length()) {
            tmp.set(j, (byte)(tmp.get(j) ^ newKey[iterations * digestLength + j]));
            ++j;
        }
        byte[] keyChange = new byte[random.length + delta.length() + tmp.length()];
        System.arraycopy(random, 0, keyChange, 0, random.length);
        System.arraycopy(delta.getValue(), 0, keyChange, random.length, delta.length());
        System.arraycopy(tmp.getValue(), 0, keyChange, random.length + delta.length(), tmp.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "keyChange:" + new OctetString(keyChange).toHexString())));
        }
        return keyChange;
    }

    @Override
    public byte[] passwordToKey(OctetString passwordString, byte[] engineID) {
        MessageDigest md = this.getDigestObject();
        byte[] buf = new byte[this.hmacBlockSize];
        int password_index = 0;
        int count = 0;
        byte[] password = passwordString.getValue();
        while (count < 0x100000) {
            int i = 0;
            while (i < this.hmacBlockSize) {
                buf[i] = password[password_index++ % password.length];
                ++i;
            }
            md.update(buf);
            count += this.hmacBlockSize;
        }
        byte[] digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "First digest: " + new OctetString(digest).toHexString())));
        }
        md.reset();
        md.update(digest);
        md.update(engineID);
        md.update(digest);
        digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)(String.valueOf(this.protoName) + "localized key: " + new OctetString(digest).toHexString())));
        }
        return digest;
    }

    @Override
    public byte[] hash(byte[] data) {
        MessageDigest md = this.getDigestObject();
        md.update(data);
        return md.digest();
    }

    @Override
    public byte[] hash(byte[] data, int offset, int length) {
        MessageDigest md = this.getDigestObject();
        md.update(data, offset, length);
        return md.digest();
    }
}

