/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.CipherPool;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyGeneric;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class PrivDES
extends PrivacyGeneric {
    private static final long serialVersionUID = 2526070176429255416L;
    public static final OID ID = new OID("1.3.6.1.6.3.10.1.2.2");
    private static final String PROTOCOL_ID = "DES/CBC/NoPadding";
    private static final String PROTOCOL_CLASS = "DES";
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final int INIT_VECTOR_LENGTH = 8;
    private static final int INPUT_KEY_LENGTH = 16;
    private static final int KEY_LENGTH = 8;
    protected Salt salt;
    private static final LogAdapter logger = LogFactory.getLogger(PrivDES.class);

    public PrivDES() {
        this.initVectorLength = 8;
        this.protocolId = PROTOCOL_ID;
        this.protocolClass = PROTOCOL_CLASS;
        this.keyBytes = 8;
        this.salt = Salt.getInstance();
        this.cipherPool = new CipherPool();
    }

    @Override
    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] encryptedData;
        block9: {
            int mySalt = (int)this.salt.getNext();
            if (encryptionKey.length < 16) {
                logger.error((Serializable)((Object)("Wrong Key length: need at least 16 bytes, is " + encryptionKey.length + " bytes.")));
                throw new IllegalArgumentException("encryptionKey has illegal length " + encryptionKey.length + " (should be at least 16).");
            }
            if (decryptParams.array == null || decryptParams.length < 8) {
                decryptParams.array = new byte[8];
            }
            decryptParams.length = 8;
            decryptParams.offset = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Preparing decrypt_params."));
            }
            int i = 0;
            while (i < 4) {
                decryptParams.array[3 - i] = (byte)(0xFFL & engineBoots >> 8 * i);
                decryptParams.array[7 - i] = (byte)(0xFF & mySalt >> 8 * i);
                ++i;
            }
            byte[] iv = new byte[8];
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Preparing iv for encryption."));
            }
            int i2 = 0;
            while (i2 < 8) {
                iv[i2] = (byte)(encryptionKey[8 + i2] ^ decryptParams.array[i2]);
                ++i2;
            }
            encryptedData = null;
            try {
                Cipher alg = this.doInit(encryptionKey, iv);
                encryptedData = this.doFinalWithPadding(unencryptedData, offset, length, alg);
                this.cipherPool.offerCipher(alg);
            }
            catch (Exception e) {
                logger.error(e);
                if (!logger.isDebugEnabled()) break block9;
                e.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)"Encryption finished."));
        }
        return encryptedData;
    }

    @Override
    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        if (length % 8 != 0 || length < 8 || decryptParams.length != 8) {
            throw new IllegalArgumentException("Length (" + length + ") is not multiple of 8 or decrypt params has not length 8 (" + decryptParams.length + ").");
        }
        if (decryptionKey.length < 16) {
            logger.error((Serializable)((Object)("Wrong Key length: need at least 16 bytes, is " + decryptionKey.length + " bytes.")));
            throw new IllegalArgumentException("decryptionKey has illegal length " + decryptionKey.length + " (should be at least 16).");
        }
        byte[] iv = new byte[8];
        int i = 0;
        while (i < 8) {
            iv[i] = (byte)(decryptionKey[8 + i] ^ decryptParams.array[i]);
            ++i;
        }
        byte[] decryptedData = this.doDecrypt(cryptedData, offset, length, decryptionKey, iv);
        return decryptedData;
    }

    @Override
    public OID getID() {
        return (OID)ID.clone();
    }

    @Override
    public boolean isSupported() {
        try {
            Cipher alg = this.cipherPool.reuseCipher();
            if (alg == null) {
                Cipher.getInstance("DESede/CBC/NoPadding");
            }
            return true;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    @Override
    public int getEncryptedLength(int scopedPDULength) {
        if (scopedPDULength % 8 == 0) {
            return scopedPDULength;
        }
        return 8 * (scopedPDULength / 8 + 1);
    }

    @Override
    public int getMinKeyLength() {
        return 16;
    }

    @Override
    public int getDecryptParamsLength() {
        return 8;
    }

    @Override
    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    @Override
    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        return shortKey;
    }
}

