/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.CipherPool;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;

public abstract class PrivacyGeneric
implements PrivacyProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(PrivacyGeneric.class);
    protected String protocolId;
    protected String protocolClass;
    protected int keyBytes;
    protected Salt salt;
    protected CipherPool cipherPool;
    protected int initVectorLength;

    protected Cipher doInit(byte[] encryptionKey, byte[] initVect) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher alg = this.cipherPool.reuseCipher();
        if (alg == null) {
            alg = Cipher.getInstance(this.protocolId);
        }
        SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, this.keyBytes, this.protocolClass);
        IvParameterSpec ivSpec = new IvParameterSpec(initVect);
        alg.init(1, (Key)key, ivSpec);
        return alg;
    }

    protected byte[] doFinal(byte[] unencryptedData, int offset, int length, Cipher alg) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        return alg.doFinal(unencryptedData, offset, length);
    }

    protected byte[] doFinalWithPadding(byte[] unencryptedData, int offset, int length, Cipher alg) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        byte[] encryptedData;
        if (length % 8 == 0) {
            encryptedData = alg.doFinal(unencryptedData, offset, length);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Using padding."));
            }
            encryptedData = new byte[8 * (length / 8 + 1)];
            byte[] tmp = new byte[8];
            int encryptedLength = alg.update(unencryptedData, offset, length, encryptedData);
            alg.doFinal(tmp, 0, 8 - length % 8, encryptedData, encryptedLength);
        }
        return encryptedData;
    }

    protected byte[] doDecrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, byte[] iv) {
        byte[] decryptedData;
        block3: {
            decryptedData = null;
            try {
                Cipher alg = this.cipherPool.reuseCipher();
                if (alg == null) {
                    alg = Cipher.getInstance(this.protocolId);
                }
                SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.keyBytes, this.protocolClass);
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                alg.init(2, (Key)key, ivSpec);
                decryptedData = alg.doFinal(cryptedData, offset, length);
                this.cipherPool.offerCipher(alg);
            }
            catch (Exception e) {
                logger.error(e);
                if (!logger.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return decryptedData;
    }

    @Override
    public boolean isSupported() {
        try {
            Cipher alg = this.cipherPool.reuseCipher();
            if (alg == null) {
                alg = Cipher.getInstance(this.protocolId);
            }
            byte[] initVect = new byte[this.initVectorLength];
            byte[] encryptionKey = new byte[this.keyBytes];
            SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, this.keyBytes, this.protocolClass);
            IvParameterSpec ivSpec = new IvParameterSpec(initVect);
            alg.init(1, (Key)key, ivSpec);
            return true;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)(String.valueOf(this.protocolClass) + " privacy not available without padding")));
            }
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)(String.valueOf(this.protocolClass) + " privacy not available")));
            }
            return false;
        }
        catch (InvalidAlgorithmParameterException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)(String.valueOf(this.protocolClass) + " privacy not available due to invalid parameter: " + e.getMessage())));
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)(String.valueOf(this.protocolClass) + " privacy with key length " + this.keyBytes + " not supported")));
            }
            return false;
        }
    }
}

