/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.UnsignedInteger32;

public class TimeTicks
extends UnsignedInteger32 {
    private static final long serialVersionUID = 8663761323061572311L;
    private static final String FORMAT_PATTERN = "{0,choice,0#|1#1 day, |1<{0,number,integer} days, }{1,number,integer}:{2,number,00}:{3,number,00}.{4,number,00}";
    private static final int[] FORMAT_FACTORS = new int[]{8640000, 360000, 6000, 100, 1};

    public TimeTicks() {
    }

    public TimeTicks(TimeTicks other) {
        this.value = other.value;
    }

    public TimeTicks(long value) {
        super(value);
    }

    @Override
    public Object clone() {
        return new TimeTicks(this.value);
    }

    @Override
    public int getSyntax() {
        return 67;
    }

    @Override
    public void encodeBER(OutputStream os) throws IOException {
        BER.encodeUnsignedInteger(os, (byte)67, super.getValue());
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        long newValue = BER.decodeUnsignedInteger(inputStream, type);
        if (type.getValue() != 67) {
            throw new IOException("Wrong type encountered when decoding TimeTicks: " + type.getValue());
        }
        this.setValue(newValue);
    }

    @Override
    public String toString() {
        return this.toString(FORMAT_PATTERN);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void setValue(String value) {
        block4: {
            try {
                v = Long.parseLong(value);
                this.setValue(v);
                break block4;
            }
            catch (NumberFormatException v0) {
                v = 0L;
                num = value.split("[days :,\\.]");
                i = 0;
                var9_6 = num;
                var8_7 = num.length;
                var7_8 = 0;
                ** while (var7_8 < var8_7)
            }
lbl-1000:
            // 1 sources

            {
                n = var9_6[var7_8];
                if (n.length() > 0) {
                    f = TimeTicks.FORMAT_FACTORS[i++];
                    v += Long.parseLong(n) * f;
                }
                ++var7_8;
                continue;
            }
lbl19:
            // 1 sources

            this.setValue(v);
        }
    }

    public String toString(String pattern) {
        long tt = this.getValue();
        long days = tt / 8640000L;
        long hours = (tt %= 8640000L) / 360000L;
        long minutes = (tt %= 360000L) / 6000L;
        long seconds = (tt %= 6000L) / 100L;
        long hseconds = tt %= 100L;
        Object[] values = new Long[]{days, hours, minutes, seconds, hseconds};
        return MessageFormat.format(pattern, values);
    }

    public long toMilliseconds() {
        return this.value * 10L;
    }

    public void fromMilliseconds(long millis) {
        this.setValue(millis / 10L);
    }
}

