/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class PropertiesTlsTmSecurityCallback
implements TlsTmSecurityCallback<X509Certificate> {
    private static final LogAdapter LOGGER = LogFactory.getLogger(PropertiesTlsTmSecurityCallback.class);
    private boolean serverMode;
    private Properties properties;

    public PropertiesTlsTmSecurityCallback(boolean serverMode) {
        this(System.getProperties(), serverMode);
    }

    public PropertiesTlsTmSecurityCallback(Properties properties, boolean serverMode) {
        this.serverMode = serverMode;
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
    }

    public OctetString getSecurityName(X509Certificate[] peerCertificateChain) {
        String securityName = this.properties.getProperty("org.snmp4j.arg.securityName", null);
        if (securityName != null) {
            return new OctetString(securityName);
        }
        return null;
    }

    @Override
    public boolean isClientCertificateAccepted(X509Certificate peerEndCertificate) {
        String accepted = this.properties.getProperty("org.snmp4j.arg.tlsLocalID", "");
        if (this.serverMode) {
            accepted = this.properties.getProperty("org.snmp4j.arg.tlsPeerID", "");
        }
        return peerEndCertificate.getSubjectDN().getName().equals(accepted);
    }

    public boolean isServerCertificateAccepted(X509Certificate[] peerCertificateChain) {
        String subject;
        String acceptedPeer = this.properties.getProperty("org.snmp4j.arg.tlsPeerID", "");
        if (this.serverMode) {
            acceptedPeer = this.properties.getProperty("org.snmp4j.arg.tlsLocalID", "");
        }
        if ((subject = peerCertificateChain[0].getSubjectDN().getName()).equals(acceptedPeer)) {
            return true;
        }
        LOGGER.warn((Serializable)((Object)("Certificate subject '" + subject + "' does not match accepted peer '" + acceptedPeer + "'")));
        String acceptedCA = this.properties.getProperty("org.snmp4j.arg.tlsTrustCA", "");
        int i = 1;
        while (i < peerCertificateChain.length) {
            String ca = peerCertificateChain[i].getIssuerDN().getName();
            if (ca.equals(acceptedCA)) {
                return true;
            }
            LOGGER.warn((Serializable)((Object)("Certification authority '" + ca + "' does not match accepted CA '" + acceptedCA + "'")));
            ++i;
        }
        return false;
    }

    @Override
    public boolean isAcceptedIssuer(X509Certificate issuerCertificate) {
        String acceptedCA = this.properties.getProperty("org.snmp4j.arg.tlsTrustCA", "");
        return issuerCertificate.getIssuerDN().getName().equals(acceptedCA);
    }

    @Override
    public String getLocalCertificateAlias(Address targetAddress) {
        return this.properties.getProperty("org.snmp4j.arg.tlsLocalID");
    }
}

