/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;

public class TreeUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TreeUtils.class);
    private int maxRepetitions = 10;
    private boolean ignoreLexicographicOrder;

    public TreeUtils(Session snmpSession, PDUFactory pduFactory) {
        super(snmpSession, pduFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeEvent> getSubtree(Target target, OID rootOID) {
        InternalTreeListener listener;
        LinkedList<TreeEvent> l = new LinkedList<TreeEvent>();
        InternalTreeListener internalTreeListener = listener = new InternalTreeListener(l);
        synchronized (internalTreeListener) {
            OID[] rootOIDs = new OID[]{rootOID};
            this.walk(target, rootOIDs, null, listener);
            try {
                listener.wait();
            }
            catch (InterruptedException ex) {
                logger.warn((Serializable)((Object)("Tree retrieval interrupted: " + ex.getMessage())));
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeEvent> walk(Target target, OID[] rootOIDs) {
        InternalTreeListener listener;
        LinkedList<TreeEvent> l = new LinkedList<TreeEvent>();
        InternalTreeListener internalTreeListener = listener = new InternalTreeListener(l);
        synchronized (internalTreeListener) {
            this.walk(target, rootOIDs, null, listener);
            try {
                listener.wait();
            }
            catch (InterruptedException ex) {
                logger.warn((Serializable)((Object)("Tree retrieval interrupted: " + ex.getMessage())));
            }
        }
        return l;
    }

    public void getSubtree(Target target, OID rootOID, Object userObject, TreeListener listener) {
        this.walk(target, new OID[]{rootOID}, userObject, listener);
    }

    public void walk(Target target, OID[] rootOIDs, Object userObject, TreeListener listener) {
        PDU request = this.pduFactory.createPDU(target);
        OID[] oIDArray = rootOIDs;
        int n = rootOIDs.length;
        int n2 = 0;
        while (n2 < n) {
            OID oid = oIDArray[n2];
            request.add(new VariableBinding(oid));
            ++n2;
        }
        if (target.getVersion() == 0) {
            request.setType(-95);
        } else if (request.getType() != -95) {
            request.setType(-91);
            request.setMaxRepetitions(this.maxRepetitions);
        }
        TreeRequest treeRequest = new TreeRequest(listener, rootOIDs, target, userObject, request);
        treeRequest.send();
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setIgnoreLexicographicOrder(boolean ignoreLexicographicOrder) {
        this.ignoreLexicographicOrder = ignoreLexicographicOrder;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public boolean isIgnoreLexicographicOrder() {
        return this.ignoreLexicographicOrder;
    }

    class InternalTreeListener
    implements TreeListener {
        private List<TreeEvent> collectedEvents;
        private volatile boolean finished = false;

        public InternalTreeListener(List<TreeEvent> eventList) {
            this.collectedEvents = eventList;
        }

        @Override
        public synchronized boolean next(TreeEvent event) {
            this.collectedEvents.add(event);
            return true;
        }

        @Override
        public synchronized void finished(TreeEvent event) {
            this.collectedEvents.add(event);
            this.finished = true;
            this.notify();
        }

        public List<TreeEvent> getCollectedEvents() {
            return this.collectedEvents;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    class TreeRequest
    implements ResponseListener {
        private TreeListener listener;
        private Object userObject;
        private PDU request;
        private OID[] rootOIDs;
        private Target target;

        public TreeRequest(TreeListener listener, OID[] rootOIDs, Target target, Object userObject, PDU request) {
            this.listener = listener;
            this.userObject = userObject;
            this.request = request;
            this.rootOIDs = rootOIDs;
            this.target = target;
        }

        public void send() {
            try {
                TreeUtils.this.session.send(this.request, this.target, null, this);
            }
            catch (IOException iox) {
                this.listener.finished(new TreeEvent(this, this.userObject, iox));
            }
        }

        @Override
        public void onResponse(ResponseEvent event) {
            TreeUtils.this.session.cancel(event.getRequest(), this);
            PDU respPDU = event.getResponse();
            if (respPDU == null) {
                this.listener.finished(new TreeEvent(this, this.userObject, -1));
            } else if (respPDU.getErrorStatus() != 0) {
                if (this.target.getVersion() == 0 && respPDU.getErrorStatus() == 2) {
                    this.listener.finished(new TreeEvent(this, this.userObject, new VariableBinding[0]));
                }
                this.listener.finished(new TreeEvent(this, this.userObject, respPDU.getErrorStatus()));
            } else if (respPDU.getType() == -88) {
                this.listener.finished(new TreeEvent(this, this.userObject, respPDU));
            } else {
                ArrayList<VariableBinding> l = new ArrayList<VariableBinding>(respPDU.size());
                ArrayList<OID> lastOIDs = null;
                if (!TreeUtils.this.ignoreLexicographicOrder) {
                    lastOIDs = new ArrayList<OID>(this.request.size());
                    int i = 0;
                    while (i < this.request.size()) {
                        lastOIDs.add(this.request.get(i).getOid());
                        ++i;
                    }
                }
                boolean finished = false;
                int i = 0;
                while (!(finished && i % this.rootOIDs.length <= 0 || i >= respPDU.size())) {
                    int r = i % this.rootOIDs.length;
                    VariableBinding vb = respPDU.get(i);
                    if (vb.getOid() == null || vb.getOid().size() < this.rootOIDs[r].size() || this.rootOIDs[r].leftMostCompare(this.rootOIDs[r].size(), vb.getOid()) != 0) {
                        finished = true;
                    } else if (Null.isExceptionSyntax(vb.getVariable().getSyntax())) {
                        finished = true;
                    } else {
                        if (!TreeUtils.this.ignoreLexicographicOrder && lastOIDs != null && vb.getOid().compareTo((Variable)lastOIDs.get(r)) <= 0) {
                            this.listener.finished(new TreeEvent(this, this.userObject, -2));
                            finished = true;
                            break;
                        }
                        finished = false;
                        if (lastOIDs != null) {
                            lastOIDs.set(r, vb.getOid());
                        }
                        l.add(vb);
                    }
                    if (this.rootOIDs.length > 1 && (i + 1) % this.rootOIDs.length == 0) {
                        VariableBinding[] vbs = l.toArray(new VariableBinding[l.size()]);
                        this.listener.next(new TreeEvent(this, this.userObject, vbs));
                        l.clear();
                    }
                    ++i;
                }
                if (respPDU.size() == 0) {
                    finished = true;
                }
                VariableBinding[] vbs = l.toArray(new VariableBinding[l.size()]);
                if (finished) {
                    this.listener.finished(new TreeEvent(this, this.userObject, vbs));
                } else if (this.listener.next(new TreeEvent(this, this.userObject, vbs))) {
                    int lastRowIndex = (respPDU.size() / this.rootOIDs.length - 1) * this.rootOIDs.length;
                    this.request.clear();
                    int i2 = Math.max(0, lastRowIndex);
                    while (i2 < lastRowIndex + this.rootOIDs.length) {
                        VariableBinding next = (VariableBinding)respPDU.get(i2).clone();
                        next.setVariable(new Null());
                        this.request.add(next);
                        ++i2;
                    }
                    if (this.request.size() > 0) {
                        this.send();
                    } else {
                        this.listener.finished(new TreeEvent(this, this.userObject, new VariableBinding[0]));
                    }
                } else {
                    this.listener.finished(new TreeEvent(this, this.userObject, vbs));
                }
            }
        }
    }
}

