/*
 * Decompiled with CFR 0.152.
 */
package com.bes.utils;

import com.blixx.log.LoggerMain;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;

public class FilePathTraversalCheck {
    private static Logger logger = LoggerMain.getLogger(FilePathTraversalCheck.class);

    public static boolean isPathTraversal(Path base, Path requested) {
        if (base == null || requested == null) {
            return false;
        }
        Path baseL = null;
        try {
            baseL = base.isAbsolute() ? base.normalize() : base.toAbsolutePath().normalize();
        }
        catch (Exception e) {
            logger.warn(" >>> Invalid Base directory: {}. Check the implementation.", (Object)base);
            return false;
        }
        try {
            return !requested.toAbsolutePath().normalize().startsWith(baseL);
        }
        catch (Exception e) {
            logger.debug("Invalid request directory: {}. Check the implementation.", (Object)requested);
            return false;
        }
    }

    public static boolean isPathTraversal(Path base, String path) {
        if (path == null) {
            return false;
        }
        Path p = null;
        try {
            p = Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            logger.debug("Invalid request directory: {}. Check the implementation.", (Object)path);
            return false;
        }
        return FilePathTraversalCheck.isPathTraversal(base, p);
    }

    public static boolean isPathTraversal(Path base, File path) {
        if (path == null) {
            return false;
        }
        return FilePathTraversalCheck.isPathTraversal(base, path.toPath());
    }

    public static boolean isFileNameTraversal(String filename) {
        if (filename != null) {
            Path testBase = Paths.get(".", new String[0]);
            Path file = Paths.get(".", filename);
            return FilePathTraversalCheck.isPathTraversal(testBase, file);
        }
        return false;
    }
}

