/*
 * Decompiled with CFR 0.152.
 */
package com.bes.utils;

import com.blixx.shared.AbstractCondition;
import com.blixx.shared.AbstractConditions;
import com.blixx.shared.Conditions;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.UUID;

public class GenerateUUID {
    public static String m_version = "1.0";

    public static void main(String[] parameters) {
        String setVersion = null;
        String setMPIName = null;
        String directory = ".";
        if (parameters != null && parameters.length > 0) {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < parameters.length; ++i) {
                sb.append(parameters[i]);
                if (i >= parameters.length - 1) continue;
                sb.append(" ");
            }
            parameters = sb.toString().split("\\s+");
            try {
                for (i = 0; i < parameters.length; ++i) {
                    if (parameters[i].trim().equalsIgnoreCase("-d")) {
                        directory = parameters[++i];
                        continue;
                    }
                    if (parameters[i].trim().equalsIgnoreCase("-setver")) {
                        setVersion = parameters[++i];
                        try {
                            PolicyFactory.getVersionAsInt(setVersion);
                        }
                        catch (Throwable e) {
                            System.err.println("policy version has invalid format: " + setVersion);
                            System.err.println("Expected <major>.<minor> in ranges: [1 ... 99].[0 ... 99] i.e. 1.0, 2.99, 3.5, 4.25, etc ...");
                            System.exit(1);
                        }
                        continue;
                    }
                    if (!parameters[i].trim().equalsIgnoreCase("-setmpi")) continue;
                    setMPIName = parameters[++i];
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            GenerateUUID.usage();
            System.exit(0);
        }
        File dir = new File(directory);
        if (!dir.exists()) {
            System.err.println("Directory not found: " + directory);
            System.exit(0);
        }
        System.out.println("This utility will re-generate UUIDs of all policy components.");
        System.out.println("Selected directory: " + dir.getAbsolutePath());
        System.out.println("Please make sure, that you have a backup of files.");
        int yes = 32;
        while (121 != yes && 89 != yes) {
            System.out.println("Please press [Y] if you want to do the operation or (CTRL-C) for exit ...");
            try {
                yes = System.in.read();
            }
            catch (IOException e) {}
        }
        File[] list = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".mon.xml") || name.toLowerCase().endsWith(".msg.xml");
            }
        });
        if (list == null || list.length == 0) {
            System.err.println("no policies found in directory: " + dir.getAbsolutePath());
            System.exit(0);
        } else {
            for (File f : list) {
                AbstractConditions cnds;
                PolicyFactory pf = new PolicyFactory();
                if (f.getName().endsWith(".mon.xml")) {
                    System.out.println("processing policy file: " + f.getName());
                    try {
                        Policy p = pf.initPolicy(f);
                        if (setVersion != null) {
                            p.setVersion(setVersion);
                        }
                        if (setMPIName != null) {
                            p.setSpiName(setMPIName);
                        }
                        cnds = p.getConditions();
                        ((Conditions)cnds).uuid = UUID.randomUUID();
                        for (AbstractCondition cond : cnds.getConditionList()) {
                            cond.setConditionId(UUID.randomUUID().toString());
                            cond.setHelptextId(UUID.randomUUID().toString());
                        }
                        try {
                            pf.storePolicy(directory, p);
                        }
                        catch (Throwable e) {
                            System.err.println("Error saving policy : " + p.getName());
                            e.printStackTrace();
                        }
                    }
                    catch (PolicyParsingException e) {
                        System.err.println("Error reading policy file: " + f.getName());
                        e.printStackTrace();
                    }
                    continue;
                }
                System.out.println("processing policy file: " + f.getName());
                try {
                    MsgPolicy mp = pf.initMsgPolicy(f);
                    if (setVersion != null) {
                        mp.setVersion(setVersion);
                    }
                    if (setMPIName != null) {
                        mp.setSpiName(setMPIName);
                    }
                    cnds = mp.getConditions();
                    ((MsgConditions)cnds).uuid = UUID.randomUUID();
                    for (AbstractCondition cond : cnds.getConditionList()) {
                        cond.setConditionId(UUID.randomUUID().toString());
                        cond.setHelptextId(UUID.randomUUID().toString());
                    }
                    try {
                        pf.storePolicy(directory, mp);
                    }
                    catch (Throwable e) {
                        System.err.println("Error saving policy : " + mp.getName());
                        e.printStackTrace();
                    }
                }
                catch (PolicyParsingException e) {
                    System.err.println("Error reading policy file: " + f.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    public static void usage() {
        System.out.print("com.bes.utils.GenerateUUID");
        System.out.println(" v " + m_version);
        System.out.println("Usage: ");
        System.out.println("java -cp nnn.jar com.bes.utils.GenerateUUID <parameters>");
        System.out.println("parameters:");
        System.out.println("\t-d <dir>\tsource directory with policy files");
        System.out.println("\t-setver <ver>\tforce to set version. (i.e. 1.0, 2.5, etc)");
        System.out.println("\t-setmpi <mpiName>\tforce to set Plugin Name.");
    }
}

