/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc.in;

import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ScGetGTO
extends ServerClient {
    public static boolean isSupport = true;

    public ScGetGTO(IServerAuth auth) {
        super(auth);
    }

    @Override
    public GroupTreeObject getResultObject() {
        return (GroupTreeObject)this.m_result;
    }

    @Override
    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        this.m_result = this.readGTO(is);
    }

    private GroupTreeObject readGTO(SDataInputStream is) throws IOException {
        int i;
        String name = is.readUTF();
        String type = is.readUTF();
        String oid = null;
        String valueStr = "";
        String link = null;
        String icon = null;
        int children = 0;
        GroupTreeObject result = null;
        if (is.readBoolean()) {
            if (is.readBoolean()) {
                oid = is.readUTF();
            }
            if (is.readBoolean()) {
                valueStr = is.readUTF();
            }
        }
        LinkedHashMap<String, String> attributes = null;
        int size = is.readInt();
        if (size > 0) {
            attributes = new LinkedHashMap<String, String>();
            for (i = 0; i < size; ++i) {
                String key = is.readUTF();
                String value = is.readUTF();
                attributes.put(key, value);
            }
        }
        if ((children = is.readInt()) == -1) {
            if (is.readBoolean()) {
                link = is.readUTF();
            }
            if (is.readBoolean()) {
                icon = is.readUTF();
            }
            result = new GroupTreeObjectLast(new TreeObject(name, type, valueStr), link, icon);
        } else {
            result = children == -2 ? new GroupTreeObjectUnsubmitted(new TreeObject(name, type, valueStr), link, icon) : new GroupTreeObject(new TreeObject(name, type, valueStr));
        }
        result.getTreeObject().setOID(oid);
        if (attributes != null) {
            for (Map.Entry en : attributes.entrySet()) {
                result.setAttribute((String)en.getKey(), (String)en.getValue());
            }
        }
        if (children > 0) {
            for (i = 0; i < children; ++i) {
                result.addElement(this.readGTO(is));
            }
        }
        return result;
    }

    public void runCommandServer(SDataInputStream is, SDataOutputStream os, GroupTreeObject root) throws IOException {
        GroupTreeObject gto = root;
        this.sendGTO(os, gto);
    }

    private void sendGTO(SDataOutputStream os, GroupTreeObject gto) throws IOException {
        os.writeUTF(gto.getName());
        os.writeUTF(gto.getType());
        ITreeObject to = gto.getTreeObject();
        if (to != null) {
            os.writeBoolean(true);
            String oid = to.getOID();
            if (oid != null && oid.length() > 0) {
                os.writeBoolean(true);
                os.writeUTF(oid);
            } else {
                os.writeBoolean(false);
            }
            Iterator<Map.Entry<String, String>> obj = to.getObject();
            if (obj != null && obj instanceof String && ((String)((Object)obj)).length() > 0) {
                os.writeBoolean(true);
                os.writeUTF((String)((Object)obj));
            } else {
                os.writeBoolean(false);
            }
        } else {
            os.writeBoolean(false);
        }
        Map<String, String> attributes = gto.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            os.writeInt(attributes.size());
            for (Map.Entry<String, String> en : attributes.entrySet()) {
                os.writeUTF(en.getKey());
                os.writeUTF(en.getValue());
            }
        } else {
            os.writeInt(0);
        }
        if (gto instanceof GroupTreeObjectUnsubmitted) {
            os.writeInt(-2);
        } else if (gto instanceof GroupTreeObjectLast) {
            os.writeInt(-1);
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
            String link = gtol.getLinkedPath();
            String icon = gtol.getIcon();
            if (link != null && link.length() > 0) {
                os.writeBoolean(true);
                os.writeUTF(link);
            } else {
                os.writeBoolean(false);
            }
            if (icon != null && icon.length() > 0) {
                os.writeBoolean(true);
                os.writeUTF(icon);
            } else {
                os.writeBoolean(false);
            }
        } else {
            List<GroupTreeObject> subElementList = gto.getElements();
            os.writeInt(subElementList.size());
            for (GroupTreeObject gtoKid : subElementList) {
                this.sendGTO(os, gtoKid);
            }
        }
    }
}

