/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.sa.VirtualSocket;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelayedSDataOutputStream
extends SDataOutputStream {
    AtomicBoolean m_isClosed = new AtomicBoolean(false);
    AtomicBoolean m_ready = new AtomicBoolean(false);
    Object m_lock = new Object();
    VirtualSocket m_parent = null;
    long timeoutTime = Long.MAX_VALUE;

    public DelayedSDataOutputStream(VirtualSocket parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(OutputStream os) {
        if (!this.m_isClosed.get()) {
            this.setOS(os);
            this.m_ready.set(true);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
        } else {
            throw new RuntimeException("Stream is closed. SessionID: " + this.m_parent.m_sockID);
        }
    }

    public void detachOutputStream() {
        try {
            this.stream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_ready.compareAndSet(true, false);
        this.m_isClosed.compareAndSet(true, false);
        this.stream = null;
    }

    public void setTimeoutTime(long stopWaitingTime) {
        this.timeoutTime = stopWaitingTime;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            super.close();
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_isClosed.compareAndSet(false, true);
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lock.notifyAll();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void flush() throws IOException {
        this.waitReady();
        super.flush();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public void write(byte[] v, int start, int len) throws IOException {
        this.waitReady();
        super.write(v, start, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitReady() throws IOException {
        this.m_parent.setState(2);
        while (!this.m_ready.get() && !this.m_isClosed.get()) {
            Object object = this.m_lock;
            synchronized (object) {
                try {
                    this.m_lock.wait(500L);
                    if (System.currentTimeMillis() > this.timeoutTime) {
                        throw new SocketTimeoutException();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void write(byte[] v) throws IOException {
        this.waitReady();
        super.write(v);
    }

    @Override
    public void write(int i) throws IOException {
        this.waitReady();
        super.write(i);
    }

    @Override
    public void writeBoolean(boolean i) throws IOException {
        this.waitReady();
        super.writeBoolean(i);
    }

    @Override
    public void writeBytes(byte[] content) throws IOException {
        this.waitReady();
        super.writeBytes(content);
    }

    @Override
    public void writeChar(int i) throws IOException {
        this.waitReady();
        super.writeChar(i);
    }

    @Override
    public void writeDouble(double i) throws IOException {
        this.waitReady();
        super.writeDouble(i);
    }

    @Override
    public void writeFile(InputStream fis) throws IOException {
        this.waitReady();
        byte[] arr = new byte[65536];
        int countB = -1;
        long totalBytes = 0L;
        while ((countB = fis.read(arr)) != -1) {
            totalBytes += (long)countB;
            this.writeInt(countB);
            this.write(arr, 0, countB);
            if (countB != arr.length) continue;
            this.m_parent.sendResponseNow();
            this.waitReady();
        }
        this.writeInt(-1);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.waitReady();
        super.writeInt(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.waitReady();
        super.writeLong(i);
    }

    @Override
    public void writeUTF(String msg) throws IOException {
        this.waitReady();
        super.writeUTF(msg);
    }
}

