/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.sa;

import com.blixx.sa.DelayedSDataInputStream;
import com.blixx.sa.DelayedSDataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class VirtualSocket
extends Socket {
    public static String MIME_DEFAULT_BINARY = "application/octet-stream";
    protected String m_sockID = null;
    protected int m_SOTimeout = 300000;
    protected boolean m_isConnected = false;
    protected boolean m_isClosed = false;
    protected DelayedSDataInputStream m_is = null;
    protected DelayedSDataOutputStream m_os = null;
    protected AtomicInteger m_state = new AtomicInteger(0);

    public VirtualSocket(String sessionid) {
        this.m_sockID = sessionid;
        this.m_is = new DelayedSDataInputStream(this);
        this.m_os = new DelayedSDataOutputStream(this);
    }

    public abstract boolean isSendResponseOnCloseState();

    public void setState(int state) throws IOException {
        this.getOs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        this.getIs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        if (state == 2 && this.m_state.compareAndSet(1, 2)) {
            this.getOs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        } else if (state == 1 && this.m_state.compareAndSet(2, 1)) {
            this.sendResponseNow();
            this.getIs().setTimeoutTime(System.currentTimeMillis() + (long)this.m_SOTimeout);
        } else if (!(state == 1 && this.m_state.compareAndSet(0, 1) || state == 2 && this.m_state.compareAndSet(0, 2) || state != 3)) {
            if (this.isSendResponseOnCloseState()) {
                this.sendResponseNow();
            }
            this.m_state.set(state);
        }
    }

    protected abstract void sendResponseNow() throws IOException;

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.getIs().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.getOs().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setState(3);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualSocket) {
            VirtualSocket s = (VirtualSocket)obj;
            if (this.m_sockID.equals(s.m_sockID)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.m_is == null) {
            return null;
        }
        return this.m_is.getInputStream();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.m_os == null) {
            return null;
        }
        return this.m_os.getOutputStream();
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return 0;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return true;
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return 0;
    }

    @Override
    public int getSoLinger() throws SocketException {
        return 1;
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.m_SOTimeout;
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return 0;
    }

    public int hashCode() {
        return this.m_sockID.hashCode();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed;
    }

    @Override
    public boolean isConnected() {
        return this.m_isConnected;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.m_SOTimeout = timeout;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
    }

    @Override
    public void shutdownInput() throws IOException {
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    @Override
    public String toString() {
        return this.m_sockID;
    }

    public DelayedSDataInputStream getIs() {
        return this.m_is;
    }

    public DelayedSDataOutputStream getOs() {
        return this.m_os;
    }
}

