/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.server.AgentCard;
import com.blixx.server.NullAgentID;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerWorker;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import com.boom.crt.CertificateManager;
import com.boom.crt.TrustStoreClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocket;

public class AgentHB
extends SchedulerTask {
    public static final String AGENT_AVAILABILITY = "Availability";
    public static final SocketException SKIP_BAD_HOSTNAME = new SocketException("skip bad hostname");
    public int countFails = 0;
    public long firstFailTime = 0L;
    public Boolean previousReachable = null;
    protected ServerEngine m_srv = ServerEngine.getInstance();
    protected AgentCard m_ac;
    protected int m_numberOFskipped = 0;
    private int countTriesTLS = 0;
    private boolean connected = false;

    public AgentHB(AgentCard ac) {
        super(AgentHB.getName(ac.getAgentID()));
        this.m_ac = ac;
    }

    @Override
    public long getInterval() {
        return (long)ServerProperties.getHB_Interval() * 1000L;
    }

    public static String getName(String id) {
        return "HB2A_" + id;
    }

    @Override
    protected int getPriority() {
        return 5;
    }

    private int getConnectTimeOut() {
        return ServerProperties.getHB_Ctimeout();
    }

    private int getReadTimeOut() {
        return ServerProperties.getHB_Rtimeout();
    }

    private void setReassigned() {
        this.m_ac.setMode(9);
        this.countFails = 0;
        this.firstFailTime = 0L;
    }

    protected void connectWithAgent(String remoteIP, SDataInputStream is, SDataOutputStream os, String connectedVia) throws IOException, NullAgentID {
        if (this.m_ac.isAgentDetailsNeeded() || !this.m_ac.isApproved()) {
            this.m_ac.askAgentDetails(os, is, remoteIP, connectedVia);
        }
        if (!this.m_ac.isApproved()) {
            ServerEngine.getInstance().getAgentRepository().approveAgent(this.m_ac.getAgentID());
        }
    }

    @Override
    public boolean onGetData() {
        if (this.m_ac == null) {
            return false;
        }
        RTLogger.print(6, "Starting AgentHB " + this.m_ac.getAgentHost());
        if (this.m_ac.needsToBeChecked() && this.m_ac.getMode() == 8) {
            this.m_ac.setMode(7);
        }
        if (!this.m_ac.needsToBeCheckedFromServer() && this.m_numberOFskipped < 3) {
            RTLogger.print(6, "HB skipped. " + this.m_ac.getAgentHost());
            ++this.m_numberOFskipped;
            return true;
        }
        this.m_numberOFskipped = 0;
        Socket s = null;
        try {
            s = this.doJob(this.m_ac);
        }
        catch (Throwable e) {
            this.failed(s, e);
        }
        finally {
            SocketUtils.closeSocket(s, new AutoCloseable[0]);
            RTLogger.print(6, "finished");
        }
        return true;
    }

    private void success() {
        this.countFails = 0;
        this.previousReachable = true;
        this.m_ac.setLastTimeOnlineFromServer(System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket doJob(AgentCard ac) throws Exception {
        Socket s = null;
        SDataInputStream dis = null;
        SDataOutputStream dos = null;
        String connectedVia = null;
        try {
            s = SocketUtils.getNewSocket(this.getReadTimeOut());
            try {
                if (this.connected && ac.isIPPPreferred()) {
                    throw SKIP_BAD_HOSTNAME;
                }
                InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName(ac.getAgentHost()), ac.getAgentPort());
                s.connect(sa, this.getConnectTimeOut());
                connectedVia = ac.getAgentHost();
                this.connected = true;
            }
            catch (Exception e) {
                try {
                    s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RTLogger.print(5, "Error connecting via hostname: " + ac.getAgentHost() + " " + e.getClass().getName());
                RTLogger.print(6, "Error connecting via hostname: " + ac.getAgentHost(), e);
                if (Objects.equals(ac.getAgentHost(), ac.getAgentIP())) throw new Exception("Error connecting to Agent using both hostname and IP");
                InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName(ac.getAgentIP()), ac.getAgentPort());
                s = SocketUtils.getNewSocket(this.getReadTimeOut());
                s.connect(sa, this.getConnectTimeOut());
                connectedVia = ac.getAgentIP();
                this.connected = true;
                ac.setIPPPreferred(true);
            }
            RTLogger.print(6, "Connecting via : " + connectedVia);
            if (this.m_ac.isTlsAgent()) {
                try {
                    boolean agentCertUpdateMightBeInProgress;
                    CertificateManager certificateManager = ServerEngine.getInstance().getCertificateManager();
                    s = TlsUtils.upgradeClientSocket(s, certificateManager, true);
                    Certificate agentCACert = null;
                    Certificate agentCert = null;
                    if (s instanceof SSLSocket) {
                        Certificate[] peerCertificates = ((SSLSocket)s).getSession().getPeerCertificates();
                        if (peerCertificates.length > 1) {
                            agentCert = peerCertificates[0];
                            agentCACert = peerCertificates[peerCertificates.length - 1];
                        } else {
                            ac.setAgentDetailsNecessary(true);
                        }
                    }
                    TrustStoreClient tsClient = certificateManager.getTsClient();
                    Certificate latestCACertificate = tsClient.getLatestCACertificate();
                    boolean agentNeedsCACertUpdate = agentCACert != null && !TlsUtils.isCertificateSignedBy(agentCACert, latestCACertificate);
                    boolean agentCertAboutToExpire = false;
                    if (agentCert instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)agentCert;
                        Date notAfter = x509Certificate.getNotAfter();
                        agentCertAboutToExpire = notAfter.getTime() - TimeUnit.DAYS.toMillis(ServerEngine.getInstance().getServerProps().getCertExpirationThresholdDays()) < System.currentTimeMillis();
                    }
                    Certificate knownAgentCert = tsClient.getKeyStore().getCertificate(this.m_ac.getAgentID());
                    if (agentNeedsCACertUpdate) {
                        if (this.m_ac == null) {
                            RTLogger.print(2, "Agent certificate is not signed by the latest CA, need update, cannot send new CA cert, since m_ac=null");
                        } else {
                            RTLogger.print(2, "Agent " + this.m_ac.getAgentID() + " certificate is not signed by the latest CA, need update");
                            ServerEngine.getInstance().getAgentCertificates().sendNewCACertToAgent(this.m_ac);
                        }
                    }
                    if (knownAgentCert == null && !agentNeedsCACertUpdate && agentCert != null) {
                        tsClient.importCertificate(this.m_ac.getAgentID(), agentCert);
                        tsClient.saveKeyStore();
                    }
                    boolean bl = agentCertUpdateMightBeInProgress = !Objects.equals(knownAgentCert, agentCert);
                    if (agentNeedsCACertUpdate || agentCertAboutToExpire || agentCertUpdateMightBeInProgress) {
                        this.m_ac.setAgentDetailsNecessary(true);
                    }
                }
                catch (SocketException e) {
                    if (e.getMessage() == null) throw e;
                    if (!e.getMessage().contains("Connection reset")) throw e;
                    this.m_ac.setSingleFlagOFF(64);
                    throw e;
                }
            }
            dis = new SDataInputStream(s.getInputStream());
            dos = new SDataOutputStream(s.getOutputStream(), ac.getProtocolVersion());
            dos.write(123);
            String remoteIP = s.getInetAddress().getHostAddress();
            RTLogger.print(11, remoteIP);
            this.connectWithAgent(remoteIP, dis, dos, connectedVia);
            this.doNormalPing(ac, dis, dos);
            this.success();
            if (RTLogger.getCurrentLevel() > 5) {
                RTLogger.print(6, "Success ping " + ac.getAgentID() + " via " + connectedVia);
            }
            dos.write(76);
            char answ = (char)dis.read();
            if (answ != 'T') return s;
            dos.write(79);
            char res = (char)dis.read();
            switch (res) {
                case 'T': {
                    while (dis.readBoolean()) {
                        ServerWorker sw = new ServerWorker(ac);
                        sw.setConnectedVia(connectedVia);
                        sw.processIncomingData(dos, dis, ac.getAgentIP());
                    }
                    return s;
                }
                case 'F': {
                    return s;
                }
            }
            return s;
        }
        catch (NullAgentID nullAgentID) {
            if (!this.detectTLS(dis, dos)) return s;
            RTLogger.print(1, "Agent requires TLS: " + String.valueOf(this.m_ac));
            this.m_ac.setSingleFlagON(64);
            try {
                if (!this.isKnownAgent()) {
                    RTLogger.print(3, "Agent TLS certificate missed: " + String.valueOf(this.m_ac));
                    this.m_ac.sendAgentCertificateError("Agent certificate missed");
                    return s;
                }
                RTLogger.print(3, "Agent is now using TLS: " + String.valueOf(this.m_ac));
                this.m_ac.setAgentDetailsNecessary(true);
                return s;
            }
            catch (Exception e) {
                RTLogger.print(1, "Error checking agent certificate. Ensure, that keystore and truststore are initialized correctly: " + String.valueOf(this.m_ac), e);
                return s;
            }
        }
        catch (SSLHandshakeException | SSLKeyException e) {
            if (this.isKnownAgent()) {
                RTLogger.print(1, "Agent certificate mismatch, or presented certificate expired " + String.valueOf(this.m_ac), e);
                this.m_ac.sendAgentCertificateError("Agent handshake error: " + e.getMessage());
                this.m_ac.setSingleFlagOFF(64);
                int defaultAgentPort = ServerEngine.getInstance().getServerProps().getAgentPort();
                this.m_ac.setAgentPort(defaultAgentPort);
            } else {
                RTLogger.print(1, "Agent TLS certificate missed: " + String.valueOf(this.m_ac));
                this.m_ac.sendAgentCertificateError("Agent certificate missed");
            }
            this.m_ac.setAgentDetailsNecessary(true);
            return s;
        }
        catch (SSLException e) {
            if (this.m_ac.getLastTimeOnlineFromServer() != 0L) throw e;
            if (this.m_ac.getLastTimeOnline() != 0L) throw e;
            if (e.getCause() == null) throw e;
            if (!(e.getCause() instanceof SocketException)) throw e;
            if (e.getMessage() == null) throw e;
            if (!e.getMessage().contains("Connection reset")) throw e;
            ++this.countTriesTLS;
            if (this.countTriesTLS < 3) throw e;
            this.countTriesTLS = 0;
            RTLogger.print(5, "trying switch to non-TLS comm. Assumed Agent mode=7, non-TLS port. " + String.valueOf(this.m_ac));
            this.m_ac.setSingleFlagOFF(64);
            throw e;
        }
        catch (Exception e) {
            this.connected = false;
            ac.setIPPPreferred(false);
            throw e;
        }
        finally {
            try {
                if (dos != null) {
                    dos.write(125);
                    dos.flush();
                    Thread.sleep(100L);
                }
            }
            catch (Exception nullAgentID) {}
        }
    }

    private boolean isKnownAgent() throws NullPointerException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        boolean agentKnown = false;
        CertificateManager certificateManager = ServerEngine.getInstance().getCertificateManager();
        if (certificateManager == null) {
            RTLogger.print(1, "Agent certificate check failed. Certificate manager is null");
        } else {
            agentKnown = certificateManager.isKnownAgent(this.m_ac.getAgentID());
        }
        return agentKnown;
    }

    private boolean detectTLS(SDataInputStream dis, SDataOutputStream dos) throws IOException {
        if (dos != null) {
            dos.write(0);
            dos.write(0);
            dos.write(0);
            int probablyAlert = dis.read();
            if (probablyAlert == 21) {
                return true;
            }
        }
        return false;
    }

    protected void doNormalPing(AgentCard ac, SDataInputStream is, SDataOutputStream os) throws SocketException, IOException {
        os.write(49);
        RTLogger.print(11, "Ping write(1)");
        char a = (char)is.read();
        RTLogger.print(11, "Ping get(): " + a);
        if (a == '0') {
            ac.setMode(1);
            ac.setProtocolVersion(1);
        } else if (a == '2') {
            ac.setProtocolVersion(1);
            ac.setMode(1);
            if (!ServerEngine.getInstance().isOutOfMemory() && ac.isAgentAllowsToSend()) {
                RTLogger.print(3, "Activate fetching data here. " + ac.getAgentHost());
                ac.fetchRemoteUpdates(is, os);
            }
        } else if (a == '!') {
            try {
                while (is.read() != -1) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setReassigned();
        } else if (a == '5') {
            ac.setMode(1);
            ac.setProtocolVersion(2);
        } else if (a == '6') {
            ac.setProtocolVersion(2);
            ac.setMode(1);
            if (!ServerEngine.getInstance().isOutOfMemory() && ac.isAgentAllowsToSend()) {
                RTLogger.print(3, "Activate fetching data here. " + ac.getAgentHost());
                ac.fetchRemoteUpdates(is, os);
            }
        } else {
            throw new RuntimeException("HB Protocol failed");
        }
    }

    public InetAddress getInetAddress(AgentCard ac) {
        String hostOrIP = ac.getAgentHost();
        InetAddress iaFirst = null;
        try {
            iaFirst = InetAddress.getByName(hostOrIP);
        }
        catch (UnknownHostException e1) {
            hostOrIP = ac.getAgentIP();
            try {
                iaFirst = null;
                iaFirst = InetAddress.getByName(hostOrIP);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return iaFirst;
    }

    protected void failed(Socket s, Throwable e) {
        if (this.previousReachable == null || this.previousReachable.booleanValue()) {
            this.previousReachable = false;
            this.firstFailTime = System.currentTimeMillis();
        }
        if (this.countFails >= 3) {
            this.countFails = 3;
            if (this.m_ac.getMode() < 3) {
                this.m_ac.setMode(3);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                StringBuilder sb = new StringBuilder();
                sb.append("hb failed(1): Agent ").append(this.m_ac.getAgentHost()).append(" offline! fcount=3").append(" first fail: ").append(sdf.format(new Date(this.firstFailTime)));
                RTLogger.print(2, sb);
                if (RTLogger.getCurrentLevel() >= 4 && !(e instanceof SocketTimeoutException)) {
                    RTLogger.print(4, "HB " + this.m_ac.getAgentHost() + " ", e);
                }
            } else {
                boolean isDeltaSmall;
                long delta = System.currentTimeMillis() - this.m_ac.getLastTimeOnline();
                boolean bl = isDeltaSmall = delta < this.getInterval() * 2L;
                if (isDeltaSmall && !this.m_ac.isOnline()) {
                    this.m_ac.setMode(8);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    StringBuilder sb = new StringBuilder();
                    sb.append("server hb failed : Agent ").append(this.m_ac.getAgentHost()).append(" is firewalled! fcount=3").append(" first fail: ").append(sdf.format(new Date(this.firstFailTime)));
                    RTLogger.print(2, sb);
                    if (RTLogger.getCurrentLevel() >= 4 && !(e instanceof SocketTimeoutException)) {
                        RTLogger.print(4, "HB " + this.m_ac.getAgentHost() + " ", e);
                    }
                }
            }
        } else {
            this.m_ac.setMode(2);
            ++this.countFails;
            StringBuffer sb = new StringBuffer();
            sb.append("hb failed(1): ").append(e.getMessage()).append(" host=").append(this.m_ac.getAgentHost());
            sb.append(" port=").append(this.m_ac.getAgentPort()).append(" Ctimeout=").append(this.getConnectTimeOut()).append(" Rtimeout=").append(this.getReadTimeOut()).append(" fcount=").append(this.countFails);
            RTLogger.print(2, sb);
            if (RTLogger.getCurrentLevel() >= 4 && !(e instanceof SocketTimeoutException)) {
                RTLogger.print(4, "HB " + String.valueOf(this.m_ac) + " ", e);
            }
        }
    }

    @Override
    public boolean onInit() throws Exception {
        this.countFails = 0;
        this.firstFailTime = 0L;
        return true;
    }

    @Override
    public boolean onStartRun() {
        if (this.m_srv.getAgentRepository().getLocalAgentCard(this.m_ac.getAgentID(), false) == null) {
            this.m_srv.getScheduler().removeTask(this.getName());
            throw new RuntimeException("Unknown Agent ID:{" + this.m_ac.getAgentID() + "}. Heartbeat stopped.");
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        int current_mode = this.m_ac.getMode();
        switch (current_mode) {
            case 0: {
                break;
            }
            case 1: {
                this.m_ac.sendAgentOnline();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.m_ac.sendAgentOffline();
                break;
            }
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

