/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Assignment;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentSyncStatus {
    public static final String GETHASH_SPI_DIR = "GETHASH=spi";
    public List<String> m_binpackagesUnsync = new LinkedList<String>();
    public List<String> m_binpackagesToUndeploy = new LinkedList<String>();
    public List<String> m_monToUndeploy = new LinkedList<String>();
    public List<String> m_monToDeploy = new LinkedList<String>();
    public List<String> m_msgToUndeploy = new LinkedList<String>();
    public List<String> m_msgToDeploy = new LinkedList<String>();
    public AgentCard m_ac = null;
    public Map<String, String> m_assignedMonitorPolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public Map<String, String> m_assignedMessagePolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public Map<String, String> m_disabledPolicies = new ConcurrentHashMap<String, String>(20, 0.9f, 3);
    public boolean m_ignoreDeploymentQueue = false;
    public boolean m_undeploySingle = false;
    public List<String> m_autoDeployASNs = null;

    public AgentSyncStatus(AgentCard ac, boolean ignoreDeploymentQueue, boolean undeploySingle, List<String> autoDeployASNs) {
        this.m_ignoreDeploymentQueue = ignoreDeploymentQueue;
        this.m_undeploySingle = undeploySingle;
        this.m_ac = ac;
        this.m_autoDeployASNs = autoDeployASNs;
    }

    public void clearSyncBuffers() {
        this.m_binpackagesUnsync.clear();
        this.m_binpackagesToUndeploy.clear();
        this.m_monToDeploy.clear();
        this.m_msgToDeploy.clear();
        this.m_monToUndeploy.clear();
        this.m_msgToUndeploy.clear();
    }

    public List<String> checkUnassignedGroups(boolean skipDeployment) {
        ArrayList<String> asnToDeploy = new ArrayList<String>();
        if (this.m_autoDeployASNs != null && this.m_autoDeployASNs.size() > 0) {
            for (String asnName : this.m_autoDeployASNs) {
                Assignment as = ServerEngine.getInstance().getAssignmentRepository().getAssignment(this.m_ac.getAgentID(), asnName, "pga");
                if (as != null) continue;
                asnToDeploy.add(asnName);
                if (skipDeployment) {
                    GroupTreeObject asnGrp = ServerEngine.getInstance().getAssignmentRepository().getAsnTree().findFirstGroup(asnName, "pga");
                    List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                    for (GroupTreeObjectLast gtol : list) {
                        if ("mon".equals(gtol.getType())) {
                            this.m_monToDeploy.add(gtol.getName());
                            continue;
                        }
                        if ("msg".equals(gtol.getType())) {
                            this.m_msgToDeploy.add(gtol.getName());
                            continue;
                        }
                        if (!"pkg".equals(gtol.getType())) continue;
                        this.m_binpackagesUnsync.add(gtol.getName());
                    }
                    continue;
                }
                AsnDbUpdate adu = new AsnDbUpdate();
                ServerEngine.getInstance().getAssignmentRepository().addAssignment(adu, this.m_ac.getAgentID(), asnName, "AgentSyncJob", "pga", true);
                adu.saveDB(ServerEngine.getInstance());
            }
        }
        return asnToDeploy;
    }

    public boolean checkAssignedPolicies() {
        Map<Assignment, Object> asns = ServerEngine.getInstance().getAssignmentRepository().getAssignments(this.m_ac.getAgentID());
        asns.putAll(ServerEngine.getInstance().getAssignmentRepository().getAssignmentsByNodeGroups(this.m_ac.getAgentID()));
        HashMap<CallSite, String> expectedPolicies = new HashMap<CallSite, String>();
        HashMap<String, String> policiesMarkedToUndeploy = new HashMap<String, String>();
        for (Assignment assignment : asns.keySet()) {
            AbstractPolicy p = null;
            if (assignment.getType().equals("mon")) {
                p = ServerEngine.getInstance().getPolicyRepository().getMonitorPolicy(assignment.getName());
                if (this.checkSingle(policiesMarkedToUndeploy, assignment, p)) continue;
                if (!this.m_ignoreDeploymentQueue && assignment.getLock() >= 3) {
                    policiesMarkedToUndeploy.put(p.getName(), p.getVersion());
                    continue;
                }
                expectedPolicies.put((CallSite)((Object)(assignment.getName() + "|" + assignment.getType())), p.getVersion());
                continue;
            }
            if (!assignment.getType().equals("msg") || this.checkSingle(policiesMarkedToUndeploy, assignment, p = ServerEngine.getInstance().getPolicyRepository().getMessagePolicy(assignment.getName()))) continue;
            if (!this.m_ignoreDeploymentQueue && assignment.getLock() >= 3) {
                policiesMarkedToUndeploy.put(p.getName(), p.getVersion());
                continue;
            }
            expectedPolicies.put((CallSite)((Object)(assignment.getName() + "|" + assignment.getType())), p.getVersion());
        }
        this.requestPolicyInfoFromAgent();
        Map<String, String> monpol = this.getDeployedMonitorPolicies();
        Iterator<Map.Entry<String, String>> it = monpol.entrySet().iterator();
        String monSuff = "|mon";
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String polName = entry.getKey();
            String tkey = polName + monSuff;
            String ver = entry.getValue();
            String srvVer = (String)expectedPolicies.get(tkey);
            if (srvVer == null) {
                this.m_monToUndeploy.add(polName);
            } else if (!srvVer.equals(ver)) {
                this.m_monToDeploy.add(polName);
            }
            expectedPolicies.remove(tkey);
        }
        Map<String, String> msgpol = this.getDeployedMessagePolicies();
        it = msgpol.entrySet().iterator();
        String msgSuff = "|msg";
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String polName = entry.getKey();
            String tkey = polName + msgSuff;
            String ver = entry.getValue();
            String srvVer = (String)expectedPolicies.get(tkey);
            if (srvVer == null) {
                this.m_msgToUndeploy.add(polName);
            } else if (!srvVer.equals(ver)) {
                this.m_msgToDeploy.add(polName);
            }
            expectedPolicies.remove(tkey);
        }
        for (String tkey : expectedPolicies.keySet()) {
            String pname;
            if (tkey.endsWith(monSuff)) {
                pname = tkey.replace(monSuff, "");
                this.m_monToDeploy.add(pname);
                continue;
            }
            if (!tkey.endsWith(msgSuff)) continue;
            pname = tkey.replace(msgSuff, "");
            this.m_msgToDeploy.add(pname);
        }
        return this.m_msgToUndeploy.size() > 0 || this.m_monToUndeploy.size() > 0 || this.m_msgToDeploy.size() > 0 || this.m_monToDeploy.size() > 0;
    }

    public boolean checkSingle(Map<String, String> policiesMarkedToUndeploy, Assignment assignment, AbstractPolicy p) {
        boolean single = false;
        if (this.m_undeploySingle && !this.m_monToDeploy.contains(assignment.getName()) && !ServerEngine.getInstance().getAssignmentRepository().checkOtherASNGroups(assignment.getName(), assignment.getType(), assignment.getAgentID())) {
            policiesMarkedToUndeploy.put(p.getName(), p.getVersion());
            single = true;
        }
        return single;
    }

    public boolean checkBinaryPackages() {
        this.requestBinaryHashInfo();
        return this.m_binpackagesUnsync.size() > 0 || this.m_binpackagesToUndeploy.size() > 0;
    }

    protected void requestPolicyInfoFromAgent() {
        this.m_assignedMonitorPolicies.clear();
        this.m_assignedMessagePolicies.clear();
        this.m_disabledPolicies.clear();
        RemoteCmdClient rc0 = new RemoteCmdClient('A', this.m_ac, "BOOM_AGENT POLICIES", 20);
        this.m_ac.scheduleTask(rc0);
        long start0 = System.currentTimeMillis();
        this.waitResult(rc0, start0);
        boolean isNewSyntax = false;
        if (rc0.getResult().resultCode == 0) {
            Pattern p = Pattern.compile("\\s*(...)\\s+(.*)\\s+\\(([\\d\\.]+)\\)(.*)");
            String[] lines = rc0.getMessage().split("\r*\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String status = m.group(1);
                String name = m.group(2);
                String ver = m.group(3);
                String typeAndOther = m.group(4);
                if (typeAndOther != null) {
                    String taot = typeAndOther.trim();
                    if (taot.startsWith("mon")) {
                        this.m_assignedMonitorPolicies.put(name, ver);
                        isNewSyntax = true;
                    } else if (taot.startsWith("msg")) {
                        this.m_assignedMessagePolicies.put(name, ver);
                        isNewSyntax = true;
                    }
                }
                if (status.charAt(0) != 'D') continue;
                this.m_disabledPolicies.put(name, status);
            }
        } else {
            throw new RuntimeException("Agent is offline");
        }
        if (!isNewSyntax) {
            GetDeployedPoliciesOld cmd = new GetDeployedPoliciesOld(this.m_ac);
            this.m_ac.scheduleTask(cmd);
            long start = System.currentTimeMillis();
            ServerEngine.getInstance().getServerProps();
            long hb_ms = (long)(ServerProperties.getHB_Interval() + 2) * 1000L;
            while (!cmd.isReady() && System.currentTimeMillis() - start < hb_ms) {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {}
            }
            if (cmd.getResult().resultCode != 0) {
                throw new RuntimeException("Agent is offline");
            }
        }
    }

    private void waitResult(RemoteCmdClient rc0, long start0) {
        ServerEngine.getInstance().getServerProps();
        long hb_ms0 = (long)(ServerProperties.getHB_Interval() + 2) * 1000L + 10000L;
        while (!rc0.isReady() && System.currentTimeMillis() - start0 < hb_ms0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Map<String, String> getDeployedMonitorPolicies() {
        return this.m_assignedMonitorPolicies;
    }

    public Map<String, String> getDeployedMessagePolicies() {
        return this.m_assignedMessagePolicies;
    }

    public List<String> getBinpackagesUnsync() {
        return this.m_binpackagesUnsync;
    }

    public List<String> getBinpackagesToUnDeploy() {
        return this.m_binpackagesToUndeploy;
    }

    public List<String> getMonToUndeploy() {
        return this.m_monToUndeploy;
    }

    public List<String> getMonToDeploy() {
        return this.m_monToDeploy;
    }

    public List<String> getMsgToUndeploy() {
        return this.m_msgToUndeploy;
    }

    public List<String> getMsgToDeploy() {
        return this.m_msgToDeploy;
    }

    public Map<String, String> getDisabledPolicies() {
        return this.m_disabledPolicies;
    }

    protected void requestBinaryHashInfo() {
        this.m_binpackagesUnsync.clear();
        this.m_binpackagesToUndeploy.clear();
        GetSPIHash rcc = new GetSPIHash(this.m_ac);
        this.m_ac.scheduleTask(rcc);
        long start0 = System.currentTimeMillis();
        this.waitResult(rcc, start0);
        if (rcc.getResult().resultCode != 0) {
            throw new RuntimeException("Agent is offline");
        }
    }

    public class GetDeployedPoliciesOld
    extends RemoteCmdClient {
        public GetDeployedPoliciesOld(AgentCard card) {
            super('P', card, "will not be used", 0);
        }

        @Override
        public void processGetAssignedPolicies(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
            this.er.resultCode = 1;
            try {
                String version;
                String monitor;
                int i;
                os.write(80);
                String type = is.readUTF();
                int size = is.readInt();
                RTLogger.print(5, "Assigned mons expected :" + size);
                AgentSyncStatus.this.m_assignedMonitorPolicies.clear();
                for (i = 0; i < size; ++i) {
                    monitor = is.readUTF();
                    version = is.readUTF();
                    AgentSyncStatus.this.m_assignedMonitorPolicies.put(monitor, version);
                }
                type = is.readUTF();
                size = is.readInt();
                RTLogger.print(5, "Assigned msgs expected :" + size);
                AgentSyncStatus.this.m_assignedMessagePolicies.clear();
                for (i = 0; i < size; ++i) {
                    monitor = is.readUTF();
                    version = is.readUTF();
                    AgentSyncStatus.this.m_assignedMessagePolicies.put(monitor, version);
                }
                this.er.resultCode = 0;
            }
            catch (RuntimeException e) {
                RTLogger.print(5, "processGetAssignedPolicies ", e);
            }
            if (this.er.resultCode != 0) {
                this.er.m_errorMessages.add("Failed to fetch data from the Agent");
            } else {
                this.er.m_outMessages.add("Success");
            }
        }
    }

    public class GetSPIHash
    extends RemoteCmdClient {
        private StringBuilder sbErrors;
        private AbstractAgentCard ac;

        public GetSPIHash(AgentCard ac) {
            super('C', AgentSyncStatus.this.m_ac, AgentSyncStatus.GETHASH_SPI_DIR, 0);
            this.sbErrors = new StringBuilder();
            this.ac = ac;
        }

        @Override
        public void processAgentAction(SDataInputStream is, SDataOutputStream os) throws IOException {
            os.write(this.m_char);
            os.writeUTF(this.m_cmd);
            String result = is.readUTF();
            char response = (char)is.read();
            this.er.resultCode = response != 'T' ? -1 : 0;
            this.processResult(result);
        }

        public void processResult(String result) {
            if (this.er.resultCode == 0) {
                HashMap<String, String> agentSide = FileSyncUtils.parseDigest(result);
                Map<Assignment, Object> allAssignments = ServerEngine.getInstance().getAssignmentRepository().getAssignments(this.ac.getAgentID());
                for (Assignment assignment : allAssignments.keySet()) {
                    if (!"pkg".equals(assignment.getType())) continue;
                    String binPkg = assignment.getName();
                    if (AgentSyncStatus.this.m_undeploySingle && !AgentSyncStatus.this.m_monToDeploy.contains(assignment.getName()) && !ServerEngine.getInstance().getAssignmentRepository().checkOtherASNGroups(assignment.getName(), assignment.getType(), assignment.getAgentID())) {
                        AgentSyncStatus.this.m_binpackagesToUndeploy.add(binPkg);
                        continue;
                    }
                    if (!AgentSyncStatus.this.m_ignoreDeploymentQueue && assignment.getLock() >= 3) {
                        AgentSyncStatus.this.m_binpackagesToUndeploy.add(binPkg);
                        continue;
                    }
                    File packages = ServerEngine.getInstance().getBinariesRepository().getPackageDirectory();
                    try {
                        int okfiles = 0;
                        int notOK = 0;
                        int agentMissed = 0;
                        int agentHasDifferentVersion = 0;
                        File pkgdir = new File(packages, binPkg);
                        HashMap<String, byte[]> m = FileSyncUtils.getDigestMap(pkgdir);
                        Map<String, String> serverSidePkg = FileSyncUtils.formatDigestMap(m);
                        for (Map.Entry<String, String> entry : serverSidePkg.entrySet()) {
                            String agentDigestSingle = agentSide.get(entry.getKey());
                            if (agentDigestSingle == null) {
                                ++agentMissed;
                                continue;
                            }
                            if (agentDigestSingle.equals(entry.getValue())) {
                                ++okfiles;
                                continue;
                            }
                            ++agentHasDifferentVersion;
                        }
                        notOK = agentMissed + agentHasDifferentVersion;
                        if (notOK <= 0) continue;
                        AgentSyncStatus.this.m_binpackagesUnsync.add(binPkg);
                    }
                    catch (Throwable e) {
                        this.sbErrors.append("# error: ").append(e.getMessage()).append('\n');
                    }
                }
            } else {
                throw new RuntimeException("ERROR: " + this.er.getOutput());
            }
        }
    }

    public class GetDeployedPolicies
    extends RemoteCmdClient {
        public GetDeployedPolicies(AgentSyncStatus this$0, AgentCard card) {
            super('A', card, "BOOM_AGENT POLICIES", 20);
        }
    }
}

