/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.sa.Scheduler;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentHB;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.cube.Cube;
import com.blixx.server.db.DB;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.BM;
import com.blixx.shared.IAgentCMRepository;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.IAgentManager;
import com.boom.AgentInfo;
import com.boom.crt.CertificateManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class AgentsRepository
implements IAgentManager<AgentCard>,
IAgentCMRepository {
    private ConcurrentHashMap<String, AgentCard> m_agents = new ConcurrentHashMap(100, 0.85f, 5);
    private ConcurrentHashMap<String, AgentCard> m_agentsPending = new ConcurrentHashMap(5, 0.85f, 2);
    private ConcurrentHashMap<String, AgentCardCM> m_agentsCM = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> m_agentsCMLabels = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> m_concurrentIPs = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> m_pendingAgentRequestsTimes = new ConcurrentHashMap(5, 0.85f, 2);
    private DB m_db = null;
    private Scheduler m_scheduler = null;
    private ConcurrentHashMapMap<String, AgentCard> externalHosts = new ConcurrentHashMapMap();

    void initAgentCards(DB db, Scheduler scheduler) {
        this.m_db = db;
        this.m_scheduler = scheduler;
        AgentCard[] res = this.m_db.readAgentCards();
        if (res != null) {
            this.reloadAgentCardCM();
            for (AgentCard ac : res) {
                AgentCardCM acm;
                if (!ac.isApproved() && !ac.isExternal()) continue;
                this.putAgentCard(ac);
                if (!ac.isExternal()) {
                    ServerEngine.getInstance().ensureLicense(ac);
                }
                if ((acm = this.getAgentCM(ac.getAgentID())) == null || acm.getValue("LIT") == null) continue;
                try {
                    long time = Long.parseLong(String.valueOf(acm.getValue("LIT")));
                    if (time <= 0L) continue;
                    ac.setLastTimeOnlineFromServer(time);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } else {
            RTLogger.print(1, "No AgentCards found");
        }
    }

    public Map<String, AgentCard> getAgentCards() {
        return this.m_agents;
    }

    public Map<String, AgentCardCM> getAgentCMs() {
        return this.m_agentsCM;
    }

    @Override
    public ConcurrentHashMap<String, AgentCard> getAgentCardsPending() {
        return this.m_agentsPending;
    }

    public Map<String, String> getAgentLabels() {
        return this.m_agentsCMLabels;
    }

    public Map<String, Long> getConcurrentIPs() {
        return this.m_concurrentIPs;
    }

    public Map<String, Long> getAgentsPendingTimes() {
        return this.m_pendingAgentRequestsTimes;
    }

    @Override
    public void putAgentCard(AgentCard ac) {
        if (ac != null) {
            if (ac.getAgentPort() == -2 && ac.getMode() < 7) {
                ac.setModeSilently(7);
                ac.setDefaultMode(7);
            }
            this.m_agents.put(ac.getAgentID(), ac);
            if (ac.isExternal()) {
                for (String hostnames : AgentCard.getAllHostnames(ac)) {
                    this.externalHosts.putV(hostnames, ac);
                }
                for (String ip : AgentCard.getAllIPs(ac)) {
                    this.externalHosts.putV(ip, ac);
                }
            }
        }
    }

    public AgentCardCM getAgentCM(String id) {
        return this.m_agentsCM.get(id);
    }

    public void initHBs(Scheduler scheduler) {
        for (AgentCard agentCard : this.getAgentCards().values()) {
            if (agentCard == null || agentCard.isFirewalled() || agentCard.getAgentPort() <= 0 || agentCard.isIoTHub()) continue;
            AgentHB hb = new AgentHB(agentCard);
            scheduler.addTask(hb, 0L);
        }
    }

    public AgentCard getAgentCardByID(String id) {
        return this.m_agents.get(id);
    }

    @Override
    public AgentCard getAgentCard(String ip) {
        AgentCard acFirstFound = null;
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            AgentCard ac = en.getValue();
            if (ac == null || !ac.isLocalAgent() || !ip.equals(ac.getAgentIP()) || ac.isExternal()) continue;
            if (acFirstFound != null) {
                this.m_concurrentIPs.put(ip, System.currentTimeMillis());
                return null;
            }
            acFirstFound = ac;
        }
        return acFirstFound;
    }

    @Override
    public boolean isHostNameOrIPKnown(String nameOrIP) {
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            AgentCard ac = en.getValue();
            if (ac == null || !nameOrIP.equalsIgnoreCase(ac.getAgentIP()) && !nameOrIP.equalsIgnoreCase(ac.getAgentHost())) continue;
            return true;
        }
        return false;
    }

    @Override
    public AgentCard getAgentCard(String nodeName, int port) {
        if (nodeName == null) {
            return null;
        }
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            AgentCard ac = en.getValue();
            if (ac == null || port != 0 && ac.getAgentPort() != port || !nodeName.equals(ac.getAgentHost())) continue;
            return ac;
        }
        return null;
    }

    @Override
    public AgentCard getAgentCardVirtual(String nodeName, String ip) {
        if (nodeName == null || ip == null) {
            return null;
        }
        AgentCard result = null;
        Map byHostname = (Map)this.externalHosts.get(nodeName);
        if (byHostname != null && byHostname.keySet().size() > 0) {
            result = (AgentCard)byHostname.keySet().iterator().next();
        } else {
            Map byIP = (Map)this.externalHosts.get(ip);
            if (byIP != null && byIP.keySet().size() > 0) {
                result = (AgentCard)byIP.keySet().iterator().next();
            }
        }
        return result;
    }

    @Override
    public List<AgentCard> getLocalAgentCard(String nodeName, int port) {
        ArrayList<AgentCard> list = new ArrayList<AgentCard>();
        if (nodeName == null) {
            return list;
        }
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            AgentCard ac = en.getValue();
            if (ac == null || !ac.isLocalAgent() || !nodeName.equals(ac.getAgentHost()) || ac.getAgentPort() != port) continue;
            list.add(ac);
        }
        return list;
    }

    @Override
    public List<AgentCard> getLocalAgentCards(String nodeName) {
        ArrayList<AgentCard> list = new ArrayList<AgentCard>();
        if (nodeName == null) {
            return list;
        }
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            AgentCard ac = en.getValue();
            if (ac == null || !ac.isLocalAgent() || !nodeName.equals(ac.getAgentHost())) continue;
            list.add(ac);
        }
        return list;
    }

    public List<AgentCard> getExternalHosts(String hostOrIP) {
        Map cards = (Map)this.externalHosts.get(hostOrIP);
        return cards == null ? Collections.emptyList() : new ArrayList(cards.keySet());
    }

    @Override
    public List<AgentCard> getExternalHostsLocalOnly(String hostOrIP) {
        List<AgentCard> list = this.getExternalHosts(hostOrIP);
        return list.isEmpty() ? list : list.stream().filter(AgentCard::isLocalAgent).collect(Collectors.toList());
    }

    @Override
    public AgentCard getLocalAgentCard(String agentID, boolean includeExternal) {
        AgentCard ac = this.m_agents.get(agentID);
        if (ac != null) {
            if (!ac.isLocalAgent()) {
                ac = null;
            } else if (!includeExternal && ac.isExternal()) {
                ac = null;
            }
        }
        return ac;
    }

    @Override
    public void addPendingIP(AgentInfo agtInfo) {
        this._addPendingIP(agtInfo);
    }

    private void _addPendingIP(AgentInfo agtInfo) {
        AgentCard ac = this.m_agents.get(agtInfo.getId());
        if (ac != null) {
            if (!(ac.toStringExt().equals(AgentCard.getStringExt(agtInfo.getRemoteIP(), agtInfo.getId(), agtInfo.getHostname(), agtInfo.getOs(), agtInfo.getPort(), agtInfo.getFlags())) || agtInfo.isTLS() && !agtInfo.isTLSReady())) {
                this.updateACFields(agtInfo, ac);
                this.saveAgentCard(ac);
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
                RTLogger.print(3, "Agent has new IP: " + ac.toStringExt());
            }
        } else {
            AgentCard acOld = this.m_agentsPending.get(agtInfo.getId());
            if (acOld != null) {
                if (!acOld.toStringExt().equals(AgentCard.getStringExt(agtInfo.getRemoteIP(), agtInfo.getId(), agtInfo.getHostname(), agtInfo.getOs(), agtInfo.getPort(), agtInfo.getFlags()))) {
                    this.updateACFields(agtInfo, acOld);
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
                }
                this.m_pendingAgentRequestsTimes.put(acOld.getAgentID(), System.currentTimeMillis());
            } else {
                acOld = this.getAgentCard(agtInfo.getHostname(), agtInfo.getPort());
                if (acOld == null) {
                    acOld = this.getAgentCard(agtInfo.getRemoteIP(), agtInfo.getPort());
                }
                if (acOld != null) {
                    try {
                        if (!agtInfo.isTLS() || agtInfo.isTLSReady() && this.isKnownAgent(acOld.getAgentID())) {
                            this.updateACFields(agtInfo, acOld);
                            this.saveAgentCard(acOld);
                        }
                    }
                    catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        RTLogger.print(1, "Could not check if agent known: " + acOld.toStringExt());
                    }
                    if (!acOld.getAgentID().equals(agtInfo.getId())) {
                        acOld.sendAgentID();
                    }
                    if (!acOld.isFirewalled()) {
                        this.m_scheduler.removeTask(AgentHB.getName(acOld.getAgentID()));
                        if (acOld.getAgentPort() > 0) {
                            AgentHB hb = new AgentHB(acOld);
                            this.m_scheduler.addTask(hb, 0L);
                        }
                    }
                    RTLogger.print(3, "Pending Agent attr: " + acOld.toStringExt());
                } else {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("HOSTNAME", agtInfo.getHostname());
                    m.put("ID", agtInfo.getId());
                    m.put("IP", agtInfo.getRemoteIP());
                    m.put("DESCRIPTION", "Discovered " + agtInfo.getHostname() + " (" + agtInfo.getRemoteIP() + ")");
                    if (agtInfo.getPort() != BM.AGENT_PORT) {
                        m.put("LABEL", agtInfo.getHostname() + "(" + agtInfo.getPort() + ")");
                    } else {
                        m.put("LABEL", agtInfo.getHostname());
                    }
                    m.put("MODE", agtInfo.getPort() == -2 ? 7 : 0);
                    m.put("OS", agtInfo.getOs());
                    m.put("APPROVED", 0);
                    m.put("DISABLED", 0);
                    m.put("PORT", "" + agtInfo.getPort());
                    ac = new AgentCard(m);
                    ac.csr = agtInfo.certificate;
                    this.m_agentsPending.put(agtInfo.getId(), ac);
                    this.m_pendingAgentRequestsTimes.put(agtInfo.getId(), System.currentTimeMillis());
                    RTLogger.print(3, "Pending AC:" + String.valueOf(ac) + " port:" + agtInfo.getPort());
                    if (ServerEngine.getInstance().getServerProps().isAutoApproval()) {
                        this.approveAgent(agtInfo.getId());
                    }
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
                }
            }
        }
    }

    private boolean isKnownAgent(String agentId) throws NullPointerException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        boolean agentKnown = false;
        CertificateManager certificateManager = ServerEngine.getInstance().getCertificateManager();
        if (certificateManager == null) {
            RTLogger.print(1, "Agent certificate check failed. Certificate manager is null");
        } else {
            agentKnown = certificateManager.isKnownAgent(agentId);
        }
        return agentKnown;
    }

    public AgentCard removeAgentCard(String id) {
        AgentCard removed = this.m_agents.remove(id);
        if (removed != null && removed.isExternal()) {
            this.forgetExternalAgentCard(removed);
        }
        return removed;
    }

    @Override
    public int getRealAgentCardsCount() {
        int res = 0;
        for (Map.Entry<String, AgentCard> en : this.m_agents.entrySet()) {
            if (en.getValue().isExternal()) continue;
            ++res;
        }
        return res;
    }

    private void updateACFields(AgentInfo agtInfo, AgentCard ac) {
        if (!agtInfo.getRemoteIP().equals(ac.getAgentIP())) {
            ac.setNewAgentIP(agtInfo.getRemoteIP());
        }
        Object oldDefaultLabel = ac.getAgentHost();
        if (ac.getAgentPort() != BM.AGENT_PORT) {
            oldDefaultLabel = (String)oldDefaultLabel + "(" + ac.getAgentPort() + ")";
        }
        Object newDefaultLabel = agtInfo.getHostname();
        if (agtInfo.getPort() != BM.AGENT_PORT) {
            newDefaultLabel = (String)newDefaultLabel + "(" + agtInfo.getPort() + ")";
        }
        ac.setHostName(agtInfo.getHostname());
        ac.setOSName(agtInfo.getOs());
        ac.setAgentPort(agtInfo.getPort());
        if (ac.getAgentPort() == -2) {
            ac.setDefaultMode(7);
        }
        int agtInfoFlags = agtInfo.getFlags();
        if (ac.getAgentOutage()) {
            agtInfoFlags |= 0x10;
        }
        ac.setAgentFlags(agtInfoFlags);
        if (ac.getLabel().equals(oldDefaultLabel)) {
            ac.setLabel((String)newDefaultLabel);
        }
        ac.csr = agtInfo.certificate;
    }

    @Override
    public void checkPending() {
        this._checkPending();
    }

    private void _checkPending() {
        boolean sendGetAgentsCMD = false;
        for (String id : this.m_pendingAgentRequestsTimes.keySet()) {
            long delta;
            Long time = this.m_pendingAgentRequestsTimes.get(id);
            if (time == null) {
                time = 0L;
            }
            if ((delta = System.currentTimeMillis() - time) <= 30000L) continue;
            sendGetAgentsCMD = true;
            this.m_agentsPending.remove(id);
            this.m_pendingAgentRequestsTimes.remove(id);
        }
        if (sendGetAgentsCMD) {
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        }
    }

    @Override
    public boolean approveAgent(String id) {
        boolean localAgent = false;
        AgentCard ac = this.m_agentsPending.get(id);
        if (ac == null && (ac = this.getAgentCardByID(id)) != null && (ac.getOSName() == null || ac.getOSName().isEmpty())) {
            ac.setOSName("Connecting...");
        }
        if (ac != null && ac.isLocalAgent()) {
            localAgent = true;
            ac.setApproved();
            try {
                this.saveAgentCard(ac);
                if (ac.csr != null) {
                    ServerEngine.getInstance().getAgentCertificates().processAgentCSR(ac, ac.csr);
                }
                this.m_agentsPending.remove(id);
                this.putAgentCard(ac);
                if (ac.getAgentPort() > 0) {
                    AgentHB hb = new AgentHB(ac);
                    this.m_scheduler.addTask(hb, 0L);
                }
                SEventFwd sm = SMessage.createMessage(1, 1, ac.getAgentHost(), "BOOM_SERVER", "BOOM_AGENT", "BOOM Server", "Agent approved");
                sm.setNode(ac.getAgentHost());
                sm.setT1(ac.getAgentID());
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
            catch (Throwable e) {
                ac.setUnApproved();
                RuntimeException r = new RuntimeException(e);
                RTLogger.print(2, "Error approving AC: " + String.valueOf(ac) + " " + ac.getOSName());
                throw r;
            }
        } else {
            AgentCard remote = this.getAgentCardByID(id);
            if (remote != null) {
                if (remote.getRelatedServer() != null) {
                    SlaveServerCard ssc = ServerEngine.getInstance().getSlave(remote.getRelatedServer());
                    if (ssc != null && ssc.getScenario() < 3) {
                        ssc.getServerClient().start("JOB", "APPROVE_AGENT", new String[]{id});
                    }
                } else if (remote.isExternal()) {
                    remote.setApproved();
                    this.saveAgentCard(remote);
                    return true;
                }
            }
        }
        return localAgent;
    }

    @Override
    public void deleteAgent(String id) {
        ArrayList<String> toDeleteAgentIDs = new ArrayList<String>(1);
        toDeleteAgentIDs.add(id);
        this.deleteAgents(toDeleteAgentIDs);
    }

    @Override
    public boolean deleteAgents(List<String> ids) {
        boolean nodeGroupsUpdated = false;
        if (ids == null || ids.size() == 0) {
            return false;
        }
        HashMap<SlaveServerCard, List> slaves = new HashMap<SlaveServerCard, List>();
        ArrayList<String> localAgentsToDelete = new ArrayList<String>();
        for (String string : ids) {
            if (this.m_agentsPending.containsKey(string)) continue;
            nodeGroupsUpdated = NodeGroupRepository.getInstance().deleteLinked(string) || nodeGroupsUpdated;
            AgentCard ac = this.m_agents.get(string);
            if (ac != null && ac.isLocalAgent()) {
                localAgentsToDelete.add(string);
                this.m_agents.remove(string);
                if (!ac.isExternal()) {
                    this.m_scheduler.removeTask(AgentHB.getName(ac.getAgentID()));
                    if (ServerEngine.getInstance().getAssignmentRepository() != null) {
                        ServerEngine.getInstance().getAssignmentRepository().deleteAgent(string);
                    }
                    ServerEngine.getInstance().unregisterAgentFromLicensed(string);
                    continue;
                }
                this.forgetExternalAgentCard(ac);
                continue;
            }
            if (ac != null && ac.getRelatedServer() != null) {
                SlaveServerCard ssc = ServerEngine.getInstance().getSlave(ac.getRelatedServer());
                if (ssc == null || ssc.getScenario() >= 3) continue;
                List list = slaves.computeIfAbsent(ssc, k -> new LinkedList());
                list.add(string);
                continue;
            }
            for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
                if (ssc == null || ssc.getScenario() >= 3) continue;
                List list = slaves.computeIfAbsent(ssc, k -> new LinkedList());
                list.add(string);
            }
        }
        if (localAgentsToDelete.size() > 0) {
            final ArrayList<String> td = localAgentsToDelete;
            ServerThreadPool.getInstance().submit(new Runnable(){

                @Override
                public void run() {
                    if (td.size() > 0) {
                        for (String agentID : td) {
                            Cube.getInstance().removeAgentCardStatusSummary(agentID);
                            AgentsRepository.this.m_db.deleteAgent(agentID);
                            AgentsRepository.this.m_db.deleteAgentAssignments(agentID);
                            try {
                                ServerEngine.getInstance().getCertificateManager().getTsClient().deleteCertificate(agentID);
                            }
                            catch (KeyStoreException e) {
                                RTLogger.print(1, "error delete cert for " + agentID, e);
                            }
                        }
                        try {
                            ServerEngine.getInstance().getCertificateManager().getTsClient().saveKeyStore();
                        }
                        catch (Exception e) {
                            RTLogger.print(1, "error save trust store ", e);
                        }
                    }
                }
            });
        }
        for (Map.Entry entry : slaves.entrySet()) {
            SlaveServerCard ssc = (SlaveServerCard)entry.getKey();
            List l = (List)entry.getValue();
            if (l == null || l.size() <= 0) continue;
            ssc.getServerClient().start("JOB", "DELETE_AGENT", l.toArray(new String[0]));
        }
        if (localAgentsToDelete.size() > 0) {
            ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS"));
        }
        if (nodeGroupsUpdated) {
            ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("REFRESH_NODEGROUPS"));
        }
        return nodeGroupsUpdated;
    }

    private void forgetExternalAgentCard(AgentCard ac) {
        for (String host : AgentCard.getAllHostnames(ac)) {
            this.externalHosts.removeElement(host, ac);
        }
        for (String ip : AgentCard.getAllIPs(ac)) {
            this.externalHosts.removeElement(ip, ac);
        }
    }

    @Override
    public void saveAgentCard(AgentCard ac) {
        this.saveAgentCard_noNotification(ac);
        try {
            ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GETAGENTCARDS"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void saveAgentCard_notifySingle(AgentCard ac) {
        this.saveAgentCard_noNotification(ac);
        AgentsRepository.notifySingleAgentChange(ac);
    }

    public static void notifySingleAgentChange(AgentCard ac) {
        try {
            ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GETAGENTCARD_SINGLE", ac.getAgentID(), null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void saveAgentCard_noNotification(AgentCard ac) {
        this.m_db.saveAgentCard(ac);
    }

    @Override
    public void reloadAgentCardCM() {
        this.m_agentsCMLabels = new ConcurrentHashMap<String, String>(this.m_db.readAgentCMLabel());
        this.m_agentsCM = new ConcurrentHashMap<String, AgentCardCM>(this.m_db.readAgentCM());
        RTLogger.print(2, "Extended agent attributes reloaded from the DB");
    }

    @Override
    public List<AgentCard> getAgentCards(String user) {
        LinkedList<AgentCard> allAC = new LinkedList<AgentCard>();
        if (UserManager.getInstance().getRights(1002, user) < 2) {
            return allAC;
        }
        Collection<AgentCard> values = this.getAgentCards().values();
        allAC.addAll(values);
        allAC.addAll(this.getAgentCardsPending().values());
        List<SlaveServerCard> list = ServerEngine.getInstance().getSlaves();
        for (SlaveServerCard ssc : list) {
            if (!ssc.getAgents().isEmpty()) continue;
            ssc.updateAgent(ssc.getDummyPendingAgentCard());
            this.putAgentCard(ssc.getDummyPendingAgentCard());
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            allAC.removeIf(ac -> !UserManager.getInstance().isAgentVisible(user, ac.getAgentID(), nodeGroups));
        }
        return allAC;
    }

    @Override
    public void createAgentCard(AgentCard ac, String user) throws Exception {
        this.normalizeHostnameAndIP(ac);
        if (ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
            ac.setHostName(ac.getAgentHost().toLowerCase());
        }
        if (ac.isExternal()) {
            if (ServerEngine.getInstance().getExternalHostResolver() != null) {
                ServerEngine.getInstance().getExternalHostResolver().addExternalHost(ac, user);
            }
        } else if (this.getLocalAgentCard(ac.getAgentID(), true) == null) {
            AgentCard potentialConflict = this.getAgentCard(ac.getAgentHost(), ac.getAgentPort());
            if (potentialConflict != null) {
                throw new Exception("Skip creation of the conflicting AgentCard. Already used hostname: " + ac.getAgentHost());
            }
            potentialConflict = this.getAgentCard(ac.getAgentIP());
            if (potentialConflict != null && potentialConflict.getAgentPort() == ac.getAgentPort()) {
                throw new Exception("Skip creation of the conflicting AgentCard. Already used IP: " + ac.getAgentIP());
            }
            if (ac.isFirewalled() || ac.getAgentPort() <= 0) {
                ac.setModeSilently(7);
                this.m_scheduler.removeTask(AgentHB.getName(ac.getAgentID()));
            } else {
                ac.setModeSilently(0);
                AgentHB hb = new AgentHB(ac);
                this.m_scheduler.addTask(hb, 0L);
            }
            ServerEngine.getInstance().ensureLicense(ac);
            this.saveAgentCard(ac);
            this.putAgentCard(ac);
            ServerEngine.getInstance().getAuditLog().logCreate(user == null ? "BOOM_SERVER" : user, ac.toString());
        } else {
            throw new Exception("Skip creation of the conflicting AgentCard. Agent ID is already in use: " + ac.getAgentID());
        }
    }

    private void normalizeHostnameAndIP(AgentCard ac) throws Exception {
        if (ac.getAgentHost() == null || ac.getAgentHost().trim().isEmpty()) {
            if (ac.getAgentIP() == null || ac.getAgentIP().isEmpty()) {
                throw new Exception("empty hostname and IP");
            }
            try {
                ac.setHost(InetAddress.getByName(ac.getAgentIP()).getHostName());
            }
            catch (UnknownHostException e) {
                RTLogger.print(5, "error lookup hostname: " + ac.getAgentIP());
                ac.setHost(ac.getAgentIP());
            }
        }
        if (ac.getAgentIP() == null || ac.getAgentIP().trim().isEmpty()) {
            try {
                ac.setIP(InetAddress.getByName(ac.getAgentHost()).getHostAddress());
            }
            catch (UnknownHostException e) {
                RTLogger.print(5, "error lookup IP: " + ac.getAgentHost());
            }
        }
    }

    @Override
    public AgentCard updateFrom(AgentCard ac, String user) {
        AgentCard stored = this.getLocalAgentCard(ac.getAgentID(), true);
        stored.setDescription(ac.getDescription());
        stored.setLabel(ac.getLabel());
        stored.setAgentPort(ac.getAgentPort());
        stored.setAgentFlags(ac.getAgentFlags());
        if ("PRIMARY_SERVER".equals(user)) {
            stored.setHost(ac.getAgentHost());
            stored.setIP(ac.getAgentIP());
            stored.setDisabled(ac.isDisabled());
            stored.setDefaultMode(ac.getDefaultMode());
            stored.setOSName(ac.getOSName());
        } else if (stored.isExternal()) {
            stored.setHost(ServerEngine.getInstance().getServerProps().isUseHostLowercase() ? ac.getAgentHost().toLowerCase() : ac.getAgentHost());
            stored.setIP(ServerEngine.getInstance().getServerProps().isUseHostLowercase() ? ac.getAgentIP().toLowerCase() : ac.getAgentIP());
        }
        if (!ac.isDisabled() && stored.isDisabled()) {
            stored.sendEnableAgent();
            if (ServerEngine.getInstance().ensureLicense(ac)) {
                ServerEngine.getInstance().getAuditLog().logModify(user, "Agent/" + String.valueOf(stored), ac.isDisabled() ? "Disabled" : "Enabled");
            }
        } else if (ac.isDisabled() && !stored.isDisabled()) {
            stored.sendDisableAgent();
            ServerEngine.getInstance().unregisterAgentFromLicensed(ac.getAgentID());
            ServerEngine.getInstance().getAuditLog().logModify(user, "Agent/" + String.valueOf(stored), ac.isDisabled() ? "Disabled" : "Enabled");
        }
        int modeIncoming = ac.getMode();
        if (ac.isFirewalled() && !stored.isFirewalled()) {
            this.m_scheduler.removeTask(AgentHB.getName(stored.getAgentID()));
            ServerEngine.getInstance().getAuditLog().logModify(user, "Agent/" + String.valueOf(stored), "Firewalled ON");
        } else if (!ac.isFirewalled() && stored.isFirewalled()) {
            modeIncoming = 0;
            if (!stored.isExternal()) {
                AgentHB hb = new AgentHB(stored);
                this.m_scheduler.addTask(hb, 0L);
                ServerEngine.getInstance().getAuditLog().logModify(user, "Agent/" + String.valueOf(stored), "Firewalled OFF");
            } else {
                stored.setOSName("_External");
            }
        }
        stored.setModeSilently(modeIncoming);
        this.saveAgentCard_notifySingle(stored);
        return stored;
    }

    @Override
    public Map<String, AgentCardCM> getAgentCardCMLocalOnly() {
        return this.m_agentsCM;
    }

    @Override
    public Map<String, AgentCardCM> getAgentCardCM() {
        LinkedHashMap<String, AgentCardCM> map = new LinkedHashMap<String, AgentCardCM>(this.m_agentsCM);
        for (SlaveServerCard ssc : ServerEngine.getInstance().getSlaves()) {
            map.putAll(ssc.getAgentCMs());
        }
        return map;
    }

    @Override
    public Map<String, String> getAgentCardCMLabels() {
        return this.m_agentsCMLabels;
    }

    @Override
    public AgentCardCM getAgentCardCM(String agentID) {
        return this.m_agentsCM.get(agentID);
    }

    @Override
    public void saveAgentCardCM(AgentCardCM acm) throws Exception {
        ArrayList<AgentCardCM> l = new ArrayList<AgentCardCM>(1);
        l.add(acm);
        this.saveAgentCardCM(l);
    }

    @Override
    public void saveAgentCardCM(Collection<AgentCardCM> list) throws SQLException {
        this.m_db.saveAgentCMs(list);
        for (AgentCardCM acm : list) {
            this.putAgentCardCM(acm);
        }
    }

    public void putAgentCardCM(AgentCardCM acm) {
        this.m_agentsCM.put(acm.getID(), acm);
    }

    @Override
    public String resolve(String agentID) {
        String retVal = agentID;
        AgentCard ac = this.getAgentCardByID(agentID);
        if (ac != null && "".equals(retVal = ac.getLabel())) {
            retVal = ac.getAgentHost();
        }
        return retVal;
    }

    @Override
    public void addExternalHost(String hostNameOrIP, String agentID) {
        AgentCard ac0 = this.getAgentCardByID(agentID);
        if (ServerEngine.getInstance().getServerProps().getAutoDetectExternalHosts() && hostNameOrIP != null && hostNameOrIP.length() > 0 && ac0 != null && !ac0.getAgentHost().equalsIgnoreCase(hostNameOrIP) && !ac0.getAgentIP().equalsIgnoreCase(hostNameOrIP) && ServerEngine.getInstance().getExternalHostResolver() != null) {
            ServerEngine.getInstance().getExternalHostResolver().offer(hostNameOrIP, agentID);
        }
    }

    @Override
    public void removeFwdAgentCard(String agentID) {
        AgentCard toRemove = null;
        toRemove = this.removeAgentCard(agentID);
        if (toRemove != null) {
            SlaveServerCard ssc = ServerEngine.getInstance().getSlave(toRemove.getRelatedServer());
            if (ssc != null) {
                ssc.removeAgent(toRemove);
                ssc.getServerClient().start("JOB", "DELETE_AGENT", new String[]{agentID});
            }
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        }
    }

    @Override
    public void removeFwdAgentCards(String serverHostname) {
        ArrayList<String> aids = new ArrayList<String>();
        for (Map.Entry<String, AgentCard> en : this.getAgentCards().entrySet()) {
            String id = en.getKey();
            AgentCard ac = en.getValue();
            if (ac == null || !serverHostname.equals(ac.getRelatedServer())) continue;
            aids.add(id);
        }
        for (String aid : aids) {
            this.removeAgentCard(aid);
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
    }

    @Override
    public void setAgentsOffline(String slaveServer) {
    }
}

