/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Asn {
    private String m_name = null;
    private String m_type = null;
    private String m_id = null;
    private Map<String, String> m_agents = new HashMap<String, String>();

    public Asn(String name, String type) throws Exception {
        if (name == null || type == null) {
            throw new Exception("Both assignment's name and type must be not null");
        }
        this.m_name = name;
        this.m_type = type;
        this.m_id = this.m_type + "_" + this.m_name;
    }

    public Asn(String name, String type, String agentIDs) throws Exception {
        this(name, type);
        this.addAgentIDs(agentIDs);
    }

    public void addAgentIDs(String agentIDs) {
        if (agentIDs != null) {
            String[] arr = agentIDs.split(",");
            for (int i = 0; i < arr.length; ++i) {
                this.m_agents.put(arr[i], null);
            }
        }
    }

    public void addAgentIDs(Asn asn) {
        this.m_agents.putAll(asn.m_agents);
    }

    public void removeAgentIDs(String agentIDs) {
        if (agentIDs != null) {
            String[] arr = agentIDs.split(",");
            for (int i = 0; i < arr.length; ++i) {
                this.m_agents.remove(arr[i]);
            }
        }
    }

    public void removeAgentIDs(Asn asn) {
        for (String id : asn.m_agents.keySet()) {
            this.m_agents.remove(id);
        }
    }

    public Collection<String> getAgentIDs() {
        return this.m_agents.keySet();
    }

    public String getAgentIDsString() {
        if (this.m_agents.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = this.getAgentIDs().iterator();
        while (it.hasNext()) {
            String agentID = it.next();
            sb.append(agentID);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.m_agents.size() == 0;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Asn) {
            Asn asn = (Asn)obj;
            return this.m_id.equals(asn.m_id);
        }
        return false;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public String toString() {
        return this.m_id;
    }
}

