/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.SMessage;
import com.blixx.server.ServerAction;
import com.blixx.server.ServerEngine;
import java.util.List;

public class AutoSyncAction
extends ServerAction {
    public AgentCard m_agent = null;
    public boolean m_isSuccess = false;
    public int m_tries = 0;
    public int m_undeployed = 0;
    public int m_deployed = 0;
    public int m_bin_deployed = 0;

    public AutoSyncAction(AgentCard ac) {
        this.m_agent = ac;
        if (this.m_agent == null) {
            throw new RuntimeException("Agent can't be null");
        }
    }

    @Override
    public String getActionID() {
        return "ASA|" + this.m_agent.getAgentID();
    }

    @Override
    public void handleResult() {
        this.m_reschedule = -1;
        if (!this.isSuccess() && this.m_tries < 3) {
            this.m_isSuccess = false;
            ++this.m_tries;
            this.m_reschedule = 60000;
        } else {
            if (!this.isSuccess()) {
                StringBuffer sb = new StringBuffer("Synchronization Action failed for Agent: ");
                sb.append(this.m_agent.getLabel());
                SMessage.sendMessage(this.m_agent, sb.toString(), 4, "Job", "Sync", this.m_agent.getAgentHost(), 0);
            } else {
                StringBuffer sb = new StringBuffer("Synchronization Action finished for Agent: ");
                sb.append(this.m_agent.getLabel()).append('\n').append(" deployed policies: ").append(this.m_deployed).append(" undeployed policies: ").append(this.m_undeployed).append(" deployed binary packages: ").append(this.m_bin_deployed);
                SMessage.sendMessage(this.m_agent, sb.toString(), 1, "Job", "Sync", this.m_agent.getAgentHost(), 0);
            }
            this.m_agent.clearSyncBuffers();
        }
    }

    @Override
    public void onRun() {
        long maxTime = System.currentTimeMillis() + 60000L;
        if (this.m_agent.getMode() == 1 || this.m_agent.getMode() == 8) {
            this.m_isSuccess = false;
            try {
                RemoteCmdClient rcc = this.m_agent.processSyncStatus();
                while (!rcc.isReady && System.currentTimeMillis() < maxTime) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.m_agent.m_lastSyncReport != null) {
                    if (this.m_agent.m_binpackagesUnsync.size() > 0) {
                        this.m_bin_deployed = this.m_agent.m_binpackagesUnsync.size();
                        List<DeployClient> list = ServerEngine.getInstance().getBinariesRepository().deploy(this.m_agent, this.m_agent.m_binpackagesUnsync);
                        DeploymentManager.waitDeploymentsStarted(list);
                    }
                    if (this.m_agent.m_monToUndeploy.size() > 0 || this.m_agent.m_msgToUndeploy.size() > 0) {
                        this.m_undeployed = this.m_agent.m_monToUndeploy.size() + this.m_agent.m_msgToUndeploy.size();
                        ServerEngine.getInstance().getPolicyRepository().undeploy(this.m_agent, this.m_agent.m_monToUndeploy, this.m_agent.m_msgToUndeploy);
                    }
                    if (this.m_agent.m_monToDeploy.size() > 0 || this.m_agent.m_msgToDeploy.size() > 0) {
                        this.m_deployed = this.m_agent.m_monToDeploy.size() + this.m_agent.m_msgToDeploy.size();
                        ServerEngine.getInstance().getPolicyRepository().deploy(this.m_agent, this.m_agent.m_monToDeploy, this.m_agent.m_msgToDeploy);
                    }
                    this.m_isSuccess = true;
                    RTLogger.print(4, "AutoSyncTask ok. {}", this.m_agent);
                } else {
                    RTLogger.print(4, "AutoSyncTask failed (NoSyncReport) for " + String.valueOf(this.m_agent));
                }
            }
            catch (Throwable e) {
                RTLogger.print(4, "AutoSyncTask failed for " + String.valueOf(this.m_agent), e);
            }
        }
    }

    @Override
    public boolean isSuccess() {
        return this.m_isSuccess;
    }

    @Override
    public void onInit() {
        super.onInit();
        SMessage.sendMessage(this.m_agent, "Synchronization Action started for Agent: " + this.m_agent.getLabel(), 1, "Job", "Sync", this.m_agent.getAgentHost(), 0);
    }

    @Override
    public void onReSchedule() {
        super.onReSchedule();
    }
}

