/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.in.ScPutFileFromString;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.GUIClientProxy;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.SlaveServerClient;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.XMLTree;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.server.AgentAfoB2B;
import com.boom.server.AgentAfoB2BList;
import com.boom.server.AgentCardB2B;
import com.boom.server.AgentCardB2BList;
import com.boom.server.AgentOutagesB2B;
import com.boom.server.AssignmentsB2B;
import com.boom.server.ModifyServerPoliciesB2B;
import com.boom.server.ServerOutagesB2B;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public class BackupSlaveServerClient
extends SlaveServerClient {
    private final String serverId;
    private GUIClientProxy indiProxy = null;
    private GUIClientProxy indiProxyOutage = null;
    private final Object internalObj = new Object();
    private String digestHostsFile;

    public BackupSlaveServerClient(SlaveServerCard ssCard, String threadName) {
        super(ssCard, threadName);
        this.serverId = ServerEngine.getInstance().getServerProps().getServerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long lastTimeFullSync = 0L;
            while (this.m_running.get()) {
                try {
                    int res = this.ensureConnect();
                    if (res == 0 || System.currentTimeMillis() - lastTimeFullSync > 300000L) {
                        this.indiProxy = ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().createClientCache("PRIMARY_SERVER", this.ssc.getHostName());
                        this.indiProxyOutage = ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().getClientProxyMgr().createClientCache("PRIMARY_SERVER", this.ssc.getHostName());
                        this.pushAgents();
                        this.pushNodeGroups(this.os, this.is);
                        this.pushAfo(this.os, this.is);
                        this.pushAgtOutages(this.os, this.is);
                        this.pushServerOutages(this.os, this.is);
                        this.pushModifyPolicies(this.os, this.is);
                        this.os.writeUTF("B2B");
                        this.os.writeInt(20);
                        this.processFullIndiSync(this.is, this.os);
                        this.syncAsProxy();
                        this.pushAssignments(this.os, this.is);
                        lastTimeFullSync = System.currentTimeMillis();
                    } else {
                        RTLogger.getStaticLogger().trace("- an iteration to BKPSRV is started");
                        AtomicBoolean isAgentChangesDetected = new AtomicBoolean(false);
                        AtomicBoolean isOutagesChangesDetected = new AtomicBoolean(false);
                        AtomicBoolean isAssignmentChangesDetected = new AtomicBoolean(false);
                        AtomicBoolean isSyncPolBinPgaDetected = new AtomicBoolean(false);
                        AtomicBoolean isNodeGroupTreeChangeDetected = new AtomicBoolean(false);
                        this.indiProxy.getPending().forEach(cmd -> {
                            switch (cmd.m_command) {
                                case "GETAGENTCARD_SINGLE": 
                                case "GETAGENTCARDS": 
                                case "GETAGENTCARDS_LIST": {
                                    isAgentChangesDetected.set(true);
                                    break;
                                }
                                case "GET_SERVER_POLICIES_STATUS_EXT": 
                                case "GET_SERVER_POLICIES_STATUS": 
                                case "GET_SERVER_POLICIES_STATUS_AOP": 
                                case "GET_SERVER_POLICIES_STATUS_MOD": {
                                    isOutagesChangesDetected.set(true);
                                    break;
                                }
                                case "GET_ALL_ASSIGNMENTS": {
                                    isAssignmentChangesDetected.set(true);
                                    break;
                                }
                                case "GETPOLICIES": 
                                case "GETASSIGNMENTS": 
                                case "GETACTIONS": 
                                case "GETBINARIES": {
                                    isSyncPolBinPgaDetected.set(true);
                                    break;
                                }
                                case "CMD_GET_NODEGROUPS_XML_GTO": 
                                case "REFRESH_NODEGROUPS": {
                                    isNodeGroupTreeChangeDetected.set(true);
                                    break;
                                }
                                default: {
                                    RTLogger.getStaticLogger().debug("Not supported CMD notification : {}", (Object)cmd.m_command);
                                }
                            }
                        });
                        this.indiProxy.getPending().clear();
                        if (isAgentChangesDetected.get()) {
                            this.pushAgents();
                        }
                        if (isOutagesChangesDetected.get()) {
                            this.pushAgtOutages(this.os, this.is);
                            this.pushServerOutages(this.os, this.is);
                            this.pushModifyPolicies(this.os, this.is);
                        }
                        if (isNodeGroupTreeChangeDetected.get()) {
                            this.pushNodeGroups(this.os, this.is);
                        }
                        this.os.writeUTF("B2B");
                        this.os.writeInt(21);
                        this.pushIndiUpdates(this.serverId, this.indiProxy, this.os, this.is);
                        this.pushIndiUpdates(this.serverId, this.indiProxyOutage, this.os, this.is);
                        if (isAssignmentChangesDetected.get()) {
                            this.pushAssignments(this.os, this.is);
                        }
                        if (isSyncPolBinPgaDetected.get()) {
                            this.syncAsProxy();
                        }
                        this.pushAfo(this.os, this.is);
                        RTLogger.getStaticLogger().trace("- an iteration to BKPSRV is finished");
                    }
                    this.pushEtcHosts(this.os, this.is);
                    this.os.writeUTF("CLEAR_PENDING");
                    this.is.readUTF();
                    this.ssc.getServerClient();
                }
                catch (Throwable e) {
                    this.ensureDisconnect(e);
                    Object object = this.internalObj;
                    synchronized (object) {
                        this.internalObj.wait(5000L);
                    }
                }
                Object object = this.internalObj;
                synchronized (object) {
                    this.internalObj.wait(1000L);
                }
            }
            this.isONLINE.set(0);
        }
        catch (Exception e) {
            RTLogger.print(3, this.getName() + "stopped", e);
        }
        finally {
            this.m_stopped.set(true);
        }
    }

    public void processFullIndiSync(SDataInputStream is, SDataOutputStream os) throws IOException {
        this.pushIndis(is, os, this.serverId, () -> ServerEngine.getInstance().getEventsRouter().getEventOperations().getActiveIndications(false));
        this.pushIndis(is, os, this.serverId, () -> ServerEngine.getInstance().getEventsRouter().getEventOperations().getAcknowledgedIndications(false));
        this.pushIndis(is, os, this.serverId, () -> ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().getActiveIndications(false));
        this.pushIndis(is, os, this.serverId, () -> ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().getAcknowledgedIndications(false));
    }

    private void pushAgents() throws IOException {
        List<AgentCardB2B> agents = ServerEngine.getInstance().getAgentRepository().getAgentCards().values().stream().filter(AgentCard::isLocalAgent).filter(AbstractAgentCard::isApproved).map(ac -> {
            AgentCardB2B acb = null;
            try {
                Certificate cert;
                acb = new AgentCardB2B((AbstractAgentCard)ac);
                AgentCardCM acm = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(ac.getAgentID());
                if (acm != null) {
                    acb.setAttributes(acm.getAttributes());
                }
                if ((cert = (Certificate)ServerEngine.getInstance().getAgentCertificates().getAgentCert(ac.getAgentID()).orElse(null)) != null) {
                    acb.setCertificate(new String(CertificateSerializationHelper.serializeCertificate(cert)));
                }
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().warn("Error processing agent {} ", (Object)acb, (Object)e);
            }
            return acb;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        AgentCardB2BList signal = new AgentCardB2BList();
        signal.setAgents(agents);
        String json = new GsonBuilder().create().toJson(signal);
        this.os.writeUTF("B2B");
        this.os.writeInt(1);
        this.os.writeUTF(json);
        String result = this.is.readUTF();
        if (!"T".equals(result)) {
            RTLogger.getStaticLogger().warn("Error sending agents to BKPSRV. {}", (Object)result);
        } else {
            RTLogger.getStaticLogger().trace("Agents pushed to BKPSRV");
        }
    }

    public void pushAgtOutages(SDataOutputStream os, SDataInputStream is) throws IOException {
        ArrayList<AgentOutagePolicy> policies = new ArrayList<AgentOutagePolicy>(ServerEngine.getInstance().getEventsRouter().getAgentOutageMgr().getAllPolicies().values());
        AgentOutagesB2B payload = new AgentOutagesB2B();
        payload.setAgtOutages(policies);
        os.writeUTF("B2B");
        os.writeInt(2);
        os.writeUTF(new GsonBuilder().create().toJson(payload));
        if (!"T".equals(is.readUTF())) {
            throw new IOException("AOP sync is failed");
        }
        RTLogger.getStaticLogger().debug("pushed {} AOPs to BKPSRV", (Object)policies.size());
    }

    public void pushServerOutages(SDataOutputStream os, SDataInputStream is) throws IOException {
        ArrayList<OutagePolicy> policies = new ArrayList<OutagePolicy>(ServerEngine.getInstance().getEventsRouter().getOutageMgr().getAllPolicies().values());
        ServerOutagesB2B payload = new ServerOutagesB2B();
        payload.setSrvOutages(policies);
        os.writeUTF("B2B");
        os.writeInt(3);
        os.writeUTF(new GsonBuilder().create().toJson(payload));
        if (!"T".equals(is.readUTF())) {
            throw new IOException("SOP sync is failed");
        }
        RTLogger.getStaticLogger().debug("pushed {} SOPs to BKPSRV", (Object)policies.size());
    }

    public void pushModifyPolicies(SDataOutputStream os, SDataInputStream is) throws IOException {
        ArrayList<ExtendedServerPolicy> policies = new ArrayList<ExtendedServerPolicy>(ServerEngine.getInstance().getEventsRouter().getModifyIndicationMgr().getAllPolicies().values());
        ModifyServerPoliciesB2B payload = new ModifyServerPoliciesB2B();
        payload.setModPolicies(policies);
        os.writeUTF("B2B");
        os.writeInt(4);
        os.writeUTF(new GsonBuilder().create().toJson(payload));
        if (!"T".equals(is.readUTF())) {
            throw new IOException("MOP sync is failed");
        }
        RTLogger.getStaticLogger().debug("pushed {} MOPs to BKPSRV", (Object)policies.size());
    }

    public void pushAssignments(SDataOutputStream os, SDataInputStream is) throws IOException {
        AssignmentsB2B payload = new AssignmentsB2B();
        payload.setAssignments(ServerEngine.getInstance().getAssignmentRepository().getAssignments());
        os.writeUTF("B2B");
        os.writeInt(10);
        os.writeUTF(new GsonBuilder().create().toJson(payload));
        if (!"T".equals(is.readUTF())) {
            throw new IOException("ASN sync is failed");
        }
        RTLogger.getStaticLogger().debug("pushed {} assignments to BKPSRV", (Object)payload.getAssignments().size());
    }

    public void pushIndis(SDataInputStream is, SDataOutputStream os, String serverId, Supplier<List<SEventFwd>> indisSupplier) throws IOException {
        os.writeUTF(serverId);
        long timefrom = is.readLong();
        RTLogger.getStaticLogger().debug("BKPSRV wants data from {}", (Object)new Date(timefrom));
        List<SEventFwd> activeAndInsertedAsClosed = indisSupplier.get();
        AtomicBoolean error = new AtomicBoolean(false);
        AtomicInteger start = new AtomicInteger(0);
        int blockSize = 5000;
        while (!error.get() && !activeAndInsertedAsClosed.isEmpty() && start.get() <= activeAndInsertedAsClosed.size()) {
            os.writeBoolean(true);
            HashMap eventsBlock = new HashMap(5000);
            activeAndInsertedAsClosed.stream().filter(e -> timefrom <= e.getSTime()).skip(start.get()).limit(5000L).forEach(e -> {
                try {
                    os.writeBoolean(true);
                    String id = e.getID();
                    os.writeUTF(id);
                    os.writeUTF(e.getB2bHash());
                    eventsBlock.put(e.getID(), e);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    RTLogger.getStaticLogger().warn("Error sending data to BKP. {} of {}", (Object)start, (Object)activeAndInsertedAsClosed.size());
                    error.set(true);
                }
            });
            if (error.get()) {
                throw new IOException("unable to send data to BKPSRV");
            }
            os.writeBoolean(false);
            ArrayList<String> requestEventIDs = new ArrayList<String>(eventsBlock.size() / 2);
            if (is.readBoolean()) {
                if (!is.readBoolean()) {
                    while (is.readBoolean()) {
                        requestEventIDs.add(is.readUTF());
                    }
                    eventsBlock.keySet().retainAll(requestEventIDs);
                    RTLogger.getStaticLogger().debug("Requested from BKPSRV: {} events", (Object)requestEventIDs.size());
                } else {
                    RTLogger.getStaticLogger().debug("BKPSRV wants all");
                }
                for (SEventFwd sef : eventsBlock.values()) {
                    os.writeBoolean(true);
                    sef.sendSv2(os);
                }
                os.writeBoolean(false);
            }
            start.addAndGet(5000);
        }
        os.writeBoolean(false);
        RTLogger.getStaticLogger().debug("BKPSRV event sync finished");
    }

    public void pushIndiUpdates(String serverId, GUIClientProxy indiProxy, SDataOutputStream os, SDataInputStream is) throws IOException {
        os.writeUTF(serverId);
        SEventFwd sef = null;
        int max = 10000;
        os.writeInt(1);
        while ((sef = indiProxy.getNew().poll()) != null && --max > 0) {
            os.writeBoolean(true);
            sef.sendSv2(os);
        }
        os.writeBoolean(false);
        String res = is.readUTF();
        if (!"T".equals(res)) {
            RTLogger.getStaticLogger().info("Error pushing new indis to BKPSRV. {}", (Object)res);
            return;
        }
        if (max < 1000) {
            RTLogger.getStaticLogger().info("pushed new indis to BKPSRV. count={}", (Object)(1000 - max));
        }
        os.writeInt(2);
        max = 10000;
        while ((sef = indiProxy.getUpdated().poll()) != null && --max > 0) {
            os.writeBoolean(true);
            sef.sendSv2(os);
        }
        os.writeBoolean(false);
        res = is.readUTF();
        if (!"T".equals(res)) {
            RTLogger.getStaticLogger().info("Error pushing updated indis to BKPSRV. {}", (Object)res);
            return;
        }
        if (max < 1000) {
            RTLogger.getStaticLogger().info("pushed updated indis to BKPSRV. count={}", (Object)(1000 - max));
        }
        os.writeInt(3);
        String closedID = null;
        max = 10000;
        while ((closedID = indiProxy.getDeleted().poll()) != null && --max > 0) {
            os.writeBoolean(true);
            os.writeUTF(closedID);
        }
        os.writeBoolean(false);
        res = is.readUTF();
        if (!"T".equals(res)) {
            RTLogger.getStaticLogger().info("Error pushing closed indis to BKPSRV. {}", (Object)res);
            return;
        }
        if (max < 1000) {
            RTLogger.getStaticLogger().info("pushed closed Indis to BKPSRV. count={}", (Object)(1000 - max));
        }
        os.writeInt(4);
        String archivedID = null;
        max = 10000;
        while ((archivedID = indiProxy.getArchived().poll()) != null && --max > 0) {
            os.writeBoolean(true);
            os.writeUTF(archivedID);
        }
        os.writeBoolean(false);
        res = is.readUTF();
        if (!"T".equals(res)) {
            RTLogger.getStaticLogger().info("Error pushing archived indis to BKPSRV. {}", (Object)res);
            return;
        }
        if (max < 1000) {
            RTLogger.getStaticLogger().info("pushed archived Indis to BKPSRV. count={}", (Object)(1000 - max));
        }
    }

    private void syncAsProxy() {
        try {
            RTLogger.getStaticLogger().info("push p/b/ag");
            ServerEngine.getInstance().getServerJobManager().runJobOnce("Synchronize_PROXY_Slaves");
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().warn("Error sync p/b/ag", e);
        }
    }

    private void pushAfo(SDataOutputStream os, SDataInputStream is) {
        try {
            List<AgentAfoB2B> list = ServerEngine.getInstance().getAgentRepository().getAgentCards().values().stream().filter(AbstractAgentCard::isFirewalled).filter(AbstractAgentCard::isOnline).map(ac -> new AgentAfoB2B(ac.getAgentID(), ac.getLastTimeOnline())).collect(Collectors.toList());
            AgentAfoB2BList payload = new AgentAfoB2BList(list);
            os.writeUTF("B2B");
            os.writeInt(5);
            os.writeUTF(new GsonBuilder().create().toJson(payload));
            String res = is.readUTF();
            if (!"T".equals(res)) {
                RTLogger.getStaticLogger().info("Error pushing AFOs to BKPSRV. {}", (Object)res);
            }
        }
        catch (Exception e) {
            RTLogger.getStaticLogger().warn("Error AFO sync", e);
        }
    }

    private void pushNodeGroups(SDataOutputStream os, SDataInputStream is) throws Exception {
        GroupTreeObject ngTree = NodeGroupRepository.getInstance().getNodeGroupTree();
        Document d = new XMLTree().getXML(ngTree);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLFactory.writeXml(d, baos);
        ScPutFileFromString sc = new ScPutFileFromString(this.ssc, NodeGroupRepository.getInstance().getNodeGroupXMLFile(), baos.toString());
        sc.runDirect(is, os);
        RTLogger.getStaticLogger().debug("NodeGroupTree pushed to BKPSRV");
    }

    private void pushEtcHosts(SDataOutputStream os, SDataInputStream is) throws Exception {
        String content = ServerEngine.getInstance().getHostnameResolver().getFileContent();
        if (content != null) {
            try {
                String digestHostsFileTmp = FileSyncUtils.getDigest("hosts", content);
                if (!Objects.equals(this.digestHostsFile, digestHostsFileTmp)) {
                    ScPutFileFromString sc = new ScPutFileFromString(this.ssc, "srv/etc/hosts", content);
                    sc.runDirect(is, os);
                    RTLogger.getStaticLogger().debug("srv/etc/hosts pushed to BKPSRV");
                    this.digestHostsFile = digestHostsFileTmp;
                }
            }
            catch (Exception e) {
                RTLogger.getStaticLogger().debug("Error push srv/etc/hosts to BKPSRV", e);
            }
        }
    }
}

