/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentCloseSocket;
import com.blixx.server.DeploymentTrigger;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.SMessage;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.utils.DeployType;
import com.blixx.shared.Assignment;
import com.blixx.shared.BM;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.utils.NameValue;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeployClient
implements IRemoteProcessing {
    public static final int OK = 30;
    public static final int CANCELED = 25;
    public static final int FAILED = 20;
    public static final int EXPIRED = 15;
    public static final int RUNNING = 10;
    public static final int WAITING_AGENT = 2;
    public static final int WAITING_SLOT = 1;
    public static final int CREATED = 0;
    public static final int MINUTES_20 = 1200000;
    private static final int TIMEOUT = 120000;
    private final ServerEngine serverEngine;
    private AgentCard m_card = null;
    private List<File> m_file = new LinkedList<File>();
    private DeployType m_type = DeployType.DEPLOY_AGENT;
    private List<String> m_monitors = null;
    private List<String> m_messages = null;
    private String m_package = null;
    private Socket m_socket = null;
    private SDataInputStream m_is = null;
    private SDataOutputStream m_os = null;
    private ExecResult er = new ExecResult();
    protected AtomicBoolean isFinished = new AtomicBoolean(false);
    long m_initTime = System.currentTimeMillis();
    long m_expire_time = this.m_initTime + 1200000L;
    int m_state = 0;
    String m_ID = null;

    protected DeployClient(DeployType type, AgentCard card) {
        this.m_type = type;
        this.m_card = card;
        this.m_ID = UUID.randomUUID().toString();
        this.serverEngine = ServerEngine.getInstance();
    }

    public DeployClient(AgentCard ac) {
        this(DeployType.DEPLOY_AGENT, ac);
        this.m_file.add(new File("srv/deploy/agent/" + BM.PRODUCT_lowercase + "_agent.jar"));
    }

    public DeployClient(DeployType type, AgentCard card, String binPkgName) {
        this(type, card);
        this.m_package = binPkgName;
    }

    public DeployClient(AgentCard ac, List<String> policies) {
        this(DeployType.DEPLOY_POLICIES, ac);
        SPolicyRepository polRepo = this.serverEngine.getPolicyRepository();
        for (String policyName : policies) {
            String fileNameOnly = polRepo.getFilename(policyName);
            if (fileNameOnly != null) {
                String filename = SPolicyRepository.getPolicyDir() + File.separator + fileNameOnly;
                this.m_file.add(new File(filename));
                continue;
            }
            this.sendErrorMessage("Policy '" + policyName + "' was deleted from server. Deployment impossible.");
        }
    }

    public DeployClient(AgentCard ac, List<String> undeployMonPolicies, List<String> undeployMsgPolicies) {
        this(DeployType.UNDEPLOY_POLICIES, ac);
        this.m_monitors = new ArrayList<String>(undeployMonPolicies);
        this.m_messages = new ArrayList<String>(undeployMsgPolicies);
    }

    public String getID() {
        return this.m_ID;
    }

    void sendErrorMessage(String text) {
        String what = this.m_type.toString();
        String grp = "DEPLOY";
        switch (this.m_type) {
            case UNDEPLOY_PACKAGES: {
                what = "PACKAGE";
                grp = "UNDEPLOY";
                break;
            }
            case DEPLOY_PACKAGES: {
                what = "PACKAGE";
                grp = "DEPLOY";
                break;
            }
            case DEPLOY_POLICIES: {
                what = "POLICY";
                grp = "DEPLOY";
                break;
            }
            case UNDEPLOY_POLICIES: {
                what = "POLICY";
                grp = "UNDEPLOY";
                break;
            }
        }
        SMessage.sendMessage(this.m_card, text, 4, grp, what, this.m_card.getAgentHost(), 0);
    }

    @Override
    public long getInitTime() {
        return this.m_initTime;
    }

    @Override
    public long getExpireTime() {
        return this.m_expire_time;
    }

    @Override
    public void extendExpireTimePlus10Minutes() {
        this.m_expire_time = System.currentTimeMillis() + 600000L;
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.getExpireTime();
    }

    @Override
    public void sendToFirewalled(Socket socket) throws Throwable {
        try {
            this.m_state = 10;
            if (socket != null) {
                socket.setSoTimeout(120000);
                socket.setTcpNoDelay(true);
                socket.setSoLinger(true, 1);
            }
            if (this.m_type == DeployType.UNDEPLOY_POLICIES) {
                this.processUnDeploy(this.m_is, this.m_os, this.m_card);
            } else {
                this.m_os.write(66);
                this.m_os.writeInt(this.m_file.size());
                int i = 0;
                Iterator<File> it = this.m_file.iterator();
                SDataInputStream resultStream = null;
                while (it.hasNext()) {
                    File file = it.next();
                    resultStream = this.sendFile(this.m_is, this.m_os, file, i, this.m_card);
                    ++i;
                    this.m_card.setLastTimeOnline();
                }
                if (this.m_card.isIoTHub()) {
                    this.m_is = resultStream;
                }
                if (this.m_is == null) {
                    throw new RuntimeException("Agent failed to process data. Result stream is null.");
                }
                int ch = this.m_is.read();
                if (ch != 84) {
                    throw new RuntimeException("Agent failed to process data");
                }
            }
            this.finishedOk();
        }
        catch (Throwable e) {
            this.failedToProcess(e);
            throw e;
        }
    }

    @Override
    public void failedToProcess(Throwable e) {
        this.setFinished(20);
        String error = e.getMessage() != null ? e.getMessage() : e.getClass().getName();
        this.getResult().m_errorMessages.add("Communication error: " + error);
        this.checkTaskResult();
    }

    @Override
    public void run() {
        DeploymentTrigger.increaseDeploymentsRunning();
        try {
            if (this.m_is == null && !this.m_card.isIoTHub()) {
                try {
                    this.openStreams();
                }
                catch (AgentCloseSocket e) {
                    Thread.sleep(200L);
                    this.openStreams();
                }
            }
            this.sendToFirewalled(this.m_socket);
        }
        catch (Throwable e) {
            RTLogger.print(3, "deployment failed on " + String.valueOf(this.getAgentCard()), e);
            if (!this.isReady()) {
                this.failedToProcess(e);
            } else {
                this.setFinished(20);
            }
        }
        finally {
            DeploymentTrigger.decreaseDeploymentsRunning();
            try {
                this.closeStreams();
            }
            catch (Throwable e) {}
        }
    }

    private void openStreams() throws IOException, AgentCloseSocket {
        this.m_socket = SocketUtils.getNewSocket(120000);
        try {
            InetSocketAddress agentAddrByHost = new InetSocketAddress(this.m_card.getAgentHost(), this.m_card.getAgentPort());
            if (agentAddrByHost.isUnresolved()) {
                throw new RuntimeException("Change to IP");
            }
            this.m_socket.connect(agentAddrByHost, 10000);
        }
        catch (Throwable e) {
            SocketUtils.closeSocket(this.m_socket, new AutoCloseable[0]);
            this.m_socket = SocketUtils.getNewSocket(120000);
            this.m_socket.connect(new InetSocketAddress(this.m_card.getAgentIP(), this.m_card.getAgentPort()), 10000);
        }
        try {
            if (this.m_card.isTlsAgent()) {
                this.m_socket = TlsUtils.upgradeClientSocket(this.m_socket, this.serverEngine.getCertificateManager());
            }
            this.m_is = new SDataInputStream(this.m_socket.getInputStream());
            this.m_os = new SDataOutputStream(this.m_socket.getOutputStream(), this.m_card.getProtocolVersion());
        }
        catch (Exception e) {
            throw new AgentCloseSocket();
        }
    }

    private void closeStreams() {
        if (this.m_socket != null) {
            SocketUtils.closeSocket(this.m_socket, this.m_os, this.m_is);
            this.m_is = null;
            this.m_os = null;
            this.m_socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDataInputStream sendFile(SDataInputStream is, SDataOutputStream os, File fileToSend, int i, AgentCard ac) throws FileNotFoundException, IOException {
        this.er.resultCode = 0;
        String filename = fileToSend.getName();
        try (FileInputStream fis = new FileInputStream(fileToSend);){
            os.writeUTF(this.m_type.toString());
            os.writeUTF(filename);
            try {
                os.writeFile(fis);
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            int count = -1;
            try {
                count = is.readInt();
                if (count == -1) {
                    throw new IOException("Deployment confirmation not arrived");
                }
                if (filename.endsWith(".mon.xml")) {
                    String pName = filename.replace(".mon.xml", "");
                    this.serverEngine.getAssignmentRepository().setUploaded(this.m_card.getAgentID(), pName, "mon");
                } else if (filename.endsWith(".msg.xml")) {
                    String pName = filename.replace(".msg.xml", "");
                    this.serverEngine.getAssignmentRepository().setUploaded(this.m_card.getAgentID(), pName, "msg");
                } else if (this.m_type == DeployType.DEPLOY_PACKAGES) {
                    String pName = filename.substring(0, filename.lastIndexOf(95));
                    this.serverEngine.getAssignmentRepository().setUploaded(this.m_card.getAgentID(), pName, "pkg");
                } else if (this.m_type == DeployType.UNDEPLOY_PACKAGES) {
                    String pName = filename.substring(0, filename.lastIndexOf(95));
                    this.serverEngine.getAssignmentRepository().setUndeployed(this.m_card.getAgentID(), pName, "pkg");
                }
            }
            catch (SocketTimeoutException timeout) {
                RTLogger.print(3, this.m_card.getAgentHost() + "DeployClient received timeout during deployment of :" + filename);
            }
        }
        this.er.m_outMessages.add("Deployed: " + filename);
        return is;
    }

    public void processUnDeploy(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
        os.write(85);
        os.writeUTF("mon");
        int size = 0;
        if (this.m_monitors != null) {
            size = this.m_monitors.size();
        }
        os.writeInt(size);
        for (int i = 0; this.m_monitors != null && i < this.m_monitors.size(); ++i) {
            String pName = this.m_monitors.get(i);
            os.writeUTF(pName);
        }
        os.writeUTF("msg");
        int size2 = 0;
        if (this.m_messages != null) {
            size2 = this.m_messages.size();
        }
        os.writeInt(size2);
        for (int i = 0; this.m_messages != null && i < this.m_messages.size(); ++i) {
            String pName = this.m_messages.get(i);
            os.writeUTF(pName);
        }
        int ch = is.read();
        if (ch == 84) {
            String pName;
            int i;
            for (i = 0; this.m_monitors != null && i < this.m_monitors.size(); ++i) {
                pName = this.m_monitors.get(i);
                this.serverEngine.getAssignmentRepository().setUndeployed(this.m_card.getAgentID(), pName, "mon");
            }
            for (i = 0; this.m_messages != null && i < this.m_messages.size(); ++i) {
                pName = this.m_messages.get(i);
                this.serverEngine.getAssignmentRepository().setUndeployed(this.m_card.getAgentID(), pName, "msg");
            }
        } else {
            throw new IOException("Agent does not confirm success");
        }
    }

    @Override
    public void setInputOutput(SDataInputStream is, SDataOutputStream os) {
        this.m_is = is;
        this.m_os = os;
    }

    @Override
    public ExecResult getResult() {
        return this.er;
    }

    @Override
    public boolean isReady() {
        return this.isFinished.get();
    }

    public boolean isFinishedOk() {
        return 30 == this.getState();
    }

    @Override
    public AgentCard getAgentCard() {
        return this.m_card;
    }

    public void cancel() {
        this.setFinished(25);
        this.checkTaskResult();
    }

    public void expire() {
        this.setFinished(15);
        this.checkTaskResult();
    }

    private void deleteFiles() {
        if ((this.m_type == DeployType.DEPLOY_PACKAGES || this.m_type == DeployType.UNDEPLOY_PACKAGES) && this.m_file != null) {
            for (File f : this.m_file) {
                if (f.delete()) continue;
                RTLogger.print(3, "can't delete temp file: " + f.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTaskResult() {
        try {
            StringBuilder text = new StringBuilder();
            switch (this.m_type) {
                case UNDEPLOY_PACKAGES: 
                case UNDEPLOY_POLICIES: {
                    text.append("UnDeploy");
                    break;
                }
                default: {
                    text.append("Deploy");
                }
            }
            text.append(" task ");
            switch (this.getState()) {
                case 30: {
                    if (RTLogger.getCurrentLevel() < 4) break;
                    text.append("done. ").append(this);
                    RTLogger.print(4, text);
                    break;
                }
                case 25: {
                    text.append("canceled ");
                    break;
                }
                case 15: {
                    text.append("expired ");
                    break;
                }
                case 20: {
                    text.append("failed ");
                    break;
                }
            }
            text.append(" for Agent: ").append(this.m_card.getLabel());
            if (this.m_messages != null && this.m_messages.size() > 0) {
                text.append('\n').append(this.m_messages).append('\n');
            }
            if (this.m_monitors != null && this.m_monitors.size() > 0) {
                text.append('\n').append(this.m_monitors).append('\n');
            }
            if (this.m_file != null && this.m_file.size() > 0) {
                text.append('\n').append(this.m_file).append('\n');
            }
            if (this.getState() != 30) {
                if (this.er.m_errorMessages != null && !this.er.m_errorMessages.isEmpty()) {
                    for (String err : this.er.m_errorMessages) {
                        text.append(err).append('\n');
                    }
                }
                this.sendErrorMessage(text.toString());
            }
            List<NameValue<String>> allAssignments = this.getAllObjects();
            for (NameValue<String> nv : allAssignments) {
                Assignment asn = this.serverEngine.getAssignmentRepository().getAssignment(this.getAgentCard().getAgentID(), nv.getName(), nv.getValue());
                if (asn == null) continue;
                if (asn.getLock() > 100) {
                    asn.setLock(asn.getLock() - 100);
                }
                if (this.getState() == 30) continue;
                this.serverEngine.getAssignmentRepository().cancelDelayed(Arrays.asList(asn.getID()), "canceled");
            }
        }
        catch (Throwable e) {
            RTLogger.print(4, "", e);
        }
        finally {
            this.deleteFiles();
        }
    }

    public String toString() {
        StringBuilder what = new StringBuilder("DC type=");
        what.append((Object)this.m_type).append(' ');
        what.append(this.m_state).append(' ');
        if (DeployType.UNDEPLOY_POLICIES == this.m_type || DeployType.DEPLOY_POLICIES == this.m_type) {
            if (this.m_messages != null && this.m_messages.size() > 0) {
                what.append(this.m_messages).append('\n');
            }
            if (this.m_monitors != null && this.m_monitors.size() > 0) {
                what.append(this.m_monitors).append('\n');
            }
        } else if (this.m_file != null) {
            for (int i = 0; i < this.m_file.size(); ++i) {
                what.append(this.m_file.get(i).getName());
                what.append('\n');
            }
        }
        return what.toString();
    }

    public int getState() {
        return this.m_state;
    }

    public List<File> getFiles() {
        return this.m_file;
    }

    public List<String> getMonitors() {
        return this.m_monitors;
    }

    public List<String> getMessages() {
        return this.m_messages;
    }

    public DeployType getType() {
        return this.m_type;
    }

    public String getPackageName() {
        return this.m_package;
    }

    public List<NameValue<String>> getAllObjects() {
        LinkedList<NameValue<String>> objects = new LinkedList<NameValue<String>>();
        if (DeployType.DEPLOY_AGENT != this.getType()) {
            if (this.m_file != null && this.m_file.size() > 0) {
                for (File file : this.m_file) {
                    String filename = file.getName();
                    String pName = null;
                    String pType = null;
                    try {
                        if (filename.endsWith(".mon.xml")) {
                            pName = filename.replace(".mon.xml", "");
                            pType = "mon";
                        } else if (filename.endsWith(".msg.xml")) {
                            pName = filename.replace(".msg.xml", "");
                            pType = "msg";
                        } else if (this.m_type == DeployType.DEPLOY_PACKAGES || this.m_type == DeployType.UNDEPLOY_PACKAGES) {
                            pName = filename.substring(0, filename.lastIndexOf(95));
                            pType = "pkg";
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (pName == null || pType == null) continue;
                    objects.add(new NameValue<String>(pName, pType));
                }
            }
            if (this.m_messages != null && this.m_messages.size() > 0) {
                for (String pName : this.m_messages) {
                    objects.add(new NameValue<String>(pName, "msg"));
                }
            }
            if (this.m_monitors != null && this.m_monitors.size() > 0) {
                for (String pName : this.m_monitors) {
                    objects.add(new NameValue<String>(pName, "mon"));
                }
            }
        }
        return objects;
    }

    public void finishedOk() {
        this.setFinished(30);
        this.checkTaskResult();
    }

    public void setFinished(int state) {
        this.m_state = state;
        this.isFinished.set(true);
    }
}

