/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.IEventProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventBatchJob
extends Thread {
    List<String> m_elements = new ArrayList<String>();
    String m_operator = null;
    int mode = 1;
    boolean m_deleteOnly = false;
    IEventProcessor m_eo = null;
    private static ReadWriteLock m_lock = new ReentrantReadWriteLock();

    public EventBatchJob(IEventProcessor eo, List<String> array, boolean deleteOnly) {
        this.setName("ArchivingDB");
        this.m_elements = array;
        this.mode = 2;
        this.m_deleteOnly = deleteOnly;
        this.m_eo = eo;
    }

    public EventBatchJob(IEventProcessor eo, List<String> array, String operator, boolean deleteOnly) {
        this.setName("ClosingDB");
        this.m_elements = array;
        this.m_operator = operator;
        this.mode = 1;
        this.m_deleteOnly = deleteOnly;
        this.m_eo = eo;
    }

    @Override
    public void run() {
        m_lock.writeLock().lock();
        try {
            if (this.mode == 1) {
                this.m_eo.acknowledge2(this.m_elements, this.m_operator);
            } else {
                this.m_eo.archive2(this.m_elements, this.m_deleteOnly);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "error batch event processing.", e);
        }
        finally {
            m_lock.writeLock().unlock();
        }
    }
}

