/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.FA;
import com.blixx.server.AgentCard;
import com.blixx.server.AutoActionLocalJob;
import com.blixx.server.AutoActionServerAction;
import com.blixx.server.GUIClientProxy;
import com.blixx.server.GUIClientProxyMgr;
import com.blixx.server.IEventProcessor;
import com.blixx.server.RemoteAction;
import com.blixx.server.SMessage;
import com.blixx.server.ServerActionsManager;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.cube.Cube;
import com.blixx.server.db.AnnotationInsertTask;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBException;
import com.blixx.server.ext.EventIterator;
import com.blixx.server.ext.ForwardManager;
import com.blixx.server.perf.IEventComparator;
import com.blixx.shared.Annotation;
import com.blixx.shared.BM;
import com.blixx.shared.HashCode;
import com.blixx.shared.IEvent;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.SEventFwdCompare;
import com.blixx.shared.utils.HashMapMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class EventOperations
implements IEventProcessor {
    public static final String AUTO_CLOSED_FINISHED_ALERT = "AutoClosedFinishedAlert";
    public static final String PRIME = "P";
    protected ServerEngine m_serverEngine = null;
    protected static ExecutorService executorService = Executors.newFixedThreadPool(1);
    protected static final String SERVER_DB_IS_ONLINE = "Server DB is online";
    protected static final String SERVER_LOST_CONNECTION_WITH_DB = "Server lost connection with DB";
    protected static final String KEY_DB_UP = "BOOM_SERVER:RUNTIME:DB:CLEAR";
    protected static final String CLOSEKEY_DB_DOWN = "BOOM_SERVER:RUNTIME:DB:<*>";
    protected static final String KEY_DB_DOWN = "BOOM_SERVER:RUNTIME:DB:ERROR";
    public static final String OUT_OF_LICENSE = "OutOfLicense";
    protected ConcurrentHashMap<String, SEventFwd> m_activeAndInsertedAsClosed = new ConcurrentHashMap(2000, 0.8f, 100);
    protected ConcurrentHashMap<String, SEventFwd> m_closed = new ConcurrentHashMap(10000, 0.8f, 100);
    public DB m_db = null;
    protected final Map<String, SEventFwd> m_DBnewORupdate = new LinkedHashMap<String, SEventFwd>();
    protected final Map<String, SEventFwd> m_DBnewORupdateEXT = new LinkedHashMap<String, SEventFwd>();
    protected final Map<String, SEventFwd> m_DBacknByNewMsg = new LinkedHashMap<String, SEventFwd>();
    protected final Map<String, SEventFwd> m_DBUpdateDuplicateCounts = new LinkedHashMap<String, SEventFwd>();
    protected final Map<String, SEventFwd> m_DBsetDeleted = new LinkedHashMap<String, SEventFwd>();
    protected final Map<String, SEventFwd> m_DBOnlyDeleteNOArchive = new LinkedHashMap<String, SEventFwd>();
    protected final HashMapMap<String, Annotation> m_DBannotations = new HashMapMap();
    protected ConcurrentLinkedQueue<SEventFwd> m_failedToInsertOrUpdate = new ConcurrentLinkedQueue();
    protected AtomicBoolean m_failedToInsertOrUpdateSAVETrigger = new AtomicBoolean(false);
    protected GUIClientProxyMgr m_clientCacheMgr = null;
    protected ConcurrentHashMap<HashCode, String> m_msgkeys = new ConcurrentHashMap(2000, 0.8f, 100);
    protected AtomicLong m_timeProcessing = new AtomicLong(0L);
    protected AtomicLong m_maxTimeProcessing = new AtomicLong(0L);
    protected AtomicBoolean m_DBConnectionOK = new AtomicBoolean(true);
    protected Map<String, Object> m_monitoredHosts = new ConcurrentHashMap<String, Object>(100, 0.9f, 2);
    protected ReadWriteLock m_monitoredHostsLock = new ReentrantReadWriteLock();
    public double m_weightedAverage = 0.0;
    public AtomicLong m_weightedAverageCount = new AtomicLong(0L);
    public IEventComparator m_AscComparator = new IEventComparator(false);
    public IEventComparator m_DescComparator = new IEventComparator(true);
    protected Map<String, Long> processedAKeys = new ConcurrentHashMap<String, Long>(1000, 0.9f, 100);
    protected AnnotationInsertTask m_annInsTask = new AnnotationInsertTask(this.m_DBannotations);
    protected Cube m_cube = null;
    ConcurrentHashMap<HashCode, SEventFwd> inProcessing = new ConcurrentHashMap();

    public EventOperations(ServerEngine se, DB db, boolean init) {
        this.m_serverEngine = se;
        this.m_clientCacheMgr = new GUIClientProxyMgr(this.m_serverEngine.getForwardManager());
        this.m_db = db;
        if (init) {
            this.init();
        }
    }

    public void init() {
        this.m_cube = Cube.getInstance();
        long start = System.currentTimeMillis();
        HashMap<String, SEventFwd> idToDelete = new HashMap<String, SEventFwd>();
        this.m_failedToInsertOrUpdate = this.m_db.loadFromFile();
        for (SEventFwd sef : this.m_failedToInsertOrUpdate) {
            idToDelete.put(sef.getID(), sef);
            switch (sef.getState()) {
                case '-': {
                    this.putActiveOrInsertedAsClosed(sef);
                    if (this.m_cube == null) break;
                    this.m_cube.processIncoming(sef);
                    break;
                }
                case 'A': 
                case 'O': {
                    this.m_closed.put(sef.getID(), sef);
                    break;
                }
            }
        }
        this.m_db.deleteInDBSpecial(idToDelete);
        this.m_db.readActiveMessages(this.m_serverEngine.getForwardManager(), this, this.m_activeAndInsertedAsClosed);
        for (SEventFwd sef : this.m_activeAndInsertedAsClosed.values()) {
            if (this.m_cube == null) continue;
            this.m_cube.processIncoming(sef);
        }
        RTLogger.print(5, "**KeysSize " + this.m_msgkeys.size() + " **ActiveInd " + this.getActiveMessagesCount());
        RTLogger.print(3, "EvReadActiveDBTime=" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.m_closed = this.m_db.readAcknowledgedMessages(this.m_serverEngine.getForwardManager(), this, this.m_closed);
        RTLogger.print(3, "EvReadAcknDBTime=" + (System.currentTimeMillis() - start));
    }

    @Override
    public boolean isAvailable() {
        if (!this.m_DBConnectionOK.get()) {
            try {
                if (this.m_db.isOnline()) {
                    this.dBup();
                }
            }
            catch (DBException dBException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_DBConnectionOK.get();
    }

    public void setForwardManager(ForwardManager fm) {
        this.m_clientCacheMgr.setForwardManager(fm);
    }

    public void changeMonHosts(int ch, SEventFwd se, boolean skipMsgKey) {
        String node;
        if (ch >= 0 && !skipMsgKey) {
            this.m_msgkeys.put(se.getKeyInternal(), se.getID());
        }
        if ((node = se.getNode()) == null || node.length() == 0 || node.equals(OUT_OF_LICENSE)) {
            return;
        }
        if (se.getSrv() != null && se.getSrv().length() > 0) {
            if (ch > 0) {
                this.detectExternalHosts(se, se.getT1(), true);
            }
            return;
        }
        boolean detectExtHost = this.licenseHost(ch, se);
        if (detectExtHost) {
            this.detectExternalHosts(se, se.getT1(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean licenseHost(int ch, SEventFwd se) {
        boolean detectExtHost = false;
        this.m_monitoredHostsLock.writeLock().lock();
        try {
            Integer l = (Integer)this.m_monitoredHosts.get(se.getNode());
            if (l == null) {
                if (ch > 0) {
                    if (this.m_serverEngine.getFreeLicenseHostObjects() <= 0) {
                        se.setNode(OUT_OF_LICENSE);
                        se.setSeverity(0);
                    } else {
                        this.m_monitoredHosts.put(se.getNode(), 1);
                        this.m_serverEngine.registerHostAsLicensed();
                        detectExtHost = true;
                    }
                }
            } else {
                int res = l + ch;
                if (ch < 0 && res == 0) {
                    this.m_monitoredHosts.remove(se.getNode());
                    this.m_serverEngine.unregisterHostFromLicensed();
                } else {
                    this.m_monitoredHosts.put(se.getNode(), res);
                }
            }
        }
        finally {
            this.m_monitoredHostsLock.writeLock().unlock();
        }
        return detectExtHost;
    }

    @Override
    public void submitNewMessage(List<SEventFwd> messages, AgentCard ac) {
        long tstart = System.currentTimeMillis();
        this.submitNewMessage(messages, ac, tstart);
    }

    protected void submitNewMessage(List<SEventFwd> messages, AgentCard ac, long tstart) {
        int size = messages.size();
        SEventFwd event = null;
        for (SEventFwd message : messages) {
            event = message;
            String mid = event.getID();
            if (this.getEvent(mid) != null || 'D' == event.getState()) {
                if (RTLogger.getCurrentLevel() < 5) continue;
                RTLogger.print(5, "drop " + mid);
                continue;
            }
            HashCode hash = event.getKeyInternal();
            this.submitNewMessage(event, ac, hash);
            this.saveMaximumProcessingTime(System.currentTimeMillis() - tstart);
        }
        this.setAverageProcessingTime(size, System.currentTimeMillis() - tstart);
        if (RTLogger.getCurrentLevel() >= 6) {
            RTLogger.print(6, "Active message count = " + this.getActiveMessagesCount());
        }
    }

    public void submitFromPrimaryActive(SEventFwd sef, String serverName) {
        sef.setSrv(serverName);
        sef.setSrvType(PRIME);
        HashCode hash = sef.getKeyInternal();
        this.m_msgkeys.put(hash, sef.getID());
        this.processedAKeys.put(sef.getCloseMask(), sef.getSTime() - 1000L);
        this.m_activeAndInsertedAsClosed.put(sef.getID(), sef);
        SEventFwd closed = this.m_closed.remove(sef.getID());
        this.markToInsertOrUpdateInDB(sef);
        executorService.submit(() -> this.getClientProxyMgr().addToClientCachesNoForwardAction(sef));
    }

    public void submitFromPrimaryClosed(SEventFwd sef, String serverName) {
        sef.setSrv(serverName);
        sef.setSrvType(PRIME);
        this.m_closed.put(sef.getID(), sef);
        SEventFwd active = this.m_activeAndInsertedAsClosed.remove(sef.getID());
        this.markToInsertOrUpdateInDB(sef);
        executorService.submit(() -> this.getClientProxyMgr().addToClientCachesNoForwardAction(sef));
    }

    @Override
    public void submitFwdMessage(List<SEventFwd> messages, SlaveServerCard ssc) {
        boolean closeOnSlave = ssc.getScenario() <= 1;
        messages.sort(this.m_AscComparator);
        LinkedList<String> ids = new LinkedList<String>();
        for (SEventFwd event : messages) {
            if (ssc.getScenario() == 3) {
                if (ssc.getTopTime() > event.getSTime() && this.getEvent(event.getID()) == null) continue;
                ssc.compareAndSetTopTime(event.getSTime());
            }
            boolean isClosed = this.submitFwdMessage(event);
            if (!closeOnSlave || !isClosed) continue;
            ids.add(event.getID());
        }
        try {
            if (ids.size() > 0) {
                try {
                    ssc.getServerClient().start("ACKN_MSG", null, ids.toArray(new String[0]));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (DBException e) {
            throw e;
        }
        finally {
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "Active message count = " + this.getActiveMessagesCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveDBdata() {
        LinkedHashMap<String, SEventFwd> setDeletedSnapshot = new LinkedHashMap<String, SEventFwd>(this.m_DBsetDeleted);
        setDeletedSnapshot.keySet().removeAll(this.m_DBnewORupdate.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBnewORupdateEXT.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBacknByNewMsg.keySet());
        setDeletedSnapshot.keySet().removeAll(this.m_DBUpdateDuplicateCounts.keySet());
        int ll = 6;
        if (this.m_DBnewORupdate.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Active " + this.m_DBnewORupdate.size());
            }
            Map<String, SEventFwd> toExtProcessing = this.m_db.saveEvents(this.m_DBnewORupdate);
            this.markAsNewEXTInDB(toExtProcessing);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Active done");
            }
        }
        if (this.m_DBnewORupdateEXT.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB ActiveExt " + this.m_DBnewORupdateEXT.size());
            }
            this.m_db.saveEventsExt(this.m_DBnewORupdateEXT);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB ActiveExt done");
            }
        }
        if (this.m_DBUpdateDuplicateCounts.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB dupl " + this.m_DBUpdateDuplicateCounts.size());
            }
            this.m_db.updateActiveDuplicates(this.m_DBUpdateDuplicateCounts);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB dupl done");
            }
        }
        if (this.m_DBacknByNewMsg.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Closed " + this.m_DBacknByNewMsg.size());
            }
            this.m_db.acknowledgeMessagesByMsg(this.m_DBacknByNewMsg);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Closed done");
            }
        }
        if (setDeletedSnapshot.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB set Deleted " + setDeletedSnapshot.size());
            }
            this.m_DBsetDeleted.keySet().removeAll(setDeletedSnapshot.keySet());
            try {
                this.m_db.archiveInDB(setDeletedSnapshot);
                if (RTLogger.getCurrentLevel() >= ll) {
                    RTLogger.print(ll, "Save DB set Deleted done");
                }
            }
            finally {
                if (setDeletedSnapshot.size() > 0) {
                    this.m_DBsetDeleted.putAll(setDeletedSnapshot);
                }
            }
        }
        if (this.m_DBOnlyDeleteNOArchive.size() > 0) {
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Delete(proxy0) " + this.m_DBOnlyDeleteNOArchive.size());
            }
            this.m_db.deleteInDB(this.m_DBOnlyDeleteNOArchive);
            if (RTLogger.getCurrentLevel() >= ll) {
                RTLogger.print(ll, "Save DB Delete(proxy0) done");
            }
        }
        if (this.m_failedToInsertOrUpdate.size() > 0 || this.m_failedToInsertOrUpdateSAVETrigger.get()) {
            this.m_db.tryInsertEvent(this.m_failedToInsertOrUpdate, this.m_failedToInsertOrUpdateSAVETrigger);
        }
        if (this.m_DBannotations.size() > 0 && !AnnotationInsertTask.m_lock.isWriteLocked()) {
            ServerThreadPool.getInstance().submit(this.m_annInsTask);
        }
    }

    void dBdown(DBException dbe) {
        if (this.m_DBConnectionOK.compareAndSet(true, false)) {
            if (dbe == null) {
                dbe = new DBException("Can't connect");
            }
            SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "DB", "RUNTIME", "DB Error: " + dbe.getMessage());
            sm.setKey(KEY_DB_DOWN);
            sm.setCloseMask(CLOSEKEY_DB_DOWN);
            this.submitNewMessageInternal(sm);
        }
    }

    void dBup() {
        if (this.m_DBConnectionOK.compareAndSet(false, true)) {
            SEventFwd sm = SMessage.createMessage(1, 1, "BOOM_SERVER", "DB", "RUNTIME", SERVER_DB_IS_ONLINE);
            sm.setKey(KEY_DB_UP);
            sm.setCloseMask(CLOSEKEY_DB_DOWN);
            this.submitNewMessageInternal(sm);
        }
    }

    @Override
    public void setAnnotationFlag(String messageID) {
        SEventFwd se = this.getEvent(messageID);
        if (se != null) {
            se.setAnnotationFlag(true);
            executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(se));
        } else {
            RTLogger.print(5, "Set annotation flag impossible for msg=" + messageID);
        }
    }

    public int getActiveMessagesCount() {
        return this.m_activeAndInsertedAsClosed.size();
    }

    public int getClosedMessagesCount() {
        return this.m_closed.size();
    }

    public int getMessagesCount() {
        return this.getActiveMessagesCount() + this.getClosedMessagesCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitNewMessageInternal(SEventFwd mv) {
        String mid = mv.getID();
        if (this.getEvent(mid) != null || 'D' == mv.getState()) {
            RTLogger.print(5, "drop " + mid);
            return;
        }
        mv.setNode(ServerEngine.getInstance().getHostnameResolver().getNameForAlias(mv.getNode(), null));
        String monKey = mv.getKeyConfigured();
        String UUIDdupl = null;
        HashCode hash = mv.getKeyInternal();
        while (this.inProcessing.containsKey(hash)) {
            Thread.yield();
        }
        this.inProcessing.put(hash, mv);
        try {
            UUIDdupl = this.acknowledge(mv, hash, -1L);
            if (monKey.length() == 0) {
                this.setNew(mv);
                if (mv.getAutoActionFlag() && mv.getAA_DuplicateTrigger() == 0) {
                    this.startAA(mv, null);
                }
                executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(mv));
            } else if (UUIDdupl == null) {
                this.setNew(mv);
                if (mv.getAutoActionFlag() && mv.getAA_DuplicateTrigger() == 0) {
                    this.startAA(mv, null);
                }
                executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(mv));
            } else {
                this.setDuplicate(mv, UUIDdupl);
            }
        }
        finally {
            this.inProcessing.remove(hash);
        }
    }

    protected boolean submitFwdMessage(SEventFwd mv) {
        boolean isClosed = false;
        if ('D' == mv.getState()) {
            return isClosed;
        }
        String mid = mv.getID();
        SEventFwd old = this.getEvent(mid);
        if (old != null) {
            if (old.getState() != mv.getState() && this.getActive(mid) == null) {
                isClosed = true;
            }
            this.updateFwd(mv, true);
        } else {
            this.setNew(mv);
            executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(mv));
        }
        return isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitNewMessage(SEventFwd mv, AgentCard ac, HashCode hash) {
        if (this.getEvent(mv.getID()) != null || 'D' == mv.getState()) {
            RTLogger.print(5, "drop " + mv.getID());
            return;
        }
        mv.setNode(ServerEngine.getInstance().getHostnameResolver().getNameForAlias(mv.getNode(), ac == null ? null : ac.getAgentID()));
        String UUIDdupl = null;
        while (this.inProcessing.containsKey(hash)) {
            Thread.yield();
        }
        this.inProcessing.put(hash, mv);
        try {
            String closeMask = mv.getCloseMask();
            UUIDdupl = this.acknowledge(mv, hash, this.processedAKeys.get(closeMask));
            this.processedAKeys.put(closeMask, mv.getSTime() - 1000L);
            if (UUIDdupl == null) {
                this.setNew(mv);
                if (mv.getAutoActionFlag() && mv.getAA_DuplicateTrigger() == 0) {
                    this.startAA(mv, ac);
                }
                executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(mv));
            } else {
                SEventFwd eOld;
                int dupl = this.setDuplicate(mv, UUIDdupl);
                if (mv.getAutoActionFlag() && dupl == mv.getAA_DuplicateTrigger() && (eOld = this.getActive(UUIDdupl)) != null) {
                    this.startAA(eOld, ac);
                }
            }
        }
        finally {
            this.inProcessing.remove(hash);
        }
    }

    private void detectExternalHosts(SEventFwd mv, String agentID, boolean slaveIndication) {
        if (slaveIndication && this.m_serverEngine.getServerProps().getAutoDetectExternalHostsFromSlaves() || this.m_serverEngine.getServerProps().getAutoDetectExternalHosts()) {
            boolean equalsHostAndAgentHost = false;
            try {
                equalsHostAndAgentHost = mv.getAgentNode().equalsIgnoreCase(mv.getNode());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!equalsHostAndAgentHost) {
                this.m_serverEngine.getAgentRepository().addExternalHost(mv.getNode(), agentID);
            }
        }
    }

    protected void saveMaximumProcessingTime(long delta) {
        this.m_timeProcessing.set(delta);
        if (delta > this.m_maxTimeProcessing.get()) {
            this.m_maxTimeProcessing.set(delta);
        }
    }

    protected void setAverageProcessingTime(int count, long deltaTime) {
        long wac = this.m_weightedAverageCount.get();
        if (count > 0) {
            this.m_weightedAverage = (this.m_weightedAverage * (double)wac + (double)deltaTime) / (double)(wac + (long)count);
            this.m_weightedAverageCount.getAndAdd(count);
        }
    }

    protected void startAA(IEvent mv, AgentCard ac) {
        block15: {
            try {
                String agentID = mv.getAutoActionNode().trim();
                String mid2 = mv.getID();
                if (agentID.length() > 0) {
                    if (agentID.equals("BOOM_SERVER")) {
                        ServerActionsManager.getInstance().schedule(new AutoActionLocalJob(mv.getAutoAction(), mid2, mv.getAutoActionTimeout()));
                    } else if (agentID.startsWith("BOOM_SERVER_IA") || agentID.startsWith("BOOM_SERVER_IA")) {
                        ServerActionsManager.getInstance().schedule(new AutoActionServerAction(mv.getAutoAction(), mid2, mv.getAutoActionTimeout()));
                    } else {
                        AgentCard acForAction = this.m_serverEngine.getAgentRepository().getLocalAgentCard(agentID, false);
                        if (acForAction != null) {
                            RemoteAction ra = new RemoteAction(acForAction, mv.getAutoAction(), mid2, mv.getAutoActionTimeout());
                            acForAction.scheduleTask(ra);
                        } else {
                            List<AgentCard> list = ServerEngine.getInstance().getAgentRepository().getLocalAgentCards(mv.getAutoActionNode());
                            if (list.size() > 0) {
                                for (AgentCard acS : list) {
                                    RemoteAction ra = new RemoteAction(acS, mv.getAutoAction(), mid2, mv.getAutoActionTimeout());
                                    acS.scheduleTask(ra);
                                }
                            } else {
                                Annotation ann = new Annotation("Remote action can't be processed on unknown Agent:" + agentID, System.currentTimeMillis(), "AAF");
                                this.markToSaveAnnotations(mid2, ann);
                                if (RTLogger.getCurrentLevel() >= 5) {
                                    RTLogger.print(5, "Remote action finished for message ID:" + mid2 + " AAF");
                                }
                                this.setAnnotationFlag(mid2);
                            }
                        }
                    }
                    break block15;
                }
                if (ac != null) {
                    RemoteAction ra = new RemoteAction(ac, mv.getAutoAction(), mid2, mv.getAutoActionTimeout());
                    ac.scheduleTask(ra);
                    break block15;
                }
                throw new RuntimeException("Agent card is not specified or not found");
            }
            catch (Throwable e) {
                Annotation ann = new Annotation("Remote action failed. Exception:\n" + e.getMessage(), System.currentTimeMillis(), "AAF");
                this.markToSaveAnnotations(mv.getID(), ann);
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "Remote action failed for message ID:" + mv.getID() + " AAF", e);
                }
                this.setAnnotationFlag(mv.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String acknowledge(IEvent mv, HashCode hash, Long maxSTime) {
        PatternB patternB;
        int pos1;
        char testCH1;
        int posRandom;
        char testCHrandom;
        int pos;
        char testCH;
        String duplicateUUID;
        String ackkey;
        block16: {
            ackkey = mv.getCloseMask();
            duplicateUUID = null;
            testCH = '*';
            pos = -1;
            testCHrandom = '*';
            posRandom = -1;
            testCH1 = '*';
            pos1 = -1;
            patternB = null;
            duplicateUUID = this.getDuplicateID(mv, hash);
            if (ackkey != null && ackkey.length() > 1) {
                try {
                    patternB = PatternB.getPattern(ackkey);
                    Pattern p = patternB.getPattern();
                    String pattern = p.pattern();
                    if (!pattern.startsWith("\\Q")) break block16;
                    int post = pattern.indexOf("\\E");
                    testCH = pattern.charAt(post - 1);
                    pos = post - 3;
                    if (pos > 0) {
                        pos1 = 0;
                        testCH1 = pattern.charAt(2);
                        if (pos > 2) {
                            posRandom = pos / 2;
                            testCHrandom = pattern.charAt(posRandom + 2);
                        }
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(2, "CLOSE KEY compilation failed: " + e.getMessage());
                }
            } else {
                if (!mv.getDeduplication()) {
                    if (RTLogger.getCurrentLevel() >= 6) {
                        RTLogger.print(6, "DD skipped. " + mv.getDeduplication());
                    }
                    return null;
                }
                return duplicateUUID;
            }
        }
        if (patternB != null) {
            Iterator<Map.Entry<String, SEventFwd>> it = this.m_activeAndInsertedAsClosed.entrySet().iterator();
            while (it.hasNext()) {
                String key;
                int len;
                Map.Entry<String, SEventFwd> en = it.next();
                SEventFwd e = en.getValue();
                if (maxSTime != null && maxSTime > 0L && e.getSTime() < maxSTime || (len = (key = e.getKeyConfigured()).length()) == 0 || pos > -1 && (len < pos + 1 || key.charAt(pos) != testCH) || pos1 == 0 && key.charAt(pos1) != testCH1 || posRandom > 0 && (len < posRandom + 1 || key.charAt(posRandom) != testCHrandom)) continue;
                long start = System.currentTimeMillis();
                PatternMatchResult matchesR = PatternMatcherThread.match(patternB, key);
                if (matchesR == null || !matchesR.isMatch()) continue;
                long delta = System.currentTimeMillis() - start;
                if (this.m_weightedAverage > 0.0 && (double)delta > this.m_weightedAverage * 2.0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("CK: ").append(ackkey).append(' ').append(delta).append("ms");
                    RTLogger.print(2, sb);
                }
                if (e.getID().equals(duplicateUUID)) continue;
                SEventFwd sEventFwd = e;
                synchronized (sEventFwd) {
                    if (e.getState() != 'A') {
                        e.setAnnotationClosedByMessage(mv.getID());
                        if (this.m_cube != null) {
                            this.m_cube.processOutgoing(e);
                        }
                        this.setAcknowledged(e, it, 'A', hash);
                    }
                }
            }
        }
        return duplicateUUID;
    }

    public void acknowledgeLastBeforeOutage(SEventFwd sef) {
        HashCode hash = sef.getKeyInternal();
        PatternB patternB = null;
        char testCH = '*';
        int pos = -1;
        char testCHrandom = '*';
        int posRandom = -1;
        char testCH1 = '*';
        int pos1 = -1;
        try {
            patternB = PatternB.getPattern(sef.getCloseMask());
            Pattern p = patternB.getPattern();
            String pattern = p.pattern();
            if (pattern.startsWith("\\Q")) {
                int post = pattern.indexOf("\\E");
                testCH = pattern.charAt(post - 1);
                pos = post - 3;
                if (pos > 0) {
                    pos1 = 0;
                    testCH1 = pattern.charAt(2);
                    if (pos > 2) {
                        posRandom = pos / 2;
                        testCHrandom = pattern.charAt(posRandom + 2);
                    }
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "CLOSE KEY compilation failed: " + e.getMessage());
        }
        if (patternB != null) {
            Iterator<Map.Entry<String, SEventFwd>> it = this.m_activeAndInsertedAsClosed.entrySet().iterator();
            while (it.hasNext()) {
                int len;
                Map.Entry<String, SEventFwd> en = it.next();
                SEventFwd e = en.getValue();
                String key = e.getKeyConfigured();
                if (e.getSTime() > sef.getSTime() || (len = key.length()) == 0 || pos > -1 && (len < pos + 1 || key.charAt(pos) != testCH) || pos1 == 0 && key.charAt(pos1) != testCH1 || posRandom > 0 && (len < posRandom + 1 || key.charAt(posRandom) != testCHrandom)) continue;
                long start = System.currentTimeMillis();
                PatternMatchResult matchesR = PatternMatcherThread.match(patternB, key);
                if (matchesR == null || !matchesR.isMatch()) continue;
                long delta = System.currentTimeMillis() - start;
                if (this.m_weightedAverage > 0.0 && (double)delta > this.m_weightedAverage * 2.0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("CK: ").append(sef.getCloseMask()).append(' ').append(delta).append("ms");
                    RTLogger.print(2, sb);
                }
                e.setAnnotationClosedByMessage(sef.getID());
                if (this.m_cube != null) {
                    this.m_cube.processOutgoing(e);
                }
                this.setAcknowledged(e, it, 'A', hash);
            }
        }
    }

    protected String getDuplicateID(IEvent mv, HashCode hash) {
        String oldid = this.m_msgkeys.get(hash);
        if (oldid != null && this.getActive(oldid) == null) {
            this.m_msgkeys.remove(hash);
            oldid = null;
        }
        return oldid;
    }

    @Override
    @Deprecated
    public void acknowledge2(List<String> messageIDs, String operator) {
        for (String id : messageIDs) {
            SEventFwd se = this.getEvent(id);
            if (se == null) continue;
            se.setAnnotationClosedByUser(operator);
            this.markAcknByNewMsg(se);
        }
        this.removeAndUpdate(messageIDs);
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Messages marked to close in DB: " + messageIDs.size());
        }
    }

    protected int removeAndUpdate(List<String> messageIDs) {
        int sizeOrig = messageIDs.size();
        for (String id : messageIDs) {
            SEventFwd e = this.getActive(id);
            if (e == null) continue;
            this.m_activeAndInsertedAsClosed.remove(id);
            if (this.m_cube != null) {
                this.m_cube.processOutgoing(e);
            }
            this.setAcknowledged(e, null, 'O', null);
        }
        this.getClientProxyMgr().addDeletedToClients(messageIDs);
        return sizeOrig;
    }

    @Override
    public void acknowledgeFwd(String ID, char state, String t9Attr) {
        SEventFwd e = this.getActive(ID);
        if (e == null) {
            SEventFwd closed = this.m_closed.get(ID);
            if (closed != null) {
                this.getClientProxyMgr().addDeletedToClients(closed);
            }
            return;
        }
        SEventFwd exist = this.m_activeAndInsertedAsClosed.remove(e.getID());
        if (exist != null && this.m_cube != null) {
            this.m_cube.processOutgoing(e);
        }
        e.setState(state);
        if (t9Attr != null) {
            e.setT9(t9Attr);
        }
        this.m_closed.put(e.getID(), e);
        this.getClientProxyMgr().addDeletedToClients(e);
        this.markAcknByNewMsg(e);
        HashCode hash = e.getKeyInternal();
        this.m_msgkeys.remove(hash);
    }

    @Override
    public void acknowledgeFwd(List<SEventFwd> list, SlaveServerCard ssc) {
        list.sort(this.m_AscComparator);
        Iterator<SEventFwd> it = list.iterator();
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<SEventFwd> newEvents = new LinkedList<SEventFwd>();
        while (it.hasNext()) {
            SEventFwd eA = it.next();
            SEventFwd old = this.getActive(eA.getID());
            if (old != null) {
                old.setAnnotationFlag(eA.getAnnotationFlag());
                old.setDuplicate(eA.getDuplicates());
                this.acknowledgeFwd(eA.getID(), eA.getState(), eA.getT9());
                continue;
            }
            String server = eA.getSrv();
            if (!eA.getSrvtype().equals(BM.PRODUCT_lowercase)) {
                server = eA.getSrvtype();
            }
            if ((old = this.m_closed.get(eA.getID())) == null) {
                if (ssc.getScenario() == 3) {
                    if (ssc.getTopTime() > eA.getSTime()) continue;
                    ssc.compareAndSetTopTime(eA.getSTime());
                }
                newEvents.add(eA);
                ids.add(eA.getID());
            }
            this.m_closed.put(eA.getID(), eA);
        }
        this.markToInsertOrUpdateInDB(newEvents);
        executorService.submit(() -> {
            this.getClientProxyMgr().addToClientCaches(newEvents);
            this.getClientProxyMgr().addDeletedToClients(ids);
        });
    }

    protected String updateFwd(SEventFwd e, boolean fromSlave) {
        String unknownID = null;
        SEventFwd old = this.m_activeAndInsertedAsClosed.get(e.getID());
        if (old != null) {
            if (fromSlave) {
                e.setT5(old.getT5());
                e.setT6(old.getT6());
                e.setT7(old.getT7());
                e.setT8(old.getT8());
                e.setT10(old.getT10());
                e.setAgentNode(old.getAgentNode());
                e.setNode(old.getNode());
                e.setApplication(old.getApplication());
                e.setGroup(old.getGroup());
                e.setObject(old.getObject());
                if (e.getSeverityInt() >= 0 || old.getSeverityInt() < 0) {
                    e.setSeverity(old.getSeverityInt());
                }
                e.setKey(old.getKeyConfigured());
                e.setText(old.getText());
            }
            e.setState(old.getState());
            this.putActiveOrInsertedAsClosed(e);
            if (!fromSlave || !SEventFwdCompare.isEqual(e, old)) {
                executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(e));
            }
        } else {
            old = this.m_closed.get(e.getID());
            if (old != null) {
                if (fromSlave) {
                    e.setT5(old.getT5());
                    e.setT6(old.getT6());
                    e.setT7(old.getT7());
                    e.setT8(old.getT8());
                    e.setT10(old.getT10());
                    e.setAgentNode(old.getAgentNode());
                    e.setNode(old.getNode());
                    e.setApplication(old.getApplication());
                    e.setGroup(old.getGroup());
                    e.setObject(old.getObject());
                    if (e.getSeverityInt() >= 0 || old.getSeverityInt() < 0) {
                        e.setSeverity(old.getSeverityInt());
                    }
                    e.setKey(old.getKeyConfigured());
                    e.setText(old.getText());
                }
                e.setState(old.getState());
                this.m_closed.put(e.getID(), e);
                if (!fromSlave || !SEventFwdCompare.isEqual(e, old)) {
                    executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(e));
                }
            } else {
                unknownID = e.getID();
            }
        }
        return unknownID;
    }

    @Override
    public List<String> updateEvents(List<SEventFwd> events, boolean fromSlave) {
        LinkedList<String> ids = new LinkedList<String>();
        Iterator<SEventFwd> it = events.iterator();
        while (it.hasNext()) {
            SEventFwd se = it.next();
            String unknownID = this.updateFwd(se, fromSlave);
            if (unknownID == null) continue;
            ids.add(unknownID);
            it.remove();
        }
        this.markToInsertOrUpdateInDB(events);
        return ids;
    }

    @Override
    public void reopenIndi(List<String> ids, String user) {
        LinkedList<String> emulateArchive = new LinkedList<String>();
        LinkedList<SEventFwd> emulateNew = new LinkedList<SEventFwd>();
        for (String id : ids) {
            SEventFwd old = this.getEvent(id);
            if (old == null || old.getState() == '-') continue;
            emulateArchive.add(old.getID());
            emulateNew.add(old);
        }
        this.updateClosed(emulateArchive);
        this.cleanProcessedAKeys(false);
        for (SEventFwd nse : emulateNew) {
            nse.setState('-');
            Annotation ann = new Annotation(user + "\nRe-opened", System.currentTimeMillis(), "REO");
            this.markToSaveAnnotations(nse.getID(), ann);
            this.changeMonHosts(1, nse, false);
            this.putActiveOrInsertedAsClosed(nse);
            if (this.m_cube != null) {
                this.m_cube.processIncoming(nse);
            }
            executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(nse));
        }
        this.markToInsertOrUpdateInDB(emulateNew);
    }

    @Override
    public void updateEventsManual(List<SEventFwd> events, String user) {
        LinkedList<String> emulateArchive = new LinkedList<String>();
        LinkedList<SEventFwd> emulateNew = new LinkedList<SEventFwd>();
        LinkedList<SEventFwd> update = new LinkedList<SEventFwd>();
        for (SEventFwd se : events) {
            SEventFwd old = this.getEvent(se.getID());
            if (old == null) continue;
            if (old.getState() != '-' && se.getState() == '-') {
                if (old.getText().equals(se.getText())) {
                    se.setAnnotationFlag(true);
                    emulateArchive.add(old.getID());
                    emulateNew.add(se);
                    continue;
                }
                se.setState(old.getState());
                update.add(se);
                continue;
            }
            update.add(se);
        }
        this.updateClosed(emulateArchive);
        this.cleanProcessedAKeys(false);
        for (SEventFwd nse : emulateNew) {
            Annotation ann = new Annotation(user + "\nRe-opened", System.currentTimeMillis(), "REO");
            this.markToSaveAnnotations(nse.getID(), ann);
            this.changeMonHosts(1, nse, false);
            this.putActiveOrInsertedAsClosed(nse);
            if (this.m_cube != null) {
                Cube.getInstance().processIncoming(nse);
            }
            executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(nse));
        }
        this.markToInsertOrUpdateInDB(emulateNew);
        this.updateEvents(update, false);
    }

    @Override
    public void archive2(Collection<String> messageIDs, boolean deleteOnly) {
        if (deleteOnly) {
            this.markToDelete(messageIDs);
        } else {
            this.markToSetDeleted(messageIDs);
        }
        this.updateClosed(messageIDs);
    }

    protected void updateClosed(Collection<String> messageIDs) {
        LinkedList<String> informUIforClosed = new LinkedList<String>();
        if (messageIDs == null || messageIDs.size() == 0) {
            return;
        }
        for (String idToDelete : messageIDs) {
            SEventFwd se;
            if (this.m_serverEngine.getForwardManager() != null) {
                this.m_serverEngine.getForwardManager().forgetIndication(idToDelete);
            }
            if ((se = this.m_closed.remove(idToDelete)) != null) {
                this.changeMonHosts(-1, se, true);
                continue;
            }
            se = this.m_activeAndInsertedAsClosed.remove(idToDelete);
            if (se == null) continue;
            informUIforClosed.add(se.getID());
            this.changeMonHosts(-1, se, true);
            if (this.m_cube == null) continue;
            this.m_cube.processOutgoing(se);
        }
        if (informUIforClosed.size() > 0) {
            this.getClientProxyMgr().addDeletedToClients(informUIforClosed);
        }
        this.getClientProxyMgr().addArchivedToClients(messageIDs);
        if (messageIDs.size() > 0) {
            RTLogger.print(4, "Finished archiving " + messageIDs.size() + " messages");
        }
    }

    protected void setNew(SEventFwd e) {
        this.changeMonHosts(1, e, false);
        e.cleanTempVariables();
        this.putActiveOrInsertedAsClosed(e);
        if (this.m_cube != null) {
            this.m_cube.processIncoming(e);
        }
        this.markToInsertOrUpdateInDB(e);
    }

    protected void setClosedPublishedFromOutage(SEventFwd e) {
        this.m_closed.put(e.getID(), e);
        this.markToInsertOrUpdateInDB(e);
    }

    public boolean isFilteredForUser(String eventID, GUIClientProxy cp) {
        boolean filtered = true;
        SEventFwd e = this.getEvent(eventID);
        if (e != null) {
            Collection<String> roles = this.m_serverEngine.getForwardManager().checkAll(e, false, false);
            filtered = roles.contains(cp.getUserRoleNameForFilters());
        }
        return filtered;
    }

    protected int setDuplicate(SEventFwd e, String uuid) {
        int duplCount = 0;
        SEventFwd eOld = this.getActive(uuid);
        if (eOld == null || eOld.getSeverityInt() < 0) {
            this.setNew(e);
            executorService.submit(() -> this.getClientProxyMgr().addToClientCaches(e));
        } else {
            eOld.setDuplicate(eOld.getDuplicates() + 1);
            eOld.setTime(e.getTime());
            eOld.setSTime(e.getSTime());
            if (this.m_serverEngine.getServerProps().isUseLastDuplicateText() && e.getDeDuplicationKeyOnly() && !eOld.getText().equals(e.getText())) {
                eOld.setText(e.getText());
                this.m_msgkeys.put(eOld.getKeyInternal(), eOld.getID());
            }
            this.markToUpdateInDBCount(eOld);
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "UUID " + uuid + " duplicates = " + eOld.getDuplicates());
            }
            executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(eOld));
            duplCount = eOld.getDuplicates();
        }
        return duplCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markToInsertOrUpdateInDB(SEventFwd e) {
        e.setB2bHash(null);
        Map<String, SEventFwd> map = this.m_DBnewORupdate;
        synchronized (map) {
            this.m_DBnewORupdate.put(e.getID(), e);
        }
        if (!this.m_failedToInsertOrUpdateSAVETrigger.get() && this.m_failedToInsertOrUpdate.contains(e)) {
            this.m_failedToInsertOrUpdateSAVETrigger.set(true);
        }
    }

    public void markToInsertOrUpdateInDB(Collection<SEventFwd> list) {
        list.forEach(this::markToInsertOrUpdateInDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsNewEXTInDB(Map<String, SEventFwd> map) {
        Map<String, SEventFwd> map2 = this.m_DBnewORupdateEXT;
        synchronized (map2) {
            this.m_DBnewORupdateEXT.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markToUpdateInDBCount(SEventFwd eOld) {
        eOld.setB2bHash(null);
        Map<String, SEventFwd> map = this.m_DBUpdateDuplicateCounts;
        synchronized (map) {
            this.m_DBUpdateDuplicateCounts.put(eOld.getID(), eOld);
        }
        if (!this.m_failedToInsertOrUpdateSAVETrigger.get() && this.m_failedToInsertOrUpdate.contains(eOld)) {
            this.m_failedToInsertOrUpdateSAVETrigger.set(true);
        }
    }

    public void markToUpdateInDBCount(Collection<SEventFwd> list) {
        list.forEach(this::markToUpdateInDBCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markToSetDeleted(String eventID) {
        Map<String, SEventFwd> map = this.m_DBsetDeleted;
        synchronized (map) {
            SEventFwd event = this.getEvent(eventID);
            if (event != null) {
                event.setState('D');
                this.m_DBsetDeleted.put(eventID, event);
            }
        }
    }

    public void markToSetDeleted(Collection<String> eventIDs) {
        eventIDs.forEach(this::markToSetDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markToDelete(String eventID) {
        Map<String, SEventFwd> map = this.m_DBOnlyDeleteNOArchive;
        synchronized (map) {
            SEventFwd event = this.getEvent(eventID);
            if (event != null) {
                event.setState('D');
                this.m_DBOnlyDeleteNOArchive.put(eventID, event);
                this.cleanEventFromDBqueues(event);
            }
        }
    }

    public void markToDelete(Collection<String> eventIDs) {
        eventIDs.forEach(this::markToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markToSaveAnnotations(String messageID, Annotation ann) {
        if (messageID == null || ann == null || ann.getStatus() == null || ann.getText() == null) {
            return;
        }
        HashMapMap<String, Annotation> hashMapMap = this.m_DBannotations;
        synchronized (hashMapMap) {
            this.m_DBannotations.putV(messageID, ann);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markToSaveAnnotations(String messageID, List<Annotation> listOfAnnotations) {
        HashMapMap<String, Annotation> hashMapMap = this.m_DBannotations;
        synchronized (hashMapMap) {
            this.m_DBannotations.put(messageID, listOfAnnotations);
        }
    }

    public void markAsFailedInsertOrUpdate(Collection<SEventFwd> sefList) {
        for (SEventFwd sef : sefList) {
            if (sef == null) continue;
            this.m_failedToInsertOrUpdate.remove(sef);
            this.m_failedToInsertOrUpdate.offer(sef);
            this.m_failedToInsertOrUpdateSAVETrigger.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanEventFromDBqueues(SEventFwd event) {
        String eventID = null;
        if (event != null) {
            eventID = event.getID();
        }
        Map<String, SEventFwd> map = this.m_DBnewORupdate;
        synchronized (map) {
            this.m_DBnewORupdate.remove(eventID);
        }
        map = this.m_DBnewORupdateEXT;
        synchronized (map) {
            this.m_DBnewORupdateEXT.remove(eventID);
        }
        map = this.m_DBUpdateDuplicateCounts;
        synchronized (map) {
            this.m_DBUpdateDuplicateCounts.remove(eventID);
        }
        map = this.m_DBacknByNewMsg;
        synchronized (map) {
            this.m_DBacknByNewMsg.remove(eventID);
        }
        if (this.m_failedToInsertOrUpdate.remove(event)) {
            this.m_failedToInsertOrUpdateSAVETrigger.set(true);
            this.m_db.printInFile(event);
        }
    }

    @Override
    public void setAlertFinished(List<FA> fas) {
        for (FA finAlert : fas) {
            SEventFwd sef = this.getActive(finAlert.m_uuid);
            if (sef == null || sef.getSeverityInt() < 0) continue;
            sef.setSeverity(sef.getSeverityInt() - 6);
            sef.setTFA(finAlert.m_time);
            sef.setVFA(finAlert.m_value);
            if (this.m_serverEngine.getServerProps().getAutocloseFinishedAlerts()) {
                this.m_activeAndInsertedAsClosed.remove(sef.getID());
                this.setAcknowledged(sef, null, 'A', sef.getKeyInternal());
                sef.addAnnotation(AUTO_CLOSED_FINISHED_ALERT);
                Annotation ann = new Annotation(AUTO_CLOSED_FINISHED_ALERT, System.currentTimeMillis(), "ACF");
                this.markToSaveAnnotations(sef.getID(), ann);
                executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(sef));
                continue;
            }
            this.markToInsertOrUpdateInDB(sef);
            this.putActiveOrInsertedAsClosed(sef);
            executorService.submit(() -> this.getClientProxyMgr().addUpdatedToClients(sef));
            this.m_msgkeys.remove(sef.getKeyInternal());
        }
    }

    protected void putActiveOrInsertedAsClosed(SEventFwd sef) {
        this.m_activeAndInsertedAsClosed.put(sef.getID(), sef);
    }

    protected void setAcknowledged(SEventFwd e, Iterator<Map.Entry<String, SEventFwd>> itParent, char state, HashCode hash) {
        e.setState(state);
        this.m_closed.put(e.getID(), e);
        if (state != 'O') {
            if (itParent != null) {
                itParent.remove();
            }
            this.markAcknByNewMsg(e);
            this.getClientProxyMgr().addDeletedToClients(e);
        }
        if (hash == null) {
            hash = e.getKeyInternal();
        }
        this.m_msgkeys.remove(hash);
    }

    public void markAcknByNewMsg(Map<String, SEventFwd> messages) {
        messages.values().forEach(this::markAcknByNewMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAcknByNewMsg(SEventFwd message) {
        message.setB2bHash(null);
        Map<String, SEventFwd> map = this.m_DBacknByNewMsg;
        synchronized (map) {
            this.m_DBacknByNewMsg.put(message.getID(), message);
        }
        if (!this.m_failedToInsertOrUpdateSAVETrigger.get() && this.m_failedToInsertOrUpdate.contains(message)) {
            this.m_failedToInsertOrUpdateSAVETrigger.set(true);
        }
    }

    public Collection<SEventFwd> freshGetActiveMessages(String user, String IP) {
        this.getClientProxyMgr().createClientCache(user, IP);
        RTLogger.print(5, "FRESH for " + user);
        return new ArrayList<SEventFwd>(this.m_activeAndInsertedAsClosed.values());
    }

    public Collection<SEventFwd> freshGetAcknowledgedMessages(String user) {
        return new ArrayList<SEventFwd>(this.m_closed.values());
    }

    public Enumeration<String> getAcknowledgedIDs() {
        return this.m_closed.keys();
    }

    public Set<SEventFwd> getAllClosed() {
        ConcurrentSkipListSet<SEventFwd> set = new ConcurrentSkipListSet<SEventFwd>(new Comparator<SEventFwd>(this){

            @Override
            public int compare(SEventFwd o1, SEventFwd o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        set.addAll(this.m_closed.values());
        Iterator<SEventFwd> it = this.getActiveAndInsertedAsClosedIterator();
        while (it.hasNext()) {
            SEventFwd sef = it.next();
            if (!sef.isClosed()) continue;
            set.add(sef);
        }
        return set;
    }

    @Override
    public SEventFwd getAcknowledged(String ID) {
        return this.m_closed.get(ID);
    }

    @Override
    public SEventFwd getActive(String ID) {
        return this.m_activeAndInsertedAsClosed.get(ID);
    }

    public List<SEventFwd> getActiveIndications(boolean sort) {
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(this.getActiveMessagesCount());
        list.addAll(this.m_activeAndInsertedAsClosed.values());
        if (sort) {
            list.sort(this.m_DescComparator);
        }
        return list;
    }

    public List<SEventFwd> getActiveOnlyIndicationsUnsorted(String user) {
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        if (UserManager.getInstance().getRights(1000, user) > 1) {
            Iterator<SEventFwd> it = this.m_activeAndInsertedAsClosed.values().iterator();
            EventIterator ei = new EventIterator(it, this.m_serverEngine.getForwardManager(), user);
            while (ei.hasNext()) {
                SEventFwd sef = ei.next();
                if ('-' != sef.getState()) continue;
                list.add(sef);
            }
        }
        return list;
    }

    public List<SEventFwd> getAcknowledgedIndications(boolean sort) {
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(this.m_closed.size());
        list.addAll(this.m_closed.values());
        if (sort) {
            list.sort(this.m_DescComparator);
        }
        return list;
    }

    public Iterator<SEventFwd> getActiveAndInsertedAsClosedIterator() {
        return this.m_activeAndInsertedAsClosed.values().iterator();
    }

    public Iterator<SEventFwd> getClosedIterator() {
        return this.m_closed.values().iterator();
    }

    public Enumeration<String> getActiveIndicationsEnum() {
        return this.m_activeAndInsertedAsClosed.keys();
    }

    public Enumeration<String> getClosedIndicationsEnum() {
        return this.m_closed.keys();
    }

    public long getLastProcessingTime() {
        return this.m_timeProcessing.get();
    }

    public long getMaxProcessingTime() {
        return this.m_maxTimeProcessing.get();
    }

    public void resetMaxProcessingTime() {
        this.m_maxTimeProcessing.set(0L);
        this.m_weightedAverage = 0.0;
        this.m_weightedAverageCount.set(0L);
    }

    public int getMonitoredHostsCount() {
        int res = 0;
        this.m_monitoredHostsLock.readLock().lock();
        try {
            res = this.m_monitoredHosts.size();
        }
        finally {
            this.m_monitoredHostsLock.readLock().unlock();
        }
        return res;
    }

    @Override
    public SEventFwd getEvent(String ID) {
        SEventFwd e = this.getActive(ID);
        if (e == null) {
            e = this.getAcknowledged(ID);
        }
        return e;
    }

    public void cleanProcessedAKeys(boolean softClean) {
        if (!softClean) {
            this.processedAKeys.clear();
        } else {
            long max = System.currentTimeMillis() - 3600000L;
            this.processedAKeys.entrySet().removeIf(en -> (Long)en.getValue() < max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAnnotations(String messageID) {
        LinkedList<String> list = new LinkedList<String>();
        HashMapMap<String, Annotation> hashMapMap = this.m_DBannotations;
        synchronized (hashMapMap) {
            Map<Annotation, Object> m = this.m_DBannotations.getHashMap(messageID);
            if (m != null) {
                for (Annotation annotation : m.keySet()) {
                    String str = annotation.toString();
                    if (list.contains(str)) continue;
                    list.add(str);
                }
            }
        }
        try {
            List<String> db = ServerEngine.getInstance().getDB().loadAnnotations(messageID);
            db.removeAll(list);
            list.addAll(db);
        }
        catch (SQLException e) {
            RTLogger.print(6, "", e);
        }
        SEventFwd sef = this.getEvent(messageID);
        if (sef != null) {
            for (String string : sef.getAnnotations()) {
                if (list.contains(string)) continue;
                list.add(string);
                this.markToSaveAnnotations(messageID, Annotation.parseString(string));
            }
            if (sef.getT9() != null && !sef.getT9().isEmpty()) {
                list.add(sef.getT9());
            }
        }
        return list;
    }

    public ConcurrentLinkedQueue<SEventFwd> getFailedToInsertOrUpdate() {
        return this.m_failedToInsertOrUpdate;
    }

    public GUIClientProxyMgr getClientProxyMgr() {
        return this.m_clientCacheMgr;
    }

    public int getInsertedAsClosedCount() {
        return (int)this.getActiveAndInsertedAsClosedStream().filter(s -> '-' != s.getState()).count();
    }

    public Stream<SEventFwd> getActiveAndInsertedAsClosedStream() {
        return this.m_activeAndInsertedAsClosed.values().stream();
    }

    public Stream<SEventFwd> getClosedStream() {
        return this.m_closed.values().stream();
    }

    public Map<String, Object> getMonitoredHosts() {
        return this.m_monitoredHosts;
    }

    public void cleanAll() {
        this.m_activeAndInsertedAsClosed.clear();
        this.m_closed.clear();
        this.m_msgkeys.clear();
        this.m_cube = Cube.getInstance();
        this.m_failedToInsertOrUpdate.clear();
        this.m_monitoredHosts.clear();
        this.m_DBacknByNewMsg.clear();
        this.m_DBannotations.clear();
        this.m_DBnewORupdate.clear();
        this.m_DBsetDeleted.clear();
        this.m_DBOnlyDeleteNOArchive.clear();
        this.m_DBnewORupdateEXT.clear();
        this.m_DBUpdateDuplicateCounts.clear();
        this.resetMaxProcessingTime();
    }

    public int pendingToSave() {
        return this.m_DBnewORupdate.size() + this.m_DBnewORupdateEXT.size() + this.m_DBUpdateDuplicateCounts.size() + this.m_DBacknByNewMsg.size() + this.m_DBannotations.size() + this.m_DBsetDeleted.size() + this.m_DBOnlyDeleteNOArchive.size() + this.m_failedToInsertOrUpdate.size();
    }
}

