/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.IUiNotificator;
import com.blixx.shared.pg.INodeGroupTree;
import com.blixx.shared.utils.IAgentManager;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class ExternalHostResolver
implements Runnable {
    protected IAgentManager<AgentCard> m_resolver = null;
    protected INodeGroupTree m_ngr = null;
    protected IUiNotificator m_uiNoti = null;
    protected LinkedBlockingQueue<String[]> m_incomingExtenalHosts = new LinkedBlockingQueue();
    private final Object lock = new Object();

    public void offer(String hostnameOrIP, String agentID) {
        this.m_incomingExtenalHosts.offer(new String[]{hostnameOrIP, agentID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastLog = 0L;
        while (true) {
            try {
                while (true) {
                    List<AgentCard> cards2;
                    List<SlaveServerCard> slaveList;
                    if ((slaveList = ServerEngine.getInstance().getSlaveServerFactory().getSlaves()) != null && !slaveList.isEmpty()) {
                        boolean isSlavesReady = true;
                        for (SlaveServerCard ssc : slaveList) {
                            if (!ssc.isAgentsRequested() && System.currentTimeMillis() - lastLog > 300000L) {
                                RTLogger.print(3, "ExternalHostResolver: Agents form slave %s not yet arrived", ssc.getHostName());
                                lastLog = System.currentTimeMillis();
                            }
                            isSlavesReady = isSlavesReady && ssc.isAgentsRequested();
                        }
                        if (!isSlavesReady) {
                            Object object = this.lock;
                            synchronized (object) {
                                this.lock.wait(1000L);
                            }
                        }
                    }
                    String[] arr = this.m_incomingExtenalHosts.take();
                    String hostNameOrIP = arr[0];
                    String agentID = arr[1];
                    String host = null;
                    String ip = null;
                    String fqdn = null;
                    List<AgentCard> cards = this.m_resolver.getExternalHostsLocalOnly(hostNameOrIP);
                    if (!cards.isEmpty() || this.m_resolver.isHostNameOrIPKnown(hostNameOrIP)) continue;
                    try {
                        InetAddress ia = InetAddress.getByName(hostNameOrIP);
                        host = ia.getHostName();
                        if (host != null && ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
                            host = host.toLowerCase();
                        }
                        if ((ip = ia.getHostAddress()) != null) {
                            if (ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
                                ip = ip.toLowerCase();
                            }
                            if (ip.equals(host)) {
                                host = null;
                            }
                        }
                        fqdn = ia.getCanonicalHostName();
                        if (ip != null && ip.equals(fqdn)) {
                            fqdn = null;
                        }
                        if (fqdn != null && ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
                            fqdn = fqdn.toLowerCase();
                        }
                    }
                    catch (Throwable ia) {
                        // empty catch block
                    }
                    RTLogger.print(5, "EHR queue size = " + this.m_incomingExtenalHosts.size());
                    if (ip != null && this.m_resolver.isHostNameOrIPKnown(ip) || host != null && this.m_resolver.isHostNameOrIPKnown(host) || fqdn != null && this.m_resolver.isHostNameOrIPKnown(fqdn)) continue;
                    if (host != null && !host.equals(hostNameOrIP)) {
                        cards2 = this.m_resolver.getExternalHostsLocalOnly(host);
                        cards.addAll(cards2);
                    }
                    if (ip != null && !ip.equals(hostNameOrIP)) {
                        cards2 = this.m_resolver.getExternalHostsLocalOnly(ip);
                        cards.addAll(cards2);
                    }
                    if (fqdn != null && !fqdn.equals(hostNameOrIP) && !fqdn.equals(host)) {
                        cards2 = this.m_resolver.getExternalHostsLocalOnly(fqdn);
                        cards.addAll(cards2);
                    }
                    if (cards.isEmpty()) {
                        this.storeExternalAgentCard(hostNameOrIP, host, ip, fqdn, agentID);
                        continue;
                    }
                    Collections.sort(cards, new Comparator<AgentCard>(){

                        @Override
                        public int compare(AgentCard o1, AgentCard o2) {
                            int rating1 = 0;
                            int rating2 = 0;
                            if (o1.isApproved()) {
                                ++rating1;
                            }
                            if (o2.isApproved()) {
                                ++rating2;
                            }
                            if (o1.getAgentIP() != null && !o1.getAgentIP().isEmpty()) {
                                ++rating1;
                            }
                            if (o2.getAgentIP() != null && !o2.getAgentIP().isEmpty()) {
                                ++rating2;
                            }
                            if (!ExternalHostResolver.this.m_ngr.getNodeGroupTree().findLinksByName(o1.getAgentID(), "agt").isEmpty()) {
                                ++rating1;
                            }
                            if (!ExternalHostResolver.this.m_ngr.getNodeGroupTree().findLinksByName(o2.getAgentID(), "agt").isEmpty()) {
                                ++rating2;
                            }
                            return rating2 - rating1;
                        }
                    });
                    AgentCard ac = cards.get(0);
                    Set<String> hostnames = AbstractAgentCard.getAllHostnames(ac);
                    Set<String> ips = AbstractAgentCard.getAllIPs(ac);
                    if (!hostnames.contains(ip)) {
                        ips.add(ip);
                    }
                    if (!hostnames.contains(host)) {
                        ips.add(host);
                    }
                    if (!hostnames.contains(fqdn)) {
                        ips.add(fqdn);
                    }
                    StringBuilder sb = new StringBuilder();
                    Iterator<String> it = hostnames.iterator();
                    while (it.hasNext()) {
                        sb.append(it.next());
                        if (!it.hasNext()) continue;
                        sb.append('|');
                    }
                    ac.setHost(sb.toString());
                    StringBuilder sb2 = new StringBuilder();
                    Iterator<String> it2 = ips.iterator();
                    while (it2.hasNext()) {
                        sb2.append(it2.next());
                        if (!it2.hasNext()) continue;
                        sb2.append('|');
                    }
                    ac.setIP(sb2.toString());
                    this.m_resolver.saveAgentCard_notifySingle(ac);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable e) {
                RTLogger.print(5, "EHR", e);
                continue;
            }
            break;
        }
    }

    private void storeExternalAgentCard(String hostNameOrIP, String host, String ip, String fqdn, String agentID) {
        Object ipString = null;
        if (host != null || ip != null || fqdn != null) {
            ipString = "";
            if (ip != null) {
                if (!hostNameOrIP.equalsIgnoreCase(ip)) {
                    ipString = (String)ipString + ip;
                } else if (host != null) {
                    hostNameOrIP = host;
                    ipString = (String)ipString + ip;
                } else if (fqdn != null) {
                    hostNameOrIP = fqdn;
                    ipString = (String)ipString + ip;
                }
            }
            if (host != null && !hostNameOrIP.equalsIgnoreCase(host)) {
                ipString = !((String)ipString).isEmpty() ? (String)ipString + "|" + host : (String)ipString + host;
            }
            if (fqdn != null && !hostNameOrIP.equalsIgnoreCase(fqdn)) {
                ipString = !((String)ipString).isEmpty() ? (String)ipString + "|" + fqdn : (String)ipString + fqdn;
            }
            if (((String)ipString).isEmpty()) {
                ipString = null;
            }
        }
        AgentCard ac = new AgentCard(hostNameOrIP, (String)ipString, hostNameOrIP, "");
        ac.setUnApproved();
        if (agentID != null && !agentID.isEmpty()) {
            boolean saveACM = false;
            AgentCardCM extInfo = new AgentCardCM(ac.getAgentID());
            try {
                String acid = (String)extInfo.getValue("ACID");
                if (acid == null) {
                    extInfo.add("ACID", agentID);
                    saveACM = true;
                } else if (!acid.contains(agentID)) {
                    extInfo.add("ACID", acid + "," + agentID);
                    saveACM = true;
                }
            }
            catch (Exception e) {
                RTLogger.print(3, "", e);
            }
            if (saveACM) {
                try {
                    ServerEngine.getInstance().getAgentRepository().saveAgentCardCM(extInfo);
                }
                catch (Exception e) {
                    RTLogger.print(3, "", e);
                }
            }
        }
        this.addExternalHost(ac, null);
    }

    public void setAgentResolver(IAgentManager<AgentCard> resolver) {
        this.m_resolver = resolver;
    }

    public void setNodeGroupTree(INodeGroupTree ngr) {
        this.m_ngr = ngr;
    }

    public void setUiNotificator(IUiNotificator uiNoti) {
        this.m_uiNoti = uiNoti;
    }

    public void addExternalHost(AgentCard ac, String userName) {
        if (ac != null && ac.getAgentPort() == 0) {
            if (ServerEngine.getInstance().getServerProps().isUseHostLowercase()) {
                try {
                    ac.setHost(ac.getAgentHost().toLowerCase());
                    ac.setIP(ac.getAgentIP().toLowerCase());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ac.setOSName("_External");
            ac.setModeSilently(1);
            ServerEngine.getInstance().getAgentRepository().saveAgentCard(ac);
            this.m_resolver.putAgentCard(ac);
            ServerEngine.getInstance().getAuditLog().logCreate(userName == null ? "BOOM_SERVER" : userName, ac.toString());
            try {
                if (ac.isApproved()) {
                    // empty if block
                }
                ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().addPendingToALL(new CMD("GETAGENTCARDS", null, null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

