/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.in.ScDeleteAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScDeleteExtendedServerPolicy;
import com.blixx.ctrl.sc.in.ScDeletePowerGroup;
import com.blixx.ctrl.sc.in.ScDeleteServerPolicy;
import com.blixx.ctrl.sc.in.ScEnableAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScEnableExtendedServerPolicy;
import com.blixx.ctrl.sc.in.ScEnableServerPolicy;
import com.blixx.ctrl.sc.in.ScGetAgentCMLabels;
import com.blixx.ctrl.sc.in.ScGetAgentCardSingle;
import com.blixx.ctrl.sc.in.ScGetAgentPolicies;
import com.blixx.ctrl.sc.in.ScGetAgentsCM;
import com.blixx.ctrl.sc.in.ScGetAsnPermissionTree;
import com.blixx.ctrl.sc.in.ScGetBinaryTreeMD5;
import com.blixx.ctrl.sc.in.ScGetNodeGroupPermissionTree;
import com.blixx.ctrl.sc.in.ScGetPolicyGroupsXml;
import com.blixx.ctrl.sc.in.ScGetPolicyPermissionTree;
import com.blixx.ctrl.sc.in.ScGetPolicyTreeMD5;
import com.blixx.ctrl.sc.in.ScGetPowerGroups;
import com.blixx.ctrl.sc.in.ScGetUsersConnected;
import com.blixx.ctrl.sc.in.ScPushIndi2Notifier;
import com.blixx.ctrl.sc.in.ScPutAgentsCM;
import com.blixx.ctrl.sc.in.ScPutPowerGroups;
import com.blixx.ctrl.sc.in.ScSaveExtendedPolicies;
import com.blixx.ctrl.sc.in.ScSaveServerPolicies;
import com.blixx.ctrl.sc.in.ScSetAgentAttribute;
import com.blixx.ctrl.sc.in.ScSetExtendedServerPoliciesOrder;
import com.blixx.ctrl.sc.in.ScSetServerPoliciesOrder;
import com.blixx.ctrl.sc.in.ScUndeployAll;
import com.blixx.ctrl.sc.in.ScValidateCmd;
import com.blixx.ext.IAction;
import com.blixx.log.RTLogger;
import com.blixx.sa.BMClassLoader;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.server.ActionsRepository;
import com.blixx.server.AgentCard;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.AutoSyncAction;
import com.blixx.server.BinariesRepository;
import com.blixx.server.CSRStorage;
import com.blixx.server.CertificateStateIndicationHelper;
import com.blixx.server.DeployClient;
import com.blixx.server.DeploymentManager;
import com.blixx.server.EventBatchJob;
import com.blixx.server.EventOperations;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.EventsRouter;
import com.blixx.server.FileTransfer;
import com.blixx.server.GUIBackupSlaveMethods;
import com.blixx.server.GUIClientProxy;
import com.blixx.server.GUIClientProxyMgr;
import com.blixx.server.GUIWorkerMethods;
import com.blixx.server.IEventProcessor;
import com.blixx.server.IRemoteProcessing;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.SAssignmentRepository;
import com.blixx.server.SMessage;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerActionsManager;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerClientQ;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.correlation.AgentOutageManager;
import com.blixx.server.correlation.IServerPolicyManager;
import com.blixx.server.correlation.ModifyIndicationManager;
import com.blixx.server.correlation.OutageManager;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DeleteTask;
import com.blixx.server.ext.EventIterator;
import com.blixx.server.jetty.InternalHttpRequest;
import com.blixx.server.jetty.InternalHttpResponse;
import com.blixx.server.jetty.JettyMain;
import com.blixx.server.jetty.OldNanoHandler;
import com.blixx.server.notify.NotifierManager;
import com.blixx.server.perf.NanoHTTPD;
import com.blixx.server.utils.BkpFile;
import com.blixx.server.utils.CheckAgentCardsConflicts;
import com.blixx.server.utils.CreateAgentRcpUi;
import com.blixx.server.utils.SearchPolicies;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Action;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.BM;
import com.blixx.shared.Condition;
import com.blixx.shared.Cryptor;
import com.blixx.shared.IEvent;
import com.blixx.shared.IODataStream;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyDeployed;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.Severity;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.FPolicyFactory;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.ext.IPluginIO;
import com.blixx.shared.ext.IPluginSt;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.io.ByteArray;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.notify.Notifier;
import com.blixx.shared.notify.NovelConfig;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.ArchiveDetails;
import com.blixx.shared.utils.AsfUtils;
import com.blixx.shared.utils.EventStorageUtils;
import com.blixx.shared.utils.FileFilterPrefix;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.HashMapArray;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.StrUtils;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.ZIP;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import com.boom.crt.CertificateManager;
import com.boom.crt.KeyStoreRollbackException;
import com.boom.crt.KeysStoreSwitchException;
import com.boom.crt.hlp.BasicCertificateInfo;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.google.gson.GsonBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.ssl.KeyStoreScanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.w3c.dom.Document;

public class GUIWorker
extends CMDS
implements Runnable {
    private static final String INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED = "Insufficient rights. Operation not permitted.";
    private static final String OPERATION_REJECTED = "Operation rejected! Your version of the UI is incompatible with current version of the server.";
    private static final String EMPTY = "";
    private static final String SERVER_S_DB_IS_DOWN = "Server's DB is down";
    private static final String LOGIN_PASSWORD_INVALID = "login/password invalid";
    private static final String MAX_NUMBER_OF_CLIENTS_REACHED = "Max number of clients reached.";
    public static ConcurrentHashMap<String, Set<GUIWorker>> m_users = new ConcurrentHashMap();
    private final ServerEngine m_serverEngine;
    SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Socket m_socket;
    private String m_login;
    private boolean isTLS = false;
    private UserRole m_userRole;
    private String m_hostAddressConnected;
    private String m_sessionID = "";
    public static Pattern m_slaveServerActionPattern = Pattern.compile(".*(\\Q(BS:\\E(.*)\\)).*");
    public long m_lastTimeActivity = System.currentTimeMillis();
    public Map<String, String> m_COMMAND_OPTIONS = new LinkedHashMap<String, String>();
    private static final Object m_nodeGroupLock = new Object();
    public static final String IMAGE_FOLDER_CUT_STR = "IMAGE_FOLDER_CUT";

    public GUIWorker(Socket socket) {
        this.m_serverEngine = ServerEngine.getInstance();
        this.m_socket = socket;
        if (this.m_socket != null) {
            try {
                this.m_socket.setSoTimeout(120000);
                this.m_socket.setTcpNoDelay(true);
                this.m_socket.setSoLinger(true, 1);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public static void disconnectUser(String user) {
        if (user == null) {
            return;
        }
        Object stackStr = EMPTY;
        try {
            throw new Exception("track who call disconnect");
        }
        catch (Throwable e) {
            try {
                StackTraceElement[] stack = e.getStackTrace();
                stackStr = " by " + stack[1].getClassName() + "." + stack[1].getMethodName();
            }
            catch (Throwable stack) {
                // empty catch block
            }
            String finStack = stackStr;
            Callable<String> call = () -> {
                GUIWorker.sleep(1000);
                RTLogger.print(2, "Disconnect " + user + finStack);
                Set<GUIWorker> connectedClients = m_users.remove(user);
                if (connectedClients != null) {
                    connectedClients.forEach(gw -> {
                        if (gw.m_socket != null && !gw.m_socket.isClosed()) {
                            SocketUtils.closeSocketServerSide(gw.m_socket, new AutoCloseable[0]);
                        }
                    });
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_CONNECTED_USERS");
                    ServerEngine.getInstance().getAuditLog().log(user, "DISCONNECT", (String)null, null);
                }
                try {
                    UserManager.getInstance().cleanUserCache(user);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ServerEngine.getInstance().getEventsRouter().getEventOperations().getClientProxyMgr().removeClientCache(user);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage().getClientProxyMgr().removeClientCache(user);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            };
            ServerThreadPool.getInstance().submit(call);
            return;
        }
    }

    private static NovelConfig convertNotificationNovelConfigForGui(NovelConfig cfg) {
        Properties guiCompatibleProps = new Properties();
        guiCompatibleProps.putAll((Map<?, ?>)cfg.getProperties());
        String pwd = guiCompatibleProps.getProperty("mail.smtp.password.encrypted");
        if (pwd != null && !pwd.isEmpty()) {
            guiCompatibleProps.setProperty("mail.smtp.password", Cryptor.decrypt(pwd));
        }
        NovelConfig guiNovelConfig = new NovelConfig(guiCompatibleProps, cfg.getType(), cfg.getId());
        guiNovelConfig.setNotifierStatus(cfg.getNotifierStatus());
        return guiNovelConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block23: {
            try {
                Thread.currentThread().setPriority(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SDataOutputStream out = null;
            SDataInputStream in = null;
            out = new SDataOutputStream(this.m_socket.getOutputStream(), 1);
            in = new SDataInputStream(this.m_socket.getInputStream());
            this.m_lastTimeActivity = System.currentTimeMillis();
            this.processIncomingData(out, in);
            try {
                if (this.m_login != null) {
                    Set<GUIWorker> al = m_users.get(this.m_login);
                    if (al != null) {
                        al.remove(this);
                        RTLogger.print(5, this.m_login + " out, conns remain: " + al.size());
                    } else {
                        RTLogger.print(5, this.m_login + " out, no conns");
                    }
                }
            }
            catch (Throwable e1) {
                RTLogger.print(5, "CU ", e1);
            }
            SocketUtils.closeSocketServerSide(this.m_socket, out, in);
            break block23;
            catch (Throwable tr) {
                block22: {
                    try {
                        if (this.m_login != null) {
                            RTLogger.print(2, "GUI Client closed connection. [" + this.m_login + "]", tr);
                            GUIWorker.disconnectUser(this.m_login);
                            break block22;
                        }
                        RTLogger.print(2, "Failed attempt to connect from " + String.valueOf(this.m_socket.getRemoteSocketAddress()) + ". Login missing.");
                    }
                    catch (Throwable throwable) {
                        try {
                            if (this.m_login != null) {
                                Set<GUIWorker> al = m_users.get(this.m_login);
                                if (al != null) {
                                    al.remove(this);
                                    RTLogger.print(5, this.m_login + " out, conns remain: " + al.size());
                                } else {
                                    RTLogger.print(5, this.m_login + " out, no conns");
                                }
                            }
                        }
                        catch (Throwable e1) {
                            RTLogger.print(5, "CU ", e1);
                        }
                        SocketUtils.closeSocketServerSide(this.m_socket, out, in);
                        throw throwable;
                    }
                }
                try {
                    if (this.m_login != null) {
                        Set<GUIWorker> al = m_users.get(this.m_login);
                        if (al != null) {
                            al.remove(this);
                            RTLogger.print(5, this.m_login + " out, conns remain: " + al.size());
                        } else {
                            RTLogger.print(5, this.m_login + " out, no conns");
                        }
                    }
                }
                catch (Throwable e1) {
                    RTLogger.print(5, "CU ", e1);
                }
                SocketUtils.closeSocketServerSide(this.m_socket, out, in);
            }
        }
    }

    private void processIncomingData(SDataOutputStream out, SDataInputStream in) throws Exception {
        block24: {
            if (in.available() == 0) {
                GUIWorker.sleep(200);
            }
            if (in.available() > 0) {
                String str = in.readUTF();
                if (in.getLastProtocolVersion() != out.getVersion()) {
                    out.setVersion(in.getLastProtocolVersion());
                    RTLogger.print(5, "GUIWorker: set protocol version: " + out.getVersion());
                }
                if (!str.equals("PING") && "+".equalsIgnoreCase(str)) {
                    this.m_socket = TlsUtils.upgradeServerSocket(this.m_socket, ServerEngine.getInstance().getCertificateManager(), false, false);
                    this.isTLS = true;
                }
            }
            out.writeUTF("login");
            this.m_login = in.readUTF().toLowerCase(Locale.getDefault());
            if ("+".equalsIgnoreCase(this.m_login)) {
                this.m_socket = TlsUtils.upgradeServerSocket(this.m_socket, ServerEngine.getInstance().getCertificateManager(), false, false);
                this.isTLS = true;
                out.writeUTF("login");
                this.m_login = in.readUTF().toLowerCase(Locale.getDefault());
            }
            if (in.getLastProtocolVersion() != out.getVersion()) {
                out.setVersion(in.getLastProtocolVersion());
                RTLogger.print(3, "GUIWorker: set protocol version: " + out.getVersion() + " login: " + this.m_login);
            }
            out.writeUTF("password");
            String password = in.readUTF();
            try {
                this.m_hostAddressConnected = this.m_socket.getInetAddress().getHostAddress();
                String from = " Host: " + this.m_hostAddressConnected;
                int sep = this.m_login.indexOf(9658);
                if (sep != -1) {
                    this.m_sessionID = this.m_login.substring(sep + 1);
                    from = from + this.m_login.substring(sep);
                    this.m_login = this.m_login.substring(0, sep);
                }
                if (this.checkUser(this.m_login, password, from)) {
                    if (m_users.containsKey(this.m_login) || m_users.size() < ServerProperties.getMAX_CONNECTED_USERS(this, false)) {
                        if (this.checkInvalidSession(out, from)) {
                            return;
                        }
                        RTLogger.print(6, "UI - upgraded to TLS: " + this.isTLS + ". User: " + this.m_login);
                        LinkedList<String> history = new LinkedList<String>();
                        String command = "-";
                        int noDataCount = 0;
                        try {
                            while (!this.m_socket.isClosed() && !"EXIT".equalsIgnoreCase(command = in.readUTF())) {
                                if (command == null) {
                                    RTLogger.print(3, "No data from UI. History: " + String.valueOf(history));
                                    if (++noDataCount <= 3 && !this.m_socket.isClosed()) continue;
                                    throw new IOException("No data from ui of user: " + this.m_login);
                                }
                                history.add(command);
                                while (history.size() > 20) {
                                    history.remove(0);
                                }
                                if (!this.processCommand2(command, out, in, this.m_login)) {
                                    throw new RuntimeException("Unknown command: " + command);
                                }
                                out.flush();
                                this.m_lastTimeActivity = System.currentTimeMillis();
                            }
                            break block24;
                        }
                        catch (IOException e) {
                            RTLogger.print(5, "closing socket. Last cmd: " + command);
                            throw e;
                        }
                    }
                    String msg = MAX_NUMBER_OF_CLIENTS_REACHED;
                    RTLogger.print(3, msg + from);
                    out.writeUTF(msg);
                    break block24;
                }
                String msg = LOGIN_PASSWORD_INVALID;
                if (UserManager.getInstance().getUser(this.m_login) == null) {
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "FAILEDLOGIN", from, null);
                } else if (!UserManager.getInstance().isUserEnabled(this.m_login)) {
                    msg = "Account disabled";
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "ACCOUNTDISABLED", from, null);
                } else if (UserManager.getInstance().isUserLocked(this.m_login)) {
                    msg = "Account locked, please try later.";
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "ACCOUNTLOCKED", from, null);
                } else {
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "WRONGCREDENTIALS", from, null);
                }
                out.writeUTF(msg);
            }
            catch (DBException e) {
                out.writeUTF(SERVER_S_DB_IS_DOWN);
            }
        }
    }

    private synchronized boolean checkInvalidSession(SDataOutputStream out, String from) throws IOException {
        block10: {
            Set<GUIWorker> clientsConnected = m_users.get(this.m_login);
            if (clientsConnected != null && clientsConnected.size() > 0) {
                try {
                    Iterator<GUIWorker> iterator = clientsConnected.iterator();
                    GUIWorker gw = null;
                    ArrayList<GUIWorker> deadList = new ArrayList<GUIWorker>();
                    while (iterator.hasNext()) {
                        GUIWorker gwT = iterator.next();
                        if (gwT.m_socket == null) {
                            deadList.add(gwT);
                            continue;
                        }
                        long deltaLastActivity = System.currentTimeMillis() - gwT.m_lastTimeActivity;
                        if (gwT.m_socket.isClosed() || deltaLastActivity > 1800000L) {
                            SocketUtils.closeSocketServerSide(gwT.m_socket, new AutoCloseable[0]);
                            gwT.m_socket = null;
                            deadList.add(gwT);
                            continue;
                        }
                        gw = gwT;
                    }
                    if (deadList.size() > 0) {
                        deadList.forEach(clientsConnected::remove);
                    }
                    if (!this.m_serverEngine.getServerProps().getLoadBlancingIPs().contains(this.m_hostAddressConnected) || gw == null || gw.m_hostAddressConnected == null || gw.m_sessionID == null) break block10;
                    String hostAddress2 = gw.m_hostAddressConnected;
                    String sessionID2 = gw.m_sessionID;
                    if (!hostAddress2.equals(this.m_hostAddressConnected) || !sessionID2.equals(this.m_sessionID)) {
                        String msg = "User \"" + this.m_login + "\" tries to connect from: " + from;
                        RTLogger.print(3, msg);
                        msg = "Rejected. \"" + this.m_login + "\" already connected from " + hostAddress2 + "|" + sessionID2;
                        RTLogger.print(3, msg);
                        out.writeUTF(msg);
                        return true;
                    }
                }
                catch (Exception e) {
                    RTLogger.print(5, "CU " + from, e);
                }
            } else if (clientsConnected == null) {
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "CONNECT", this.m_sessionID, null);
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_CONNECTED_USERS");
            }
        }
        out.writeUTF("OK");
        m_users.computeIfAbsent(this.m_login, l -> new HashSet()).add(this);
        return false;
    }

    protected boolean processCommand2(String command, SDataOutputStream out, SDataInputStream in, String user) {
        boolean knownCMD = true;
        try {
            int number;
            Integer numm;
            this.m_COMMAND_OPTIONS.clear();
            if (RTLogger.getCurrentLevel() >= 7) {
                RTLogger.print(7, "GUICMD: " + command);
            }
            if ((numm = (Integer)m_acceptable.get(command)) == null) {
                numm = -1;
            }
            if ((number = numm.intValue()) == 158) {
                while (in.readBoolean()) {
                    String name = in.readUTF();
                    String value = in.readUTF();
                    this.m_COMMAND_OPTIONS.put(name, value);
                }
                command = in.readUTF();
                numm = (Integer)m_acceptable.get(command);
                if (numm == null) {
                    numm = -1;
                }
                number = numm;
            }
            switch (number) {
                case 4: {
                    this.processGetFreshActiveMsgs(out, user);
                    break;
                }
                case 5: {
                    this.processGetFreshActiveMsgsEXT(out, user);
                    break;
                }
                case 1: 
                case 71: {
                    this.processGetFreshAcknMsgs(out, user);
                    break;
                }
                case 2: {
                    this.processGetFreshAcknMsgsEXT(out, user);
                    break;
                }
                case 107: {
                    this.processGetLastWeekArchivedIDs(out);
                    break;
                }
                case 6: {
                    this.processGetFreshActiveMsgsEXT_ZIP(out, user, in.getLastProtocolVersion(), this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 38: {
                    this.processGetFreshActiveMsgsEXT_ZIP(out, user, in.getLastProtocolVersion(), this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 3: {
                    this.processGetFreshAcknMsgsEXT_ZIP(out, user, in.getLastProtocolVersion(), this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 39: {
                    this.processGetFreshAcknMsgsEXT_ZIP(out, user, in.getLastProtocolVersion(), this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 44: {
                    this.m_serverEngine.getEventsRouter().getEventOperationsOutage().getClientProxyMgr().removeClientCache(user);
                    out.writeUTF("T");
                    break;
                }
                case 73: {
                    this.processGetAcknIDs(out);
                    break;
                }
                case 74: {
                    this.processGetAcknIDsA(out);
                    break;
                }
                case 75: {
                    this.processGetAcknIDsB(out, user);
                    break;
                }
                case 7: {
                    out.writeUTF("valid");
                    break;
                }
                case 8: {
                    this.processGetNewMsgs(out, user);
                    break;
                }
                case 9: {
                    this.processGetNewMsgsEXT(out, user, this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 40: {
                    this.processGetNewMsgsEXT(out, user, this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 10: {
                    this.processGetAcknowledgedMsgs(out, user, this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 41: {
                    this.processGetAcknowledgedMsgs(out, user, this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 11: {
                    this.processGetAcknowledgedMsgsB(out, user);
                    break;
                }
                case 12: {
                    this.processGetUpdatedMessages(out, user);
                    break;
                }
                case 13: {
                    this.processGetUpdatedMessagesEXT(out, user, this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 42: {
                    this.processGetUpdatedMessagesEXT(out, user, this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 15: {
                    this.processGetArchivedMessages(out, user, this.m_serverEngine.getEventsRouter().getEventOperations());
                    break;
                }
                case 43: {
                    this.processGetArchivedMessages(out, user, this.m_serverEngine.getEventsRouter().getEventOperationsOutage());
                    break;
                }
                case 57: {
                    this.processGetPending(out);
                    break;
                }
                case 16: {
                    this.processRemoteAction(out, in);
                    break;
                }
                case 17: {
                    this.processingJob(out, in);
                    break;
                }
                case 27: {
                    File policyGroups_xml = new File(SPolicyRepository.getPolicyGroupsFile());
                    new ScGetPolicyGroupsXml().runCommandOnServer(policyGroups_xml, out);
                    break;
                }
                case 28: {
                    this.processGetAssignments(out);
                    break;
                }
                case 24: {
                    this.processGetAgentCard(out);
                    break;
                }
                case 105: {
                    this.processGetAgentCardList(out, in);
                    break;
                }
                case 35: {
                    this.processGetFile(out, in);
                    break;
                }
                case 36: {
                    this.processGetFileSlave(out, in);
                    break;
                }
                case 30: {
                    this.processUpdatePolicy(out, in, false);
                    break;
                }
                case 204: {
                    this.processUpdatePolicy(out, in, true);
                    break;
                }
                case 31: {
                    this.processDeletePolicy(out, in);
                    break;
                }
                case 51: {
                    this.processDeploymentTrigger(out, in);
                    break;
                }
                case 127: {
                    this.processDeploymentTriggerFiltered(out, in);
                    break;
                }
                case 52: {
                    this.processDeploymentCancel(out, in);
                    break;
                }
                case 256: {
                    GUIWorkerMethods gwm = new GUIWorkerMethods(this.m_serverEngine, this.m_login);
                    gwm.processPolicyTreeUpdateWithType(out, in);
                    break;
                }
                case 34: {
                    this.processAssignmentTreeUpdate2(out, in);
                    break;
                }
                case 47: {
                    this.processDeploy(out, in);
                    break;
                }
                case 117: {
                    this.processDeployVirtual(out, in);
                    break;
                }
                case 49: {
                    this.processDeployDelayed(out, in);
                    break;
                }
                case 48: {
                    this.processUnDeploy(out, in);
                    break;
                }
                case 50: {
                    this.processUnDeployDelayed(out, in);
                    break;
                }
                case 53: {
                    this.processAcknMsg(out, in, this.m_serverEngine.getEventsRouter(), "ACKN_MSG");
                    break;
                }
                case 60: {
                    this.processAcknMsg(out, in, this.m_serverEngine.getEventsRouter(), "ACKN_MSG_O");
                    break;
                }
                case 54: 
                case 61: {
                    this.processArchMsg(out, in, this.m_serverEngine.getEventsRouter());
                    break;
                }
                case 55: 
                case 62: {
                    this.processDeleteMsg(out, in, this.m_serverEngine.getEventsRouter());
                    break;
                }
                case 56: {
                    this.processGetAssigned(out, in);
                    break;
                }
                case 29: {
                    this.processGetAllAssignments(out);
                    break;
                }
                case 37: {
                    this.processGetActions(out);
                    break;
                }
                case 58: {
                    this.processUpdateActions(out, in);
                    break;
                }
                case 76: {
                    this.processGetHelps(out);
                    break;
                }
                case 77: {
                    this.processGetHelp(out, in);
                    break;
                }
                case 78: {
                    this.processGetVersions(out, in);
                    break;
                }
                case 202: {
                    this.processGetVersions2(out, in);
                    break;
                }
                case 80: {
                    this.processGetUsers(out);
                    break;
                }
                case 81: {
                    this.processGetUserRoles(out);
                    break;
                }
                case 82: {
                    this.processGetUItems(out);
                    break;
                }
                case 79: {
                    this.processGetUserRole(out, in);
                    break;
                }
                case 83: 
                case 84: 
                case 85: {
                    this.processObjects(out, in, command);
                    break;
                }
                case 89: {
                    this.processGetAnnotation(out, in);
                    break;
                }
                case 90: {
                    this.processPutAnnotation(out, in);
                    break;
                }
                case 59: {
                    this.processUpdateActionTree(out, in);
                    break;
                }
                case 65: {
                    this.processPutFile(out, in);
                    break;
                }
                case 66: {
                    this.processRenameFile(out, in);
                    break;
                }
                case 67: {
                    this.processDeleteFile(out, in);
                    break;
                }
                case 68: {
                    this.processCreateFile(out, in);
                    break;
                }
                case 118: {
                    this.processDeleteFolder(out, in);
                    break;
                }
                case 69: {
                    this.processCreateFolder(out, in);
                    break;
                }
                case 70: {
                    this.processRenamePkg(out, in);
                    break;
                }
                case 14: {
                    this.processClearPending(out);
                    break;
                }
                case 91: {
                    this.processGetForwardFilters(out);
                    break;
                }
                case 92: {
                    this.processPutForwardFilters(out, in);
                    break;
                }
                case 93: {
                    this.processGetForwardPolicies(out);
                    break;
                }
                case 94: {
                    this.processUpdateForwardPolicies(out, in);
                    break;
                }
                case 95: {
                    this.processDeleteForwardPolicies(out, in);
                    break;
                }
                case 96: {
                    this.processActivateForwardPolicy(out, in);
                    break;
                }
                case 97: {
                    this.processRenamePolicyHistory(out, in);
                    break;
                }
                case 98: {
                    this.processCheckUpdate(out, in);
                    break;
                }
                case 99: {
                    this.processGUIUpdate(out);
                    break;
                }
                case 101: {
                    this.processGetAgentInventoryCard(out, in);
                    break;
                }
                case 102: {
                    this.processTriggerAgentInventoryCard(out, in);
                    break;
                }
                case 116: {
                    this.processValidate(out, in);
                    break;
                }
                case 100: {
                    try {
                        this.processGetArchived(out, in);
                        break;
                    }
                    catch (Throwable e1) {
                        return false;
                    }
                }
                case 104: {
                    this.processGetPolicyDetails(out);
                    break;
                }
                case 103: {
                    this.processAnyUpdate(out, in);
                    break;
                }
                case 106: {
                    this.processMasterUpdate(out, in);
                    break;
                }
                case 111: {
                    this.processMasterUpdateTrigger(out, in);
                    break;
                }
                case 112: {
                    this.processMasterUpdateTriggerSync(out, in);
                    break;
                }
                case 108: {
                    try {
                        this.processGetMIBS(out);
                        break;
                    }
                    catch (Throwable e1) {
                        return false;
                    }
                }
                case 109: {
                    this.processGetUIProfile(out);
                    break;
                }
                case 110: {
                    this.processUpdateIndication(out, in);
                    break;
                }
                case 113: {
                    this.processGetAgentVersions(out);
                    break;
                }
                case 114: {
                    this.processGetPolicyVersions(out);
                    break;
                }
                case 115: {
                    this.processGetBinaryPackage(out, in);
                    break;
                }
                case 119: {
                    this.listSJobs(out);
                    break;
                }
                case 120: {
                    this.reloadSJobs(out);
                    break;
                }
                case 121: {
                    this.activateSJob(out, in);
                    break;
                }
                case 122: {
                    this.runSJobOnce(out, in);
                    break;
                }
                case 123: {
                    this.getSJobConfig(out, in);
                    break;
                }
                case 124: {
                    this.setSJobConfig(out, in);
                    break;
                }
                case 125: {
                    this.sendCMDtoUI(out, in);
                    break;
                }
                case 126: {
                    this.getConnectedUsers(out);
                    break;
                }
                case 128: {
                    this.getDirHash(out, in);
                    break;
                }
                case 129: {
                    this.getDirHashShort(out, in);
                    break;
                }
                case 130: {
                    this.processSearchPolicies(out, in);
                    break;
                }
                case 131: 
                case 132: {
                    this.ownIndi(out, in, number);
                    break;
                }
                case 203: {
                    this.reopenIndi(out, in);
                    break;
                }
                case 133: {
                    out.writeInt(out.getVersion());
                    RTLogger.print(5, "GUIWorker: " + this.m_login + " protocol version: " + out.getVersion());
                    break;
                }
                case 134: {
                    this.processGetServerPolicy(this.m_serverEngine.getEventsRouter().getOutageMgr(), out, in);
                    break;
                }
                case 138: {
                    this.processGetServerPoliciesStatus(this.m_serverEngine.getEventsRouter().getOutageMgr(), out);
                    break;
                }
                case 135: {
                    this.processSaveServerPolicies(this.m_serverEngine.getEventsRouter().getOutageMgr(), out, in, user, number);
                    break;
                }
                case 136: {
                    this.processEnableDisableServerPolicy(this.m_serverEngine.getEventsRouter().getOutageMgr(), out, in, user);
                    break;
                }
                case 137: {
                    this.processDeleteServerPolicies(this.m_serverEngine.getEventsRouter().getOutageMgr(), out, in);
                    break;
                }
                case 139: {
                    this.processGetServerPolicy(this.m_serverEngine.getEventsRouter().getAgentOutageMgr(), out, in);
                    break;
                }
                case 143: {
                    this.processGetServerPoliciesStatus(this.m_serverEngine.getEventsRouter().getAgentOutageMgr(), out);
                    break;
                }
                case 140: {
                    this.processSaveServerPolicies(this.m_serverEngine.getEventsRouter().getAgentOutageMgr(), out, in, user, number);
                    break;
                }
                case 141: {
                    this.processEnableDisableServerPolicy(this.m_serverEngine.getEventsRouter().getAgentOutageMgr(), out, in, user);
                    break;
                }
                case 142: {
                    this.processDeleteServerPolicies(this.m_serverEngine.getEventsRouter().getAgentOutageMgr(), out, in);
                    break;
                }
                case 144: {
                    in.readUTF();
                    out.writeInt(-1);
                    break;
                }
                case 148: {
                    this.processGetModifyServerPoliciesStatusReadOnly(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out);
                    break;
                }
                case 145: 
                case 231: {
                    this.processSaveServerPolicies(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out, in, user, number);
                    break;
                }
                case 146: 
                case 232: {
                    this.processEnableDisableServerPolicy(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out, in, user);
                    break;
                }
                case 147: 
                case 233: {
                    this.processDeleteServerPolicies(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out, in);
                    break;
                }
                case 230: {
                    this.processGetServerPolicy(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out, in);
                    break;
                }
                case 234: {
                    this.processGetServerPoliciesStatus(this.m_serverEngine.getEventsRouter().getModifyIndicationMgr(), out);
                    break;
                }
                case 149: {
                    OutageManager ip = this.m_serverEngine.getEventsRouter().getOutageMgr();
                    this.processSetServerPoliciesOrder(out, in, ip);
                    break;
                }
                case 150: 
                case 235: {
                    ModifyIndicationManager ipm = this.m_serverEngine.getEventsRouter().getModifyIndicationMgr();
                    this.processSetServerPoliciesOrder(out, in, ipm);
                    break;
                }
                case 153: {
                    this.processSetSlavePoliciesOrder(out, in);
                    break;
                }
                case 154: 
                case 236: {
                    this.processSetSlavePoliciesOrderMod(out, in);
                    break;
                }
                case 155: {
                    this.processSaveOutagePoliciesSlave(out, in);
                    break;
                }
                case 156: {
                    this.processSaveModifyPoliciesSlave(out, in);
                    break;
                }
                case 237: {
                    this.processSaveExtendedPoliciesSlave(out, in);
                    break;
                }
                case 157: {
                    this.processGetSlaves(out);
                    break;
                }
                case 152: {
                    this.processGetUserAttributes(out);
                    break;
                }
                case 200: {
                    this.processGetMemAnnotations(out, in);
                    break;
                }
                case 201: {
                    this.processPutFileSlave(out, in);
                    break;
                }
                case 151: {
                    Date d = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z(Z)", Locale.ENGLISH);
                    out.writeUTF(sdf.format(d));
                    break;
                }
                case 205: {
                    this.getINotifyList(out);
                    break;
                }
                case 206: {
                    this.startNotifier(out, in);
                    break;
                }
                case 207: {
                    this.stopNotifier(out, in);
                    break;
                }
                case 208: {
                    this.saveNotifierConfig(out, in);
                    break;
                }
                case 210: {
                    this.testNotifierConfig(out, in);
                    break;
                }
                case 209: {
                    this.deleteNotifierConfig(out, in);
                    break;
                }
                case 211: {
                    this.getAvailableSmsTransports(out);
                    break;
                }
                case 159: {
                    this.userAuth(out, in);
                    break;
                }
                case 212: {
                    this.processGetStrings(out, in);
                    break;
                }
                case 213: {
                    this.processGetIODataStreamObject(out, in);
                    break;
                }
                case 214: {
                    new ScGetPolicyPermissionTree(null).runCommandServer(in, out, UserManager.getInstance().getPolicyTreePermissions(this.m_login));
                    break;
                }
                case 221: {
                    new ScGetAsnPermissionTree(null).runCommandServer(in, out, UserManager.getInstance().getAsnTreePermissions(this.m_login));
                    break;
                }
                case 216: {
                    new ScGetPowerGroups(null, null).runCommandServer(in, out, UserManager.getInstance());
                    break;
                }
                case 217: {
                    new ScPutPowerGroups(null, null, null).runCommandServer(in, out, UserManager.getInstance());
                    break;
                }
                case 218: {
                    new ScDeletePowerGroup(null, null, null).runCommandServer(in, out, UserManager.getInstance());
                    break;
                }
                case 219: {
                    UserManager.getInstance().loadPowerGroups();
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_POLICYTREEPERMISSIONS");
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ASNTREEPERMISSIONS");
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_NODEGROUPTREEPERMISSIONS");
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_POWERGROUPS");
                    break;
                }
                case 220: {
                    ScPushIndi2Notifier sc = new ScPushIndi2Notifier(null, null, null);
                    sc.runCommandServer(in, out, NotifierManager.getInstance(), this.m_serverEngine.getEventsRouter(), this.m_login);
                    break;
                }
                case 222: {
                    ScGetPolicyTreeMD5 scPTMD5 = new ScGetPolicyTreeMD5(null);
                    scPTMD5.runCommandServer(in, out, this.m_serverEngine.getPolicyRepository().getPolicyTreeWithMD5());
                    break;
                }
                case 223: {
                    ScGetBinaryTreeMD5 scBTMD5 = new ScGetBinaryTreeMD5(null);
                    scBTMD5.runCommandServer(in, out, this.m_serverEngine.getBinariesRepository().getBinaryTreeWithMD5());
                    break;
                }
                case 226: {
                    if (UserManager.getInstance().getRights(2015, user) >= 2) {
                        out.writeUTF("T");
                        ScGetAgentsCM sc226 = new ScGetAgentsCM(null);
                        sc226.runCommandOnServer(in, out, this.m_serverEngine.getAgentRepository().getAgentCardCM());
                        break;
                    }
                    out.writeUTF("Insufficient rights");
                    break;
                }
                case 227: {
                    this.processSetAgentAttributes(out, in, user);
                    break;
                }
                case 224: {
                    if (UserManager.getInstance().getRights(2015, user) >= 2) {
                        out.writeUTF("T");
                        ScGetAgentCMLabels sc226 = new ScGetAgentCMLabels(null);
                        sc226.runCommandOnServer(out, this.m_serverEngine.getAgentRepository().getAgentCardCMLabels());
                        break;
                    }
                    out.writeUTF("Insufficient rights");
                    break;
                }
                case 238: {
                    ScGetAgentCardSingle scgacs = new ScGetAgentCardSingle(null, null, null);
                    scgacs.runCommandServer(in, out, this.m_serverEngine.getAgentRepository());
                    break;
                }
                case 239: {
                    this.processAddNodeGroups(out, in);
                    break;
                }
                case 240: {
                    this.processDeleteNodeGroups(out, in);
                    break;
                }
                case 241: {
                    this.processRenameNodeGroup(out, in);
                    break;
                }
                case 242: {
                    this.processLinkAgents(out, in);
                    break;
                }
                case 243: {
                    this.processUnlinkAgents(out, in);
                    break;
                }
                case 244: {
                    this.processUpdateIndiAttributes(out, in);
                    break;
                }
                case 245: {
                    ScGetUsersConnected scguc = new ScGetUsersConnected(null);
                    GUIClientProxyMgr mgr = this.m_serverEngine.getEventsRouter().getClientProxyMgr();
                    TreeSet<GUIClientProxy> set = new TreeSet<GUIClientProxy>(Comparator.comparing(GUIClientProxy::getUserLogin));
                    set.addAll(mgr.getClientCaches().values());
                    StringBuilder sb = new StringBuilder();
                    for (GUIClientProxy client : set) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(client.getUserLogin()).append("\t(").append(client.getIP()).append(")\t").append(client.getConnectionTimeString());
                    }
                    scguc.runCommandOnServer(in, out, sb.toString());
                    break;
                }
                case 246: {
                    Object ssc;
                    String agentID = in.readUTF();
                    AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                    String error = null;
                    Object policyList = new LinkedList<PolicyDeployed>();
                    if (ac.isLocalAgent()) {
                        if (!ac.isOnline()) {
                            error = "Agent is offline";
                        } else {
                            Map<String, String> mons = null;
                            try {
                                mons = ac.getDeployedMonitorPolicies();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (mons == null) {
                                error = "Agent is offline";
                            } else {
                                Map<String, String> msgs = ac.getDeployedMessagePolicies();
                                Map<String, String> disabled = ac.getDisabledPolicies();
                                policyList.addAll(this.getPolicyDeployedByType(ac, mons, "mon", disabled.keySet()));
                                policyList.addAll(this.getPolicyDeployedByType(ac, msgs, "msg", disabled.keySet()));
                            }
                        }
                    } else {
                        ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                        ScGetAgentPolicies scSlave = new ScGetAgentPolicies((IServerAuth)ssc, agentID);
                        scSlave.run();
                        if (scSlave.isSuccess()) {
                            policyList = scSlave.getResultObject();
                        } else {
                            try {
                                error = scSlave.getLastException().getMessage();
                            }
                            catch (Throwable e) {
                                error = "Error accessing slave server";
                            }
                        }
                    }
                    if (error != null) {
                        out.writeUTF(error);
                        break;
                    }
                    out.writeUTF("T");
                    ssc = policyList.iterator();
                    while (ssc.hasNext()) {
                        PolicyDeployed policyDeployed = (PolicyDeployed)ssc.next();
                        out.writeBoolean(true);
                        out.writeUTF(policyDeployed.getPolicyName());
                        out.writeUTF(policyDeployed.getPolicyType());
                        out.writeUTF(policyDeployed.getPolicyVersionAgent());
                        out.writeUTF(policyDeployed.getPolicyVersionServer());
                        out.writeBoolean(policyDeployed.isPolicyDisabled());
                    }
                    out.writeBoolean(false);
                    out.writeUTF("T");
                    break;
                }
                case 247: {
                    ScSetAgentAttribute scaa = new ScSetAgentAttribute(null, null, null, null);
                    scaa.runCommandOnServer(in, out, this.m_serverEngine.getAgentRepository(), this.m_serverEngine.getAgentRepository().getAgentCardCMLabels());
                    break;
                }
                case 248: {
                    Object message = in.readUTF();
                    String userName = in.readUTF();
                    String errorUImsg = null;
                    message = "------- " + this.m_login + " : " + BM.m_sdf.format(new Date()) + " -------\r\n" + (String)message;
                    if (EMPTY.equals(userName)) {
                        this.m_serverEngine.getEventsRouter().addPendingToALL(new CMD("SHOW_MESSAGE", this.m_login, new String[]{message}));
                    } else {
                        boolean foundUser = this.m_serverEngine.getEventsRouter().addPendingToUser(new CMD("SHOW_MESSAGE", this.m_login, new String[]{message}), userName);
                        if (!foundUser) {
                            errorUImsg = "User is not online: " + userName;
                        }
                    }
                    if (errorUImsg != null) {
                        out.writeUTF(errorUImsg);
                        break;
                    }
                    out.writeUTF("T");
                    break;
                }
                case 251: {
                    String url = in.readUTF();
                    int countParamName = in.read();
                    MultiMap mm = new MultiMap();
                    for (int i = 0; i < countParamName; ++i) {
                        String name = in.readUTF();
                        int countValuesForParam = in.read();
                        for (int j = 0; j < countValuesForParam; ++j) {
                            String val = in.readUTF();
                            mm.add(name, (Object)val);
                        }
                    }
                    InternalHttpRequest hreq = new InternalHttpRequest(user);
                    hreq.setParameters((MultiMap<String>)mm);
                    InternalHttpResponse hres = new InternalHttpResponse(out);
                    OldNanoHandler ha = new OldNanoHandler();
                    try {
                        ha.processJsonURLs(url, (HttpServletRequest)hreq, new Properties(), (HttpServletResponse)hres);
                    }
                    catch (Throwable e) {
                        out.writeUTF("F");
                        out.writeUTF(e.getMessage());
                    }
                    break;
                }
                case 252: {
                    new ScGetNodeGroupPermissionTree(null).runCommandServer(in, out, UserManager.getInstance().getNodeGroupsTreePermissions(user));
                    break;
                }
                case 257: {
                    this.processUndeployAll(in, out);
                    break;
                }
                case 258: {
                    String agtID = in.readUTF();
                    AgentCard acRslvd = this.m_serverEngine.getAgentRepository().getAgentCardByID(agtID);
                    String sev = in.readUTF();
                    String host = in.readUTF();
                    String grp = in.readUTF();
                    String app = in.readUTF();
                    String obj = in.readUTF();
                    String txt = in.readUTF();
                    String agtHost = in.readUTF();
                    String source = in.readUTF();
                    String key = in.readUTF();
                    String closeMask = in.readUTF();
                    SEventFwd sm = SMessage.createMessage(Severity.getSeverity(sev), 0, host, app, obj, grp, txt);
                    sm.setNode(host);
                    sm.setT1(agtID);
                    sm.setAgentNode(agtHost);
                    sm.setSource(source);
                    sm.setKey(key);
                    sm.setCloseMask(closeMask);
                    if (acRslvd != null) {
                        ServerEngine.getInstance().getEventsRouter().submitNewMessage(Collections.singletonList(sm), acRslvd);
                    } else {
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                    }
                    out.writeUTF(sm.getID());
                    out.writeUTF("T");
                    break;
                }
                case 259: {
                    GUIBackupSlaveMethods.processOutages(in, out, this.m_login);
                    break;
                }
                default: {
                    knownCMD = false;
                    RTLogger.print(2, "unknown command: " + command);
                    break;
                }
            }
        }
        catch (IOException e) {
            RTLogger.print(3, "Client connection failed", e);
        }
        catch (Throwable e) {
            RTLogger.print(2, "error0256 ", e);
            try {
                String message = e.getMessage();
                out.writeUTF(message);
                try {
                    out.writeUTF("T");
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return knownCMD;
    }

    private void processUpdateIndiAttributes(SDataOutputStream out, SDataInputStream in) throws IOException {
        String indiID = in.readUTF();
        String attributeName = in.readUTF();
        String attributeValue = in.readUTF();
        SEventFwd sef = this.m_serverEngine.getEventsRouter().getEvent(indiID);
        if (sef == null) {
            out.writeUTF("Indication not found. ID=" + indiID);
        } else if (EventStorageUtils.setCustomAttribute(sef, attributeName, attributeValue)) {
            this.m_serverEngine.getEventsRouter().updateEventsManual(Collections.singletonList(sef), this.m_login);
            this.m_serverEngine.getEventsRouter().getClientProxyMgr().addUpdatedToClients(sef);
            out.writeUTF("T");
        } else {
            out.writeUTF("Not supported attribute: " + attributeName);
        }
    }

    private void processUnlinkAgents(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size1 = in.readInt();
        boolean canDo1 = true;
        ArrayList<String> paths = new ArrayList<String>(size1);
        for (int i = 0; i < size1; ++i) {
            String path1 = in.readUTF();
            if (canDo1 && !UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, path1)) {
                canDo1 = false;
            }
            paths.add(path1);
        }
        try {
            if (canDo1) {
                StringBuilder sb = new StringBuilder();
                NodeGroupRepository.getInstance().unlinkAgent(paths, sb);
                this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                if (sb.length() == 0) {
                    out.writeUTF("T");
                } else {
                    RTLogger.print(3, "Unlink operation impossible. Paths not found: " + String.valueOf(sb));
                    out.writeUTF(sb.toString());
                }
                for (String pathUnlinked : paths) {
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "UNLINK", pathUnlinked, "NodeGroups");
                }
            } else {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void processLinkAgents(SDataOutputStream out, SDataInputStream in) throws IOException {
        String path = in.readUTF();
        int size = in.readInt();
        ArrayList<String> agentIDs = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String agentID = in.readUTF();
            agentIDs.add(agentID);
        }
        try {
            if (UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, path)) {
                NodeGroupRepository.getInstance().linkAgent(path, agentIDs);
                this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                out.writeUTF("T");
                for (String agentID : agentIDs) {
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "LINK", agentID, path);
                }
            } else {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void processRenameNodeGroup(SDataOutputStream out, SDataInputStream in) throws IOException {
        String pathOld = in.readUTF();
        String pathNew = in.readUTF();
        try {
            if (UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, pathOld)) {
                NodeGroupRepository nodeGroupRepository = NodeGroupRepository.getInstance();
                if (nodeGroupRepository.getNodeGroupTree().searchPath(nodeGroupRepository.normalizeNgPath(pathOld), EMPTY) != null) {
                    nodeGroupRepository.renameNodeGroup(pathOld, pathNew);
                    this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                    out.writeUTF("T");
                    ServerEngine.getInstance().getAuditLog().logRename(this.m_login, pathOld, pathNew);
                } else {
                    RTLogger.print(1, "NG rename not possible. Path not found: " + pathOld);
                    out.writeUTF("Path not found: " + pathOld);
                }
            } else {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void processDeleteNodeGroups(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size2 = in.readInt();
        boolean canDo2 = true;
        ArrayList<String> ngroups = new ArrayList<String>(size2);
        for (int i = 0; i < size2; ++i) {
            String path = in.readUTF();
            if (canDo2 && !UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, path)) {
                canDo2 = false;
            }
            ngroups.add(path);
        }
        try {
            if (canDo2) {
                List<String> notFoundPaths = NodeGroupRepository.getInstance().deleteNodeGroup(ngroups);
                if (notFoundPaths.isEmpty()) {
                    this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                    out.writeUTF("T");
                } else {
                    RTLogger.print(3, "Delete impossible. Paths not found: " + String.valueOf(notFoundPaths));
                    out.writeUTF("not found: " + String.valueOf(notFoundPaths));
                }
                ArrayList<String> deleted = new ArrayList<String>(ngroups);
                deleted.removeAll(notFoundPaths);
                for (String pgPath : deleted) {
                    ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, pgPath);
                }
            } else {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void processAddNodeGroups(SDataOutputStream out, SDataInputStream in) throws IOException {
        String path3 = in.readUTF();
        try {
            GroupTreeObject toCheck = NodeGroupRepository.getInstance().getNodeGroupTree().searchLongestExistingPath(path3);
            if (toCheck != null && UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, toCheck.getPath())) {
                NodeGroupRepository.getInstance().addNodeGroup(path3);
                this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                out.writeUTF("T");
                ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, path3);
            } else {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private List<PolicyDeployed> getPolicyDeployedByType(AgentCard ac, Map<String, String> policies, String type, Collection<String> disabled) {
        AbstractPolicy p;
        PolicyDeployed pd;
        LinkedList<PolicyDeployed> policyList = new LinkedList<PolicyDeployed>();
        Map<Assignment, Object> asnExpected = this.m_serverEngine.getAssignmentRepository().getAssignments(ac.getAgentID());
        for (Map.Entry<String, String> en : policies.entrySet()) {
            pd = new PolicyDeployed();
            pd.setPolicyName(en.getKey());
            pd.setPolicyType(type);
            pd.setPolicyVersionAgent(en.getValue());
            pd.setPolicyDisabled(disabled.contains(en.getKey()));
            p = null;
            if ("mon".equals(type)) {
                p = this.m_serverEngine.getPolicyRepository().getMonitorPolicy(en.getKey());
            } else if ("msg".equals(type)) {
                p = this.m_serverEngine.getPolicyRepository().getMessagePolicy(en.getKey());
            }
            if (p == null) {
                pd.setPolicyVersionServer("-");
            } else {
                pd.setPolicyVersionServer(p.getVersion());
            }
            policyList.add(pd);
        }
        for (Assignment asn : asnExpected.keySet()) {
            if (!type.equals(asn.getType()) || policies.containsKey(asn.getName())) continue;
            pd = new PolicyDeployed();
            pd.setPolicyName(asn.getName());
            pd.setPolicyType(type);
            pd.setPolicyVersionAgent(EMPTY);
            pd.setPolicyDisabled(false);
            p = this.m_serverEngine.getPolicyRepository().getMonitorPolicy(asn.getName());
            if (p == null) {
                pd.setPolicyVersionServer("-");
            } else {
                pd.setPolicyVersionServer(p.getVersion());
            }
            policyList.add(pd);
        }
        return policyList;
    }

    private void processGetStrings(SDataOutputStream out, SDataInputStream in) throws IOException {
        block10: {
            String className = in.readUTF();
            int paramSize = in.readInt();
            String[] params = null;
            if (paramSize > 0) {
                params = new String[paramSize];
                for (int i = 0; i < paramSize; ++i) {
                    params[i] = in.readUTF();
                }
            }
            try {
                Class plugin = BMClassLoader.findClass2(className);
                if (IPluginSt.class.isAssignableFrom(plugin)) {
                    try {
                        List<String> res;
                        Constructor constr = plugin.getConstructor(null);
                        IPluginSt obj = (IPluginSt)constr.newInstance(null);
                        try {
                            res = obj.execute(params);
                        }
                        catch (Throwable e) {
                            out.writeBoolean(true);
                            out.writeUTF(e.getMessage());
                            return;
                        }
                        for (String string : res) {
                            out.writeBoolean(true);
                            out.writeUTF(string);
                        }
                        out.writeBoolean(false);
                        out.writeUTF("T");
                    }
                    catch (Throwable e) {
                        out.writeBoolean(false);
                        out.writeUTF("Error initialization: " + className);
                    }
                    break block10;
                }
                out.writeBoolean(false);
                out.writeUTF("Failed plugin: " + className);
            }
            catch (ClassNotFoundException e) {
                out.writeBoolean(false);
                out.writeUTF("Server does not support: " + className);
            }
        }
    }

    private void processGetIODataStreamObject(SDataOutputStream out, SDataInputStream in) throws IOException {
        block10: {
            String className = in.readUTF();
            int paramSize = in.readInt();
            String[] params = null;
            if (paramSize > 0) {
                params = new String[paramSize];
                for (int i = 0; i < paramSize; ++i) {
                    params[i] = in.readUTF();
                }
            }
            try {
                Class plugin = BMClassLoader.findClass2(className);
                if (IPluginIO.class.isAssignableFrom(plugin)) {
                    try {
                        List<IODataStream> res;
                        Constructor constr = plugin.getConstructor(null);
                        IPluginIO obj = (IPluginIO)constr.newInstance(null);
                        try {
                            res = obj.execute(params);
                        }
                        catch (Throwable e) {
                            out.writeBoolean(true);
                            out.writeUTF(e.getMessage());
                            return;
                        }
                        for (IODataStream io : res) {
                            out.writeBoolean(true);
                            io.send(out);
                        }
                        out.writeBoolean(false);
                        out.writeUTF("T");
                    }
                    catch (Throwable e) {
                        out.writeBoolean(false);
                        out.writeUTF("Error initialization: " + className);
                    }
                    break block10;
                }
                out.writeBoolean(false);
                out.writeUTF("Failed plugin: " + className);
            }
            catch (ClassNotFoundException e) {
                out.writeBoolean(false);
                out.writeUTF("Server does not support: " + className);
            }
        }
    }

    private void userAuth(SDataOutputStream out, SDataInputStream in) throws IOException {
        String login = in.readUTF();
        String encryptedPass = in.readUTF();
        UserRole role = null;
        try {
            role = UserManager.getInstance().checkUser(login, encryptedPass);
        }
        catch (Throwable e) {
            RTLogger.print(3, "UserAuthCheck failed", e);
        }
        out.writeBoolean(role != null);
    }

    private void processGetUserAttributes(SDataOutputStream out) throws IOException {
        LinkedHashMap<String, CallSite> attr = new LinkedHashMap<String, CallSite>();
        attr.put("USER_AGENTS_FILTERED", (CallSite)((Object)(EMPTY + UserManager.getInstance().isUserNodeGroupFiltered(this.m_login))));
        Iterator itua = attr.entrySet().iterator();
        out.writeBoolean(itua.hasNext());
        while (itua.hasNext()) {
            Map.Entry en = itua.next();
            out.writeUTF((String)en.getKey());
            out.writeUTF((String)en.getValue());
            out.writeBoolean(itua.hasNext());
        }
    }

    @Deprecated
    private void processGetMemAnnotations(SDataOutputStream out, SDataInputStream in) throws IOException {
        String[] arr;
        String filter = in.readUTF();
        Pattern filterP = null;
        try {
            if (filter != null && filter.length() > 0) {
                filterP = Pattern.compile(filter);
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "GET_MEM_ANNOTATIONS Pattern invalid: " + filter);
        }
        String ids = in.readUTF();
        for (String iD : arr = ids.split("\\s*,\\s*")) {
            SEventFwd sef = this.m_serverEngine.getEventsRouter().getEvent(iD);
            if (sef == null) continue;
            ArrayList<String> annotations = new ArrayList<String>(sef.getAnnotations());
            if (filterP != null) {
                Iterator<String> iit = annotations.iterator();
                while (iit.hasNext()) {
                    String stringAnnot = iit.next();
                    Matcher m = filterP.matcher(stringAnnot);
                    if (m.matches()) continue;
                    iit.remove();
                }
            }
            if (annotations.size() <= 0) continue;
            out.writeBoolean(true);
            out.writeUTF(iD);
            int size = annotations.size();
            out.writeInt(size);
            for (String a : annotations) {
                out.writeUTF(a);
            }
        }
        out.writeBoolean(false);
    }

    private void processGetSlaves(SDataOutputStream out) throws IOException {
        Iterator<SlaveServerCard> it = new ArrayList<SlaveServerCard>(this.m_serverEngine.getSlaves()).iterator();
        out.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SlaveServerCard ssc = it.next();
            out.writeUTF(ssc.getHostName());
            out.writeUTF(ssc.getUser());
            out.writeInt(ssc.getScenario());
            out.writeBoolean(it.hasNext());
        }
    }

    private void processSaveOutagePoliciesSlave(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String byWhom2 = this.getUsernameForSlave(this.m_login);
            String slaveName = in.readUTF();
            int size = in.readInt();
            LinkedList<ServerPolicyTemplate> list = new LinkedList<ServerPolicyTemplate>();
            for (int i = 0; i < size; ++i) {
                OutagePolicy sp = new OutagePolicy("temp", "temp");
                sp.read(in);
                sp.setOwner(byWhom2);
                list.add(sp);
            }
            SlaveServerCard ssc = this.m_serverEngine.getSlave(slaveName);
            if (ssc != null) {
                ScSaveServerPolicies sc = new ScSaveServerPolicies(ssc, list);
                sc.run();
                if (!sc.isSuccess()) {
                    throw sc.getLastException();
                }
                out.writeUTF("T");
            } else {
                out.writeUTF("Slave Server not found: " + slaveName);
            }
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processSaveModifyPoliciesSlave(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            this.getUsernameForSlave(this.m_login);
            in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                ModifyServerPolicy sp = new ModifyServerPolicy("temp", "temp");
                sp.read(in);
            }
            out.writeUTF(OPERATION_REJECTED);
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processSaveExtendedPoliciesSlave(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String byWhom2 = this.getUsernameForSlave(this.m_login);
            String slaveName = in.readUTF();
            int size = in.readInt();
            LinkedList<ServerPolicyTemplate> list = new LinkedList<ServerPolicyTemplate>();
            for (int i = 0; i < size; ++i) {
                ExtendedServerPolicy sp = new ExtendedServerPolicy("temp", "temp");
                sp.read(in);
                sp.setOwner(byWhom2);
                list.add(sp);
            }
            SlaveServerCard ssc = this.m_serverEngine.getSlave(slaveName);
            if (ssc != null) {
                ScValidateCmd validate = new ScValidateCmd(ssc, "SAVE_SERVER_POLICIES_EXT");
                validate.run();
                if (!validate.isSuccess()) {
                    throw new RuntimeException("Request can not be processed. Slave server version is too old.");
                }
                ScSaveExtendedPolicies sc = new ScSaveExtendedPolicies(ssc, list);
                sc.run();
                if (!sc.isSuccess()) {
                    throw sc.getLastException();
                }
                out.writeUTF("T");
            } else {
                out.writeUTF("Slave Server not found: " + slaveName);
            }
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processSetSlavePoliciesOrder(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String slaveName = in.readUTF();
            int size = in.readInt();
            ArrayList<String> ids = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(in.readUTF());
            }
            SlaveServerCard ssc = this.m_serverEngine.getSlave(slaveName);
            if (ssc != null) {
                ScSetServerPoliciesOrder sc = new ScSetServerPoliciesOrder(ssc, ids);
                sc.run();
                if (!sc.isSuccess()) {
                    throw sc.getLastException();
                }
                out.writeUTF("T");
            } else {
                out.writeUTF("Slave Server not found: " + slaveName);
            }
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processSetSlavePoliciesOrderMod(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String slaveName = in.readUTF();
            int size = in.readInt();
            ArrayList<String> ids = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(in.readUTF());
            }
            SlaveServerCard ssc = this.m_serverEngine.getSlave(slaveName);
            if (ssc != null) {
                ScValidateCmd validate = new ScValidateCmd(ssc, "SAVE_SERVER_POLICIES_EXT");
                validate.run();
                if (!validate.isSuccess()) {
                    throw new RuntimeException("Request can not be processed. Slave server version is too old.");
                }
                ScSetExtendedServerPoliciesOrder sc = new ScSetExtendedServerPoliciesOrder(ssc, ids);
                sc.run();
                if (!sc.isSuccess()) {
                    throw sc.getLastException();
                }
                out.writeUTF("T");
            } else {
                out.writeUTF("Slave Server not found: " + slaveName);
            }
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processSetServerPoliciesOrder(SDataOutputStream out, SDataInputStream in, IServerPolicyManager<? extends ServerPolicyTemplate> ip) throws IOException {
        try {
            int size = in.readInt();
            ArrayList<String> ids = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(in.readUTF());
            }
            ip.setOrder(ids);
            out.writeUTF("T");
        }
        catch (Throwable e1) {
            out.writeUTF(e1.toString());
        }
    }

    private void processGetServerPoliciesStatus(IServerPolicyManager<? extends ServerPolicyTemplate> om, SDataOutputStream out) throws IOException {
        if (om != null) {
            List<? extends ServerPolicyTemplate> list = om.getServerPoliciesOrdered(this.m_login);
            out.writeInt(list.size());
            for (ServerPolicyTemplate serverPolicyTemplate : list) {
                ServerPolicyStatus sps = om.getPolicyStatus(serverPolicyTemplate, this.m_login);
                serverPolicyTemplate.send(out);
                sps.send(out);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void processGetModifyServerPoliciesStatusReadOnly(ModifyIndicationManager om, SDataOutputStream out) throws IOException {
        if (om != null) {
            List list = om.getServerPoliciesOrdered(this.m_login);
            out.writeInt(list.size());
            for (ExtendedServerPolicy ep : list) {
                ModifyServerPolicy sp = new ModifyServerPolicy(ep);
                ServerPolicyStatus sps = om.getPolicyStatus(ep, this.m_login);
                sps.m_access = ServerPolicyStatus.ACCESS_READONLY;
                sp.send(out);
                sps.send(out);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void processSaveServerPolicies(IServerPolicyManager om, SDataOutputStream out, SDataInputStream in, String user, int command) throws Exception {
        int count = in.readInt();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            ServerPolicyTemplate sp;
            boolean deprecated = false;
            switch (command) {
                case 140: {
                    sp = new AgentOutagePolicy();
                    break;
                }
                case 231: {
                    sp = new ExtendedServerPolicy("temp", "temp");
                    break;
                }
                case 145: {
                    sp = new ModifyServerPolicy("temp", "temp");
                    deprecated = true;
                    break;
                }
                case 135: {
                    sp = new OutagePolicy("temp", "temp");
                    break;
                }
                default: {
                    throw new IOException("Server can't process request");
                }
            }
            ((ServerPolicyTemplate)sp).read(in);
            if (om != null) {
                if (!deprecated) {
                    if (om instanceof AgentOutageManager && sp instanceof AgentOutagePolicy) {
                        AgentOutageManager am = (AgentOutageManager)om;
                        ServerPolicyTemplate ap = sp;
                        if (am.equals4UserAdHoc((AgentOutagePolicy)ap)) {
                            sb.append("Agent AdHoc maintenance configuration already exist");
                            continue;
                        }
                        om.updateServerPolicy(sp, user);
                        continue;
                    }
                    om.updateServerPolicy(sp, user);
                    continue;
                }
                sb.append(OPERATION_REJECTED);
                continue;
            }
            if (sb.length() != 0) continue;
            sb.append("Outage Manager is not activated on the server");
        }
        if (sb.length() > 0) {
            out.writeUTF(sb.toString());
        } else {
            out.writeUTF("T");
        }
    }

    private void processDeleteServerPolicies(IServerPolicyManager om, SDataOutputStream out, SDataInputStream in) throws Exception {
        int count = in.readInt();
        ArrayList<String> ids = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            ids.add(in.readUTF());
        }
        Object byWhom = in.readUTF();
        if (((String)byWhom).length() == 0) {
            byWhom = "User:" + this.m_login;
        }
        if (!((String)byWhom).startsWith("User:")) {
            byWhom = "User:" + (String)byWhom;
        }
        if (om != null) {
            HashMapMap<SlaveServerCard, String> m_toSlaves = new HashMapMap<SlaveServerCard, String>();
            for (String id : ids) {
                SlaveServerCard ssc = om.getSlaveServer(id);
                if (ssc != null) {
                    m_toSlaves.putV(ssc, id);
                    continue;
                }
                om.deletePolicy(id);
                Object who = ((String)byWhom).startsWith("User:") ? ((String)byWhom).substring(5) : byWhom;
                String what = "AgentOutagePolicy";
                if (om instanceof OutageManager) {
                    what = "OutagePolicy";
                } else if (om instanceof ModifyIndicationManager) {
                    what = "ExtendedServerPolicy";
                }
                ServerEngine.getInstance().getAuditLog().logDelete((String)who, what + "/" + id);
            }
            StringBuilder sb = new StringBuilder();
            boolean iserr = false;
            for (Map.Entry entry : m_toSlaves.entrySet()) {
                Map value;
                SlaveServerCard ssc = (SlaveServerCard)entry.getKey();
                if (ssc == null || (value = (Map)entry.getValue()) == null || value.size() <= 0) continue;
                ArrayList<String> idL = new ArrayList<String>(value.keySet());
                String byWhom2 = this.getUsernameForSlave((String)byWhom);
                ScDeleteServerPolicy sc = null;
                if (om instanceof ModifyIndicationManager) {
                    sc = new ScDeleteExtendedServerPolicy(ssc, idL, byWhom2);
                } else if (om instanceof AgentOutageManager) {
                    sc = new ScDeleteAgentOutagePolicy(ssc, idL, byWhom2);
                } else if (om instanceof OutageManager) {
                    sc = new ScDeleteServerPolicy(ssc, idL, byWhom2);
                }
                if (sc == null) continue;
                sc.run();
                if (sc.isSuccess()) continue;
                iserr = true;
                sb.append("\nError deleting on the slave: ").append(ssc.getHostName()).append("\npolicy IDs: ").append(idL).append("\nError: ").append(sc.getLastException() == null ? "unknown" : sc.getLastException().toString());
            }
            if (iserr) {
                out.writeUTF(sb.toString());
            } else {
                out.writeUTF("T");
            }
        } else {
            out.writeUTF("Outage Manager is not activated on the server");
        }
    }

    private String getUsernameForSlave(String byWhom) {
        return byWhom + "@@" + ServerEngine.getInstance().getServerProps().getHostname();
    }

    private void processEnableDisableServerPolicy(IServerPolicyManager om, SDataOutputStream out, SDataInputStream in, String user) throws IOException {
        boolean enable = in.readBoolean();
        Object byWhom = in.readUTF();
        int overridePostAction = in.readInt();
        if (((String)byWhom).length() == 0) {
            byWhom = "User:" + user;
        }
        if (!((String)byWhom).startsWith("User:")) {
            byWhom = "User:" + (String)byWhom;
        }
        LinkedList<String> ids = new LinkedList<String>();
        while (in.readBoolean()) {
            String id = in.readUTF();
            ids.add(id);
        }
        HashMapMap<SlaveServerCard, String> m_toSlaves = new HashMapMap<SlaveServerCard, String>();
        if (om != null) {
            StringBuilder sb = new StringBuilder("ServerPolicies not found: ");
            boolean err = false;
            for (String string : ids) {
                Object sp = om.getServerPolicy(string);
                SlaveServerCard ssc = om.getSlaveServer(string);
                if (ssc == null && sp != null) {
                    if (!enable && overridePostAction > 0) {
                        int eventCode = 5;
                        switch (overridePostAction) {
                            case 5: {
                                eventCode = 7;
                                break;
                            }
                            case 1: {
                                eventCode = 6;
                                break;
                            }
                        }
                        ((ServerPolicyTemplate)sp).setDisabled((String)byWhom, eventCode);
                        if (sp instanceof OutagePolicy) {
                            ServerEngine.getInstance().getAuditLog().logModify(user, "OutagePolicy/" + string, "Disable+" + ServerPolicyTemplate.getActionLabel(overridePostAction));
                            continue;
                        }
                        if (!(sp instanceof AgentOutagePolicy)) continue;
                        ServerEngine.getInstance().getAuditLog().logModify(user, "AgentOutagePolicy/" + string, "Disable+" + ServerPolicyTemplate.getActionLabel(overridePostAction));
                        continue;
                    }
                    if (enable) {
                        ((ServerPolicyTemplate)sp).setEnabled((String)byWhom);
                    } else {
                        ((ServerPolicyTemplate)sp).setDisabled((String)byWhom);
                    }
                    if (sp instanceof ExtendedServerPolicy) {
                        ServerEngine.getInstance().getAuditLog().logModify(user, "ExtendedServerPolicy/" + string, enable ? "Enable" : "Disable");
                        continue;
                    }
                    if (sp instanceof OutagePolicy) {
                        ServerEngine.getInstance().getAuditLog().logModify(user, "OutagePolicy/" + string, enable ? "Enable" : "Disable");
                        continue;
                    }
                    if (!(sp instanceof AgentOutagePolicy)) continue;
                    ServerEngine.getInstance().getAuditLog().logModify(user, "AgentOutagePolicy/" + string, enable ? "Enable" : "Disable");
                    continue;
                }
                if (ssc != null) {
                    m_toSlaves.putV(ssc, string);
                    continue;
                }
                sb.append("\n").append(string);
                err = true;
            }
            for (Map.Entry entry : m_toSlaves.entrySet()) {
                Map value;
                SlaveServerCard ssc = (SlaveServerCard)entry.getKey();
                if (ssc == null || (value = (Map)entry.getValue()) == null || value.size() <= 0) continue;
                ArrayList<String> idL = new ArrayList<String>(value.keySet());
                String byWhom2 = this.getUsernameForSlave((String)byWhom);
                ScEnableServerPolicy sc = null;
                if (om instanceof ModifyIndicationManager) {
                    sc = new ScEnableExtendedServerPolicy(ssc, idL, enable, byWhom2, overridePostAction);
                } else if (om instanceof AgentOutageManager) {
                    sc = new ScEnableAgentOutagePolicy(ssc, idL, enable, byWhom2, overridePostAction);
                } else if (om instanceof OutageManager) {
                    sc = new ScEnableServerPolicy(ssc, idL, enable, byWhom2, overridePostAction);
                }
                if (sc == null) continue;
                ssc.getServerClient().start(sc);
            }
            if (err) {
                out.writeUTF(sb.toString());
            } else {
                out.writeUTF("T");
            }
        } else {
            out.writeUTF("Outage Manager is not activated on the server");
        }
    }

    private void processGetServerPolicy(IServerPolicyManager om, SDataOutputStream out, SDataInputStream in) throws IOException {
        String id = in.readUTF();
        if (om != null) {
            Object sp = om.getServerPolicy(id);
            if (sp != null) {
                out.writeInt(1);
                ((ServerPolicyTemplate)sp).send(out);
            } else {
                out.writeInt(0);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void reopenIndi(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> ids = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String ID = in.readUTF();
            ids.add(ID);
        }
        try {
            this.m_serverEngine.getEventsRouter().reopenIndi(ids, this.m_login);
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void ownIndi(SDataOutputStream out, SDataInputStream in, int command) throws IOException {
        try {
            long time = System.currentTimeMillis();
            EventOperations eo = this.m_serverEngine.getEventsRouter().getEventOperations();
            EventOperationsOutage eoOutage = this.m_serverEngine.getEventsRouter().getEventOperationsOutage();
            LinkedList<SEventFwd> toUpdate = new LinkedList<SEventFwd>();
            LinkedList<SEventFwd> toUpdateOutage = new LinkedList<SEventFwd>();
            String user = in.readUTF();
            int size = in.readInt();
            if (user != null && user.length() > 255) {
                for (int i = 0; i < size; ++i) {
                    in.readUTF();
                }
                out.writeUTF("User name is too long");
                RTLogger.print(3, "Own indi rejected. Username is too long: " + user);
            } else {
                if (command == 131) {
                    for (int i = 0; i < size; ++i) {
                        String ID = in.readUTF();
                        SEventFwd sef = eo.getEvent(ID);
                        if (sef != null) {
                            sef.setT5(user + "\n" + time);
                            toUpdate.add(sef);
                            continue;
                        }
                        sef = eoOutage.getEvent(ID);
                        if (sef == null) continue;
                        sef.setT5(user + "\n" + time);
                        toUpdateOutage.add(sef);
                    }
                    eo.markToInsertOrUpdateInDB(toUpdate);
                    eo.getClientProxyMgr().addUpdatedToClients(toUpdate);
                    eoOutage.markToInsertOrUpdateInDB(toUpdateOutage);
                    eoOutage.getClientProxyMgr().addUpdatedToClients(toUpdateOutage);
                } else {
                    for (int i = 0; i < size; ++i) {
                        String ID = in.readUTF();
                        SEventFwd sef = eo.getEvent(ID);
                        if (sef != null) {
                            sef.setT5(EMPTY);
                            toUpdate.add(sef);
                            continue;
                        }
                        sef = eoOutage.getEvent(ID);
                        if (sef == null) continue;
                        sef.setT5(EMPTY);
                        toUpdateOutage.add(sef);
                    }
                }
                eo.markToInsertOrUpdateInDB(toUpdate);
                eo.getClientProxyMgr().addUpdatedToClients(toUpdate);
                eoOutage.markToInsertOrUpdateInDB(toUpdateOutage);
                eoOutage.getClientProxyMgr().addUpdatedToClients(toUpdateOutage);
                out.writeUTF("T");
            }
        }
        catch (Throwable e) {
            out.writeUTF("F");
        }
    }

    private void processSearchPolicies(SDataOutputStream out, SDataInputStream in) throws IOException {
        String searchTextGlobal = in.readUTF();
        int propsSize = in.readInt();
        ArrayList<String> properties = new ArrayList<String>();
        for (int i = 0; i < propsSize; ++i) {
            String prop = in.readUTF();
            properties.add(prop);
        }
        if (searchTextGlobal.length() > 0) {
            try {
                SearchPolicies sp = new SearchPolicies(searchTextGlobal, properties);
                result = sp.getResult();
                out.writeInt(result.size());
                for (String s : result.keySet()) {
                    out.writeUTF(s);
                }
                out.writeUTF("T");
            }
            catch (Throwable e) {
                out.writeUTF(e.getMessage());
                out.writeUTF("F");
            }
        } else if (properties.size() > 0) {
            try {
                SearchPolicies sp = new SearchPolicies(properties);
                result = sp.getResult();
                out.writeInt(result.size());
                for (String s : result.keySet()) {
                    out.writeUTF(s);
                }
                out.writeUTF("T");
            }
            catch (Throwable e) {
                out.writeUTF(e.getMessage());
                out.writeUTF("F");
            }
        } else {
            try {
                out.writeUTF(EMPTY);
                out.writeUTF("F");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getDirHashShort(SDataOutputStream out, SDataInputStream in) throws IOException {
        String dir = in.readUTF();
        try {
            File dirf = new File(dir);
            String report = dirf.equals(this.m_serverEngine.getBinariesRepository().getPackageDirectory()) ? FileSyncUtils.getShortDigestPackages(dirf) : FileSyncUtils.getShortDigest(dirf);
            out.writeUTF(report);
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
            out.writeUTF("F");
        }
    }

    private void getDirHash(SDataOutputStream out, SDataInputStream in) throws IOException {
        String dir = in.readUTF();
        try {
            File dirf = new File(dir);
            String report = FileSyncUtils.getDigest(dirf);
            out.writeUTF(report);
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
            out.writeUTF("F");
        }
    }

    private void listSJobs(SDataOutputStream out) throws IOException {
        String status = this.m_serverEngine.getServerJobManager().getStatus();
        out.writeUTF(status);
        out.writeUTF("T");
    }

    private void reloadSJobs(SDataOutputStream out) throws IOException {
        try {
            this.m_serverEngine.getServerJobManager().reInit();
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void activateSJob(SDataOutputStream out, SDataInputStream in) throws IOException {
        String taskname = in.readUTF();
        String bt = in.readUTF();
        try {
            boolean isActive = Boolean.parseBoolean(bt);
            this.m_serverEngine.getServerJobManager().setActive(taskname, isActive);
            if (isActive) {
                ServerEngine.getInstance().getAuditLog().logEnable(this.m_login, "ServerJob", taskname);
            } else {
                ServerEngine.getInstance().getAuditLog().logDisable(this.m_login, "ServerJob", taskname);
            }
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void runSJobOnce(SDataOutputStream out, SDataInputStream in) throws IOException {
        String jname = in.readUTF();
        try {
            this.m_serverEngine.getServerJobManager().runJobOnce(jname);
            ServerEngine.getInstance().getAuditLog().log(this.m_login, "RUN_JOB", jname, null);
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void getSJobConfig(SDataOutputStream out, SDataInputStream in) throws IOException {
        String jname2 = in.readUTF();
        try {
            String configToSend = this.m_serverEngine.getServerJobManager().getConfig(jname2);
            out.writeUTF(configToSend);
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
            out.writeUTF("F");
        }
    }

    private void setSJobConfig(SDataOutputStream out, SDataInputStream in) throws IOException {
        String config = in.readUTF();
        try {
            this.m_serverEngine.getServerJobManager().setConfig(config);
            ServerEngine.getInstance().getAuditLog().logModify(this.m_login, "ServerJob");
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage());
        }
    }

    private void sendCMDtoUI(SDataOutputStream out, SDataInputStream in) throws IOException {
        String guiCmd = in.readUTF();
        String toUsers = in.readUTF();
        int paramSize = in.readInt();
        Object[] params = new String[paramSize];
        if ("SHOW_MESSAGE".equals(guiCmd)) {
            params = new String[paramSize + 1];
            params[0] = "------- " + this.m_login + " : " + BM.m_sdf.format(new Date()) + " -------";
            for (i = 1; i < params.length; ++i) {
                params[i] = in.readUTF();
            }
        } else {
            for (i = 0; i < paramSize; ++i) {
                params[i] = in.readUTF();
            }
        }
        CMD cmd = new CMD(guiCmd, this.m_login, params);
        if (toUsers.length() > 0) {
            String[] users;
            for (String user : users = toUsers.split("\\s*,\\s*")) {
                this.m_serverEngine.getEventsRouter().addPendingToUser(cmd, user);
            }
            out.writeUTF("T");
        } else {
            this.m_serverEngine.getEventsRouter().addPendingToALL(cmd);
            out.writeUTF("T");
        }
    }

    private void getConnectedUsers(SDataOutputStream out) throws IOException {
        StringJoiner allConnectedUsers = new StringJoiner("\u25ba");
        m_users.entrySet().stream().filter(en -> en.getValue() != null).filter(en -> !((Set)en.getValue()).isEmpty()).map(Map.Entry::getKey).forEach(allConnectedUsers::add);
        out.writeUTF(allConnectedUsers.toString());
        out.writeUTF("T");
    }

    private void processValidate(SDataOutputStream out, SDataInputStream in) throws IOException {
        String cmdToValidate = in.readUTF();
        Object res = m_acceptable.get(cmdToValidate);
        if (res != null) {
            out.writeUTF("T");
        } else {
            out.writeUTF("F");
            RTLogger.print(6, "VALIDATION failed for cmd:" + cmdToValidate);
        }
        RTLogger.print(6, "VALIDATION finished for cmd:" + cmdToValidate);
    }

    private void processGetPolicyVersions(SDataOutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        SPolicyRepository policyRepository = this.m_serverEngine.getPolicyRepository();
        GroupTreeObject policyTree = policyRepository.getPolicyTree();
        List<GroupTreeObjectLast> policies = policyTree.getAllGTOLs();
        for (GroupTreeObjectLast gtol : policies) {
            MsgPolicy mp;
            String name = gtol.getName();
            String type = gtol.getType();
            if ("mon".equals(type)) {
                Policy p = policyRepository.getMonitorPolicy(name);
                if (p == null) continue;
                sb.append(gtol.getPath()).append(' ').append("mon").append(' ').append(p.getVersion()).append('\n');
                continue;
            }
            if (!"msg".equals(type) || (mp = policyRepository.getMessagePolicy(name)) == null) continue;
            sb.append(gtol.getPath()).append(' ').append("msg").append(' ').append(mp.getVersion()).append('\n');
        }
        out.writeUTF(sb.toString());
        out.writeUTF("T");
    }

    private void processGetAgentVersions(SDataOutputStream out) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String id : this.m_serverEngine.getAgentRepository().getAgentCards().keySet()) {
            AgentCard ac = this.m_serverEngine.getAgentRepository().getLocalAgentCard(id, true);
            if (ac == null) continue;
            AgentInventoryCard aci = ac.getAgentInventoryCard();
            if (aci.isDiscovered()) {
                sb.append(id).append(aci.getAttribute(AgentInventoryCard.getPath("VERSION"))).append('|');
                continue;
            }
            if (ac.getAgentPort() != 0) continue;
            sb.append(id).append("-").append('|');
        }
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            ServerClientQ serverClient = ssc.getServerClient();
            if (!serverClient.isOnline()) continue;
            serverClient.start("GET_AGENT_VERSIONS", null, new String[0]);
            while (!serverClient.isFinished()) {
                GUIWorker.sleep(100);
            }
            if (!serverClient.isSuccess()) continue;
            sb.append(ssc.getAgentVersions());
        }
        out.writeUTF(sb.toString());
        out.writeUTF("T");
    }

    private void processUpdateIndication(SDataOutputStream out, SDataInputStream in) throws IOException {
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        while (in.readBoolean()) {
            SEventFwd sef = new SEventFwd();
            sef.readSv2(in);
            list.add(sef);
        }
        out.writeUTF("T");
        if (list.size() > 0) {
            this.m_serverEngine.getEventsRouter().updateEventsManual(list, this.m_login);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() != 2) continue;
                ssc.getServerClient().start("UPDATE_INDICATION", (String)null, list.toArray(new SEventFwd[0]));
            }
        }
    }

    private void processGetUIProfile(SDataOutputStream out) throws IOException {
        UserRole role = UserManager.getInstance().getRoleForUser(this.m_login);
        String roleID = role.getID();
        File file = new File("srv/profiles/" + roleID + ".xml");
        if (role.getName().equalsIgnoreCase("Administrator")) {
            file = new File("srv/profiles/notexistingFile.f1112");
        }
        this.sendFile(out, file);
        if (file.exists()) {
            out.writeUTF("T");
        } else {
            out.writeUTF("F");
        }
    }

    private void processAnyUpdate(SDataOutputStream out, SDataInputStream in) throws IOException {
        int uiversion = in.readInt();
        Object msg = EMPTY;
        if (uiversion < 220) {
            msg = "You current version of the UI Client is outdated.\nPlease download the latest package from the server!\nhttp://" + this.m_serverEngine.getServerProps().getHostname() + ":" + this.m_serverEngine.getServerProps().getHTTPPort() + "/deploy/";
        } else {
            this.m_serverEngine.checkGUIUpdate();
            if (this.m_serverEngine.getUIVersionBestFit() > uiversion) {
                msg = "New UI Client version " + this.getUIVersionAsString(this.m_serverEngine.getUIVersionBestFit()) + " is available.\nUse menu: \"Help\" -> \"About BOOM\" for update.";
            }
        }
        out.writeUTF((String)msg);
    }

    private String getUIVersionAsString(int version) {
        int nmajor = version / 100000;
        int nminor = version - nmajor * 100000;
        String res = nmajor + "." + (nminor /= 1000);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetMIBS(SDataOutputStream out) throws IOException {
        File mibsDir = new File("srv/mibs");
        if (mibsDir.exists() && mibsDir.isDirectory()) {
            File tmpZip = new File("mibs" + System.currentTimeMillis() + ".zip");
            try {
                Files.createFile(tmpZip.toPath(), new FileAttribute[0]);
                ZIP zip = new ZIP();
                zip.zipDir(mibsDir.getCanonicalPath(), tmpZip.getCanonicalPath());
                try (FileInputStream fis = new FileInputStream(tmpZip);){
                    out.writeFile(fis);
                    out.writeUTF("T");
                }
                catch (Throwable e) {
                    out.writeUTF("F");
                }
            }
            finally {
                try {
                    Files.deleteIfExists(tmpZip.toPath());
                }
                catch (IOException e) {
                    RTLogger.print(5, "can't delete temp file: " + tmpZip.getName());
                }
            }
        } else {
            out.writeInt(-1);
            out.writeUTF("F");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMasterUpdate(SDataOutputStream out, SDataInputStream in) throws IOException {
        String action = in.readUTF();
        File tmp = new File("tmp" + System.currentTimeMillis() + ".zip");
        if (!tmp.createNewFile()) {
            RTLogger.print(1, "Master Update Error. Can't create an empty tmp file.");
            in.readFileToNULL("tmp");
            out.writeUTF("F");
            return;
        }
        String filepath = tmp.getCanonicalPath();
        in.readFile(filepath);
        ZIP zip = new ZIP();
        try {
            if (action.equalsIgnoreCase("BINARIES")) {
                File bin = new File("./srv/packages");
                if (bin.exists() && bin.isDirectory()) {
                    List<String> filesUnzipped = zip.unzip(filepath, "./srv/packages");
                    zip.deleteFilesExcept(filesUnzipped, "./srv/packages");
                    ServerEngine.getInstance().getBinariesRepository().getXmlFile(true);
                }
            } else if (action.startsWith("UPD_BINARIES")) {
                File bin = new File("./srv/packages");
                if (bin.exists() && bin.isDirectory()) {
                    List<String> filesUnzipped = zip.unzip(filepath, "./srv/packages");
                    StrUtils su = new StrUtils();
                    String[] arr = su.processQuoted(action);
                    for (int i = 1; i < arr.length; ++i) {
                        String pkgname = su.removeQuotes(arr[i]);
                        zip.deleteFilesExcept(filesUnzipped, "./srv/packages/" + pkgname);
                    }
                    ServerEngine.getInstance().getBinariesRepository().getXmlFile(true);
                }
            } else if (action.equalsIgnoreCase("POLICIES_AND_ASSIGNMENTS")) {
                List<String> filesUnzipped = zip.unzip(filepath, "./srv/policies");
                zip.addExceptionMask("*.fgf.xml");
                zip.addExceptionMask("*.fwd.xml");
                zip.deleteFilesExcept(filesUnzipped, "./srv/policies");
                this.m_serverEngine.getPolicyRepository().init();
                ServerEngine.getInstance().getAssignmentRepository().init();
                this.m_serverEngine.getForwardManager().reinit();
            } else if (action.equalsIgnoreCase("ASSIGNMENTS")) {
                FileUtils.copyFile(tmp, new File(this.m_serverEngine.getAssignmentRepository().getAssignmentGroupsFile()));
                ServerEngine.getInstance().getAssignmentRepository().init();
            } else if (action.equalsIgnoreCase("NODEGROUPS")) {
                Object filesUnzipped = m_nodeGroupLock;
                synchronized (filesUnzipped) {
                    NodeGroupRepository.getInstance().loadFile(tmp.getAbsolutePath());
                }
                this.m_serverEngine.getForwardManager().cleanNodeGroupCache();
                this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
            } else if (action.equalsIgnoreCase("POLICIES")) {
                FileUtils.copyFile(tmp, new File(SPolicyRepository.getPolicyGroupsFile()));
                this.m_serverEngine.getPolicyRepository().init();
            } else {
                throw new RuntimeException("unknown action: " + action);
            }
            out.writeUTF("T");
        }
        catch (Throwable e) {
            RTLogger.print(2, "Update from master failed", e);
            out.writeUTF("F");
        }
        finally {
            try {
                Files.deleteIfExists(tmp.toPath());
            }
            catch (Throwable ignored) {
                RTLogger.print(5, "error deleting temp file: " + tmp.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMasterUpdateTrigger(SDataOutputStream out, SDataInputStream in) throws IOException {
        String action = in.readUTF();
        File tmp = new File("tmp" + System.currentTimeMillis() + ".zip");
        Files.createFile(tmp.toPath(), new FileAttribute[0]);
        String slaves = in.readUTF();
        ZIP zip = new ZIP();
        String zipFile = tmp.getCanonicalPath();
        ArrayList<ServerClient> runningClients = new ArrayList<ServerClient>();
        try {
            if (action.equalsIgnoreCase("BINARIES")) {
                File bin = new File("./srv/packages");
                if (bin.exists() && bin.isDirectory()) {
                    File[] files = bin.listFiles();
                    LinkedList<String> directories = new LinkedList<String>();
                    if (files != null) {
                        for (File file : files) {
                            if (!file.isDirectory()) continue;
                            directories.add(file.getName());
                        }
                    }
                    zip.zipDir("./srv/packages", directories, zipFile);
                }
            } else if (action.equalsIgnoreCase("POLICIES_AND_ASSIGNMENTS")) {
                zip.addExceptionMask("*.fgf.xml");
                zip.addExceptionMask("*.fwd.xml");
                zip.zipDir("./srv/policies", zipFile);
            } else if (action.startsWith("UPD_BINARIES")) {
                StrUtils su = new StrUtils();
                String[] arr = su.processQuoted(action);
                LinkedList<String> dirsToPush = new LinkedList<String>();
                for (int i = 1; i < arr.length; ++i) {
                    dirsToPush.add(su.removeQuotes(arr[i]));
                }
                zip.zipDir("./srv/packages", dirsToPush, zipFile);
            }
            if (slaves.equals("*")) {
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                    ServerClientQ sc = ssc.getServerClient();
                    ((ServerClient)sc).start("MASTER_UPDATE", action, new String[]{zipFile});
                    runningClients.add(sc);
                }
            } else {
                SlaveServerCard ssc = this.m_serverEngine.getSlave(slaves);
                if (ssc.getScenario() <= 1 || 8 == ssc.getScenario()) {
                    ServerClientQ sc = ssc.getServerClient();
                    ((ServerClient)sc).start("MASTER_UPDATE", action, new String[]{zipFile});
                    runningClients.add(sc);
                }
            }
            out.writeUTF("T");
        }
        catch (Throwable e) {
            out.writeUTF("F");
        }
        finally {
            try {
                for (int max = 0; runningClients.size() > 0 && max < 1500; ++max) {
                    runningClients.removeIf(ServerClient::isFinished);
                    GUIWorker.sleep(500);
                }
                try {
                    Files.deleteIfExists(tmp.toPath());
                }
                catch (Throwable ignored) {
                    RTLogger.print(5, "error deleting temp file: " + tmp.getName());
                }
            }
            catch (Throwable max) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processMasterUpdateTriggerSync(SDataOutputStream out, SDataInputStream in) throws IOException {
        block54: {
            ServerClient sc;
            ArrayList<ServerClient> runningClients;
            File tmp;
            StringBuilder sb;
            boolean isOK;
            block53: {
                isOK = true;
                sb = new StringBuilder();
                String action = in.readUTF();
                tmp = new File("tmp" + System.currentTimeMillis() + ".zip");
                if (!tmp.createNewFile()) {
                    out.writeUTF("Master Trigger Update failed to create an empty temp file.");
                    out.writeUTF("F");
                    return;
                }
                String slaves = in.readUTF();
                ZIP zip = new ZIP();
                String zipFile = tmp.getCanonicalPath();
                runningClients = new ArrayList<ServerClient>();
                if (action.equalsIgnoreCase("BINARIES")) {
                    File bin = new File("./srv/packages");
                    if (bin.exists() && bin.isDirectory()) {
                        LinkedList<String> directories = new LinkedList<String>();
                        File[] files = bin.listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (!file.isDirectory()) continue;
                                directories.add(file.getName());
                            }
                        }
                        zip.zipDir("./srv/packages", directories, zipFile);
                    }
                } else if (action.equalsIgnoreCase("POLICIES_AND_ASSIGNMENTS")) {
                    zip.addExceptionMask("*.fgf.xml");
                    zip.addExceptionMask("*.fwd.xml");
                    zip.zipDir("./srv/policies", zipFile);
                } else if (action.startsWith("UPD_BINARIES")) {
                    StrUtils su = new StrUtils();
                    String[] arr = su.processQuoted(action);
                    LinkedList<String> dirsToPush = new LinkedList<String>();
                    for (int i = 1; i < arr.length; ++i) {
                        dirsToPush.add(su.removeQuotes(arr[i]));
                    }
                    zip.zipDir("./srv/packages", dirsToPush, zipFile);
                }
                if (slaves.equals("*")) {
                    for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                        if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                        sc = ssc.getServerClient();
                        sc.start("MASTER_UPDATE", action, new String[]{zipFile});
                        runningClients.add(sc);
                    }
                    break block53;
                }
                SlaveServerCard ssc = this.m_serverEngine.getSlave(slaves);
                if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) break block53;
                ServerClientQ sc2 = ssc.getServerClient();
                ((ServerClient)sc2).start("MASTER_UPDATE", action, new String[]{zipFile});
                runningClients.add(sc2);
            }
            try {
                for (int max = 0; runningClients.size() > 0 && max < 1500; ++max) {
                    Iterator it = runningClients.iterator();
                    while (it.hasNext()) {
                        sc = (ServerClient)it.next();
                        if (!sc.isFinished()) continue;
                        it.remove();
                        sb.append("Slave: ").append(sc.m_hostname);
                        sb.append(' ');
                        if (sc.isOKFinished) {
                            sb.append("update status: OK");
                        } else {
                            sb.append("update status: FAILED ");
                            if (sc.m_result instanceof String) {
                                sb.append('{').append(sc.m_result).append('}');
                            }
                        }
                        sb.append('\n');
                    }
                    GUIWorker.sleep(1000);
                }
            }
            catch (Throwable e) {
                RTLogger.print(6, EMPTY, e);
            }
            try {
                Files.deleteIfExists(tmp.toPath());
            }
            catch (Throwable ignored) {
                RTLogger.print(5, "error deleting temp file: " + tmp.getName());
            }
            try {
                out.writeUTF(sb.toString());
                if (isOK) {
                    out.writeUTF("T");
                    break block54;
                }
                out.writeUTF("F");
            }
            catch (Throwable e) {
                RTLogger.print(6, EMPTY, e);
            }
            break block54;
            catch (Throwable e) {
                isOK = false;
                try {
                    for (int max = 0; runningClients.size() > 0 && max < 1500; ++max) {
                        Iterator it = runningClients.iterator();
                        while (it.hasNext()) {
                            ServerClient sc3 = (ServerClient)it.next();
                            if (!sc3.isFinished()) continue;
                            it.remove();
                            sb.append("Slave: ").append(sc3.m_hostname);
                            sb.append(' ');
                            if (sc3.isOKFinished) {
                                sb.append("update status: OK");
                            } else {
                                sb.append("update status: FAILED ");
                                if (sc3.m_result instanceof String) {
                                    sb.append('{').append(sc3.m_result).append('}');
                                }
                            }
                            sb.append('\n');
                        }
                        GUIWorker.sleep(1000);
                    }
                }
                catch (Throwable e2) {
                    RTLogger.print(6, EMPTY, e2);
                }
                try {
                    Files.deleteIfExists(tmp.toPath());
                }
                catch (Throwable ignored) {
                    RTLogger.print(5, "error deleting temp file: " + tmp.getName());
                }
                try {
                    out.writeUTF(sb.toString());
                    if (isOK) {
                        out.writeUTF("T");
                    }
                    out.writeUTF("F");
                }
                catch (Throwable e3) {
                    RTLogger.print(6, EMPTY, e3);
                }
                catch (Throwable throwable) {
                    try {
                        for (int max = 0; runningClients.size() > 0 && max < 1500; ++max) {
                            Iterator it = runningClients.iterator();
                            while (it.hasNext()) {
                                ServerClient sc4 = (ServerClient)it.next();
                                if (!sc4.isFinished()) continue;
                                it.remove();
                                sb.append("Slave: ").append(sc4.m_hostname);
                                sb.append(' ');
                                if (sc4.isOKFinished) {
                                    sb.append("update status: OK");
                                } else {
                                    sb.append("update status: FAILED ");
                                    if (sc4.m_result instanceof String) {
                                        sb.append('{').append(sc4.m_result).append('}');
                                    }
                                }
                                sb.append('\n');
                            }
                            GUIWorker.sleep(1000);
                        }
                    }
                    catch (Throwable e4) {
                        RTLogger.print(6, EMPTY, e4);
                    }
                    try {
                        Files.deleteIfExists(tmp.toPath());
                    }
                    catch (Throwable ignored) {
                        RTLogger.print(5, "error deleting temp file: " + tmp.getName());
                    }
                    try {
                        out.writeUTF(sb.toString());
                        if (isOK) {
                            out.writeUTF("T");
                        } else {
                            out.writeUTF("F");
                        }
                    }
                    catch (Throwable e5) {
                        RTLogger.print(6, EMPTY, e5);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void processGetPolicyDetails(SDataOutputStream out) throws IOException {
        ArrayList<CallSite> res = new ArrayList<CallSite>();
        SPolicyRepository spr = this.m_serverEngine.getPolicyRepository();
        Set<String> monpolicies = spr.getMonitorPolicyList();
        res.ensureCapacity(monpolicies.size());
        for (String name : monpolicies) {
            Object application;
            Policy policy = spr.getMonitorPolicy(name);
            TreeSet<String> map_grp = new TreeSet<String>();
            TreeSet<String> map_app = new TreeSet<String>();
            List condList = policy.getConditions().getConditionList();
            for (Condition c : condList) {
                if (c.getSetGroup() != null && c.getSetGroup().length() > 0) {
                    map_grp.add(c.getSetGroup());
                } else {
                    map_grp.add(policy.getSetGroup());
                }
                if (c.getSetApplication() != null && c.getSetApplication().length() > 0) {
                    map_app.add(c.getSetApplication());
                    continue;
                }
                map_app.add(policy.getSetApplication());
            }
            StringBuilder group = this.buildString(map_grp);
            if (group.length() == 0) {
                group.append(policy.getSetGroup());
            }
            if (((StringBuilder)(application = this.buildString(map_app))).length() == 0) {
                ((StringBuilder)application).append(policy.getSetApplication());
            }
            res.add((CallSite)((Object)(policy.getName() + "\u25ba" + policy.getVersion() + "\u25ba" + String.valueOf(group) + "\u25ba" + String.valueOf(application) + "\u25ba" + policy.getCallType())));
        }
        Set<String> msgpolicies = spr.getMessagePolicyList();
        res.ensureCapacity(res.size() + msgpolicies.size());
        for (String string : msgpolicies) {
            StringBuilder application;
            MsgPolicy mp = spr.getMessagePolicy(string);
            TreeSet<String> map_grp = new TreeSet<String>();
            TreeSet<String> map_app = new TreeSet<String>();
            List condList = mp.getConditions().getConditionList();
            for (MsgCondition mc : condList) {
                if (mc.getSetGroup() != null && mc.getSetGroup().length() > 0) {
                    map_grp.add(mc.getSetGroup());
                } else {
                    map_grp.add(mp.getSetGroup());
                }
                if (mc.getSetApplication() != null && mc.getSetApplication().length() > 0) {
                    map_app.add(mc.getSetApplication());
                    continue;
                }
                map_app.add(mp.getSetApplication());
            }
            StringBuilder group = this.buildString(map_grp);
            if (group.length() == 0) {
                group.append(mp.getSetGroup());
            }
            if ((application = this.buildString(map_app)).length() == 0) {
                application.append(mp.getSetApplication());
            }
            res.add((CallSite)((Object)(mp.getName() + "\u25ba" + mp.getVersion() + "\u25ba" + String.valueOf(group) + "\u25ba" + String.valueOf(application) + "\u25ba" + mp.getCallType())));
        }
        out.writeInt(res.size());
        for (String string : res) {
            out.writeUTF(string);
        }
    }

    private StringBuilder buildString(Set<String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && !map.isEmpty()) {
            for (String value : map) {
                sb.append(value).append('|');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb;
    }

    private void processGetArchived(SDataOutputStream out, SDataInputStream in) throws IOException {
        long from = in.readLong();
        long limit = in.readLong();
        String where = in.readUTF();
        ArchiveDetails ad = null;
        if (!this.m_serverEngine.getDB().getConnectorArchive().isReady() && !this.m_serverEngine.getDB().getConnectorArchive().onOpen()) {
            ad = new ArchiveDetails();
            SEventFwd se = SMessage.createMessage(5, 0, "Operation", "Error", "Processing", "Database is offline.");
            ad.m_events.add(se);
            ad.m_minStime = System.currentTimeMillis();
            ad.m_restRecords = 0;
        }
        if (ad == null) {
            ad = new ArchiveDetails();
            try {
                LinkedList<Map<String, Object>> row = this.m_serverEngine.getDB().getConnectorArchive().query("SELECT count(*) AS COUNT, min(STIME) as MINSTIME FROM EVENTS_A WHERE STIME<" + from);
                Map<String, Object> r = row.get(0);
                ad.m_restRecords = Integer.parseInt(String.valueOf(r.get("COUNT")));
                Object MINSTIME = r.get("MINSTIME");
                ad.m_minStime = MINSTIME != null ? Long.parseLong(String.valueOf(MINSTIME)) : 0L;
                GUIWorkerMethods gm = new GUIWorkerMethods(this.m_serverEngine, this.m_login);
                try (PreparedStatement ps = gm.getArchivedQuery(where, from, limit);
                     ResultSet rs = ps.executeQuery();){
                    ResultSetMetaData rsMD = rs.getMetaData();
                    while (rs.next()) {
                        SEventFwd sef0 = this.m_serverEngine.getDB().getConnectorArchive().initSEventFwd(rs, rsMD);
                        ad.m_events.add(sef0);
                        if (ad.m_events.size() <= 100) continue;
                        this.send_SEF_Block(out, in, ad);
                    }
                }
            }
            catch (Throwable e) {
                SEventFwd se = SMessage.createMessage(5, 0, "Operation", "Error", "Processing", e.getMessage());
                ad.m_events.add(se);
                ad.m_minStime = System.currentTimeMillis();
                ad.m_restRecords = 0;
            }
        }
        try {
            if (ad.m_events.size() > 0) {
                this.send_SEF_Block(out, in, ad);
            }
            out.writeInt(0);
            out.writeInt(ad.m_restRecords);
            out.writeLong(ad.m_minStime);
            out.writeUTF("T");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void send_SEF_Block(SDataOutputStream out, SDataInputStream in, ArchiveDetails ad) throws IOException {
        Iterator<SEventFwd> it = ad.m_events.iterator();
        ByteArrayOutputStream bbb = new ByteArrayOutputStream();
        SDataOutputStream sdo = new SDataOutputStream(bbb, in.getLastProtocolVersion());
        sdo.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd sef = it.next();
            sef.sendSv2(sdo);
            sdo.writeBoolean(it.hasNext());
        }
        sdo.close();
        bbb.close();
        byte[] arr = bbb.toByteArray();
        out.writeInt(arr.length);
        out.write(arr);
        ad.m_events.clear();
    }

    private void processTriggerAgentInventoryCard(SDataOutputStream out, SDataInputStream in) throws IOException {
        String id = in.readUTF();
        if ("*".equals(id)) {
            for (String s : this.m_serverEngine.getAgentRepository().getAgentCards().keySet()) {
                this.triggerInventory(s);
            }
        } else if (id.indexOf(44) != -1) {
            String[] ids;
            for (String s : ids = id.split("\\s*,\\s*")) {
                this.triggerInventory(s);
            }
        } else {
            this.triggerInventory(id);
        }
        out.writeUTF("T");
    }

    private void triggerInventory(String id) {
        if (id == null) {
            return;
        }
        AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(id);
        if (ac != null && ac.getAgentPort() > 0) {
            if (ac.getRelatedServer() != null) {
                SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                if (ssc != null && ssc.getScenario() < 3) {
                    ssc.getServerClient().start("TRIGGER_AGENT_INVENTORY_CARD", id, new String[0]);
                    ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, id, "BOOM_AGENT GET_DETAILS");
                }
            } else {
                ac.triggerInventory();
                ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, id, "BOOM_AGENT GET_DETAILS");
            }
        }
    }

    private void processGetAgentInventoryCard(SDataOutputStream out, SDataInputStream in) throws IOException {
        String id = in.readUTF();
        AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(id);
        if (ac != null) {
            if (ac.getRelatedServer() != null) {
                SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                if (ssc != null) {
                    ServerClient serverClient = ssc.getServerClientStandAlone();
                    boolean isOK = serverClient.run("GET_AGENT_INVENTORY_CARD", id, new String[0]);
                    if (isOK) {
                        Object result = serverClient.getResultObject();
                        if (result instanceof AgentInventoryCard) {
                            AgentInventoryCard aciSlave = (AgentInventoryCard)result;
                            aciSlave.send(out);
                        } else {
                            new AgentInventoryCard(EMPTY).send(out);
                        }
                    } else {
                        new AgentInventoryCard(EMPTY).send(out);
                    }
                } else {
                    new AgentInventoryCard(EMPTY).send(out);
                }
            } else {
                AgentInventoryCard aci = ac.getAgentInventoryCard();
                aci.send(out);
                if (!aci.isDiscovered()) {
                    ac.triggerInventory();
                }
            }
        } else {
            AgentInventoryCard aci = new AgentInventoryCard(EMPTY);
            aci.send(out);
        }
        out.writeUTF("T");
    }

    private void processCheckUpdate(SDataOutputStream out, SDataInputStream io) throws IOException {
        String version = io.readUTF();
        String res = "Unknown version";
        try {
            String[] vv = version.split("\\Q.\\E");
            int major = Integer.parseInt(vv[0]);
            int minor = Integer.parseInt(vv[1]);
            int last = 0;
            if (vv.length == 3) {
                last = Integer.parseInt(vv[2]);
            }
            int total = major * 100000 + minor * 1000 + last;
            this.m_serverEngine.checkGUIUpdate();
            res = this.m_serverEngine.getUIVersionBestFit() > total ? this.getUIVersionAsString(this.m_serverEngine.getUIVersionBestFit()) : "NoUpdates";
        }
        catch (Throwable e) {
            RTLogger.print(5, "check update failed", e);
        }
        out.writeUTF(res);
        out.writeUTF("T");
    }

    private void processGUIUpdate(SDataOutputStream out) throws IOException {
        this.sendFile(out, this.m_serverEngine.getUIFileBestFit());
        out.writeUTF("T");
    }

    private void processPutFile(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        try {
            if (!path.contains("srv/packages/") && path.endsWith(".xml")) {
                BkpFile.backup(path);
            }
            if (path.endsWith(NodeGroupRepository.getInstance().getNodeGroupXMLFile())) {
                this.processIncomingNodeGroupsXML(out, io, path);
            } else {
                RTLogger.print(5, "put file: " + path);
                io.readFile(path);
                out.writeUTF("T");
                ServerEngine.getInstance().getBinariesRepository().notifyUI();
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "PUFILE", path, "BOOM_SERVER");
                if (path.contains("srv/packages/")) {
                    for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                        if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                        ServerClientQ sc = ssc.getServerClient();
                        ((ServerClient)sc).start("PUT_FILE", path, new String[]{path});
                    }
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(4, e.getMessage(), e);
            try {
                out.writeUTF(e.getMessage() == null ? "F" : e.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processPutFileSlave(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        String server = io.readUTF();
        try {
            SlaveServerCard ssc = this.m_serverEngine.getSlave(server);
            if (ssc != null) {
                ServerClient sc;
                String tmpfilename = ssc.getSlaveDir() + String.valueOf(UUID.randomUUID());
                io.readFile(tmpfilename);
                if ((ssc.getScenario() <= 1 || 8 == ssc.getScenario()) && (sc = ssc.getServerClientStandAlone()).run("PUT_FILE", path, new String[]{tmpfilename})) {
                    out.writeUTF("T");
                }
            }
        }
        catch (Throwable e) {
            try {
                io.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            RTLogger.print(4, e.getMessage(), e);
            out.writeUTF("F");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingNodeGroupsXML(SDataOutputStream out, SDataInputStream io, String tmpPath) throws Exception {
        tmpPath = (String)tmpPath + ".tmp";
        NodeGroupRepository ngr = NodeGroupRepository.getInstance();
        if (UserManager.getInstance().isUserNodeGroupFiltered(this.m_login)) {
            io.readFileToNULL((String)tmpPath);
            out.writeUTF("F");
        } else {
            List<String> before = ngr.getAllOIDs();
            Iterator<SlaveServerCard> iterator = m_nodeGroupLock;
            synchronized (iterator) {
                io.readFile((String)tmpPath);
                out.writeUTF("T");
                ngr.loadFile((String)tmpPath);
                List<String> after = ngr.getAllOIDs();
                if (before.removeAll(after)) {
                    for (String oid : before) {
                        this.m_serverEngine.getAssignmentRepository().deleteAgent(oid);
                        this.m_serverEngine.getDB().deleteAgentAssignments(oid);
                        RTLogger.print(2, "Deleting assignments for NodeGroup oid:" + oid);
                    }
                }
                this.m_serverEngine.getForwardManager().cleanNodeGroupCache();
                this.m_serverEngine.getEventsRouter().notifyNodeGroupChange();
                try {
                    Files.deleteIfExists(Paths.get((String)tmpPath, new String[0]));
                }
                catch (Exception e) {
                    RTLogger.print(5, "can't delete temp file: " + (String)tmpPath);
                }
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "UPDATENGFILE", (String)tmpPath, "BOOM_SERVER");
            }
            this.m_serverEngine.getEventsRouter().addPendingToALL("REFRESH_NODEGROUPS");
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1) continue;
                ServerEngine.getInstance().getSlaveServerFactory().pushNodeGroupsToSlave(ssc);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRenameFile(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        String newpath = io.readUTF();
        try {
            File f = new File(path);
            if (!f.exists()) throw new RuntimeException("File not exist");
            if (!f.renameTo(new File(newpath))) throw new RuntimeException("Rename failed");
            ServerEngine.getInstance().getAuditLog().logRename(this.m_login, path, newpath);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                ServerClientQ sc = ssc.getServerClient();
                ((ServerClient)sc).start("RENAME_FILE", path, new String[]{newpath});
            }
            out.writeUTF("T");
            return;
        }
        catch (Throwable e) {
            RTLogger.print(4, e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRenamePkg(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        String newpath = io.readUTF();
        try {
            File f = new File(path);
            if (!f.exists() || !f.isDirectory()) throw new RuntimeException("File not exist");
            String oldName = f.getName();
            File dest = new File(newpath);
            if (f.renameTo(dest)) {
                String newName = dest.getName();
                try {
                    SAssignmentRepository sar = this.m_serverEngine.getAssignmentRepository();
                    sar.renameAssignment(oldName, newName, this.m_login, "pkg");
                    sar.getAsnTree().renameElements(oldName, newName, "pkg");
                    sar.saveTree();
                    ServerEngine.getInstance().getAuditLog().logRename(this.m_login, path, newpath);
                    for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                        if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                        ServerClientQ sc = ssc.getServerClient();
                        ((ServerClient)sc).start("RENAME_PKG", path, new String[]{newpath});
                    }
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Error update DB. Rename package old=" + oldName + " new=" + newName);
                }
            } else {
                if (!dest.exists()) throw new RuntimeException("Rename failed");
                throw new RuntimeException("Target already exists");
            }
            out.writeUTF("T");
            return;
        }
        catch (Throwable e) {
            RTLogger.print(4, e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDeleteFile(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        try {
            File f = new File(path);
            if (!f.exists()) throw new RuntimeException("File not exist");
            if (!f.delete()) throw new RuntimeException("File can't be deleted");
            ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, path);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                ServerClientQ sc = ssc.getServerClient();
                ((ServerClient)sc).start("DELETE_FILE", path, new String[0]);
            }
            out.writeUTF("T");
            return;
        }
        catch (Throwable e) {
            RTLogger.print(4, e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    private void processCreateFile(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        try {
            File f = new File(path);
            if (f.exists()) {
                throw new RuntimeException("File already exists");
            }
            RTLogger.print(5, "create file: " + path);
            Files.createFile(f.toPath(), new FileAttribute[0]);
            if (path.contains("srv/packages")) {
                ServerEngine.getInstance().getBinariesRepository().notifyUI();
            }
            ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, path);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                ServerClientQ sc = ssc.getServerClient();
                ((ServerClient)sc).start("CREATE_FILE", path, new String[0]);
            }
            out.writeUTF("T");
        }
        catch (Throwable e) {
            RTLogger.print(4, e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    private void processDeleteFolder(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        try {
            File f = new File(path);
            if (f.exists()) {
                String parentPath = f.getParentFile().getCanonicalPath();
                if (parentPath.equalsIgnoreCase(this.m_serverEngine.getBinariesRepository().getPackageDirectoryPath())) {
                    SAssignmentRepository sar = this.m_serverEngine.getAssignmentRepository();
                    AsnDbUpdate adu = new AsnDbUpdate();
                    sar.unlinkAll(f.getName(), "pkg");
                    sar.deleteAssignment(adu, this.m_login, f.getName(), "pkg", false);
                    sar.saveTree();
                    for (String asnID : adu.getAllAssignmentIDs()) {
                        Assignment as = this.m_serverEngine.getAssignmentRepository().getAssignment(asnID);
                        if (as == null) continue;
                        this.m_serverEngine.getBinariesRepository().zipDeletedPackage(as);
                    }
                    adu.saveDB(this.m_serverEngine);
                }
                FileUtils.deleteDirectoryRecursive(path);
                this.m_serverEngine.getBinariesRepository().getXmlFile(true);
                ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, path);
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                    ServerClientQ sc = ssc.getServerClient();
                    ((ServerClient)sc).start("DELETE_FOLDER", path, new String[0]);
                }
            } else {
                throw new RuntimeException("Folder not exist");
            }
            out.writeUTF("T");
            this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
            this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNED");
            CMD cmd2 = new CMD("GETFILE", null, new String[]{"boom_packages.xml", "file"});
            this.m_serverEngine.getEventsRouter().addPendingToALL(cmd2);
        }
        catch (Throwable e) {
            RTLogger.print(4, "Error create file", e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    private void processCreateFolder(SDataOutputStream out, SDataInputStream io) throws IOException {
        String path = io.readUTF();
        try {
            Path dirPath = Paths.get(path, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                RTLogger.print(5, "create dir: " + path);
                Files.createDirectories(dirPath, new FileAttribute[0]);
                if (path.contains("srv/packages")) {
                    this.m_serverEngine.getBinariesRepository().getXmlFile(true);
                    ServerEngine.getInstance().getBinariesRepository().notifyUI();
                }
                ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, path);
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                    ServerClientQ sc = ssc.getServerClient();
                    ((ServerClient)sc).start("CREATE_FOLDER", path, new String[0]);
                }
            }
            out.writeUTF("T");
        }
        catch (Throwable e) {
            RTLogger.print(4, "error create folder", e.getMessage());
            out.writeUTF(e.getMessage());
        }
    }

    private void processUpdateActionTree(SDataOutputStream out, SDataInputStream io) throws IOException {
        String action = io.readUTF();
        int size = io.readInt();
        ArrayList<String> arr = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            arr.add(io.readUTF());
        }
        ActionsRepository ar = this.m_serverEngine.getActionRepository();
        switch (action) {
            case "DELETE": {
                String actID = (String)arr.get(0);
                ar.removeAction(actID);
                ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, "ActionID=" + actID);
                break;
            }
            case "DELETE_GRP": {
                String oldName = (String)arr.get(0);
                ar.removeGroup(oldName);
                ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, "ActionGrp=" + oldName);
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_USERS");
                break;
            }
            case "MOVE": {
                String id = (String)arr.get(0);
                String newGroup = (String)arr.get(1);
                ar.moveAction(id, newGroup);
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "MOVEACTION", "ActionID=" + id, newGroup);
                break;
            }
            case "ADD_GRP": {
                String newName = (String)arr.get(0);
                ar.addGroup(newName);
                ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, "ActionGrp=" + newName);
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_USERS");
                break;
            }
            case "RENAME_GRP": {
                String oldName = (String)arr.get(0);
                String newName = (String)arr.get(1);
                ar.renameGroup(oldName, newName);
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "RENAME", "ActionGrp=" + oldName, "ActionGrp=" + newName);
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_USERS");
                break;
            }
        }
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETACTIONS");
        out.writeUTF("T");
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc.getScenario() > 1) continue;
            ServerClientQ sc = ssc.getServerClient();
            ((ServerClient)sc).start("UPDATEACTIONTREE", action, arr.toArray(new String[0]));
        }
    }

    private void processObjects(SDataOutputStream out, SDataInputStream io, String command) throws IOException {
        String action = io.readUTF();
        int size = io.readInt();
        try {
            UserManager uMngr = UserManager.getInstance();
            if (command.equalsIgnoreCase("GET_ProcessUSER")) {
                boolean isOK = true;
                for (int i = 0; i < size; ++i) {
                    User user = User.createNewUser();
                    user.read(io);
                    if (action.equalsIgnoreCase(ACTION_DELETE_OBJECT)) {
                        isOK = uMngr.deleteUser(user);
                        if (!isOK) continue;
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "DELETE", "User=" + user.getLoginName(), null);
                        continue;
                    }
                    if (action.equalsIgnoreCase(ACTION_CREATE_OBJECT)) {
                        isOK = uMngr.saveUser(user);
                        if (!isOK) continue;
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "NEW", "User=" + user.getLoginName(), null);
                        continue;
                    }
                    if (!action.equalsIgnoreCase(ACTION_UPDATE_OBJECT)) continue;
                    User oldUser = uMngr.getUser(user.getLoginName());
                    isOK = uMngr.saveUser(user);
                    if (!isOK) continue;
                    if (oldUser == null) {
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "NEW", "User=" + user.getLoginName(), null);
                        continue;
                    }
                    if (oldUser.isActive() != user.isActive()) {
                        if (user.isActive()) {
                            ServerEngine.getInstance().getAuditLog().log(this.m_login, "ENABLE", "User=" + user.getLoginName(), null);
                            continue;
                        }
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "DISABLE", "User=" + user.getLoginName(), null);
                        continue;
                    }
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", "User=" + user.getLoginName(), null);
                }
                if (isOK) {
                    out.writeUTF("T");
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_USERS");
                } else {
                    out.writeUTF("Error processing operation on User");
                }
            } else if (command.equalsIgnoreCase("GET_ProcessUSERROLE")) {
                boolean isOK = true;
                for (int i = 0; i < size; ++i) {
                    UserRole userr = UserRole.createNewRole();
                    userr.read(io);
                    if (action.equalsIgnoreCase(ACTION_DELETE_OBJECT)) {
                        isOK = uMngr.deleteRole(userr);
                        if (!isOK) continue;
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "DELETE", "UserRole=" + String.valueOf(userr), null);
                        continue;
                    }
                    if (action.equalsIgnoreCase(ACTION_CREATE_OBJECT)) {
                        isOK = uMngr.saveRole(userr, true);
                        if (!isOK) continue;
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "NEW", "UserRole=" + String.valueOf(userr), null);
                        continue;
                    }
                    if (!action.equalsIgnoreCase(ACTION_UPDATE_OBJECT)) continue;
                    UserRole oldRole = uMngr.getRoleByID(userr.getID());
                    isOK = uMngr.saveRole(userr, true);
                    if (!isOK) continue;
                    if (oldRole == null) {
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "NEW", "UserRole=" + userr.getName(), null);
                        continue;
                    }
                    if (oldRole.getName().equals(userr.getName())) {
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", "UserRole=" + userr.getName(), null);
                        continue;
                    }
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", "UserRole=" + oldRole.getName(), userr.getName());
                }
                if (isOK) {
                    out.writeUTF("T");
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_USERS");
                } else {
                    out.writeUTF("Error processing operation on User Role");
                }
            } else if (command.equalsIgnoreCase("ProcessAGENT")) {
                ArrayList<AgentCard> arr = new ArrayList<AgentCard>();
                boolean canDo = true;
                for (int i = 0; i < size; ++i) {
                    AgentCard ac = new AgentCard();
                    ac.read(io);
                    if (canDo && !UserManager.getInstance().checkAction4NodeGroupTree(this.m_userRole.getID(), PGEntityAction.MODIFY, ac.getAgentID())) {
                        canDo = false;
                    }
                    arr.add(ac);
                }
                if (!canDo) {
                    out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                } else {
                    StringBuilder errors = new StringBuilder();
                    boolean isSlavesOnly = true;
                    for (int i = 0; i < size; ++i) {
                        AgentCard ac = (AgentCard)arr.get(i);
                        if (ac.getOSName().startsWith("(BS:")) {
                            int closingBracketFirst = ac.getOSName().indexOf(")", 6);
                            String server = ac.getOSName().substring(6, closingBracketFirst);
                            SlaveServerCard ssc = this.m_serverEngine.getSlave(server);
                            if (ssc == null || ssc.getScenario() >= 3) continue;
                            ac.setOSName(ac.getOSName().substring(closingBracketFirst + 1));
                            ssc.getServerClient().start(command, action, new IODataStream[]{ac});
                            continue;
                        }
                        isSlavesOnly = false;
                        if (action.equalsIgnoreCase(ACTION_DELETE_OBJECT)) {
                            RTLogger.print(5, "deprecated delete agent call");
                            continue;
                        }
                        if (action.equalsIgnoreCase(ACTION_CREATE_OBJECT)) {
                            try {
                                this.m_serverEngine.getAgentRepository().createAgentCard(ac, this.m_login);
                            }
                            catch (Exception e) {
                                errors.append(e.getMessage()).append('\n');
                                RTLogger.print(2, "Skip creation of the conflicting AgentCard.", e);
                            }
                            continue;
                        }
                        if (!action.equalsIgnoreCase(ACTION_UPDATE_OBJECT)) continue;
                        this.m_serverEngine.getAgentRepository().updateFrom(ac, this.m_login);
                    }
                    if (!isSlavesOnly) {
                        this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                    }
                    if (errors.length() > 0) {
                        out.writeUTF(errors.toString());
                    } else {
                        out.writeUTF("T");
                    }
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "Failed Command: " + command, e);
            try {
                out.writeUTF(e.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processGetHelps(SDataOutputStream out) throws IOException {
        Map<String, String> m_helps = this.m_serverEngine.getPolicyRepository().getHelps();
        int size = m_helps.size();
        out.writeInt(size);
        Iterator<Map.Entry<String, String>> it = m_helps.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, String> en = it.next();
            String id = en.getKey();
            String text = en.getValue();
            out.writeUTF(id);
            out.writeUTF(text);
        }
        out.writeUTF("T");
    }

    private void processGetHelp(SDataOutputStream out, SDataInputStream io) throws IOException {
        String id = io.readUTF();
        Map<String, String> m_helps = this.m_serverEngine.getPolicyRepository().getHelps();
        String help = m_helps.get(id);
        if (help == null) {
            help = EMPTY;
            try {
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    if (ssc.getScenario() < 2) continue;
                    ServerClient sc = ssc.getServerClientStandAlone();
                    if (!sc.run("GET_HELP", id, new String[]{id})) continue;
                    help = (String)sc.getResultObject();
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        out.writeUTF(help);
        out.writeUTF("T");
    }

    @Deprecated
    private void processGetFreshActiveMsgs(SDataOutputStream out, String user) throws IOException {
        EventOperations eventOperations = this.m_serverEngine.getEventsRouter().getEventOperations();
        Collection<SEventFwd> events = eventOperations.freshGetActiveMessages(user, this.m_hostAddressConnected);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        out.writeInt(events.size());
        out.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd e = it.next();
            e.sendS(out);
            out.writeBoolean(it.hasNext());
        }
        out.writeUTF("T");
    }

    private void processGetFreshActiveMsgsEXT(SDataOutputStream out, String user) throws IOException {
        EventOperations eventOperations = this.m_serverEngine.getEventsRouter().getEventOperations();
        Collection<SEventFwd> events = eventOperations.freshGetActiveMessages(user, this.m_hostAddressConnected);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        out.writeInt(events.size());
        out.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd o = it.next();
            if (o != null) {
                o.sendSv2(out);
            }
            out.writeBoolean(it.hasNext());
        }
        out.writeUTF("T");
    }

    private void processGetFreshActiveMsgsEXT_ZIP(SDataOutputStream outSock, String user, int protocolVresion, EventOperations eventOperations) throws IOException {
        this.m_socket.setSoTimeout(300000);
        Collection<SEventFwd> events = eventOperations.freshGetActiveMessages(user, this.m_hostAddressConnected);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        int count = 0;
        int predictedSize = 5324800;
        if (events.size() < 5000) {
            predictedSize = events.size() * 1024;
        }
        ByteArrayOutputStream bbb = new ByteArrayOutputStream(predictedSize);
        SDataOutputStream sdo = new SDataOutputStream(bbb, protocolVresion);
        sdo.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd o = it.next();
            if (o != null) {
                o.sendSv2(sdo);
            }
            if (++count >= 5000) {
                sdo.writeBoolean(false);
                outSock.writeInt(bbb.size());
                outSock.write(bbb.toByteArray());
                bbb.reset();
            }
            sdo.writeBoolean(it.hasNext());
        }
        if (bbb.size() > 0) {
            outSock.writeInt(bbb.size());
            outSock.write(bbb.toByteArray());
        }
        outSock.writeInt(0);
        outSock.writeUTF("T");
    }

    private void processGetFreshAcknMsgs(SDataOutputStream out, String user) throws IOException {
        Collection<SEventFwd> events = this.m_serverEngine.getEventsRouter().getEventOperations().freshGetAcknowledgedMessages(user);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        out.writeInt(events.size());
        out.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd e = it.next();
            e.sendS(out);
            out.writeBoolean(it.hasNext());
        }
        out.writeUTF("T");
    }

    private void processGetFreshAcknMsgsEXT(SDataOutputStream out, String user) throws IOException {
        Collection<SEventFwd> events = this.m_serverEngine.getEventsRouter().getEventOperations().freshGetAcknowledgedMessages(user);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        out.writeInt(events.size());
        out.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd o = it.next();
            if (o != null) {
                o.sendSv2(out);
            }
            out.writeBoolean(it.hasNext());
        }
        out.writeUTF("T");
    }

    private void processGetFreshAcknMsgsEXT_ZIP(SDataOutputStream outSock, String user, int protocolVresion, EventOperations eo) throws IOException {
        this.m_socket.setSoTimeout(300000);
        Collection<SEventFwd> events = eo.freshGetAcknowledgedMessages(user);
        Iterator<SEventFwd> itOrig = events.iterator();
        EventIterator it = new EventIterator(itOrig, this.m_serverEngine.getForwardManager(), user);
        int eventCount = 0;
        int predictedSize = 5324800;
        if (events.size() < 5000) {
            predictedSize = events.size() * 1024;
        }
        ByteArrayOutputStream bbb = new ByteArrayOutputStream(predictedSize);
        SDataOutputStream sdo = new SDataOutputStream(bbb, protocolVresion);
        sdo.writeBoolean(it.hasNext());
        while (it.hasNext()) {
            SEventFwd o = it.next();
            if (o != null) {
                o.sendSv2(sdo);
            }
            if (++eventCount >= 5000) {
                sdo.writeBoolean(false);
                outSock.writeInt(bbb.size());
                outSock.write(bbb.toByteArray());
                bbb.reset();
                eventCount = 0;
            }
            sdo.writeBoolean(it.hasNext());
        }
        outSock.writeInt(bbb.size());
        outSock.write(bbb.toByteArray());
        outSock.writeInt(0);
        outSock.writeUTF("T");
    }

    @Deprecated
    private void processGetAcknIDs(SDataOutputStream out) throws IOException {
        Enumeration<String> en = this.m_serverEngine.getEventsRouter().getEventOperations().getAcknowledgedIDs();
        out.writeBoolean(en.hasMoreElements());
        while (en.hasMoreElements()) {
            String id = en.nextElement();
            out.writeUTF(id);
            out.writeBoolean(en.hasMoreElements());
        }
        out.writeUTF("T");
    }

    private void processGetAcknIDsA(SDataOutputStream out) throws IOException {
        Enumeration<String> en = this.m_serverEngine.getEventsRouter().getEventOperations().getAcknowledgedIDs();
        StringBuilder sb = new StringBuilder();
        while (en.hasMoreElements()) {
            String id = en.nextElement();
            sb.append(id);
            if (!en.hasMoreElements()) continue;
            sb.append(',');
        }
        out.writeUTF(sb.toString());
        out.writeUTF("T");
    }

    private void processGetAcknIDsB(SDataOutputStream out, String user) throws IOException {
        Enumeration<String> en = this.m_serverEngine.getEventsRouter().getEventOperations().getAcknowledgedIDs();
        GUIClientProxy cp = this.m_serverEngine.getEventsRouter().getEventOperations().getClientProxyMgr().getClientCache(user);
        StringBuilder sb = new StringBuilder();
        while (en.hasMoreElements()) {
            String id = en.nextElement();
            if (cp != null && cp.isUserIndicationsFiltered() && !this.m_serverEngine.getEventsRouter().getEventOperations().isFilteredForUser(id, cp)) continue;
            sb.append(id);
            if (!en.hasMoreElements()) continue;
            sb.append(',');
        }
        out.writeUTF(sb.toString());
        out.writeUTF("T");
    }

    private void processGetLastWeekArchivedIDs(SDataOutputStream out) throws IOException {
        Map<String, Object> en = this.m_serverEngine.getDB().getArchiveIDs();
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = en.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            sb.append(id);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        out.writeUTF(sb.toString());
        out.writeUTF("T");
    }

    @Deprecated
    private void processGetNewMsgs(SDataOutputStream out, String user) throws IOException {
        Queue<SEventFwd> newMessagesQueue = this.m_serverEngine.getEventsRouter().getEventOperations().getClientProxyMgr().getActualNewQ(user);
        if (newMessagesQueue == null) {
            Collection<SEventFwd> newMessagesAll = this.m_serverEngine.getEventsRouter().getEventOperations().freshGetActiveMessages(user, this.m_hostAddressConnected);
            Iterator<SEventFwd> it = newMessagesAll.iterator();
            out.writeInt(newMessagesAll.size());
            out.writeBoolean(it.hasNext());
            int i = 0;
            while (it.hasNext() && i < 10000) {
                IEvent e = it.next();
                e.sendS(out);
                out.writeBoolean(it.hasNext() && ++i < 10000);
            }
        } else {
            SEventFwd se;
            out.writeInt(newMessagesQueue.size());
            out.writeBoolean(newMessagesQueue.peek() != null);
            int i = 0;
            while (i < 10000 && (se = newMessagesQueue.poll()) != null) {
                se.sendS(out);
                out.writeBoolean(newMessagesQueue.peek() != null && ++i < 10000);
            }
        }
        out.writeUTF("T");
    }

    private void processGetNewMsgsEXT(SDataOutputStream out, String user, EventOperations eo) throws IOException {
        Queue<SEventFwd> newMessagesQueue = eo.getClientProxyMgr().getActualNewQ(user);
        if (newMessagesQueue == null) {
            Collection<SEventFwd> newMessages = eo.freshGetActiveMessages(user, this.m_hostAddressConnected);
            Iterator<SEventFwd> evIT = newMessages.iterator();
            EventIterator it = new EventIterator(evIT, this.m_serverEngine.getForwardManager(), user);
            out.writeInt(newMessages.size());
            out.writeBoolean(it.hasNext());
            int i = 0;
            while (it.hasNext() && i < 10000) {
                SEventFwd o = it.next();
                if (o != null) {
                    o.sendSv2(out);
                }
                out.writeBoolean(it.hasNext() && ++i < 10000);
            }
        } else {
            SEventFwd se;
            out.writeInt(newMessagesQueue.size());
            out.writeBoolean(newMessagesQueue.peek() != null);
            int i = 0;
            while (i < 10000 && (se = newMessagesQueue.poll()) != null) {
                se.sendSv2(out);
                out.writeBoolean(newMessagesQueue.peek() != null && ++i < 10000);
            }
        }
        out.writeUTF("T");
    }

    @Deprecated
    private void processGetAcknowledgedMsgs(SDataOutputStream out, String user, EventOperations eventOperations) throws IOException {
        Queue<String> closedQueue = eventOperations.getClientProxyMgr().getActualClosedQ(user);
        if (closedQueue == null) {
            Collection<SEventFwd> closedMessages = eventOperations.freshGetAcknowledgedMessages(user);
            Iterator<SEventFwd> it = closedMessages.iterator();
            out.writeBoolean(it.hasNext());
            int i = 0;
            while (it.hasNext() && i < 50000) {
                SEventFwd se = it.next();
                char state = se.getState();
                out.writeUTF(se.getID() + state + se.getT9());
                out.writeBoolean(it.hasNext() && ++i < 50000);
            }
        } else {
            String id;
            out.writeBoolean(closedQueue.peek() != null);
            int i = 0;
            while (i < 50000 && (id = closedQueue.poll()) != null) {
                SEventFwd se = eventOperations.getEvent(id);
                if (se != null) {
                    out.writeUTF(id + se.getState() + se.getT9());
                } else {
                    out.writeUTF(id + "X");
                }
                out.writeBoolean(closedQueue.peek() != null && ++i < 50000);
            }
        }
        out.writeUTF("T");
    }

    private void processGetAcknowledgedMsgsB(SDataOutputStream out, String user) throws IOException {
        EventOperations eventOperations = this.m_serverEngine.getEventsRouter().getEventOperations();
        GUIClientProxy cp = eventOperations.getClientProxyMgr().getClientCache(user);
        Queue<String> closedMessagesQueue = eventOperations.getClientProxyMgr().getActualClosedQ(user);
        if (closedMessagesQueue == null) {
            Collection<SEventFwd> newMessagesAll = eventOperations.freshGetAcknowledgedMessages(user);
            Iterator<SEventFwd> it = newMessagesAll.iterator();
            out.writeBoolean(it.hasNext());
            int i = 0;
            boolean mustSendDummy = false;
            while (it.hasNext() && i < 50000) {
                SEventFwd event = it.next();
                String id = event.getID();
                if (cp != null && cp.isUserIndicationsFiltered() && !eventOperations.isFilteredForUser(event.getID(), cp)) {
                    mustSendDummy = true;
                    continue;
                }
                mustSendDummy = false;
                out.writeUTF(id + event.getState() + event.getT9());
                out.writeBoolean(it.hasNext() && ++i < 50000);
            }
            if (mustSendDummy) {
                out.writeUTF("123456789012345678901234567890123456A");
                out.writeBoolean(false);
            }
        } else {
            String id;
            boolean mustSendDummy = false;
            out.writeBoolean(closedMessagesQueue.peek() != null);
            int i = 0;
            while (i < 50000 && (id = closedMessagesQueue.poll()) != null) {
                if (cp != null && cp.isUserIndicationsFiltered() && !eventOperations.isFilteredForUser(id, cp)) {
                    mustSendDummy = true;
                    continue;
                }
                mustSendDummy = false;
                SEventFwd se = eventOperations.getEvent(id);
                if (se != null) {
                    out.writeUTF(id + se.getState() + se.getT9());
                } else {
                    out.writeUTF(id + "X");
                }
                out.writeBoolean(closedMessagesQueue.peek() != null && ++i < 50000);
            }
            if (mustSendDummy) {
                out.writeUTF("123456789012345678901234567890123456A");
                out.writeBoolean(false);
            }
        }
        out.writeUTF("T");
    }

    @Deprecated
    private void processGetUpdatedMessages(SDataOutputStream out, String user) throws IOException {
        Queue<SEventFwd> updatedMessagesQueue = this.m_serverEngine.getEventsRouter().getEventOperations().getClientProxyMgr().getActualUpdatedQ(user);
        if (updatedMessagesQueue == null || updatedMessagesQueue.isEmpty()) {
            out.writeBoolean(false);
        } else {
            SEventFwd se;
            out.writeBoolean(updatedMessagesQueue.peek() != null);
            int i = 0;
            while (i < 10000 && (se = updatedMessagesQueue.poll()) != null) {
                se.sendS(out);
                out.writeBoolean(updatedMessagesQueue.peek() != null && ++i < 10000);
            }
        }
        out.writeUTF("T");
    }

    private void processGetUpdatedMessagesEXT(SDataOutputStream out, String user, EventOperations eo) throws IOException {
        Queue<SEventFwd> updatedMessagesQueue = eo.getClientProxyMgr().getActualUpdatedQ(user);
        if (updatedMessagesQueue == null || updatedMessagesQueue.isEmpty()) {
            out.writeBoolean(false);
        } else {
            SEventFwd se;
            out.writeBoolean(updatedMessagesQueue.peek() != null);
            int i = 0;
            while (i < 10000 && (se = updatedMessagesQueue.poll()) != null) {
                se.sendSv2(out);
                out.writeBoolean(updatedMessagesQueue.peek() != null && ++i < 10000);
            }
        }
        out.writeUTF("T");
    }

    private void processGetArchivedMessages(SDataOutputStream out, String user, EventOperations eo) throws IOException {
        Queue<String> archivedMessagesQueue = eo.getClientProxyMgr().getActualArchivedQ(user);
        if (archivedMessagesQueue == null || archivedMessagesQueue.isEmpty()) {
            out.writeBoolean(false);
        } else {
            String id;
            out.writeBoolean(archivedMessagesQueue.peek() != null);
            int i = 0;
            while (i < 50000 && (id = archivedMessagesQueue.poll()) != null) {
                out.writeUTF(id);
                out.writeBoolean(archivedMessagesQueue.peek() != null && ++i < 50000);
            }
        }
        out.writeUTF("T");
    }

    private void processGetAssignments(SDataOutputStream out) throws IOException {
        File assignmentGroups_xml = new File(this.m_serverEngine.getAssignmentRepository().getAssignmentGroupsFile());
        try (FileInputStream fis = new FileInputStream(assignmentGroups_xml);){
            out.writeLong(assignmentGroups_xml.length());
            out.writeFile(fis);
        }
        catch (RuntimeException e) {
            out.writeLong(0L);
            out.writeUTF("F");
            return;
        }
        out.writeUTF("T");
    }

    private void processGetAgentCardList(SDataOutputStream out, SDataInputStream in) throws IOException {
        String action = in.readUTF();
        String[] ids = action.split("\\s*,\\s*");
        ArrayList<AgentCard> allAC = new ArrayList<AgentCard>();
        for (String id : ids) {
            AgentCard ac2 = this.m_serverEngine.getAgentRepository().getAgentCardByID(id);
            if (ac2 == null) continue;
            allAC.add(ac2);
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(this.m_login)) {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(this.m_login);
            allAC.removeIf(ac -> !UserManager.getInstance().isAgentVisible(this.m_login, ac.getAgentID(), nodeGroups));
        }
        Iterator it = allAC.iterator();
        out.writeInt(allAC.size());
        while (it.hasNext()) {
            AgentCard ac3 = (AgentCard)it.next();
            ac3.send(out);
        }
        allAC.clear();
        out.writeUTF("T");
    }

    private void processGetAgentCard(SDataOutputStream out) throws IOException {
        List<AgentCard> allAC = this.m_serverEngine.getAgentRepository().getAgentCards(this.m_login);
        Iterator<AgentCard> it = allAC.iterator();
        out.writeInt(allAC.size());
        while (it.hasNext()) {
            AgentCard ac = it.next();
            ac.send(out);
        }
        out.writeUTF("T");
    }

    private void processGetPending(SDataOutputStream out) throws IOException {
        this.m_socket.setSoTimeout(120000);
        GUIClientProxy cache = this.m_serverEngine.getEventsRouter().getEventOperations().getClientProxyMgr().getClientCache(this.m_login);
        if (cache != null) {
            Queue<CMD> c = cache.getPending();
            int size = c.size();
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                CMD cmd = c.peek();
                if (cmd != null) {
                    cmd.send(out);
                    c.poll();
                    continue;
                }
                new CMD("PING").send(out);
                RTLogger.print(5, "missing pending CMD. Login:" + this.m_login + " UIsocket-local-port:" + this.m_socket.getLocalPort());
            }
            out.writeUTF("T");
            if (size > 0) {
                RTLogger.print(5, new StringBuilder("GETPENDING").append(" ").append(size).append(" ").append(this.m_login));
            }
        } else {
            out.writeInt(0);
            out.writeUTF("T");
        }
    }

    private void processClearPending(SDataOutputStream out) throws IOException {
        GUIClientProxy cache2;
        try {
            cache2 = this.m_serverEngine.getEventsRouter().getEventOperations().getClientProxyMgr().getClientCache(this.m_login);
            if (cache2 != null) {
                cache2.getPending().clear();
            }
        }
        catch (Throwable cache2) {
            // empty catch block
        }
        try {
            cache2 = this.m_serverEngine.getEventsRouter().getEventOperationsOutage().getClientProxyMgr().getClientCache(this.m_login);
            if (cache2 != null) {
                cache2.getPending().clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out.writeUTF("T");
    }

    private void processAssignmentTreeUpdate2(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<String[]> names = new ArrayList<String[]>();
        for (int i = 0; i < size; ++i) {
            String treePathParent = in.readUTF();
            String newElement = in.readUTF();
            String action = in.readUTF();
            String type = in.readUTF();
            parameters.add(treePathParent);
            parameters.add(newElement);
            parameters.add(action);
            parameters.add(type);
            names.add(new String[]{treePathParent, newElement, action, type});
        }
        SAssignmentRepository sar = this.m_serverEngine.getAssignmentRepository();
        AsnDbUpdate adu = new AsnDbUpdate();
        for (String[] arr : names) {
            String treePathParent = arr[0];
            String newElement = arr[1];
            String action = arr[2];
            String type = arr[3];
            if (IMAGE_FOLDER_CUT_STR.equals(type)) {
                type = EMPTY;
            }
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Action=" + action + " Parent=" + treePathParent + " new=" + newElement);
            }
            GroupTreeObject root = sar.getAsnTree();
            try {
                block74: {
                    if (action.equals(ACTION_ADD)) {
                        el = root.searchPath(treePathParent, EMPTY);
                        if (el == null) {
                            el = root.searchPath(treePathParent, "pga");
                        }
                        if (el == null) {
                            out.writeUTF("Error creating Element. Parent not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        String typeEL = ((GroupTreeObject)el).getTreeObject().getType();
                        if (newElement.contains(BM.GTO_PATH_SEPARATOR)) {
                            GroupTreeObject.createPath(newElement, root);
                            ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, treePathParent + "/" + newElement);
                        } else {
                            String type1 = EMPTY;
                            if (typeEL.equals("toplevel")) {
                                type1 = "pga";
                            }
                            GroupTreeObject newEl = new GroupTreeObject(new TreeObject(newElement, type1, null));
                            ((GroupTreeObject)el).addElement(newEl);
                            ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newEl.getPath());
                        }
                    } else if (action.equals(ACTION_DEL) || action.equals(ACTION_DEL_and_UNDEPLOY)) {
                        el = root.searchPath(treePathParent, EMPTY);
                        if (el == null) {
                            el = root.searchPath(treePathParent, "pga");
                        }
                        if (el == null) {
                            out.writeUTF("Error deleting Assignment. Assignment group not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        boolean dontUndeploy = !ACTION_DEL_and_UNDEPLOY.equals(action);
                        String nameEL = ((GroupTreeObject)el).getName();
                        String typeEL = ((GroupTreeObject)el).getType();
                        Map<GroupTreeObject, GroupTreeObject> children = ((GroupTreeObject)el).getAllElementsMap();
                        GroupTreeObject gtoParent = ((GroupTreeObject)el).getParent();
                        gtoParent.removeElement((GroupTreeObject)el);
                        ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, treePathParent + "." + typeEL);
                        if (typeEL.equals("pga")) {
                            List<String> impactedACs = sar.getAgentsAssigned(nameEL, typeEL);
                            sar.deleteAssignment(adu, this.m_login, nameEL, typeEL, dontUndeploy);
                            for (GroupTreeObject gto : children.keySet()) {
                                if (!(gto instanceof GroupTreeObjectLast)) continue;
                                GroupTreeObjectLast policyOrbinary = (GroupTreeObjectLast)gto;
                                Iterator iterator = impactedACs.iterator();
                                while (iterator.hasNext()) {
                                    String impactedAC = (String)iterator.next();
                                    this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, policyOrbinary.getName(), policyOrbinary.getType(), impactedAC, dontUndeploy);
                                }
                            }
                        } else {
                            for (GroupTreeObject groupTreeObject : children.keySet()) {
                                sar.deleteAssignment(adu, this.m_login, groupTreeObject.getName(), groupTreeObject.getType(), dontUndeploy);
                            }
                        }
                    } else if (action.equals(ACTION_RNM)) {
                        el = root.searchPath(treePathParent, EMPTY);
                        if (el == null) {
                            el = root.searchPath(treePathParent, "pga");
                        }
                        if (el == null) {
                            out.writeUTF("Error rename Assignment. Assignment not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        nameEL = ((GroupTreeObject)el).getName();
                        typeEL = ((GroupTreeObject)el).getType();
                        ((GroupTreeObject)el).setName(newElement);
                        sar.renameAssignment(nameEL, newElement, this.m_login, typeEL);
                        ServerEngine.getInstance().getAuditLog().logRename(this.m_login, treePathParent, ((GroupTreeObject)el).getPath());
                    } else if (action.equals(ACTION_COPY)) {
                        el = root.searchPath(treePathParent, type);
                        if (el == null) {
                            out.writeUTF("Error copy. Assignment not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        newFolder = root.searchPath(newElement, EMPTY);
                        if (newFolder == null) {
                            newFolder = root.searchPath(newElement, "pga");
                        }
                        if (newFolder == null) {
                            out.writeUTF("Error linking. Target not found: " + newElement);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, newFolder.getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        try {
                            GroupTreeObject clone = ((GroupTreeObject)el).clone();
                            if (newFolder.getChild(((GroupTreeObject)el).getName(), ((GroupTreeObject)el).getType()) != null) {
                                if (!(el instanceof GroupTreeObjectLast)) {
                                    clone.setName(clone.getName() + "_Copy_" + System.currentTimeMillis());
                                    newFolder.addElement(clone);
                                    ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, clone.getPath());
                                }
                                break block74;
                            }
                            newFolder.addElement(clone);
                            ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, clone.getPath());
                        }
                        catch (Throwable e) {
                            RTLogger.print(5, "Copy error. ", e);
                        }
                    } else if (action.equals(ACTION_ADDLINK) || action.equals(ACTION_ADDLINK_noDeploy)) {
                        GroupTreeObject newFolder = root.searchPath(newElement, EMPTY);
                        if (newFolder == null) {
                            newFolder = root.searchPath(newElement, "pga");
                        }
                        if (newFolder == null) {
                            out.writeUTF("Error linking. Assignment group not found: " + newElement);
                            out.writeUTF("F");
                            return;
                        }
                        GroupTreeObject assignmentGroup = newFolder.findFirstParent("pga");
                        if (assignmentGroup == null) {
                            out.writeUTF("Error linking. Assignment group not found: " + newElement);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, assignmentGroup.getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        String[] elem = treePathParent.split("/");
                        String nameEL = null;
                        String typeEL = null;
                        if (elem[2].equalsIgnoreCase("Policies")) {
                            spr = ServerEngine.getInstance().getPolicyRepository();
                            GroupTreeObject rootPolicy = ((SPolicyRepository)spr).getPolicyTree();
                            el = rootPolicy.searchPath(treePathParent, type);
                            if (el != null) {
                                nameEL = el.getName();
                                typeEL = el.getTreeObject().getType();
                                if (typeEL.equals("mon") || typeEL.equals("msg")) {
                                    to = new TreeObject(el.getName(), typeEL, null);
                                    try {
                                        newEl = new GroupTreeObjectLast(to, treePathParent, null);
                                        newFolder.addElement(newEl);
                                        ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newEl.getPath() + "." + typeEL);
                                    }
                                    catch (RuntimeException newEl) {}
                                } else if (typeEL.equalsIgnoreCase(EMPTY)) {
                                    GroupTreeObject newSubFolder = new GroupTreeObject(new TreeObject(el.getName(), typeEL, null));
                                    newSubFolder = this.processAssignmentTreeUpdateRecursive(sar, assignmentGroup, action, treePathParent, newSubFolder, el);
                                    try {
                                        newFolder.addElement(newSubFolder);
                                        ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newSubFolder.getPath());
                                    }
                                    catch (RuntimeException runtimeException) {}
                                }
                            } else {
                                RTLogger.print(2, "Source not found: " + treePathParent);
                            }
                        } else if (elem[2].equalsIgnoreCase("Packages")) {
                            spr = ServerEngine.getInstance().getBinariesRepository();
                            GroupTreeObject rootBinaries = ((BinariesRepository)spr).getTree();
                            el = rootBinaries.searchPath(treePathParent, type);
                            if (el != null) {
                                nameEL = el.getName();
                                typeEL = el.getTreeObject().getType();
                                to = new TreeObject(el.getName(), "pkg", null);
                                newEl = new GroupTreeObjectLast(to, treePathParent, null);
                                newFolder.addElement(newEl);
                                ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newEl.getPath() + "." + typeEL);
                            } else {
                                RTLogger.print(2, "Source not found: " + treePathParent);
                            }
                        }
                        if (nameEL != null && typeEL != null) {
                            List<String> agents = sar.getAgentsAssigned(assignmentGroup.getName(), "pga");
                            for (String agentID : agents) {
                                Assignment asn = Assignment.getInstance(agentID, nameEL, this.m_login, typeEL);
                                sar.addAssignment(asn, true);
                            }
                        }
                    } else if (action.equals(ACTION_MOVE)) {
                        el = root.searchPath(treePathParent, type);
                        if (el == null) {
                            out.writeUTF("Error: Element not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        newFolder = root.searchPath(newElement, EMPTY);
                        if (newFolder == null) {
                            newFolder = root.searchPath(newElement, "pga");
                        }
                        if (newFolder == null) {
                            out.writeUTF("Error: Path not found: " + newElement);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, newFolder.getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        ((GroupTreeObject)el).getParent().removeElement((GroupTreeObject)el);
                        newFolder.addElement((GroupTreeObject)el);
                        ServerEngine.getInstance().getAuditLog().logRename(this.m_login, treePathParent, ((GroupTreeObject)el).getPath());
                    } else if (action.equals(ACTION_DELLINK) || action.equals(ACTION_DELLINK_noDeploy)) {
                        el = root.searchPath(treePathParent, type);
                        if (el == null) {
                            out.writeUTF("Error delete link. Element not found: " + treePathParent);
                            out.writeUTF("F");
                            return;
                        }
                        if (!UserManager.getInstance().checkAsnTree(this.m_login, PGEntityAction.MODIFY, ((GroupTreeObject)el).getPath())) {
                            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                            out.writeUTF("F");
                            return;
                        }
                        nameEL = ((GroupTreeObject)el).getName();
                        typeEL = ((GroupTreeObject)el).getTreeObject().getType();
                        GroupTreeObject gtoParent = ((GroupTreeObject)el).getParent();
                        gtoParent.removeElement((GroupTreeObject)el);
                        ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, treePathParent + "." + typeEL);
                        if (action.equals(ACTION_DELLINK)) {
                            sar.deleteAssignment(adu, this.m_login, nameEL, typeEL, true);
                        }
                    }
                }
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    if (ssc.getScenario() > 1) continue;
                    ServerClientQ sc = ssc.getServerClient();
                    ((ServerClient)sc).start("ASSIGNMENTTREEUPDATE2", null, parameters.toArray(new String[0]));
                }
                this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
            }
            catch (RuntimeException e) {
                RTLogger.print(2, "Assignment tree update failed. Action=" + action + " TreePath=" + treePathParent + " Parameter=" + newElement);
                RTLogger.print(5, EMPTY, e);
            }
        }
        sar.saveTree();
        adu.saveDB(this.m_serverEngine);
        this.m_serverEngine.getAssignmentRepository().triggerDelayed(adu.getAllAssignmentIDs());
        out.writeUTF(EMPTY);
        out.writeUTF("T");
    }

    private GroupTreeObject processAssignmentTreeUpdateRecursive(SAssignmentRepository sar, GroupTreeObject assignmentGroup, String action, String treePathParent, GroupTreeObject newFolder, Object obj) {
        GroupTreeObject gtoNew = null;
        if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
            GroupTreeObject gto = (GroupTreeObject)obj;
            gtoNew = new GroupTreeObject(new TreeObject(gto.getName(), gto.getTreeObject().getType(), null));
            List<GroupTreeObject> list = gto.getElements();
            for (GroupTreeObject o : list) {
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                    Object link = EMPTY;
                    if (action.equals(ACTION_ADDLINK) || action.equals(ACTION_ADDLINK_noDeploy)) {
                        link = treePathParent + "/" + gtol.getName();
                    }
                    TreeObject to = new TreeObject(gtol.getName(), gtol.getTreeObject().getType(), null);
                    gtoNew.addElement(new GroupTreeObjectLast(to, (String)link, null));
                    List<String> agents = sar.getAgentsAssigned(assignmentGroup.getName(), "pga");
                    for (String agentID : agents) {
                        sar.addAssignment(Assignment.getInstance(agentID, gtol.getName(), this.m_login, gtol.getTreeObject().getType()), true);
                    }
                    continue;
                }
                GroupTreeObject folder = this.processAssignmentTreeUpdateRecursive(sar, assignmentGroup, action, treePathParent + "/" + o.getName(), gtoNew, o);
                gtoNew.addElement(folder);
            }
        } else if (obj instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            String link = treePathParent + "/" + gtol.getName();
            TreeObject to = new TreeObject(gtol.getName(), gtol.getTreeObject().getType(), null);
            newFolder.addElement(new GroupTreeObjectLast(to, link, null));
            return newFolder;
        }
        return gtoNew;
    }

    private void processDeletePolicy(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> params = new ArrayList<String>(size);
        ArrayList<String[]> names = new ArrayList<String[]>();
        for (int i = 0; i < size; ++i) {
            String objectName = in.readUTF();
            params.add(objectName);
            String objectType = in.readUTF();
            params.add(objectType);
            String filename = in.readUTF();
            params.add(filename);
            names.add(new String[]{objectName, objectType, filename});
        }
        SAssignmentRepository sar = this.m_serverEngine.getAssignmentRepository();
        SPolicyRepository spr = this.m_serverEngine.getPolicyRepository();
        Object result = EMPTY;
        AsnDbUpdate adu = new AsnDbUpdate();
        for (String[] arr : names) {
            String objectName = arr[0];
            String objectType = arr[1];
            String newPolicyNameToDeploy = arr[2];
            int isOK = 84;
            String fileNameFull = spr.getFilename(objectName);
            GroupTreeObjectLast gtol = spr.getPolicyTree().findElement(objectName, objectType);
            if (gtol != null) {
                if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, gtol.getName(), gtol.getType())) {
                    out.writeUTF("You are not allowed to change this object!");
                    out.writeUTF("F");
                    return;
                }
                List<GroupTreeObjectLast> al = sar.getAsnTree().findLinksByName(gtol.getPath());
                RTLogger.print(3, String.valueOf(al));
                Iterator<Object> it2 = al.iterator();
                boolean isSARchanged = it2.hasNext();
                while (it2.hasNext()) {
                    GroupTreeObjectLast gtollink = (GroupTreeObjectLast)it2.next();
                    gtollink.getParent().removeElement(gtollink);
                }
                if (isSARchanged) {
                    sar.saveTree();
                }
                result = "Policy deleted and will be undeployed from all agents";
                if (!EMPTY.equals(newPolicyNameToDeploy)) {
                    ServerEngine.getInstance().getAuditLog().logRename(this.m_login, objectName + "." + objectType, newPolicyNameToDeploy + "." + objectType);
                } else {
                    ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, objectName + "." + objectType);
                }
            } else {
                result = "Policy does not exist";
            }
            List<String> agentsImpacted = sar.deleteAssignment(adu, this.m_login, objectName, objectType, false);
            if (objectType.equals("mon")) {
                spr.removeFromKnownMonitors(objectName, false);
            } else if (objectType.equals("msg")) {
                spr.removeFromKnownMsgPolicies(objectName, false);
            }
            if (!EMPTY.equals(newPolicyNameToDeploy)) {
                for (String agentID : agentsImpacted) {
                    sar.addAssignment(adu, agentID, newPolicyNameToDeploy, this.m_login, objectType, true);
                }
            }
            if (newPolicyNameToDeploy.length() > 0 && !objectName.equals(newPolicyNameToDeploy)) {
                this._renameHistory(objectName + "." + objectType + ".xml.", newPolicyNameToDeploy + "." + objectType + ".xml.");
            }
            File f = new File(SPolicyRepository.getPolicyDir() + File.separator + fileNameFull);
            BkpFile.move(f);
            if (f.exists() && !f.delete()) {
                result = "Can't delete file (1): " + fileNameFull;
                RTLogger.print(5, (String)result);
                isOK = 70;
            }
            result = (String)result + (char)isOK;
        }
        spr.saveTree();
        adu.saveDB(this.m_serverEngine);
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
        this.m_serverEngine.getAssignmentRepository().triggerDelayed(adu.getAllAssignmentIDs());
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETPOLICIES");
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNED");
        out.writeUTF((String)result);
        out.writeUTF("T");
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc.getScenario() > 1) continue;
            ServerClientQ sc = ssc.getServerClient();
            ((ServerClient)sc).start("DELETEPOLICY", null, params.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdatePolicy(SDataOutputStream out, SDataInputStream in, boolean forceVersion) throws IOException {
        String objectName = in.readUTF();
        String objectType = in.readUTF();
        Object filename = in.readUTF();
        String treePath = in.readUTF();
        in.readLong();
        File temp = new File((String)filename + System.currentTimeMillis() + ".tmp");
        SPolicyRepository policyRepository = this.m_serverEngine.getPolicyRepository();
        if (objectType.equals("mon")) {
            Object result = "Unexpected Exception";
            int isOK = 84;
            try {
                in.readFile(temp.getCanonicalPath());
                Policy p = null;
                try {
                    p = policyRepository.getPolicyFactory().initPolicy(temp);
                }
                catch (PolicyParsingException policyParsingException) {
                    // empty catch block
                }
                if (p == null) {
                    result = "Error during init of uploaded policy. " + String.valueOf(temp);
                    isOK = 70;
                } else {
                    if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, p.getName(), objectType)) {
                        throw new RuntimeException("You are not allowed to change this object!");
                    }
                    filename = p.getName() + ".mon.xml";
                    Policy old = policyRepository.getMonitorPolicy(objectName);
                    if (old == null) {
                        result = "Successfuly created a new Monitor Policy. " + p.getName();
                        policyRepository.createMonitorPolicy(p, (String)filename, treePath);
                        this.deleteOldVersions((String)filename);
                        this.pushPolicyToProxies(objectName, objectType, (String)filename, treePath);
                        ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, treePath + "/" + p.getName());
                        this.m_serverEngine.getEventsRouter().addPendingToALL("GETPOLICIES");
                    } else if (!forceVersion && PolicyFactory.getVersionAsInt(p.getVersion()) <= PolicyFactory.getVersionAsInt(old.getVersion())) {
                        result = "Version of the policy conflicts with actual: " + p.getName();
                        isOK = 70;
                    } else {
                        result = "Monitor Policy was successfuly updated. " + p.getName();
                        policyRepository.createMonitorPolicy(p, (String)filename, treePath);
                        this.pushPolicyToProxies(objectName, objectType, (String)filename, treePath);
                        ServerEngine.getInstance().getAuditLog().logModify(this.m_login, treePath + "/" + p.getName(), p.getVersion());
                    }
                }
                RTLogger.print(3, (String)result);
            }
            catch (Throwable e) {
                result = e.getMessage();
                RTLogger.print(3, "Error processing incoming file", e);
                isOK = 70;
            }
            finally {
                try {
                    Files.deleteIfExists(temp.toPath());
                }
                catch (IOException e) {
                    RTLogger.print(5, "error delete temp file: " + temp.getName(), e);
                }
                out.writeUTF((String)result);
                out.writeUTF(EMPTY + (char)isOK);
            }
        } else if (objectType.equals("msg")) {
            Object result = "Unexpected Exception";
            int isOK = 84;
            try {
                MsgPolicy p = null;
                in.readFile(temp.getCanonicalPath());
                try {
                    p = policyRepository.getPolicyFactory().initMsgPolicy(temp);
                }
                catch (PolicyParsingException old) {
                    // empty catch block
                }
                if (p == null) {
                    result = "Error during init of uploaded policy: " + objectName;
                    isOK = 70;
                } else {
                    if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, p.getName(), objectType)) {
                        throw new RuntimeException("You are not allowed to change this object!");
                    }
                    filename = p.getName() + ".msg.xml";
                    MsgPolicy old = policyRepository.getMessagePolicy(objectName);
                    if (old == null) {
                        result = "Successfuly created a new Message Policy. " + p.getName();
                        policyRepository.createMessagePolicy(p, (String)filename, treePath);
                        this.deleteOldVersions((String)filename);
                        this.pushPolicyToProxies(objectName, objectType, (String)filename, treePath);
                        ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, treePath + "/" + p.getName());
                        this.m_serverEngine.getEventsRouter().addPendingToALL("GETPOLICIES");
                    } else if (!forceVersion && PolicyFactory.getVersionAsInt(p.getVersion()) <= PolicyFactory.getVersionAsInt(old.getVersion())) {
                        result = "Version of the policy conflicts with actual: " + p.getName();
                        isOK = 70;
                    } else {
                        result = "Message Policy was successfuly updated. " + p.getName();
                        policyRepository.createMessagePolicy(p, (String)filename, treePath);
                        this.pushPolicyToProxies(objectName, objectType, (String)filename, treePath);
                        ServerEngine.getInstance().getAuditLog().logModify(this.m_login, treePath + "/" + p.getName(), p.getVersion());
                    }
                }
                RTLogger.print(3, (String)result);
            }
            catch (Throwable e) {
                result = e.getMessage();
                RTLogger.print(3, "Error processing incoming file", e);
                isOK = 70;
            }
            finally {
                try {
                    Files.deleteIfExists(temp.toPath());
                }
                catch (IOException e) {
                    RTLogger.print(5, "error delete temp file: " + temp.getName(), e);
                }
                out.writeUTF((String)result);
                out.writeUTF(EMPTY + (char)isOK);
            }
        }
    }

    private void pushPolicyToProxies(String objectName, String objectType, String filename, String treePath) {
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc.getScenario() > 1) continue;
            ssc.getServerClient().start("UPDATEPOLICY_FORCE", null, new String[]{objectName, objectType, SPolicyRepository.getPolicyDir() + "/" + filename, treePath});
        }
    }

    private void deleteOldVersions(String filename) {
        String policyFile = filename;
        File dir_policies = new File(SPolicyRepository.getPolicyDir());
        try {
            File[] oldVersions = dir_policies.listFiles((dir, name) -> name.startsWith(policyFile) && !name.equalsIgnoreCase(policyFile));
            if (oldVersions != null) {
                for (File oldVersion : oldVersions) {
                    try {
                        Files.deleteIfExists(oldVersion.toPath());
                    }
                    catch (Throwable e) {
                        RTLogger.print(3, "Can't delete old version file: " + oldVersion.getName());
                    }
                }
            }
        }
        catch (Throwable e1) {
            RTLogger.print(1, "Policy directory is not accessible");
        }
    }

    private void processGetFile(SDataOutputStream out, SDataInputStream in) throws IOException {
        String objectName = in.readUTF();
        String objectType = in.readUTF();
        if (objectType.equals("mon") || objectType.equals("msg")) {
            String filename = this.m_serverEngine.getPolicyRepository().getFilename(objectName);
            if (filename == null) {
                out.writeUTF("NoFileFound_for_" + objectName);
                out.writeLong(0L);
                out.writeUTF("F");
                return;
            }
            File dir_policies = new File(SPolicyRepository.getPolicyDir());
            File file_policy = new File(dir_policies, filename);
            this.sendFile(out, file_policy);
        } else if (objectType.equals("file")) {
            if (objectName.equals("boom_packages.xml")) {
                File xml = this.m_serverEngine.getBinariesRepository().getXmlFile(true);
                this.sendFile(out, xml);
            } else if (objectName.startsWith("srv/")) {
                if (objectName.equalsIgnoreCase(NodeGroupRepository.getInstance().getNodeGroupXMLFile())) {
                    GroupTreeObject tree4User = UserManager.getInstance().getNodeGroups(this.m_login);
                    XMLTree xt = new XMLTree();
                    Document d = xt.getXML(tree4User);
                    String res = XMLFactory.writeXml(d);
                    this.sendStringAsFile(out, res, "nodeGroups.xml");
                } else if (objectName.startsWith("srv/services/")) {
                    String roleID = this.m_userRole.getID();
                    String filePath = objectName.replace("/services/", "/services/" + roleID + "/");
                    File nf = new File(filePath);
                    if (nf.exists() && !this.m_userRole.getName().equalsIgnoreCase("Administrator")) {
                        this.sendFile(out, nf);
                    } else {
                        File file = new File(objectName);
                        this.sendFile(out, file);
                    }
                } else {
                    File file = new File(objectName);
                    this.sendFile(out, file);
                }
            } else {
                String filePath = "./srv/packages" + objectName;
                File ff = new File(filePath);
                if ("/SNMP/snmp/users.asf".equalsIgnoreCase(objectName) && ff.exists() && ff.length() == 0L) {
                    try (FileWriter fw2 = new FileWriter(ff);){
                        fw2.write("[\n]");
                    }
                    catch (Throwable fw2) {
                        // empty catch block
                    }
                }
                out.writeUTF(filePath);
                if (ff.canRead()) {
                    out.writeLong(ff.length());
                    if (ff.length() > 0L) {
                        try (FileInputStream fis = new FileInputStream(filePath);){
                            out.writeFile(fis);
                        }
                    }
                } else {
                    out.writeLong(-1L);
                }
            }
        } else if (objectType.startsWith("mon") || objectType.startsWith("msg")) {
            String filename = SPolicyRepository.getPolicyDir() + File.separator + objectName + "." + objectType;
            File versionOfPolicy = new File(filename);
            this.sendFile(out, versionOfPolicy);
        } else {
            out.writeUTF("NoFileFound_for_" + objectName);
            out.writeLong(0L);
            out.writeUTF("F");
            return;
        }
        out.writeUTF("T");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetBinaryPackage(SDataOutputStream out, SDataInputStream in) throws IOException {
        String binPkgName;
        String strOUT = binPkgName = in.readUTF();
        String result = "T";
        File tmpZip = null;
        try {
            try {
                tmpZip = this.m_serverEngine.getBinariesRepository().zipPackage(binPkgName);
            }
            catch (Throwable e) {
                result = "F";
                strOUT = e.getMessage();
            }
            out.writeUTF(result);
            out.writeUTF(strOUT);
            if (result.equals("T")) {
                try {
                    this.sendFile(out, tmpZip);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (tmpZip != null) {
                try {
                    Files.deleteIfExists(tmpZip.toPath());
                }
                catch (IOException e) {
                    RTLogger.print(5, "error delete temp file: " + tmpZip.getName(), e);
                }
            }
        }
    }

    private void processGetFileSlave(SDataOutputStream out, SDataInputStream in) throws IOException {
        String objectName = in.readUTF();
        String objectType = in.readUTF();
        String slaveServer = in.readUTF();
        SlaveServerCard ssc = this.m_serverEngine.getSlave(slaveServer);
        if (ssc != null) {
            Object res;
            ServerClient sc = ssc.getServerClientStandAlone();
            if (sc.run("GETFILE", null, new String[]{objectName, objectType, ssc.getSlaveDir()}) && (res = sc.getResultObject()) instanceof File) {
                this.sendFile(out, (File)res);
                out.writeUTF("T");
                return;
            }
        } else {
            for (SlaveServerCard sscN : this.m_serverEngine.getSlaves()) {
                Object res;
                if (!sscN.isMasterOfSlave(slaveServer)) continue;
                ServerClient sc = sscN.getServerClientStandAlone();
                if (!sc.run("GETFILE_SLAVE", null, new String[]{objectName, objectType, slaveServer, sscN.getSlaveDir()}) || !((res = sc.getResultObject()) instanceof File)) break;
                this.sendFile(out, (File)res);
                out.writeUTF("T");
                return;
            }
        }
        out.writeUTF("NoFileFound_for_" + objectName);
        out.writeLong(0L);
        out.writeUTF("F");
    }

    private void sendFile(SDataOutputStream out, File file) throws IOException {
        if (file == null) {
            file = new File("FileNotExist");
        }
        out.writeUTF(file.getName());
        if (!file.exists() || !file.canRead()) {
            out.writeLong(-1L);
        } else {
            out.writeLong(file.length());
            try (FileInputStream fis = new FileInputStream(file);){
                out.writeFile(fis);
            }
        }
    }

    private void sendStringAsFile(SDataOutputStream out, String content, String filename) throws IOException {
        if (content == null) {
            filename = "FileNotExist";
        }
        out.writeUTF(filename);
        if (content == null) {
            out.writeLong(-1L);
        } else {
            out.writeLong(content.getBytes().length);
            out.writeBytes(content.getBytes());
        }
    }

    private void processGetVersions(SDataOutputStream out, SDataInputStream in) throws IOException {
        String objectName = in.readUTF();
        String objectType = in.readUTF();
        if (objectType.equals("mon") || objectType.equals("msg")) {
            String firstPart = objectName + "." + objectType + ".xml.";
            File dir_policies = new File(SPolicyRepository.getPolicyDir());
            String[] names = dir_policies.list((dir, name) -> name.startsWith(firstPart));
            if (names != null) {
                out.writeInt(names.length);
                for (String name2 : names) {
                    out.writeUTF(name2.replace(firstPart, EMPTY));
                }
            } else {
                out.writeInt(0);
            }
        }
        out.writeUTF("T");
    }

    private void processGetVersions2(SDataOutputStream out, SDataInputStream in) throws IOException {
        String directory = in.readUTF();
        String prefix = in.readUTF();
        try {
            File dir = new File(directory);
            if (dir.exists() && dir.isDirectory()) {
                String[] names = dir.list((dir1, name) -> name.startsWith(prefix));
                if (names != null) {
                    out.writeInt(names.length);
                    for (String name2 : names) {
                        out.writeUTF(name2.replace(prefix, EMPTY));
                    }
                } else {
                    out.writeInt(0);
                }
                out.writeUTF("T");
            } else {
                out.writeInt(-1);
                out.writeUTF("Directory not found");
            }
        }
        catch (Throwable e) {
            out.writeInt(-2);
            out.writeUTF("Error: " + e.getMessage());
        }
    }

    private void processGetAssigned(SDataOutputStream out, SDataInputStream in) throws IOException {
        boolean refreshPoliciesCMD = false;
        String agentID = in.readUTF();
        AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
        if (ac != null && ac.getRelatedServer() != null) {
            SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
            ServerClient sc = ssc.getServerClientStandAlone();
            sc.run("GETASSIGNED", agentID, (String[])null);
            if (sc.isSuccess()) {
                Object object = sc.getResultObject();
                if (object instanceof List) {
                    List list = (List)object;
                    for (Object e : list) {
                        if (e instanceof String) {
                            String str = (String)e;
                            out.writeUTF(str);
                            continue;
                        }
                        if (!(e instanceof Integer)) continue;
                        Integer i = (Integer)e;
                        out.writeInt(i);
                    }
                } else {
                    out.writeUTF("F");
                }
            }
        } else {
            Assignment expected;
            StringBuilder sb;
            String agentVersion;
            String srv_ver;
            TreeMap<String, String> disabled;
            TreeMap<String, String> msgs;
            if (ac == null) {
                out.writeUTF("F");
                return;
            }
            TreeMap<String, String> mons = null;
            try {
                mons = new TreeMap<String, String>(ac.getDeployedMonitorPolicies());
            }
            catch (Throwable list) {
                // empty catch block
            }
            if (mons == null) {
                Map<Assignment, Object> assignmentsExpected = this.m_serverEngine.getAssignmentRepository().getAssignments(ac.getAgentID());
                mons = new TreeMap();
                msgs = new TreeMap();
                disabled = new TreeMap();
                for (Assignment assignment : assignmentsExpected.keySet()) {
                    if ("mon".equals(assignment.getType())) {
                        mons.put(assignment.getName(), "NA");
                        continue;
                    }
                    if (!"msg".equals(assignment.getType())) continue;
                    msgs.put(assignment.getName(), "NA");
                }
            } else {
                msgs = new TreeMap<String, String>(ac.getDeployedMessagePolicies());
                disabled = new TreeMap<String, String>(ac.getDisabledPolicies());
            }
            out.writeUTF("mon");
            out.writeInt(mons.size());
            boolean isSavePolicyRepository = false;
            ArrayList al = new ArrayList(mons.keySet());
            for (String value : al) {
                String status;
                out.writeUTF(value);
                Policy monitorPolicy = this.m_serverEngine.getPolicyRepository().getMonitorPolicy(value);
                srv_ver = "DELETED";
                if (monitorPolicy != null) {
                    srv_ver = monitorPolicy.getVersion();
                } else {
                    this.m_serverEngine.getPolicyRepository().removeFromKnownMonitors(value, false);
                    isSavePolicyRepository = true;
                    refreshPoliciesCMD = true;
                }
                agentVersion = (String)mons.get(value);
                if (agentVersion == null) {
                    agentVersion = "X";
                }
                sb = new StringBuilder();
                sb.append(agentVersion).append(' ').append('(').append(srv_ver).append(')');
                if (agentVersion.length() > 2 && (expected = this.m_serverEngine.getAssignmentRepository().getAssignment(ac.getAgentID(), value, "mon")) == null) {
                    sb.append(' ').append("(! Unexpected by server !)");
                }
                if ((status = (String)disabled.get(value)) != null) {
                    if (status.length() >= 4 && status.charAt(3) == 'E') {
                        sb.append(' ').append("(!DISABLED!)byVar");
                    } else {
                        sb.append(' ').append("(!DISABLED!)");
                    }
                }
                out.writeUTF(sb.toString());
            }
            al = new ArrayList(msgs.keySet());
            out.writeUTF("msg");
            out.writeInt(msgs.size());
            for (String s : al) {
                out.writeUTF(s);
                MsgPolicy messagePolicy = this.m_serverEngine.getPolicyRepository().getMessagePolicy(s);
                srv_ver = "DELETED";
                if (messagePolicy != null) {
                    srv_ver = messagePolicy.getVersion();
                } else {
                    this.m_serverEngine.getPolicyRepository().removeFromKnownMsgPolicies(s, false);
                    isSavePolicyRepository = true;
                    refreshPoliciesCMD = true;
                }
                agentVersion = (String)msgs.get(s);
                if (agentVersion == null) {
                    agentVersion = "X";
                }
                sb = new StringBuilder();
                sb.append(agentVersion).append(' ').append('(').append(srv_ver).append(')');
                if (agentVersion.length() > 2 && (expected = this.m_serverEngine.getAssignmentRepository().getAssignment(ac.getAgentID(), s, "msg")) == null) {
                    sb.append(' ').append("(! Unexpected by server !)");
                }
                if (disabled.containsKey(s)) {
                    sb.append(' ').append("(!DISABLED!)");
                }
                out.writeUTF(sb.toString());
            }
            Map<Assignment, Object> map = this.m_serverEngine.getAssignmentRepository().getAssignments(agentID);
            map.putAll(this.m_serverEngine.getAssignmentRepository().getAssignmentsByNodeGroups(agentID));
            out.writeUTF("pga");
            out.writeInt(map.size());
            HashMap<String, String> binaryFilesOnAgent = new HashMap<String, String>();
            RemoteCmdClient rca = new RemoteCmdClient('C', ac, "GETHASH=spi", 30);
            boolean isBinaryGetHashResultProcessed = false;
            boolean isBinaryGetHashResultOK = false;
            if (ac.isOnline()) {
                ac.scheduleTask(rca);
            } else {
                rca = null;
            }
            for (Assignment asn : map.keySet()) {
                out.writeUTF(asn.getName());
                out.writeUTF(asn.getType());
                if ("pkg".equals(asn.getType())) {
                    String difference = "(expected by server)";
                    if (!isBinaryGetHashResultProcessed) {
                        try {
                            while (rca != null && !rca.isReady()) {
                                GUIWorker.sleep(100);
                            }
                            if (rca != null && rca.getResult() != null && rca.getResult().resultCode == 0) {
                                isBinaryGetHashResultOK = true;
                                String result = rca.getResult().getOutput();
                                String[] split = result.split("\r?\n");
                                for (int i = 0; i < split.length; i += 2) {
                                    binaryFilesOnAgent.put(split[i], split[i + 1]);
                                }
                            }
                            isBinaryGetHashResultProcessed = true;
                        }
                        catch (Throwable result) {
                            // empty catch block
                        }
                    }
                    if (isBinaryGetHashResultOK) {
                        difference = "(OK)";
                        boolean foundMissed = false;
                        boolean foundUnsync = false;
                        boolean foundSync = false;
                        List<String> files = this.m_serverEngine.getBinariesRepository().getAllFiles(asn.getName());
                        for (String file : files) {
                            try {
                                String serverDigest;
                                File bFile = new File(this.m_serverEngine.getBinariesRepository().getPackageDirectory(), asn.getName() + "/" + file);
                                if (file.endsWith(".asf")) {
                                    serverDigest = AsfUtils.getDigest(bFile, agentID);
                                    if (serverDigest == null) {
                                        serverDigest = FileSyncUtils.getDigest(bFile);
                                    }
                                } else {
                                    serverDigest = FileSyncUtils.getDigest(bFile);
                                }
                                serverDigest = serverDigest.split("\r?\n")[1];
                                if (binaryFilesOnAgent.get(file) == null) {
                                    foundMissed = true;
                                    continue;
                                }
                                if (serverDigest.equals(binaryFilesOnAgent.get(file))) {
                                    foundSync = true;
                                    continue;
                                }
                                foundUnsync = true;
                            }
                            catch (Exception e) {
                                RTLogger.print(5, "Error getting digest for file: " + file);
                            }
                        }
                        if (foundMissed || foundUnsync) {
                            difference = foundSync || foundUnsync ? "(!)" : "(X)";
                        }
                    }
                    out.writeUTF(difference);
                } else if (asn.getAgentID().length() == 32) {
                    out.writeUTF(asn.getAgentID());
                } else {
                    out.writeUTF(EMPTY);
                }
                out.writeInt(asn.getLock());
            }
            if (refreshPoliciesCMD) {
                this.m_serverEngine.getEventsRouter().addPendingToALL("GETPOLICIES");
            }
            if (isSavePolicyRepository) {
                this.m_serverEngine.getPolicyRepository().saveTree();
            }
            out.writeUTF("T");
        }
    }

    private void processGetAllAssignments(SDataOutputStream out) throws IOException {
        Map<String, Assignment> assignments = this.m_serverEngine.getAssignmentRepository().getAllAssignments_AlsoSlaves(this.m_login, null);
        for (Map.Entry<String, Assignment> en : assignments.entrySet()) {
            Assignment asn = en.getValue();
            out.writeBoolean(true);
            asn.send(out);
        }
        out.writeBoolean(false);
        out.writeUTF("T");
    }

    private void processRemoteAction(SDataOutputStream out, SDataInputStream in) throws IOException, InterruptedException {
        String action = in.readUTF();
        try {
            UUID actionID = UUID.fromString(action);
            if (RTLogger.getCurrentLevel() > 6) {
                RTLogger.print(7, "action id is OK : " + String.valueOf(actionID));
            }
            action = in.readUTF();
        }
        catch (IllegalArgumentException actionID) {
            // empty catch block
        }
        action = action.trim();
        String nodes = in.readUTF();
        int seconds = in.readInt();
        try {
            this.m_socket.setSoTimeout(seconds * 1500);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        if (nodes.equalsIgnoreCase("BOOM_SERVER")) {
            Matcher m = m_slaveServerActionPattern.matcher(action);
            if (m.matches()) {
                try {
                    String gr1 = m.group(1);
                    String gr2 = m.group(2);
                    String server = gr2.trim();
                    action = action.replace(gr1, EMPTY);
                    action = action.trim();
                    SlaveServerCard slaveServerCard = this.m_serverEngine.getSlave(server);
                    if (slaveServerCard == null) {
                        out.writeUTF("Slave Server not found: " + server);
                        RTLogger.print(4, "SlaveServerAction server not found: " + server);
                    } else {
                        ServerClient sc = slaveServerCard.getServerClientStandAlone();
                        sc.run("ACTION", null, new String[]{action, nodes, EMPTY + seconds});
                        sb.append("(BS:").append(server).append(")\n");
                        sb.append(sc.getResultObject());
                        out.writeUTF(sb.toString());
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(4, "SlaveServerAction failed. action: " + action, e);
                    out.writeUTF("Error processing slave server action.");
                }
                out.writeUTF("T");
            } else {
                this.processRemoteActionServer(out, action, seconds);
            }
        } else if (nodes.equalsIgnoreCase("*")) {
            Map<String, AgentCard> acards = this.m_serverEngine.getAgentRepository().getAgentCards();
            Iterator<Map.Entry<String, AgentCard>> it = acards.entrySet().iterator();
            ArrayList<IRemoteProcessing> al = new ArrayList<IRemoteProcessing>(acards.size());
            while (it.hasNext()) {
                AgentCard ac = it.next().getValue();
                if (ac.getAgentPort() == 0 || ac.getMode() == 3) continue;
                RemoteCmdClient remoteCmdClient = new RemoteCmdClient('A', ac, action, seconds);
                ac.scheduleTask(remoteCmdClient);
                al.add(remoteCmdClient);
                ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, ac.getAgentID(), action);
            }
            this.waitAnswers(sb, al, seconds);
            out.writeUTF(sb.toString());
            RTLogger.print(3, "action finished");
        } else if (nodes.indexOf(32) != -1) {
            String[] nodesa = nodes.split("\\s+");
            if (SPECIAL_ACTION_DISABLE_AGENTS.equals(action) || SPECIAL_ACTION_ENABLE_AGENTS.equals(action)) {
                if (this.processActionSpecial(action, seconds, nodesa, sb)) {
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                }
                out.writeUTF(sb.toString());
                if (sb.indexOf("Unknown AgentID:") != -1) {
                    out.writeUTF("F");
                } else {
                    out.writeUTF("T");
                }
                return;
            }
            ArrayList<IRemoteProcessing> al = new ArrayList<IRemoteProcessing>(nodes.length());
            HashMap<SlaveServerCard, Object> proxy = new HashMap<SlaveServerCard, Object>();
            for (String s : nodesa) {
                AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(s);
                if (ac != null) {
                    if (ac.getAgentPort() == 0) {
                        sb.append("Virtual Agent (").append(ac.getLabel()).append(") does not support remote actions.").append('\n');
                        continue;
                    }
                    if (ac.getRelatedServer() != null) {
                        SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                        if (ssc == null) continue;
                        Object st = (String)proxy.get(ssc);
                        st = st == null ? s : (String)st + " " + s;
                        proxy.put(ssc, st);
                        continue;
                    }
                    if (ac.getMode() == 3) continue;
                    RemoteCmdClient acl = new RemoteCmdClient('A', ac, action, seconds);
                    ac.scheduleTask(acl);
                    al.add(acl);
                    ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, ac.getAgentID(), action);
                    continue;
                }
                sb.append("Specified Agent not found. ID=").append(s).append('\n');
            }
            for (Map.Entry entry : proxy.entrySet()) {
                SlaveServerCard ssc = (SlaveServerCard)entry.getKey();
                String agents = (String)entry.getValue();
                ServerClient sc = ssc.getServerClientStandAlone();
                ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, agents, action);
                if (!sc.run("ACTION", null, new String[]{action, agents, EMPTY + seconds})) continue;
                sb.append(sc.getResultObject());
            }
            this.waitAnswers(sb, al, seconds);
            out.writeUTF(sb.toString());
            RTLogger.print(3, "action finished");
        } else {
            if (SPECIAL_ACTION_DISABLE_AGENTS.equals(action) || SPECIAL_ACTION_ENABLE_AGENTS.equals(action)) {
                if (this.processActionSpecial(action, seconds, new String[]{nodes}, sb)) {
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                }
                out.writeUTF(sb.toString());
                if (sb.indexOf("Unknown AgentID:") != -1) {
                    out.writeUTF("F");
                } else {
                    out.writeUTF("T");
                }
                return;
            }
            ArrayList<IRemoteProcessing> al = new ArrayList<IRemoteProcessing>();
            AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(nodes);
            if (ac != null && ac.getRelatedServer() != null) {
                ServerClient sc;
                SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                if (ssc != null && (sc = ssc.getServerClientStandAlone()).run("ACTION", null, new String[]{action, nodes, EMPTY + seconds})) {
                    sb.append(sc.getResultObject());
                }
            } else if (ac != null) {
                if (ac.getAgentPort() == 0) {
                    String error = "Virtual Agent does not support remote actions.";
                    out.writeUTF(error);
                    out.writeUTF(error);
                } else if (action.startsWith("BOOM_AGENT_")) {
                    StrUtils strUtils = new StrUtils();
                    String[] params = strUtils.processQuoted(action);
                    if (params.length >= 3) {
                        String string = params[0].replace("BOOM_AGENT_", EMPTY);
                        FileTransfer ft = new FileTransfer(ac, string, strUtils.removeQuotes(params[1]), strUtils.removeQuotes(params[2]), seconds);
                        ac.scheduleTask(ft);
                        al.add(ft);
                        ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, ac.getAgentID(), action);
                    }
                } else {
                    RemoteCmdClient acl = new RemoteCmdClient('A', ac, action, seconds);
                    ac.scheduleTask(acl);
                    al.add(acl);
                    ServerEngine.getInstance().getAuditLog().logRunOnAgent(this.m_login, ac.getAgentID(), action);
                }
                this.waitAnswers(sb, al, seconds);
            } else {
                String error = "Remote action failed. Specified Agent not found. ID=" + nodes;
                out.writeUTF(error);
                out.writeUTF(error);
                RTLogger.print(3, error);
                return;
            }
            out.writeUTF(sb.toString());
            RTLogger.print(3, "action finished");
        }
        out.writeUTF("T");
    }

    private boolean processActionSpecial(String action, int seconds, String[] nodesa, StringBuilder output) {
        boolean atLeastOneCardUpdated = false;
        HashMapArray<SlaveServerCard, String> mapToSlaves = new HashMapArray<SlaveServerCard, String>();
        for (String id : nodesa) {
            if (id == null || id.length() == 0) continue;
            AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(id);
            if (ac == null) {
                output.append("Unknown AgentID: ").append(id).append("\n");
                continue;
            }
            if (ac.getOSName().startsWith("(BS:")) {
                int closingBracketFirst = ac.getOSName().indexOf(")", 6);
                String server = ac.getOSName().substring(6, closingBracketFirst);
                SlaveServerCard ssc = this.m_serverEngine.getSlave(server);
                if (ssc == null || ssc.getScenario() >= 3) continue;
                mapToSlaves.putV(ssc, id);
                continue;
            }
            if (ac.isDisabled() && SPECIAL_ACTION_ENABLE_AGENTS.equals(action)) {
                ac.sendEnableAgent();
                if (this.m_serverEngine.ensureLicense(ac)) {
                    ServerEngine.getInstance().getAuditLog().logModify(this.m_login, "Agent/" + String.valueOf(ac), ac.isDisabled() ? "Disabled" : "Enabled");
                }
            } else if (!ac.isDisabled() && SPECIAL_ACTION_DISABLE_AGENTS.equals(action)) {
                ac.sendDisableAgent();
                this.m_serverEngine.unregisterAgentFromLicensed(ac.getAgentID());
            }
            atLeastOneCardUpdated = true;
            this.m_serverEngine.getAgentRepository().saveAgentCard_notifySingle(ac);
        }
        for (SlaveServerCard slaveServerCard : mapToSlaves.keySet()) {
            StringBuilder sbids = new StringBuilder();
            Iterator its = mapToSlaves.iterator(slaveServerCard);
            while (its.hasNext()) {
                String string = (String)its.next();
                sbids.append(string).append(' ');
            }
            slaveServerCard.getServerClient().start("ACTION", null, new String[]{action, sbids.toString(), EMPTY + seconds});
        }
        output.append("operation scheduled.");
        return atLeastOneCardUpdated;
    }

    public void processRemoteActionServer(SDataOutputStream out, String action, int seconds) throws IOException {
        block324: {
            StringBuilder sb = new StringBuilder();
            if (action.startsWith("GET_LOGLEVEL")) {
                try {
                    out.writeUTF("Current loglevel: " + RTLogger.getCurrentLevel());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_LOGLEVEL")) {
                String[] arr = action.split("\\s+");
                try {
                    int level = Integer.parseInt(arr[1]);
                    this.m_serverEngine.getServerProps().setLogLevel(level);
                    RTLogger.storeConfig();
                    ServerProperties.saveProps();
                    out.writeUTF("Loglevel is now set to " + level);
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("GET_PID")) {
                try {
                    out.writeUTF(BM.PRODUCT_lowercase + " server PID: " + this.m_serverEngine.getPID());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_HB_CTIMEOUT")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int newCtimeout = Integer.parseInt(args[1]);
                    ServerProperties.setHB_Ctimeout(newCtimeout);
                    ServerProperties.saveProps();
                    out.writeUTF("done. HB's connect timeout: " + ServerProperties.getHB_Ctimeout() + " ms");
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_HB_RTIMEOUT")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int newRtimeout = Integer.parseInt(args[1]);
                    ServerProperties.setHB_Rtimeout(newRtimeout);
                    ServerProperties.saveProps();
                    out.writeUTF("done. HB's read timeout: " + ServerProperties.getHB_Rtimeout() + " ms");
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_HB_INTERVAL")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int hbIntervalSeconds = Integer.parseInt(args[1]);
                    ServerProperties.setHB_Interval(hbIntervalSeconds);
                    ServerProperties.saveProps();
                    out.writeUTF("done. HB's Interval: " + ServerProperties.getHB_Interval() + " seconds");
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_INSTRUCTION_SERVER")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    this.m_serverEngine.getServerProps().setInstruction_server(args[1]);
                    ServerProperties.saveProps();
                    out.writeUTF("done. INSTRUCTION_SERVER: " + this.m_serverEngine.getServerProps().getInstruction_server());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_AUTO_BACKUP")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    BkpFile.isEnabled = Boolean.parseBoolean(args[1]);
                    ServerProperties.saveProps();
                    out.writeUTF("done. AUTO_BACKUP: " + BkpFile.isEnabled);
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed " + e.getMessage());
                }
            } else if (action.startsWith("SET_SHORT_LABELS")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    this.m_serverEngine.getServerProps().setUseAgentShortLabels(Boolean.parseBoolean(args[1]));
                    ServerProperties.saveProps();
                    out.writeUTF("done. SHORT_LABELS: " + this.m_serverEngine.getServerProps().isUseAgentShortLabels());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed " + e.getMessage());
                }
            } else if (action.startsWith("SET_MAX_UI_THREADS")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int maxUIThreads = Integer.parseInt(args[1]);
                    this.m_serverEngine.getServerProps().setMaxUIThreads(maxUIThreads);
                    ServerProperties.saveProps();
                    this.m_serverEngine.getGUIServer().setUILimit(maxUIThreads);
                    out.writeUTF("done. Max UI threads: " + this.m_serverEngine.getServerProps().getMaxUIThreads());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_MAX_AGENT_THREADS")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int maxAgThreads = Integer.parseInt(args[1]);
                    this.m_serverEngine.getServerProps().setMaxAgentThreads(maxAgThreads);
                    ServerProperties.saveProps();
                    out.writeUTF("Saved. Max Agent threads: " + this.m_serverEngine.getServerProps().getMaxAgentThreads() + "\nRestart of the boom server is required to apply this change.");
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_MAX_DEPLOY_THREADS")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int maxDpThreads = Integer.parseInt(args[1]);
                    this.m_serverEngine.getServerProps().setMaxDeployThreads(maxDpThreads);
                    ServerProperties.saveProps();
                    out.writeUTF("done. Max Deploy threads: " + this.m_serverEngine.getServerProps().getMaxDeployThreads());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("SET_FW_AGENT_OFFLINE_TIMEOUT")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    int maxDpThreads = Integer.parseInt(args[1]);
                    this.m_serverEngine.getServerProps().setFw_agent_offline_timeout(maxDpThreads);
                    ServerProperties.saveProps();
                    out.writeUTF("done. FW_AGENT_OFFLINE_TIMEOUT: " + this.m_serverEngine.getServerProps().getFw_agent_offline_timeout());
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("GET_HB_CTIMEOUT")) {
                out.writeUTF("HB_CTIMEOUT: " + ServerProperties.getHB_Ctimeout() + " ms");
            } else if (action.startsWith("GET_HB_RTIMEOUT")) {
                out.writeUTF("HB_RTIMEOUT: " + ServerProperties.getHB_Rtimeout() + " ms");
            } else if (action.startsWith("GET_HB_INTERVAL")) {
                out.writeUTF("HB_INTERVAL: " + ServerProperties.getHB_Interval() + " seconds");
            } else if (action.startsWith("GET_FW_AGENT_OFFLINE_TIMEOUT")) {
                out.writeUTF("FW_AGENT_OFFLINE_TIMEOUT: " + this.m_serverEngine.getServerProps().getFw_agent_offline_timeout() + " ms");
            } else if (action.startsWith("GET_INSTRUCTION_SERVER")) {
                out.writeUTF("INSTRUCTION_SERVER: " + this.m_serverEngine.getServerProps().getInstruction_server());
            } else if (action.startsWith("GET_SHORT_LABELS")) {
                out.writeUTF("SHORT_LABELS: " + this.m_serverEngine.getServerProps().isUseAgentShortLabels());
            } else if (action.startsWith("IAction ")) {
                try {
                    Class cl;
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    String className = args[1];
                    try {
                        cl = BMClassLoader.findClass2(className);
                    }
                    catch (Throwable e) {
                        this.m_serverEngine.loadJars();
                        cl = BMClassLoader.findClass2(className);
                    }
                    String[] params = new String[args.length - 2];
                    for (int i = 2; i < args.length; ++i) {
                        params[i - 2] = args[i];
                    }
                    Constructor con = cl.getConstructor(new Class[0]);
                    Object instance = con.newInstance(new Object[0]);
                    String res = "FAILED";
                    if (instance instanceof IAction) {
                        res = ((IAction)instance).run(params, 300);
                    }
                    out.writeUTF(res);
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                    RTLogger.print(4, "Action failed", e);
                }
            } else if (action.startsWith("RESET_MPT")) {
                try {
                    this.m_serverEngine.getEventsRouter().getEventOperations().resetMaxProcessingTime();
                    out.writeUTF("Max processing time = 0");
                }
                catch (Throwable e) {
                    out.writeUTF("Command failed. " + e.getMessage());
                }
            } else if (action.startsWith("AGENTS_STATUS")) {
                StringBuilder outBuff = new StringBuilder();
                Map<String, AgentCard> m1 = this.m_serverEngine.getAgentRepository().getAgentCards();
                for (Map.Entry<String, AgentCard> en : m1.entrySet()) {
                    AgentCard ac = en.getValue();
                    outBuff.append(ac.toString()).append('\n');
                }
                out.writeUTF(outBuff.toString());
            } else if (action.startsWith("ADD_SLAVE")) {
                String res;
                String[] arr = action.split("\\s+");
                if (arr.length != 5 && arr.length != 6 && arr.length != 7) {
                    res = "Failed. Wrong format.\n Expected:\n<hostname> <user> <password> <scenario(int)> <port(int)> <isTLS(boolean)>";
                } else {
                    String hostname = arr[1];
                    String user = arr[2];
                    String pass = arr[3];
                    String scenarioInt = arr[4];
                    int port = BM.CLIENT_PORT;
                    boolean isTls = false;
                    if (arr.length >= 6) {
                        try {
                            port = Integer.parseInt(arr[5]);
                        }
                        catch (NumberFormatException e) {
                            out.writeUTF("Invalid port number: " + arr[5] + " Usage: <hostname> <user> <password> <scenario(int)> <port(int)> <isTLS(boolean)>");
                            return;
                        }
                    }
                    if (arr.length >= 7) {
                        try {
                            isTls = Boolean.parseBoolean(arr[6]);
                        }
                        catch (Exception e) {
                            out.writeUTF("Invalid isTLS flag: " + arr[6] + " Usage: <hostname> <user> <password> <scenario(int)> <port(int)> <isTLS(boolean)>");
                            return;
                        }
                    }
                    try {
                        res = this.m_serverEngine.addNewSlave(hostname, port, user, pass, Integer.parseInt(scenarioInt), isTls);
                    }
                    catch (NumberFormatException e) {
                        res = "Failed. Wrong scenario. Expected [1-3] {1-Proxy, 2-Mirror, 3-Master}";
                    }
                }
                out.writeUTF(res);
            } else if (action.startsWith("REMOVE_SLAVE")) {
                String res;
                String[] arr = action.split("\\s+");
                if (arr.length != 3) {
                    res = "Failed. Wrong format.\n Expected parameters:\n<hostname> <user>";
                } else {
                    String hostname = arr[1];
                    String user = arr[2];
                    res = this.m_serverEngine.removeSlave(hostname, user);
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                }
                out.writeUTF(res);
            } else if (action.startsWith("ADD_LICENSE")) {
                Object res = "Invalid license";
                try {
                    String[] arr = action.split("\\s+");
                    String lic = arr[1];
                    Object[] arr2 = ServerProperties.checkAll(this.m_serverEngine.getServerProps().getHostname(), lic);
                    if ((Integer)arr2[0] > 0 && (Long)arr2[1] > 0L) {
                        if (lic.startsWith("LU")) {
                            ServerProperties.m_lic_users = lic.substring(3);
                            ServerProperties.getMAX_CONNECTED_USERS(this, true);
                            ServerProperties.getMAX_ENABLED_HOSTS(this, true);
                            res = "Added License for " + String.valueOf(arr2[0]) + " users";
                        } else if (lic.startsWith("LH")) {
                            ServerProperties.m_lic_hosts = lic.substring(3);
                            ServerProperties.getMAX_ENABLED_HOSTS(this, true);
                            res = "Added License for " + String.valueOf(arr2[0]) + " monitored hosts";
                        } else if (lic.startsWith("LA")) {
                            ServerProperties.m_lic_agents = lic.substring(3);
                            ServerProperties.getMAX_ENABLED_HOSTS(this, true);
                            res = "Added License for " + String.valueOf(arr2[0]) + " agents";
                        } else if (lic.startsWith("BB")) {
                            ServerProperties.m_lic_b2b = lic.substring(3);
                            int number = ServerProperties.getMAX_B2B(this, true);
                            res = "Added License for " + String.valueOf(arr2[0]) + " " + BM.PRODUCT_lowercase + "2" + BM.PRODUCT_lowercase + " integration module(s)";
                            List<SlaveServerCard> slaves = this.m_serverEngine.getSlaves();
                            if (slaves.size() > 0) {
                                for (SlaveServerCard ssc : slaves) {
                                    if (ssc.isRunning() || this.m_serverEngine.getSlaveServerFactory().getRunningSlaves() >= number) continue;
                                    ssc.start();
                                }
                            }
                        }
                        ServerProperties.saveProps();
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Error adding license");
                    res = "Error processing license";
                }
                out.writeUTF((String)res);
            } else if (action.startsWith("LOOKUP")) {
                String[] arr = action.split("\\s+");
                String host = arr[1];
                try {
                    InetAddress ia = InetAddress.getByName(host);
                    StringBuilder sbres = new StringBuilder();
                    try {
                        sbres.append("Hostname: ").append(ia.getCanonicalHostName()).append('\n');
                    }
                    catch (Throwable e) {
                        sbres.append("Hostname: ").append(ia.getHostName()).append('\n');
                    }
                    sbres.append("IP: ").append(ia.getHostAddress()).append('\n');
                    out.writeUTF(sbres.toString());
                }
                catch (Throwable e) {
                    out.writeUTF("Error host lookup: " + e.getMessage());
                }
            } else if (action.startsWith("RLOOKUP")) {
                String[] arr = action.split("\\s+");
                String host = arr[1];
                try {
                    InetAddress ip = InetAddress.getByName(host);
                    InetAddress ia = InetAddress.getByAddress(ip.getAddress());
                    out.writeUTF(ia.getHostName());
                }
                catch (Throwable e) {
                    out.writeUTF("Error IP lookup: " + e.getMessage());
                }
            } else if (action.startsWith("LDAP")) {
                Object result = "done.";
                try {
                    StrUtils su = new StrUtils();
                    String[] arr = su.processQuoted(action);
                    if ("RELOAD".equalsIgnoreCase(arr[1])) {
                        UserManager.getInstance().reloadLDAP();
                    } else if ("IMPORT".equalsIgnoreCase(arr[1])) {
                        Properties ldap = new Properties();
                        for (int i = 2; i < arr.length; ++i) {
                            String line = arr[i];
                            int eq = line.indexOf(61);
                            if (eq != -1) {
                                String key = line.substring(0, eq);
                                String val = su.removeQuotes(line.substring(eq + 1));
                                ldap.setProperty(key, val);
                                continue;
                            }
                            if (!"LDAP_TEST".equalsIgnoreCase(line)) continue;
                            ldap.setProperty("LDAP_TEST", "TRUE");
                        }
                        result = UserManager.getInstance().importUsersFromLDAP(ldap);
                    } else if ("SAVECONFIG".equalsIgnoreCase(arr[1])) {
                        Properties ldap = new Properties();
                        for (int i = 2; i < arr.length; ++i) {
                            String line = arr[i];
                            int eq = line.indexOf(61);
                            if (eq != -1) {
                                String key = line.substring(0, eq);
                                String val = su.removeQuotes(line.substring(eq + 1));
                                ldap.setProperty(key, val);
                                continue;
                            }
                            if (!"LDAP_TEST".equalsIgnoreCase(line)) continue;
                            ldap.setProperty("LDAP_TEST", "TRUE");
                        }
                        try {
                            UserManager.getInstance().storeLDAPConfig(ldap);
                            result = "\nOK.";
                        }
                        catch (Throwable e) {
                            result = "Error: " + e.getMessage();
                        }
                    } else if ("CHECKUSER".equalsIgnoreCase(arr[1])) {
                        Properties ldap = new Properties();
                        for (int i = 2; i < arr.length; ++i) {
                            String line = arr[i];
                            int eq = line.indexOf(61);
                            if (eq != -1) {
                                String key = line.substring(0, eq);
                                String val = su.removeQuotes(line.substring(eq + 1));
                                ldap.setProperty(key, val);
                                continue;
                            }
                            if (!"LDAP_TEST".equalsIgnoreCase(line)) continue;
                            ldap.setProperty("LDAP_TEST", "TRUE");
                        }
                        result = UserManager.getInstance().testUserLDAP(ldap);
                    } else if ("CHECK".equalsIgnoreCase(arr[1])) {
                        try {
                            if (arr.length != 4) {
                                throw new RuntimeException("wrong syntax.\n Expected: LDAP CHECK <user> <pass>");
                            }
                            result = UserManager.getInstance().testUserLDAP(arr[2], arr[3]);
                        }
                        catch (Throwable e) {
                            result = "Error " + e.getMessage();
                        }
                    } else if ("ADDUSER".equalsIgnoreCase(arr[1]) || "ADD".equalsIgnoreCase(arr[1])) {
                        try {
                            if (arr.length < 3) {
                                throw new RuntimeException("wrong syntax.\n Expected: LDAP ADD <user1> [<user2> <user3>]");
                            }
                            String[] users = new String[arr.length - 2];
                            System.arraycopy(arr, 2, users, 0, users.length);
                            for (int i = 0; i < users.length; ++i) {
                                users[i] = su.removeQuotesStrict(users[i]);
                            }
                            result = UserManager.getInstance().addUserLDAP(users);
                        }
                        catch (Throwable e) {
                            result = "Error " + e.getMessage();
                        }
                    } else if ("DELETECONFIG".equalsIgnoreCase(arr[1])) {
                        try {
                            if (arr.length != 3) {
                                throw new RuntimeException("wrong syntax.\n Expected: LDAP DELETE <ldapURL>");
                            }
                            result = UserManager.getInstance().deleteLDAPConfig(arr[2]);
                        }
                        catch (Throwable e) {
                            result = "Error " + e.getMessage();
                        }
                    } else if ("LIST".equalsIgnoreCase(arr[1])) {
                        try {
                            result = UserManager.getInstance().listLDAPConfigs2();
                        }
                        catch (Throwable e) {
                            result = "Error " + e.getMessage();
                        }
                    } else if ("SAVEORDER".equalsIgnoreCase(arr[1])) {
                        try {
                            if (arr.length < 3) {
                                throw new RuntimeException("wrong syntax.\n Expected: LDAP SAVEORDER <url1> [<url2> <url3>]");
                            }
                            ArrayList<String> orderUrl = new ArrayList<String>(5);
                            for (int i = 2; i < arr.length; ++i) {
                                orderUrl.add(su.removeQuotesStrict(arr[i]));
                            }
                            UserManager.getInstance().saveUrlOrder(orderUrl);
                        }
                        catch (Throwable e) {
                            result = "Error " + e.getMessage();
                        }
                    }
                }
                catch (Throwable e) {
                    result = "Error: " + e.getMessage();
                }
                out.writeUTF((String)result);
            } else if (action.equalsIgnoreCase("RELOAD_HOSTS")) {
                ServerEngine.getInstance().getHostnameResolver().reload();
                out.writeUTF("done.");
            } else if (action.equalsIgnoreCase("REMOVE_FANTOM_AC")) {
                int removed = CheckAgentCardsConflicts.doCheck();
                sb.append("Removed ").append(removed).append(" fantom AgentCards.\ndone.");
                out.writeUTF(sb.toString());
            } else if (action.startsWith("MOVE_INDICATIONS")) {
                String[] arr = action.split("\\s+");
                if (arr.length >= 3) {
                    String oldAgentID = arr[1];
                    String newAgentID = arr[2];
                    int merged = CheckAgentCardsConflicts.doMerge(oldAgentID, newAgentID);
                    sb.append("Moved ").append(merged).append(" indications to a new Agent ID.\ndone.");
                    out.writeUTF(sb.toString());
                } else {
                    out.writeUTF("Wrong parameters. Usage: MOVE_INDICATIONS oldAgentID newAgentID");
                }
            } else if (action.startsWith("GENERATE_STATIC_PACKAGES")) {
                out.writeUTF(NanoHTTPD.generateStaticAgents());
            } else if (action.equals("@DB_ENABLE")) {
                this.m_serverEngine.getDB().enableDB();
                out.writeUTF("done");
            } else if (action.equals("@DB_DISABLE")) {
                this.m_serverEngine.getDB().disableDB();
                out.writeUTF("done");
            } else if (action.equals("@DB_PERF_ENABLE")) {
                this.m_serverEngine.getDB().enableDB_PERF();
                out.writeUTF("done");
            } else if (action.equals("@DB_PERF_DISABLE")) {
                this.m_serverEngine.getDB().disableDB_PERF();
                out.writeUTF("done");
            } else if (action.equals("@DB_ARCH_START")) {
                try {
                    DeleteTask dt = new DeleteTask(ServerEngine.getInstance().getDB());
                    Thread tr = new Thread((Runnable)dt, "ArchiveTask");
                    tr.start();
                }
                catch (Throwable dt) {
                    // empty catch block
                }
                out.writeUTF("done");
            } else if (action.startsWith("@DB_SQL")) {
                String[] arr = action.split("\\s+", 2);
                try {
                    List<Map<String, Object>> result = this.m_serverEngine.getDB().selectDirect(arr[1], seconds);
                    this.printSQLResult(out, result);
                }
                catch (SQLException e) {
                    out.writeUTF("SQLException: " + e.getMessage());
                }
            } else if (action.startsWith("@DB_PERF_SQL")) {
                String[] arr = action.split("\\s+", 2);
                try {
                    List<Map<String, Object>> result = this.m_serverEngine.getDB().selectPerfDirect(arr[1], seconds);
                    this.printSQLResult(out, result);
                }
                catch (SQLException e) {
                    out.writeUTF("SQLException: " + e.getMessage());
                }
            } else if (action.equals("@PERF_DISABLE")) {
                this.m_serverEngine.getServerProps().setIgnorePerfData(true);
                ServerProperties.saveProps();
                out.writeUTF("done");
            } else if (action.equals("@PERF_ENABLE")) {
                this.m_serverEngine.getServerProps().setIgnorePerfData(false);
                ServerProperties.saveProps();
                out.writeUTF("done");
            } else if (action.equals("RELOAD_IGNORE_PERF_CLASSES_FILE")) {
                this.m_serverEngine.getPerfSubmitter().reloadIgnorePerfClasses();
                out.writeUTF("done");
            } else if (action.equals("CLEAN_POLICY_TREE")) {
                this.m_serverEngine.getPolicyRepository().removeUnExistingPolicies();
                LinkedList<String> dummyList = new LinkedList<String>();
                this.m_serverEngine.getPolicyRepository().checkLostAndFound(dummyList);
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETPOLICIES");
                out.writeUTF("done");
            } else if (action.equals("@@INIT_POLICY_TREE")) {
                this.m_serverEngine.getPolicyRepository().init();
            } else if (action.startsWith("GETSPIHASH")) {
                String[] arr = action.split("\\s+", 2);
                if (arr.length == 2) {
                    String agentID = arr[1];
                    AgentCard ac = this.m_serverEngine.getAgentRepository().getLocalAgentCard(agentID, false);
                    if (ac != null) {
                        if (ac.getMode() == 1 || ac.getMode() == 8) {
                            try {
                                RemoteCmdClient rcc = ac.processSyncStatus();
                                long maxTime = System.currentTimeMillis() + (long)seconds * 1000L;
                                while (!rcc.isReady && System.currentTimeMillis() < maxTime) {
                                    GUIWorker.sleep(500);
                                }
                                if (ac.m_lastSyncReport == null) {
                                    out.writeUTF("Timeout");
                                    break block324;
                                }
                                out.writeUTF(ac.m_lastSyncReport);
                            }
                            catch (Throwable e) {
                                out.writeUTF(e.getMessage());
                            }
                        } else {
                            out.writeUTF("Agent is offline.");
                        }
                    } else {
                        out.writeUTF("Agent not found.");
                    }
                } else {
                    out.writeUTF("Wrong parameters. Usage: GETSPIHASH agentID");
                }
            } else if (action.startsWith("@@SYNC_AGTS")) {
                this.processSyncAgentServerAction(this.m_login, action, seconds, sb);
                out.writeUTF(sb.toString());
            } else if (action.startsWith("AGENT_OUTAGE")) {
                StrUtils su = new StrUtils();
                String[] arr = su.processQuoted(action);
                if (arr.length < 3) {
                    sb.append("Wrong parameters. Usage: AGENT_OUTAGE ON|OFF agentID1 [agentID2] ...");
                } else {
                    String command = su.removeQuotes(arr[1]);
                    if (command.equalsIgnoreCase("ON") || command.equalsIgnoreCase("OFF")) {
                        for (int i = 2; i < arr.length; ++i) {
                            String agentID = su.removeQuotes(arr[i]);
                            AgentCard ac = this.m_serverEngine.getAgentRepository().getLocalAgentCard(agentID, true);
                            if (ac == null) continue;
                            if (command.equalsIgnoreCase("ON")) {
                                ac.setSingleFlagON(16);
                            } else {
                                ac.setSingleFlagOFF(16);
                            }
                            this.m_serverEngine.getAgentRepository().saveAgentCard_notifySingle(ac);
                        }
                        for (SlaveServerCard slaveServerCard : this.m_serverEngine.getSlaves()) {
                            if (slaveServerCard.getScenario() >= 3) continue;
                            slaveServerCard.getServerClient().start("ACTION", null, new String[]{action, "BOOM_SERVER", EMPTY + seconds});
                        }
                        this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                    } else {
                        sb.append("Wrong parameters. Usage: AGENT_OUTAGE ON|OFF agentID1 [agentID2] ...");
                        out.writeUTF(sb.toString());
                    }
                }
                out.writeUTF(sb.toString());
            } else if (action.equals("GET_ALL_IP")) {
                for (String ip : this.m_serverEngine.getServerProps().getAllServerIPs()) {
                    sb.append(ip).append('\n');
                }
                out.writeUTF(sb.toString());
            } else if (action.equals("GET_KNOWN_HOSTS")) {
                TreeMap<String, Object> hostCache = new TreeMap<String, Object>(this.m_serverEngine.getEventsRouter().getEventOperations().getMonitoredHosts());
                for (Map.Entry stringObjectEntry : hostCache.entrySet()) {
                    sb.append((String)stringObjectEntry.getKey()).append('\n');
                }
                out.writeUTF(sb.toString());
            } else if (action.equals("RELOAD_AGENT_EXT_FROM_DB")) {
                this.m_serverEngine.getAgentRepository().reloadAgentCardCM();
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_AGENTS_CM");
                out.writeUTF("done.");
            } else if (action.startsWith("SET_AGENT_STATUS")) {
                StrUtils su = new StrUtils();
                String[] arr = su.processQuoted(action);
                try {
                    String agentID = su.removeQuotesStrict(arr[1]);
                    String state = su.removeQuotesStrict(arr[2]);
                    AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                    if (ac != null) {
                        String status = "online";
                        if ("online".equalsIgnoreCase(state) || "normal".equalsIgnoreCase(state)) {
                            ac.setMode(1);
                        } else {
                            ac.setMode(3);
                            status = "offline";
                        }
                        out.writeUTF("Agent new status is: " + status);
                        break block324;
                    }
                    out.writeUTF("Agent not found. ID=" + agentID);
                }
                catch (Throwable e) {
                    out.writeUTF("Action has invalid syntax: " + action);
                }
            } else if (action.startsWith("SET_AGENT_ATTRIBUTE")) {
                StrUtils su = new StrUtils();
                String[] arr = su.processQuoted(action);
                try {
                    String agentID = su.removeQuotesStrict(arr[1]);
                    String attrName = su.removeQuotesStrict(arr[2]);
                    String attrValue = su.removeQuotesStrict(arr[3]);
                    AgentCardCM ac = this.m_serverEngine.getAgentRepository().getAgentCardCM(agentID);
                    if (ac != null) {
                        ac.add(attrName, attrValue);
                        this.m_serverEngine.getAgentRepository().saveAgentCardCM(ac);
                        out.writeUTF("OK setting Agent attribute: " + attrName + "=" + attrValue);
                        ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", agentID, "Attribute: " + attrName + "=" + attrValue);
                        break block324;
                    }
                    out.writeUTF("Agent not found. ID=" + agentID);
                }
                catch (Throwable e) {
                    out.writeUTF("Action has invalid syntax: " + action);
                }
            } else if (action.startsWith("@@OSCHG")) {
                for (AgentCard ac : this.m_serverEngine.getAgentRepository().getAgentCards().values()) {
                    if (ac.getAgentPort() == 0 || ac.getRelatedServer() != null) continue;
                    String OSNAme = ac.getOSName();
                    if (OSNAme.contains("_")) {
                        ac.setOSName(OSNAme.substring(0, OSNAme.lastIndexOf(95)));
                    } else {
                        ac.setOSName(OSNAme + "_TEST");
                    }
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GETAGENTCARDS", ac.getID(), null));
                    break;
                }
                out.writeUTF("OK ;)");
            } else if (action.startsWith("SIGN_AGENT_CERTIFICATE_REQUEST")) {
                StringBuilder stringBuilder = new StringBuilder();
                StrUtils su = new StrUtils();
                String[] args = su.processQuoted(action);
                if (args.length == 3) {
                    String agentId = args[1];
                    String inputFile = args[2];
                    AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentId);
                    if ("ca".equals(agentId) || ac == null) {
                        stringBuilder.append("Error: unknown agent id ").append(agentId);
                    } else {
                        try {
                            byte[] csr = Files.readAllBytes(Paths.get(inputFile, new String[0]));
                            CertificateStateIndicationHelper.sendSendingAgentCSRtoPKI(ac);
                            ServerEngine.getInstance().getPki().processCSR(agentId, csr);
                        }
                        catch (Exception e) {
                            stringBuilder.append("Error: could not sign certificate request ").append(e.getMessage());
                        }
                    }
                } else {
                    stringBuilder.append("Error: please specify agent id and input file");
                }
                out.writeUTF(stringBuilder.toString());
            } else if (action.startsWith("DELETE_AGENT_CERTIFICATE")) {
                String[] args = action.split("\\s+");
                if (args.length == 2) {
                    String agentId = args[1];
                    if ("ca".equals(agentId) || this.m_serverEngine.getAgentRepository().getAgentCardByID(agentId) == null) {
                        out.writeUTF("Error: unknown agent id " + agentId);
                    } else {
                        try {
                            this.m_serverEngine.getCertificateManager().getTsClient().deleteCertificate(agentId);
                            this.m_serverEngine.getCertificateManager().getTsClient().saveKeyStore();
                            out.writeUTF("Certificate for agent id " + agentId + " has been deleted");
                        }
                        catch (KeyStoreException e) {
                            out.writeUTF("Error: could not delete certificate for agent id " + agentId + " " + e.getMessage());
                        }
                        catch (NoSuchAlgorithmException | CertificateException e) {
                            out.writeUTF("Error: could not store trust store");
                        }
                    }
                } else {
                    out.writeUTF("Error: please specify agent id");
                }
            } else if (action.equals("RELOAD_TRUST_STORE")) {
                try {
                    this.m_serverEngine.getCertificateManager().getTsClient().loadKeyStore();
                    out.writeUTF("Trust store reloaded");
                }
                catch (Exception e) {
                    out.writeUTF("Error: could not reload trust store");
                }
            } else if (action.startsWith("LIST_TRUST_STORE")) {
                try {
                    List<BasicCertificateInfo> certificatesInfo = this.m_serverEngine.getCertificateManager().getTsClient().getCertificatesInfo();
                    String result = certificatesInfo.stream().map(info -> CertificateSerializationHelper.certificateInfoToString(info) + "\n------------------------------\n").collect(Collectors.joining("\n"));
                    out.writeUTF(result);
                }
                catch (Exception e) {
                    out.writeUTF("Error: could not reload trust store");
                }
            } else if (action.startsWith("LIST_KEY_STORE")) {
                try {
                    List<BasicCertificateInfo> certificatesInfo = this.m_serverEngine.getCertificateManager().getKsClient().getCertificatesInfo();
                    String result = certificatesInfo.stream().map(info -> CertificateSerializationHelper.certificateInfoToString(info) + "\n------------------------------\n").collect(Collectors.joining("\n"));
                    out.writeUTF(result);
                }
                catch (Exception e) {
                    out.writeUTF("Error: could not reload trust store");
                }
            } else if (action.startsWith("UPDATE_SERVER_CERT")) {
                try {
                    out.writeUTF(this.updateServerCertificate());
                }
                catch (Exception e) {
                    out.writeUTF("Error: could not create new keystore. " + e.getMessage());
                }
            } else if (action.startsWith("SWITCH_SERVER_KEY_STORES")) {
                try {
                    out.writeUTF(this.switchServerKeyStores());
                }
                catch (Exception e) {
                    out.writeUTF("Error: could not switch keystores. " + e.getMessage());
                }
            } else if (action.startsWith("ENABLE_AGENT_TLS")) {
                String[] args = action.split("\\s+");
                if (args.length != 3) {
                    out.writeUTF("Wrong parameters count. Expected two, got " + (args.length - 1));
                    return;
                }
                String agentId = args[1];
                String portStr = args[2];
                try {
                    Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    out.writeUTF("Could not parse port: " + portStr);
                    return;
                }
                AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentId);
                if (ac == null) {
                    out.writeUTF("Could not find agent with ID : " + agentId);
                    return;
                }
                try {
                    Certificate cert = ServerEngine.getInstance().getCertificateManager().getKsClient().getKeyStore().getCertificate("ca");
                    byte[] bytes = CertificateSerializationHelper.serializeCertificate(cert);
                    RemoteCmdClient acl = new RemoteCmdClient('A', ac, "BOOM_AGENT ENABLE_AGENT_TLS \"" + new String(bytes) + "\" " + portStr, seconds);
                    ac.scheduleTask(acl);
                }
                catch (KeyStoreException | CertificateEncodingException e) {
                    out.writeUTF("Could not get CA certificate " + e.getMessage());
                    return;
                }
                out.writeUTF("Task scheduled");
            } else if (action.startsWith("DISABLE_AGENT_TLS")) {
                String[] args = action.split("\\s+");
                if (args.length != 3) {
                    out.writeUTF("Wrong parameters count. Expected two, got " + (args.length - 1));
                    return;
                }
                String agentId = args[1];
                String communicationType = args[2];
                AgentCard ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentId);
                if (ac == null) {
                    out.writeUTF("Could not find agent with ID : " + agentId);
                    return;
                }
                RemoteCmdClient acl = new RemoteCmdClient('A', ac, "BOOM_AGENT DISABLE_AGENT_TLS " + communicationType, seconds);
                ac.scheduleTask(acl);
                out.writeUTF("Task scheduled");
            } else if (action.startsWith("REMOVE_AGENT_CSR")) {
                try {
                    String[] args = action.split("\\s+");
                    if (args.length != 2) {
                        out.writeUTF("Wrong parameters count. Expected one, got " + (args.length - 1));
                        return;
                    }
                    String agentId = args[1];
                    CSRStorage.CSRPayload payload = this.m_serverEngine.getAgentCertificates().getCsrStorage().removeCSRRequest(agentId);
                    this.m_serverEngine.getAgentCertificates().getCsrStorage().removeCSRResponse(agentId);
                    out.writeUTF(payload != null ? "deleted" : "not found");
                }
                catch (Exception e) {
                    RTLogger.print(2, "error remove agent CSR", e);
                    out.writeUTF(e.getMessage());
                }
            } else if (action.equals("JETTY_KEYSTORE_RELOAD")) {
                try {
                    new KeyStoreScanner((SslContextFactory)JettyMain.sslContextFactory).reload();
                    out.writeUTF("OK");
                }
                catch (Exception e) {
                    RTLogger.print(1, "FileScanner failed to reload certificate for Jetty", e);
                    out.writeUTF(e.getMessage());
                }
            } else if (action.startsWith("USE_LAST_DUPLICATE_TEXT")) {
                try {
                    StrUtils su = new StrUtils();
                    String[] args = su.processQuoted(action);
                    this.m_serverEngine.getServerProps().setUseLastDuplicateText(Boolean.parseBoolean(args[1]));
                    ServerProperties.saveProps();
                    out.writeUTF("OK");
                }
                catch (IOException e) {
                    RTLogger.print(1, "Error parsing input: " + action, e);
                    out.writeUTF("Error parsing input: " + action);
                }
            } else if (action.startsWith("RUN_ONCE_SERVER_JOB")) {
                try {
                    String[] args = new StrUtils().processQuoted(action);
                    if (args.length == 2) {
                        ServerEngine.getInstance().getServerJobManager().runJobOnce(new StrUtils().removeQuotesStrict(args[1]));
                        out.writeUTF("OK");
                        break block324;
                    }
                    out.writeUTF("incorrect syntax. RUN_ONCE_SERVER_JOB \"Server job name\"");
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error: RunOnce ", e);
                    out.writeUTF("Error: RunOnce " + e.getMessage());
                }
            } else {
                int i;
                ExecResult res = ExecUtils.exec2(action, new File("."), seconds);
                StringBuilder outBuff = new StringBuilder();
                outBuff.append("#RESULT CODE: ").append(res.resultCode).append('\n');
                if (res.m_errorMessages.size() > 0) {
                    outBuff.append("#STDERR: ").append('\n');
                    for (i = 0; i < res.m_errorMessages.size(); ++i) {
                        outBuff.append(res.m_errorMessages.get(i)).append('\n');
                    }
                }
                if (res.m_outMessages.size() > 0) {
                    outBuff.append("#STDOUT: ").append('\n');
                    for (i = 0; i < res.m_outMessages.size(); ++i) {
                        outBuff.append(res.m_outMessages.get(i)).append('\n');
                    }
                }
                RTLogger.print(3, "Server action finished." + String.valueOf(res));
                out.writeUTF(outBuff.toString());
            }
        }
        ServerEngine.getInstance().getAuditLog().logRunOnServer(this.m_login, this.m_serverEngine.getServerProps().getServerId(), action);
    }

    private String switchServerKeyStores() {
        Object result;
        try {
            this.m_serverEngine.getCertificateManager().switchKeyStores();
            result = "Successfully switched the key stores.";
        }
        catch (KeysStoreSwitchException e) {
            result = "Error: could not switch key stores. " + e.getMessage();
        }
        catch (KeyStoreRollbackException e) {
            result = "Error: could not switch key stores and could not restore the old one from the backup! " + e.getMessage();
        }
        return result;
    }

    private String updateServerCertificate() throws Exception {
        ServerProperties serverProps = this.m_serverEngine.getServerProps();
        Path newKsFile = this.m_serverEngine.getCertificateManager().getRenewalKeyStore().getKeyStorePath();
        CertificateManager tmpCertManager = new CertificateManager();
        Optional<ByteArray> optionalCSR = tmpCertManager.initServerKeyStore(serverProps.getHostname(), serverProps.getClusterName(), serverProps.getClusterIP(), newKsFile.toAbsolutePath().toString(), serverProps.getKsPassEncoded(), serverProps.getAllServerIPs(), serverProps.getAllHostnames());
        if (optionalCSR.isPresent()) {
            CertificateStateIndicationHelper.sendSendingServerCSRtoPKI();
            this.m_serverEngine.getPki().processCSR("server", optionalCSR.get().getBytes());
        }
        return "Successfully created " + newKsFile.getFileName().toString();
    }

    private void processSyncAgentServerAction(String user, String action, int seconds, StringBuilder sb) {
        try {
            String agentIdsOrNodeGroupsOIDs = action.replace("@@SYNC_AGTS", EMPTY).trim();
            StrUtils su = new StrUtils();
            LinkedList<String> forSlaves = new LinkedList<String>();
            String[] arr = su.processQuoted(agentIdsOrNodeGroupsOIDs);
            if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(arr))) {
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            HashMap<String, String> processed = new HashMap<String, String>(arr.length);
            if (arr.length > 0) {
                for (String s : arr) {
                    String agentID = su.removeQuotes(s);
                    if (processed.containsKey(agentID)) continue;
                    processed.put(agentID, agentID);
                    if (agentID.length() == 32) {
                        String nodeGroupPath = NodeGroupRepository.getInstance().getNodeGroupPath("NodeGroup: " + agentID);
                        if (nodeGroupPath != null) {
                            ServerEngine.getInstance().getAuditLog().logTriggerSync(user, nodeGroupPath);
                        } else {
                            ServerEngine.getInstance().getAuditLog().logTriggerSync(user, "NodeGroup oid: " + agentID);
                        }
                        List ids = NodeGroupRepository.getInstance().getAssociatedAgentIDsByNGOID(agentID);
                        for (String id : ids) {
                            AgentCard ac = this.m_serverEngine.getAgentRepository().getLocalAgentCard(id, false);
                            if (ac == null) continue;
                            processed.put(id, id);
                            if (ServerActionsManager.getInstance().schedule(new AutoSyncAction(ac))) {
                                sb.append(ac.getAgentHost()).append(" ").append(ac.getAgentID()).append('\n');
                                continue;
                            }
                            sb.append(ac.getAgentHost()).append(" rejected. Already running.").append('\n');
                            SMessage.sendMessage(ac, "Rejected Synchronization Action. Already running for Agent: " + ac.getLabel(), 2, "Job", "Sync", ac.getAgentHost(), 0);
                        }
                        forSlaves.add(agentID);
                        continue;
                    }
                    if (agentID.length() != 36) continue;
                    AgentCard ac1 = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                    if (ac1 != null) {
                        ServerEngine.getInstance().getAuditLog().logTriggerSync(user, ac1.toString());
                    } else {
                        ServerEngine.getInstance().getAuditLog().logTriggerSync(user, "Agent id: " + agentID);
                    }
                    AgentCard ac = this.m_serverEngine.getAgentRepository().getLocalAgentCard(agentID, false);
                    if (ac != null) {
                        if (ServerActionsManager.getInstance().schedule(new AutoSyncAction(ac))) {
                            sb.append(ac.getAgentHost()).append(" ").append(ac.getAgentID()).append('\n');
                            continue;
                        }
                        sb.append(ac.getAgentHost()).append(" rejected. Already running.").append('\n');
                        SMessage.sendMessage(ac, "Rejected Synchronization Action. Already running for Agent: " + ac.getLabel(), 2, "Job", "Sync", ac.getAgentHost(), 0);
                        continue;
                    }
                    forSlaves.add(agentID);
                }
            }
            if (forSlaves.size() > 0) {
                StringBuilder actionSB = new StringBuilder("@@SYNC_AGTS");
                for (String agid : forSlaves) {
                    actionSB.append(' ').append(agid);
                }
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaveServerFactory().getSlaves()) {
                    ServerClient sc = ssc.getServerClientStandAlone();
                    sc.start("ACTION", null, new String[]{actionSB.toString(), "BOOM_SERVER", EMPTY + seconds});
                }
            }
        }
        catch (Throwable e) {
            sb.append("Error: ").append(e.getMessage());
        }
    }

    private void printSQLResult(SDataOutputStream out, List<Map<String, Object>> result) throws IOException {
        if (result == null || result.size() == 0) {
            out.writeUTF("0 records found");
        } else {
            Map<String, Object> first = result.get(0);
            Set<String> keys = first.keySet();
            StringBuilder sbr = new StringBuilder();
            for (String fielName : keys) {
                sbr.append(fielName).append('\t');
            }
            sbr.append("\r\n");
            Iterator<Map<String, Object>> it = result.iterator();
            int maxStringLength = 0x5000000;
            while (it.hasNext() && sbr.length() < maxStringLength) {
                Map<String, Object> map = it.next();
                for (String fielName : keys) {
                    sbr.append(map.get(fielName)).append('\t');
                }
                sbr.append("\r\n");
            }
            if (sbr.length() > maxStringLength) {
                out.writeUTF(sbr.substring(0, maxStringLength));
            } else {
                out.writeUTF(sbr.toString());
            }
        }
    }

    private void processGetUsers(SDataOutputStream out) throws IOException {
        List<User> values = UserManager.getInstance().getUsers();
        Iterator<User> it = values.iterator();
        out.writeInt(values.size());
        while (it.hasNext()) {
            User ac = it.next();
            ac.send(out);
        }
        out.writeUTF("T");
    }

    private void processGetUserRoles(SDataOutputStream out) throws IOException {
        List<UserRole> values = UserManager.getInstance().getRoles(this.m_login);
        Iterator<UserRole> it = values.iterator();
        out.writeInt(values.size());
        while (it.hasNext()) {
            UserRole ac = it.next();
            ac.send(out);
        }
        out.writeUTF("T");
    }

    private void processGetUItems(SDataOutputStream out) throws IOException {
        List<UItem> values = UserManager.getInstance().getUItems();
        Iterator<UItem> it = values.iterator();
        out.writeInt(values.size());
        while (it.hasNext()) {
            UItem ui = it.next();
            ui.send(out);
        }
        out.writeUTF("T");
    }

    private void processGetUserRole(SDataOutputStream out, SDataInputStream in) throws IOException {
        String userName = in.readUTF();
        UserRole role = UserManager.getInstance().getRoleForUser(userName);
        if (role == null) {
            out.writeUTF("F");
        } else {
            RTLogger.print(5, "User=" + userName + " Role=" + role.getName());
            out.writeUTF("T");
            role.send(out);
        }
        out.writeUTF("T");
    }

    private void waitAnswers(StringBuilder sb, List<IRemoteProcessing> al, int seconds) throws InterruptedException {
        IRemoteProcessing cl;
        Iterator<IRemoteProcessing> tasks = al.iterator();
        long endTime = System.currentTimeMillis() + (long)seconds * 1000L + 10000L;
        while (tasks.hasNext() && System.currentTimeMillis() < endTime) {
            GUIWorker.sleep(500);
            while (tasks.hasNext()) {
                cl = tasks.next();
                if (!cl.isReady()) continue;
                if (cl.getResult().resultCode == 0) {
                    sb.append("Result = Success\n");
                } else if (cl.getResult().resultCode == Integer.MAX_VALUE) {
                    sb.append("Result = TIMEOUT reached\n");
                } else {
                    sb.append("Result = FAILED\n");
                }
                String agentHost = cl.getAgentCard().getAgentHost();
                sb.append("=== Start of Output from ").append(agentHost).append(" (").append(this.m_sdf.format(new Date())).append(") ===").append('\n');
                sb.append(cl.getResult().getOutput());
                sb.append("\n=== End of Output from ").append(agentHost).append(" ===").append('\n');
                RTLogger.print(3, "Agent responded " + agentHost);
                tasks.remove();
            }
            tasks = al.iterator();
        }
        while (tasks.hasNext()) {
            cl = tasks.next();
            sb.append("Result = FAILED\nTimeout is reached for ").append(cl.getAgentCard().getAgentHost());
            tasks.remove();
        }
    }

    private void processingJob(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "T";
        String jobName = in.readUTF();
        int parameters = in.readInt();
        if (this.m_COMMAND_OPTIONS.containsKey("BOOM_SERVER")) {
            String server = this.m_COMMAND_OPTIONS.get("BOOM_SERVER");
            String[] arr = new String[parameters];
            for (int i = 0; i < parameters; ++i) {
                arr[i] = in.readUTF();
            }
            SlaveServerCard ssc = this.m_serverEngine.getSlaveServerFactory().getSlave(server);
            if (ssc != null) {
                ServerClient sc = ssc.getServerClientStandAlone();
                sc.run("JOB", jobName, arr);
                if (sc.isSuccess()) {
                    out.writeUTF("T");
                } else {
                    out.writeUTF(sc.getResultObject() == null ? "Unknown error processing command on slave: " + String.valueOf(ssc) : String.valueOf(sc.getResultObject()));
                }
            } else {
                out.writeUTF("Slave server not found: " + server);
            }
            return;
        }
        switch (jobName) {
            case "APPROVE_AGENT": {
                this.processApproveAgents(in, parameters);
                break;
            }
            case "DELETE_AGENT": {
                result = this.processDeleteAgents(in, parameters);
                break;
            }
            case "JOB_CREATE_AGENT": {
                result = this.processCreateAgent(in, parameters);
                break;
            }
            case "AGENT_REDEPLOY": {
                result = this.processUpgradeAgents(in, parameters);
                break;
            }
            case "AGENT_RESTART": {
                result = this.processRestartAgents(in, parameters);
            }
        }
        out.writeUTF(result);
    }

    private String processRestartAgents(SDataInputStream in, int parameters) throws IOException {
        String result = "T";
        Map<String, AgentCard> acards = this.m_serverEngine.getAgentRepository().getAgentCards();
        String[] agentIDs = new String[parameters];
        for (int i = 0; i < agentIDs.length; ++i) {
            agentIDs[i] = in.readUTF();
        }
        if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(agentIDs))) {
            result = INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED;
        } else {
            for (String agentID : agentIDs) {
                AgentCard ac = acards.get(agentID);
                if (ac == null || ac.getAgentPort() == 0) continue;
                if (ac.getRelatedServer() != null) {
                    SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ssc.getServerClient().start("JOB", "AGENT_RESTART", new String[]{ac.getAgentID()});
                    continue;
                }
                RemoteCmdClient rcc = new RemoteCmdClient('Y', ac, null, 180);
                ac.scheduleTask(rcc);
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "RESTART", ac.getAgentID(), "start action");
            }
        }
        return result;
    }

    private String processUpgradeAgents(SDataInputStream in, int parameters) throws IOException {
        String result = "T";
        Map<String, AgentCard> acards = this.m_serverEngine.getAgentRepository().getAgentCards();
        String[] agentIDs = new String[parameters];
        for (int i = 0; i < agentIDs.length; ++i) {
            agentIDs[i] = in.readUTF();
        }
        if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(agentIDs))) {
            result = INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED;
        } else {
            for (String agentID : agentIDs) {
                AgentCard ac = acards.get(agentID);
                if (ac == null || ac.getAgentPort() == 0) continue;
                if (ac.getRelatedServer() != null) {
                    SlaveServerCard ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ssc.getServerClient().start("JOB", "AGENT_REDEPLOY", new String[]{ac.getAgentID()});
                    continue;
                }
                DeployClient dc = new DeployClient(ac);
                DeploymentManager.getInstance().schedule(dc);
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "UPGRADE", ac.getAgentID(), "start action");
                SMessage.sendMessage(ac, "Agent re-deploy task started", 1, "BOOM Server", "BOOM_SERVER", ac.getAgentHost(), 0);
            }
        }
        return result;
    }

    private String processDeleteAgents(SDataInputStream in, int parameters) throws IOException {
        Object result = "T";
        ArrayList<String> array = new ArrayList<String>(parameters);
        for (int i = 0; i < parameters; ++i) {
            String agentID = in.readUTF();
            array.add(agentID);
        }
        if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, array)) {
            result = INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED;
        } else {
            Object error = EMPTY;
            ArrayList<String> notFoundIDs = new ArrayList<String>();
            for (String agentID : array) {
                if (this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID) != null) continue;
                error = ((String)error).isEmpty() ? "Agent(s) not found: " + agentID : ", " + agentID;
                notFoundIDs.add(agentID);
            }
            array.removeAll(notFoundIDs);
            this.m_serverEngine.getAgentRepository().deleteAgents(array);
            for (String agentID : array) {
                ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, agentID);
            }
            if (!((String)error).isEmpty()) {
                result = error;
            }
        }
        return result;
    }

    private String processCreateAgent(SDataInputStream in, int parameters) throws IOException {
        String result = "T";
        String[] array = new String[parameters];
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            array[i] = in.readUTF();
            if (array[i].contains("{")) {
                CreateAgentRcpUi uiReq = new GsonBuilder().create().fromJson(array[i], CreateAgentRcpUi.class);
                try {
                    try {
                        if (uiReq.ip == null && uiReq.host == null) {
                            throw new UnknownHostException("No host or IP specified: " + String.valueOf(uiReq));
                        }
                        if (uiReq.ip != null && uiReq.host == null) {
                            ia = InetAddress.getByName(uiReq.ip);
                            uiReq.host = ia.getHostName();
                        } else if (uiReq.ip == null && uiReq.host != null) {
                            ia = InetAddress.getByName(uiReq.host);
                            uiReq.ip = ia.getHostAddress();
                        }
                    }
                    catch (Exception e) {
                        RTLogger.print(1, "Error resolving host/ip : " + uiReq.ip, e);
                    }
                    AgentCard ac = new AgentCard(uiReq.id, uiReq.host, uiReq.ip, uiReq.label, "User created");
                    ac.setAgentPort(uiReq.port);
                    ac.setOSName("Connecting...");
                    if (uiReq.approved) {
                        ac.setApproved();
                    } else {
                        ac.setUnApproved();
                    }
                    ac.setRelatedServer(uiReq.slaveServer);
                    if (uiReq.firewalled) {
                        ac.setModeSilently(7);
                    } else {
                        ac.setMode(0);
                    }
                    if (uiReq.isTLS) {
                        ac.setSingleFlagON(64);
                    } else {
                        ac.setSingleFlagOFF(64);
                    }
                    this.m_serverEngine.getAgentRepository().createAgentCard(ac, this.m_login);
                }
                catch (Exception e1) {
                    errors.append(e1.getMessage()).append('\n');
                    RTLogger.print(2, "Failed creating AgentCard: " + String.valueOf(uiReq), e1);
                }
                continue;
            }
            AgentCard ac = new AgentCard(array[i]);
            try {
                this.m_serverEngine.getAgentRepository().createAgentCard(ac, this.m_login);
                ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, "AgentID=" + ac.getAgentID());
                continue;
            }
            catch (Exception e) {
                errors.append(e.getMessage()).append('\n');
                RTLogger.print(2, "Skip creation of the conflicting AgentCard.", e);
            }
        }
        if (errors.length() > 0) {
            result = errors.toString();
        }
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
        return result;
    }

    private void processApproveAgents(SDataInputStream in, int parameters) throws IOException {
        String[] array = new String[parameters];
        for (int i = 0; i < array.length; ++i) {
            array[i] = in.readUTF();
        }
        Thread runBkgr = new Thread(() -> {
            int count = 0;
            boolean isLocalAgentFound = false;
            for (String s : array) {
                boolean isLocalAgent = this.m_serverEngine.getAgentRepository().approveAgent(s);
                if (isLocalAgent) {
                    isLocalAgentFound = true;
                }
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "APPROVEAGENT", s, null);
                if (!isLocalAgentFound || ++count <= 50) continue;
                this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
                count = 0;
            }
            if (isLocalAgentFound) {
                this.m_serverEngine.getEventsRouter().addPendingToALL("GETAGENTCARDS");
            }
        });
        runBkgr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeploy(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "Unknown error";
        char isOK = 'F';
        try {
            String targets = in.readUTF();
            int params = in.readInt();
            ArrayList<String> pairsToDeploy = new ArrayList<String>(params * 2);
            for (int i = 0; i < params; ++i) {
                String deployType = in.readUTF();
                pairsToDeploy.add(deployType);
                String objectName = in.readUTF();
                pairsToDeploy.add(objectName);
            }
            if (UserManager.getInstance().getRights(1002, this.m_userRole) == 1) {
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            RTLogger.print(5, "to deploy=" + params);
            ServerThreadPool.getInstance().submit(() -> {
                try {
                    this.processDeploy(targets, pairsToDeploy, this.m_login, this.m_userRole);
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
                }
                catch (Throwable e) {
                    RTLogger.print(3, EMPTY, e);
                }
            });
            result = "OK";
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
        }
    }

    private void processDeploy(String targets, List<String> pairsToDeploy, String login, UserRole role) {
        String[] agIDs = new String[1];
        if (targets.indexOf(44) != -1) {
            agIDs = targets.split("\\s*,\\s*");
        } else {
            agIDs[0] = targets;
        }
        ArrayList<String> agentIDs = new ArrayList<String>(agIDs.length);
        for (String id : agIDs) {
            if (UserManager.getInstance().checkAction4Agents(role.getID(), PGEntityAction.MODIFY, Collections.singletonList(id))) {
                agentIDs.add(id);
                continue;
            }
            RTLogger.print(2, "Skip deploy cmd. Operation is not permitted for user " + login + " on agent ID: " + id);
        }
        HashMap<SlaveServerCard, String> toSlaves = new HashMap<SlaveServerCard, String>();
        AsnDbUpdate adu = new AsnDbUpdate();
        for (int i = 0; i < pairsToDeploy.size(); i += 2) {
            String deployType = pairsToDeploy.get(i);
            String objectName = pairsToDeploy.get(i + 1);
            if ("REDEPLOY".equals(targets)) {
                ServerEngine.getInstance().getAuditLog().logReDeploy(login, objectName + "." + deployType, "ALL");
                this.processRedeployAll(adu, pairsToDeploy, login, role);
                continue;
            }
            ServerEngine.getInstance().getAuditLog().logDeploy(login, objectName + "." + deployType, targets);
            for (String agentID : agentIDs) {
                AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                if (target != null && target.getRelatedServer() != null) {
                    SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                    if (ssc == null) continue;
                    toSlaves.merge(ssc, target.getAgentID(), (a, b) -> a + "," + b);
                    continue;
                }
                this.m_serverEngine.getAssignmentRepository().addAssignment(adu, agentID, objectName, login, deployType, false);
            }
            RTLogger.print(5, "to deploy : %s %s -> agents count: %s", deployType, objectName, agentIDs.size());
        }
        adu.saveDB(this.m_serverEngine);
        if (toSlaves.size() > 0) {
            for (Map.Entry en : toSlaves.entrySet()) {
                SlaveServerCard ssc = (SlaveServerCard)en.getKey();
                if (ssc == null || ssc.getScenario() >= 3) continue;
                ssc.getServerClient().start("DEPLOY", (String)en.getValue(), pairsToDeploy.toArray(new String[0]));
            }
        }
        this.m_serverEngine.getAssignmentRepository().triggerDelayed(adu.getAllAssignmentIDs());
    }

    private void processRedeployAll(AsnDbUpdate adu, List<String> pairsToDeploy, String login, UserRole role) {
        for (int i = 0; i < pairsToDeploy.size(); i += 2) {
            String deployType = pairsToDeploy.get(i);
            String objectName = pairsToDeploy.get(i + 1);
            ArrayList<Assignment> assignments = this.m_serverEngine.getAssignmentRepository().getAssignments(objectName, deployType);
            if (assignments == null) continue;
            for (Assignment asn : assignments) {
                AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(asn.getAgentID());
                if (target == null) continue;
                if (UserManager.getInstance().checkAction4Agents(role.getID(), PGEntityAction.MODIFY, Collections.singletonList(target.getAgentID()))) {
                    this.m_serverEngine.getAssignmentRepository().addAssignment(adu, target.getAgentID(), objectName, login, deployType, false);
                    continue;
                }
                RTLogger.print(2, "Skip redeploy cmd. Operation is not permitted for user " + login + " on agent ID: " + target.getAgentID());
            }
        }
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc == null || ssc.getScenario() >= 3) continue;
            ssc.getServerClient().start("DEPLOY", "REDEPLOY", pairsToDeploy.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeployVirtual(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "done";
        char isOK = 'F';
        try {
            HashMap<SlaveServerCard, String> toSlaves = new HashMap<SlaveServerCard, String>();
            ArrayList<String> pairsToDeploy = new ArrayList<String>();
            String[] aIDs = new String[]{in.readUTF()};
            if (aIDs[0].indexOf(44) != -1) {
                aIDs = aIDs[0].split("\\s*,\\s*");
            }
            int params = in.readInt();
            if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(aIDs))) {
                for (int i = 0; i < params; ++i) {
                    in.readUTF();
                    in.readUTF();
                }
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            AsnDbUpdate adu = new AsnDbUpdate();
            RTLogger.print(5, "Virtual deploy=" + params);
            for (int i = 0; i < params; ++i) {
                String deployType = in.readUTF();
                pairsToDeploy.add(deployType);
                String objectName = in.readUTF();
                pairsToDeploy.add(objectName);
                for (String agentID : aIDs) {
                    AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                    if (target != null && target.getRelatedServer() != null) {
                        SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                        if (ssc == null) continue;
                        toSlaves.merge(ssc, target.getAgentID(), (a, b) -> a + "," + b);
                        continue;
                    }
                    List<SlaveServerCard> listSL = this.m_serverEngine.getSlaves();
                    for (SlaveServerCard ssc : listSL) {
                        if (ssc.getScenario() > 1) continue;
                        toSlaves.merge(ssc, agentID, (a, b) -> a + "," + b);
                    }
                    RTLogger.print(5, "to Virtual deploy : " + deployType + " " + objectName);
                    this.m_serverEngine.getAssignmentRepository().setAssignmentDeployedVirtual(adu, agentID, objectName, this.m_login, deployType);
                }
            }
            adu.saveDB(this.m_serverEngine);
            if (toSlaves.size() > 0) {
                for (Map.Entry en : toSlaves.entrySet()) {
                    SlaveServerCard ssc = (SlaveServerCard)en.getKey();
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ssc.getServerClient().start("DEPLOY_VIRTUAL", (String)en.getValue(), pairsToDeploy.toArray(new String[0]));
                }
            }
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeployDelayed(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "Unknown error";
        char isOK = 'F';
        try {
            HashMap<SlaveServerCard, String> toSlaves = new HashMap<SlaveServerCard, String>();
            String[] aIDs = new String[1];
            String targets = in.readUTF();
            if (targets.indexOf(44) != -1) {
                aIDs = targets.split("\\s*,\\s*");
            } else {
                aIDs[0] = targets;
            }
            int params = in.readInt();
            if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(aIDs))) {
                for (int i = 0; i < params; ++i) {
                    in.readUTF();
                    in.readUTF();
                }
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            ArrayList<String> pairsToDeploy = new ArrayList<String>(params * 2);
            AsnDbUpdate adu = new AsnDbUpdate();
            RTLogger.print(5, "to deployDelayed=" + params);
            for (int i = 0; i < params; ++i) {
                String deployType = in.readUTF();
                pairsToDeploy.add(deployType);
                String objectName = in.readUTF();
                pairsToDeploy.add(objectName);
                ServerEngine.getInstance().getAuditLog().logDeployQueue(this.m_login, objectName + "." + deployType, targets);
                for (String aID : aIDs) {
                    AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(aID);
                    if (target != null && target.getRelatedServer() != null) {
                        SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                        if (ssc == null || ssc.getScenario() >= 3) continue;
                        toSlaves.merge(ssc, target.getAgentID(), (a, b) -> a + "," + b);
                        continue;
                    }
                    List<SlaveServerCard> listSL = this.m_serverEngine.getSlaves();
                    for (SlaveServerCard ssc : listSL) {
                        if (ssc.getScenario() > 1) continue;
                        toSlaves.merge(ssc, aID, (a, b) -> a + "," + b);
                    }
                    RTLogger.print(5, "to deployDelayed : " + deployType + " " + objectName);
                    this.m_serverEngine.getAssignmentRepository().addAssignment(adu, aID, objectName, this.m_login, deployType, true);
                }
            }
            RTLogger.print(5, "Start ASN db update");
            adu.saveDB(this.m_serverEngine);
            RTLogger.print(5, "Stop ASN db update");
            isOK = 'T';
            if (toSlaves.size() > 0) {
                for (Map.Entry en : toSlaves.entrySet()) {
                    SlaveServerCard ssc = (SlaveServerCard)en.getKey();
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ssc.getServerClient().start("DEPLOY_DELAYED", (String)en.getValue(), pairsToDeploy.toArray(new String[0]));
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetAnnotation(SDataOutputStream out, SDataInputStream in) throws IOException {
        char isOK = 'F';
        try {
            String messageID = in.readUTF();
            EventsRouter eventOperations = this.m_serverEngine.getEventsRouter();
            SEventFwd e = eventOperations.getEvent(messageID);
            List<String> annot = eventOperations.getAnnotations(messageID);
            RTLogger.print(5, new StringBuilder("Annotation count=").append(annot.size()).append(" for indi ID=").append(messageID));
            if (e == null) {
                for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                    this.addAnnotationsFromSlave(messageID, eventOperations, annot, ssc);
                }
            } else {
                AbstractAgentCard ac = null;
                if (e.getT1() != null && e.getT1().length() > 30 && (ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(e.getT1())) == null) {
                    ac = this.m_serverEngine.getAgentRepository().getAgentCard(e.getAgentNode(), 0);
                }
                if (ac != null && ac.getRelatedServer() != null) {
                    SlaveServerCard ssc;
                    ssc = this.m_serverEngine.getSlave(ac.getRelatedServer());
                    this.addAnnotationsFromSlave(messageID, eventOperations, annot, ssc);
                }
            }
            out.writeInt(annot.size());
            for (String s : annot) {
                out.writeUTF(s);
            }
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "GetAnnotation failed. ", e);
        }
        finally {
            out.writeUTF(EMPTY + isOK);
        }
    }

    private void addAnnotationsFromSlave(String messageID, IEventProcessor eventOperations, List<String> annot, SlaveServerCard ssc) {
        if (ssc != null) {
            List alist2;
            ServerClient sc = ssc.getServerClientStandAlone();
            boolean isOK2 = false;
            try {
                isOK2 = sc.run("GET_ANNOT", messageID, (String[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isOK2 && (alist2 = (List)sc.getResultObject()) != null) {
                for (String str : alist2) {
                    if (!annot.contains(str)) {
                        annot.add(str);
                    }
                    if (ssc.getScenario() > 2) continue;
                    try {
                        Annotation an = Annotation.parseString(str);
                        if (an == null) continue;
                        eventOperations.markToSaveAnnotations(messageID, an);
                    }
                    catch (Throwable e1) {
                        RTLogger.print(5, "Slave annotation failed to store: " + str, e1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPutAnnotation(SDataOutputStream out, SDataInputStream in) throws IOException {
        char isOK = 'F';
        try {
            String messageID = in.readUTF();
            String annotation = in.readUTF();
            String text = this.m_login + "\n" + annotation;
            String status = "OMN";
            long time = System.currentTimeMillis();
            Annotation ann = new Annotation(text, time, status);
            this.m_serverEngine.getEventsRouter().markToSaveAnnotations(messageID, ann);
            this.m_serverEngine.getEventsRouter().setAnnotationFlag(messageID);
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "PutAnnotation action failed. ", e);
        }
        finally {
            out.writeUTF(EMPTY + isOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnDeploy(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "done";
        char isOK = 'F';
        try {
            String targets = in.readUTF();
            int params = in.readInt();
            ArrayList<String> pairsToDeploy = new ArrayList<String>(params * 2);
            for (int i = 0; i < params; ++i) {
                String deployType = in.readUTF();
                pairsToDeploy.add(deployType);
                String objectName = in.readUTF();
                pairsToDeploy.add(objectName);
            }
            if (UserManager.getInstance().getRights(1002, this.m_userRole) == 1) {
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            ServerThreadPool.getInstance().submit(() -> {
                try {
                    this.processUnDeploy(targets, pairsToDeploy, this.m_login, this.m_userRole);
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
                }
                catch (Throwable e) {
                    RTLogger.print(3, EMPTY, e);
                }
            });
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
        }
    }

    private void processUnDeploy(String targets, List<String> pairsToDeploy, String login, UserRole role) {
        String[] agIDs = new String[1];
        if (targets.indexOf(44) != -1) {
            agIDs = targets.split("\\s*,\\s*");
        } else {
            agIDs[0] = targets;
        }
        ArrayList<String> agentIDs = new ArrayList<String>(agIDs.length);
        for (String id : agIDs) {
            if (UserManager.getInstance().checkAction4Agents(role.getID(), PGEntityAction.MODIFY, Collections.singletonList(id))) {
                agentIDs.add(id);
                continue;
            }
            RTLogger.print(2, "Skip undeploy cmd. Operation is not permitted for user " + login + " on agent ID: " + id);
        }
        HashMap<SlaveServerCard, String> toSlaves = new HashMap<SlaveServerCard, String>();
        AsnDbUpdate adu = new AsnDbUpdate();
        for (int i = 0; i < pairsToDeploy.size(); i += 2) {
            String deployType = pairsToDeploy.get(i);
            String objectName = pairsToDeploy.get(i + 1);
            if ("REDEPLOY".equals(targets)) {
                ServerEngine.getInstance().getAuditLog().logUnDeploy(this.m_login, objectName + "." + deployType, "ALL");
            } else {
                ServerEngine.getInstance().getAuditLog().logUnDeploy(this.m_login, objectName + "." + deployType, targets);
            }
            for (String agentID : agentIDs) {
                AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(agentID);
                RTLogger.print(4, "to Undeploy=" + objectName + "." + deployType + " from Agent ID: " + agentID);
                if (target != null && target.getRelatedServer() != null) {
                    SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                    if (ssc == null) continue;
                    toSlaves.merge(ssc, target.getAgentID(), (a, b) -> a + "," + b);
                    continue;
                }
                RTLogger.print(5, "to Undeploy : " + deployType + " " + objectName);
                if (agentID.equalsIgnoreCase("REDEPLOY")) {
                    List<SlaveServerCard> listSL = this.m_serverEngine.getSlaves();
                    for (SlaveServerCard ssc : listSL) {
                        if (ssc.getScenario() >= 3) continue;
                        toSlaves.merge(ssc, agentID, (a, b) -> a + "," + b);
                    }
                    List<String> impactedACs = this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, objectName, deployType, false);
                    if (!deployType.equals("pga")) continue;
                    GroupTreeObject asnGrp = this.m_serverEngine.getAssignmentRepository().getAsnTree().findFirstGroup(objectName, deployType);
                    List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                    for (GroupTreeObjectLast policyOrbinary : list) {
                        for (String impactedAC : impactedACs) {
                            this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, policyOrbinary.getName(), policyOrbinary.getTreeObject().getType(), impactedAC, false);
                        }
                    }
                    continue;
                }
                this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, objectName, deployType, agentID, false);
                if (!deployType.equals("pga")) continue;
                GroupTreeObject asnGrp = this.m_serverEngine.getAssignmentRepository().getAsnTree().findFirstGroup(objectName, deployType);
                List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                for (GroupTreeObjectLast policyOrbinary : list) {
                    this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, policyOrbinary.getName(), policyOrbinary.getTreeObject().getType(), agentID, false);
                }
            }
        }
        adu.saveDB(this.m_serverEngine);
        if (toSlaves.size() > 0) {
            for (Map.Entry en : toSlaves.entrySet()) {
                SlaveServerCard ssc = (SlaveServerCard)en.getKey();
                if (ssc == null || ssc.getScenario() >= 3) continue;
                ssc.getServerClient().start("UNDEPLOY", (String)en.getValue(), pairsToDeploy.toArray(new String[0]));
            }
        }
        this.m_serverEngine.getAssignmentRepository().triggerDelayed(adu.getAllAssignmentIDs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnDeployDelayed(SDataOutputStream out, SDataInputStream in) throws IOException {
        String result = "done";
        char isOK = 'F';
        try {
            HashMap<SlaveServerCard, String> toSlaves = new HashMap<SlaveServerCard, String>();
            String[] aIDs = new String[1];
            String targets = in.readUTF();
            if (targets.indexOf(44) != -1) {
                aIDs = targets.split("\\s*,\\s*");
            } else {
                aIDs[0] = targets;
            }
            int params = in.readInt();
            if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, Arrays.asList(aIDs))) {
                for (int i = 0; i < params; ++i) {
                    in.readUTF();
                    in.readUTF();
                }
                throw new Exception(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
            }
            ArrayList<String> pairsToDeploy = new ArrayList<String>(params * 2);
            AsnDbUpdate adu = new AsnDbUpdate();
            for (int i = 0; i < params; ++i) {
                String deployType = in.readUTF();
                pairsToDeploy.add(deployType);
                String objectName = in.readUTF();
                pairsToDeploy.add(objectName);
                if (deployType.equals(EMPTY)) continue;
                ServerEngine.getInstance().getAuditLog().logUnDeployQueue(this.m_login, objectName + "." + deployType, targets);
                for (String aID : aIDs) {
                    AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(aID);
                    RTLogger.print(5, "to UndeployDelayed=" + params + " from Agent ID: " + aID);
                    if (target != null && target.getRelatedServer() != null) {
                        SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                        if (ssc == null) continue;
                        toSlaves.merge(ssc, target.getAgentID(), (a, b) -> a + "," + b);
                        continue;
                    }
                    RTLogger.print(5, "to UndeployDelayed : " + deployType + " " + objectName);
                    if (aID.equalsIgnoreCase("REDEPLOY")) {
                        List<String> impactedACs = this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, objectName, deployType, true);
                        if (!deployType.equals("pga")) continue;
                        GroupTreeObject asnGrp = this.m_serverEngine.getAssignmentRepository().getAsnTree().findFirstGroup(objectName, deployType);
                        List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                        for (GroupTreeObjectLast policyOrbinary : list) {
                            for (String impactedAC : impactedACs) {
                                this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, policyOrbinary.getName(), policyOrbinary.getTreeObject().getType(), impactedAC, true);
                            }
                        }
                        continue;
                    }
                    this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, objectName, deployType, aID, true);
                    if (!deployType.equals("pga")) continue;
                    GroupTreeObject asnGrp = this.m_serverEngine.getAssignmentRepository().getAsnTree().findFirstGroup(objectName, deployType);
                    List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                    for (GroupTreeObjectLast policyOrbinary : list) {
                        this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, this.m_login, policyOrbinary.getName(), policyOrbinary.getTreeObject().getType(), aID, true);
                    }
                }
            }
            adu.saveDB(this.m_serverEngine);
            isOK = 'T';
            if (toSlaves.size() > 0) {
                for (Map.Entry en : toSlaves.entrySet()) {
                    SlaveServerCard ssc = (SlaveServerCard)en.getKey();
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ssc.getServerClient().start("UNDEPLOY_DELAYED", (String)en.getValue(), pairsToDeploy.toArray(new String[0]));
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAcknMsg(SDataOutputStream out, SDataInputStream in, IEventProcessor eo, String command) throws IOException {
        String result = "Unknown error";
        char isOK = 'F';
        try {
            String allIDs = in.readUTF();
            String[] arrIDs = allIDs.split("\\s*,\\s*");
            ArrayList<String> al = new ArrayList<String>(Arrays.asList(arrIDs));
            HashMapArray<SlaveServerCard, CallSite> slaves = new HashMapArray<SlaveServerCard, CallSite>();
            for (String id : al) {
                SlaveServerCard ssc;
                SEventFwd sef = eo.getEvent(id);
                if (sef == null) {
                    RTLogger.print(5, "EventNotFound (close) ID=" + id);
                    continue;
                }
                AbstractAgentCard ac = null;
                if (sef.getT1() != null && sef.getT1().length() > 30) {
                    ac = this.m_serverEngine.getAgentRepository().getAgentCardByID(sef.getT1());
                }
                if (ac == null) {
                    ac = this.m_serverEngine.getAgentRepository().getAgentCard(sef.getAgentNode(), 0);
                }
                if (ac == null || ac.getRelatedServer() == null || (ssc = this.m_serverEngine.getSlave(ac.getRelatedServer())).getScenario() != 2 && ssc.getScenario() != 1) continue;
                slaves.putV(ssc, (CallSite)((Object)id));
            }
            for (SlaveServerCard ssc : slaves.keySet()) {
                List msgsIDs = slaves.getArray(ssc);
                ssc.getServerClient().start(command, null, msgsIDs.toArray(new String[0]));
            }
            EventBatchJob batch = new EventBatchJob(eo, al, this.m_login, false);
            batch.start();
            result = "operation scheduled";
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArchMsg(SDataOutputStream out, SDataInputStream in, IEventProcessor eo) throws IOException {
        Object result = "Unknown error";
        char isOK = 'F';
        try {
            String allIDs = in.readUTF();
            String[] arrIDs = allIDs.split("\\s*,\\s*");
            ArrayList<String> al = new ArrayList<String>(Arrays.asList(arrIDs));
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 2) continue;
                if (ssc.getScenario() == 0) {
                    if (eo instanceof EventOperationsOutage) {
                        ssc.getServerClient().start("DELETE_MSG_O", null, arrIDs);
                        continue;
                    }
                    ssc.getServerClient().start("DELETE_MSG", null, arrIDs);
                    continue;
                }
                if (eo instanceof EventOperationsOutage) {
                    ssc.getServerClient().start("ARCH_MSG_O", null, arrIDs);
                    continue;
                }
                ssc.getServerClient().start("ARCH_MSG", null, arrIDs);
            }
            EventBatchJob batch = new EventBatchJob(eo, al, false);
            batch.start();
            result = "operation scheduled";
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(4, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF((String)result);
            out.writeUTF(EMPTY + isOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeleteMsg(SDataOutputStream out, SDataInputStream in, IEventProcessor eo) throws IOException {
        String result = "Unknown error";
        char isOK = 'F';
        try {
            String allIDs = in.readUTF();
            String[] arrIDs = allIDs.split("\\s*,\\s*");
            List<String> al = Arrays.asList(arrIDs);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 2) continue;
                if (ssc.getScenario() == 0) {
                    if (eo instanceof EventOperationsOutage) {
                        ssc.getServerClient().start("DELETE_MSG_O", null, arrIDs);
                        continue;
                    }
                    ssc.getServerClient().start("DELETE_MSG", null, arrIDs);
                    continue;
                }
                if (eo instanceof EventOperationsOutage) {
                    ssc.getServerClient().start("ARCH_MSG_O", null, arrIDs);
                    continue;
                }
                ssc.getServerClient().start("ARCH_MSG", null, arrIDs);
            }
            EventBatchJob batch = new EventBatchJob(eo, al, true);
            batch.start();
            result = "operation scheduled";
            isOK = 'T';
        }
        catch (Throwable e) {
            RTLogger.print(5, "CMD failed. ", e);
            result = e.getMessage();
        }
        finally {
            out.writeUTF(result);
            out.writeUTF(EMPTY + isOK);
        }
    }

    private void processGetActions(SDataOutputStream out) throws IOException {
        ActionsRepository aRep = this.m_serverEngine.getActionRepository();
        LinkedList<File> tosend = new LinkedList<File>();
        Iterator<String> it = aRep.getFilesIterator();
        while (it.hasNext()) {
            String filename = it.next();
            int id = UserManager.getInstance().getActionID(filename);
            if (UserManager.getInstance().getRights(id, this.m_login) <= 1) continue;
            File file = aRep.getActionsDirectory().resolve(filename).toFile();
            tosend.add(file);
        }
        out.writeInt(tosend.size());
        for (File f : tosend) {
            this.sendFile(out, f);
        }
        out.writeUTF("T");
    }

    private void processUpdateActions(SDataOutputStream out, SDataInputStream in) throws IOException {
        String meta = in.readUTF();
        Action a = Action.getNew();
        a.read(in);
        ActionsRepository ar = this.m_serverEngine.getActionRepository();
        try {
            ar.updateAction(a, meta);
            ServerEngine.getInstance().getAuditLog().logModify(this.m_login, "ActionID=" + a.m_ID, a.getProperties().toString());
            out.writeUTF("OK");
            out.writeUTF("T");
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1) continue;
                ServerClientQ sc = ssc.getServerClient();
                ((ServerClient)sc).start("UPDATEACTION", meta, new IODataStream[]{a});
            }
        }
        catch (Exception e) {
            out.writeUTF("Error: " + e.getMessage());
            out.writeUTF("F");
        }
        this.m_serverEngine.getEventsRouter().addPendingToALL("GETACTIONS");
    }

    private synchronized boolean checkUser(String login, String password, String host) {
        this.m_userRole = UserManager.getInstance().checkUser(login, password);
        if (this.m_userRole != null) {
            if (m_users.get(login) == null) {
                RTLogger.print(2, "User '" + login + "' has logged in from " + host + " TLS=" + this.isTLS);
            }
            return true;
        }
        RTLogger.print(1, "User '" + login + "' failed to login from " + host + " TLS=" + this.isTLS);
        return false;
    }

    private void processDeploymentTrigger(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> agentIDs = new ArrayList<String>();
        boolean isAllFound = false;
        for (int i = 0; i < size; ++i) {
            String agentID = in.readUTF();
            agentIDs.add(agentID);
        }
        if (!UserManager.getInstance().checkAction4Agents(this.m_userRole.getID(), PGEntityAction.MODIFY, agentIDs)) {
            out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
        } else {
            for (String id : agentIDs) {
                if (id.equals("*")) {
                    this.m_serverEngine.getAssignmentRepository().triggerAllDeployments();
                    isAllFound = true;
                    ServerEngine.getInstance().getAuditLog().log(this.m_login, "TRIGGERALLDEPLOYMENTS", "ALL", null);
                    continue;
                }
                if (isAllFound) continue;
                List<Assignment> foundAndTriggered = this.m_serverEngine.getAssignmentRepository().triggerDelayed4Agent(id);
                for (Assignment asn : foundAndTriggered) {
                    ServerEngine.getInstance().getAuditLog().logDeploy(this.m_login, asn.getName() + "." + asn.getType(), asn.getAgentID());
                }
            }
            out.writeUTF("T");
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() >= 3) continue;
                ServerClientQ serverClient = ssc.getServerClient();
                ((ServerClient)serverClient).start("DEPLOYMENT_TRIGGER", null, agentIDs.toArray(new String[0]));
            }
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
        }
    }

    private void processDeploymentTriggerFiltered(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String asnID = in.readUTF();
            list.add(asnID);
        }
        List<Assignment> foundAndTriggered = this.m_serverEngine.getAssignmentRepository().triggerDelayed(list);
        out.writeUTF("T");
        for (Assignment asn : foundAndTriggered) {
            ServerEngine.getInstance().getAuditLog().logDeploy(this.m_login, asn.getName() + "." + asn.getType(), asn.getAgentID());
        }
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc.getScenario() >= 3) continue;
            ServerClientQ serverClient = ssc.getServerClient();
            ((ServerClient)serverClient).start("DEPLOYMENT_TRIGGER_FILTERED", null, list.toArray(new String[0]));
        }
        this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
    }

    private void processDeploymentCancel(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String assignmentID = in.readUTF();
            list.add(assignmentID);
        }
        out.writeUTF("T");
        RTLogger.print(4, "ASN. Cancel deployments for " + size + " elements");
        List<Assignment> foundAndTriggered = this.m_serverEngine.getAssignmentRepository().cancelDelayed(list, this.m_login);
        for (Assignment asn : foundAndTriggered) {
            ServerEngine.getInstance().getAuditLog().log(this.m_login, "CANCELDEPLOYMENT", asn.getName() + "." + asn.getType(), asn.getAgentID());
        }
        RTLogger.print(4, "ASN. Cancel deployments finished");
        for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
            if (ssc.getScenario() >= 3) continue;
            ServerClientQ serverClient = ssc.getServerClient();
            ((ServerClient)serverClient).start("DEPLOYMENT_CANCEL", null, list.toArray(new String[0]));
        }
        this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
    }

    private void processGetForwardPolicies(SDataOutputStream out) throws IOException {
        List<ForwardPolicy> arr = this.m_serverEngine.getForwardManager().getPolicies();
        out.writeInt(arr.size());
        for (ForwardPolicy fp : arr) {
            File file = this.m_serverEngine.getForwardManager().getFile4Policy(fp);
            this.sendFile(out, file);
        }
        out.writeUTF("T");
    }

    private void processGetForwardFilters(SDataOutputStream out) throws IOException {
        this.sendFile(out, this.m_serverEngine.getForwardManager().getFiltersCache().getFgfFile());
        out.writeUTF("T");
    }

    private void processPutForwardFilters(SDataOutputStream out, SDataInputStream in) throws IOException {
        Path defaultFgFPath = this.m_serverEngine.getForwardManager().getFiltersCache().getFgfPath();
        Path tmpFgFPath = defaultFgFPath.getParent().resolve("fgf.tmp");
        try {
            in.readFile(tmpFgFPath.toAbsolutePath().toString());
            this.m_serverEngine.getForwardManager().getFiltersCache().processNewFile(tmpFgFPath);
            out.writeUTF("T");
            ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", "AttributeFilters", this.m_serverEngine.getForwardManager().getFiltersCache().getForwardFiltersInMemory().toString());
            this.m_serverEngine.getForwardManager().validateFilters();
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_FORWARD_POLICIES");
        }
        catch (Throwable e) {
            RTLogger.print(2, EMPTY, e);
            out.writeUTF(e.getMessage());
        }
    }

    private void processUpdateForwardPolicies(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        String tmpFile = SPolicyRepository.getPolicyDir() + File.separator + name + ".fwd.xml.tmp";
        in.readFile(tmpFile);
        try {
            File fwp = new File(tmpFile);
            FPolicyFactory pf = new FPolicyFactory();
            ForwardPolicy fp = pf.loadForwardPolicy(fwp);
            int count = 3;
            while (!fwp.delete() && count-- > 0) {
                GUIWorker.sleep(200);
            }
            ServerEngine.getInstance().getAuditLog().log(this.m_login, "MODIFY", "NotificationFilter", fp.getPolicyName());
            this.m_serverEngine.getForwardManager().updateFwdPolicy(name, fp);
            out.writeUTF("T");
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_FORWARD_POLICIES");
        }
        catch (Throwable e) {
            RTLogger.print(2, EMPTY, e);
            out.writeUTF(e.getMessage());
        }
    }

    private void processDeleteForwardPolicies(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        try {
            ForwardPolicy fp = this.m_serverEngine.getForwardManager().forgetFwdPolicy(name);
            if (fp != null) {
                ServerEngine.getInstance().getAuditLog().log(this.m_login, "DELETE", "NotificationFilter", name);
                File policyFile = this.m_serverEngine.getForwardManager().getFile4Policy(fp);
                BkpFile.move(policyFile);
                if (policyFile.exists() && !policyFile.delete()) {
                    RTLogger.print(5, "Can't delete file (1): " + policyFile.getAbsolutePath());
                }
                out.writeUTF("T");
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_FORWARD_POLICIES");
            } else {
                out.writeUTF("Not found: " + name);
                RTLogger.print(2, "Forward filter policy not found: " + name);
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, EMPTY, e);
            out.writeUTF(e.getMessage());
        }
    }

    private void processActivateForwardPolicy(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        boolean activate = in.readBoolean();
        try {
            this.m_serverEngine.getForwardManager().setActive(name, activate);
            out.writeUTF("T");
            ServerEngine.getInstance().getAuditLog().log(this.m_login, activate ? "ENABLE" : "DISABLE", "NotificationFilter", name);
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_FORWARD_POLICIES");
        }
        catch (Throwable e) {
            RTLogger.print(2, EMPTY, e);
            out.writeUTF(e.getMessage());
        }
    }

    private void processRenamePolicyHistory(SDataOutputStream out, SDataInputStream in) throws IOException {
        String oldname = in.readUTF();
        String newname = in.readUTF();
        try {
            this._renameHistory(oldname, newname);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1 && 8 != ssc.getScenario()) continue;
                ServerClientQ sc = ssc.getServerClient();
                ((ServerClient)sc).start("RENAME_POLICYHISTORY", null, new String[]{oldname, newname});
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, EMPTY, e);
            out.writeUTF("F");
        }
        out.writeUTF("T");
    }

    private void _renameHistory(String oldname, String newname) {
        String d = SPolicyRepository.getPolicyDir();
        File dir = new File(d);
        File[] flist = dir.listFiles(new FileFilterPrefix(oldname));
        if (flist != null) {
            for (File file : flist) {
                String nname = file.getName();
                nname = nname.replace(oldname, newname);
                Path target = Paths.get(d, nname);
                try {
                    Files.move(file.toPath(), target, new CopyOption[0]);
                }
                catch (IOException e) {
                    RTLogger.print(3, "can't rename history file: " + file.getName() + " to: " + String.valueOf(target), e);
                }
            }
        }
    }

    private void getAvailableSmsTransports(SDataOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeUTF("T");
    }

    private void getINotifyList(SDataOutputStream out) throws IOException {
        List<NovelConfig> list = NotifierManager.getInstance().getConfigs();
        List guiList = list.stream().map(GUIWorker::convertNotificationNovelConfigForGui).collect(Collectors.toList());
        out.writeInt(guiList.size());
        for (NovelConfig novelConfig : guiList) {
            novelConfig.send(out);
        }
        out.writeUTF("T");
    }

    private void startNotifier(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        try {
            Notifier noti = NotifierManager.getInstance().start(name);
            if (noti == null) {
                throw new RuntimeException("Notification interface not found: " + name);
            }
            ServerEngine.getInstance().getAuditLog().logEnable(this.m_login, "NotificationConfig", name);
            out.writeUTF("T");
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_INOTIFY_LIST");
        }
        catch (Throwable ex) {
            out.writeUTF(ex.getMessage());
        }
    }

    private void stopNotifier(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        try {
            Notifier noti = NotifierManager.getInstance().stop(name);
            if (noti == null) {
                throw new RuntimeException("Notification interface not found: " + name);
            }
            ServerEngine.getInstance().getAuditLog().logDisable(this.m_login, "NotificationConfig", name);
            out.writeUTF("T");
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_INOTIFY_LIST");
        }
        catch (Throwable ex) {
            out.writeUTF(ex.getMessage());
        }
    }

    private void saveNotifierConfig(SDataOutputStream out, SDataInputStream in) throws IOException {
        NovelConfig conf = new NovelConfig();
        conf.read(in);
        try {
            if (!NotifierManager.getInstance().saveConfig(conf)) {
                out.writeUTF("Error saving configuration");
            } else {
                ServerEngine.getInstance().getAuditLog().logModify(this.m_login, "NotificationConfig", conf.getId());
                this.m_serverEngine.getEventsRouter().addPendingToALL("GET_INOTIFY_LIST");
                out.writeUTF("T");
            }
        }
        catch (Throwable e) {
            out.writeUTF(e.getMessage() == null ? "Error saving configuration" : e.getMessage());
        }
    }

    private void testNotifierConfig(SDataOutputStream out, SDataInputStream in) throws IOException {
        NovelConfig conf = new NovelConfig();
        conf.read(in);
        String rcp = in.readUTF();
        String result = NotifierManager.getInstance().testConfig(conf, rcp);
        out.writeUTF(result);
        out.writeUTF("T");
    }

    private void deleteNotifierConfig(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name = in.readUTF();
        String type = in.readUTF();
        if (!NotifierManager.getInstance().deleteConfig(name, type)) {
            out.writeUTF("F");
        } else {
            ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, "NotificationConfig " + name);
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_INOTIFY_LIST");
            out.writeUTF("T");
        }
    }

    private void processUndeployAll(SDataInputStream in, SDataOutputStream out) throws IOException {
        int size = in.readInt();
        ArrayList<String> tmp = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            tmp.add(in.readUTF());
        }
        out.writeUTF("T");
        ArrayList<String> agentIDs = tmp;
        String login = this.m_login;
        UserRole role = this.m_userRole;
        ServerThreadPool.getInstance().submit(() -> {
            HashMap<SlaveServerCard, List> toSlaves = new HashMap<SlaveServerCard, List>();
            AsnDbUpdate adu = new AsnDbUpdate();
            try {
                for (String string : agentIDs) {
                    AgentCard target = this.m_serverEngine.getAgentRepository().getAgentCardByID(string);
                    if (UserManager.getInstance().checkAction4Agents(role.getID(), PGEntityAction.MODIFY, Collections.singletonList(string))) {
                        if (target.getRelatedServer() != null) {
                            SlaveServerCard ssc = this.m_serverEngine.getSlave(target.getRelatedServer());
                            List currentList = toSlaves.computeIfAbsent(ssc, k -> new ArrayList());
                            currentList.add(string);
                            continue;
                        }
                        Map<Assignment, Object> assignments = this.m_serverEngine.getAssignmentRepository().getAssignments(string);
                        LinkedList<Assignment> pga = new LinkedList<Assignment>();
                        LinkedList<Assignment> pkg = new LinkedList<Assignment>();
                        LinkedList<Assignment> pol = new LinkedList<Assignment>();
                        for (Assignment asn : assignments.keySet()) {
                            if ("pga".equals(asn.getType())) {
                                pga.add(asn);
                                continue;
                            }
                            if ("pkg".equals(asn.getType())) {
                                pkg.add(asn);
                                continue;
                            }
                            pol.add(asn);
                        }
                        ArrayList<String> ids = new ArrayList<String>(pol.size());
                        for (Assignment asn : pga) {
                            this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, login, asn.getName(), asn.getType(), asn.getAgentID(), false);
                            ids.add(asn.getID());
                        }
                        for (Assignment asn : pol) {
                            this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, login, asn.getName(), asn.getType(), asn.getAgentID(), false);
                            ids.add(asn.getID());
                        }
                        this.m_serverEngine.getAssignmentRepository().triggerDelayed(ids);
                        GUIWorker.sleep(1000);
                        ids = new ArrayList(pol.size());
                        for (Assignment asn : pkg) {
                            this.m_serverEngine.getAssignmentRepository().deleteAssignment(adu, login, asn.getName(), asn.getType(), asn.getAgentID(), false);
                            ids.add(asn.getID());
                        }
                        this.m_serverEngine.getAssignmentRepository().triggerDelayed(ids);
                        continue;
                    }
                    RTLogger.print(2, "Skip undeploy cmd. Operation is not permitted for user " + login + " on agent ID: " + string);
                }
            }
            catch (Throwable e) {
                RTLogger.print(3, EMPTY, e);
            }
            adu.saveDB(this.m_serverEngine);
            if (toSlaves.size() > 0) {
                for (Map.Entry entry : toSlaves.entrySet()) {
                    SlaveServerCard ssc = (SlaveServerCard)entry.getKey();
                    if (ssc == null || ssc.getScenario() >= 3) continue;
                    ScUndeployAll sc = new ScUndeployAll(ssc, (List)toSlaves.get(ssc));
                    ssc.getServerClient().start(sc);
                }
            }
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
        });
        ServerEngine.getInstance().getAuditLog().logUnDeploy(this.m_login, String.join((CharSequence)",", agentIDs), "ALL");
    }

    public void processSetAgentAttributes(SDataOutputStream out, SDataInputStream in, String user) throws IOException {
        out.writeUTF("T");
        if (UserManager.getInstance().getRights(2015, user) >= 3) {
            try {
                ScPutAgentsCM sc227 = new ScPutAgentsCM(null, null);
                List<AgentCardCM> attributes = sc227.runCommandOnServer(in);
                ArrayList<AgentCardCM> localAgents = new ArrayList<AgentCardCM>();
                HashMap<String, List> slaveAgents = new HashMap<String, List>();
                for (AgentCardCM attributeList : attributes) {
                    AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(attributeList.getID());
                    if (ac != null) {
                        if (ac.isLocalAgent()) {
                            localAgents.add(attributeList);
                            continue;
                        }
                        if (ac.getRelatedServer() == null || ac.getRelatedServer().isEmpty()) continue;
                        slaveAgents.computeIfAbsent(ac.getRelatedServer(), slave -> new ArrayList()).add(attributeList);
                        continue;
                    }
                    RTLogger.print(5, "Set Agent attribute. Agent not found: " + attributeList.getID());
                }
                if (!localAgents.isEmpty()) {
                    this.m_serverEngine.getAgentRepository().saveAgentCardCM(localAgents);
                    String agentIds = localAgents.stream().map(AgentCardCM::getID).collect(Collectors.joining(","));
                    ServerEngine.getInstance().getAuditLog().logModify(this.m_login, agentIds, "Custom attributes");
                }
                if (!slaveAgents.isEmpty()) {
                    for (String slave2 : slaveAgents.keySet()) {
                        SlaveServerCard ssc = this.m_serverEngine.getSlave(slave2);
                        if (ssc != null) {
                            ScPutAgentsCM sscmd = new ScPutAgentsCM(ssc, (List)slaveAgents.get(slave2));
                            sscmd.addCmdPostProcess(sc -> RTLogger.print(5, "Agent attributes forwarded to slave. isOK?: " + sc.isSuccess()));
                            sscmd.start();
                            continue;
                        }
                        RTLogger.print(5, "Set Agent attribute. Slave not found: " + slave2);
                    }
                }
            }
            catch (Exception e) {
                RTLogger.print(3, "Error processing agent attributes", e);
            }
            this.m_serverEngine.getEventsRouter().addPendingToALL("GET_AGENTS_CM");
        } else {
            out.writeUTF("Insufficient rights");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep(int millis) throws InterruptedException {
        Object object = m_nodeGroupLock;
        synchronized (object) {
            m_nodeGroupLock.wait(millis);
        }
    }
}

