/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.SAssignmentRepository;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerClientQ;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.utils.BkpFile;
import com.blixx.shared.BM;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GUIWorkerMethods
extends CMDS {
    private static final String INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED = "Insufficient rights. Operation not permitted.";
    private static final String ELEMENT_NOT_FOUND = "Element not found";
    private static final String MOVE_TO_SUBTREE_OPERATION_NOT_PERMITTED = "Move element to subtree. Operation not permitted.";
    private static final String EMPTY = "";
    private ServerEngine m_serverEngine = null;
    private String m_login = null;

    public GUIWorkerMethods(ServerEngine serverEngine, String login) {
        this.m_serverEngine = serverEngine;
        this.m_login = login;
    }

    public void processPolicyTreeUpdateWithType(SDataOutputStream out, SDataInputStream in) throws IOException, FileNotFoundException {
        String treePathParent = in.readUTF();
        String newElement = in.readUTF();
        String action = in.readUTF();
        String treePathParentType = in.readUTF();
        Object result = "Unexpected Exception";
        int isOK = 84;
        SPolicyRepository spr = ServerEngine.getInstance().getPolicyRepository();
        SAssignmentRepository sar = this.m_serverEngine.getAssignmentRepository();
        String directory = SPolicyRepository.getPolicyDir();
        AsnDbUpdate adu = new AsnDbUpdate();
        GroupTreeObject root = spr.getPolicyTree();
        try {
            GroupTreeObject el = root.searchPath(treePathParent, treePathParentType);
            if (el == null) {
                out.writeUTF("Element not found: " + treePathParent);
                out.writeUTF("F");
                return;
            }
            if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, el.getPath(), el.getType())) {
                out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                out.writeUTF("F");
                return;
            }
            if (action.equals(ACTION_MOVE)) {
                GroupTreeObject subFolder = el.searchPath(newElement, EMPTY);
                if (subFolder != null) {
                    out.writeUTF(MOVE_TO_SUBTREE_OPERATION_NOT_PERMITTED);
                    out.writeUTF("F");
                    return;
                }
                String oldPath = el.getPath();
                GroupTreeObject targetFolder = root.searchPath(newElement, EMPTY);
                if (targetFolder == null) {
                    out.writeUTF("Element not found: " + newElement);
                    out.writeUTF("F");
                    return;
                }
                if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, targetFolder.getPath(), targetFolder.getType())) {
                    out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                    out.writeUTF("F");
                    return;
                }
                GroupTreeObject parent = el.getParent();
                el.getParent().removeElement(el);
                if (targetFolder.getChild(el.getName(), el.getType()) == null) {
                    try {
                        targetFolder.addElement(el);
                    }
                    catch (Throwable e) {
                        parent.addElement(el);
                        throw e;
                    }
                }
                ServerEngine.getInstance().getAuditLog().logRename(this.m_login, oldPath, el.getPath());
                GroupTreeObject gto = null;
                gto = el instanceof GroupTreeObjectLast ? spr.getPolicyTree().findElement(el.getName(), el.getTreeObject().getType()) : root.searchPath(el.getPath(), EMPTY);
                if (gto != null) {
                    this.updatingAsnLinks(el, oldPath, sar.getAsnTree());
                    sar.saveTree();
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
                }
            } else if (action.equals(ACTION_ADD)) {
                if (newElement.indexOf(BM.GTO_PATH_SEPARATOR) != -1) {
                    if (!UserManager.getInstance().checkPolicy(this.m_login, PGEntityAction.MODIFY, newElement, EMPTY)) {
                        out.writeUTF(INSUFFICIENT_RIGHTS_OPERATION_NOT_PERMITTED);
                        out.writeUTF("F");
                        return;
                    }
                    GroupTreeObject.createPath(newElement, root);
                    ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newElement);
                } else {
                    GroupTreeObject newEl = new GroupTreeObject(new TreeObject(newElement, EMPTY, null));
                    el.addElement(newEl);
                    ServerEngine.getInstance().getAuditLog().logCreate(this.m_login, newEl.getPath());
                }
            } else if (action.equals(ACTION_DEL) || action.equals(ACTION_DEL_and_UNDEPLOY)) {
                boolean dontUndeploy = !ACTION_DEL_and_UNDEPLOY.equals(action);
                GroupTreeObject gtoParent = el.getParent();
                String oldPath = el.getPath();
                String newPath = el.getParent().getPath();
                List<GroupTreeObjectLast> aList = el.getAllGTOLs();
                Iterator<GroupTreeObjectLast> it2 = aList.iterator();
                boolean saveSAR = it2.hasNext();
                boolean hasNameConflict = false;
                if (!newElement.equals("recursive") && this.hasNamingConflicts(gtoParent, el.getElements())) {
                    hasNameConflict = true;
                    saveSAR = false;
                    isOK = 70;
                    throw new RuntimeException("Conflict found");
                }
                while (it2.hasNext()) {
                    GroupTreeObjectLast gtol = it2.next();
                    List<Object> links = new ArrayList();
                    if (newElement.equals("recursive")) {
                        RTLogger.print(3, "PolicyPath: oldPath=" + oldPath + "/" + gtol.getName());
                        links = sar.getAsnTree().findLinksByName(oldPath + "/" + gtol.getName());
                        for (GroupTreeObjectLast groupTreeObjectLast : links) {
                            groupTreeObjectLast.getParent().removeElement(groupTreeObjectLast);
                            RTLogger.print(3, "delete link=" + groupTreeObjectLast.getLinkedPath());
                        }
                        continue;
                    }
                    if (hasNameConflict) continue;
                    links = sar.getAsnTree().findLinksByName(gtol.getPath());
                    for (GroupTreeObjectLast groupTreeObjectLast : links) {
                        RTLogger.print(3, "PolicyPath: oldPath=" + groupTreeObjectLast.getLinkedPath());
                        groupTreeObjectLast.setLinkedPath(groupTreeObjectLast.getLinkedPath().replace(oldPath + "/", newPath + "/"));
                        RTLogger.print(3, "update_link newPath=" + groupTreeObjectLast.getLinkedPath());
                    }
                }
                if (newElement.equals("recursive")) {
                    List<GroupTreeObjectLast> al = el.getAllGTOLs();
                    for (GroupTreeObjectLast gtol : al) {
                        String string = gtol.getTreeObject().getType();
                        if (string.equals("mon")) {
                            filename = gtol.getName() + ".mon.xml";
                            fileNameFull = directory + File.separator + filename;
                            f = new File(fileNameFull);
                            BkpFile.move(f);
                            if (f.exists()) {
                                f.delete();
                            }
                        } else if (string.equals("msg")) {
                            filename = gtol.getName() + ".msg.xml";
                            fileNameFull = directory + File.separator + filename;
                            f = new File(fileNameFull);
                            BkpFile.move(f);
                            if (f.exists()) {
                                f.delete();
                            }
                        }
                        String pt = el.getPath();
                        gtoParent.removeElement(el);
                        ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, gtol.getName());
                        sar.deleteAssignment(adu, this.m_login, gtol.getName(), string, dontUndeploy);
                        if (string.equals("mon")) {
                            this.m_serverEngine.getPolicyRepository().removeFromKnownMonitors(gtol.getName(), false);
                            continue;
                        }
                        if (!string.equals("msg")) continue;
                        this.m_serverEngine.getPolicyRepository().removeFromKnownMsgPolicies(gtol.getName(), false);
                    }
                    String pt = el.getPath();
                    gtoParent.removeElement(el);
                    ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, pt);
                } else if (!hasNameConflict) {
                    String pt = el.getPath();
                    gtoParent.removeElement(el);
                    ServerEngine.getInstance().getAuditLog().logDelete(this.m_login, pt);
                    List<GroupTreeObject> al = el.getElements();
                    gtoParent.addElements(al);
                }
                if (saveSAR) {
                    sar.saveTree();
                    this.m_serverEngine.getEventsRouter().addPendingToALL("GETASSIGNMENTS");
                }
            } else if (action.equals(ACTION_RNM)) {
                String oldPt = el.getName();
                el.setName(newElement);
                ServerEngine.getInstance().getAuditLog().logRename(this.m_login, oldPt, el.getPath());
            }
            spr.saveTree();
            adu.saveDB(this.m_serverEngine);
            for (SlaveServerCard ssc : this.m_serverEngine.getSlaves()) {
                if (ssc.getScenario() > 1) continue;
                ServerClientQ sc = ssc.getServerClient();
                sc.start("POLICYTREEUPDATE2", null, new String[]{treePathParent, newElement, action, treePathParentType});
            }
            this.m_serverEngine.getEventsRouter().addPendingToALL("GETPOLICIES");
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "error updating tree ", e);
            result = "Processing failed. Action=" + action + " TreePath=" + treePathParent + " Parameter=" + newElement;
            isOK = 70;
        }
        out.writeUTF((String)result);
        out.writeUTF(EMPTY + (char)isOK);
    }

    private boolean hasNamingConflicts(GroupTreeObject destinationGTO, List<GroupTreeObject> elements) {
        boolean hasConflict = false;
        for (int ii = 0; ii < elements.size(); ++ii) {
            GroupTreeObject groupTreeObject = elements.get(ii);
            String name = groupTreeObject.getName();
            if (destinationGTO.getFirstChild(name) == null) continue;
            hasConflict = true;
            break;
        }
        return hasConflict;
    }

    private void updatingAsnLinks(GroupTreeObject el, String oldPath, GroupTreeObject root_asnTree) {
        if (el instanceof GroupTreeObjectLast) {
            List<GroupTreeObjectLast> al = root_asnTree.findLinksByName(oldPath);
            String newPath = el.getPath();
            RTLogger.print(3, String.valueOf(al));
            for (GroupTreeObjectLast gtol_link : al) {
                gtol_link.setLinkedPath(newPath);
            }
        } else {
            List<GroupTreeObject> elements = el.getElements();
            for (int i = 0; i < elements.size(); ++i) {
                GroupTreeObject gto = elements.get(i);
                this.updatingAsnLinks(gto, oldPath + "/" + gto.getName(), root_asnTree);
            }
        }
    }

    public PreparedStatement getArchivedQuery(String where, long from, long limit) throws SQLException {
        ArrayList<Object> values = new ArrayList<Object>();
        Object sql = "SELECT EVENTS_A.*, EVENTS_EXT_A.* FROM EVENTS_A LEFT JOIN EVENTS_EXT_A ON EVENTS_A.ID=EVENTS_EXT_A.ID_E WHERE STIME >= ? AND STIME < ? ";
        values.add(from);
        values.add(limit);
        Pattern pSeverities = Pattern.compile("(AND EVENTS_A.SEVERITY IN \\([\\d\\,\\- ]+\\))");
        Matcher matcher = pSeverities.matcher(where);
        if (matcher.find()) {
            sql = (String)sql + matcher.group(1);
        }
        sql = this.extractFilter("EVENTS_A.NODE", where, values, (String)sql);
        sql = this.extractFilter("EVENTS_A.AGENTNODE", where, values, (String)sql);
        sql = this.extractFilter("EVENTS_A.MSGGRP", where, values, (String)sql);
        sql = this.extractFilter("EVENTS_A.APPLICATION", where, values, (String)sql);
        sql = this.extractFilter("EVENTS_A.OBJECT", where, values, (String)sql);
        sql = this.extractFilter("EVENTS_A.MSGTEXT", where, values, (String)sql);
        PreparedStatement ps = ServerEngine.getInstance().getDB().getConnectorArchive().getConnection().prepareStatement((String)sql, 1003, 1007);
        ps.setQueryTimeout(600);
        ServerEngine.getInstance().getDB().getConnectorArchive().fillValues(values.toArray(), ps);
        return ps;
    }

    private String extractFilter(String keyword, String where, ArrayList<Object> values, String sql) {
        Pattern pNode = Pattern.compile("AND " + keyword + " LIKE '(%[^']+%)'");
        Matcher m = pNode.matcher(where);
        if (m.find()) {
            sql = (String)sql + " AND " + keyword + " LIKE ?";
            values.add(m.group(1));
        }
        return sql;
    }
}

