/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.db.DBException;
import com.blixx.server.perf.PerfSubmitter;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.utils.StrUtils;

public class ReadPerf {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndSubmit(SDataInputStream is, AgentCard ac) {
        int success = 0;
        int size = 0;
        try {
            size = is.readInt();
            for (int k = 0; k < size; ++k) {
                String values = is.readUTF();
                this.submitPerfRow(ac, values);
                ++success;
            }
        }
        catch (Throwable e) {
            RTLogger.print(4, "Error reading Perf from " + ac.getAgentHost(), e);
        }
        finally {
            if (size != 0 && RTLogger.getCurrentLevel() >= 4) {
                StringBuffer sb = new StringBuffer("Perf expected=");
                sb.append(size).append(" success=").append(success).append(" Agent=").append(ac.getAgentHost());
                RTLogger.print(4, sb);
            }
        }
    }

    public void submitPerfRow(AgentCard ac, String values) {
        try {
            if (values == null) {
                return;
            }
            StrUtils m_SU = new StrUtils();
            String[] arr = m_SU.processQuoted(values);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = m_SU.removeQuotes(arr[i]);
            }
            String fields = arr[0];
            long time = Long.parseLong(arr[1]);
            String className = arr[3];
            PerfSubmitter ps = ServerEngine.getInstance().getPerfSubmitter();
            try {
                String[] narr = new String[arr.length - 4 + 1];
                int cc = 0;
                for (int i = 4; i < arr.length; ++i) {
                    narr[cc] = arr[i];
                    ++cc;
                }
                StringBuilder sb = new StringBuilder(fields);
                sb.append(',').append("BOOMAGENTID").append("/*VARCHAR|50*/");
                fields = sb.toString();
                narr[narr.length - 1] = ac.getAgentID();
                ps.submitValues(time, fields, className, narr);
            }
            catch (DBException e) {
                RTLogger.print(5, "perfdata submit failing", e);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error parsing time for rrd", e);
        }
    }
}

