/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.RemoteCmdClient;
import com.blixx.server.ServerEngine;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Annotation;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.File;
import java.io.IOException;

public class RemoteAction
extends RemoteCmdClient {
    private String m_message_ID = null;

    public RemoteAction(AgentCard card, String cmd, String messageID, int secondsTimeout) {
        super('A', card, cmd, secondsTimeout);
        this.m_message_ID = messageID;
        RTLogger.print(5, "Remote action scheduled for message ID:" + messageID + " agentID:" + card.getAgentID() + " AgentHost:" + card.getAgentHost());
    }

    @Override
    public void processRemote(SDataInputStream is, SDataOutputStream os, AgentCard ac) throws IOException {
        os.write(65);
        os.writeUTF(this.m_cmd);
        os.writeInt(this.m_timeoutSeconds);
        this.er.resultCode = is.readInt();
        this.m_output = is.readUTF();
        String resCode = "AAT";
        if (this.er.resultCode != 0) {
            this.er.m_errorMessages.add(this.m_output);
            resCode = "AAF";
        } else {
            this.er.m_outMessages.add("Success");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_card.getAgentHost()).append(" {").append(this.m_card.getAgentID()).append("}\n").append(this.m_output);
        Annotation ann = new Annotation(sb.toString(), System.currentTimeMillis(), resCode);
        ServerEngine.getInstance().getEventsRouter().markToSaveAnnotations(this.m_message_ID, ann);
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Remote action finished for message ID:" + this.m_message_ID + " " + resCode);
        }
        ServerEngine.getInstance().getEventsRouter().setAnnotationFlag(this.m_message_ID);
        if (this.m_cmd.toUpperCase().contains("BOOM_AGENT GET_DETAILS")) {
            this.handleInventory();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RemoteAction) {
            RemoteAction ria = (RemoteAction)obj;
            return this.m_card.getAgentID().equals(ria.m_card.getAgentID()) && this.m_cmd.equals(ria.m_cmd) && this.m_char == ria.m_char;
        }
        return false;
    }

    public int hashCode() {
        return this.m_cmd.hashCode();
    }

    public void handleInventory() {
        AgentInventoryCard agentInventoryCard = this.m_card.getAgentInventoryCard();
        boolean isFirstDiscovery = !agentInventoryCard.isDiscovered();
        boolean changed = agentInventoryCard.parseGET_DETAILS(this.m_output);
        if (changed) {
            String nVersion = PolicyFactory.getNextVersion(agentInventoryCard.getAttribute(AgentInventoryCard.getPath("_VERSION")));
            agentInventoryCard.saveSDIS(new File("srv/inventory"), nVersion);
            RTLogger.print(4, "Inventory change detected for " + this.m_card.getAgentID());
            CMD cmd = new CMD("GET_AGENT_INVENTORY_CARD", this.m_card.getAgentID(), null);
            ServerEngine.getInstance().getEventsRouter().addPendingToALL(cmd);
        } else if (isFirstDiscovery) {
            agentInventoryCard.saveSDIS(new File("srv/inventory"));
            RTLogger.print(4, "Inventory saved for " + this.m_card.getAgentID());
            CMD cmd = new CMD("GET_AGENT_INVENTORY_CARD", this.m_card.getAgentID(), null);
            ServerEngine.getInstance().getEventsRouter().addPendingToALL(cmd);
        }
    }
}

