/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AsnDbUpdate;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.utils.BkpFile;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.Assignment;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.pg.IAssignmentTree;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.w3c.dom.Document;

public class SAssignmentRepository
implements IAssignmentTree {
    public static final String ASSIGNMENTS = "Assignments";
    public static final String REDEPLOY = "REDEPLOY";
    public static final String POLICIES_DIR = "policies";
    public static final String ASSIGNMENTGROUP_XML = "assignmentGroups.xml";
    private final ServerEngine serverEngine;
    public String m_policyDirectory = null;
    private GroupTreeObject m_treeRoot = null;
    private final Map<String, Assignment> m_assignmentsStored = new ConcurrentHashMap<String, Assignment>();
    private final ConcurrentHashMapMap<String, Assignment> m_assignmentsByAgentID = new ConcurrentHashMapMap();
    private String m_asnGroupFile;
    private final ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();

    public SAssignmentRepository(boolean isTest) {
        this.serverEngine = ServerEngine.getInstance();
        if (!isTest) {
            this.init();
        }
    }

    private void readXML() {
        block9: {
            XMLTree m_xmlTools = new XMLTree();
            try {
                String asnGroupsFile = this.getAssignmentGroupsFile();
                File pf = new File(asnGroupsFile);
                if (!pf.exists() || !pf.canRead()) {
                    RTLogger.print(1, "SAR001 Required file: " + this.getAssignmentGroupsFile() + " not found. Creating new.");
                    this.m_treeRoot = new GroupTreeObject(new TreeObject("root", "", null));
                    GroupTreeObject Assignments = new GroupTreeObject(new TreeObject(ASSIGNMENTS, "toplevel", null));
                    this.m_treeRoot.addElement(Assignments);
                    this.saveTree();
                    break block9;
                }
                try (FileInputStream fio = new FileInputStream(asnGroupsFile);){
                    this.m_treeRoot = m_xmlTools.parseXML(fio, false);
                }
                if (!this.m_treeRoot.getFirstChild(ASSIGNMENTS).getTreeObject().getType().equals("toplevel")) {
                    this.m_treeRoot.getFirstChild(ASSIGNMENTS).getTreeObject().setType("toplevel");
                    this.saveTree();
                }
            }
            catch (Exception e) {
                RTLogger.print(2, "Policy groups tree failed to be initialized");
                throw new RuntimeException(e);
            }
        }
    }

    private void initPoliciesDirectory() {
        this.m_policyDirectory = this.serverEngine.getMainDir() + File.separator + "srv" + File.separator + POLICIES_DIR;
        this.m_asnGroupFile = this.m_policyDirectory + File.separator + ASSIGNMENTGROUP_XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.m_lock.writeLock().lock();
        try {
            this.initPoliciesDirectory();
            HashMap<String, Assignment> tempAssignmentsStored = new HashMap<String, Assignment>();
            HashMapMap<String, Assignment> tempAssignmentsByAgentID = new HashMapMap<String, Assignment>();
            this.readXML();
            GroupTreeObject ASNROOT = this.m_treeRoot.getFirstChild(ASSIGNMENTS);
            List<Assignment> list = this.serverEngine.getDB().loadAssignments();
            for (Assignment el : list) {
                if (el.getType().equals("pga")) {
                    ASNROOT.getChild(el.getName(), el.getType());
                }
                tempAssignmentsStored.put(el.getID(), el);
                tempAssignmentsByAgentID.putV(el.getAgentID(), el);
            }
            this.m_assignmentsStored.keySet().retainAll(tempAssignmentsStored.keySet());
            this.m_assignmentsStored.putAll(tempAssignmentsStored);
            ((ConcurrentHashMap.CollectionView)((Object)this.m_assignmentsByAgentID.keySet())).retainAll(tempAssignmentsByAgentID.keySet());
            this.m_assignmentsByAgentID.putAll(tempAssignmentsByAgentID);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public String getAssignmentGroupsFile() {
        return this.m_asnGroupFile;
    }

    @Override
    public GroupTreeObject getAsnTree() {
        this.m_lock.readLock().lock();
        try {
            GroupTreeObject groupTreeObject = this.m_treeRoot;
            return groupTreeObject;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void saveTree() {
        this.m_lock.writeLock().lock();
        try {
            XMLTree xmlTools = new XMLTree();
            Document doc = xmlTools.getXML(this.m_treeRoot);
            BkpFile.backup(this.getAssignmentGroupsFile());
            XMLFactory.writeXml(doc, this.getAssignmentGroupsFile());
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public Map<Assignment, Object> getAssignments(String agentID) {
        Map<Assignment, Object> all = this.m_assignmentsByAgentID.getHashMap(agentID);
        if (all == null) {
            return new HashMap<Assignment, Object>();
        }
        return new HashMap<Assignment, Object>(all);
    }

    public List<Assignment> getAssignments() {
        return new ArrayList<Assignment>(this.m_assignmentsStored.values());
    }

    public Map<Assignment, Object> getAssignmentsByNodeGroups(String agentID) {
        HashMap<Assignment, Object> all = new HashMap<Assignment, Object>();
        List<String> pathes = NodeGroupRepository.getInstance().getNodeGroupPathes(agentID);
        for (String ngPath : pathes) {
            Map<Assignment, Object> mapNG;
            GroupTreeObject ng = NodeGroupRepository.getInstance().getNodeGroupTree().searchPath(ngPath, "");
            if (ng == null || ng.getTreeObject() == null || ng.getTreeObject().getOID() == null || (mapNG = this.getAssignments(ng.getTreeObject().getOID())) == null) continue;
            all.putAll(mapNG);
        }
        return all;
    }

    public ArrayList<Assignment> getAssignments(String name, String type) {
        ArrayList<Assignment> all = new ArrayList<Assignment>();
        for (String id : this.m_assignmentsStored.keySet()) {
            Assignment a = this.m_assignmentsStored.get(id);
            if (!name.equals(a.getName()) || !type.equals(a.getType())) continue;
            all.add(a);
        }
        return all;
    }

    public Assignment getAssignment(String asnID) {
        return this.m_assignmentsStored.get(asnID);
    }

    public Assignment getAssignment(String agentID, String name, String type) {
        Iterator<Assignment> it = this.m_assignmentsByAgentID.iterator(agentID);
        while (it.hasNext()) {
            Assignment as = it.next();
            if (!as.getName().equals(name) || !as.getType().equals(type)) continue;
            return as;
        }
        return null;
    }

    public Map<String, Assignment> getLocalAssignmentsVisible(String user) {
        HashMap<String, List<GroupTreeObjectLast>> cache = new HashMap<String, List<GroupTreeObjectLast>>();
        HashMap<String, Assignment> to_send = new HashMap<String, Assignment>(this.m_assignmentsStored);
        GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
        for (Map.Entry<String, Assignment> en : this.m_assignmentsStored.entrySet()) {
            String type;
            Assignment value = en.getValue();
            if (user != null && UserManager.getInstance().isUserNodeGroupFiltered(user) && !UserManager.getInstance().isAgentVisible(user, value.getAgentID(), nodeGroups) || !(type = value.getType()).equals("pga")) continue;
            String agentID = value.getAgentID();
            List<GroupTreeObjectLast> list = (List<GroupTreeObjectLast>)cache.get(value.getName());
            if (list == null) {
                GroupTreeObject asnGrp = this.getAsnTree().findFirstGroup(value.getName(), type);
                list = asnGrp == null ? new ArrayList<GroupTreeObjectLast>() : asnGrp.getAllGTOLs();
                cache.put(value.getName(), list);
            }
            for (GroupTreeObjectLast policyOrbinary : list) {
                Assignment polORbin = this.getAssignment(agentID, policyOrbinary.getName(), policyOrbinary.getType());
                if (polORbin == null || polORbin.getLock() != 0) continue;
                to_send.remove(polORbin.getID());
            }
        }
        return to_send;
    }

    public void addAssignment(AsnDbUpdate adu, String agentID, String policyName, String login, String type, boolean dontDeploy) {
        if (agentID.equalsIgnoreCase(REDEPLOY)) {
            if (type.equals("pga")) {
                List<AgentCard> acList = this.redeployAssigned(adu, policyName, type, login, dontDeploy);
                GroupTreeObject asnGrp = this.getAsnTree().findFirstGroup(policyName, type);
                List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                for (GroupTreeObjectLast policyOrbinary : list) {
                    this.redeployForAgents(adu, acList, policyOrbinary.getName(), policyOrbinary.getTreeObject().getType(), login, dontDeploy);
                }
            } else {
                this.redeployAssigned(adu, policyName, type, login, dontDeploy);
            }
        } else {
            if (type.equals("pga")) {
                GroupTreeObject asnGrp = this.getAsnTree().findFirstGroup(policyName, type);
                List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                for (GroupTreeObjectLast policyOrbinary : list) {
                    Assignment asSub = Assignment.getInstance(agentID, policyOrbinary.getName(), login, policyOrbinary.getTreeObject().getType());
                    this.addAssignmentBatch(adu, asSub, dontDeploy);
                }
            }
            Assignment as = Assignment.getInstance(agentID, policyName, login, type);
            this.addAssignmentBatch(adu, as, dontDeploy);
        }
    }

    public void setAssignmentDeployedVirtual(AsnDbUpdate adu, String agentID, String name, String login, String type) {
        if (!agentID.equalsIgnoreCase(REDEPLOY)) {
            if (this.isAssignedToNodeGroup(Assignment.getInstance(agentID, name, login, type))) {
                RTLogger.print(3, "Assignment dropped because Parent NodeGroup Assignment here. ID: " + agentID + " name=" + name + " type=" + type);
                return;
            }
            if (type.equals("pga")) {
                GroupTreeObject asnGrp = this.getAsnTree().findFirstGroup(name, type);
                List<GroupTreeObjectLast> list = asnGrp.getAllGTOLs();
                for (GroupTreeObjectLast policyOrbinary : list) {
                    Assignment asSub = Assignment.getInstance(agentID, policyOrbinary.getName(), login, policyOrbinary.getTreeObject().getType());
                    this.addAssignmentAsDeployed(adu, asSub);
                }
            }
            Assignment as = Assignment.getInstance(agentID, name, login, type);
            this.addAssignmentAsDeployed(adu, as);
        }
    }

    public void addAssignment(Assignment as, boolean dontDeploy) {
        String agentID = as.getAgentID();
        String name = as.getName();
        String type = as.getType();
        boolean skip = this.isAssignmentAllowed(as);
        if (skip) {
            return;
        }
        if (!this.isAssigned(agentID, name, type)) {
            this.m_assignmentsStored.put(as.getID(), as);
            this.m_assignmentsByAgentID.putV(agentID, as);
            String user = as.getUser();
            as.setLock(1);
            this.serverEngine.getDB().saveAssignment(as.getID(), agentID, name, user, type, 1);
        } else {
            as = this.getAssignment(agentID, name, type);
            as.setLock(2);
            as.setUtime(System.currentTimeMillis());
            this.serverEngine.getDB().updateAssignment(as.getID(), as.getName(), as.getUser(), as.getLock(), as.getUtime());
        }
        if (!dontDeploy) {
            SPolicyRepository spr = this.serverEngine.getPolicyRepository();
            switch (type) {
                case "msg": {
                    spr._assignMessagePolicy(name, agentID, as.getUser());
                    break;
                }
                case "mon": {
                    spr._assignMonitorPolicy(name, agentID, as.getUser());
                    break;
                }
                case "pga": {
                    as.setLock(0);
                    this.serverEngine.getDB().updateAssignment(as.getID(), as.getName(), as.getUser(), as.getLock(), as.getUtime());
                    break;
                }
                case "pkg": {
                    this.serverEngine.getBinariesRepository().assignBinaryPackage(name, agentID);
                }
            }
        }
    }

    private void addAssignmentBatch(AsnDbUpdate adu, Assignment as, boolean dontDeploy) {
        String agentID = as.getAgentID();
        String name = as.getName();
        String type = as.getType();
        boolean skip = this.isAssignmentAllowed(as);
        if (skip) {
            return;
        }
        if (!this.isAssigned(agentID, name, type)) {
            this.m_assignmentsStored.put(as.getID(), as);
            this.m_assignmentsByAgentID.putV(agentID, as);
            as.setLock(1);
            adu.addToCreate(as);
        } else {
            as = this.getAssignment(agentID, name, type);
            if (as.getLock() != 2) {
                as.setLock(2);
                as.setUtime(System.currentTimeMillis());
                adu.addToUpdate(as);
            }
        }
        if (!dontDeploy) {
            SPolicyRepository spr = this.serverEngine.getPolicyRepository();
            switch (type) {
                case "msg": {
                    spr._assignMessagePolicy(name, agentID, as.getUser());
                    break;
                }
                case "mon": {
                    spr._assignMonitorPolicy(name, agentID, as.getUser());
                    break;
                }
                case "pga": {
                    if (as.getLock() == 2) break;
                    as.setLock(0);
                    adu.addToUpdate(as);
                    break;
                }
                case "pkg": {
                    this.serverEngine.getBinariesRepository().assignBinaryPackage(name, agentID);
                }
            }
        }
    }

    private boolean isAssignmentAllowed(Assignment as) {
        AgentCard ac;
        boolean skip = false;
        if (as.getType() == null || as.getType().equals("")) {
            skip = true;
        } else if (this.isAssignedToNodeGroup(as)) {
            RTLogger.print(3, "Assignment dropped because Parent NodeGroup Assignment here. AgentID: " + as.getAgentID() + " name=" + as.getName() + " type=" + as.getType());
            skip = true;
        } else if (as.getAgentID().length() != 32 && (ac = this.serverEngine.getAgentRepository().getLocalAgentCard(as.getAgentID(), false)) == null) {
            skip = true;
        }
        return skip;
    }

    private void addAssignmentAsDeployed(AsnDbUpdate adu, Assignment as) {
        String agentID = as.getAgentID();
        String name = as.getName();
        String type = as.getType();
        boolean skip = this.isAssignmentAllowed(as);
        if (skip) {
            return;
        }
        if (!this.isAssigned(agentID, name, type)) {
            this.m_assignmentsStored.put(as.getID(), as);
            this.m_assignmentsByAgentID.putV(agentID, as);
            as.getUser();
            as.setLock(0);
            adu.addToCreate(as);
        } else {
            as = this.getAssignment(agentID, name, type);
            if (as.getLock() != 0) {
                as.setLock(0);
                as.setUtime(System.currentTimeMillis());
                adu.addToUpdate(as);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlinkAll(String name, String type) {
        this.m_lock.readLock().lock();
        try {
            int found = 0;
            List<GroupTreeObjectLast> elements = this.m_treeRoot.findLinksByName(name, type);
            for (GroupTreeObjectLast toDelete : elements) {
                toDelete.getParent().removeElement(toDelete);
                ++found;
            }
            int n = found;
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public boolean deleteAssignment(AsnDbUpdate adu, String user, String name, String type, String agentID, boolean dontUndeploy) {
        boolean isFound = false;
        if (!type.equals("pga") && agentID.length() != 32 && this.checkOtherASNGroups(name, type, agentID)) {
            return true;
        }
        Assignment asn = this.getAssignment(agentID, name, type);
        if (agentID.length() == 32) {
            if ("pga".equals(type)) {
                List listOfAgentIDs = NodeGroupRepository.getInstance().getAssociatedAgentIDsByNGOID(agentID);
                for (String id : listOfAgentIDs) {
                    Assignment asnAgentDirect = this.getAssignment(id, name, type);
                    if (asnAgentDirect == null) continue;
                    adu.addToDelete(asnAgentDirect.getID());
                    this.cleanAssignmentFromMemory(asnAgentDirect);
                }
            }
        } else {
            AgentCard ac = this.serverEngine.getAgentRepository().getLocalAgentCard(agentID, false);
            if (ac == null) {
                this.setUndeployed(agentID, name, type);
                return false;
            }
        }
        if (!dontUndeploy) {
            if (asn != null) {
                isFound = true;
                if (type.equals("pga")) {
                    adu.addToDelete(asn.getID());
                    this.cleanAssignmentFromMemory(asn);
                } else {
                    asn.setLock(3);
                    asn.setUtime(System.currentTimeMillis());
                    if (asn.getLock() == 4) {
                        adu.addToDelete(asn.getID());
                        this.cleanAssignmentFromMemory(asn);
                    } else {
                        adu.addToUpdate(asn);
                    }
                }
                this.triggerUndeployAssignment(asn);
            } else {
                SPolicyRepository spr = this.serverEngine.getPolicyRepository();
                switch (type) {
                    case "msg": {
                        spr._deassignMessagePolicy(name, agentID);
                        break;
                    }
                    case "mon": {
                        spr._deassignMonitorPolicy(name, agentID);
                        break;
                    }
                    case "pga": {
                        break;
                    }
                    case "pkg": {
                        this.serverEngine.getBinariesRepository().deassignBinaryPackage(name, agentID);
                    }
                }
            }
        } else if (asn != null) {
            if (type.equals("pga")) {
                isFound = true;
            }
            asn.setLock(3);
            asn.setUtime(System.currentTimeMillis());
            if (asn.getLock() == 4) {
                adu.addToDelete(asn.getID());
                this.cleanAssignmentFromMemory(asn);
            } else {
                adu.addToUpdate(asn);
            }
        }
        return isFound;
    }

    public boolean checkOtherASNGroups(String name, String type, String agentID) {
        Iterator<Assignment> itF = this.m_assignmentsByAgentID.iterator(agentID);
        while (itF.hasNext()) {
            GroupTreeObject asnGTO;
            Assignment asn = itF.next();
            if (!asn.getType().equals("pga") || (asnGTO = this.m_treeRoot.findFirstGroup(asn.getName(), "pga")) == null || asnGTO.findElement(name, type) == null || asn.getLock() >= 3) continue;
            return true;
        }
        return false;
    }

    private void triggerUndeployAssignment(Assignment as) {
        SPolicyRepository spr = this.serverEngine.getPolicyRepository();
        switch (as.getType()) {
            case "msg": {
                spr._deassignMessagePolicy(as.getName(), as.getAgentID());
                break;
            }
            case "mon": {
                spr._deassignMonitorPolicy(as.getName(), as.getAgentID());
                break;
            }
            case "pga": {
                break;
            }
            case "pkg": {
                this.serverEngine.getBinariesRepository().deassignBinaryPackage(as.getName(), as.getAgentID());
            }
        }
    }

    private void cleanAssignmentInMemoryAndDB(Assignment as) {
        this.serverEngine.getDB().deleteAssignment(as.getID());
        this.cleanAssignmentFromMemory(as);
    }

    private void cleanAssignmentFromMemory(Assignment as) {
        this.m_assignmentsStored.remove(as.getID());
        Map<Assignment, Object> map = this.m_assignmentsByAgentID.getHashMap(as.getAgentID());
        if (map != null) {
            map.remove(as);
        }
    }

    public List<String> deleteAssignment(AsnDbUpdate adu, String user, String name, String type, boolean dontUndeploy) {
        List<String> agents = this.getAgentsAssigned(name, type);
        for (String agentID : agents) {
            if (!UserManager.getInstance().isAgentVisible(user, agentID)) continue;
            this.deleteAssignment(adu, user, name, type, agentID, dontUndeploy);
        }
        return agents;
    }

    public void deleteAgent(String agentID) {
        Iterator<Assignment> it = this.m_assignmentsByAgentID.iterator(agentID);
        while (it.hasNext()) {
            Assignment asn = it.next();
            if (asn == null) continue;
            this.m_assignmentsStored.remove(asn.getID());
        }
        this.m_assignmentsByAgentID.remove(agentID);
    }

    public List<String> getAgentsAssigned(String asName, String type) {
        LinkedList<String> al = new LinkedList<String>();
        for (String agentID : this.m_assignmentsByAgentID.keySet()) {
            if (!this.isAssigned(agentID, asName, type)) continue;
            al.add(agentID);
        }
        return al;
    }

    public boolean isAssigned(String agentID, String name, String type) {
        boolean isFound = false;
        Iterator<Assignment> it = this.m_assignmentsByAgentID.iterator(agentID);
        while (it.hasNext()) {
            Assignment as = it.next();
            if (!as.getName().equals(name) || !as.getType().equals(type)) continue;
            return true;
        }
        return isFound;
    }

    public List<AgentCard> redeployAssigned(AsnDbUpdate adu, String name, String type, String user, boolean dontDeploy) {
        long time = System.currentTimeMillis();
        ArrayList<AgentCard> impacted = new ArrayList<AgentCard>();
        for (String id : this.m_assignmentsStored.keySet()) {
            Assignment as = this.m_assignmentsStored.get(id);
            AgentCard ac = this.serverEngine.getAgentRepository().getLocalAgentCard(as.getAgentID(), false);
            if (ac == null || !UserManager.getInstance().isAgentVisible(user, ac.getAgentID()) || !as.getName().equals(name) || !as.getType().equals(type)) continue;
            if (!dontDeploy) {
                SPolicyRepository spr = this.serverEngine.getPolicyRepository();
                impacted.add(ac);
                switch (type) {
                    case "msg": {
                        spr._assignMessagePolicy(name, as.getAgentID(), as.getUser());
                        break;
                    }
                    case "mon": {
                        spr._assignMonitorPolicy(name, as.getAgentID(), as.getUser());
                        break;
                    }
                    case "pga": {
                        break;
                    }
                    case "pkg": {
                        this.serverEngine.getBinariesRepository().assignBinaryPackage(name, as.getAgentID());
                    }
                }
            } else {
                impacted.add(ac);
            }
            if (!"pga".equals(type) && as.getLock() != 2) {
                as.setLock(2);
            }
            as.setUtime(time);
            as.setUser(user);
            adu.addToUpdate(as);
        }
        return impacted;
    }

    protected void redeployForAgents(AsnDbUpdate adu, List<AgentCard> acList, String name, String type, String user, boolean dontDeploy) {
        block12: for (AgentCard ac : acList) {
            if (ac == null || !UserManager.getInstance().isAgentVisible(user, ac.getAgentID())) continue;
            Assignment as = this.getAssignment(ac.getAgentID(), name, type);
            if (!dontDeploy) {
                SPolicyRepository spr = this.serverEngine.getPolicyRepository();
                switch (type) {
                    case "msg": {
                        spr._assignMessagePolicy(name, ac.getAgentID(), user);
                        break;
                    }
                    case "mon": {
                        spr._assignMonitorPolicy(name, ac.getAgentID(), user);
                        break;
                    }
                    case "pga": {
                        continue block12;
                    }
                    case "pkg": {
                        this.serverEngine.getBinariesRepository().assignBinaryPackage(name, ac.getAgentID());
                    }
                }
                if (as == null) {
                    as = Assignment.getInstance(ac.getAgentID(), name, user, type);
                }
            }
            if (as == null || type.equals("pga") || as.getLock() == 2) continue;
            as.setLock(2);
            as.setUtime(System.currentTimeMillis());
            as.setUser(user);
            adu.addToUpdate(as);
        }
    }

    public void renameAssignment(String oldName, String newName, String user, String type) {
        for (String id : this.m_assignmentsStored.keySet()) {
            Assignment as = this.m_assignmentsStored.get(id);
            if (!as.getName().equals(oldName) || !as.getType().equals(type)) continue;
            as.setUtime(System.currentTimeMillis());
            this.serverEngine.getDB().updateAssignment(as.getID(), newName, user, as.getLock(), as.getUtime());
            as.setName(newName);
            RTLogger.print(5, "Assignment renamed: old=" + oldName + " new=" + newName);
        }
    }

    public synchronized void triggerAllDeployments() {
        ServerThreadPool.getInstance().submit(() -> {
            try {
                this.serverEngine.getBinariesRepository()._triggerAllDeployments();
                this.serverEngine.getPolicyRepository()._triggerAllDeployments();
            }
            catch (Throwable e) {
                RTLogger.print(2, "TriggerAllDeployments", e);
            }
        });
    }

    public void setUploaded(String agentID, String name, String type) {
        Assignment as = this.getAssignment(agentID, name, type);
        this.setUploaded(as);
    }

    private void setUploaded(Assignment as) {
        if (as != null) {
            as.setLock(0);
            as.setUtime(System.currentTimeMillis());
            this.serverEngine.getDB().updateAssignment(as.getID(), as.getName(), as.getUser(), as.getLock(), as.getUtime());
        }
    }

    public void setUndeployed(String agentID, String name, String type) {
        Assignment as = this.getAssignment(agentID, name, type);
        if (as != null) {
            this.cleanAssignmentInMemoryAndDB(as);
        }
    }

    public List<Assignment> cancelDelayed(List<String> assignmentIDs, String user) {
        LinkedList<Assignment> foundAndCanceled = new LinkedList<Assignment>();
        AsnDbUpdate adu = new AsnDbUpdate();
        for (String assignmentID : assignmentIDs) {
            Assignment a = this.m_assignmentsStored.get(assignmentID);
            if (a == null) continue;
            foundAndCanceled.add(a);
            switch (a.getLock()) {
                case 1: 
                case 4: {
                    this.cleanAssignmentFromMemory(a);
                    adu.addToDelete(a.getID());
                    break;
                }
                case 2: 
                case 3: {
                    if (a.getLock() == 0) break;
                    a.setLock(0);
                    a.setUtime(System.currentTimeMillis());
                    adu.addToUpdate(a);
                }
            }
        }
        adu.saveDB(this.serverEngine);
        return foundAndCanceled;
    }

    public List<Assignment> triggerDelayed(List<String> asnIDs) {
        LinkedList<Assignment> foundAndTriggered = new LinkedList<Assignment>();
        for (String id : asnIDs) {
            int SEP = id.indexOf(9658);
            if (SEP != -1) {
                String name = id.substring(0, SEP);
                int SEP2 = id.indexOf(9658, SEP + 1);
                int tl = id.length();
                if (SEP2 != -1) {
                    tl = SEP2;
                }
                String type = id.substring(SEP + 1, tl);
                ArrayList<Assignment> list = this.getAssignments(name, type);
                for (Assignment asn : list) {
                    if (asn == null) continue;
                    this.processTriggerDeploymentAction(asn);
                    foundAndTriggered.add(asn);
                }
                continue;
            }
            Assignment asn = this.getAssignment(id);
            if (asn == null) continue;
            this.processTriggerDeploymentAction(asn);
            foundAndTriggered.add(asn);
        }
        this.triggerAllDeployments();
        return foundAndTriggered;
    }

    public List<Assignment> triggerDelayed4Agent(String agentID_IN) {
        LinkedList<Assignment> foundAndTroggered = new LinkedList<Assignment>();
        Map<Assignment, Object> asnList = this.getAssignments(agentID_IN);
        for (Assignment a : asnList.keySet()) {
            this.processTriggerDeploymentAction(a);
            foundAndTroggered.add(a);
        }
        this.triggerAllDeployments();
        return foundAndTroggered;
    }

    private void processTriggerDeploymentAction(Assignment a) {
        String agentID = a.getAgentID();
        if (a.getLock() > 0) {
            long time = a.getUtime();
            if (time == 0L) {
                time = a.getFtime();
            }
            switch (a.getType()) {
                case "mon": {
                    if (a.getLock() == 1 || a.getLock() == 2) {
                        this.serverEngine.getPolicyRepository()._assignMonitorPolicy(a.getName(), agentID, a.getUser());
                        break;
                    }
                    if (a.getLock() != 3) break;
                    this.serverEngine.getPolicyRepository()._deassignMonitorPolicy(a.getName(), agentID);
                    break;
                }
                case "msg": {
                    if (a.getLock() == 1 || a.getLock() == 2) {
                        this.serverEngine.getPolicyRepository()._assignMessagePolicy(a.getName(), agentID, a.getUser());
                        break;
                    }
                    if (a.getLock() != 3) break;
                    this.serverEngine.getPolicyRepository()._deassignMessagePolicy(a.getName(), agentID);
                    break;
                }
                case "pkg": {
                    if (a.getLock() == 1 || a.getLock() == 2) {
                        this.serverEngine.getBinariesRepository().assignBinaryPackage(a.getName(), agentID);
                        break;
                    }
                    if (a.getLock() != 3) break;
                    this.serverEngine.getBinariesRepository().deassignBinaryPackage(a.getName(), agentID);
                    break;
                }
                case "pga": {
                    if (a.getLock() < 3) {
                        this.serverEngine.getAssignmentRepository().setUploaded(agentID, a.getName(), a.getType());
                        break;
                    }
                    this.serverEngine.getAssignmentRepository().setUndeployed(agentID, a.getName(), a.getType());
                }
            }
        }
    }

    public boolean isAssignedToNodeGroup(Assignment asn) {
        if (asn != null) {
            String agentid = asn.getAgentID();
            List<String> parentNodeGroupOIDs = NodeGroupRepository.getInstance().getNodeGroupOIDs(agentid);
            if (parentNodeGroupOIDs.size() == 0) {
                return false;
            }
            for (String ngOID : parentNodeGroupOIDs) {
                Map<Assignment, Object> asns = this.m_assignmentsByAgentID.getHashMap(ngOID);
                if (asns == null) continue;
                for (Assignment asnbyNG : asns.keySet()) {
                    if (!asn.getType().equals(asnbyNG.getType()) || !asn.getName().equals(asnbyNG.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, Assignment> getAllAssignments_AlsoSlaves(String user, ConcurrentHashMapMap<String, Assignment> perAgentIDMap) {
        HashMap<String, Assignment> assignments = new HashMap<String, Assignment>(this.getLocalAssignmentsVisible(user));
        for (SlaveServerCard ssc : this.serverEngine.getSlaves()) {
            List slaveasn;
            ServerClient serverClient;
            if (ssc == null || ssc.getSlaveServerClient() == null || !ssc.getSlaveServerClient().isOnline() || ssc.getScenario() >= 3 || !(serverClient = ssc.getServerClientStandAlone()).run("GET_ALL_ASSIGNMENTS", null, new String[0]) || (slaveasn = (List)serverClient.getResultObject()) == null) continue;
            for (Assignment a : slaveasn) {
                if (assignments.containsKey(a.getID())) continue;
                assignments.put(a.getID(), a);
                if (perAgentIDMap == null) continue;
                perAgentIDMap.putV(a.getAgentID(), a);
            }
        }
        return assignments;
    }
}

