/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.sa.Opts;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.shared.IEvent;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.Severity;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class SMessage
extends SEvent
implements IODataStream,
IEvent {
    public static final String SERVER_GROUP = "BOOM Server";
    public static final String CONCATENATOR_ATAT = "@@";
    public static final String LICENSE_MSGGRP = "LICENSE";

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        String type = null;
        String uuid = dis.readUTF();
        if (uuid.length() > 36) {
            type = uuid.substring(36);
            uuid = uuid.substring(0, 36);
        }
        this.setID(uuid);
        this.setTime(dis.readLong());
        this.setApplication(dis.readUTF());
        this.setObject(dis.readUTF());
        this.setSeverity(dis.readInt());
        this.setText(dis.readUTF());
        this.setInstructionID(dis.readUTF());
        this.setGroup(dis.readUTF());
        this.setKey(dis.readUTF());
        this.setCloseMask(dis.readUTF());
        this.setNode(dis.readUTF());
        this.setAutoAction(dis.readUTF());
        this.setAutoActionNode(dis.readUTF());
        this.setAutoActionTimeout(dis.readInt());
        this.setSource(dis.readUTF());
        this.setOpAction(dis.readUTF());
        this.setTypeA(dis.readInt());
        this.setTypeK(dis.readInt());
        this.setDeduplication(dis.readBoolean());
        this.setSTime(System.currentTimeMillis());
        this.setFirstTime(this.getTime());
        if (type != null) {
            this.setState(type.charAt(0));
            SEventFwd sef = new SEventFwd(this);
            if (type.length() > 1) {
                String optVars = type.substring(1);
                HashMap<String, String> opt = Opts.getFromString(optVars);
                sef.m_CustomAttributes.putAll(opt);
            }
            return sef;
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        throw new IOException("This feature does not supported yet.");
    }

    public static SEventFwd sendMessage(AgentCard ac, String text, int severity, String msggrp, String object, String node, int type_a) {
        SEventFwd sm = SMessage.createMessage(ac, text, severity, msggrp, "BOOM_SERVER", object, node, type_a);
        try {
            if (!ServerEngine.isNullInstance()) {
                ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
            }
        }
        catch (Throwable e) {
            sm = null;
        }
        return sm;
    }

    public static SEventFwd createMessage(AgentCard ac, String text, int severity, String msggrp, String app, String object, String node, int type_a) {
        SEventFwd sm = new SEventFwd();
        sm.setID(UUID.randomUUID().toString());
        sm.setSource("BOOM_SERVER");
        sm.setTime(System.currentTimeMillis());
        sm.setFirstTime(sm.getTime());
        sm.setApplication(app);
        sm.setObject(object);
        sm.setSeverity(severity);
        sm.setText(text);
        sm.setGroup(msggrp);
        if (node != null && node.length() > 0) {
            sm.setNode(node);
        } else if (!ServerEngine.isNullInstance()) {
            sm.setNode(ServerEngine.getInstance().getServerProps().getHostname());
        }
        if (ac != null) {
            sm.setAgentNode(ac.getAgentHost());
        } else {
            sm.setAgentNode(SERVER_GROUP);
        }
        sm.setKey(sm.getAutoKey());
        String sevStr = Severity.getSeverity(severity);
        if (sm.getKeyConfigured().endsWith(":" + sevStr)) {
            sm.setCloseMask(sm.getKeyConfigured().replace(":" + sevStr, ":<![" + sevStr + "]>"));
        }
        sm.setSTime(sm.getTime());
        sm.setState('-');
        sm.setTypeA(type_a);
        sm.setDeduplication(true);
        if (ac != null) {
            sm.setT1(ac.getAgentID());
        }
        return sm;
    }

    public static SEventFwd createMessage(int sev, int type_a, String apps, String obj, String msggrp, String text) {
        return SMessage.createMessage(sev, type_a, ServerEngine.isNullInstance() ? null : ServerEngine.getInstance().getServerProps().getHostname(), apps, obj, msggrp, text);
    }

    public static SEventFwd createMessage(int sev, int type_a, String node, String apps, String obj, String msggrp, String text) {
        return SMessage.createMessage(null, text, sev, msggrp, apps, obj, node, type_a);
    }
}

