/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.ServerAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ServerActionsManager
extends Thread {
    public static int m_maxThreads = 10;
    public LinkedBlockingQueue<ServerAction> m_queue = new LinkedBlockingQueue();
    public Map<ServerAction, Long> m_queueDelayed = new ConcurrentHashMap<ServerAction, Long>(5);
    public List<ServerAction> m_queueRunning = new ArrayList<ServerAction>(m_maxThreads);
    private final Object m_lock = new Object();
    private static volatile ServerActionsManager m_instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerActionsManager getInstance() {
        if (m_instance != null) return m_instance;
        Class<ServerActionsManager> clazz = ServerActionsManager.class;
        synchronized (ServerActionsManager.class) {
            if (m_instance != null) return m_instance;
            ServerActionsManager instance = new ServerActionsManager("ServerActionMgr");
            instance.start();
            m_instance = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    private ServerActionsManager() {
    }

    private ServerActionsManager(Runnable target, String name) {
        super(target, name);
    }

    private ServerActionsManager(Runnable target) {
        super(target);
    }

    private ServerActionsManager(String name) {
        super(name);
    }

    private ServerActionsManager(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    private ServerActionsManager(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    private ServerActionsManager(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    private ServerActionsManager(ThreadGroup group, String name) {
        super(group, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(ServerAction client, long delay_ms) {
        if (!this.m_queueDelayed.containsKey(client) && !this.m_queue.contains(client)) {
            client.onInit();
            this.m_queueDelayed.put(client, System.currentTimeMillis() + delay_ms);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reschedule(ServerAction client, long delay_ms) {
        if (!this.m_queueDelayed.containsKey(client) && !this.m_queue.contains(client)) {
            client.onReSchedule();
            this.m_queueDelayed.put(client, System.currentTimeMillis() + delay_ms);
            Object object = this.m_lock;
            synchronized (object) {
                this.m_lock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(ServerAction client) {
        if (client == null || this.m_queue.contains(client) || this.m_queueDelayed.containsKey(client)) {
            return false;
        }
        client.onInit();
        while (!this.m_queue.offer(client)) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.m_queue.size() == 0 && this.m_queueDelayed.size() == 0) {
                Object object = this.m_lock;
                synchronized (object) {
                    try {
                        this.m_lock.wait(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            try {
                Iterator<ServerAction> it = this.m_queueRunning.iterator();
                while (it.hasNext()) {
                    ServerAction running = it.next();
                    if (!running.isFinished()) continue;
                    it.remove();
                    int repeat = running.getRescheduleDelay();
                    if (repeat <= 0) continue;
                    running.isFinished = false;
                    this.reschedule(running, repeat);
                }
                Iterator<ServerAction> itc = this.m_queueDelayed.keySet().iterator();
                while (itc.hasNext()) {
                    ServerAction sc = itc.next();
                    long timeToStart = this.m_queueDelayed.get(sc);
                    if (System.currentTimeMillis() < timeToStart) continue;
                    this.m_queue.offer(sc);
                    itc.remove();
                }
                if (this.m_queueRunning.size() < m_maxThreads) {
                    ServerAction job = this.m_queue.poll();
                    if (job == null) continue;
                    Thread tr = new Thread(job);
                    tr.setName(job.getActionID());
                    tr.start();
                    this.m_queueRunning.add(job);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Throwable e) {
                RTLogger.print(3, "", e);
                continue;
            }
            break;
        }
    }
}

