/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.in.ScGetAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScGetAgentServerPolicies;
import com.blixx.ctrl.sc.in.ScGetExtendedServerPolicies;
import com.blixx.ctrl.sc.in.ScGetExtendedServerPolicy;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicies;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicy;
import com.blixx.ctrl.sc.in.ScGetServerPolicies;
import com.blixx.ctrl.sc.in.ScGetServerPolicy;
import com.blixx.ctrl.sc.in.ScGetSlaves;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.shared.AgentInventoryCard;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.BM;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.ArchiveDetails;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.VersionComparator;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class ServerClient
extends Thread {
    protected String m_action = null;
    protected String[] m_parameters = null;
    public String m_command = null;
    protected Object m_result = null;
    protected boolean isFinished = false;
    protected boolean isOKFinished = false;
    protected IODataStream[] m_object = null;
    protected String m_hostname = null;
    protected String m_user = null;
    protected String m_passEncrypted = null;
    protected SEvent[] m_events = null;
    protected SlaveServerCard m_ssc = null;
    protected int m_port = BM.CLIENT_PORT;
    protected Socket m_sock;
    protected SDataInputStream m_is;
    protected SDataOutputStream m_os;

    public ServerClient(SlaveServerCard ssc) {
        this(ssc.getHostName(), ssc.getPort(), ssc.getUser(), ssc.getPasswordEncrypted());
        this.m_ssc = ssc;
    }

    protected ServerClient(String hostname, int port, String user, String passEncrypted) {
        this.m_hostname = hostname;
        this.m_port = port;
        this.m_user = user;
        this.m_passEncrypted = passEncrypted;
    }

    protected void openSocket() throws Exception {
        String str;
        int res;
        this.m_sock = null;
        this.m_sock = SocketUtils.getNewSocket(120000);
        this.m_sock.connect(new InetSocketAddress(this.m_hostname, this.m_port), 10000);
        this.m_is = new SDataInputStream(this.m_sock.getInputStream());
        this.m_os = new SDataOutputStream(this.m_sock.getOutputStream(), this.m_ssc.getDetectedServerProtocolVersion());
        if (this.m_ssc.isTLS()) {
            this.m_ssc.setDetectedServerProtocolVersion(1);
            this.m_os.writeUTF("+");
            this.m_os.flush();
            this.m_sock = TlsUtils.upgradeClientSocket(this.m_sock, ServerEngine.getInstance().getCertificateManager());
        }
        if ((res = this.processServerQuestion(str = this.m_is.readUTF(), this.m_os, this.m_is)) != 0) {
            throw new RuntimeException("login failed");
        }
    }

    protected Object runBatch() {
        this.m_result = null;
        this.isOKFinished = false;
        this.isFinished = false;
        try {
            this.runCommand(this.m_is, this.m_os);
        }
        catch (Throwable e) {
            if (this.m_sock == null || this.m_sock.isClosed()) {
                try {
                    this.openSocket();
                    this.runCommand(this.m_is, this.m_os);
                }
                catch (Throwable e1) {
                    RTLogger.print(1, "error processing " + this.m_command + " " + e.getMessage());
                    RTLogger.print(2, "", e);
                }
            } else {
                RTLogger.print(1, "error processing " + this.m_command + " " + e.getMessage());
                RTLogger.print(2, "", e);
            }
        }
        finally {
            this.isFinished = true;
        }
        return this.m_result;
    }

    public boolean run(String command, String action, String[] parameters) {
        this.m_command = command;
        this.m_action = action;
        this.m_parameters = parameters;
        this.isOKFinished = false;
        return this.runSync();
    }

    public boolean run(String command, String action, IODataStream[] objects) {
        this.m_command = command;
        this.m_action = action;
        this.m_object = objects;
        this.isOKFinished = false;
        return this.runSync();
    }

    public void start(String command, String action, String[] parameters) {
        this.setName("SC " + command);
        this.m_command = command;
        this.m_action = action;
        this.m_parameters = parameters;
        this.isOKFinished = false;
        this.start();
    }

    public void start(String command, String action, IODataStream[] objects) {
        this.setName("SC " + command);
        this.m_command = command;
        this.m_action = action;
        this.m_object = objects;
        this.isOKFinished = false;
        this.start();
    }

    public void start(String command, String action, SEvent[] objects) {
        this.setName("SC " + command);
        this.m_command = command;
        this.m_action = action;
        this.m_events = objects;
        this.isOKFinished = false;
        this.start();
    }

    @Override
    public void run() {
        try {
            this.setName("SC" + this.m_hostname);
            if (!this.runSync()) {
                this.m_ssc.handleFailedCommand(this);
            }
        }
        finally {
            this.isFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String checkConnection(String hostname, int port, String user, String passEncrypted) {
        SDataOutputStream os;
        SDataInputStream is;
        Socket sock;
        Object error;
        block8: {
            error = null;
            ServerClient sc = new ServerClient(hostname, port, user, passEncrypted);
            sock = null;
            is = null;
            os = null;
            try {
                sock = SocketUtils.getNewSocket(30000);
                InetSocketAddress srvAddr = new InetSocketAddress(hostname, port);
                sock.connect(srvAddr, 10000);
                is = new SDataInputStream(sock.getInputStream());
                os = new SDataOutputStream(sock.getOutputStream(), is.getLastProtocolVersion());
                String str = is.readUTF();
                os.setVersion(is.getLastProtocolVersion());
                int res = 0;
                try {
                    res = sc.processServerQuestion(str, os, is);
                }
                catch (RuntimeException e) {
                    error = e.getMessage();
                }
                if (res != 0) break block8;
                os.writeUTF("EXIT");
            }
            catch (UnknownHostException e) {
                error = "UnknownHost: " + hostname;
                SocketUtils.closeSocket(sock, os, is);
            }
            catch (IOException e2) {
                error = "IOError: " + e2.getMessage();
                {
                    catch (Throwable throwable) {
                        SocketUtils.closeSocket(sock, os, is);
                        throw throwable;
                    }
                }
                SocketUtils.closeSocket(sock, os, is);
            }
        }
        SocketUtils.closeSocket(sock, os, is);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSync() {
        long delta;
        SDataOutputStream os;
        SDataInputStream is;
        Socket sock;
        block9: {
            if (!this.m_ssc.getSlaveServerClient().isOnline()) {
                String msg = "Slave server \"" + this.m_hostname + "\" is offline. Discarded cmd: " + this.m_command;
                if ("ACTION".equals(this.m_command)) {
                    this.m_result = "Slave server \"" + this.m_hostname + "\" is offline.";
                }
                RTLogger.print(3, msg);
                this.isFinished = true;
                return this.isOKFinished;
            }
            long startCommand = 0L;
            sock = null;
            is = null;
            os = null;
            try {
                sock = SocketUtils.getNewSocket(60000);
                sock.connect(new InetSocketAddress(this.m_hostname, this.m_port), 10000);
                is = new SDataInputStream(sock.getInputStream());
                os = new SDataOutputStream(sock.getOutputStream(), this.m_ssc.getDetectedServerProtocolVersion());
                sock.setSoTimeout(10000);
                String str = is.readUTF();
                os.setVersion(is.getLastProtocolVersion());
                int res = this.processServerQuestion(str, os, is);
                if (res == 0) {
                    sock.setSoTimeout(60000);
                    startCommand = System.currentTimeMillis();
                    this.runCommand(is, os);
                    os.writeUTF("EXIT");
                } else {
                    this.isOKFinished = false;
                }
                this.isFinished = true;
                delta = 0L;
                if (startCommand <= 0L) break block9;
            }
            catch (Throwable e) {
                long delta2;
                block10: {
                    try {
                        this.isOKFinished = false;
                        this.m_result = e.getMessage();
                        RTLogger.print(3, "", e);
                        this.isFinished = true;
                        delta2 = 0L;
                        if (startCommand <= 0L) break block10;
                    }
                    catch (Throwable throwable) {
                        this.isFinished = true;
                        long delta3 = 0L;
                        if (startCommand > 0L) {
                            delta3 = System.currentTimeMillis() - startCommand;
                        }
                        RTLogger.print(3, this.m_command + " is finished. pt=" + delta3);
                        SocketUtils.closeSocket(sock, os, is);
                        throw throwable;
                    }
                    delta2 = System.currentTimeMillis() - startCommand;
                }
                RTLogger.print(3, this.m_command + " is finished. pt=" + delta2);
                SocketUtils.closeSocket(sock, os, is);
            }
            delta = System.currentTimeMillis() - startCommand;
        }
        RTLogger.print(3, this.m_command + " is finished. pt=" + delta);
        SocketUtils.closeSocket(sock, os, is);
        return this.isOKFinished;
    }

    protected void runCommand(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        RTLogger.print(4, this.m_command + " is started");
        Integer codeI = CMDS.m_acceptable.get(this.m_command);
        int code = -1;
        if (codeI != null) {
            code = codeI;
        }
        boolean processed = true;
        switch (code) {
            case 17: {
                this.requestJOB(is, os);
                break;
            }
            case 24: {
                this.requestAgentCards(is, os);
                break;
            }
            case 27: {
                this.requestPolicies(is, os);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                this.requestAllAssignments(is, os);
                break;
            }
            case 35: {
                this.requestFile(is, os);
                break;
            }
            case 36: {
                this.requestFileSlave(is, os);
                break;
            }
            case 30: 
            case 204: {
                this.pushFile(is, os);
                break;
            }
            case 32: {
                this.policyTreeUpdate(is, os);
                break;
            }
            case 256: {
                this.policyTreeUpdate2(is, os);
                break;
            }
            case 34: {
                this.assignmentTreeUpdate2(is, os);
                break;
            }
            case 31: {
                this.deleteFile(is, os);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 117: {
                this.deploy(is, os);
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                this.acknmsg(is, os);
                break;
            }
            case 56: {
                this.processGetAssigned(is, os);
                break;
            }
            case 37: {
                break;
            }
            case 58: {
                this.updateAction(is, os);
                break;
            }
            case 71: {
                this.m_command = "GET_ACKN_IDSA";
                this.getAcknIDsA(is, os);
                break;
            }
            case 73: {
                this.getAcknIDs(is, os);
                break;
            }
            case 74: {
                this.getAcknIDsA(is, os);
                break;
            }
            case 76: {
                this.getHelps(is, os);
                break;
            }
            case 77: {
                this.processGetHelp(is, os);
                break;
            }
            case 78: {
                this.getVersions(is, os);
                break;
            }
            case 80: {
                this.getUsers(is, os);
                break;
            }
            case 81: {
                this.getUserRoles(is, os);
                break;
            }
            case 82: {
                this.getUItems(is, os);
                break;
            }
            case 79: {
                this.getUserRole(is, os);
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                this.processObjects(is, os);
                break;
            }
            case 89: {
                this.processGetAnnotation(is, os);
                break;
            }
            case 90: {
                this.processPutAnnotation(is, os);
                break;
            }
            case 59: {
                this.processUpdateActionTree(is, os);
                break;
            }
            case 65: {
                this.processPutFile(is, os);
                break;
            }
            case 67: 
            case 118: {
                this.processDeleteFile(is, os);
                break;
            }
            case 66: {
                this.processRenameFile(is, os);
                break;
            }
            case 68: {
                this.processCreateFile(is, os);
                break;
            }
            case 69: {
                this.processCreateFolder(is, os);
                break;
            }
            case 70: {
                this.processRenameFile(is, os);
                break;
            }
            case 51: 
            case 127: {
                this.processDeploymentTrigger(is, os);
                break;
            }
            case 52: {
                this.processDeploymentCancel(is, os);
                break;
            }
            case 16: {
                this.processRemoteAction(is, os);
                break;
            }
            case 101: {
                this.getAgentInventoryCard(is, os);
                break;
            }
            case 102: {
                this.processTriggerAgentInventory(is, os);
                break;
            }
            case 100: {
                this.processGetArchived(is, os);
                break;
            }
            case 110: {
                this.processUpdateIndications(is, os);
                break;
            }
            case 106: {
                this.processMasterUpdate(is, os);
                break;
            }
            case 97: {
                this.processRenamePolicyHistory(is, os);
                break;
            }
            case 113: {
                this.processGetAgentVersions(is, os);
                break;
            }
            case 125: {
                this.processSendCommandToUI(is, os);
                break;
            }
            case 114: {
                this.processGetPolicyVersions(is, os);
                break;
            }
            case 128: 
            case 129: {
                this.getDirHash(is, os);
                break;
            }
            case 116: {
                this.processValidate(is, os);
                break;
            }
            case 131: 
            case 132: {
                this.processOwnDisown(is, os);
                break;
            }
            case 200: {
                this.getMemAnnotations(is, os);
                break;
            }
            case 134: {
                ScGetServerPolicy scgsop = new ScGetServerPolicy(null, this.m_action);
                this.m_result = scgsop;
                scgsop.runDirect(is, os);
                this.isOKFinished = scgsop.isSuccess();
                break;
            }
            case 139: {
                ScGetAgentOutagePolicy scgaop = new ScGetAgentOutagePolicy(null, this.m_action);
                this.m_result = scgaop;
                scgaop.runDirect(is, os);
                this.isOKFinished = scgaop.isSuccess();
                break;
            }
            case 144: {
                ScGetModifyServerPolicy scm = new ScGetModifyServerPolicy(null, this.m_action);
                this.m_result = scm;
                scm.runDirect(is, os);
                this.isOKFinished = scm.isSuccess();
                break;
            }
            case 230: {
                ScGetExtendedServerPolicy scext = new ScGetExtendedServerPolicy(null, this.m_action);
                this.m_result = scext;
                scext.runDirect(is, os);
                this.isOKFinished = scext.isSuccess();
                break;
            }
            case 138: {
                ScGetServerPolicies scsps = new ScGetServerPolicies(null);
                this.m_result = scsps;
                scsps.runDirect(is, os);
                this.isOKFinished = scsps.isSuccess();
                break;
            }
            case 143: {
                ScGetAgentServerPolicies scaos = new ScGetAgentServerPolicies(null);
                this.m_result = scaos;
                scaos.runDirect(is, os);
                this.isOKFinished = scaos.isSuccess();
                break;
            }
            case 148: {
                ScGetModifyServerPolicies scmps = new ScGetModifyServerPolicies(null);
                this.m_result = scmps;
                scmps.runDirect(is, os);
                this.isOKFinished = scmps.isSuccess();
                break;
            }
            case 234: {
                ScGetExtendedServerPolicies scmpse = new ScGetExtendedServerPolicies(null);
                this.m_result = scmpse;
                scmpse.runDirect(is, os);
                this.isOKFinished = scmpse.isSuccess();
                break;
            }
            case 157: {
                ScGetSlaves scSL = new ScGetSlaves(null);
                this.m_result = scSL;
                scSL.runDirect(is, os);
                this.isOKFinished = scSL.isSuccess();
                break;
            }
            default: {
                processed = false;
            }
        }
    }

    private void processValidate(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processOwnDisown(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        String statusO = is.readUTF();
        if (statusO.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processGetHelp(SDataInputStream is, SDataOutputStream os) {
        try {
            os.writeUTF(this.m_command);
            os.writeUTF(this.m_action);
            String help = is.readUTF();
            String res = is.readUTF();
            if (help != null && help.length() > 0) {
                this.m_result = help;
                this.isOKFinished = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void getMemAnnotations(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_MEM_ANNOTATIONS");
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            this.m_result = null;
            this.isOKFinished = false;
        } else {
            long start = System.currentTimeMillis();
            os.writeUTF("GET_MEM_ANNOTATIONS");
            String filter = "";
            os.writeUTF(filter);
            os.writeUTF(this.m_action);
            HashMapMap<String, Annotation> annotations = new HashMapMap<String, Annotation>();
            while (is.readBoolean()) {
                String id = is.readUTF();
                int size = is.readInt();
                for (int i = 0; i < size; ++i) {
                    String annot = is.readUTF();
                    Annotation aaa = Annotation.parseString(annot);
                    annotations.putV(id, aaa);
                }
            }
            ServerEngine.getInstance().getDB().saveAnnotations(annotations);
            RTLogger.print(5, "MassAnot time = " + (System.currentTimeMillis() - start));
        }
    }

    private void getDirHash(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processGetPolicyVersions(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("GET_POLICY_VERSIONS");
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
    }

    private void processGetAgentVersions(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GET_AGENT_VERSIONS");
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            this.m_result = null;
            this.isOKFinished = false;
        } else {
            os.writeUTF("GET_AGENT_VERSIONS");
            String versions = is.readUTF();
            this.m_result = versions;
            String status = is.readUTF();
            if (status.equals("T")) {
                this.isOKFinished = true;
            }
        }
    }

    private void processSendCommandToUI(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("SEND_CMD");
        os.writeUTF(this.m_action);
        if (this.m_parameters != null && this.m_parameters.length > 0) {
            os.writeUTF(this.m_parameters[0]);
            os.writeInt(this.m_parameters.length - 1);
            for (int i = 1; i < this.m_parameters.length; ++i) {
                os.writeUTF(this.m_parameters[i]);
            }
        } else {
            os.writeUTF("");
            os.writeInt(0);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        } else {
            this.m_result = status;
        }
        this.isFinished = true;
    }

    private void processRenamePolicyHistory(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("RENAME_POLICYHISTORY");
        os.writeUTF(this.m_parameters[0]);
        os.writeUTF(this.m_parameters[1]);
        String validation = is.readUTF();
        if (!validation.equals("T")) {
            this.m_result = null;
            this.isOKFinished = false;
        }
    }

    private void processGetArchived(SDataInputStream is, SDataOutputStream os) throws IOException {
        ArchiveDetails ad = new ArchiveDetails();
        os.writeUTF("GET_ARCHIVED");
        os.writeLong(Long.parseLong(this.m_parameters[0]));
        os.writeLong(Long.parseLong(this.m_parameters[1]));
        os.writeUTF(this.m_parameters[2]);
        int bbbSize = -1;
        while ((bbbSize = is.readInt()) > 0) {
            byte[] bbi = new byte[bbbSize];
            is.readFully(bbi);
            ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
            SDataInputStream byteIS = new SDataInputStream(bis);
            while (byteIS.readBoolean()) {
                SEventFwd e = new SEventFwd();
                e.readSv2(byteIS);
                ad.m_events.add(e);
            }
        }
        ad.m_restRecords = is.readInt();
        ad.m_minStime = is.readLong();
        is.readUTF();
        this.m_result = ad;
    }

    private void processUpdateIndications(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("UPDATE_INDICATION");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            this.m_result = "Slave: unsupported command: UPDATE_INDICATION";
        } else if (this.m_events != null && this.m_events.length != 0) {
            int i;
            os.writeUTF("UPDATE_INDICATION");
            os.writeBoolean(i < this.m_events.length);
            for (i = 0; i < this.m_events.length; ++i) {
                SEvent se = this.m_events[i];
                if (se instanceof SEventFwd) {
                    SEventFwd sef = (SEventFwd)se;
                    sef.sendSv2(os);
                } else {
                    se.sendS(os);
                }
                os.writeBoolean(i + 1 < this.m_events.length);
            }
            String string = is.readUTF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMasterUpdate(SDataInputStream is, SDataOutputStream os) throws IOException {
        block16: {
            os.writeUTF("VALIDATE_CMD");
            os.writeUTF("MASTER_UPDATE");
            String validation = is.readUTF();
            if (validation.equals("F")) {
                this.m_result = "Slave: unsupported command: MASTER_UPDATE";
            } else {
                if (this.m_parameters == null || this.m_parameters.length != 1) {
                    throw new IOException("MASTER_UPDATE - Wrong arguments!");
                }
                File ff = null;
                try {
                    os.writeUTF("MASTER_UPDATE");
                    os.writeUTF(this.m_action);
                    ff = new File(this.m_parameters[0]);
                    try (FileInputStream fis2 = new FileInputStream(ff);){
                        os.writeFile(fis2);
                    }
                    catch (Throwable fis2) {
                        // empty catch block
                    }
                    String status = is.readUTF();
                    if (status.equals("T")) {
                        this.isOKFinished = true;
                        SEventFwd sm = SMessage.createMessage(1, 0, this.m_hostname, "BOOM_SERVER", this.m_action, "BOOM Server", "Master update action finished.");
                        sm.setState('A');
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                        break block16;
                    }
                    SEventFwd sm = SMessage.createMessage(3, 0, this.m_hostname, "BOOM_SERVER", this.m_action, "BOOM Server", "Master update action failed.");
                    ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                    this.m_result = "Unexpected error";
                }
                catch (Throwable e) {
                    SEventFwd sm = SMessage.createMessage(3, 0, this.m_hostname, "BOOM_SERVER", this.m_action, "BOOM Server", "Master update action failed.\n" + e.getMessage());
                    ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                    this.m_result = e.getMessage();
                }
            }
        }
    }

    private void processTriggerAgentInventory(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("TRIGGER_AGENT_INVENTORY_CARD");
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        this.isOKFinished = true;
    }

    private void getAgentInventoryCard(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF("GET_AGENT_INVENTORY_CARD");
        os.writeUTF(this.m_action);
        AgentInventoryCard aci = new AgentInventoryCard(this.m_action);
        aci.read(is);
        String status = is.readUTF();
        this.m_result = aci;
        this.isOKFinished = true;
    }

    private void processGetAssigned(SDataInputStream is, SDataOutputStream os) throws IOException {
        int i;
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        ArrayList<Object> response = new ArrayList<Object>();
        String firstStr = is.readUTF();
        if (firstStr.equals("F")) {
            return;
        }
        response.add(firstStr);
        int size = is.readInt();
        response.add(size);
        for (i = 0; i < size; ++i) {
            response.add(is.readUTF());
            response.add(is.readUTF());
        }
        response.add(is.readUTF());
        size = is.readInt();
        response.add(size);
        for (i = 0; i < size; ++i) {
            response.add(is.readUTF());
            response.add(is.readUTF());
        }
        response.add(is.readUTF());
        size = is.readInt();
        response.add(size);
        for (i = 0; i < size; ++i) {
            response.add(is.readUTF());
            response.add(is.readUTF());
            response.add(is.readUTF());
            response.add(is.readInt());
        }
        response.add(is.readUTF());
        this.m_result = response;
        this.isOKFinished = true;
    }

    private void processRemoteAction(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_parameters[0]);
        os.writeUTF(this.m_parameters[1]);
        int seconds = Integer.parseInt(this.m_parameters[2]);
        os.writeInt(seconds);
        this.m_result = is.readUTF();
        String okFlag = is.readUTF();
        this.isOKFinished = true;
    }

    private void processDeploymentTrigger(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        String status = is.readUTF();
        this.isOKFinished = true;
    }

    private void processDeploymentCancel(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        String status = is.readUTF();
        this.isOKFinished = true;
    }

    private void processPutFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        try (FileInputStream fis2 = new FileInputStream(this.m_parameters[0]);){
            os.writeFile(fis2);
        }
        catch (Throwable fis2) {
            // empty catch block
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processDeleteFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processRenameFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processCreateFile(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processCreateFolder(SDataInputStream is, SDataOutputStream os) throws IOException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processUpdateActionTree(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processGetAnnotation(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        int expected = is.readInt();
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < expected; ++i) {
            al.add(is.readUTF());
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processPutAnnotation(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeUTF(this.m_parameters[0]);
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void processObjects(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_object.length);
        for (int i = 0; i < this.m_object.length; ++i) {
            this.m_object[i].send(os);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = "Success";
        } else {
            this.m_result = "Failed";
        }
        this.isFinished = true;
    }

    private void getHelps(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        HashMap<String, String> helps = new HashMap<String, String>();
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            String id = is.readUTF();
            String help = is.readUTF();
            helps.put(id, help);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = helps;
        }
        this.isFinished = true;
    }

    private void requestJOB(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        os.writeInt(this.m_parameters.length);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            os.writeUTF(this.m_parameters[i]);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (RuntimeException i) {
            // empty catch block
        }
        String OK = is.readUTF();
        if (OK.equals("T")) {
            this.isOKFinished = true;
            RTLogger.print(3, "JOB is done");
        } else {
            RTLogger.print(3, "JOB FAILED");
        }
        this.isFinished = true;
    }

    private void requestAgentCards(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        ArrayList<AgentCard> al = new ArrayList<AgentCard>();
        os.writeUTF(this.m_command);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            AgentCard ac = new AgentCard();
            ac.read(is);
            al.add(ac);
            RTLogger.print(5, "AC: " + String.valueOf(ac) + " " + ac.getMode());
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void requestPolicies(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        long size = is.readLong();
        File zipFile = new File("tmp" + System.currentTimeMillis());
        is.readFile(zipFile.getCanonicalPath());
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void requestAllAssignments(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        boolean hasMore = false;
        ArrayList<Object> result = new ArrayList<Object>();
        while (hasMore = is.readBoolean()) {
            Assignment asn = new Assignment();
            result.add(asn.read(is));
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = result;
        }
        this.isFinished = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException {
        int res = 0;
        if (!question.equalsIgnoreCase("login")) {
            if (!question.equalsIgnoreCase("valid")) return res;
            RTLogger.print(1, "Login is still valid");
            return 7;
        }
        os.writeUTF(this.m_user);
        String nextToken = is.readUTF();
        if (!nextToken.equalsIgnoreCase("password")) throw new RuntimeException("login name unknown");
        os.writeUTF(this.m_passEncrypted);
        String response = is.readUTF();
        if (!response.equals("OK")) throw new RuntimeException(response);
        return res;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isSuccess() {
        return this.isOKFinished;
    }

    public Object getResultObject() {
        return this.m_result;
    }

    private void deploy(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        int size = this.m_parameters.length / 2;
        RTLogger.print(5, "sizeofdeploy=" + size);
        os.writeInt(size);
        for (int i = 0; i < this.m_parameters.length; i += 2) {
            String objectType = this.m_parameters[i];
            String objectName = this.m_parameters[i + 1];
            os.writeUTF(objectType);
            os.writeUTF(objectName);
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        this.isOKFinished = status.equals("T");
        this.isFinished = true;
    }

    private void acknmsg(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        int i = 0;
        int max = 10000;
        while (i < this.m_parameters.length) {
            os.writeUTF(this.m_command);
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < max && i < this.m_parameters.length; ++i, ++j) {
                sb.append(this.m_parameters[i]);
                sb.append(',');
            }
            os.writeUTF(sb.toString());
            this.m_result = is.readUTF();
            String status = is.readUTF();
            if (status.equals("T")) {
                this.isOKFinished = true;
                continue;
            }
            this.isOKFinished = false;
            break;
        }
    }

    private void requestFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        Object dir = this.m_parameters[2];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        String filename = is.readUTF();
        long size = is.readLong();
        File wFile = null;
        if (size >= 0L) {
            File dirF;
            RTLogger.print(5, "F: " + filename + " size=" + size);
            String addDir = "";
            if (filename.indexOf(47) != -1) {
                addDir = filename.substring(0, filename.lastIndexOf(47));
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                if (addDir.length() > 0 && addDir.charAt(0) == '/') {
                    addDir = addDir.substring(1);
                }
            }
            if (!((String)dir).endsWith("/") && !((String)dir).endsWith("\\")) {
                dir = (String)dir + "/";
            }
            if (!(dirF = new File((String)dir + addDir)).exists()) {
                dirF.mkdirs();
            }
            wFile = new File(dirF, filename);
            if (size > 0L) {
                is.readFile(wFile.getCanonicalPath());
            } else {
                wFile.delete();
                wFile.createNewFile();
            }
        } else {
            RTLogger.print(5, "Requested file not found. Object name: " + objectName + " type=" + objectType);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size >= 0L;
            this.m_result = wFile;
        }
        this.isFinished = true;
    }

    private void requestFileSlave(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        String slaveServer = this.m_parameters[2];
        Object dir = this.m_parameters[3];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        os.writeUTF(slaveServer);
        String filename = is.readUTF();
        long size = is.readLong();
        File wFile = null;
        if (size >= 0L) {
            File dirF;
            RTLogger.print(5, "F: " + filename + " size=" + size);
            String addDir = "";
            if (filename.indexOf(47) != -1) {
                addDir = filename.substring(0, filename.lastIndexOf(47));
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                if (addDir.length() > 0 && addDir.charAt(0) == '/') {
                    addDir = addDir.substring(1);
                }
            }
            if (!((String)dir).endsWith("/") && !((String)dir).endsWith("\\")) {
                dir = (String)dir + "/";
            }
            if (!(dirF = new File((String)dir + addDir)).exists()) {
                dirF.mkdirs();
            }
            wFile = new File(dirF, filename);
            if (size > 0L) {
                is.readFile(wFile.getCanonicalPath());
            } else {
                wFile.delete();
                wFile.createNewFile();
            }
        } else {
            RTLogger.print(5, "Requested file not found. Object name: " + objectName + " type=" + objectType);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size >= 0L;
            this.m_result = wFile;
        }
        this.isFinished = true;
    }

    protected void getVersions(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        int size = is.readInt();
        ArrayList<String> versions = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            versions.add(is.readUTF());
        }
        Collections.sort(versions, new VersionComparator());
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = size != 0;
            this.m_result = versions;
        }
        this.isFinished = true;
    }

    private void pushFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String objectName = this.m_parameters[0];
        String objectType = this.m_parameters[1];
        String file = this.m_parameters[2];
        String treePath = this.m_parameters[3];
        os.writeUTF(this.m_command);
        os.writeUTF(objectName);
        os.writeUTF(objectType);
        File f = new File(file);
        long size = f.length();
        os.writeUTF(f.getName());
        os.writeUTF(treePath);
        os.writeLong(size);
        try (FileInputStream fis2 = new FileInputStream(f);){
            os.writeFile(fis2);
        }
        catch (Throwable fis2) {
            // empty catch block
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    @Deprecated
    private void policyTreeUpdate(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String treePath = this.m_parameters[0];
        String newElement = this.m_parameters[1];
        String action = this.m_parameters[2];
        os.writeUTF(this.m_command);
        os.writeUTF(treePath);
        os.writeUTF(newElement);
        os.writeUTF(action);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void policyTreeUpdate2(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        String treePath = this.m_parameters[0];
        String newElement = this.m_parameters[1];
        String action = this.m_parameters[2];
        String type = this.m_parameters[3];
        os.writeUTF(this.m_command);
        os.writeUTF(treePath);
        os.writeUTF(newElement);
        os.writeUTF(action);
        os.writeUTF(type);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    @Deprecated
    private void assignmentTreeUpdate(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 3);
        for (int i = 0; i < size; i += 3) {
            String treePath = this.m_parameters[i];
            String newElement = this.m_parameters[i + 1];
            String action = this.m_parameters[i + 2];
            os.writeUTF(treePath);
            os.writeUTF(newElement);
            os.writeUTF(action);
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void assignmentTreeUpdate2(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 4);
        for (int i = 0; i < size; i += 4) {
            String treePath = this.m_parameters[i];
            String newElement = this.m_parameters[i + 1];
            String action = this.m_parameters[i + 2];
            String type = this.m_parameters[i + 3];
            os.writeUTF(treePath);
            os.writeUTF(newElement);
            os.writeUTF(action);
            os.writeUTF(type);
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void deleteFile(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        int size = this.m_parameters.length;
        os.writeInt(size / 3);
        for (int i = 0; i < size; i += 3) {
            String name = this.m_parameters[i];
            String type = this.m_parameters[i + 1];
            String filename = this.m_parameters[i + 2];
            os.writeUTF(name);
            os.writeUTF(type);
            os.writeUTF(filename);
        }
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void updateAction(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_action);
        this.m_object[0].send(os);
        this.m_result = is.readUTF();
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void getAcknIDs(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        LinkedList<String> ids = new LinkedList<String>();
        while (is.readBoolean()) {
            String ID = is.readUTF();
            ids.add(ID);
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = ids;
        }
        this.isFinished = true;
    }

    private void getAcknIDsA(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        String allIDs_separatedByComma = is.readUTF();
        String[] ids = allIDs_separatedByComma.split(",");
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
            this.m_result = Arrays.asList(ids);
        }
        this.isFinished = true;
    }

    private void getUsers(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        ArrayList<User> al = new ArrayList<User>();
        os.writeUTF(this.m_command);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            User u = new User();
            u.read(is);
            al.add(u);
            RTLogger.print(5, "User: " + String.valueOf(u));
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void getUserRoles(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        ArrayList<UserRole> al = new ArrayList<UserRole>();
        os.writeUTF(this.m_command);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            UserRole u = UserRole.createNewRole();
            u.read(is);
            al.add(u);
            RTLogger.print(5, "UserRole: " + String.valueOf(u));
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void getUItems(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        ArrayList<UItem> al = new ArrayList<UItem>();
        os.writeUTF(this.m_command);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            UItem u = new UItem(new HashMap());
            u.read(is);
            al.add(u);
            RTLogger.print(5, "UItem: " + String.valueOf(u));
        }
        this.m_result = al;
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }

    private void getUserRole(SDataInputStream is, SDataOutputStream os) throws IOException, InterruptedException {
        os.writeUTF(this.m_command);
        os.writeUTF(this.m_parameters[0]);
        String isOK = is.readUTF();
        if (isOK.equals("T")) {
            UserRole urole = UserRole.createNewRole();
            this.m_result = urole.read(is);
        } else {
            this.m_result = isOK;
        }
        String status = is.readUTF();
        if (status.equals("T")) {
            this.isOKFinished = true;
        }
        this.isFinished = true;
    }
}

