/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.log.RTLogger;
import com.blixx.server.ServerClient;
import com.blixx.server.SlaveServerCard;
import com.blixx.shared.IODataStream;
import com.blixx.shared.SEventFwd;
import com.boom.SocketUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerClientQ
extends ServerClient {
    protected static final String PING = "PING";
    protected AtomicBoolean m_running = new AtomicBoolean(true);
    protected AtomicBoolean isONLINE = new AtomicBoolean(false);

    public ServerClientQ(SlaveServerCard ssc) {
        super(ssc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long lasterror = 0L;
        try {
            block9: while (this.m_running.get()) {
                try {
                    this.process();
                    try {
                        int i = 0;
                        while (true) {
                            if (i >= 30 || this.m_ssc.m_commands.size() != 0) continue block9;
                            Thread.sleep(100L);
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Throwable e) {
                    if (lasterror + 1000L >= System.currentTimeMillis()) continue;
                    lasterror = System.currentTimeMillis();
                    RTLogger.print(2, "SCQ", e);
                }
            }
            return;
        }
        catch (Exception e) {
            RTLogger.print(2, "SCQ - error", e);
            return;
        }
        finally {
            SocketUtils.closeSocket(this.m_sock, new AutoCloseable[0]);
            this.m_running.compareAndSet(true, false);
        }
    }

    private void process() {
        try {
            Object object;
            this.m_command = null;
            if (this.m_sock == null || this.m_sock.isClosed()) {
                this.openSocket();
                RTLogger.print(4, String.valueOf(this.m_ssc) + " cmd Queue size=" + this.m_ssc.m_commands.size());
            }
            if (this.m_ssc.m_commands.size() > 10) {
                RTLogger.print(4, String.valueOf(this.m_ssc) + " cmd Queue size=" + this.m_ssc.m_commands.size());
            }
            if ((object = this.m_ssc.m_commands.poll()) != null) {
                if (object instanceof CMD) {
                    this.processCMD(object);
                } else if (object instanceof com.blixx.ctrl.sc.ServerClient) {
                    this.isOKFinished = false;
                    this.isFinished = false;
                    com.blixx.ctrl.sc.ServerClient sc = (com.blixx.ctrl.sc.ServerClient)object;
                    sc.runDirect(this.m_is, this.m_os);
                    this.isOKFinished = sc.isSuccess();
                    if (!this.isOKFinished) {
                        RTLogger.print(5, "SCQ error on cmd " + sc.getCommand() + ". Result: " + String.valueOf(sc.getResultObject()));
                    }
                    this.isFinished = true;
                    sc.postProcess();
                }
            } else {
                this.m_os.writeUTF(PING);
                String sc = this.m_is.readUTF();
            }
            if (this.isONLINE.compareAndSet(false, true)) {
                RTLogger.print(1, this.m_ssc.getHostName() + " SCQ connection restored");
            }
        }
        catch (Throwable e) {
            if (this.isONLINE.compareAndSet(true, false)) {
                RTLogger.print(1, this.m_ssc.getHostName() + " SCQ failed", e);
            }
            SocketUtils.closeSocket(this.m_sock, new AutoCloseable[0]);
            this.m_ssc.handleFailedCommand(this);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.isFinished = true;
        }
    }

    private void processCMD(Object object) throws IOException, InterruptedException {
        CMD cmd = (CMD)object;
        this.m_command = cmd.m_command;
        this.m_action = cmd.m_action;
        this.m_parameters = cmd.m_params;
        this.m_object = cmd.m_objects;
        this.m_events = cmd.m_events;
        this.m_result = null;
        this.isOKFinished = false;
        this.isFinished = false;
        if (RTLogger.getCurrentLevel() >= 5) {
            StringBuffer sb = new StringBuffer();
            sb.append("Slave: ").append(this.m_hostname).append(" CMD:").append(this.m_command);
            if (this.m_action != null && this.m_action.length() < 1024) {
                sb.append(" P1:").append(this.m_action);
            }
            if (this.m_parameters != null && this.m_parameters.length > 0) {
                if (this.m_parameters.length < 100) {
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        sb.append(" A").append(i).append(':').append(this.m_parameters[i]);
                    }
                } else {
                    sb.append(" A size=").append(this.m_parameters.length);
                }
            }
            RTLogger.print(5, sb);
        }
        this.runCommand(this.m_is, this.m_os);
        this.m_ssc.handleSucessCommands(this);
    }

    public void stopClient() {
        this.m_running.set(false);
    }

    public boolean isRunning() {
        return this.m_running.get();
    }

    public boolean isOnline() {
        return this.isONLINE.get();
    }

    @Override
    public void start(String command, String action, IODataStream[] objects) {
        CMD cmd = new CMD(command, action, objects);
        this.addCMD(command, cmd);
    }

    public void start(String command, String action, SEventFwd[] objects) {
        CMD cmd = new CMD(command, action, objects);
        this.addCMD(command, cmd);
    }

    @Override
    public void start(String command, String action, String[] parameters) {
        CMD cmd = new CMD(command, action, parameters);
        this.addCMD(command, cmd);
    }

    public void start(com.blixx.ctrl.sc.ServerClient sc) {
        if (!this.m_ssc.m_commands.contains(sc)) {
            this.m_ssc.m_commands.offer(sc);
        } else {
            RTLogger.print(4, "Alredy in Queue " + String.valueOf(sc));
        }
    }

    private void addCMD(String command, CMD cmd) {
        if (!this.m_ssc.m_commands.contains(cmd)) {
            this.m_ssc.m_commands.offer(cmd);
            if (this.m_ssc.m_commands.size() > 50) {
                RTLogger.print(4, "SSC Queue size=" + this.m_ssc.m_commands.size());
            }
        } else {
            RTLogger.print(4, "Alredy in Queue " + command);
        }
    }

    @Override
    @Deprecated
    public boolean run(String command, String action, IODataStream[] objects) {
        throw new RuntimeException("Incorrect usage of ServiceClientQ");
    }

    @Override
    @Deprecated
    public boolean run(String command, String action, String[] parameters) {
        throw new RuntimeException("Incorrect usage of ServiceClientQ");
    }
}

