/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.sa.ClassPathLoader;
import com.blixx.sa.HostnameResolver;
import com.blixx.sa.IHostnameResolver;
import com.blixx.sa.NullHostnameResolver;
import com.blixx.sa.Scheduler;
import com.blixx.server.ActionsRepository;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentCertificates;
import com.blixx.server.AgentsRepository;
import com.blixx.server.BinariesRepository;
import com.blixx.server.CSRStorage;
import com.blixx.server.CertificateStateIndicationHelper;
import com.blixx.server.DeploymentManager;
import com.blixx.server.DeploymentTrigger;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.EventsRouter;
import com.blixx.server.ExternalHostResolver;
import com.blixx.server.GUIServer;
import com.blixx.server.GUIWorker;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SAssignmentRepository;
import com.blixx.server.SMessage;
import com.blixx.server.SPolicyRepository;
import com.blixx.server.Server;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.SlaveServerFactory;
import com.blixx.server.UserManager;
import com.blixx.server.audit.AuditLog;
import com.blixx.server.correlation.AgentOutageManager;
import com.blixx.server.correlation.OutageManager;
import com.blixx.server.db.DB;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DBOutage;
import com.blixx.server.ext.ForwardManager;
import com.blixx.server.jetty.JettyMain;
import com.blixx.server.jobs.ServerJobManager;
import com.blixx.server.notify.NotifierManager;
import com.blixx.server.perf.Chart01;
import com.blixx.server.perf.PerfManager;
import com.blixx.server.perf.PerfSubmitter;
import com.blixx.server.pki.BoomPKI;
import com.blixx.server.utils.CheckAgentCardsConflicts;
import com.blixx.server.utils.MaintenanceTask;
import com.blixx.server.utils.PerfDBMonitor;
import com.blixx.server.utils.UpdateDBObjectHourly;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.Interval;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.io.ByteArray;
import com.blixx.shared.utils.FileFilter;
import com.boom.SharedLocks;
import com.boom.crt.CertificateManager;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.pki.PKI;
import com.boom.pki.PKIResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ServerEngine
implements Runnable {
    private static boolean test = false;
    private static ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private static volatile ServerEngine m_this = null;
    private Server m_server = null;
    private Scheduler m_scheduler = null;
    private volatile ServerProperties m_properties = null;
    private SPolicyRepository m_policyRepository = null;
    private SAssignmentRepository m_assignmentRepository = null;
    private EventsRouter m_eventsRouter = null;
    private GUIServer m_GUIServer = null;
    private String DIR_MAIN = "";
    private DB m_db;
    private DBOutage m_db_OUTAGE;
    private ActionsRepository m_actionsRepository;
    private AgentsRepository m_agentsRepository = new AgentsRepository();
    private UserManager m_userManager = null;
    private BinariesRepository m_binRepository = null;
    private static volatile PerfSubmitter m_perfSubmitter = null;
    private ForwardManager m_forwardManager = null;
    private static String PID = null;
    private SlaveServerFactory m_slaveFactory = null;
    private final long m_startTime = System.currentTimeMillis();
    private String m_startTimeStr = null;
    private int m_GUIVersionBestFit = 200;
    private File m_GUIVersionBestFitFile = null;
    private IHostnameResolver m_hostResolver = new NullHostnameResolver();
    private DeploymentTrigger m_deployTrigger;
    private ServerJobManager m_serverJobManager = null;
    private boolean isOutOfMemory = false;
    private AuditLog m_auditLog = null;
    private CertificateManager m_certificateManager;
    private AgentCertificates agentCertificates;
    private PKI pki;
    private CSRStorage csrStorage;
    private Thread shutdownHook;
    AtomicInteger m_licenseHostObject = new AtomicInteger(0);
    ConcurrentHashMap<String, String> m_enabledAgents = new ConcurrentHashMap(10);
    public ExternalHostResolver m_externalHostResolver;

    @Deprecated
    public static synchronized ServerEngine getMockInstance() {
        if (m_this == null) {
            test = true;
            ServerEngine tmpInstance = new ServerEngine();
            tmpInstance.DIR_MAIN = ".";
            tmpInstance.initLibs();
            tmpInstance.initParameters();
            tmpInstance.initDB();
            m_this = tmpInstance;
        }
        return m_this;
    }

    @Deprecated
    public static synchronized ServerEngine getMockInstanceNoDB(DB mock, DBOutage mock_outage) {
        return ServerEngine.getMockInstanceNoDB(mock, mock_outage, ".");
    }

    public static synchronized ServerEngine getMockInstanceNoDB(DB mock, DBOutage mock_outage, String dirMain) {
        if (m_this != null) {
            m_this.stop();
        }
        test = true;
        m_this = new ServerEngine();
        ServerEngine.m_this.DIR_MAIN = dirMain;
        m_this.initLibs();
        m_this.initParameters();
        ServerEngine.m_this.m_hostResolver = new HostnameResolver(Paths.get("mockHostResolver.dat", new String[0]), true);
        ServerEngine.m_this.m_db = mock;
        ServerEngine.m_this.m_db_OUTAGE = mock_outage;
        m_this.initUserManager();
        ServerEngine.m_this.m_policyRepository = SPolicyRepository.getInstance(true);
        ServerEngine.m_this.m_binRepository = BinariesRepository.getInstance(ServerEngine.m_this.DIR_MAIN);
        ServerEngine.m_this.m_forwardManager = new ForwardManager(Paths.get(dirMain, new String[0]).resolve("srv").resolve("policies").resolve("fwd"));
        ServerEngine.m_this.m_scheduler = new Scheduler();
        ServerEngine.m_this.m_eventsRouter = new EventsRouter(m_this, Paths.get(dirMain, "srv", "srv_policies").toAbsolutePath().toString());
        ServerEngine.m_this.m_auditLog = new AuditLog();
        m_this.initScheduler();
        ServerEngine.m_this.m_assignmentRepository = new SAssignmentRepository(true);
        ServerEngine.m_this.m_agentsRepository.initAgentCards(m_this.getDB(), m_this.getScheduler());
        ServerEngine.m_this.m_agentsRepository.initHBs(m_this.getScheduler());
        ServerEngine.m_this.m_externalHostResolver = new ExternalHostResolver();
        ServerEngine.m_this.m_externalHostResolver.setAgentResolver(ServerEngine.m_this.m_agentsRepository);
        ServerEngine.m_this.m_certificateManager = new CertificateManager();
        m_this.initCertificateManager();
        m_this.initAgentCertificates();
        m_this.initServerSocket();
        m_this.startScheduler();
        return m_this;
    }

    public static ServerEngine getInstance() {
        block6: {
            if (m_this != null) {
                return m_this;
            }
            m_lock.writeLock().lock();
            try {
                if (m_this != null) break block6;
                m_this = new ServerEngine();
                try {
                    ServerEngine.m_this.DIR_MAIN = new File(".").getCanonicalPath();
                    ServerEngine.storePID();
                }
                catch (IOException e) {
                    System.out.println("Error=-99. Can't start server");
                    System.exit(ServerEngine.isJUnitTest() ? 0 : -99);
                }
                m_this.init();
            }
            finally {
                m_lock.writeLock().unlock();
            }
        }
        return m_this;
    }

    public static boolean isNullInstance() {
        return m_this == null;
    }

    public int stop() {
        RTLogger.print(1, "  stopping");
        if (this.getPki() != null) {
            this.getPki().stop();
        }
        if (this.getScheduler() != null) {
            this.getScheduler().deactivate();
        }
        if (this.getServer() != null) {
            this.getServer().stop();
        }
        if (this.getScheduler() != null) {
            this.getScheduler().stopScheduler();
        }
        DeploymentManager.getInstance().clean();
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        m_this = null;
        RTLogger.print(1, "  stop done");
        return 0;
    }

    public static void storePID() {
        try {
            String pidmx = ManagementFactory.getRuntimeMXBean().getName();
            try {
                pidmx = pidmx.substring(0, pidmx.indexOf(64));
                if (pidmx.indexOf(91) != -1) {
                    pidmx = pidmx.substring(pidmx.indexOf(91) + 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            PID = pidmx;
            File pidf = new File(BM.SERVER_PID_FILE);
            try (FileOutputStream fos = new FileOutputStream(pidf);){
                fos.write(PID.getBytes());
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPID() {
        return PID;
    }

    private void init() {
        try {
            this.initLibs();
            this.initParameters();
            this.m_externalHostResolver = new ExternalHostResolver();
            this.m_auditLog = new AuditLog(this.getServerProps().getLogDir(), "BOOMAudit_", this.getServerProps().getAuditLogCount(), 0x100000L * (long)this.getServerProps().getAuditLogSizeMB());
            this.m_auditLog.setEnabled(this.getServerProps().getAuditEnabled());
            RTLogger.print(1, "PID: " + this.getPID());
            this.initDB();
            if (this.getDB() == null) {
                RTLogger.print(0, "DB is offline. Server can't start. Exiting...");
                System.exit(ServerEngine.isJUnitTest() ? 0 : 1);
            }
            PerfManager.fixBoomAgentIDColumn();
            this.initPolicyRepository();
            this.initScheduler();
            this.m_agentsRepository.initAgentCards(this.getDB(), this.getScheduler());
            this.initUserManager();
            this.initForwardManager();
            this.initEventsRouter();
            this.m_hostResolver = new HostnameResolver(Paths.get(this.DIR_MAIN, new String[0]).resolve("srv").resolve("etc").resolve("hosts"), this.getServerProps().isUseHostLowercase());
            this.initCertificateManager();
            this.initAgentCertificates();
            this.startScheduler();
            this.initAssignmentRepository();
            this.initActionsRepository();
            this.m_userManager.removeZombieActions();
            if (this.m_userManager.getRights(8000, "admin") == 0) {
                Iterator<String> it = this.m_actionsRepository.getFilesIterator();
                while (it.hasNext()) {
                    try {
                        String filename = it.next();
                        this.m_userManager.addAction(filename, !it.hasNext());
                    }
                    catch (Exception e) {
                        RTLogger.print(2, "", e);
                    }
                }
            }
            this.initBinariesRepository();
            CheckAgentCardsConflicts.doCheck();
            ServerEngine.checkOutagePoliciesActivation(this);
            ServerEngine.checkAgentOutagesActivation(this);
            NotifierManager.getInstance();
            this.initServerSocket();
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable it) {
                // empty catch block
            }
            this.m_agentsRepository.initHBs(this.getScheduler());
            ServerEngine.storePID();
            this.m_deployTrigger = new DeploymentTrigger("DTTASK");
            this.getScheduler().addTask(this.m_deployTrigger, 0L);
            try {
                JettyMain.start(this.m_properties.getHTTPPort());
            }
            catch (Throwable e1) {
                RTLogger.print(1, "HTTP Server is not able to run.", e1);
            }
            MaintenanceTask mt = new MaintenanceTask("MaintenanceTask", new File("./srv/packages"));
            mt.onGetData();
            this.getScheduler().addTask(mt, 0L);
            final Chart01 chartingTask = new Chart01("charts");
            ServerThreadPool.getInstance().submit(new Runnable(){

                @Override
                public void run() {
                    chartingTask.onGetData();
                }
            });
            this.getScheduler().addTask(chartingTask, 0L);
            PerfDBMonitor mon = new PerfDBMonitor("perfDBmon", this.getDB());
            mon.setInterval(Interval.getDailyInterval(1, 1, 59));
            this.getScheduler().addTask(mon, 0L);
            this.shutdownHook = new Thread((Runnable)this, "ServerShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.m_serverJobManager = ServerJobManager.getInstance();
            this.m_userManager.setPolicyGroups(this.m_policyRepository);
            this.m_userManager.setAssignmentGroups(this.m_assignmentRepository);
            NodeGroupForwardFilter.m_RA = this.m_agentsRepository;
            try {
                Thread.sleep(5000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.initGUIServer();
            try {
                Thread.sleep(5000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_slaveFactory = new SlaveServerFactory();
            this.m_externalHostResolver.setAgentResolver(this.m_agentsRepository);
            this.m_externalHostResolver.setNodeGroupTree(NodeGroupRepository.getInstance());
            this.m_externalHostResolver.setUiNotificator(this.getEventsRouter());
            Thread ehrThread = new Thread((Runnable)this.m_externalHostResolver, "EHR");
            ehrThread.start();
            UpdateDBObjectHourly updTaskHourly = new UpdateDBObjectHourly();
            this.getScheduler().addTask(updTaskHourly, 0L);
            RTLogger.print(0, "server started. [" + this.getServerProps().getHostname() + "] [" + this.getServerProps().getServerId() + "]");
            System.out.println("server started. [" + this.getServerProps().getHostname() + "] [" + this.getServerProps().getServerId() + "]");
        }
        catch (DBException dbe) {
            RTLogger.print(1, "Error opening database connection.");
            System.err.println("Error opening database connection.");
            throw dbe;
        }
        catch (RuntimeException e) {
            RTLogger.print(1, "Initialization ERROR ", e);
            System.err.println("Initialization ERROR " + e.getMessage());
            throw e;
        }
    }

    private void initAgentCertificates() {
        this.csrStorage = new CSRStorage(this.getServerProps().getCSRStorageDir(), this.getServerProps().getCsrTTLMs());
        this.csrStorage.load();
        this.getScheduler().addTask(new CSRStorage.CleanupExpiredPKIRequests(this.csrStorage, 360), 0L);
        this.agentCertificates = new AgentCertificates(this.pki, this.csrStorage);
        this.autoCorrectTlsFlags(this.agentCertificates, this.getAgentRepository());
    }

    private void autoCorrectTlsFlags(AgentCertificates agentCertificates, AgentsRepository agtRepo) {
        agtRepo.getAgentCards().values().stream().filter(a -> !a.isTlsAgent()).forEach(ac -> {
            if (!ac.isTlsAgent() && agentCertificates.getAgentCert(ac.getAgentID()).isPresent() || "Connecting...".equals(ac.getOSName())) {
                ac.setSingleFlagON(64);
                agtRepo.saveAgentCard((AgentCard)ac);
                RTLogger.print(5, "auto-correct TLS flag (ON) for " + String.valueOf(ac));
            }
        });
    }

    private void initPKIInterface() {
        String pkiClass = this.getServerProps().getPkiClass();
        if (pkiClass == null) {
            pkiClass = BoomPKI.class.getName();
        }
        try {
            this.pki = (PKI)PKI.class.getClassLoader().loadClass(pkiClass).newInstance();
            HashMap<String, String> additionalProps = new HashMap<String, String>();
            additionalProps.put("AGENT_TS_FILE", this.getServerProps().getAgentTsFile());
            additionalProps.put("AGENT_TS_PASS_ENCODED", this.getServerProps().getAgentTsPassEncoded());
            this.pki.init(Paths.get(this.getMainDir(), new String[0]), this.getServerProps().getPkiConfigFile(), this::processCSRResponse, additionalProps);
            try {
                Path agtTsPath;
                if (this.getServerProps().getAgentTsFile() != null && Files.exists(agtTsPath = Paths.get(this.getServerProps().getAgentTsFile(), new String[0]), new LinkOption[0])) {
                    TrustStoreClient agentTs = new TrustStoreClient("PKCS12", agtTsPath, this.getServerProps().getAgentTsPassEncoded());
                    agentTs.loadKeyStore();
                    Path agtTsLegacyPass = agtTsPath.getParent().resolve("truststore_legacy.p12");
                    agentTs.saveLegacyKeyStore(agtTsLegacyPass);
                }
            }
            catch (Exception e) {
                RTLogger.print(1, "Error writing legacy PKCS12 ", e);
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Could not load PKI class " + pkiClass, e);
            throw new RuntimeException("Could not load PKI class " + pkiClass, e);
        }
    }

    public void processCSRResponse(PKIResponse response) {
        String deviceId = response.getDeviceId();
        if ("ca".equals(deviceId)) {
            boolean imported = false;
            try {
                String agentTsFile = this.getServerProps().getAgentTsFile();
                Path agentTsPath = Paths.get(agentTsFile, new String[0]);
                TrustStoreClient tsClient = this.m_certificateManager.getTsClient();
                imported = tsClient.importTrustedCACertificate(response.getSignedCertificate());
                if (imported) {
                    tsClient.saveKeyStore();
                    CertificateStateIndicationHelper.sendTrustedCAImported();
                }
                if (imported || !Files.exists(agentTsPath, new LinkOption[0]) || !Files.isRegularFile(agentTsPath, new LinkOption[0])) {
                    this.importCACertificateIntoTsForAgents(response.getSignedCertificate());
                }
            }
            catch (Exception e) {
                RTLogger.print(1, "Could not import CA certificate" + new String(response.getSignedCertificate()), e);
            }
            try {
                if (imported && !this.m_certificateManager.getKsClient().isSelfSignedCertificate("server")) {
                    this.updateServerCertificate();
                }
            }
            catch (Exception e) {
                RTLogger.print(1, "Could not update server certificate after CA certificate update" + new String(response.getSignedCertificate()), e);
            }
        } else if ("server".equalsIgnoreCase(deviceId)) {
            try {
                this.m_certificateManager.storeServerCertificate(response.getSignedCertificate());
                CertificateStateIndicationHelper.sendServerCertImported();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                String payload = new String(response.getSignedCertificate());
                RTLogger.print(4, "Cannot store server certificate " + payload, e);
                CertificateStateIndicationHelper.sendServerSignedCertificateCorrupt(payload);
            }
        } else {
            AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(deviceId);
            if (ac != null) {
                try {
                    this.agentCertificates.storeAndSendSignedCertToAgent(ac, response.getSignedCertificate());
                }
                catch (Exception e) {
                    RTLogger.print(2, "Error process agent's signed certificate", e);
                    ac.sendAgentCertificateError("Error processing agent's signed certificate. [" + new String(response.getSignedCertificate()) + "]");
                }
            } else {
                RTLogger.print(1, "can't import signed certificate for unknown agent ID=" + deviceId + ". [" + new String(response.getSignedCertificate()) + "]");
            }
        }
    }

    private void updateServerCertificate() throws Exception {
        ServerProperties serverProps = this.getServerProps();
        Path newKsFile = this.getCertificateManager().getRenewalKeyStore().getKeyStorePath();
        CertificateManager tmpCertManager = new CertificateManager();
        Optional<ByteArray> optionalCSR = tmpCertManager.initServerKeyStore(serverProps.getHostname(), serverProps.getClusterName(), serverProps.getClusterIP(), newKsFile.toAbsolutePath().toString(), serverProps.getKsPassEncoded(), serverProps.getAllServerIPs(), serverProps.getAllHostnames());
        if (optionalCSR.isPresent()) {
            CertificateStateIndicationHelper.sendSendingServerCSRtoPKI();
            this.pki.processCSR("server", optionalCSR.get().getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCACertificateIntoTsForAgents(byte[] caCertificate) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        String agentTsFile = this.getServerProps().getAgentTsFile();
        Path agentTsPath = Paths.get(agentTsFile, new String[0]);
        Path agentTsDir = agentTsPath.toAbsolutePath().getParent();
        if (!Files.exists(agentTsDir, new LinkOption[0]) || !Files.isDirectory(agentTsDir, new LinkOption[0])) {
            Files.createDirectories(agentTsDir, new FileAttribute[0]);
        }
        SharedLocks.agentTsFileLock.writeLock().lock();
        try {
            String agtTsPass = this.getServerProps().getAgentTsPassEncoded();
            if (ServerEngine.isJUnitTest() && (agtTsPass == null || agtTsPass.isEmpty())) {
                agtTsPass = Cryptor.encrypt4("changeit");
            }
            TrustStoreClient caTS = new TrustStoreClient(KeyStoreUtils.getKeyStoreType(agentTsFile), agentTsPath, agtTsPass);
            if (Files.exists(agentTsPath, new LinkOption[0])) {
                caTS.loadKeyStore();
            } else {
                RTLogger.print(1, "Truststore for agents doesn't exist, creating a new one " + agentTsPath.toAbsolutePath().toString());
                caTS.createKeyStore();
            }
            caTS.importTrustedCACertificate(caCertificate);
            caTS.saveKeyStore();
        }
        finally {
            SharedLocks.agentTsFileLock.writeLock().unlock();
        }
        RTLogger.print(1, "Truststore for agents has been created");
    }

    private void initCertificateManager() {
        this.m_certificateManager = new CertificateManager();
        try {
            String tsPass = this.getServerProps().getTsPassEncoded();
            String tsFile = this.getServerProps().getTsFile();
            if (ServerEngine.isJUnitTest()) {
                if (tsFile == null || tsFile.isEmpty()) {
                    tsFile = Paths.get(this.DIR_MAIN, new String[0]).resolve("srv").resolve("etc").resolve("truststore.p12").toString();
                }
                if (tsPass == null || tsPass.isEmpty()) {
                    tsPass = Cryptor.encrypt4("changeit");
                }
            }
            this.m_certificateManager.initTrustStore(tsFile, tsPass);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error init certificate manager trust store", e);
            e.printStackTrace();
            System.exit(ServerEngine.isJUnitTest() ? 0 : 41);
        }
        Optional<Object> optionalCSR = Optional.empty();
        try {
            String ksPass = this.getServerProps().getKsPassEncoded();
            String ksFile = this.getServerProps().getKsFile();
            if (ServerEngine.isJUnitTest()) {
                if (ksFile == null || ksFile.isEmpty()) {
                    ksFile = Paths.get(this.DIR_MAIN, new String[0]).resolve("srv").resolve("etc").resolve("keystore.p12").toString();
                }
                if (ksPass == null || ksPass.isEmpty()) {
                    ksPass = Cryptor.encrypt4("changeit");
                }
            }
            optionalCSR = this.m_certificateManager.initServerKeyStore(this.getServerProps().getHostname(), this.getServerProps().getClusterName(), this.getServerProps().getClusterIP(), ksFile, ksPass, this.getServerProps().getAllServerIPs(), this.getServerProps().getAllHostnames());
        }
        catch (Exception e) {
            RTLogger.print(1, "Error init certificate manager key store", e);
            e.printStackTrace();
            System.exit(ServerEngine.isJUnitTest() ? 0 : 43);
        }
        this.initPKIInterface();
        if (optionalCSR.isPresent()) {
            CertificateStateIndicationHelper.sendSendingServerCSRtoPKI();
            this.pki.processCSR("server", ((ByteArray)optionalCSR.get()).getBytes());
        }
    }

    public AuditLog getAuditLog() {
        return this.m_auditLog;
    }

    public ServerJobManager getServerJobManager() {
        return this.m_serverJobManager;
    }

    public IHostnameResolver getHostnameResolver() {
        return this.m_hostResolver;
    }

    public void setHostResolver(IHostnameResolver hostResolver) {
        this.m_hostResolver = hostResolver;
    }

    public SlaveServerCard getSlave(String hostname) {
        return this.m_slaveFactory.getSlave(hostname);
    }

    public List<SlaveServerCard> getSlaves() {
        if (this.m_slaveFactory == null) {
            return new ArrayList<SlaveServerCard>();
        }
        return this.m_slaveFactory.getSlaves();
    }

    public String addNewSlave(String hostname, int port, String user, String password, int scenario, boolean isTls) {
        for (SlaveServerCard ssc : this.m_slaveFactory.getSlaves()) {
            if (!ssc.getHostName().equalsIgnoreCase(hostname) || ssc.getPort() != port || !ssc.getUser().equalsIgnoreCase(user)) continue;
            return "Server " + hostname + ":" + port + ":" + user + " already connected";
        }
        String result = this.m_slaveFactory.addNewSlave(hostname, port, user, password, scenario, isTls);
        this.getEventsRouter().addPendingToALL("GET_SLAVES");
        return result;
    }

    public String removeSlave(String hostname, String user) {
        String result = this.m_slaveFactory.removeSlave(hostname, user);
        this.getEventsRouter().addPendingToALL("GET_SLAVES");
        return result;
    }

    public SlaveServerFactory getSlaveServerFactory() {
        return this.m_slaveFactory;
    }

    public int getUIVersionBestFit() {
        return this.m_GUIVersionBestFit;
    }

    public File getUIFileBestFit() {
        return this.m_GUIVersionBestFitFile;
    }

    public String getMainDir() {
        return this.DIR_MAIN;
    }

    private void initLibs() {
        ArrayList<File> jarsOnly = new ArrayList<File>();
        Path extLibs = Paths.get(this.DIR_MAIN, "libs", "ext");
        if (Files.exists(extLibs, new LinkOption[0])) {
            try (Stream<Path> libs = Files.list(extLibs);){
                libs.forEach(path -> jarsOnly.add(path.toFile()));
            }
            catch (Exception e) {
                RTLogger.print(1, "can't list file in the directory " + String.valueOf(extLibs), e);
            }
        }
        try {
            ClassPathLoader.addFiles(jarsOnly);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error init libs.", e);
            System.exit(ServerEngine.isJUnitTest() ? 0 : 851);
        }
    }

    private void initActionsRepository() {
        String actDirPath = ServerEngine.getInstance().DIR_MAIN + File.separator + "srv" + File.separator + "actions";
        this.m_actionsRepository = new ActionsRepository(actDirPath);
    }

    private void initBinariesRepository() {
        this.m_binRepository = BinariesRepository.getInstance(this.DIR_MAIN);
    }

    private void initDB() {
        for (int i = 0; i < 10; ++i) {
            try {
                this.m_db = DB.getInstance(true);
                try {
                    this.m_db_OUTAGE = DBOutage.getInstance(true);
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Outage management tables are not available.");
                }
                break;
            }
            catch (Exception e) {
                if (i < 10) {
                    RTLogger.print(1, "Database is not available. Try # " + (i + 1) + " from 10.");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                RTLogger.print(1, "Database is not available. Exiting...");
                System.exit(ServerEngine.isJUnitTest() ? 0 : -4);
                continue;
            }
        }
    }

    private void initUserManager() {
        this.m_userManager = UserManager.getInstance();
        this.m_userManager.setNodeGroups(NodeGroupRepository.getInstance());
    }

    private void initGUIServer() {
        if (this.m_GUIServer == null) {
            this.checkGUIUpdate();
            this.m_GUIServer = new GUIServer(this.m_properties.getGUIPort(), this.m_properties.getMaxUIThreads());
            Thread tr = new Thread((Runnable)this.m_GUIServer, "GUIUpdateTask");
            tr.setName("UIServerSocket");
            tr.start();
        }
    }

    public void checkGUIUpdate() {
        try {
            File[] list;
            this.m_GUIVersionBestFit = 0;
            this.m_GUIVersionBestFitFile = null;
            File auto = new File(ServerEngine.getInstance().DIR_MAIN + File.separator + "srv" + File.separator + "deploy" + File.separator + "auto");
            if (auto.exists() && auto.isDirectory() && (list = auto.listFiles(new FileFilter(".jar"))) != null) {
                for (File f : list) {
                    Pattern pluginRegexp = Pattern.compile("com\\.blixx.*\\.gui_(.*).jar");
                    Matcher pluginMatcher = pluginRegexp.matcher(f.getName());
                    if (!f.isFile() || !pluginMatcher.matches()) continue;
                    String version = pluginMatcher.group(1);
                    String[] arr = version.split("\\Q.\\E");
                    int h = Integer.parseInt(arr[0]) * 100000;
                    int t = Integer.parseInt(arr[1]) * 1000;
                    int d = 0;
                    if (arr.length != 2) {
                        d = Integer.parseInt(arr[2]);
                    }
                    int total = h + t + d;
                    if (total <= this.m_GUIVersionBestFit) continue;
                    this.m_GUIVersionBestFit = total;
                    this.m_GUIVersionBestFitFile = f;
                }
            }
        }
        catch (Throwable r) {
            this.m_GUIVersionBestFit = 0;
            this.m_GUIVersionBestFitFile = null;
            RTLogger.print(5, "Error checkGuiUpdate", r);
        }
    }

    private void initPolicyRepository() {
        this.m_policyRepository = SPolicyRepository.getInstance(false);
    }

    private void initAssignmentRepository() {
        this.m_assignmentRepository = new SAssignmentRepository(false);
    }

    private void initForwardManager() {
        try {
            this.m_forwardManager = new ForwardManager(Paths.get("srv", new String[0]).resolve("policies").resolve("fwd"));
        }
        catch (Exception e) {
            RTLogger.print(5, "FM", e);
        }
    }

    public void setForwardManager(ForwardManager fm) {
        this.m_forwardManager = fm;
    }

    public boolean ensureLicense(AgentCard ac) {
        if (ac != null && ac.getRelatedServer() == null && !ac.isDisabled() && ac.getAgentPort() > 0 && !this.registerAgentAsLicensed(ac.getAgentID())) {
            ac.setDisabled(true);
            ac.sendDisableAgent();
            this.m_agentsRepository.saveAgentCard_notifySingle(ac);
            SMessage.sendMessage(ac, "Agent can not be enabled. ID:" + ac.getAgentID() + ". Max number of licensed objects reached.", 2, "LICENSE", "BOOM Server", "BOOM Server", 0);
            return false;
        }
        return true;
    }

    private void initParameters() {
        this.m_properties = ServerProperties.load(this.DIR_MAIN);
    }

    private void initEventsRouter() {
        if (this.m_eventsRouter == null) {
            this.m_eventsRouter = new EventsRouter(this, null);
        }
    }

    public EventsRouter getEventsRouter() {
        return this.m_eventsRouter;
    }

    public ServerProperties getServerProps() {
        return this.m_properties;
    }

    private void initScheduler() {
        this.m_scheduler = new Scheduler(100);
    }

    private void startScheduler() {
        Thread sch = new Thread(this.m_scheduler);
        sch.setName("ServerScheduler");
        sch.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PerfSubmitter getPerfSubmitter() {
        if (m_perfSubmitter != null) return m_perfSubmitter;
        Class<PerfSubmitter> clazz = PerfSubmitter.class;
        synchronized (PerfSubmitter.class) {
            if (m_perfSubmitter != null) return m_perfSubmitter;
            m_perfSubmitter = new PerfSubmitter();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_perfSubmitter;
        }
    }

    private void initServerSocket() {
        this.m_server = Server.getInstance(this.m_properties.getServerPort(), this.m_properties.getListenIP(), this.m_properties.getMaxAgentThreads());
        Thread tr = new Thread((Runnable)this.m_server, "ServerSocket");
        tr.start();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setAgentsOffline(String slaveServer) {
        try {
            SlaveServerCard ssc = this.getSlave(slaveServer);
            if (ssc != null) {
                ssc.setAgentsAsRequesting();
            }
        }
        catch (Exception e) {
            RTLogger.print(2, "", e);
        }
    }

    public Map<String, Object> getAgentIDs4User(String user) {
        HashMap<String, Object> map = null;
        if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            map = new HashMap<String, Object>();
            for (AgentCard ac : this.m_agentsRepository.getAgentCards(user)) {
                map.put(ac.getAgentID(), null);
            }
        }
        return map;
    }

    public DB getDB() {
        return this.m_db;
    }

    public DB getDB_OUTAGE() {
        return this.m_db_OUTAGE;
    }

    public SPolicyRepository getPolicyRepository() {
        return this.m_policyRepository;
    }

    public void setPolicyRepository(SPolicyRepository repo) {
        this.m_policyRepository = repo;
    }

    public SAssignmentRepository getAssignmentRepository() {
        return this.m_assignmentRepository;
    }

    public void setAssignmentRepository(SAssignmentRepository repo) {
        this.m_assignmentRepository = repo;
    }

    public ActionsRepository getActionRepository() {
        return this.m_actionsRepository;
    }

    public AgentsRepository getAgentRepository() {
        return this.m_agentsRepository;
    }

    public BinariesRepository getBinariesRepository() {
        return this.m_binRepository;
    }

    public BinariesRepository setBinaryRepository(BinariesRepository br) {
        this.m_binRepository = br;
        return this.getBinariesRepository();
    }

    public ForwardManager getForwardManager() {
        return this.m_forwardManager;
    }

    public DeploymentTrigger getDeploymentTrigger() {
        return this.m_deployTrigger;
    }

    public HashMap<String, String> getStatus() {
        if (this.m_startTimeStr == null) {
            this.m_startTimeStr = BM.m_sdf.format(new Date(this.m_startTime));
        }
        long startProcessing = System.currentTimeMillis();
        HashMap<String, String> m = new HashMap<String, String>();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long mem0 = totalMemory - Runtime.getRuntime().freeMemory();
        m.put("BOOMMemory", mem0 / 0x100000L + "MB/" + totalMemory / 0x100000L + "MB/" + maxMemory / 0x100000L + "MB");
        m.put("BOOMDir", this.DIR_MAIN);
        m.put("BOOMStartTime", this.m_startTimeStr);
        int insertedAsClosed = this.getEventsRouter().getEventOperations().getInsertedAsClosedCount();
        m.put("BOOMActiveEvents", "" + (this.getEventsRouter().getEventOperations().getActiveMessagesCount() - insertedAsClosed));
        m.put("BOOMAcknEvents", "" + (this.getEventsRouter().getEventOperations().getClosedMessagesCount() + insertedAsClosed));
        m.put("BOOMInsertedAsClosed", "" + insertedAsClosed);
        m.put("BOOMProcessors", "" + Runtime.getRuntime().availableProcessors());
        m.put("BOOMPolicies", "" + this.getPolicyRepository().getPoliciesCount());
        m.put("BOOMAgents", "" + this.m_agentsRepository.getRealAgentCardsCount());
        m.put("BOOMAgentsEnabled", "" + this.m_enabledAgents.size());
        m.put("BOOMAgentsPending", "" + this.m_agentsRepository.getAgentCardsPending().size());
        ArrayList users = new ArrayList(GUIWorker.m_users.keySet());
        Collections.sort(users);
        m.put("BOOMUsers", String.valueOf(users));
        m.put("BOOMUsersConnected", "" + users.size());
        m.put("BOOMUsersTotal", "" + UserManager.getInstance().getUsers().size());
        m.put("BOOMFilters", "" + this.getForwardManager().getPolicies().size());
        m.put("BOOMHostName", this.getServerProps().getHostname());
        m.put("BOOMHostIP", this.getServerProps().getIP());
        m.put("BOOMHostIP_LIST", String.valueOf(this.getServerProps().getAllServerIPs()));
        m.put("BOOMVersion", "5.11.0");
        m.put("OSName", System.getProperty("os.name"));
        m.put("OSVersion", System.getProperty("os.version"));
        m.put("OSArch", System.getProperty("os.arch"));
        m.put("JAVAVersion", System.getProperty("java.version"));
        m.put("JAVAVendor", System.getProperty("java.vendor"));
        m.put("BOOMEventPrTime", "" + this.getEventsRouter().getEventOperations().getLastProcessingTime());
        m.put("BOOMEventMaxTime", "" + this.getEventsRouter().getEventOperations().getMaxProcessingTime());
        m.put("BOOMEventAvgTime", "" + this.getEventsRouter().getEventOperations().m_weightedAverage);
        m.put("BOOMEventAvgTimeC", "" + Server.getConcurAverage());
        m.put("BOOMEventsProcessed", String.valueOf(this.getEventsRouter().getEventOperations().m_weightedAverageCount));
        m.put("BOOMAgentThreads", "" + Server.getCurrentThreads());
        m.put("BOOMMonHosts", "" + (this.getEventsRouter().getEventOperations().getMonitoredHostsCount() - this.m_enabledAgents.size()));
        m.put("BOOMSlavesNum", "" + this.getSlaves().size());
        m.put("BOOMSlaves", String.valueOf(this.getSlaves()));
        try {
            m.put("BOOMUIThreads", "" + this.getGUIServer().getActiveUIThreads());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            m.put("BOOMUIThreadsMax", "" + this.getGUIServer().getUILimit());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        m.put("BOOMLA", "-");
        int maxCONNECTEDUSERS = ServerProperties.getMAX_CONNECTED_USERS(this, false);
        if (Integer.MAX_VALUE == maxCONNECTEDUSERS) {
            m.put("BOOMLU", "-");
        } else {
            m.put("BOOMLU", "" + maxCONNECTEDUSERS);
        }
        int maxENABLEDHOSTS = ServerProperties.getMAX_ENABLED_HOSTS(this, false);
        if (Integer.MAX_VALUE == maxENABLEDHOSTS) {
            m.put("BOOMLH", "-");
        } else {
            m.put("BOOMLH", this.getUsedLicensedPoints() + " of " + maxENABLEDHOSTS);
        }
        m.put("BOOMBB", "" + ServerProperties.getMAX_B2B(this, false));
        m.put("BOOMPID", this.getPID());
        try {
            m.put("BOOMPerfIn", "" + this.m_db.m_perfBuffer.m_countIn.get());
            m.put("BOOMPerfOut", "" + this.m_db.m_perfBuffer.m_countOut.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
        m.put("BOOMHB_INTERVAL", "" + ServerProperties.getHB_Interval());
        m.put("BOOMHB_RTIMEOUT", "" + ServerProperties.getHB_Rtimeout());
        m.put("BOOMHB_CTIMEOUT", "" + ServerProperties.getHB_Ctimeout());
        m.put("BOOMIGNORE_ALL_PERFDATA", "" + this.getServerProps().isIgnorePerfData());
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.getPerfSubmitter().getPerfClassesIgnored().iterator();
        while (it.hasNext()) {
            String perfClassName = it.next();
            sb.append(perfClassName);
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        m.put("BOOMIGNORE_PERFCLASSES", sb.toString());
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Status metrics pt: " + (System.currentTimeMillis() - startProcessing));
        }
        return m;
    }

    @Override
    public void run() {
        RTLogger.print(1, "Shutdown starts.");
        RTLogger.print(1, "Shutdown done.");
    }

    public void loadJars() {
        File jarsDir = new File(this.DIR_MAIN + File.separator + "srv" + File.separator + "libs" + File.separator + "ext");
        if (!jarsDir.exists()) {
            jarsDir.mkdirs();
        }
        File[] lfiles = jarsDir.listFiles();
        ArrayList<File> jarsOnly = new ArrayList<File>();
        for (int i = 0; i < lfiles.length; ++i) {
            if (!lfiles[i].getName().endsWith(".jar")) continue;
            jarsOnly.add(lfiles[i]);
        }
        try {
            ClassPathLoader.addFiles(jarsOnly);
        }
        catch (IOException e) {
            RTLogger.print(2, "Reloading of JAR files failed", e);
        }
    }

    public boolean isOutOfMemory() {
        return this.isOutOfMemory;
    }

    public void setOutOfMemory(boolean isOut) {
        if (this.isOutOfMemory != isOut) {
            this.isOutOfMemory = isOut;
        }
    }

    public static void main(String[] args) {
        try {
            if (args != null && args.length == 1 && args[0].equalsIgnoreCase("-version")) {
                System.out.println("5.11.0");
                System.exit(0);
            }
            ServerEngine se = ServerEngine.getInstance();
            block11: while (true) {
                try {
                    while (true) {
                        Runtime.getRuntime().gc();
                        Thread.sleep(1000L);
                        ServerEngine.checkOutagePoliciesActivation(se);
                        ServerEngine.checkAgentOutagesActivation(se);
                        if (!se.getDB().isEnabled()) continue;
                        se.getEventsRouter().getEventOperations().saveDBdata();
                        se.getEventsRouter().getEventOperations().dBup();
                        try {
                            EventOperationsOutage eventOperationsOutage = se.getEventsRouter().getEventOperationsOutage();
                            if (eventOperationsOutage == null) continue block11;
                            eventOperationsOutage.saveDBdata();
                            continue block11;
                        }
                        catch (Throwable e) {
                            RTLogger.print(1, "{DBO} SD ", e);
                            continue;
                        }
                        break;
                    }
                }
                catch (DBException e) {
                    se.getEventsRouter().getEventOperations().dBdown(e);
                }
                finally {
                    continue;
                }
                break;
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            System.err.println(String.format("Wrong jre (?): %s version: %s", System.getProperty("java.vendor"), System.getProperty("java.version")));
            System.exit(2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            RTLogger.print(1, "MAIN thread exiting. ", e);
            System.exit(1);
        }
    }

    private static void checkAgentOutagesActivation(ServerEngine se) {
        try {
            AgentOutageManager om = se.getEventsRouter().getAgentOutageMgr();
            if (om != null) {
                om.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void checkOutagePoliciesActivation(ServerEngine se) {
        try {
            OutageManager om = se.getEventsRouter().getOutageMgr();
            if (om != null) {
                om.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GUIServer getGUIServer() {
        return this.m_GUIServer;
    }

    public Server getServer() {
        return this.m_server;
    }

    public int getFreeLicenseHostObjects() {
        return ServerProperties.getMAX_ENABLED_HOSTS(this, false) - this.m_licenseHostObject.get();
    }

    public int getUsedLicensedPoints() {
        return this.m_licenseHostObject.get();
    }

    public boolean registerHostAsLicensed() {
        if (this.m_licenseHostObject.get() < ServerProperties.getMAX_ENABLED_HOSTS(this, false)) {
            this.m_licenseHostObject.incrementAndGet();
            return true;
        }
        return false;
    }

    public boolean registerAgentAsLicensed(String agentID) {
        if (!this.m_enabledAgents.containsKey(agentID)) {
            if (this.m_licenseHostObject.get() < ServerProperties.getMAX_ENABLED_HOSTS(this, false) - 9) {
                this.m_licenseHostObject.addAndGet(9);
                this.m_enabledAgents.put(agentID, agentID);
            } else {
                return false;
            }
        }
        return true;
    }

    public void unregisterHostFromLicensed() {
        this.m_licenseHostObject.decrementAndGet();
    }

    public void unregisterAgentFromLicensed(String agentID) {
        if (this.m_enabledAgents.remove(agentID, agentID)) {
            this.m_licenseHostObject.addAndGet(-9);
        }
    }

    public ExternalHostResolver getExternalHostResolver() {
        return this.m_externalHostResolver;
    }

    public CertificateManager getCertificateManager() {
        return this.m_certificateManager;
    }

    public AgentCertificates getAgentCertificates() {
        return this.agentCertificates;
    }

    public PKI getPki() {
        return this.pki;
    }

    public void setPki(PKI pki) {
        this.pki = pki;
    }

    public CSRStorage getCsrStorage() {
        return this.csrStorage;
    }

    private static boolean isJUnitTest() {
        return test;
    }
}

