/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.CMD;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.in.ScGetAgentCardSingle;
import com.blixx.ctrl.sc.in.ScGetAgentCards;
import com.blixx.ctrl.sc.in.ScGetAgentsCM;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentsRepository;
import com.blixx.server.IEventProcessor;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.SlaveServerCard;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.BM;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.sc.CMDS;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SlaveServerClient
extends Thread {
    protected Socket m_sock = null;
    protected AtomicInteger isONLINE = new AtomicInteger(0);
    public static boolean m_ignorePending = false;
    private IEventProcessor m_EventRouter = null;
    private IEventProcessor m_EventOuatage = null;
    private ArrayList<CMD> m_commands = new ArrayList();
    protected SlaveServerCard ssc = null;
    public AtomicBoolean m_stopped = new AtomicBoolean(false);
    public AtomicBoolean m_running = new AtomicBoolean(true);
    private boolean m_isEXTZIP = true;
    private Boolean m_isOutageSupported = null;
    private long m_counterSEventFwd = 0L;
    private String osPrefix;
    protected SDataInputStream is;
    protected SDataOutputStream os;
    long lastBadLog = 0L;
    private AtomicBoolean m_stopPing = new AtomicBoolean(false);

    public SlaveServerClient(SlaveServerCard ssCard, String threadName) {
        super(threadName);
        this.ssc = ssCard;
        this.m_EventRouter = ServerEngine.getInstance().getEventsRouter();
        this.m_EventOuatage = ServerEngine.getInstance().getEventsRouter().getEventOperationsOutage();
        this.osPrefix = "(BS:" + ssCard.getScenario() + ":" + this.ssc.getHostName() + ") ";
    }

    public void addCMD(CMD cmd) {
        this.m_commands.add(cmd);
    }

    public boolean isOnline() {
        return this.isONLINE.get() == 2;
    }

    @Override
    public void run() {
        try {
            while (this.m_running.get()) {
                try {
                    this.requestData();
                }
                catch (Throwable e) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException eee) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.isONLINE.set(0);
        }
        catch (Exception e) {
            RTLogger.print(3, this.getName() + "stopped", e);
        }
        finally {
            this.m_stopped.set(true);
        }
    }

    private void requestAgentCardCMs() {
        ScGetAgentsCM accms = new ScGetAgentsCM(this.ssc);
        accms.addCmdPostProcess(new ICmdPostProcess<ScGetAgentsCM>(){

            @Override
            public void postProcess(ScGetAgentsCM sc) {
                if (sc.isSuccess()) {
                    SlaveServerClient.this.ssc.getAgentCMs().clear();
                    SlaveServerClient.this.ssc.getAgentCMs().putAll((Map<String, AgentCardCM>)sc.getResultObject());
                }
            }
        });
        this.ssc.getServerClient().start(accms);
    }

    public void requestData() {
        try {
            int res = this.ensureConnect();
            boolean isUpdated = false;
            if (res == 0) {
                this.ssc.detectProtocolVersion(this.os, this.is);
                ScGetAgentCards client = this.requestAgentCards();
                while (!client.isFinished()) {
                    Thread.sleep(500L);
                }
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("REFRESH_NODEGROUPS");
                RTLogger.print(5, "SSC: Start loading active messages. Slave: " + this.ssc.getHostName());
                this.requestServer("GETACTIVEMESSAGES_EXT_ZIP", this.os, this.is);
                RTLogger.print(5, "SSC: Start loading ackn messages. Slave: " + this.ssc.getHostName());
                this.requestServer("GETACKNMESSAGES_EXT_ZIP", this.os, this.is);
                RTLogger.print(5, "SSC: Stop loading messages. Slave: " + this.ssc.getHostName());
                if (this.m_isOutageSupported == null) {
                    this.m_isOutageSupported = this.processValidation("GETACTIVEMESSAGES_EXT_ZIP_O", this.os, this.is);
                }
                if (this.m_isOutageSupported.booleanValue()) {
                    RTLogger.print(5, "SSC: Start loading outage active messages. Slave: " + this.ssc.getHostName());
                    this.requestServer("GETACTIVEMESSAGES_EXT_ZIP_O", this.os, this.is);
                    RTLogger.print(5, "SSC: Start loading outage ackn messages. Slave: " + this.ssc.getHostName());
                    this.requestServer("GETACKNMESSAGES_EXT_ZIP_O", this.os, this.is);
                    RTLogger.print(5, "SSC: Stop loading outage messages. Slave: " + this.ssc.getHostName());
                }
                if (this.ssc.getScenario() == 2) {
                    Map<String, Object> archivedID = ServerEngine.getInstance().getDB().getArchiveIDs();
                    this.ssc.getServerClient().start("ARCH_MSG", null, archivedID.keySet().toArray(new String[0]));
                    try {
                        this.requestServer("GET_LASTWEEK_ARCHIVED_IDS", this.os, this.is);
                    }
                    catch (Throwable throwable) {}
                } else if (this.ssc.getScenario() <= 1 && this.m_isOutageSupported.booleanValue()) {
                    this.ssc.getServerClient().start("GET_SERVER_POLICIES_STATUS_AOP", null, new String[0]);
                    this.ssc.getServerClient().start("GET_SERVER_POLICIES_STATUS", null, new String[0]);
                    this.ssc.getServerClient().start("GET_SERVER_POLICIES_STATUS_EXT", null, new String[0]);
                    this.ssc.getServerClient().start("GET_SLAVES", null, new String[0]);
                }
                try {
                    ServerEngine.getInstance().getServerJobManager().runJobOnce("Synchronize_PROXY_Slaves");
                }
                catch (Throwable throwable) {}
            } else {
                RTLogger.print(6, "SSC: Getting new indi. Slave: " + this.ssc.getHostName());
                isUpdated = this.requestServer("GETUPDATENEW_EXT", this.os, this.is) || isUpdated;
                RTLogger.print(6, "SSC: Getting closed indi. Slave: " + this.ssc.getHostName());
                isUpdated = this.requestServer("GETUPDATEDELETED", this.os, this.is) || isUpdated;
                RTLogger.print(6, "SSC: Getting updated indi. Slave: " + this.ssc.getHostName());
                isUpdated = this.requestServer("GETUPDATEUPDATED_EXT", this.os, this.is) || isUpdated;
                RTLogger.print(6, "SSC: Getting archived indi. Slave: " + this.ssc.getHostName());
                boolean bl = isUpdated = this.requestServer("GETARCHIVED", this.os, this.is) || isUpdated;
                if (this.m_isOutageSupported.booleanValue()) {
                    RTLogger.print(6, "SSC: Getting outage updates. Slave: " + this.ssc.getHostName());
                    isUpdated = this.requestServer("GETUPDATENEW_EXT_O", this.os, this.is) || isUpdated;
                    isUpdated = this.requestServer("GETUPDATEDELETED_O", this.os, this.is) || isUpdated;
                    isUpdated = this.requestServer("GETUPDATEUPDATED_EXT_O", this.os, this.is) || isUpdated;
                    isUpdated = this.requestServer("GETARCHIVED_O", this.os, this.is) || isUpdated;
                    RTLogger.print(6, "SSC: Getting outage updates finished. Slave: " + this.ssc.getHostName());
                }
            }
            this.askForPending(this.os, this.is);
            this.ssc.getServerClient();
        }
        catch (Throwable e) {
            this.ensureDisconnect(e);
            throw new RuntimeException("Server is offline");
        }
    }

    protected void ensureDisconnect(Throwable e) {
        if (this.isONLINE.compareAndSet(0, 1) || this.isONLINE.compareAndSet(2, 1)) {
            this.m_isOutageSupported = null;
            ServerEngine.getInstance().getEventsRouter().getClientProxyMgr().removeClientCache(this.ssc.toString());
            RTLogger.print(1, "SSC: Client failed. Slave: " + this.ssc.getHostName(), e);
            SEventFwd se = SMessage.createMessage(5, 1, "BOOM_SLAVE", this.ssc.getHostName(), "BOOM Server", "Slave server is offline or unavailable\n" + e.getMessage());
            se.setKey("SLAVE:" + this.ssc.getHostName() + ":DOWN");
            se.setCloseMask("SLAVE:" + this.ssc.getHostName() + ":<*>");
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(se);
            ServerEngine.getInstance().setAgentsOffline(this.ssc.getHostName());
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
            SocketUtils.closeSocket(this.m_sock, this.os, this.is);
            this.m_sock = null;
        } else if (this.m_sock != null && !this.m_sock.isConnected()) {
            if (System.currentTimeMillis() - this.lastBadLog > 300000L) {
                RTLogger.print(3, "SSC: not connected. Reset.");
                this.lastBadLog = System.currentTimeMillis();
            }
            SocketUtils.closeSocket(this.m_sock, new AutoCloseable[0]);
            this.m_sock = null;
        }
    }

    protected int ensureConnect() throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        if (this.m_sock == null) {
            this.m_sock = SocketUtils.getNewSocket(120000);
            this.m_sock.connect(new InetSocketAddress(this.ssc.getHostName(), this.ssc.getPort()), 10000);
            this.is = new SDataInputStream(this.m_sock.getInputStream());
            this.os = this.ssc.getDetectedServerProtocolVersion() != null ? new SDataOutputStream(this.m_sock.getOutputStream(), this.ssc.getDetectedServerProtocolVersion()) : new SDataOutputStream(this.m_sock.getOutputStream(), 1);
            if (this.ssc.isTLS()) {
                this.ssc.setDetectedServerProtocolVersion(1);
                this.os.writeUTF("+");
                this.os.flush();
                this.m_sock = TlsUtils.upgradeClientSocket(this.m_sock, ServerEngine.getInstance().getCertificateManager());
            }
        }
        if (this.isONLINE.get() == 2) {
            this.os.writeUTF("PING");
        }
        String str = this.is.readUTF();
        this.os.setVersion(this.is.getLastProtocolVersion());
        int res = this.processServerQuestion(str, this.os, this.is);
        if (this.isONLINE.compareAndSet(0, 2) || this.isONLINE.compareAndSet(1, 2)) {
            SEventFwd se = SMessage.createMessage(1, 1, "BOOM_SLAVE", this.ssc.getHostName(), "BOOM Server", "Slave server is online");
            se.setKey("SLAVE:" + this.ssc.getHostName() + ":UP");
            se.setCloseMask("SLAVE:" + this.ssc.getHostName() + ":<*>");
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(se);
        }
        return res;
    }

    public void processExit(SDataOutputStream os, SDataInputStream is) throws IOException {
        os.writeUTF("EXIT");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processServerQuestion(String question, SDataOutputStream os, SDataInputStream is) throws IOException {
        int res = 0;
        if (!question.equalsIgnoreCase("login")) {
            if (!question.equalsIgnoreCase("valid")) return res;
            return 7;
        }
        os.writeUTF(this.ssc.getUser());
        String nextToken = is.readUTF();
        if (!nextToken.equalsIgnoreCase("password")) throw new RuntimeException("login name unknown");
        os.writeUTF(this.ssc.getPasswordEncrypted());
        String response = is.readUTF();
        if (!response.equals("OK")) throw new RuntimeException(response);
        return res;
    }

    protected boolean requestServer(String command, SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        if (command.equals("GETUPDATENEW_EXT")) {
            isUpdated = this.getNewIndications(os, is);
        } else if (command.equals("GETUPDATENEW_EXT_O")) {
            isUpdated = this.getNewIndications_Outage(os, is);
        } else if (command.equals("GETACTIVEMESSAGES_EXT_ZIP")) {
            isUpdated = this.getActiveIndicationsFresh(os, is);
        } else if (command.equals("GETACTIVEMESSAGES_EXT_ZIP_O")) {
            isUpdated = this.getActiveIndicationsFresh_Outage(os, is);
        } else if (command.equals("GETUPDATEDELETED")) {
            isUpdated = this.getClosedIndications(os, is);
        } else if (command.equals("GETUPDATEDELETED_O")) {
            isUpdated = this.getClosedIndications_Outage(os, is);
        } else if (command.equals("GETUPDATEUPDATED_EXT")) {
            isUpdated = this.getUpdatedIndications(os, is);
        } else if (command.equals("GETUPDATEUPDATED_EXT_O")) {
            isUpdated = this.getUpdatedIndications_Outage(os, is);
        } else if (command.equals("GETACKNMESSAGES_EXT") || command.equals("GETACKNMESSAGES_EXT_ZIP") && !this.m_isEXTZIP) {
            isUpdated = this.old_getClosedFresh(os, is);
        } else if (command.equals("GETACKNMESSAGES_EXT_ZIP")) {
            isUpdated = this.getClosedIndicationsFresh(os, is);
        } else if (command.equals("GETACKNMESSAGES_EXT_ZIP_O")) {
            isUpdated = this.getClosedIndicationsFresh_Outage(os, is);
        } else if (command.equals("GETARCHIVED")) {
            isUpdated = this.getArchivedIndications(os, is);
        } else if (command.equals("GETARCHIVED_O")) {
            isUpdated = this.getArchivedIndications_Outage(os, is);
        } else if (command.equals("GET_LASTWEEK_ARCHIVED_IDS") && this.ssc.getScenario() == 2) {
            this.getLastWeekArchived(os, is);
        }
        return isUpdated;
    }

    private boolean old_getClosedFresh(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETACKNMESSAGES_EXT");
        int max = is.readInt();
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(max);
        ArrayList<String> ids = new ArrayList<String>(max);
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        while (is.readBoolean()) {
            SEventFwd e = new SEventFwd();
            String server = this.readSEXT(is, e);
            if (server.equalsIgnoreCase(hostname)) continue;
            ids.add(e.getID());
            list.add(e);
            isUpdated = true;
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETACKNMESSAGES_EXT");
        }
        this.closeWithPingThread(os, is, this.m_EventRouter, list);
        if (this.ssc.getScenario() == 1 && ids.size() > 0) {
            this.ssc.getServerClient().start("ARCH_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 0 && ids.size() > 0) {
            this.ssc.getServerClient().start("DELETE_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 2 && ids.size() > 0) {
            this.archiveOnFwdCtrlSlave(ids);
        }
        return isUpdated;
    }

    private void getLastWeekArchived(SDataOutputStream os, SDataInputStream is) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP");
        String validation = is.readUTF();
        if (validation.equals("T")) {
            os.writeUTF("GET_LASTWEEK_ARCHIVED_IDS");
            String allIDs_separatedByComma = is.readUTF();
            String[] ids = allIDs_separatedByComma.split(",");
            String status = is.readUTF();
            if (status.equals("T")) {
                // empty if block
            }
            this.processLastWeekArchivedWithPingThread(os, is, ids);
        } else {
            RTLogger.print(2, "SSC: GET_LASTWEEK_ARCHIVED_IDS not supported on the slave: " + this.ssc.getHostName());
        }
    }

    private boolean getArchivedIndications(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        String res = "F";
        LinkedList<String> ids = new LinkedList<String>();
        os.writeUTF("GETARCHIVED");
        try {
            while (is.readBoolean()) {
                String id = is.readUTF();
                ids.add(id);
                isUpdated = true;
            }
            res = is.readUTF();
            this.archiveWithPingThread(os, is, this.m_EventRouter, ids);
        }
        catch (Throwable e) {
            RTLogger.print(3, "SSC: Failed GETARCHIVED", e);
        }
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETARCHIVED");
        }
        return isUpdated;
    }

    private boolean getArchivedIndications_Outage(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        String res = "F";
        LinkedList<String> ids = new LinkedList<String>();
        os.writeUTF("GETARCHIVED_O");
        try {
            while (is.readBoolean()) {
                String id = is.readUTF();
                ids.add(id);
                isUpdated = true;
            }
            res = is.readUTF();
            this.archiveWithPingThread(os, is, this.m_EventOuatage, ids);
        }
        catch (Throwable e) {
            RTLogger.print(3, "SSC: Failed GETARCHIVED_O", e);
        }
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETARCHIVED_O");
        }
        return isUpdated;
    }

    private boolean getClosedIndicationsFresh(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        LinkedList<String> ids = new LinkedList<String>();
        os.writeUTF("GETACKNMESSAGES_EXT_ZIP");
        int bbbSize = -1;
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        while ((bbbSize = is.readInt()) > 0) {
            byte[] bbi = new byte[bbbSize];
            is.readFully(bbi);
            ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
            SDataInputStream byteIS = new SDataInputStream(bis);
            while (byteIS.readBoolean()) {
                SEventFwd e = new SEventFwd();
                String server = this.readSEXT(byteIS, e);
                if (server.equalsIgnoreCase(hostname)) continue;
                ids.add(e.getID());
                list.add(e);
                isUpdated = true;
            }
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETACKNMESSAGES_EXT_ZIP");
        }
        this.closeWithPingThread(os, is, this.m_EventRouter, list);
        if (this.ssc.getScenario() == 1 && ids.size() > 0) {
            this.ssc.getServerClient().start("ARCH_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 0 && ids.size() > 0) {
            this.ssc.getServerClient().start("DELETE_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 2 && ids.size() > 0) {
            this.archiveOnFwdCtrlSlave(ids);
        }
        return isUpdated;
    }

    private void archiveOnFwdCtrlSlave(List<String> ids) {
        final HashSet<String> idsFromSlave = new HashSet<String>(ids);
        ServerThreadPool.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                RTLogger.print(4, "SSC: SSC011");
                Map<String, Object> archivedID = ServerEngine.getInstance().getDB().getArchiveIDs();
                archivedID.keySet().removeAll(idsFromSlave);
                RTLogger.print(4, "SSC: SSC012");
                if (archivedID.size() > 0) {
                    SlaveServerClient.this.ssc.getServerClient().start("ARCH_MSG", null, archivedID.keySet().toArray(new String[0]));
                }
            }
        });
    }

    private boolean getClosedIndicationsFresh_Outage(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        LinkedList<String> ids = new LinkedList<String>();
        os.writeUTF("GETACKNMESSAGES_EXT_ZIP_O");
        int bbbSize = -1;
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        while ((bbbSize = is.readInt()) > 0) {
            byte[] bbi = new byte[bbbSize];
            is.readFully(bbi);
            ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
            SDataInputStream byteIS = new SDataInputStream(bis);
            while (byteIS.readBoolean()) {
                SEventFwd e = new SEventFwd();
                String server = this.readSEXT(byteIS, e);
                if (server.equalsIgnoreCase(hostname)) continue;
                ids.add(e.getID());
                list.add(e);
                isUpdated = true;
            }
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETACKNMESSAGES_EXT_ZIP_O");
        }
        this.closeWithPingThread(os, is, this.m_EventOuatage, list);
        return isUpdated;
    }

    private boolean getUpdatedIndications(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATEUPDATED_EXT");
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        while (is.readBoolean()) {
            SEventFwd e = new SEventFwd();
            String server = this.readSEXT(is, e);
            if (server.equalsIgnoreCase(hostname)) continue;
            isUpdated = true;
            list.add(e);
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATEUPDATED_EXT");
        }
        List<String> ids = this.updateWithPingThread(os, is, this.m_EventRouter, list);
        if (this.ssc.getScenario() == 1 && ids.size() > 0) {
            this.ssc.getServerClient().start("ARCH_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 0 && ids.size() > 0) {
            this.ssc.getServerClient().start("DELETE_MSG", null, ids.toArray(new String[0]));
        }
        return isUpdated;
    }

    private boolean getUpdatedIndications_Outage(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATEUPDATED_EXT_O");
        String hostname = ServerEngine.getInstance().getServerProps().getHostname();
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        while (is.readBoolean()) {
            SEventFwd e = new SEventFwd();
            String server = this.readSEXT(is, e);
            if (server.equalsIgnoreCase(hostname)) continue;
            isUpdated = true;
            list.add(e);
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATEUPDATED_EXT_O");
        }
        List<String> ids = this.updateWithPingThread(os, is, this.m_EventOuatage, list);
        if (ids != null && ids.size() > 100) {
            RTLogger.print(5, "SSC: updated Indications Outage size " + ids.size());
        }
        return isUpdated;
    }

    private boolean getClosedIndications(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATEDELETED");
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<String> missed = new LinkedList<String>();
        while (is.readBoolean()) {
            String s = is.readUTF();
            String id = s.substring(0, 36);
            if (this.m_EventRouter.getEvent(id) != null) {
                ids.add(id);
            } else {
                missed.add(id);
            }
            char state = 'A';
            try {
                state = s.charAt(36);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String t9Attr = null;
            if (s.length() > 37) {
                t9Attr = s.substring(37);
            }
            this.m_EventRouter.acknowledgeFwd(id, state, t9Attr);
            isUpdated = true;
        }
        if (this.ssc.getScenario() == 1 && ids.size() > 0) {
            ids.addAll(missed);
            this.ssc.getServerClient().start("ARCH_MSG", null, ids.toArray(new String[0]));
        } else if (this.ssc.getScenario() == 0 && ids.size() > 0) {
            ids.addAll(missed);
            this.ssc.getServerClient().start("DELETE_MSG", null, ids.toArray(new String[0]));
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATEDELETED");
        }
        return isUpdated;
    }

    private boolean getClosedIndications_Outage(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATEDELETED_O");
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<String> missed = new LinkedList<String>();
        while (is.readBoolean()) {
            String s = is.readUTF();
            String id = s.substring(0, 36);
            if (this.m_EventOuatage.getEvent(id) != null) {
                ids.add(id);
            } else {
                missed.add(id);
            }
            char state = 'A';
            String t9Attr = null;
            if (s.length() > 36) {
                state = s.charAt(36);
                if (s.length() > 37) {
                    t9Attr = s.substring(37);
                }
            }
            this.m_EventOuatage.acknowledgeFwd(id, state, t9Attr);
            isUpdated = true;
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATEDELETED_O");
        }
        return isUpdated;
    }

    private boolean getNewIndications(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATENEW_EXT");
        int max = is.readInt();
        int count = 0;
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(max);
        while (is.readBoolean()) {
            ++count;
            SEventFwd e = new SEventFwd();
            String server = this.readSEXT(is, e);
            if (server.equalsIgnoreCase(ServerEngine.getInstance().getServerProps().getHostname())) continue;
            list.add(e);
            isUpdated = true;
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATENEW_EXT");
        }
        this.submitWithPingThread(os, is, this.m_EventRouter, list);
        return isUpdated;
    }

    private boolean getNewIndications_Outage(SDataOutputStream os, SDataInputStream is) throws IOException {
        boolean isUpdated = false;
        os.writeUTF("GETUPDATENEW_EXT_O");
        int max = is.readInt();
        int count = 0;
        ArrayList<SEventFwd> list = new ArrayList<SEventFwd>(max);
        while (is.readBoolean()) {
            ++count;
            SEventFwd e = new SEventFwd();
            String server = this.readSEXT(is, e);
            if (server.equalsIgnoreCase(ServerEngine.getInstance().getServerProps().getHostname())) continue;
            list.add(e);
            isUpdated = true;
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETUPDATENEW_EXT_O");
        }
        this.submitWithPingThread(os, is, this.m_EventOuatage, list);
        return isUpdated;
    }

    private boolean getActiveIndicationsFresh(SDataOutputStream os, SDataInputStream is) throws SocketTimeoutException, IOException {
        boolean isUpdated = false;
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        if (!this.m_isEXTZIP) {
            throw new SocketTimeoutException();
        }
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            // empty if block
        }
        RTLogger.print(5, "SSC: GETACTIVEMESSAGES_EXT_ZIP");
        os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP");
        int bbbSize = -1;
        while ((bbbSize = is.readInt()) > 0) {
            byte[] bbi = new byte[bbbSize];
            is.readFully(bbi);
            ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
            SDataInputStream byteIS = new SDataInputStream(bis);
            while (byteIS.readBoolean()) {
                SEventFwd e = new SEventFwd();
                String server = this.readSEXT(byteIS, e);
                if (server.equalsIgnoreCase(ServerEngine.getInstance().getServerProps().getHostname())) continue;
                list.add(e);
                isUpdated = true;
            }
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETACTIVEMESSAGES_EXT_ZIP");
        }
        this.submitWithPingThread(os, is, this.m_EventRouter, list);
        return isUpdated;
    }

    private boolean getActiveIndicationsFresh_Outage(SDataOutputStream os, SDataInputStream is) throws SocketTimeoutException, IOException {
        boolean isUpdated = false;
        LinkedList<SEventFwd> list = new LinkedList<SEventFwd>();
        if (!this.m_isEXTZIP) {
            throw new SocketTimeoutException();
        }
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP_O");
        String validation = is.readUTF();
        if (validation.equals("F")) {
            // empty if block
        }
        os.writeUTF("GETACTIVEMESSAGES_EXT_ZIP_O");
        int bbbSize = -1;
        while ((bbbSize = is.readInt()) > 0) {
            byte[] bbi = new byte[bbbSize];
            is.readFully(bbi);
            ByteArrayInputStream bis = new ByteArrayInputStream(bbi);
            SDataInputStream byteIS = new SDataInputStream(bis);
            while (byteIS.readBoolean()) {
                SEventFwd e = new SEventFwd();
                String server = this.readSEXT(byteIS, e);
                if (server.equalsIgnoreCase(ServerEngine.getInstance().getServerProps().getHostname())) continue;
                list.add(e);
                isUpdated = true;
            }
        }
        String res = "F";
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETACTIVEMESSAGES_EXT_ZIP_O");
        }
        this.submitWithPingThread(os, is, this.m_EventOuatage, list);
        return isUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitWithPingThread(SDataOutputStream os, SDataInputStream is, IEventProcessor eventStorage, List<SEventFwd> list) {
        if (list != null && list.size() > 0) {
            Thread tr;
            this.m_stopPing.set(false);
            try {
                tr = new Thread((Runnable)new PingThread(is, os), "BCPing");
                tr.start();
                RTLogger.print(5, "SSC: Start submit indications (%d)", list.size());
                eventStorage.submitFwdMessage(list, this.ssc);
                RTLogger.print(5, "SSC: Stop submit indications (%d)", list.size());
            }
            finally {
                this.m_stopPing.set(true);
            }
            try {
                tr.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> updateWithPingThread(SDataOutputStream os, SDataInputStream is, IEventProcessor eventStorage, List<SEventFwd> list) {
        List<String> arr = new ArrayList<String>(0);
        if (list != null && list.size() > 0) {
            Thread tr;
            this.m_stopPing.set(false);
            try {
                tr = new Thread((Runnable)new PingThread(is, os), "BCPing");
                tr.start();
                RTLogger.print(5, "SSC: Start update indications (%d)", list.size());
                arr = eventStorage.updateEvents(list, true);
                RTLogger.print(5, "SSC: Stop update indications (%d)", list.size());
            }
            finally {
                this.m_stopPing.set(true);
            }
            try {
                tr.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWithPingThread(SDataOutputStream os, SDataInputStream is, IEventProcessor eventStorage, List<SEventFwd> list) {
        if (list != null && list.size() > 0) {
            Thread tr;
            this.m_stopPing.set(false);
            try {
                tr = new Thread((Runnable)new PingThread(is, os), "BCPing");
                tr.start();
                RTLogger.print(5, "SSC: Start close indications (%d)", list.size());
                eventStorage.acknowledgeFwd(list, this.ssc);
                RTLogger.print(5, "SSC: Stop close indications (%d)", list.size());
            }
            finally {
                this.m_stopPing.set(true);
            }
            try {
                tr.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveWithPingThread(SDataOutputStream os, SDataInputStream is, IEventProcessor eventStorage, List<String> ids) {
        if (ids != null && ids.size() > 0 && this.ssc.getScenario() == 2) {
            Thread tr;
            this.m_stopPing.set(false);
            try {
                tr = new Thread((Runnable)new PingThread(is, os), "BCPing");
                tr.start();
                eventStorage.archive2(ids, false);
            }
            finally {
                this.m_stopPing.set(true);
            }
            try {
                tr.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLastWeekArchivedWithPingThread(SDataOutputStream os, SDataInputStream is, String[] ids) {
        if (ids != null && ids.length > 0) {
            Thread tr;
            this.m_stopPing.set(false);
            try {
                tr = new Thread((Runnable)new PingThread(is, os), "BCPing");
                tr.start();
                LinkedList<String> toArchive = new LinkedList<String>();
                for (String archivedIDOnSlave : ids) {
                    SEventFwd ie = this.m_EventRouter.getEvent(archivedIDOnSlave);
                    if (ie == null) continue;
                    toArchive.add(archivedIDOnSlave);
                }
                if (toArchive.size() > 0) {
                    this.m_EventRouter.archive2(toArchive, false);
                }
            }
            finally {
                this.m_stopPing.set(true);
            }
            try {
                tr.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String readSEXT(SDataInputStream is, SEventFwd e) throws IOException {
        e.readSv2(is);
        ++this.m_counterSEventFwd;
        String server = this.ssc.getHostName();
        if (e.getSrv() != null && e.getSrv().length() > 0 && !e.getSrv().equals(this.ssc.getHostName())) {
            if (e.getSrvtype() == null || e.getSrvtype().length() == 0 || e.getSrvtype().equals(BM.PRODUCT_lowercase)) {
                e.setSrvType(e.getSrv());
                this.ssc.addSlave(e.getSrv());
                server = e.getSrv();
            } else {
                server = e.getSrvtype();
            }
        } else {
            e.setSrvType(BM.PRODUCT_lowercase);
        }
        e.setSrv(this.ssc.getHostName());
        return server;
    }

    public void askForPending(SDataOutputStream os, SDataInputStream is) throws IOException {
        String res = "F";
        os.writeUTF("GETPENDING");
        String commandToProcess = null;
        String actionToProcess = null;
        Object[] parameters = null;
        LinkedHashSet<CMD> cmdList = new LinkedHashSet<CMD>();
        int size = is.readInt();
        if (size > 0) {
            RTLogger.print(5, "SSC: pending " + size + " actions");
        }
        for (int i = 0; i < size; ++i) {
            int paramSize;
            commandToProcess = is.readUTF();
            actionToProcess = is.readUTF();
            if (actionToProcess.length() == 0) {
                actionToProcess = null;
            }
            if ((paramSize = is.readInt()) > 0) {
                parameters = new String[paramSize];
                for (int j = 0; j < paramSize; ++j) {
                    parameters[j] = is.readUTF();
                }
            }
            CMD cmd = new CMD(commandToProcess, actionToProcess, parameters);
            cmdList.add(cmd);
        }
        res = is.readUTF();
        if (!res.equals("T")) {
            RTLogger.print(3, "SSC: Failed GETPENDING");
        }
        if (!m_ignorePending) {
            this.processPendingActions(cmdList, os, is);
        } else if (cmdList != null && cmdList.size() > 0) {
            RTLogger.print(2, "pending ignored. (%s)", cmdList.size());
        }
    }

    private void processPendingActions(Set<CMD> cmdList, SDataOutputStream os, SDataInputStream is) {
        block14: for (CMD cmd : cmdList) {
            RTLogger.print(5, "SSC: Ext CMD - " + String.valueOf(cmd));
            Integer codeI = CMDS.m_acceptable.get(cmd.m_command);
            int code = -1;
            if (codeI != null) {
                code = codeI;
            }
            switch (code) {
                case 143: {
                    this.ssc.requestAgentOutagesStatus();
                    continue block14;
                }
                case 138: {
                    this.ssc.requestServerOutagesStatus();
                    continue block14;
                }
                case 148: {
                    this.ssc.requestModifyPoliciesStatus();
                    continue block14;
                }
                case 234: {
                    this.ssc.requestExtendedPoliciesStatus();
                    continue block14;
                }
                case 24: {
                    if (cmd.m_action != null && cmd.m_action.length() > 0) {
                        this.requestAgentCard(cmd.m_action);
                        continue block14;
                    }
                    this.requestAgentCards();
                    continue block14;
                }
                case 238: {
                    this.requestAgentCard(cmd.m_action);
                    continue block14;
                }
                case 101: {
                    if (cmd.m_action != null && cmd.m_action.length() > 0) {
                        ServerEngine.getInstance().getEventsRouter().addPendingToALL(new CMD("GET_AGENT_INVENTORY_CARD", cmd.m_action, null));
                        continue block14;
                    }
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_AGENT_INVENTORY_CARD");
                    continue block14;
                }
                case 226: {
                    try {
                        this.requestAgentCardCMs();
                    }
                    catch (Throwable throwable) {}
                    continue block14;
                }
                case 113: {
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_AGENT_VERSIONS");
                    continue block14;
                }
                case 255: {
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("REFRESH_NODEGROUPS");
                    continue block14;
                }
            }
            RTLogger.print(5, "SSC: Ignored Slave notification: " + cmd.m_command);
        }
    }

    private ScGetAgentCards requestAgentCards() {
        ScGetAgentCards getAgentCards = new ScGetAgentCards(this.ssc, AgentCard.class);
        getAgentCards.addCmdPostProcess(new ICmdPostProcess<ScGetAgentCards>(){

            @Override
            public void postProcess(ScGetAgentCards sc) {
                if (sc.isSuccess()) {
                    try {
                        Object result = sc.getResultObject();
                        ArrayList<AgentCard> agents = new ArrayList<AgentCard>(result.size());
                        for (AbstractAgentCard aca : result.values()) {
                            AgentCard ac = (AgentCard)aca;
                            agents.add(ac);
                            if (RTLogger.getCurrentLevel() < 6) continue;
                            RTLogger.print(6, new StringBuffer("SSC: AC - ").append(ac).append(' ').append(ac.getMode()));
                        }
                        SlaveServerClient.this.putFwdAgentCards(agents, SlaveServerClient.this.ssc.getHostName());
                        SlaveServerClient.this.requestAgentCardCMs();
                    }
                    catch (Exception e) {
                        RTLogger.print(5, "SSC: ", e);
                    }
                }
            }
        });
        this.ssc.getServerClient().start(getAgentCards);
        return getAgentCards;
    }

    private void requestAgentCard(String agentID) {
        ScGetAgentCardSingle scgacs = new ScGetAgentCardSingle(this.ssc, AgentCard.class, agentID);
        scgacs.addCmdPostProcess(sc -> {
            if (sc.isSuccess()) {
                AgentCard aac = (AgentCard)sc.getResultObject();
                ArrayList<AgentCard> one = new ArrayList<AgentCard>(1);
                one.add(aac);
                this.updateFwdAgentCards(one, this.ssc.getHostName());
                AgentsRepository.notifySingleAgentChange(aac);
            }
        });
        this.ssc.getServerClient().start(scgacs);
    }

    protected boolean processValidation(String command, SDataOutputStream os, SDataInputStream is) throws IOException {
        os.writeUTF("VALIDATE_CMD");
        os.writeUTF(command);
        String validation = is.readUTF();
        return "T".equals(validation);
    }

    public long getCounterSEevntFwd() {
        return this.m_counterSEventFwd;
    }

    public void putFwdAgentCards(List<AgentCard> cards, String serverHostname) {
        Map<String, AgentCard> slaveAgents = this.ssc.getAgents();
        for (String agentID : slaveAgents.keySet()) {
            ServerEngine.getInstance().getAgentRepository().removeAgentCard(agentID);
        }
        this.ssc.getAgents().clear();
        this.updateFwdAgentCards(cards, serverHostname);
        this.ssc.setAgentsRequested(true);
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GETAGENTCARDS");
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_ALL_ASSIGNMENTS");
    }

    public void updateFwdAgentCards(List<AgentCard> cards, String serverHostname) {
        for (AgentCard ac : cards) {
            ac.setRelatedServer(serverHostname);
            ac.setOSName(this.osPrefix + ac.getOSName());
            ServerEngine.getInstance().getAgentRepository().putAgentCard(ac);
            this.ssc.updateAgent(ac);
        }
    }

    public class PingThread
    implements Runnable {
        SDataInputStream m_is = null;
        SDataOutputStream m_os = null;

        PingThread(SDataInputStream is, SDataOutputStream os) {
            this.m_is = is;
            this.m_os = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int count10sec = 0;
                while (!SlaveServerClient.this.m_stopPing.get()) {
                    if (count10sec > 0 && count10sec % 10 == 0) {
                        RTLogger.print(2, "SSC: pht02 sec: " + count10sec * 10);
                    }
                    for (int i = 0; i < 100; ++i) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!SlaveServerClient.this.m_stopPing.get()) continue;
                        return;
                    }
                    ++count10sec;
                    this.m_os.writeUTF("PING");
                    String answer = this.m_is.readUTF();
                    if (answer.equalsIgnoreCase("valid")) continue;
                    return;
                }
            }
            catch (Throwable e) {
                RTLogger.print(4, "SSC: pht01", e);
            }
            finally {
                SlaveServerClient.this.m_stopPing.set(true);
            }
        }
    }
}

