/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.ctrl.sc.in.ScPutFileFromString;
import com.blixx.log.RTLogger;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.SMessage;
import com.blixx.server.ServerClient;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.SlaveServerClient;
import com.blixx.server.jobs.SyncSlaveActionsJob;
import com.blixx.server.jobs.SyncSlaveAssignmentsJob;
import com.blixx.server.jobs.SyncSlaveBinariesJob;
import com.blixx.server.jobs.SyncSlavePoliciesJob;
import com.blixx.server.utils.XMLTree;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.FileFilter;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;

public class SlaveServerFactory {
    public static final String SLP = ".slp";
    public static String HOSTNAME = "HOST";
    public static String PORT = "PORT";
    public static String USER = "USER";
    public static String PASSWORD = "PASSWORD";
    public static String SCENARIO = "SCENARIO";
    public static String TLS = "TLS";
    List<SlaveServerCard> m_slaves = new ArrayList<SlaveServerCard>();
    public File m_slavesDir;

    public SlaveServerFactory() {
        this.init();
    }

    private void init() {
        File[] configs;
        String slavesPath = ServerEngine.getInstance().getMainDir() + File.separator + "srv" + File.separator + "slaves";
        this.m_slavesDir = new File(slavesPath);
        if (!this.m_slavesDir.exists()) {
            this.m_slavesDir.mkdirs();
        }
        if ((configs = this.m_slavesDir.listFiles(new FileFilter(SLP))) != null && configs.length > 0) {
            for (File config : configs) {
                Properties prop = new Properties();
                try (FileInputStream fis = new FileInputStream(config);){
                    prop.load(fis);
                }
                catch (Exception e) {
                    RTLogger.print(1, "Can't read slave config: " + config.getName(), e);
                    continue;
                }
                try {
                    String hostname = prop.getProperty(HOSTNAME);
                    int port = BM.CLIENT_PORT;
                    String portStr = prop.getProperty(PORT);
                    if (portStr != null) {
                        try {
                            port = Integer.parseInt(portStr);
                        }
                        catch (Exception e) {
                            RTLogger.print(2, "Invalid port for slave: " + String.valueOf(config));
                        }
                    }
                    boolean isTls = false;
                    String isTlsStr = prop.getProperty(TLS, "false");
                    try {
                        isTls = Boolean.parseBoolean(isTlsStr);
                    }
                    catch (Exception e) {
                        RTLogger.print(2, "Invalid TLS value for slave: " + isTlsStr);
                    }
                    String user = prop.getProperty(USER);
                    String pass = prop.getProperty(PASSWORD);
                    pass = Cryptor.decrypt(pass);
                    String scen = prop.getProperty(SCENARIO);
                    int scenario = Integer.parseInt(scen);
                    if (scenario > 0 && scenario < 10) {
                        SlaveServerCard ssc = new SlaveServerCard(hostname, port, user, pass, scenario, isTls);
                        ssc.setLoadedFrom(config);
                        this.m_slaves.add(ssc);
                        if (this.getSlaves().size() < ServerProperties.getMAX_B2B(this, true)) {
                            ssc.start();
                            continue;
                        }
                        SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "B2B", "LICENSE", "Failed to start " + BM.PRODUCT_lowercase + "2" + BM.PRODUCT_lowercase + " integration module. No valid license found.\nPropertyFile: " + config.getName());
                        sm.setKey("BOOM_SERVER:LICENSE:BB:EXPIRE:" + ServerProperties.getMAX_B2B(this, true));
                        sm.setCloseMask("BOOM_SERVER:LICENSE:BB:EXPIRE:<*>");
                        ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
                        continue;
                    }
                    RTLogger.print(1, "Slave configuration has unknown scenario: " + scenario + ". Expected 1-3.");
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Error processing slave configuration: " + config.getName() + ".", e);
                }
            }
        } else {
            RTLogger.print(1, "No configurations for slave servers found");
        }
    }

    public int getRunningSlaves() {
        int count = 0;
        for (SlaveServerCard ssc : this.getSlaves()) {
            if (!ssc.isRunning()) continue;
            ++count;
        }
        return count;
    }

    public String addNewSlave(String hostname, int port, String user, String password, int scenario, boolean isTls) {
        String resolvedHostname = hostname;
        try {
            InetAddress ia = InetAddress.getByName(hostname);
            try {
                resolvedHostname = ia.getHostName();
            }
            catch (Exception exception) {}
        }
        catch (UnknownHostException e1) {
            return "Failed. Unknown host: " + hostname;
        }
        Object result = "Added new slave server: " + resolvedHostname + ":" + port;
        switch (scenario) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            default: {
                RTLogger.print(1, "Wrong scenario. Failed to store slave configuration: " + resolvedHostname);
                return "Failed. Wrong scenario. Expected [1-3] {1-Proxy, 2-Mirror, 3-Master, 7-Backup}";
            }
        }
        try {
            String error = ServerClient.checkConnection(resolvedHostname, port, user, Cryptor.encrypt2(password));
            if (error != null) {
                return error;
            }
            Properties np = new Properties();
            np.put(HOSTNAME, resolvedHostname);
            np.put(PORT, "" + port);
            np.put(USER, user);
            np.put(PASSWORD, Cryptor.encrypt2(password));
            np.put(SCENARIO, "" + scenario);
            np.put(TLS, "" + isTls);
            final SlaveServerCard ssc = new SlaveServerCard(resolvedHostname, port, user, password, scenario, isTls);
            this.m_slaves.add(ssc);
            File file = new File(this.m_slavesDir, ssc.getFilename() + SLP);
            try (FileOutputStream fos = new FileOutputStream(file);){
                np.store(fos, "slave server configuration");
                ssc.setLoadedFrom(file);
            }
            if (this.getRunningSlaves() >= ServerProperties.getMAX_B2B(this, true)) {
                result = "Failed to start slave server. Please check your license. ";
                RTLogger.print(1, (String)result);
            } else {
                ssc.start();
                RTLogger.print(1, "*** slave server added: " + resolvedHostname + " (" + user + ")");
                Thread tr = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ssc.getScenario() <= 1) {
                                SlaveServerFactory.this.pushNodeGroupsToSlave(ssc);
                                StringBuffer sb = new StringBuffer("ProxyFirstSync ");
                                SlaveServerFactory.this.syncProxy(ssc, sb);
                                RTLogger.print(2, sb);
                            }
                        }
                        catch (Throwable e) {
                            RTLogger.print(2, "ProxyFirstSync", e);
                        }
                    }
                }, "ProxyFirstSync");
                tr.start();
            }
        }
        catch (Throwable e) {
            result = "Failed to store slave configuration for server: " + resolvedHostname + " " + e.getMessage();
            RTLogger.print(1, "Failed to store slave configuration: " + resolvedHostname, e);
        }
        return result;
    }

    public String removeSlave(String hostname, String user) {
        String result = "Slave not found";
        for (SlaveServerCard ssc : new ArrayList<SlaveServerCard>(this.m_slaves)) {
            if (ssc.getHostName().equals(hostname)) {
                if (!ssc.getUser().equals(user)) continue;
                ssc.stopClients();
                this.m_slaves.remove(ssc);
                ServerEngine.getInstance().getAgentRepository().removeFwdAgentCards(ssc.getHostName());
                if (ssc.getLoadedFrom() != null) {
                    File loadedFrom = ssc.getLoadedFrom();
                    String baseFn = loadedFrom.getName().replace(SLP, "");
                    loadedFrom.delete();
                    try {
                        FileUtils.deleteDirectoryRecursive(new File(this.m_slavesDir, ssc.getFilename()).getPath());
                    }
                    catch (IOException iOException) {}
                } else {
                    String baseFilename = hostname + "_" + user;
                    if (new File(this.m_slavesDir, baseFilename + SLP).delete()) {
                        try {
                            FileUtils.deleteDirectoryRecursive(new File(this.m_slavesDir, baseFilename).getPath());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                RTLogger.print(1, "*** slave server removed: " + hostname + " (" + user + ")");
                result = "Slave server removed";
                continue;
            }
            ssc.getServerClient().start("GETAGENTCARDS", null, new String[0]);
        }
        return result;
    }

    public SlaveServerCard getSlave(String hostname) {
        if (hostname != null && hostname.length() > 0) {
            for (SlaveServerCard sc : this.m_slaves) {
                if (!sc.getHostName().equals(hostname)) continue;
                return sc;
            }
        }
        return null;
    }

    public List<SlaveServerCard> getSlaves() {
        return this.m_slaves;
    }

    public String pushNodeGroupsToSlave(SlaveServerCard ssc) {
        Object result = "OK";
        NodeGroupRepository ngr = NodeGroupRepository.getInstance();
        try {
            GroupTreeObject ntree = ngr.getNodeGroupTree().clone();
            List<GroupTreeObject> list = ntree.getAllElements();
            for (GroupTreeObject gto : list) {
                Object ac;
                if (!(gto instanceof GroupTreeObjectLast) || (ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(((GroupTreeObjectLast)gto).getLinkedPath())) != null && ((AbstractAgentCard)ac).getRelatedServer() != null && ssc.getHostName().equals(((AbstractAgentCard)ac).getRelatedServer())) continue;
                gto.getParent().removeElement(gto);
            }
            try {
                GroupTreeObject groups = ntree.getChild("_Groups", "");
                GroupTreeObject.cleanEmptyGroups(groups, groups);
                for (GroupTreeObject groupTreeObject : GroupTreeObject.collectGroups(groups)) {
                    try {
                        GroupTreeObject gtoOrig = NodeGroupRepository.getInstance().getNodeGroupTree().searchPath(groupTreeObject.getPath(), groupTreeObject.getType());
                        groupTreeObject.getTreeObject().setOID(gtoOrig.getTreeObject().getOID());
                    }
                    catch (Throwable gtoOrig) {}
                }
            }
            catch (Throwable groups) {
                // empty catch block
            }
            XMLTree xt = new XMLTree();
            Document d = xt.getXML(ntree);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLFactory.writeXml(d, baos);
            ScPutFileFromString sc = new ScPutFileFromString(ssc, NodeGroupRepository.getInstance().getNodeGroupXMLFile(), baos.toString());
            ssc.getServerClient().start(sc);
        }
        catch (Throwable e) {
            result = "Error pushing NodeGroups to slave " + ssc.getHostName() + " : " + e.getMessage();
            RTLogger.print(3, (String)result, e);
        }
        return result;
    }

    public void pushNodeGroupsToSlaves() {
        for (SlaveServerCard ssc : this.getSlaves()) {
            if (ssc.getScenario() > 1) continue;
            this.pushNodeGroupsToSlave(ssc);
        }
    }

    public StringBuffer syncProxy(SlaveServerCard ssc, StringBuffer res) {
        SlaveServerClient bc = ssc.getSlaveServerClient();
        if (bc != null && bc.isOnline()) {
            res.append("SyncSlaveBinaries: ");
            try {
                SyncSlaveBinariesJob bin = (SyncSlaveBinariesJob)SyncSlaveBinariesJob.getServerJob();
                bin.syncBinaries(res, ssc);
            }
            catch (Throwable e) {
                res.append("Error: ").append(e.getMessage());
            }
            res.append("\n");
            res.append("SyncSlavePolicies: ");
            SyncSlavePoliciesJob pol = (SyncSlavePoliciesJob)SyncSlavePoliciesJob.getServerJob();
            try {
                pol.syncPoliciesAndPolicyGroup(res, ssc);
            }
            catch (Throwable e) {
                res.append("Error: ").append(e.getMessage());
            }
            res.append("\n");
            res.append("SyncSlaveAssignments: ");
            SyncSlaveAssignmentsJob asn = (SyncSlaveAssignmentsJob)SyncSlaveAssignmentsJob.getServerJob();
            try {
                asn.syncAssignments(res, ssc);
            }
            catch (Throwable e) {
                res.append("Error: ").append(e.getMessage());
            }
            res.append("\n");
            res.append("SyncSlaveActions: ");
            SyncSlaveActionsJob ssa = (SyncSlaveActionsJob)SyncSlaveActionsJob.getServerJob();
            try {
                ssa.syncActions(res, ssc);
            }
            catch (Throwable e) {
                res.append("Error: ").append(e.getMessage());
            }
            if (ssc.getScenario() <= 1) {
                res.append("\n");
                res.append("SyncNodeGroups: ");
                res.append(ssc.getHostName());
                res.append(" ");
                res.append(ServerEngine.getInstance().getSlaveServerFactory().pushNodeGroupsToSlave(ssc));
            }
        } else {
            res.append("Proxy server: ").append(ssc.getHostName()).append(" is offline\n");
        }
        return res;
    }
}

