/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server;

import com.blixx.log.RTLogger;
import com.blixx.server.BruteForceDetector;
import com.blixx.server.EventsRouter;
import com.blixx.server.GUIWorker;
import com.blixx.server.NodeGroupRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerProperties;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.UserGroupTree;
import com.blixx.server.ext.ForwardManager;
import com.blixx.server.utils.ServerSSLSocketFactory;
import com.blixx.shared.AbstractAgentCard;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.pg.IAssignmentTree;
import com.blixx.shared.pg.INodeGroupTree;
import com.blixx.shared.pg.IPolicyTree;
import com.blixx.shared.pg.IPowerGroupMgr;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.pg.PowerGroupFactory;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.ConcurrentHashMapMap;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.TreeObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class UserManager
implements IPowerGroupMgr {
    public static final String LDAP_PASS = "LDAP_PASS";
    public static final String LDAP_USER = "LDAP_USER";
    public static final int MINUTES_10 = 600000;
    public static final String LDAP2 = "LDAP";
    public static final String DEFAULT_SEARCH_FILTER = "(&(objectClass=Person)(|(userprincipalname=*)(uid=*)))";
    public static final String LDAP_SEARCH_DC = "LDAP_SEARCH_DC";
    public static final String LDAP_SEARCH_KEY = "LDAP_SEARCH_KEY";
    public static final String LDAP_SEARCH_FILTER = "LDAP_SEARCH_FILTER";
    public static final String LDAP_ADMIN_PASS = "LDAP_ADMIN_PASS";
    public static final String LDAP_ADMIN = "LDAP_ADMIN";
    public static final String LDAP_URL = "LDAP_URL";
    public static final String DEFAULT_LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String LDAP_FACTORY = "LDAP_FACTORY";
    public static final String LDAP_AUTHENTICATION = "LDAP_AUTHENTICATION";
    public static final String LDAP_USER_ATTR = "LDAP_USER_ATTR";
    public static final String LDAP_EXPIRE = "LDAP_EXPIRE";
    public static final String LDAP_BASE = "LDAP_BASE";
    public static final String ENABLED = "ENABLED";
    public static final String LDAP_ORDER_FILENAME = "order.ldap.conf";
    public static final String FILE_NAME = "FN";
    public static final String PRIMARY_SERVER = "PRIMARY_SERVER";
    protected static volatile UserManager instance = null;
    protected Map<String, User> userMap = new ConcurrentHashMap<String, User>(20, 0.9f, 3);
    protected Map<Integer, UItem> items = new ConcurrentHashMap<Integer, UItem>(20, 0.9f, 3);
    protected Map<String, UserRole> rolesMap = new ConcurrentHashMap<String, UserRole>(20, 0.9f, 3);
    protected Map<String, UserGroupTree> role2NodeGroupTree = new ConcurrentHashMap<String, UserGroupTree>(5, 0.9f, 2);
    protected static final String LDAP_DIR = "srv" + File.separator + "ldap";
    protected Map<String, Long> cachedAuth = new ConcurrentHashMap<String, Long>(20, 0.9f, 3);
    protected Map<String, Long> cachedFailedAuth = new ConcurrentHashMap<String, Long>(20, 0.9f, 3);
    protected Map<String, Properties> ldapConfigs = new ConcurrentHashMap<String, Properties>(3);
    protected List<String> ldapUrlOrder = new ArrayList<String>();
    public static final String ADMINISTRATOR = "Administrator";
    protected PowerGroupFactory powerGroupFactory = new PowerGroupFactory();
    private BruteForceDetector bruteForceDetector;

    protected UserManager() {
    }

    public static UserManager getMockInstance() {
        instance = new UserManager();
        UserManager.instance.bruteForceDetector = new BruteForceDetector(3, TimeUnit.MINUTES.toMillis(10L), TimeUnit.HOURS.toMillis(1L));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserManager getInstance() {
        if (instance != null) return instance;
        Class<UserManager> clazz = UserManager.class;
        synchronized (UserManager.class) {
            if (instance != null) return instance;
            UserManager um = new UserManager();
            um.loadAll();
            um.initBruteForceDetectorUsingServerProps();
            instance = um;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initBruteForceDetectorUsingServerProps() {
        ServerProperties serverProps = ServerEngine.getInstance().getServerProps();
        int maxFailedLoginsInARawBeforeLock = serverProps.getMaxFailedLoginsInARawBeforeLock();
        long userLockRetentionPeriodMs = serverProps.getUserLockRetentionPeriodMs();
        long failCountRetentionPeriodMs = serverProps.getFailedLoginCountRetentionPeriodMs();
        this.bruteForceDetector = new BruteForceDetector(maxFailedLoginsInARawBeforeLock, userLockRetentionPeriodMs, failCountRetentionPeriodMs);
    }

    public void loadAll() {
        this.loadItems();
        this.ensureItems();
        this.loadRoles();
        this.ensureAdminRole();
        this.ensureDefaultRightsForAllRoles();
        this.loadUsers();
        this.initLDAP();
        this.loadPowerGroups();
    }

    private void ensureItems() {
        this.ensureItem(1000, "Indications", "Access to the Indication View");
        this.ensureItem(1001, "Policies", "Access to the Policies");
        this.ensureItem(1002, "Nodes", "Access to the Nodes");
        this.ensureItem(1003, "PerfView", "Access to the Performance View");
        this.ensureItem(1004, "User Management", "Access to the User Management");
        this.ensureItem(1005, "Remote Actions", "Access to the Remote Actions");
        this.ensureItem(1006, "Packages", "Access to the Binary Packages");
        this.ensureItem(1007, "ActionView", "Access to the Tools");
        this.ensureItem(1008, "Assignments", "Access to the Assignments View");
        this.ensureItem(1009, "Server Filters", "Access to the Server Filters");
        this.ensureItem(1010, "Server Tree", "Access to the Server Tree");
        this.ensureItem(2001, "Service Dashboard", "Access to the Global Service Dashboard");
        this.ensureItem(2002, "Local Service Dashboard", "Access to the Local Service Dashboard");
        this.ensureItem(2003, "Server Jobs", "Access to the Server Jobs View");
        this.ensureItem(2004, "Server Configuration", "Access to the Server Configuration View");
        this.ensureItem(2010, "Scheduled Maintenance", "Access to the Scheduled Maintenance View");
        this.ensureItem(2011, "AdHoc Maintenance", "Access to the AdHoc Maintenance View");
        this.ensureItem(2012, "Server Policies", "Access to the Server Policies View");
        this.ensureItem(2014, "Notification Interfaces", "Allow configuration of the Notification Interfaces");
        this.ensureItem(2015, "Extended Agent attributes", "Allow to see or edit extended Agent attributes");
        this.ensureItem(2016, "Maintenance Indications", "Access to the Maintenance Indications");
    }

    private void ensureItem(int itemNumber, String itemName, String itemDescription) {
        if (!this.items.containsKey(itemNumber)) {
            this.addItem(itemNumber, itemName, itemDescription, false);
        }
    }

    private void ensureAdminRole() {
        try {
            UserRole adminRole = this.getRoleByName(ADMINISTRATOR);
            if (adminRole == null) {
                HashMap<String, String> record = new HashMap<String, String>();
                record.put("ID", "dec7d845-ef3e-4400-980e-f6f54e9b357a");
                record.put("ROLENAME", ADMINISTRATOR);
                record.put("DESCRIPTION", "");
                adminRole = UserRole.createRole(record);
                this.saveRole(adminRole, false);
            }
        }
        catch (Exception e) {
            RTLogger.print(2, "", e);
        }
    }

    private void ensureDefaultRightsForAllRoles() {
        for (UserRole role : this.getRoles()) {
            if (!this.ensureAllRightsAssigned(role)) continue;
            this.saveRole(role, false);
        }
    }

    public boolean ensureAllRightsAssigned(UserRole role) {
        boolean rightsChanged = false;
        rightsChanged = role.removeRightsIf(ur -> !this.items.containsKey(ur.getItemID()));
        for (UItem uItem : this.getUItems()) {
            if (role.getRightLevel(uItem.id) != 0) continue;
            this.ensureRights(role, uItem.id);
            rightsChanged = true;
        }
        return rightsChanged;
    }

    private boolean ensureRights(UserRole role, int itemNumber) {
        if (role.getRightLevel(itemNumber) == 0) {
            UserRight ur = ADMINISTRATOR.equals(role.getName()) ? new UserRight(role.getID(), itemNumber, 3) : new UserRight(role.getID(), itemNumber, 1000 == itemNumber ? 2 : 1);
            role.addRight(ur);
            return true;
        }
        return false;
    }

    public void addItem(int number, String name, String description, boolean saveRoles) {
        ServerEngine.getInstance().getDB().addItem(number, name, description);
        UItem ui = new UItem(number, name, description);
        this.items.put(ui.id, ui);
        for (UserRole role : this.getRoles()) {
            int defaultActionRights;
            int level;
            int n = level = ADMINISTRATOR.equals(role.getName()) ? 3 : 1;
            if (number >= 8000 && number < 9000 && (defaultActionRights = this.getRights(1007, role)) != 0) {
                level = defaultActionRights;
            }
            UserRight right = new UserRight(role.getID(), ui.id, level);
            role.addRight(right);
            if (!saveRoles) continue;
            this.saveRole(role, false);
        }
    }

    public UItem getUItem(int id) {
        return this.items.get(id);
    }

    public void addAction(String filename, boolean saveRoles) throws Exception {
        int currentNumber = 0;
        for (int i = 8000; i < 9000; ++i) {
            if (this.getUItem(i) != null) continue;
            currentNumber = i;
            break;
        }
        if (currentNumber == 0) {
            throw new Exception("No more slots for Action IDs");
        }
        this.addItem(currentNumber, filename.replace(".act.xml", ""), filename, false);
    }

    public void removeZombieActions() {
        try {
            for (int i = 8000; i < 9000; ++i) {
                UItem uItem = this.getUItem(i);
                if (uItem == null) continue;
                String filename = uItem.description;
                if (ServerEngine.getInstance().getActionRepository().getFileNames().contains(filename)) continue;
                try {
                    this.deleteActionItem(filename);
                    continue;
                }
                catch (Exception e) {
                    RTLogger.print(3, "Error deleting zombie action right item: " + uItem.description, e);
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(2, "", e);
        }
    }

    public int getActionID(String filename) {
        for (int i = 8000; i < 9000; ++i) {
            UItem act = this.getUItem(i);
            if (act == null || act.description == null || !act.description.equalsIgnoreCase(filename)) continue;
            return act.id;
        }
        return -1;
    }

    public void deleteActionItem(String filename) {
        int id = this.getActionID(filename);
        if (id >= 8000) {
            ServerEngine.getInstance().getDB().deleteItem(id);
            UItem removed = this.items.remove(id);
            if (removed != null) {
                this.ensureDefaultRightsForAllRoles();
            }
        }
    }

    public void renameActionItem(String oldfilename, String newfilename) {
        int id = this.getActionID(oldfilename);
        if (id >= 8000) {
            String shortName = newfilename.replace(".act.xml", "");
            ServerEngine.getInstance().getDB().updateItem(id, shortName, newfilename);
            UItem action = this.items.get(id);
            action.name = shortName;
            action.description = newfilename;
            this.items.put(id, action);
        }
    }

    public void initLDAP() {
        File dir = new File(LDAP_DIR);
        if (dir.exists()) {
            File[] list = dir.listFiles((dir1, name) -> {
                String fname = name.toLowerCase(Locale.getDefault());
                return fname.startsWith("ldap") && fname.endsWith(".conf");
            });
            List<Object> flist = list == null ? new ArrayList() : Arrays.asList(list);
            flist.sort((f1, f2) -> f1.getName().compareToIgnoreCase(f2.getName()));
            for (File file : flist) {
                try (FileInputStream fis = new FileInputStream(file);){
                    Properties p = new Properties();
                    p.load(fis);
                    p.setProperty(FILE_NAME, file.getName());
                    if (!p.containsKey(LDAP_URL)) continue;
                    String url = p.getProperty(LDAP_URL);
                    if (this.getLdapProperties(url) == null) {
                        this.ldapConfigs.put(url, p);
                        continue;
                    }
                    RTLogger.print(1, "Skipped Duplicate config for LDAP_URL: " + url + " file: " + file.getName());
                }
                catch (Exception e) {
                    RTLogger.print(1, "Error processing LDAP config file: " + file.getName(), e);
                }
            }
            if (this.loadLdapUrlOrder(dir)) {
                this.saveUrlOrder(dir);
            }
        }
    }

    protected boolean loadLdapUrlOrder(File dir) {
        boolean reSave = false;
        File order = new File(dir, LDAP_ORDER_FILENAME);
        if (order.exists()) {
            try (FileReader fr = new FileReader(order);
                 BufferedReader br = new BufferedReader(fr);){
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().length() <= 0) continue;
                    if (this.getLdapProperties(line) != null) {
                        this.ldapUrlOrder.add(line);
                        continue;
                    }
                    reSave = true;
                }
            }
            catch (Exception e) {
                RTLogger.print(2, "", e);
            }
        }
        if (this.ldapConfigs.size() != this.ldapUrlOrder.size()) {
            for (String url : this.ldapConfigs.keySet()) {
                if (this.ldapUrlOrder.contains(url)) continue;
                this.ldapUrlOrder.add(url);
                reSave = true;
            }
        }
        return reSave;
    }

    public void saveUrlOrder(List<String> urls) {
        this.ldapUrlOrder = urls;
        this.saveUrlOrder(new File(LDAP_DIR));
        this.clearUserAuthCaches();
    }

    protected void saveUrlOrder(File dir) {
        File order = new File(dir, LDAP_ORDER_FILENAME);
        try (FileWriter fw = new FileWriter(order);
             BufferedWriter bw = new BufferedWriter(fw);){
            for (String url : this.ldapUrlOrder) {
                bw.write(url);
                bw.newLine();
            }
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("REFRESH_LDAP_SERVERSE");
        }
        catch (Exception e) {
            RTLogger.print(2, "", e);
        }
    }

    public boolean isLDAPEnabled() {
        boolean isEnabled = false;
        for (String url : this.ldapUrlOrder) {
            Properties ldap = this.getLdapProperties(url);
            String enabled = ldap.getProperty(ENABLED);
            if (enabled == null || !enabled.equalsIgnoreCase("true")) continue;
            isEnabled = true;
            break;
        }
        return isEnabled;
    }

    public void reloadLDAP() {
        this.ldapConfigs.clear();
        this.clearUserAuthCaches();
        this.initLDAP();
    }

    private void clearUserAuthCaches() {
        this.cachedAuth.clear();
        this.cachedFailedAuth.clear();
    }

    void cleanUserCache(String username) {
        this.cachedAuth.remove(username);
    }

    String testUserLDAP(String user, String notencryptedpass) {
        StringBuilder result = new StringBuilder();
        if (this.ldapUrlOrder.isEmpty()) {
            return "LDAP configuration(s) not found!\n Please create at least one LDAP configuration in " + LDAP_DIR + " and perform \"LDAP RELOAD\" server command";
        }
        result.append("For this test request, caching and server authentication are not used!\n");
        for (String url : this.ldapUrlOrder) {
            Properties ldap = this.getLdapProperties(url);
            Properties tp = new Properties();
            tp.putAll((Map<?, ?>)ldap);
            tp.setProperty(LDAP_USER, user);
            tp.setProperty(LDAP_PASS, notencryptedpass);
            result.append('\n');
            this.testLdap(tp, result);
        }
        return result.toString();
    }

    public String testUserLDAP(Properties ldap) {
        StringBuilder result = new StringBuilder();
        result.append("For this test request, caching and server authentication are not used!\n");
        this.testLdap(ldap, result);
        return result.toString();
    }

    protected void testLdap(Properties ldap, StringBuilder result) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String user = ldap.getProperty(LDAP_USER);
        String pass = ldap.getProperty(LDAP_PASS);
        String url = ldap.getProperty(LDAP_URL);
        String base = ldap.getProperty(LDAP_BASE);
        String uattr = ldap.getProperty(LDAP_USER_ATTR);
        String authType = ldap.getProperty(LDAP_AUTHENTICATION, "simple");
        String ldapFactoryName = ldap.getProperty(LDAP_FACTORY, DEFAULT_LDAP_FACTORY);
        try {
            this.prepareLdapEnvironment(env, user, pass, url, base, uattr, authType, ldapFactoryName);
            result.append("LDAP AUTH start on LDAP server: ").append(url).append('\n');
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.hashCode();
            result.append("LDAP AUTH OK for user: ").append(user);
        }
        catch (Exception e) {
            result.append("LDAP AUTH FAILED for user: ").append(user).append('\n');
            result.append("ERROR: ").append(e.getMessage()).append('\n');
            if (e.getCause() != null) {
                result.append("Caused by: ").append(e.getCause().getMessage()).append('\n');
            }
            RTLogger.print(2, "Test LDAP failed", e);
        }
    }

    public String addUserLDAP(String[] users) {
        StringBuilder result = new StringBuilder();
        UserRole role = this.getRoleByName(LDAP2);
        if (role == null) {
            role = UserRole.createNewRole();
            role.setName(LDAP2);
            role.setDescription("Temporary role for importing users from LDAP");
            this.saveRole(role, true);
            result.append("User Role: LDAP created.\n\n");
        }
        for (String user : users) {
            if (this.getUser(user) == null) {
                User us = User.createNewUser();
                us.setActive(0);
                us.setLoginName(user);
                us.setRoleID(role.getID());
                us.setRoleName(role.getName());
                us.setFirstName("");
                us.setLastName("");
                us.setEmail("");
                us.setEncryptedPwd(LDAP2);
                result.append('[').append(us.getLoginName()).append("] --- ");
                this.saveUser(us);
                result.append("User stored.\n");
                continue;
            }
            result.append('[').append(user).append("] --- already exist. Skipped.\n");
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_USERS");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserRole checkLDAP(String user, String encryptedPass) {
        UserRole role = null;
        if (!this.isUserEnabled(user)) {
            return null;
        }
        String userPass = user + "\u25ba" + encryptedPass;
        Long expired = this.cachedAuth.get(userPass);
        if (expired != null && System.currentTimeMillis() < expired) {
            role = this.getRoleForUser(user);
        } else {
            User stored = this.getUser(user);
            Long expiredFailedLogin = this.cachedFailedAuth.get(userPass);
            if (expiredFailedLogin != null && System.currentTimeMillis() < expiredFailedLogin) {
                RTLogger.print(6, "Failed login found in cache: " + user);
            } else if (stored != null && LDAP2.equals(stored.getEncryptedPwd())) {
                this.cachedFailedAuth.remove(userPass);
                this.cachedAuth.remove(userPass);
                for (String urlStr : this.ldapUrlOrder) {
                    String enabled;
                    Properties ldap = this.getLdapProperties(urlStr);
                    if (ldap == null || (enabled = ldap.getProperty(ENABLED)) != null && !enabled.equalsIgnoreCase("true")) continue;
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    String url = ldap.getProperty(LDAP_URL);
                    String base = ldap.getProperty(LDAP_BASE);
                    String factory = ldap.getProperty(LDAP_FACTORY, DEFAULT_LDAP_FACTORY);
                    String uattr = ldap.getProperty(LDAP_USER_ATTR);
                    String authType = ldap.getProperty(LDAP_AUTHENTICATION, "simple");
                    String notEncrypterPass = Cryptor.decrypt(encryptedPass);
                    long expireMillis = 600000L;
                    try {
                        String expiration = ldap.getProperty(LDAP_EXPIRE);
                        long min = Long.parseLong(expiration);
                        expireMillis = min * 60000L;
                    }
                    catch (Exception e) {
                        RTLogger.print(2, "Error parsing LDAP_EXPIRE " + ldap.getProperty(LDAP_EXPIRE));
                    }
                    Context ctx = null;
                    try {
                        this.prepareLdapEnvironment(env, user, notEncrypterPass, url, base, uattr, authType, factory);
                        RTLogger.print(4, "LDAP AUTH start: " + url);
                        ctx = new InitialDirContext(env);
                        role = this.getRoleForUser(user);
                        this.cachedAuth.put(userPass, System.currentTimeMillis() + expireMillis);
                        this.cachedFailedAuth.remove(userPass);
                        RTLogger.print(3, "LDAP AUTH OK for user: " + user);
                        break;
                    }
                    catch (AuthenticationException e) {
                        StringBuilder sb = new StringBuilder("LDAP failed to AUTHENTICATE user: ");
                        sb.append(user).append(' ').append(e.getMessage());
                        if (e.getCause() != null) {
                            sb.append("Caused by: ").append(e.getCause().getMessage()).append('\n');
                        }
                        RTLogger.print(2, sb);
                        this.cachedFailedAuth.put(userPass, System.currentTimeMillis() + expireMillis);
                        break;
                    }
                    catch (Exception e) {
                        RTLogger.print(1, "error ldap user check", e);
                    }
                    finally {
                        try {
                            if (ctx == null) continue;
                            ctx.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (role == null && (role = this.checkUserLogin(user, encryptedPass)) != null) {
                this.cachedAuth.put(userPass, System.currentTimeMillis() + 600000L);
                this.cachedFailedAuth.remove(userPass);
                RTLogger.print(1, "LDAP activated, but user supplies plain server l/p");
            }
        }
        return role;
    }

    public Properties getLdapProperties(String url) {
        return this.ldapConfigs.get(url);
    }

    public String importUsersFromLDAP(Properties ldap) {
        StringBuilder result;
        block21: {
            HashMap<String, User> usersTemp = new HashMap<String, User>();
            boolean toSave = false;
            String test = ldap.getProperty("LDAP_TEST");
            result = new StringBuilder();
            Hashtable<String, String> env = new Hashtable<String, String>();
            String user = ldap.getProperty(LDAP_ADMIN);
            String pass = ldap.getProperty(LDAP_ADMIN_PASS);
            String url = ldap.getProperty(LDAP_URL);
            String base = ldap.getProperty(LDAP_BASE);
            String uattr = ldap.getProperty(LDAP_USER_ATTR);
            String authType = ldap.getProperty(LDAP_AUTHENTICATION, "simple");
            String ldapFactoryName = ldap.getProperty(LDAP_FACTORY, DEFAULT_LDAP_FACTORY);
            try {
                NamingEnumeration<SearchResult> answer;
                UserRole role;
                this.prepareLdapEnvironment(env, user, pass, url, base, uattr, authType, ldapFactoryName);
                InitialDirContext ctx = new InitialDirContext(env);
                ctx.addToEnvironment("java.naming.referral", "follow");
                result.append("LDAP AUTH OK for user: ").append(user).append('\n');
                String filter = ldap.getProperty(LDAP_SEARCH_FILTER, DEFAULT_SEARCH_FILTER);
                SearchControls ctls = new SearchControls();
                String uidAttr = ldap.getProperty(LDAP_SEARCH_KEY);
                if (uidAttr == null) {
                    uidAttr = "userprincipalname";
                }
                String[] attrIDs = new String[]{uidAttr, "distinguishedName", "CN", "SN", "givenname", "firstname", "lastname", "mail", "memberof", "userAccountControl"};
                ctls.setReturningAttributes(attrIDs);
                result.append('\n').append(LDAP_SEARCH_FILTER).append('=').append(filter).append("\n\n");
                ctls.setSearchScope(2);
                String dcSearch = ldap.getProperty(LDAP_SEARCH_DC);
                if (dcSearch == null) {
                    dcSearch = "";
                }
                if ((role = this.getRoleByName(LDAP2)) == null) {
                    role = UserRole.createNewRole();
                    role.setName(LDAP2);
                    role.setDescription("Temporary role for importing users from LDAP");
                    this.ensureAllRightsAssigned(role);
                    this.saveRole(role, true);
                }
                if (!(toSave = (answer = ctx.search(dcSearch, filter, ctls)).hasMore())) {
                    result.append("Search result is empty!\n");
                }
                while (answer.hasMore()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    Attribute uid = attrs.get(uidAttr);
                    if (uid == null) continue;
                    String login = String.valueOf(uid.get());
                    if (this.getRoleForUser(login) == null) {
                        User us = User.createNewUser();
                        us.setActive(0);
                        us.setLoginName(login);
                        us.setRoleID(role.getID());
                        us.setRoleName(role.getName());
                        Attribute val = attrs.get("firstname");
                        if (val != null) {
                            us.setFirstName(String.valueOf(val.get()));
                        } else {
                            val = attrs.get("givenname");
                            if (val != null) {
                                us.setFirstName(String.valueOf(val.get()));
                            }
                        }
                        val = attrs.get("lastname");
                        if (val != null) {
                            us.setLastName(String.valueOf(val.get()));
                        } else {
                            val = attrs.get("SN");
                            if (val != null) {
                                us.setLastName(String.valueOf(val.get()));
                            }
                        }
                        val = attrs.get("mail");
                        if (val != null) {
                            us.setEmail(String.valueOf(val.get()));
                        }
                        if (test == null) {
                            usersTemp.put(us.getLoginName(), us);
                            continue;
                        }
                        result.append('[').append(login).append("] --- ").append(us.getFirstName()).append(' ').append(us.getLastName());
                        if (us.getEmail() != null && us.getEmail().trim().length() > 0) {
                            result.append(" <").append(us.getEmail()).append('>');
                        }
                        result.append('\n');
                        continue;
                    }
                    result.append('[').append(login).append("] --- ");
                    result.append("User already exist. Skipped.\n");
                }
                if (toSave && test == null) {
                    this.saveDiscoveredUsers(result, usersTemp);
                } else {
                    result.append("\nLDAP import users was simulated!\n");
                }
            }
            catch (PartialResultException e) {
                if (toSave && test == null) {
                    this.saveDiscoveredUsers(result, usersTemp);
                }
                result.append("\nLDAP Warning: Request to Referral system(s) was not successful.");
            }
            catch (Exception e) {
                result.append("LDAP failed ").append(e.getClass().getName()).append(" ").append(e.getMessage() == null ? "" : e.getMessage()).append('\n');
                if (e.getCause() == null) break block21;
                result.append('\t').append(e.getCause().getClass().getName()).append(" ").append(e.getCause().getMessage()).append('\n');
            }
        }
        return result.toString();
    }

    public void saveDiscoveredUsers(StringBuilder result, Map<String, User> users) {
        for (User us : users.values()) {
            us.setEncryptedPwd(LDAP2);
            result.append('[').append(us.getLoginName()).append("] --- ");
            this.saveUser(us);
            result.append("User stored.\n");
        }
    }

    public void prepareLdapEnvironment(Hashtable<String, String> env, String user, String notEncrypterPass, String url, String base, String uattr, String authType, String ldapFactoryName) throws AuthenticationException {
        if (notEncrypterPass == null || notEncrypterPass.isEmpty()) {
            throw new AuthenticationException("Unauthenticated authentication is denied");
        }
        if (base == null || ((String)base).trim().length() == 0) {
            base = "";
        } else if (!((String)base).startsWith("@")) {
            base = "," + (String)base;
        }
        uattr = uattr == null || ((String)uattr).trim().trim().length() == 0 ? "" : (String)uattr + "=";
        env.put("java.naming.factory.initial", ldapFactoryName);
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", authType);
        env.put("java.naming.security.principal", (String)uattr + user + (String)base);
        env.put("java.naming.security.credentials", notEncrypterPass);
        env.put("java.naming.referral", "ignore");
        if (url.toLowerCase(Locale.getDefault()).startsWith("ldaps:")) {
            env.put("java.naming.ldap.factory.socket", ServerSSLSocketFactory.class.getName());
        }
    }

    public String deleteLDAPConfig(String ldapURL) {
        StringBuilder sb = new StringBuilder();
        Properties ldap = this.ldapConfigs.remove(ldapURL);
        this.ldapUrlOrder.remove(ldapURL);
        this.saveUrlOrder(this.ldapUrlOrder);
        try {
            File file = this.getExpectedLDAPConfigFile(ldapURL);
            if (file == null) {
                sb.append("LDAP configuration not found. LDAP_URL=").append(ldapURL);
            } else {
                this.delete(ldapURL, sb, ldap, file);
            }
        }
        catch (Exception e) {
            RTLogger.print(2, "Error deleting ldap config", e);
        }
        return sb.toString();
    }

    private void delete(String ldapURL, StringBuilder sb, Properties ldap, File file) {
        try {
            Files.delete(file.toPath());
            sb.append("LDAP configuration deleted. LDAP_URL=").append(ldapURL);
        }
        catch (Exception e1) {
            if (file.canWrite()) {
                this.rewrite(ldapURL, sb, ldap, file);
            }
            sb.append("LDAP configuration deleted. LDAP_URL=").append(ldapURL);
        }
    }

    private void rewrite(String ldapURL, StringBuilder sb, Properties ldap, File file) {
        ldap.setProperty(ENABLED, "false");
        boolean stored = false;
        try {
            stored = this.storeLDAPConfig(ldap);
            if (stored) {
                sb.append("LDAP configuration can't be deleted. LDAP_URL=").append(ldapURL);
                sb.append("\nDisabled.");
            } else {
                sb.append("Error delete LDAP configuration file. LDAP_URL=").append(ldapURL);
                sb.append("\nDisabled in-memory only. Please delete file manually: ").append(file.getName());
            }
        }
        catch (Exception e) {
            sb.append("Error delete LDAP configuration file. ").append(e);
        }
    }

    protected File getLDAPFreeSlot() throws IOException {
        File file = null;
        File dir = new File(LDAP_DIR);
        if (!dir.exists()) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        for (int i = 1; i < 100 && (file = new File(dir, "ldap" + i + ".conf")).exists(); ++i) {
        }
        return file;
    }

    public boolean storeLDAPConfig(Properties ldap) throws Exception {
        String url;
        boolean stored = false;
        ldap.remove(LDAP_ADMIN);
        ldap.remove(LDAP_ADMIN_PASS);
        ldap.remove(LDAP_PASS);
        ldap.remove(LDAP_USER);
        ldap.remove(LDAP_SEARCH_DC);
        ldap.remove(LDAP_SEARCH_KEY);
        ldap.remove(LDAP_SEARCH_FILTER);
        ldap.remove(FILE_NAME);
        if (!ldap.containsKey(ENABLED)) {
            ldap.put(ENABLED, "true");
        }
        if ((url = ldap.getProperty(LDAP_URL)) != null) {
            File file = this.getExpectedLDAPConfigFile(url);
            if (file == null && (file = this.getLDAPFreeSlot()) == null) {
                throw new Exception("No free slots");
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                ldap.store(fos, "");
                stored = true;
                if (!this.ldapUrlOrder.contains(url)) {
                    this.ldapUrlOrder.add(url);
                }
                this.saveUrlOrder(this.ldapUrlOrder);
                this.ldapConfigs.put(url, ldap);
                ldap.setProperty(FILE_NAME, file.getName());
            }
        } else {
            throw new Exception("LDAP_URL is not specified");
        }
        return stored;
    }

    String listLDAPConfigs2() {
        StringBuilder sb = new StringBuilder();
        for (String url : this.ldapUrlOrder) {
            Properties ldap = this.getLdapProperties(url);
            if (ldap == null) continue;
            String fileName = ldap.getProperty(FILE_NAME);
            sb.append("--- ").append(fileName).append(" ---\n");
            ArrayList<String> keys = new ArrayList<String>();
            for (Object o : ldap.keySet()) {
                String name = (String)o;
                if (FILE_NAME.equals(name)) continue;
                keys.add(name);
            }
            Collections.sort(keys);
            for (String key : keys) {
                sb.append(key).append('=').append(ldap.getProperty(key)).append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    protected File getExpectedLDAPConfigFile(String ldapURL) throws IOException {
        File dir;
        if (ldapURL == null) {
            return null;
        }
        if (ldapURL.endsWith("/")) {
            ldapURL = ldapURL.substring(0, ldapURL.lastIndexOf(47));
        }
        if (!(dir = new File(LDAP_DIR)).exists()) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        File file = null;
        File[] list = dir.listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            String name = list[i].getName();
            if (!name.startsWith("ldap")) continue;
            File file1 = list[i];
            Properties p = new Properties();
            try (FileInputStream fis = new FileInputStream(file1);){
                p.load(fis);
            }
            String url = p.getProperty(LDAP_URL);
            if (url.endsWith("/")) {
                url = url.substring(0, url.lastIndexOf(47));
            }
            if (!url.equalsIgnoreCase(ldapURL)) continue;
            file = file1;
            break;
        }
        return file;
    }

    protected UserRole checkUserLogin(String login, String password) {
        UserRole role = null;
        User user = this.getUser(login);
        if (user != null && !this.bruteForceDetector.isUserLocked(login)) {
            if (user.getLoginName() != null && user.getLoginName().equals(login) && !LDAP2.equals(user.getEncryptedPwd()) && Cryptor.decrypt(password).equals(Cryptor.decrypt(user.getEncryptedPwd())) && user.isActive()) {
                role = this.getRoleByName(user.getRoleName());
                this.bruteForceDetector.processLoginSuccessful(login);
            } else if (user.isActive()) {
                this.bruteForceDetector.processLoginFailed(login);
            }
        }
        return role;
    }

    public UserRole checkUser(String login, String encryptedPass) {
        User u = this.getUser(login);
        if (u == null) {
            return null;
        }
        UserRole userRole = this.isLDAPEnabled() ? this.checkLDAP(login, encryptedPass) : this.checkUserLogin(login, encryptedPass);
        return userRole;
    }

    protected void loadUsers() {
        this.userMap.clear();
        for (User user : ServerEngine.getInstance().getDB().readUsers()) {
            if (user != null && user.getLoginName() != null) {
                this.userMap.put(user.getLoginName(), user);
                continue;
            }
            if (user == null) {
                RTLogger.print(1, "skip user 'null' loaded from db");
                continue;
            }
            RTLogger.print(1, "skip user with 'null' loginName loaded from db");
        }
    }

    public List<User> getUsers() {
        return new ArrayList<User>(this.userMap.values());
    }

    public List<User> getUsers(String roleID) {
        LinkedList<User> res = new LinkedList<User>();
        for (Map.Entry<String, User> entry : this.userMap.entrySet()) {
            User u = entry.getValue();
            if (u == null || !u.getRoleID().equals(roleID)) continue;
            res.add(u);
        }
        return res;
    }

    public List<UItem> getUItems() {
        return new ArrayList<UItem>(this.items.values());
    }

    protected void updateUserInMemory(User user, boolean isDelete) {
        try {
            String prefix = user.getLoginName() + "SEPARATOR";
            this.cachedAuth.entrySet().removeIf(en -> ((String)en.getKey()).startsWith(prefix));
        }
        catch (Exception e) {
            RTLogger.print(3, "", e);
        }
        if (isDelete) {
            this.userMap.remove(user.getLoginName());
        } else {
            User stored = this.userMap.put(user.getLoginName(), user);
            if (stored != null) {
                if (!stored.isActive() && user.isActive()) {
                    this.unlockUser(user.getLoginName());
                }
                GUIWorker.disconnectUser(user.getLoginName());
            }
        }
    }

    protected void updateRoleInMemory(UserRole userRole, boolean isDelete) {
        UserRole old = null;
        boolean nodeRightsChanged = false;
        Iterator<Map.Entry<String, UserRole>> it = this.rolesMap.entrySet().iterator();
        while (it.hasNext()) {
            int newNodeRight;
            Map.Entry<String, UserRole> en = it.next();
            if (!en.getValue().getID().equals(userRole.getID())) continue;
            old = en.getValue();
            int oldNodeRight = old.getRightLevel(1002);
            if (oldNodeRight != (newNodeRight = userRole.getRightLevel(1002))) {
                nodeRightsChanged = true;
            }
            it.remove();
            break;
        }
        if (!isDelete) {
            this.rolesMap.put(userRole.getName(), userRole);
            if (nodeRightsChanged) {
                this.onNodeGroupChange();
            }
            ForwardManager fm = ServerEngine.getInstance().getForwardManager();
            if (old != null && !old.getName().equals(userRole.getName())) {
                List<User> userList = this.getUsers(old.getID());
                for (User user : userList) {
                    if (user == null || user.getRoleName().equals(userRole.getName())) continue;
                    user.setRoleName(userRole.getName());
                    this.saveUser(user);
                }
                boolean forwardRefresh = false;
                if (fm != null) {
                    String oldRoleInFP = old.getNameInBrackets();
                    String newRoleInFP = userRole.getNameInBrackets();
                    for (ForwardPolicy fp : fm.getPolicies()) {
                        if (!fp.getAllUsers().contains(oldRoleInFP)) continue;
                        RTLogger.print(3, "Updating FP " + fp.policyName + " with new UserRole name: " + newRoleInFP);
                        try {
                            fm.updateFwdUsrPolicy(fp, oldRoleInFP, newRoleInFP);
                            forwardRefresh = true;
                        }
                        catch (Exception e) {
                            RTLogger.print(3, "Error updating FP", e);
                        }
                    }
                }
                if (forwardRefresh) {
                    ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_FORWARD_POLICIES");
                }
            }
            if (fm != null) {
                fm.cleanIndicationCache();
            }
        } else {
            List<User> users = this.getUsers(userRole.getID());
            if (users != null) {
                for (User user : users) {
                    this.deleteUser(user);
                }
            }
        }
    }

    public boolean saveUser(User user) {
        boolean isOk = false;
        try {
            UserRole ur = this.getRoleByName(user.getRoleName());
            if (user.getRoleID() == null || user.getRoleID().length() == 0) {
                if (ur != null) {
                    user.setRoleID(ur.getID());
                    user.setRoleName(ur.getName());
                }
            } else if (ur != null && !ur.getID().equals(user.getRoleID())) {
                user.setRoleID(ur.getID());
                user.setRoleName(ur.getName());
            } else {
                UserRole byID = this.getRoleByID(user.getRoleID());
                if (byID != null && !user.getRoleName().equals(byID.getName())) {
                    user.setRoleID(byID.getID());
                    user.setRoleName(byID.getName());
                }
            }
            ServerEngine.getInstance().getDB().saveUser(user);
            this.updateUserInMemory(user, false);
            isOk = true;
            GUIWorker.disconnectUser(user.getLoginName());
        }
        catch (Exception e) {
            RTLogger.print(5, "Error saving user " + user.getLoginName(), e);
        }
        return isOk;
    }

    public boolean deleteUser(User user) {
        boolean isSuccess = false;
        try {
            ServerEngine.getInstance().getDB().deleteUser(user);
            this.updateUserInMemory(user, true);
            isSuccess = true;
            GUIWorker.disconnectUser(user.getLoginName());
        }
        catch (Exception e) {
            RTLogger.print(5, "Error deleting user " + user.getLoginName(), e);
        }
        return isSuccess;
    }

    public boolean saveRole(UserRole role, boolean disconnect) {
        boolean isSuccess = false;
        try {
            this.ensureAllRightsAssigned(role);
            ServerEngine.getInstance().getDB().saveRole(role);
            this.updateRoleInMemory(role, false);
            if (disconnect) {
                List<User> list = this.getUsers(role.getID());
                for (User u : list) {
                    GUIWorker.disconnectUser(u.getLoginName());
                }
            }
            isSuccess = true;
        }
        catch (Exception e) {
            RTLogger.print(5, "Error saving role " + role.getName(), e);
        }
        return isSuccess;
    }

    public boolean deleteRole(UserRole role) {
        boolean isSuccess = false;
        try {
            ServerEngine.getInstance().getDB().deleteRole(role);
            this.updateRoleInMemory(role, true);
            List<User> list = this.getUsers(role.getID());
            for (User u : list) {
                GUIWorker.disconnectUser(u.getLoginName());
            }
            isSuccess = true;
        }
        catch (Exception e) {
            RTLogger.print(5, "Error deleting user role " + role.getName(), e);
        }
        return isSuccess;
    }

    protected List<UserRole> loadRoles() {
        this.rolesMap.clear();
        List<UserRole> userRoles = ServerEngine.getInstance().getDB().readRoles();
        for (UserRole role : userRoles) {
            if (role != null && role.getName() != null) {
                this.rolesMap.put(role.getName(), role);
                continue;
            }
            if (role == null) {
                RTLogger.print(1, "skipped userrole 'null' loaded from db");
                continue;
            }
            RTLogger.print(1, "skipped userrole with name: 'null' loaded from db");
        }
        return userRoles;
    }

    public List<UserRole> getRoles() {
        return new ArrayList<UserRole>(this.rolesMap.values());
    }

    public List<UserRole> getRoles(String userRequesting) {
        UserRole currentRequest = this.getRoleForUser(userRequesting);
        if (currentRequest != null && currentRequest.getRightLevel(1004) > 1) {
            return this.getRoles();
        }
        ArrayList<UserRole> currentOnly = new ArrayList<UserRole>(1);
        currentOnly.add(currentRequest);
        return currentOnly;
    }

    public UserRole getRoleByName(String roleName) {
        return this.rolesMap.get(roleName);
    }

    public void addRole(UserRole userRole) {
        this.rolesMap.put(userRole.getName(), userRole);
    }

    public UserRole getRoleByID(String roleID) {
        UserRole res = null;
        for (Map.Entry<String, UserRole> en : this.rolesMap.entrySet()) {
            if (!en.getValue().getID().equals(roleID)) continue;
            res = en.getValue();
            break;
        }
        return res;
    }

    public User getUser(String loginName) {
        return this.userMap.get(loginName);
    }

    public void setUser(User user) {
        this.userMap.put(user.getLoginName(), user);
    }

    public UserRole getRoleForUser(String userName) {
        if (PRIMARY_SERVER.equals(userName)) {
            return this.getRoleByName(ADMINISTRATOR);
        }
        User u = this.getUser(userName);
        if (u != null && u.getLoginName() != null && u.getLoginName().equalsIgnoreCase(userName)) {
            return this.getRoleByName(u.getRoleName());
        }
        return null;
    }

    public boolean isUserEnabled(String userName) {
        User u = this.getUser(userName);
        if (u != null && u.getLoginName() != null && u.getLoginName().equals(userName)) {
            return u.getActive() == 1;
        }
        return false;
    }

    public boolean isUserLocked(String userName) {
        User u = this.getUser(userName);
        if (u != null && u.getLoginName() != null && u.getLoginName().equals(userName)) {
            return this.bruteForceDetector.isUserLocked(userName);
        }
        return false;
    }

    public void unlockUser(String userName) {
        User u = this.getUser(userName);
        if (u != null && u.getLoginName() != null && u.getLoginName().equals(userName) && this.bruteForceDetector.isUserLocked(userName)) {
            this.bruteForceDetector.processLoginSuccessful(userName);
        }
    }

    public boolean roleExist(String name) {
        return this.rolesMap.containsKey(name);
    }

    protected void loadItems() {
        try {
            List<UItem> list = ServerEngine.getInstance().getDB().readItems();
            for (UItem uItem : list) {
                if (uItem == null) continue;
                this.items.put(uItem.id, uItem);
            }
        }
        catch (Exception e) {
            RTLogger.print(5, "Error loading item data ", e);
        }
    }

    public int getRights(int item, String username) {
        UserRole activeRole = this.getRoleForUser(username);
        return this.getRights(item, activeRole);
    }

    public int getRights(int item, UserRole activeRole) {
        List<UserRight> list;
        int level = 0;
        if (activeRole != null && (list = activeRole.getRights()) != null) {
            for (UserRight m : list) {
                if (m.getItemID() != item) continue;
                level = m.getLevel();
                break;
            }
        }
        return level;
    }

    public void loadPowerGroups() {
        try {
            this.getPowerGroupFactory().clearAllRights();
            Map<String, PowerGroup> pgroups = ServerEngine.getInstance().getDB().readPowerGroups();
            HashMapMap<String, String> pgrights = ServerEngine.getInstance().getDB().readPGRights();
            for (String userRoleID : pgrights.keySet()) {
                UserRole ur = this.getRoleByID(userRoleID);
                if (ur == null) continue;
                Map<String, Object> groups = pgrights.getHashMap(userRoleID);
                for (String pgid : groups.keySet()) {
                    PowerGroup pg = pgroups.get(pgid);
                    if (pg == null) continue;
                    this.getPowerGroupFactory().addPowerGroup(ur.getID(), pg);
                }
            }
            CMDS.m_acceptable.put("GET_ASNTREEPERMISSIONS", 221);
            CMDS.m_acceptable.put("GET_POLICYTREEPERMISSIONS", 214);
            CMDS.m_acceptable.put("GET_POWERGROUPS", 216);
            CMDS.m_acceptable.put("PUT_POWERGROUPS", 217);
            CMDS.m_acceptable.put("DELETE_POWERGROUPS", 218);
            CMDS.m_acceptable.put("DB_POWERGROUPS_LOAD", 219);
            CMDS.m_acceptable.put("GET_NODEGROUPTREEPERMISSIONS", 252);
        }
        catch (Exception e) {
            RTLogger.print(2, "Warning loading Privileged groups skipped");
            CMDS.m_acceptable.remove("GET_ASNTREEPERMISSIONS");
            CMDS.m_acceptable.remove("GET_POLICYTREEPERMISSIONS");
            CMDS.m_acceptable.remove("GET_POWERGROUPS");
            CMDS.m_acceptable.remove("PUT_POWERGROUPS");
            CMDS.m_acceptable.remove("DELETE_POWERGROUPS");
            CMDS.m_acceptable.remove("DB_POWERGROUPS_LOAD");
            CMDS.m_acceptable.remove("GET_NODEGROUPTREEPERMISSIONS");
        }
    }

    public void savePowerGroup(String roleID, PowerGroup pg) {
        ArrayList<PowerGroup> list = new ArrayList<PowerGroup>(1);
        list.add(pg);
        this.savePowerGroups(roleID, list);
    }

    protected void savePowerGroups(String roleID, List<PowerGroup> list) {
        ServerEngine.getInstance().getDB().savePowerGroups(roleID, list);
        EventsRouter eventsRouter = ServerEngine.getInstance().getEventsRouter();
        if (eventsRouter != null) {
            eventsRouter.addPendingToALL("GET_ASNTREEPERMISSIONS");
            eventsRouter.addPendingToALL("GET_POLICYTREEPERMISSIONS");
            eventsRouter.addPendingToALL("GET_POWERGROUPS");
            eventsRouter.addPendingToALL("GET_NODEGROUPTREEPERMISSIONS");
        }
    }

    protected void deletePowerGroups(String userRoleID, List<String> pgidListD) {
        ServerEngine.getInstance().getDB().deletePGRights(userRoleID, pgidListD);
        EventsRouter eventsRouter = ServerEngine.getInstance().getEventsRouter();
        if (eventsRouter != null) {
            eventsRouter.addPendingToALL("GET_ASNTREEPERMISSIONS");
            eventsRouter.addPendingToALL("GET_POLICYTREEPERMISSIONS");
            eventsRouter.addPendingToALL("GET_POWERGROUPS");
            eventsRouter.addPendingToALL("GET_NODEGROUPTREEPERMISSIONS");
        }
    }

    protected PowerGroupFactory getPowerGroupFactory() {
        return this.powerGroupFactory;
    }

    public boolean checkPolicy(String user, PGEntityAction action, String policyName, String policyType) {
        return this.getPowerGroupFactory().checkAction4PolicyTree(this.getRoleForUser(user).getID(), PGEntityAction.MODIFY, policyName, policyType, this.getRights(1001, user));
    }

    public boolean checkAsnTree(String user, PGEntityAction action, String pgaName) {
        return this.getPowerGroupFactory().checkAction4AsnTree(this.getRoleForUser(user).getID(), action, pgaName, this.getRights(1008, user));
    }

    public GroupTreeObject getPolicyTreePermissions(String user) {
        String userRole = this.getRoleForUser(user).getID();
        return this.getPolicyTreePermissions(userRole, this.getRights(1001, user));
    }

    public GroupTreeObject getAsnTreePermissions(String user) {
        String userRole = this.getRoleForUser(user).getID();
        return this.getAsnTreePermissions(userRole, this.getRights(1008, user));
    }

    @Override
    public void addPowerGroup(String userRoleID, PowerGroup pg) {
        this.savePowerGroup(userRoleID, pg);
        this.getPowerGroupFactory().addPowerGroup(userRoleID, pg);
        this.onNodeGroupChange();
    }

    @Override
    public Map<PowerGroup, Object> getAllPowerGroups() {
        return this.getPowerGroupFactory().getAllPowerGroups();
    }

    @Override
    public ConcurrentHashMapMap<String, PowerGroup> getAllPowerGroups2() {
        return this.getPowerGroupFactory().getAllPowerGroups2();
    }

    @Override
    public Map<PowerGroup, Object> getPowerGroups(String userRoleID) {
        return this.getPowerGroupFactory().getPowerGroups(userRoleID);
    }

    @Override
    public boolean removePowerGroup(String userRoleID, List<String> pgidList) {
        this.deletePowerGroups(userRoleID, pgidList);
        boolean removed = this.getPowerGroupFactory().removePowerGroup(userRoleID, pgidList);
        this.onNodeGroupChange();
        return removed;
    }

    @Override
    public boolean checkAction4PolicyTree(String userRoleID, PGEntityAction action, String policyNameOrPath, String policyType, int generalAccessRight) {
        return this.getPowerGroupFactory().checkAction4PolicyTree(userRoleID, action, policyNameOrPath, policyType, generalAccessRight);
    }

    @Override
    public GroupTreeObject getActionGroups() {
        return this.getPowerGroupFactory().getActionGroups();
    }

    @Override
    public Map<String, AbstractAgentCard> getAgents() {
        return this.getPowerGroupFactory().getAgents();
    }

    @Override
    public Collection<PGItem> getAllExclusiveItems(ObjectType type) {
        return this.getPowerGroupFactory().getAllExclusiveItems(type);
    }

    @Override
    public GroupTreeObject getAssignmentGroups() {
        return this.getPowerGroupFactory().getAssignmentGroups();
    }

    @Override
    public Collection<PGItem> getExclusiveItems(String userRoleID, ObjectType type) {
        return this.getPowerGroupFactory().getExclusiveItems(userRoleID, type);
    }

    @Override
    public GroupTreeObject getNodeGroups() {
        return this.getPowerGroupFactory().getNodeGroups();
    }

    public GroupTreeObject getNodeGroups(String user) {
        GroupTreeObject nodeGroups = this.getPowerGroupFactory().getNodeGroups();
        if (this.isUserNodeGroupFiltered(user)) {
            UserRole userROLE = this.getRoleForUser(user);
            nodeGroups = this.getNodeGroups(userROLE);
        }
        return nodeGroups;
    }

    public GroupTreeObject getNodeGroups(UserRole userRole) {
        return this.getUserGroupTree(userRole).getTree();
    }

    public UserGroupTree getUserGroupTree(UserRole userRole) {
        String userRoleID = userRole.getID();
        UserGroupTree ugt = this.role2NodeGroupTree.get(userRoleID);
        if (ugt == null) {
            ugt = new UserGroupTree(this._createNodeGroupTree(userRoleID));
            this.role2NodeGroupTree.put(userRoleID, ugt);
        }
        return ugt;
    }

    protected GroupTreeObject _createNodeGroupTree(String userRoleID) {
        GroupTreeObject nodeGroups = null;
        GroupTreeObject groups = null;
        if (this.getRights(1002, this.getRoleByID(userRoleID)) < 2) {
            nodeGroups = new GroupTreeObject(new TreeObject("root", null, null));
            groups = new GroupTreeObject(new TreeObject("_Groups", "", null));
            nodeGroups.addElement(groups);
            Map<PowerGroup, Object> powerGroups = this.getPowerGroups(userRoleID);
            if (powerGroups != null) {
                for (PowerGroup pg : powerGroups.keySet()) {
                    block14: for (PGItem pi : pg.getAllItems()) {
                        if (pi.getObjectType() != ObjectType.ngr) continue;
                        switch (pi.getAction()) {
                            case READ: 
                            case MODIFY: {
                                GroupTreeObject gto = nodeGroups.searchPath(pi.getPath(), "");
                                if (gto == null) {
                                    gto = nodeGroups.searchPath(pi.getPath(), "agt");
                                }
                                switch (pi.getPermFlag()) {
                                    case RESTRICT: {
                                        break;
                                    }
                                    case ENFORCE: 
                                    case EXCLUSIVE: {
                                        if (gto == null) {
                                            GroupTreeObject toAdd = this.getPowerGroupFactory().getNodeGroups().searchPath(pi.getPath(), "");
                                            if (toAdd == null) {
                                                toAdd = this.getPowerGroupFactory().getNodeGroups().searchPath(pi.getPath(), "agt");
                                            }
                                            if (toAdd == null) continue block14;
                                            GroupTreeObject parent = GroupTreeObject.createPath(toAdd.getParent().getPath(), nodeGroups);
                                            try {
                                                toAdd = toAdd.clone();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            parent.addElement(toAdd);
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                continue block14;
                            }
                        }
                    }
                }
            }
        } else {
            try {
                nodeGroups = this.getNodeGroups().clone();
                groups = nodeGroups.getChild("_Groups", "");
            }
            catch (CloneNotSupportedException powerGroups) {
                // empty catch block
            }
            if (nodeGroups == null) {
                nodeGroups = new GroupTreeObject(new TreeObject("root", null, null));
            }
            if (groups == null) {
                groups = new GroupTreeObject(new TreeObject("_Groups", "", null));
                nodeGroups.addElement(groups);
            }
        }
        nodeGroups.mergeAttributesFromTree(this.getNodeGroupsTreePermissionsR(userRoleID));
        ArrayList<String> enforcement = new ArrayList<String>(2);
        enforcement.add(PGEntityPermissionFlag.ENFORCE.name());
        enforcement.add(PGEntityPermissionFlag.EXCLUSIVE.name());
        List<GroupTreeObject> allRestrictedElements = nodeGroups.findElementsByAttribute(PGEntityAction.READ.name(), PGEntityPermissionFlag.RESTRICT.name());
        for (GroupTreeObject gto : allRestrictedElements) {
            gto.removeElementsIfAttributeNotSetRecursive(PGEntityAction.READ.name(), enforcement);
            if (gto.hasElements().booleanValue() || "/root/_Groups".equals(gto.getPath())) continue;
            try {
                GroupTreeObject parent = gto.getParent();
                parent.removeElement(gto);
            }
            catch (Exception exception) {}
        }
        return nodeGroups;
    }

    public GroupTreeObject getNodeGroupsTreePermissions(String user) {
        String userRoleID = this.getRoleForUser(user).getID();
        return this.getNodeGroupsTreePermissionsR(userRoleID);
    }

    public GroupTreeObject getNodeGroupsTreePermissionsR(String userRoleID) {
        return this.getPowerGroupFactory().getNodeGroupTreePermissions(userRoleID, this.getRights(1002, this.getRoleByID(userRoleID)));
    }

    @Override
    public GroupTreeObject getPackageGroups() {
        return this.getPowerGroupFactory().getPackageGroups();
    }

    @Override
    public GroupTreeObject getPolicyGroups() {
        return this.getPowerGroupFactory().getPolicyGroups();
    }

    @Override
    public GroupTreeObject getPolicyTreePermissions(String userRoleID, int generalAccess) {
        return this.getPowerGroupFactory().getPolicyTreePermissions(userRoleID, generalAccess);
    }

    @Override
    public GroupTreeObject getAsnTreePermissions(String userRoleID, int generalAccess) {
        return this.getPowerGroupFactory().getAsnTreePermissions(userRoleID, generalAccess);
    }

    @Override
    public void setActionGroups(GroupTreeObject actionGroups) {
        this.getPowerGroupFactory().setActionGroups(actionGroups);
    }

    @Override
    public void setAgents(Map<String, AbstractAgentCard> agents) {
        this.getPowerGroupFactory().setAgents(agents);
    }

    @Override
    public void setAssignmentGroups(IAssignmentTree assignmentGroups) {
        this.getPowerGroupFactory().setAssignmentGroups(assignmentGroups);
    }

    @Override
    public void setNodeGroups(INodeGroupTree nodeGroups) {
        this.getPowerGroupFactory().setNodeGroups(nodeGroups);
    }

    @Override
    public void setPackageGroups(GroupTreeObject packageGroups) {
        this.getPowerGroupFactory().setPackageGroups(packageGroups);
    }

    @Override
    public void setPolicyGroups(IPolicyTree policyGroupsTree) {
        this.getPowerGroupFactory().setPolicyGroups(policyGroupsTree);
    }

    @Override
    public boolean checkAction4AsnTree(String userRoleID, PGEntityAction action, String pgaNameOrPath, int generalAccessRight) {
        return this.getPowerGroupFactory().checkAction4AsnTree(userRoleID, action, pgaNameOrPath, generalAccessRight);
    }

    public boolean checkAction4NodeGroupTree(String userRoleID, PGEntityAction action, String agentIDOrPath) {
        return this.getPowerGroupFactory().checkAction4NodeGroupTree(userRoleID, action, agentIDOrPath, this.getRights(1002, this.getRoleByID(userRoleID)));
    }

    public boolean checkAction4Agents(String userRoleID, PGEntityAction action, Collection<String> agentIDs) {
        for (String id : agentIDs) {
            if (this.checkAction4NodeGroupTree(userRoleID, action, id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isObjectTypeFiltered(String userRoleID, ObjectType objType) {
        return this.getPowerGroupFactory().isObjectTypeFiltered(userRoleID, objType);
    }

    public boolean isUserNodeGroupFiltered(String user) {
        UserRole ur = this.getRoleForUser(user);
        return this.isUserRoleNodeGroupFiltered(ur);
    }

    public boolean isUserRoleNodeGroupFiltered(UserRole ur) {
        return ur != null && this.isObjectTypeFiltered(ur.getID(), ObjectType.ngr);
    }

    public boolean isAgentVisible(String user, String agentID) {
        return this.isAgentVisible(user, agentID, this.getNodeGroups(user));
    }

    public boolean isAgentVisible(String user, String agentID, GroupTreeObject userNodeGroup) {
        UserRole role = this.getRoleForUser(user);
        return this.isAgentVisible(agentID, userNodeGroup, role);
    }

    public boolean isAgentVisible(String agentID, GroupTreeObject userNodeGroup, UserRole role) {
        if (role == null) {
            return false;
        }
        if (this.isObjectTypeFiltered(role.getID(), ObjectType.ngr)) {
            if (NodeGroupRepository.getInstance().isAgentLinkedToNodeGroupTree(agentID)) {
                List<GroupTreeObjectLast> agentsInTheTree = userNodeGroup.findLinksByName(agentID, "agt");
                return !agentsInTheTree.isEmpty();
            }
            return this.getRights(1002, role) >= 3 && UserManager.getInstance().checkAction4NodeGroupTree(role.getID(), PGEntityAction.READ, "/root/_Groups");
        }
        return this.getRights(1002, role) >= 2;
    }

    public Collection<String> getVisibleAgentsIDs(String user) {
        UserRole role;
        Collection<String> ids = null;
        if (this.isUserNodeGroupFiltered(user) && (role = this.getRoleForUser(user)) != null) {
            return this.getVisibleAgentsIDs(role);
        }
        return ids;
    }

    public Collection<String> getVisibleAgentsIDs(UserRole role) {
        Collection<String> ids = null;
        if (this.isUserRoleNodeGroupFiltered(role)) {
            ids = this.getUserGroupTree(role).getAgentIDs();
        }
        return ids;
    }

    public void onNodeGroupChange() {
        ServerThreadPool.getInstance().submit(this::_onNodeGroupChange);
    }

    private void _onNodeGroupChange() {
        ArrayList<String> usersToDisconnect = new ArrayList<String>(20);
        ArrayList<String> usersToNotify = new ArrayList<String>(20);
        for (String roleID : this.role2NodeGroupTree.keySet()) {
            UserGroupTree oldUgTree = this.role2NodeGroupTree.get(roleID);
            UserGroupTree newUgTree = new UserGroupTree(this._createNodeGroupTree(roleID));
            boolean eq = oldUgTree.getTree() == null ? newUgTree.getTree() == null : oldUgTree.getTree().isEqualRecursive(newUgTree.getTree());
            if (eq) continue;
            this.role2NodeGroupTree.put(roleID, newUgTree);
            Collection<String> oldAgents = oldUgTree.getAgentIDs();
            Collection<String> newAgents = newUgTree.getAgentIDs();
            if (oldAgents.size() != newAgents.size() || oldAgents.retainAll(newAgents)) {
                for (User u : this.getUsers(roleID)) {
                    usersToDisconnect.add(u.getLoginName());
                }
                continue;
            }
            for (User u : this.getUsers(roleID)) {
                if (usersToDisconnect.contains(u.getLoginName())) continue;
                usersToNotify.add(u.getLoginName());
            }
        }
        ServerEngine.getInstance().getForwardManager().cleanIndicationCache();
        if (!usersToDisconnect.isEmpty()) {
            RTLogger.print(3, "NG tree change requires to disconnect users: " + String.valueOf(usersToDisconnect));
            for (String userName : usersToDisconnect) {
                GUIWorker.disconnectUser(userName);
            }
        }
        for (String userName : usersToNotify) {
            ServerEngine.getInstance().getEventsRouter().addPendingToUser("REFRESH_NODEGROUPS", userName);
        }
    }

    public void renamePowerGroupNGPath(String oldNGPath, String newNGPath) {
        boolean isRolePGchanged = false;
        for (UserRole ur : this.getRoles()) {
            Map<PowerGroup, Object> map = this.getPowerGroups(ur.getID());
            for (PowerGroup pg : map.keySet()) {
                boolean toSave = false;
                if (!pg.hasItems(ObjectType.ngr)) continue;
                for (PGItem pi : pg.getAllItems()) {
                    if (pi.getObjectType() != ObjectType.ngr || !pi.getPath().startsWith(oldNGPath + BM.GTO_PATH_SEPARATOR) && !pi.getPath().equals(oldNGPath)) continue;
                    toSave = true;
                    pi.setPath(newNGPath);
                }
                if (!toSave) continue;
                this.savePowerGroup(ur.getID(), pg);
                isRolePGchanged = true;
            }
        }
        if (isRolePGchanged) {
            this.onNodeGroupChange();
        }
    }

    public BruteForceDetector getBruteForceDetector() {
        return this.bruteForceDetector;
    }
}

