/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.audit;

import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import java.io.PrintStream;
import java.util.List;

public class AuditLog
extends SALogger {
    public static final String DELETE = "DELETE";
    public static final String NEW = "NEW";
    public static final String MODIFY = "MODIFY";
    public static final String DEPLOY = "DEPLOY";
    public static final String DEPLOYQUEUE = "DEPLOYQUEUE";
    public static final String REDEPLOY = "REDEPLOY";
    public static final String UNDEPLOY = "UNDEPLOY";
    public static final String UNDEPLOYQUEUE = "UNDEPLOYQUEUE";
    public static final String DISABLE = "DISABLE";
    public static final String ENABLE = "ENABLE";
    public static final String TRIGGERSYNC = "TRIGGERSYNC";
    public static final String RENAME = "RENAME";
    public static final String RUN_ON_AGENT = "RUN_ON_AGENT";
    public static final String RUN_ON_SERVER = "RUN_ON_SERVER";
    public static final String CONNECT = "CONNECT";
    public static final String DISCONNECT = "DISCONNECT";
    public static final String FAILEDLOGIN = "FAILEDLOGIN";
    public static final String ACCOUNTDISABLED = "ACCOUNTDISABLED";
    public static final String ACCOUNTLOCKED = "ACCOUNTLOCKED";
    public static final String WRONGCREDENTIALS = "WRONGCREDENTIALS";

    public AuditLog() {
    }

    public AuditLog(String dir, String prefix, int logCount, long sizelimit_bytes) {
        super(dir, prefix, logCount, sizelimit_bytes);
    }

    public void log(String user, String action, String subject, String target) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(user).append(' ').append(action);
            if (subject != null) {
                sb.append(' ').append(subject);
            }
            if (target != null) {
                sb.append(" > ").append(target);
            }
            this.print(1, sb);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error writing into audit log", e);
        }
    }

    public void logDelete(String user, String subject) {
        this.log(user, DELETE, subject, null);
    }

    public void logCreate(String user, String subject) {
        this.log(user, NEW, subject, null);
    }

    public void logModify(String user, String subject) {
        this.log(user, MODIFY, subject, null);
    }

    public void logModify(String user, String subject, String what) {
        this.log(user, MODIFY, subject, what);
    }

    public void logDeploy(String user, String subject, String target) {
        this.log(user, DEPLOY, subject, target);
    }

    public void logDeployQueue(String user, String subject, String target) {
        this.log(user, DEPLOYQUEUE, subject, target);
    }

    public void logRunOnAgent(String user, String subject, String what) {
        this.log(user, RUN_ON_AGENT, subject, what);
    }

    public void logRunOnServer(String user, String subject, String what) {
        this.log(user, RUN_ON_SERVER, subject, what);
    }

    public void log(String user, String action, List<String> subject, List<String> agents) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(user).append(' ').append(action);
            this.print(1, sb);
            PrintStream printStream = this.getPrintStream(false);
            printStream.print("\t");
            printStream.print(subject);
            printStream.print("\n\tAgents: " + String.valueOf(agents));
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error writing into audit log", e);
        }
    }

    public void logReDeploy(String user, String subject, String target) {
        this.log(user, REDEPLOY, subject, target);
    }

    public void logUnDeploy(String user, String subject, String target) {
        this.log(user, UNDEPLOY, subject, target);
    }

    public void logUnDeployQueue(String user, String subject, String target) {
        this.log(user, UNDEPLOYQUEUE, subject, target);
    }

    public void logDisable(String user, String subject, String target) {
        this.log(user, DISABLE, subject, target);
    }

    public void logEnable(String user, String subject, String target) {
        this.log(user, ENABLE, subject, target);
    }

    public void logTriggerSync(String user, String target) {
        this.log(user, TRIGGERSYNC, "", target);
    }

    public void logRename(String user, String oldObj, String newObj) {
        this.log(user, RENAME, oldObj, newObj);
    }
}

