/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.ctrl.sc.in.ScSaveAgentOutagePolicies;
import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.AgentsRepository;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.UserManager;
import com.blixx.server.correlation.AbstractOutageManager;
import com.blixx.server.correlation.CorrelationEvents;
import com.blixx.server.correlation.IServerCorrelationProcessor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.IServerPolicyListener;
import com.blixx.shared.ext.TimeInterval;
import com.blixx.shared.utils.GroupTreeObject;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AgentOutageManager
extends AbstractOutageManager<AgentOutagePolicy>
implements Runnable,
IServerPolicyListener<AgentOutagePolicy>,
IServerCorrelationProcessor {
    public Map<String, List<String>> m_agentToPoliciesMap = Collections.synchronizedMap(new HashMap());
    public List<String> toSave = new LinkedList<String>();
    public Map<String, String> m_overdueNotification = new HashMap<String, String>();

    public AgentOutageManager(EventOperationsOutage eo) {
        super(eo);
        this.init();
    }

    public void init() {
        List<AgentOutagePolicy> list = ServerEngine.getInstance().getDB().readAgentOutagePolicies();
        for (AgentOutagePolicy ap : list) {
            this.addPolicyNoSave(ap);
        }
    }

    public void updatePoliciesFromSlave(SlaveServerCard ssc) {
        this.m_slaveOutagePolicies.put(ssc, ssc.getAgentOutages());
    }

    @Override
    public boolean checkAndProcess(SEventFwd sef, AgentCard ac) {
        boolean matched = false;
        if (ac != null && this.m_agentToPoliciesMap.containsKey(ac.getAgentID())) {
            List<String> policies = this.m_agentToPoliciesMap.get(ac.getAgentID());
            for (String id : policies) {
                AgentOutagePolicy ap = (AgentOutagePolicy)this.m_policies.get(id);
                if (ap == null || !ap.check(sef)) continue;
                this.doAction(ap, sef, ac);
                matched = true;
                break;
            }
        }
        return matched;
    }

    @Override
    public boolean checkAndProcessInternal(SEventFwd sef) {
        boolean matched = false;
        String agentID = sef.getT1();
        if (agentID != null && this.m_agentToPoliciesMap.containsKey(agentID)) {
            List<String> policies = this.m_agentToPoliciesMap.get(agentID);
            for (String id : policies) {
                AgentOutagePolicy ap = (AgentOutagePolicy)this.m_policies.get(id);
                if (ap == null || !ap.check(sef)) continue;
                this.doAction(ap, sef, (AgentCard)null);
                return true;
            }
        }
        return matched;
    }

    public void addServerPolicy(AgentOutagePolicy sp) throws Exception {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(sp.getAgentID());
        if (ac != null && ac.isLocalAgent()) {
            sp.setTimeInterval(new TimeInterval(System.currentTimeMillis(), sp.getTimeInterval().getInterval(), sp.getTimeInterval().getTimeMask()));
            AgentOutagePolicy p = this.addPolicyNoSave(sp);
            this.save(p);
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
        } else {
            if (ac == null) {
                throw new Exception("Agent not found: " + sp.getAgentID());
            }
            SlaveServerCard ssc = ServerEngine.getInstance().getSlave(ac.getRelatedServer());
            if (ssc != null) {
                ssc.getAgentOutages().put(sp.getID(), sp);
                ssc.getServerClient().start(new ScSaveAgentOutagePolicies(ssc, List.of(sp)));
            } else {
                throw new Exception("Slave not found: " + ac.getRelatedServer());
            }
        }
    }

    private AgentOutagePolicy addPolicyNoSave(AgentOutagePolicy sp) {
        List listP = this.m_agentToPoliciesMap.computeIfAbsent(sp.getAgentID(), k -> Collections.synchronizedList(new LinkedList()));
        listP.add(sp.getID());
        this.m_policies.put(sp.getID(), sp);
        sp.addListener(this);
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(AgentOutagePolicy p) {
        ArrayList<AgentOutagePolicy> listToSave = new ArrayList<AgentOutagePolicy>(1);
        listToSave.add(p);
        try {
            ServerEngine.getInstance().getDB().saveAgentOutagePolicies(listToSave);
        }
        catch (SQLException e) {
            e.printStackTrace();
            List<String> list = this.toSave;
            synchronized (list) {
                if (!this.toSave.contains(p.getID())) {
                    this.toSave.add(p.getID());
                }
            }
        }
    }

    @Override
    public void deletePolicy(String id) throws Exception {
        AgentOutagePolicy ap = (AgentOutagePolicy)this.m_policies.remove(id);
        if (ap != null) {
            ((List)this.m_agentToPoliciesMap.getOrDefault(ap.getAgentID(), new ArrayList())).remove(ap.getID());
            ServerEngine.getInstance().getDB().deleteAgentOutagePolicy(id);
            ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
            ap.setDisabledByFORCE("deleted");
        }
        this.m_overdueNotification.remove(id);
        this.renewAgentOutageFlag(id);
    }

    @Override
    public void doAction(AgentOutagePolicy p, SEventFwd sef, AgentCard ac) {
        super.doAction(p, sef, ac);
    }

    @Override
    public void doPostAction(AgentOutagePolicy p) {
        super.doPostAction(p);
    }

    @Override
    public List<AgentOutagePolicy> getServerPoliciesOrdered(String user) {
        ArrayList<AgentOutagePolicy> allAC = new ArrayList<AgentOutagePolicy>(this.m_policies.values());
        for (Map.Entry entry : this.m_slaveOutagePolicies.entrySet()) {
            allAC.ensureCapacity(allAC.size() + ((Map)entry.getValue()).size());
            allAC.addAll(((Map)entry.getValue()).values());
        }
        if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            GroupTreeObject nodeGroups = UserManager.getInstance().getNodeGroups(user);
            allAC.removeIf(ac -> !UserManager.getInstance().isAgentVisible(user, ac.getAgentID(), nodeGroups));
        }
        return allAC;
    }

    @Override
    public void setOrder(List<String> polIDs) {
    }

    @Override
    public AgentOutagePolicy getServerPolicy(String id) {
        return (AgentOutagePolicy)this.m_policies.get(id);
    }

    public boolean isPolicyKnown(String id) {
        return this.m_policies.containsKey(id);
    }

    public boolean equals4UserAdHoc(AgentOutagePolicy ap) {
        for (AgentOutagePolicy sp : this.m_policies.values()) {
            if (!sp.equals4UserAdHoc(ap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStopProcessing() {
        return true;
    }

    @Override
    public void onEvent(int eventType, AgentOutagePolicy sp) {
        switch (eventType) {
            case 1: {
                RTLogger.print(3, sp.getID() + " activated");
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                break;
            }
            case 2: {
                RTLogger.print(3, sp.getID() + " de-activated");
                this.doPostAction(sp);
                if (sp.getTimeInterval().getInterval() > 0L && sp.getTimeInterval().getInterval() < Long.MAX_VALUE) {
                    sp.setDisabled("Auto");
                }
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                break;
            }
            case 3: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " enabled by " + sp.getEnabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                break;
            }
            case 4: 
            case 5: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                this.m_overdueNotification.remove(sp.getID());
                break;
            }
            case 6: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                this.m_overdueNotification.remove(sp.getID());
                this.postActionDrop(sp);
                break;
            }
            case 7: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
                this.m_overdueNotification.remove(sp.getID());
                this.postActionPublish(sp);
                break;
            }
        }
        this.renewAgentOutageFlag(sp.getAgentID());
    }

    public void renewAgentOutageFlag(String agentId) {
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentId);
        if (ac != null) {
            boolean stateNow = ((List)this.m_agentToPoliciesMap.getOrDefault(agentId, new ArrayList())).stream().map(this.m_policies::get).anyMatch(policy -> policy.isActive() && policy.isEnabled());
            if (ac.getAgentOutage() != stateNow) {
                ac.setAgentOutage(stateNow);
                RTLogger.print(5, "AC " + String.valueOf(ac) + " maintenance on: " + stateNow);
                AgentsRepository.notifySingleAgentChange(ac);
            }
        }
    }

    @Override
    public void run() {
        for (AgentOutagePolicy sp : this.m_policies.values()) {
            boolean active = sp.isActive();
            if (!sp.isEnabled() || !sp.isActive() || sp.getExpectedDuration() <= 0L || sp.getExpectedDuration() == Long.MAX_VALUE || sp.getTimeInterval() == null || sp.getTimeInterval().getFirstStart() <= 0L) continue;
            long expectedEnd = sp.getTimeInterval().getFirstStart() + sp.getExpectedDuration();
            if (System.currentTimeMillis() <= expectedEnd || this.m_overdueNotification.containsKey(sp.getID())) continue;
            AgentCard localAgentCard = ServerEngine.getInstance().getAgentRepository().getLocalAgentCard(sp.getAgentID(), true);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date(expectedEnd));
            SEventFwd sef = SMessage.sendMessage(null, "Agent Outage not disabled at expected time: " + time + "\nOutage ID: " + sp.getID() + " Agent: " + localAgentCard.getLabel(), 4, "AGENT", "OUTAGE", ServerEngine.getInstance().getServerProps().getHostname(), 0);
            this.m_overdueNotification.put(sp.getID(), sef.getID());
        }
    }

    @Override
    public void saveOrder(String orderFilePath) {
    }

    public void saveServerPolicy(AgentOutagePolicy p) throws Exception {
        this.save(p);
    }

    @Override
    public void updateServerPolicy(AgentOutagePolicy p, String user) throws Exception {
        if (!this.isPolicyKnown(p.getID())) {
            this.addServerPolicy(p);
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS_AOP");
    }

    @Override
    public void replaceServerPolicy(AgentOutagePolicy p) throws Exception {
        if (this.isPolicyKnown(p.getID())) {
            this.deletePolicy(p.getID());
        }
        this.addServerPolicy(p);
    }

    @Override
    public boolean onEvent(CorrelationEvents event) {
        return false;
    }
}

