/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.log.RTLogger;
import com.blixx.sa.Opts;
import com.blixx.server.AgentCard;
import com.blixx.server.EventsRouter;
import com.blixx.server.IEventProcessor;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.correlation.AbstractOutageManager;
import com.blixx.server.correlation.CorrelationEvents;
import com.blixx.server.correlation.IServerCorrelationProcessor;
import com.blixx.server.correlation.IServerPolicyManager;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.IUiNotificator;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.Severity;
import com.blixx.shared.SupportedVariablesS;
import com.blixx.shared.exceptions.ConfigException;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.IServerPolicyListener;
import com.blixx.shared.ext.ServerPolicyFactory;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;

public class ModifyIndicationManager
extends AbstractOutageManager<ExtendedServerPolicy>
implements IServerPolicyListener<ExtendedServerPolicy>,
IServerCorrelationProcessor,
IServerPolicyManager<ExtendedServerPolicy>,
Runnable {
    private static final String ESP_SOURCE_PREFIX = "ESP:";
    private static final String SORTED_IDS = "srv/etc/mpo_order.dat";
    Set<String> awaitBadIndications = new ConcurrentSkipListSet<String>();
    final IEventProcessor eventProcessor;
    final IUiNotificator uiNotifier;

    public ModifyIndicationManager(EventsRouter router, String directory) {
        super(router.getEventOperationsOutage());
        this.eventProcessor = router;
        this.uiNotifier = router;
        try {
            ServerPolicyFactory spf = new ServerPolicyFactory(directory);
            this.loadPolicies(spf);
            this.loadOrdering();
        }
        catch (Exception e) {
            RTLogger.print(1, "error initialization ServerPolicyFactory", e);
        }
    }

    private void loadOrdering() throws IOException {
        block16: {
            File spids = new File(SORTED_IDS);
            if (spids.exists()) {
                try (FileReader fr = new FileReader(spids);
                     BufferedReader br = new BufferedReader(fr);){
                    String id = null;
                    while ((id = br.readLine()) != null) {
                        if (id.length() < 32) continue;
                        if (this.m_policies.containsKey(id)) {
                            this.m_sortedIDs.add(id);
                            continue;
                        }
                        RTLogger.print(2, "Server policy id unknown: " + id);
                    }
                    break block16;
                }
            }
            Files.createDirectories(spids.toPath().getParent(), new FileAttribute[0]);
            if (!spids.createNewFile()) {
                RTLogger.print(1, "Can't create required file: " + spids.getAbsolutePath());
            }
        }
        boolean needsToBeStored = false;
        for (String loadedID : this.m_policies.keySet()) {
            if (this.m_sortedIDs.contains(loadedID)) continue;
            this.m_sortedIDs.add(loadedID);
            needsToBeStored = true;
            RTLogger.print(2, "Added to sp_order id: " + loadedID);
        }
        boolean bl = needsToBeStored = this.m_sortedIDs.retainAll(this.m_policies.keySet()) || needsToBeStored;
        if (needsToBeStored) {
            this.saveOrder(SORTED_IDS);
        }
    }

    private void loadPolicies(ServerPolicyFactory spf) {
        File dir = spf.getDir();
        File[] list = dir.listFiles((dir1, name) -> name.endsWith(".mp.xml"));
        if (list != null) {
            for (File f : list) {
                try {
                    ExtendedServerPolicy sp = spf.initServerPolicyMSP(f);
                    this.addServerPolicy0(sp);
                }
                catch (Exception e) {
                    RTLogger.print(1, "error initialization ServerPolicy: " + f.getName(), e);
                }
            }
        }
    }

    public void updatePoliciesFromSlave(SlaveServerCard ssc) {
        this.m_slaveOutagePolicies.put(ssc, ssc.getModifyPolicies());
    }

    private void addServerPolicy0(ExtendedServerPolicy p) {
        this.m_policies.put(p.getID(), p);
        p.addListener(this);
        p.isActive();
    }

    protected void saveServerPolicy(ExtendedServerPolicy p) throws Exception {
        ServerPolicyFactory spf = new ServerPolicyFactory(null);
        spf.saveExtendedServerPolicy(p);
    }

    @Override
    public boolean checkAndProcess(SEventFwd sef, AgentCard ac) {
        for (String id : this.m_sortedIDs) {
            PatternMatchResult chk;
            ExtendedServerPolicy p = (ExtendedServerPolicy)this.m_policies.get(id);
            if (p == null || !p.isEnabled() || sef.getSource().startsWith(ESP_SOURCE_PREFIX) && sef.getSource().endsWith(p.getID()) || !(chk = p.checkR(sef)).isMatch()) continue;
            if (p.isAwait()) {
                List<String> matchedAgentIDs = p.checkNodeGroupsAndApplyTime(sef);
                if (matchedAgentIDs != null && !matchedAgentIDs.isEmpty()) {
                    for (String agentIDmatched : matchedAgentIDs) {
                        String awaitKey = this.getAwaitKey(p.getID(), agentIDmatched);
                        if (!this.awaitBadIndications.contains(awaitKey)) continue;
                        if (p.isAwaitAcknowlede()) {
                            this.sendAwaitIndication(p, agentIDmatched, true);
                        }
                        this.awaitBadIndications.remove(awaitKey);
                    }
                }
                if (!p.isAwaitDropOriginal()) continue;
                sef.setState('D');
                continue;
            }
            SEventFwd sefBKP = new SEventFwd(sef);
            sefBKP.m_CustomAttributes.putAll(sef.m_CustomAttributes);
            AgentCardCM acCM = ServerEngine.getInstance().getAgentRepository().getAgentCardCM(sef.getT1());
            if (acCM != null) {
                Map<String, Object> acAttributes = acCM.getAttributes();
                for (Map.Entry<String, Object> en : acAttributes.entrySet()) {
                    String label = ServerEngine.getInstance().getAgentRepository().getAgentCardCMLabels().get(en.getKey());
                    if (label == null) {
                        label = en.getKey();
                    }
                    chk.getVariableMap().put("AA." + label, String.valueOf(en.getValue()));
                }
            }
            this.doAction(p, sef, sefBKP, chk.getVariableMap());
        }
        return false;
    }

    @Override
    public boolean checkAndProcessInternal(SEventFwd sef) {
        return this.checkAndProcess(sef, null);
    }

    public void cleanAwaitPoliciesRuntime() {
        for (String id : this.m_sortedIDs) {
            try {
                ExtendedServerPolicy p = (ExtendedServerPolicy)this.m_policies.get(id);
                if (p == null || !p.isEnabled() || !p.isAwait()) continue;
                p.rebuildAgent2TimeRtMap();
            }
            catch (Exception e) {
                RTLogger.print(3, "error cleaning policy id: " + id, e);
            }
        }
    }

    @Override
    public boolean onEvent(CorrelationEvents event) {
        boolean isEventCatched = false;
        switch (event) {
            case NODEGROUP_CHANGE: {
                this.cleanAwaitPoliciesRuntime();
                isEventCatched = true;
                break;
            }
        }
        return isEventCatched;
    }

    public void checkAwaitPoliciesAndSendIndication() {
        for (String id : this.m_sortedIDs) {
            ExtendedServerPolicy p = (ExtendedServerPolicy)this.m_policies.get(id);
            if (p == null || !p.isEnabled() || !p.isAwait()) continue;
            for (Map.Entry<String, Long> en : p.getAgent2ExpireTime().entrySet()) {
                if (en.getValue() == null || System.currentTimeMillis() <= en.getValue()) continue;
                String agentID = en.getKey();
                p.setNextExpire(agentID);
                this.sendAwaitIndication(p, agentID, false);
                if (!p.isAwaitAcknowlede()) continue;
                this.awaitBadIndications.add(this.getAwaitKey(p.getID(), agentID));
            }
        }
    }

    private void sendAwaitIndication(ExtendedServerPolicy p, String agentID, boolean isGoodMessage) {
        SEventFwd newSEF = new SEventFwd();
        newSEF.setID(UUID.randomUUID().toString());
        newSEF.setSource(ESP_SOURCE_PREFIX + p.getName() + ":" + p.getID());
        newSEF.setTime(System.currentTimeMillis());
        newSEF.setSTime(newSEF.getTime());
        newSEF.setFirstTime(newSEF.getTime());
        newSEF.setT1(agentID);
        AgentCard ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(agentID);
        HashMap<String, String> variables = new HashMap<String, String>(0);
        if (ac != null) {
            newSEF.setAgentNode(ac.getAgentHost());
            variables.put("AGENT_HOST", ac.getAgentHost());
            variables.put("AGENT_ID", ac.getAgentID());
            variables.put("AGENT_IP", ac.getAgentIP());
        }
        if (isGoodMessage) {
            newSEF.setSeverity(1);
            if (p.isAwaitInsertAsClosed()) {
                newSEF.setState('A');
            }
        } else {
            if (p.getSetSeverity().length() > 0) {
                newSEF.setSeverity(Severity.getSeverity(p.getSetSeverity()));
            } else {
                newSEF.setSeverity(0);
            }
            if (p.isInsertAsClosed()) {
                newSEF.setState('A');
            }
        }
        variables.put("SEVERITY", newSEF.getSeverity());
        variables.put("SEVERITY_INT", "" + newSEF.getSeverityInt());
        if (p.getSetHost().length() > 0) {
            newSEF.setNode(SupportedVariablesS.replaceOptVars(p.getSetHost(), variables));
        }
        if (p.getSetApplication().length() > 0) {
            newSEF.setApplication(SupportedVariablesS.replaceOptVars(p.getSetApplication(), variables));
        }
        if (p.getSetGroup().length() > 0) {
            newSEF.setGroup(SupportedVariablesS.replaceOptVars(p.getSetGroup(), variables));
        }
        if (p.getSetObject().length() > 0) {
            newSEF.setObject(SupportedVariablesS.replaceOptVars(p.getSetObject(), variables));
        }
        if (p.getSetAutoAction().length() > 0) {
            newSEF.setAutoAction(SupportedVariablesS.replaceOptVars(p.getSetAutoAction(), variables));
            newSEF.setAutoActionTimeout(p.getSetAutoActionTimeoutSec());
        }
        if (p.getSetAutoActionNode().length() > 0) {
            newSEF.setAutoActionNode(SupportedVariablesS.replaceOptVars(p.getSetAutoActionNode(), variables));
        }
        if (p.getSetKey().length() > 0) {
            newSEF.setKey(SupportedVariablesS.replaceOptVars(p.getSetKey(), variables));
        }
        if (p.getSetCloseMask().length() > 0) {
            newSEF.setCloseMask(SupportedVariablesS.replaceOptVars(p.getSetCloseMask(), variables));
        }
        if (p.isOverwriteDeDuplication()) {
            if (p.isDeduplicateKeyOnly()) {
                newSEF.setDeduplication(true);
                newSEF.m_CustomAttributes.put(Opts.DEDUPL_KEYONLY, "true");
            } else if (p.isDeduplicate()) {
                newSEF.setDeduplication(true);
                newSEF.m_CustomAttributes.remove(Opts.DEDUPL_KEYONLY);
            } else {
                newSEF.setDeduplication(false);
                newSEF.m_CustomAttributes.remove(Opts.DEDUPL_KEYONLY);
            }
        }
        if (p.isOverwriteAV_KPI()) {
            if (p.isAV()) {
                newSEF.setTypeA(1);
                newSEF.setTypeK(0);
            } else if (p.isKPI()) {
                newSEF.setTypeA(0);
                newSEF.setTypeK(1);
            } else {
                newSEF.setTypeA(0);
                newSEF.setTypeK(0);
            }
        }
        if (p.getCAs() != null && p.getCAs().size() > 0) {
            HashMap<String, String> cas = new HashMap<String, String>(p.getCAs());
            for (Map.Entry en : cas.entrySet()) {
                String key = (String)en.getKey();
                String value = (String)en.getValue();
                newSEF.m_CustomAttributes.put(key, SupportedVariablesS.replaceOptVars(value, variables));
            }
        }
        if (isGoodMessage) {
            if (p.getAwaitSetText() != null && p.getAwaitSetText().length() > 0) {
                newSEF.setText(SupportedVariablesS.replaceOptVars(p.getAwaitSetText(), variables));
            } else if (p.getSetText().length() > 0) {
                newSEF.setText(SupportedVariablesS.replaceOptVars(p.getSetText(), variables));
            }
        } else if (p.getSetText().length() > 0) {
            newSEF.setText(SupportedVariablesS.replaceOptVars(p.getSetText(), variables));
        }
        ArrayList<SEventFwd> l = new ArrayList<SEventFwd>(1);
        l.add(newSEF);
        RTLogger.print(6, "{} send -> {} agt: {} - {} to eo: {}", System.currentTimeMillis(), newSEF, newSEF.getT1(), this, this.eventProcessor);
        this.eventProcessor.submitNewMessage(l, ac);
    }

    public void doAction(ExtendedServerPolicy p, SEventFwd sef, SEventFwd clonedSource, Map<String, String> variables) {
        SEventFwd sefBKP = clonedSource;
        if (p.getSetHost().length() > 0) {
            sef.setNode(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetHost(), variables));
        }
        if (p.getSetApplication().length() > 0) {
            sef.setApplication(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetApplication(), variables));
        }
        if (p.getSetGroup().length() > 0) {
            sef.setGroup(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetGroup(), variables));
        }
        if (p.getSetObject().length() > 0) {
            sef.setObject(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetObject(), variables));
        }
        if (p.getSetSeverity().length() > 0) {
            sef.setSeverity(Severity.getSeverity(p.getSetSeverity()));
        }
        if (p.getSetText().length() > 0) {
            sef.setText(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetText(), variables));
        }
        if (p.getSetAutoAction().length() > 0) {
            sef.setAutoAction(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetAutoAction(), variables));
            sef.setAutoActionTimeout(p.getSetAutoActionTimeoutSec());
        }
        if (p.getSetAutoActionNode().length() > 0) {
            sef.setAutoActionNode(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetAutoActionNode(), variables));
        }
        if (p.getSetKey().length() > 0) {
            sef.setKey(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetKey(), variables));
        }
        if (p.getSetCloseMask().length() > 0) {
            sef.setCloseMask(SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, p.getSetCloseMask(), variables));
        }
        if (p.isInsertAsClosed()) {
            sef.setState('A');
        }
        if (p.isOverwriteDeDuplication()) {
            if (p.isDeduplicateKeyOnly()) {
                sef.setDeduplication(true);
                sef.m_CustomAttributes.put(Opts.DEDUPL_KEYONLY, "true");
            } else if (p.isDeduplicate()) {
                sef.setDeduplication(true);
                sef.m_CustomAttributes.remove(Opts.DEDUPL_KEYONLY);
            } else {
                sef.setDeduplication(false);
                sef.m_CustomAttributes.remove(Opts.DEDUPL_KEYONLY);
            }
        }
        if (p.isOverwriteAV_KPI()) {
            if (p.isAV()) {
                sef.setTypeA(1);
                sef.setTypeK(0);
            } else if (p.isKPI()) {
                sef.setTypeA(0);
                sef.setTypeK(1);
            } else {
                sef.setTypeA(0);
                sef.setTypeK(0);
            }
        }
        if (p.getCAs() != null && p.getCAs().size() > 0) {
            HashMap<String, String> cas = new HashMap<String, String>(p.getCAs());
            for (Map.Entry en : cas.entrySet()) {
                String key = (String)en.getKey();
                String value = (String)en.getValue();
                sef.m_CustomAttributes.put(key, SupportedVariablesS.prepareString(sefBKP == null ? sef : sefBKP, value, variables));
            }
        }
    }

    @Override
    public boolean isStopProcessing() {
        return false;
    }

    @Override
    public void deletePolicy(String id) throws Exception {
        this.m_sortedIDs.remove(id);
        this.saveOrder(SORTED_IDS);
        ServerPolicyTemplate sp = (ServerPolicyTemplate)this.m_policies.remove(id);
        ServerPolicyFactory spf = new ServerPolicyFactory(null);
        File f = spf.getFile(sp);
        Files.deleteIfExists(f.toPath());
        this.informUIs();
    }

    private void informUIs() {
        this.uiNotifier.addPendingToALL("GET_SERVER_POLICIES_STATUS_EXT");
    }

    @Override
    public void updateServerPolicy(ExtendedServerPolicy pol, String user) throws Exception {
        ExtendedServerPolicy runtimeSP = (ExtendedServerPolicy)this.getServerPolicy(pol.getID());
        if (runtimeSP != null) {
            runtimeSP.updateFrom(pol);
            ServerEngine.getInstance().getAuditLog().logModify(user, "ExtendedServerPolicy/" + pol.getID() + ":" + runtimeSP.getName());
        } else {
            runtimeSP = pol;
            runtimeSP.setOwner(user);
            this.addServerPolicy0(runtimeSP);
            ServerEngine.getInstance().getAuditLog().logCreate(user, "ExtendedServerPolicy/" + pol.getID() + ":" + runtimeSP.getName());
        }
        this.saveServerPolicy(runtimeSP);
        if (!this.m_sortedIDs.contains(pol.getID())) {
            this.m_sortedIDs.add(pol.getID());
            this.saveOrder(SORTED_IDS);
        }
        this.informUIs();
    }

    @Override
    public void replaceServerPolicy(ExtendedServerPolicy pol) throws Exception {
        this.addServerPolicy0(pol);
        if (!this.m_sortedIDs.contains(pol.getID())) {
            this.m_sortedIDs.add(pol.getID());
            this.saveOrder(SORTED_IDS);
        }
        this.saveServerPolicy(pol);
        this.informUIs();
    }

    @Override
    public void setOrder(List<String> polIDs) {
        if (!this.m_sortedIDs.containsAll(polIDs) || !polIDs.containsAll(this.m_sortedIDs)) {
            throw new ConfigException("Save order action impossible. List of existing policies was concurrently modified.");
        }
        this.m_sortedIDs = polIDs;
        this.saveOrder(SORTED_IDS);
        this.informUIs();
    }

    @Override
    public void onEvent(int eventType, ExtendedServerPolicy sp) {
        switch (eventType) {
            case 3: {
                try {
                    this.saveServerPolicy(sp);
                    if (sp.isAwait()) {
                        sp.rebuildAgent2TimeRtMap();
                    }
                }
                catch (Exception e) {
                    RTLogger.print(4, "Error saving Modify Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " enabled by " + sp.getEnabledBy());
                this.informUIs();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Exception e) {
                    RTLogger.print(4, "Error saving Modify Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                this.informUIs();
                break;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    this.checkAwaitPoliciesAndSendIndication();
                }
            }
            catch (InterruptedException e) {
                RTLogger.print(1, " -- stop thread: " + String.valueOf(Thread.currentThread()));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                RTLogger.print(2, "", e);
                continue;
            }
            break;
        }
    }

    public String getAwaitKey(String policyID, String agentID) {
        return policyID + "_" + agentID;
    }
}

