/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperationsOutage;
import com.blixx.server.ServerEngine;
import com.blixx.server.SlaveServerCard;
import com.blixx.server.correlation.AbstractOutageManager;
import com.blixx.server.correlation.CorrelationEvents;
import com.blixx.server.correlation.IServerCorrelationProcessor;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.IServerPolicyListener;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyFactory;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.List;

public class OutageManager
extends AbstractOutageManager<OutagePolicy>
implements Runnable,
IServerPolicyListener<OutagePolicy>,
IServerCorrelationProcessor {
    public static String SORTED_IDS = "srv/etc/spo_order.dat";

    public OutageManager(EventOperationsOutage eo, String directory) {
        super(eo);
        try {
            block22: {
                File spids;
                ServerPolicyFactory spf = new ServerPolicyFactory(directory);
                File dir = spf.getDir();
                File[] list = dir.listFiles(new FilenameFilter(this){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".sp.xml");
                    }
                });
                if (list != null) {
                    for (File f : list) {
                        try {
                            OutagePolicy sp = spf.initServerPolicy(f);
                            this.addServerPolicy0(sp);
                        }
                        catch (Throwable e) {
                            RTLogger.print(1, "error initialization ServerPolicy: " + f.getName(), e);
                        }
                    }
                }
                if ((spids = new File(SORTED_IDS)).exists()) {
                    try (FileReader fr = new FileReader(spids);
                         BufferedReader br = new BufferedReader(fr);){
                        String id = null;
                        while ((id = br.readLine()) != null) {
                            if (id.length() < 32) continue;
                            if (this.m_policies.containsKey(id)) {
                                this.m_sortedIDs.add(id);
                                continue;
                            }
                            RTLogger.print(2, "Server policy id unknown: " + id);
                        }
                        break block22;
                    }
                }
                if (!spids.createNewFile()) {
                    RTLogger.print(1, "Can't create required file: " + spids.getAbsolutePath());
                }
            }
            boolean needsToBeStored = false;
            for (String loadedID : this.m_policies.keySet()) {
                if (this.m_sortedIDs.contains(loadedID)) continue;
                this.m_sortedIDs.add(loadedID);
                needsToBeStored = true;
                RTLogger.print(2, "Added to sp_order id: " + loadedID);
            }
            boolean bl = needsToBeStored = this.m_sortedIDs.retainAll(this.m_policies.keySet()) || needsToBeStored;
            if (needsToBeStored) {
                this.saveOrder(SORTED_IDS);
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "error initialization ServerPolicyFactory", e);
        }
    }

    public void updatePoliciesFromSlave(SlaveServerCard ssc) {
        this.m_slaveOutagePolicies.put(ssc, ssc.getOutages());
    }

    protected void addServerPolicy(OutagePolicy p) {
        this.addServerPolicy0(p);
        this.m_sortedIDs.add(p.getID());
        this.saveOrder(SORTED_IDS);
    }

    private void addServerPolicy0(OutagePolicy p) {
        this.m_policies.put(p.getID(), p);
        p.addListener(this);
    }

    protected void saveServerPolicy(OutagePolicy p) throws Exception {
        ServerPolicyFactory spf = new ServerPolicyFactory(null);
        spf.saveServerPolicy(p);
    }

    @Override
    public void updateServerPolicy(OutagePolicy pol, String user) throws Exception {
        OutagePolicy runtimeSP = (OutagePolicy)this.getServerPolicy(pol.getID());
        if (runtimeSP != null) {
            runtimeSP.updateFrom(pol);
            ServerEngine.getInstance().getAuditLog().logModify(user, "OutagePolicy/" + pol.getID() + ":" + runtimeSP.getName());
        } else {
            runtimeSP = pol;
            runtimeSP.setOwner(user);
            this.addServerPolicy0(runtimeSP);
            ServerEngine.getInstance().getAuditLog().logCreate(user, "OutagePolicy/" + pol.getID() + ":" + runtimeSP.getName());
        }
        this.saveServerPolicy(runtimeSP);
        if (!this.m_sortedIDs.contains(pol.getID())) {
            this.m_sortedIDs.add(pol.getID());
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
    }

    @Override
    public void replaceServerPolicy(OutagePolicy pol) throws Exception {
        this.addServerPolicy0(pol);
        this.saveServerPolicy(pol);
        if (!this.m_sortedIDs.contains(pol.getID())) {
            this.m_sortedIDs.add(pol.getID());
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
    }

    @Override
    public void setOrder(List<String> polIDs) {
        if (!this.m_sortedIDs.containsAll(polIDs) || !polIDs.containsAll(this.m_sortedIDs)) {
            throw new RuntimeException("Save order action impossible. List of existing policies was concurrently modified.");
        }
        this.m_sortedIDs = polIDs;
        this.saveOrder(SORTED_IDS);
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
    }

    @Override
    public void onEvent(int eventType, OutagePolicy sp) {
        switch (eventType) {
            case 1: {
                RTLogger.print(3, sp.getID() + " activated");
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                break;
            }
            case 2: {
                this.doPostAction(sp);
                RTLogger.print(3, sp.getID() + " de-activated");
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                try {
                    if (sp.getTimeInterval().isScheduled()) break;
                    sp.setDisabled("Auto");
                }
                catch (Throwable throwable) {}
                break;
            }
            case 3: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " enabled by " + sp.getEnabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                break;
            }
            case 4: 
            case 5: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                List<String> ids0 = this.getIndicationIDs(sp);
                this.cloneIndications(ids0);
                this.sendArchiveToSlaves(ids0);
                break;
            }
            case 6: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                List<String> ids1 = this.getIndicationIDs(sp);
                this.sendArchiveToSlaves(ids1);
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                this.postActionDrop(sp);
                break;
            }
            case 7: {
                try {
                    this.saveServerPolicy(sp);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "Error saving Server Policy: " + sp.getID(), e);
                }
                RTLogger.print(3, sp.getID() + " disabled by " + sp.getDisabledBy());
                ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
                this.postActionPublish(sp);
                break;
            }
        }
    }

    @Override
    public boolean checkAndProcess(SEventFwd sef, AgentCard ac) {
        for (String id : this.m_sortedIDs) {
            OutagePolicy p = (OutagePolicy)this.m_policies.get(id);
            if (p == null || !p.check(sef)) continue;
            this.doAction(p, sef, ac);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkAndProcessInternal(SEventFwd sef) {
        for (String id : this.m_sortedIDs) {
            OutagePolicy p = (OutagePolicy)this.m_policies.get(id);
            if (p == null || !p.check(sef)) continue;
            this.doAction(p, sef, null);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        for (OutagePolicy sp : this.m_policies.values()) {
            sp.isActive();
        }
    }

    public boolean isPolicyKnown(String id) {
        return this.m_policies.containsKey(id);
    }

    @Override
    public void deletePolicy(String id) throws Exception {
        this.m_sortedIDs.remove(id);
        this.saveOrder(SORTED_IDS);
        ServerPolicyTemplate sp = (ServerPolicyTemplate)this.m_policies.remove(id);
        ServerPolicyFactory spf = new ServerPolicyFactory(null);
        File f = spf.getFile(sp);
        if (!f.delete()) {
            String msg = "Can't delete file: " + f.getAbsolutePath();
            RTLogger.print(2, msg);
            throw new Exception(msg);
        }
        ServerEngine.getInstance().getEventsRouter().addPendingToALL("GET_SERVER_POLICIES_STATUS");
    }

    @Override
    public boolean isStopProcessing() {
        return true;
    }

    @Override
    public boolean onEvent(CorrelationEvents event) {
        return false;
    }
}

