/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.correlation;

import com.blixx.server.NodeGroupRepository;
import com.blixx.server.ServerEngine;
import com.blixx.server.UserManager;
import com.blixx.server.correlation.IServerPolicyManager;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.NodeGroupForwardFilter;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OutageRelations {
    public Map<String, ServerPolicyTemplate> getAffectedServerPolicies(String user, IServerPolicyManager pm) {
        HashMap<String, ServerPolicyTemplate> mapPolicies = new HashMap<String, ServerPolicyTemplate>();
        if (UserManager.getInstance().isUserNodeGroupFiltered(user)) {
            Map<String, Object> userSees = ServerEngine.getInstance().getAgentIDs4User(user);
            if (userSees == null) {
                mapPolicies = null;
            } else {
                block0: for (Map.Entry entry : pm.getAllPolicies().entrySet()) {
                    Map<String, Object> polRelatedToAgentIDs = this.getRelatedAgentIDs((ServerPolicyTemplate)entry.getValue());
                    if (polRelatedToAgentIDs.size() > 0) {
                        for (String agentID : polRelatedToAgentIDs.keySet()) {
                            if (!userSees.containsKey(agentID)) continue;
                            mapPolicies.put(((ServerPolicyTemplate)entry.getValue()).getID(), (ServerPolicyTemplate)entry.getValue());
                            continue block0;
                        }
                        continue;
                    }
                    mapPolicies.put(((ServerPolicyTemplate)entry.getValue()).getID(), (ServerPolicyTemplate)entry.getValue());
                }
            }
        }
        return mapPolicies;
    }

    public Map<String, Object> getRelatedAgentIDs(ServerPolicyTemplate sp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int filterCount = 0;
        for (ForwardFilter forwardFilter : sp.getFilters()) {
            switch (forwardFilter.getType()) {
                case 21: 
                case 26: {
                    NodeGroupForwardFilter nff = (NodeGroupForwardFilter)forwardFilter;
                    Map<String, Object> associatedAgentIDs = NodeGroupRepository.getInstance().getAssociatedAgentIDsMap(nff);
                    if (filterCount == 0) {
                        map.putAll(associatedAgentIDs);
                    } else {
                        map.keySet().retainAll(associatedAgentIDs.keySet());
                    }
                    ++filterCount;
                    break;
                }
            }
        }
        return map;
    }

    public boolean isRelated(ServerPolicyTemplate sp, String user) {
        try {
            Map<String, Object> sp_relatedID = this.getRelatedAgentIDs(sp);
            if (sp_relatedID.size() == 0) {
                return true;
            }
            Map<String, Object> userSees = ServerEngine.getInstance().getAgentIDs4User(user);
            if (userSees != null) {
                Iterator<String> it = sp_relatedID.keySet().iterator();
                while (it.hasNext()) {
                    if (!userSees.containsKey(it.next())) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

