/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFField;
import com.blixx.server.AgentCard;
import com.blixx.server.EventOperations;
import com.blixx.server.SMessage;
import com.blixx.server.ServerEngine;
import com.blixx.server.ServerThreadPool;
import com.blixx.server.db.Connector;
import com.blixx.server.db.DBException;
import com.blixx.server.db.DBProperties;
import com.blixx.server.db.DeleteTask;
import com.blixx.server.db.OraConnector;
import com.blixx.server.ext.ForwardManager;
import com.blixx.server.perf.PerfSQL;
import com.blixx.server.perf.PerfThread;
import com.blixx.shared.AgentCardCM;
import com.blixx.shared.Annotation;
import com.blixx.shared.Assignment;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.io.NEDataInputStream;
import com.blixx.shared.io.NEDataOutputStream;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.ArchiveDetails;
import com.blixx.shared.utils.HashMapArray;
import com.blixx.shared.utils.HashMapMap;
import com.blixx.shared.utils.IndicationPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB {
    public static final String SQL_ERROR = "SQLError: ";
    public static final String ANNOTATION_COUNT = "ANNOT";
    public static final String EVENT_ID = "ID";
    public static final String EVENT_MONITOR = "MONITOR";
    public static final String EVENT_VALUE = "VALUE";
    public static final String EVENT_SOURCE = "SOURCE";
    public static final String EVENT_STIME = "STIME";
    public static final String EVENT_OPACTION = "OPACTION";
    public static final String EVENT_AUTOACTION = "AUTOACTION";
    public static final String EVENT_INSTRUCTIONID = "INSTRUCTIONID";
    public static final String EVENT_STATE = "STATE";
    public static final String EVENT_DUPL = "DUPL";
    public static final String EVENT_SEVERITY = "SEVERITY";
    public static final String EVENT_ACKKEY = "ACKKEY";
    public static final String EVENT_MSGKEY = "MSGKEY";
    public static final String EVENT_TIME = "TIME";
    public static final String EVENT_MSGTEXT = "MSGTEXT";
    public static final String EVENT_MSGGRP = "MSGGRP";
    public static final String EVENT_OBJECT = "OBJECT";
    public static final String EVENT_APPLICATION = "APPLICATION";
    public static final String EVENT_NODE = "NODE";
    public static final String EVENT_SERVICE = "SERVICE";
    public static final String EVENT_AGENTNODE = "AGENTNODE";
    public static final String EVENT_ANNOT = "ANNOT";
    public static final String EVENT_TYPE_A = "TYPE_A";
    public static final String EVENT_TYPE_K = "TYPE_K";
    public static final String EVENT_FTIME = "FTIME";
    public static final String EVENT_ID_E = "ID_E";
    public static final String EVENTS_EXT = "EVENTS_EXT";
    public static final String EVENTS_EXT_A = "EVENTS_EXT_A";
    public static final String EVENTS_TABLE = "EVENTS";
    public static final String EVENTS_A_TABLE = "EVENTS_A";
    public static final String AGENTS_TABLE = "AGENTS";
    public static final String ANNOTATIONS_TABLE = "ANNOTATIONS";
    public static final String HELP_TABLE = "INSTRUCTIONS";
    public static final String ASSIGNMENTS_TABLE = "ASSIGNMENTS";
    public static final String USER_TABLE = "USERS";
    public static final String USER_ROLES_TABLE = "ROLES";
    public static final String GUI_ITEMS_TABLE = "ITEMS";
    public static final String PGROUPS_TABLE = "PGROUPS";
    public static final String PGITEMS_TABLE = "PGITEMS";
    public static final String PGRIGHTS_TABLE = "PGRIGHTS";
    public static final String USER_RIGHTS_TABLE = "RIGHTS";
    public static final String O_AGENTS = "O_AGENTS";
    protected static Pattern patternDoublesDDF = Pattern.compile("-*\\d+(,\\d+([eE][+-]?(\\d+))?)?");
    protected static Pattern patternDoublesDDF2 = Pattern.compile("-*\\d+(\\.\\d+([eE][+-]?(\\d+))?)?");
    protected static volatile DB m_db = null;
    public SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected Connector m_connector = null;
    protected Connector m_connectorUpdate = null;
    protected Connector m_connectorOperator = null;
    protected Connector m_connectorArchive = null;
    protected Connector m_connector4Master = null;
    protected Connector m_connector_perf = null;
    protected Connector m_connector_perf2 = null;
    AtomicBoolean connectorUpdateIsRunning = new AtomicBoolean(false);
    public String sqlAnnotations = "SELECT * FROM ANNOTATIONS WHERE ID = '";
    public boolean m_isOracle = false;
    public boolean m_isOraclePERF = false;
    public boolean m_isEventEXT = false;
    public boolean m_isAgentPortHERE = false;
    public AtomicBoolean m_dbEnabled = new AtomicBoolean(true);
    public ReentrantReadWriteLock m_updateState = new ReentrantReadWriteLock();
    protected String SQL_UPDATE_ASSIGNMENT = "UPDATE ASSIGNMENTS SET ASSIGNMENT=?, UTIME=?, USER=?, _LOCK=? WHERE ID=?";
    protected String SQL_UPDATE_ASSIGNMENT2 = "UPDATE ASSIGNMENTS SET UTIME=?, USER=?, _LOCK=? WHERE ID=?";
    protected String SQL_SELECT_CLOSED_EVENTS = "SELECT * FROM EVENTS WHERE STATE <> '-' AND STATE <> 'D'";
    protected String SQL_REPLACE_EVENTS = "REPLACE INTO EVENTS (`ID`,`SERVICE`,`NODE`,`APPLICATION`,`OBJECT`,`MSGGRP`,`TIME`,`MSGKEY`,`ACKKEY`,`SEVERITY`,`DUPL`,`STATE`,`INSTRUCTIONID`,`AUTOACTION`,`OPACTION`,`STIME`,`SOURCE`,`VALUE`,`MONITOR`,`AGENTNODE`,`ANNOT`,`TYPE_A`,`TYPE_K`,`FTIME`,`MSGTEXT`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected String SQL_REPLACE_EVENTS_EXT = "REPLACE EVENTS_EXT SET ID_E=?,SRV=?,SRVTYPE=?,EXTID=?,T1=?,T2=?,T3=?,T4=?,T5=?,T6=?,T7=?,T8=?,T9=?,T10=?, TFA=?,VFA=?, CA1=?,CA2=?,CA3=?,CA4=?,CA5=?,CA6=?,CA7=?,CA8=?,CA9=?,CA10=?,CA11=?,CA12=?,CA13=?,CA14=?,CA15=?";
    protected String SQL_UPDATE_DUPLICATES_EVENT = "UPDATE EVENTS SET TIME = ?, DUPL = ?, STIME = ? WHERE ID = ?";
    protected String SQL_SELECT_USERS = "SELECT u.*, r.ROLENAME FROM USERS u, ROLES r WHERE u.ROLE_ID = r.ID";
    protected String SQL_SELECT_ROLES = "SELECT * FROM ROLES";
    protected String SQL_SELECT_ACTIVE_EVENTS = "SELECT * FROM EVENTS where STATE = '-'";
    protected String SQL_INSERT_ARCHIVE_EVENTS_PREFIX = "INSERT IGNORE INTO EVENTS_A SELECT EVENTS.* FROM EVENTS JOIN EVENTS_TEMP ON EVENTS.ID=EVENTS_TEMP.ID";
    protected String SQL_DELETE_ARCHIVED_EVENTS_PREFIX = "DELETE FROM EVENTS USING EVENTS INNER JOIN EVENTS_TEMP ON EVENTS.ID=EVENTS_TEMP.ID";
    protected String SQL_SELECT_ITEMS = "SELECT * FROM ITEMS";
    protected String SQL_SELECT_POWERGROUPS = "SELECT * FROM PGROUPS";
    protected String SQL_SELECT_POWERGROUPS_ITEMS = "SELECT * FROM PGITEMS";
    protected String SQL_SELECT_POWERGROUPS_RIGHTS = "SELECT * FROM PGRIGHTS";
    protected String SQL_SELECT_AGENTS = "SELECT * FROM AGENTS";
    protected String SQL_UPDATE_AGENT = "UPDATE AGENTS SET DESCRIPTION = ?, LABEL = ?, IP = ?, HOSTNAME = ?, MODE = ?, OS = ?, APPROVED = ?, DISABLED = ?  WHERE ID = ?";
    protected String SQL_INSERT_ANNOTATION = "INSERT INTO ANNOTATIONS (`ID`,`TIME`,`STATUS`,`ANNOTATION`) VALUES(?,?,?,?)";
    protected String SQL_UPDATE_ANNOTATION_COUNT = "UPDATE EVENTS SET ANNOT=1 WHERE ID=?";
    protected String SQL_INSERT_HELP = "INSERT INTO INSTRUCTIONS VALUES(?,?)";
    protected String SQL_UPDATE_HELP = "UPDATE INSTRUCTIONS SET HELP = ? WHERE ID = ?";
    protected String SQL_SELECT_HELP = "SELECT HELP FROM INSTRUCTIONS WHERE ID = ?";
    protected String SQL_SELECT_HELPS = "SELECT * FROM INSTRUCTIONS";
    protected String SQL_INSERT_ASSIGNMENT = "INSERT INTO ASSIGNMENTS VALUES (?,?,?,?,?,?,?,?)";
    protected String SQL_RENAME_ASSIGNMENT = "UPDATE ASSIGNMENTS SET ASSIGNMENT=?, UTIME=?, USER=? WHERE ASSIGNMENT=?";
    protected String SQL_DELETE_ASSIGNMENT = "DELETE FROM ASSIGNMENTS WHERE ID = ?";
    protected String SQL_DELETE_ASSIGNMENTS_FOR_AGENT = "DELETE FROM ASSIGNMENTS WHERE AGENT_ID = ?";
    protected String SQL_DELETE_ASSIGNMENT_BYNAMEANDTYPE = "DELETE FROM ASSIGNMENTS WHERE ASSIGNMENT = ? AND _TYPE = ?";
    protected String SQL_SELECT_ASSIGNMENTS = "SELECT * FROM ASSIGNMENTS";
    protected String SQL_CLOSE_EVENT = "UPDATE EVENTS SET STATE=? WHERE ID = ?";
    protected String SQL_CLOSE_EVENT2 = "UPDATE EVENTS_EXT SET T9=? WHERE ID_E = ?";
    protected String SQL_SETDELETES_EVENT = "UPDATE EVENTS SET STATE='D' WHERE ID = ?";
    protected String SQL_SELECT_DELETED = "SELECT ID FROM EVENTS WHERE STATE='D'";
    protected String SQL_SET_DELETE_FLAG_PREFIX = "UPDATE EVENTS SET STATE='D' WHERE ID IN (";
    protected String SQL_SELECT_ACTIVE_EVENTS_EXT = "SELECT EVENTS.*, EVENTS_EXT.* FROM EVENTS LEFT JOIN EVENTS_EXT ON EVENTS.ID=EVENTS_EXT.ID_E WHERE EVENTS.STATE = '-'";
    protected String SQL_SELECT_CLOSED_EVENTS_EXT = "SELECT EVENTS.*, EVENTS_EXT.* FROM EVENTS LEFT JOIN EVENTS_EXT ON EVENTS.ID=EVENTS_EXT.ID_E WHERE EVENTS.STATE <> '-' AND EVENTS.STATE <> 'D'";
    protected String SQL_INSERT_ARCHIVE_EVENTS_PREFIX_EXT = "INSERT IGNORE INTO EVENTS_EXT_A SELECT EVENTS_EXT.* FROM EVENTS_EXT JOIN EVENTS_TEMP ON EVENTS_EXT.ID_E=EVENTS_TEMP.ID";
    protected String SQL_DELETE_ARCHIVED_EVENTS_PREFIX_EXT = "DELETE FROM EVENTS_EXT USING EVENTS_EXT INNER JOIN EVENTS_TEMP ON EVENTS_EXT.ID_E=EVENTS_TEMP.ID";
    protected String SQL_ACTIONS_RIGHTS = "SELECT * FROM ACTIONS";
    protected String SQL_CREATE_TEMP_IDS = "CREATE TABLE IF NOT EXISTS EVENTS_TEMP (ID char(36) NOT NULL default '', KEY EVENTS_TEMP_ID (ID))";
    protected String SQL_INSERT_TEMP_IDS = "INSERT INTO EVENTS_TEMP SELECT ID FROM EVENTS WHERE STATE='D' LIMIT 10000";
    protected String SQL_DROP_TEMP_IDS = "DROP TABLE EVENTS_TEMP";
    protected String SQL_TRUNCATE_TEMP_IDS = "TRUNCATE TABLE EVENTS_TEMP";
    public String SQL_DELETE_ANNOTATIONS_V2 = "DELETE FROM ANNOTATIONS WHERE NOT EXISTS (SELECT 1 FROM EVENTS_A WHERE ANNOTATIONS.ID = EVENTS_A.ID) AND NOT EXISTS (SELECT 1 FROM EVENTS WHERE ANNOTATIONS.ID = EVENTS.ID)";
    String SQL_INSERT_USERROLE = "INSERT INTO ROLES VALUES(?,?,?)";
    String SQL_UPDATE_USERROLE = "UPDATE ROLES SET ROLENAME = ?, DESCRIPTION=? WHERE ID = ?";
    protected String m_mainDBName = null;
    protected String m_perfDBName = null;
    public PerfThread m_perfBuffer = null;
    public Thread m_perfThread = null;
    public static final long WEEK = 604800000L;
    public String m_bkpIndiFile = "failed_inserts.dat";
    protected SQLException m_toThrow;
    public String m_archIndiFile = "failed_inserts";
    public File m_currentArchIndiFile = null;
    Pattern pattern_m_archIndiFile = Pattern.compile(this.m_archIndiFile + "\\.(\\d+)", 2);
    protected String SQL_selectAgOutPolicies = "SELECT * FROM O_AGENTS ORDER BY STARTTIME";
    protected String SQL_deleteAgOutPolicy = "DELETE FROM O_AGENTS WHERE ID = ?";
    protected String SQL_REPLACE_AgOutPolicies = "REPLACE INTO O_AGENTS (`ID`,`AGENTID`,`PATTERNS`,`STARTTIME`,`EXPDURATION`,`ENDTIME`,`ENABLED`,`DISABLEDBY`,`ACTION`,`POSTACTION`,`INTERVAL` ) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    protected String SQL_selectAll_AgentCM = "SELECT * FROM AGENTS_EXT";
    protected String SQL_select_AgentCM = "SELECT * FROM AGENTS_EXT WHERE ID = ?";
    protected String SQL_delete_AgentCM = "DELETE FROM AGENTS_EXT WHERE ID = ?";
    protected String SQL_REPLACE_AgentCM = "REPLACE INTO AGENTS_EXT (`ID`,`EMAIL`,`CONTACT`,`LIT`,`ACID`,`EID`,`BIGINT1`,`BIGINT2`,`BIGINT3`,`BIGINT4`,`BIGINT5`,`BIGINT6`,`BIGINT7`,`BIGINT8`,`BIGINT9`,`BIGINT10`,`INT1`,`INT2`,`INT3`,`INT4`,`INT5`,`INT6`,`INT7`,`INT8`,`INT9`,`INT10`,`DOUBLE1`,`DOUBLE2`,`DOUBLE3`,`DOUBLE4`,`DOUBLE5`,`DOUBLE6`,`DOUBLE7`,`DOUBLE8`,`DOUBLE9`,`DOUBLE10`,`VARCHAR1`,`VARCHAR2`,`VARCHAR3`,`VARCHAR4`,`VARCHAR5`,`VARCHAR6`,`VARCHAR7`,`VARCHAR8`,`VARCHAR9`,`VARCHAR10`,`VARCHAR11`,`VARCHAR12`,`VARCHAR13`,`VARCHAR14`,`VARCHAR15`,`TIMESTAMP1`,`TIMESTAMP2`,`TIMESTAMP3`,`TIMESTAMP4`,`TIMESTAMP5`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected String SQL_selectAgentExtLabels = "SELECT * FROM AGENTS_EXT_LABELS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DB getInstance(boolean force) {
        if (m_db == null) {
            Class<DB> clazz = DB.class;
            synchronized (DB.class) {
                if (m_db == null) {
                    DB db = new DB();
                    db.init();
                    m_db = db;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (force) {
            m_db.init();
        }
        return m_db;
    }

    public void init() {
        Properties m_perfDbprops = ServerEngine.getInstance().getServerProps().getDB_PERF_Properties();
        Properties m_dbprops = ServerEngine.getInstance().getServerProps().getDBProperties();
        this.init(m_dbprops, m_perfDbprops);
    }

    public void init(Properties dbprops, Properties perfDbprops) {
        block18: {
            String driver = dbprops.getProperty("Driver");
            String perfDriver = perfDbprops.getProperty("Driver");
            if (driver != null && driver.contains("mysql")) {
                this.m_connector = new Connector(dbprops);
                this.m_connectorUpdate = new Connector(dbprops);
                this.m_connectorOperator = new Connector(dbprops);
                this.m_connectorArchive = new Connector(dbprops);
                this.m_connector4Master = new Connector(dbprops);
            } else if (driver != null && driver.contains("oracle")) {
                this.m_isOracle = true;
                this.m_connector = new OraConnector(dbprops);
                this.m_connectorUpdate = new OraConnector(dbprops);
                this.m_connectorOperator = new OraConnector(dbprops);
                this.m_connectorArchive = new OraConnector(dbprops);
                this.m_connector4Master = new OraConnector(dbprops);
            } else {
                RTLogger.print(1, "Unsupported driver: " + driver);
                throw new DBException("Unsupported driver: " + driver);
            }
            if (perfDriver != null && perfDriver.contains("mysql")) {
                this.m_connector_perf = new Connector(perfDbprops);
                this.m_connector_perf2 = new Connector(perfDbprops);
            } else if (driver.contains("oracle")) {
                this.m_isOraclePERF = true;
                this.m_connector_perf = new OraConnector(perfDbprops);
                this.m_connector_perf2 = new OraConnector(perfDbprops);
            } else {
                RTLogger.print(1, "PERF Unsupported driver: " + driver);
            }
            boolean isOK = this.m_connector.isReady();
            if (isOK) {
                try {
                    this.m_connector.query("SELECT * FROM EVENTS_EXT WHERE ID_E='1'");
                    this.m_isEventEXT = true;
                    RTLogger.print(5, "EVENTS_EXT - enabled");
                    this.SQL_SELECT_ACTIVE_EVENTS = this.SQL_SELECT_ACTIVE_EVENTS_EXT;
                    this.SQL_SELECT_CLOSED_EVENTS = this.SQL_SELECT_CLOSED_EVENTS_EXT;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.m_connector.query("SELECT PORT FROM AGENTS WHERE ID='1'");
                    this.m_isAgentPortHERE = true;
                    this.SQL_UPDATE_AGENT = "UPDATE AGENTS SET DESCRIPTION = ?, LABEL = ?, IP = ?, HOSTNAME = ?, MODE = ?, OS = ?, APPROVED = ?, DISABLED = ?, PORT = ?  WHERE ID = ?";
                }
                catch (Throwable e) {
                    RTLogger.print(1, "DB needs to be updated to support current version of the server. [AGENTS]");
                }
                if (this.m_isOracle) {
                    this.setOracleQueries();
                }
                this.m_mainDBName = dbprops.getProperty(DBProperties.M_DB_NAME);
                this.m_perfDBName = perfDbprops.getProperty(DBProperties.M_DB_NAME);
                this.m_perfBuffer = new PerfThread(this.m_connector_perf);
                this.m_perfThread = new Thread(this.m_perfBuffer);
                this.m_perfThread.setName("PerfIns");
                this.m_perfThread.start();
                try {
                    this.m_connector.execute(this.SQL_CREATE_TEMP_IDS);
                }
                catch (SQLException e) {
                    if (this.m_isOracle && e.getErrorCode() == 955) {
                        RTLogger.print(2, "EVENTS_TEMP exists");
                        break block18;
                    }
                    RTLogger.print(1, "Error creation EVENTS_TEMP!", e);
                }
            } else {
                RTLogger.print(1, "DB is NOT ready");
                throw new DBException("Can't connect to the DB");
            }
        }
        RTLogger.print(1, "DB is ready");
    }

    public String getMainDBname() {
        return this.m_mainDBName;
    }

    public String getPerfDBname() {
        return this.m_perfDBName;
    }

    public void setOracleQueries() {
        this.SQL_UPDATE_ASSIGNMENT = "UPDATE ASSIGNMENTS SET \"ASSIGNMENT\"=?, \"UTIME\"=?, \"USER\"=?, \"_LOCK\"=? WHERE \"ID\"=?";
        this.SQL_UPDATE_AGENT = this.m_isAgentPortHERE ? "UPDATE AGENTS SET \"DESCRIPTION\" = ?, \"LABEL\" = ?, \"IP\" = ?, \"HOSTNAME\" = ?, \"MODE\" = ?, \"OS\" = ?, \"APPROVED\" = ?, \"DISABLED\" = ?, \"PORT\" = ?  WHERE \"ID\" = ?" : "UPDATE AGENTS SET \"DESCRIPTION\" = ?, \"LABEL\" = ?, \"IP\" = ?, \"HOSTNAME\" = ?, \"MODE\" = ?, \"OS\" = ?, \"APPROVED\" = ?, \"DISABLED\" = ?  WHERE \"ID\" = ?";
        this.SQL_UPDATE_HELP = "UPDATE INSTRUCTIONS SET \"HELP\" = ? WHERE \"ID\" = ?";
        this.SQL_UPDATE_ANNOTATION_COUNT = "UPDATE EVENTS SET \"ANNOT\"=1 WHERE \"ID\"=?";
        this.SQL_UPDATE_DUPLICATES_EVENT = "UPDATE EVENTS SET \"TIME\" = ?, \"DUPL\" = ?, \"STIME\" = ? WHERE \"ID\" = ?";
        this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX = "INSERT /*+ APPEND */ INTO EVENTS_A SELECT * FROM EVENTS WHERE EVENTS.ID IN (SELECT ID FROM EVENTS_TEMP)";
        this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX_EXT = "INSERT /*+ APPEND */ INTO EVENTS_EXT_A SELECT * FROM EVENTS_EXT WHERE EVENTS_EXT.\"ID_E\" IN (SELECT ID FROM EVENTS_TEMP)";
        this.SQL_DELETE_ASSIGNMENT_BYNAMEANDTYPE = "DELETE FROM ASSIGNMENTS WHERE ASSIGNMENT = ? AND \"_TYPE\" = ?";
        this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX_EXT = "DELETE FROM EVENTS_EXT WHERE EVENTS_EXT.\"ID_E\" IN (SELECT ID FROM EVENTS_TEMP)";
        this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX = "DELETE FROM EVENTS WHERE EVENTS.ID IN (SELECT ID FROM EVENTS_TEMP)";
        this.SQL_DELETE_ANNOTATIONS_V2 = "DELETE FROM ANNOTATIONS WHERE NOT EXISTS (SELECT 1 FROM EVENTS_A WHERE ANNOTATIONS.\"ID\" = EVENTS_A.\"ID\") AND NOT EXISTS (SELECT 1 FROM EVENTS WHERE ANNOTATIONS.\"ID\" = EVENTS.\"ID\")";
        this.SQL_INSERT_ANNOTATION = this.SQL_INSERT_ANNOTATION.replace('`', '\"');
        this.SQL_REPLACE_EVENTS = "MERGE INTO EVENTS USING (SELECT ? \"ID\",? \"SERVICE\",? \"NODE\",? \"APPLICATION\",? \"OBJECT\",? \"MSGGRP\",? \"TIME\",? \"MSGKEY\",? \"ACKKEY\",? \"SEVERITY\",? \"DUPL\",? \"STATE\",? \"INSTRUCTIONID\",? \"AUTOACTION\",? \"OPACTION\",? \"STIME\",? \"SOURCE\",? \"VALUE\",? \"MONITOR\",? \"AGENTNODE\",? \"ANNOT\",? \"TYPE_A\",? \"TYPE_K\",? \"FTIME\",? \"MSGTEXT\" FROM DUAL) R ON (R.\"ID\" = EVENTS.\"ID\") WHEN MATCHED THEN UPDATE SET \"APPLICATION\"=R.\"APPLICATION\",\"OBJECT\"=R.\"OBJECT\",\"MSGGRP\"=R.\"MSGGRP\",\"TIME\"=R.\"TIME\",\"SEVERITY\"=R.\"SEVERITY\",\"DUPL\"=R.\"DUPL\",\"STATE\"=R.\"STATE\",\"INSTRUCTIONID\"=R.\"INSTRUCTIONID\",\"STIME\"=R.\"STIME\",\"MONITOR\"=R.\"MONITOR\",\"SERVICE\"=R.\"SERVICE\",\"ANNOT\"=R.\"ANNOT\",\"MSGTEXT\"=R.\"MSGTEXT\" WHEN NOT MATCHED THEN INSERT (\"ID\",\"SERVICE\",\"NODE\",\"APPLICATION\",\"OBJECT\",\"MSGGRP\",\"TIME\",\"MSGKEY\",\"ACKKEY\",\"SEVERITY\",\"DUPL\",\"STATE\",\"INSTRUCTIONID\",\"AUTOACTION\",\"OPACTION\",\"STIME\",\"SOURCE\",\"VALUE\",\"MONITOR\",\"AGENTNODE\",\"ANNOT\",\"TYPE_A\",\"TYPE_K\",\"FTIME\",\"MSGTEXT\") VALUES (R.\"ID\",R.\"SERVICE\",R.\"NODE\",R.\"APPLICATION\",R.\"OBJECT\",R.\"MSGGRP\",R.\"TIME\",R.\"MSGKEY\",R.\"ACKKEY\",R.\"SEVERITY\",R.\"DUPL\",R.\"STATE\",R.\"INSTRUCTIONID\",R.\"AUTOACTION\",R.\"OPACTION\",R.\"STIME\",R.\"SOURCE\",R.\"VALUE\",R.\"MONITOR\",R.\"AGENTNODE\",R.\"ANNOT\",R.\"TYPE_A\",R.\"TYPE_K\",R.\"FTIME\",R.\"MSGTEXT\")";
        this.SQL_REPLACE_EVENTS_EXT = "MERGE INTO EVENTS_EXT USING (SELECT ? \"ID_E\",? \"SRV\",? \"SRVTYPE\",? \"EXTID\",? \"T1\",? \"T2\",? \"T3\",? \"T4\",? \"T5\",? \"T6\",? \"T7\",? \"T8\",? \"T9\",? \"T10\", ? \"TFA\",? \"VFA\", ? \"CA1\",? \"CA2\",? \"CA3\",? \"CA4\",? \"CA5\",? \"CA6\",? \"CA7\",? \"CA8\",? \"CA9\",? \"CA10\",? \"CA11\",? \"CA12\",? \"CA13\",? \"CA14\",? \"CA15\" FROM DUAL) R ON (R.\"ID_E\" = EVENTS_EXT.\"ID_E\") WHEN MATCHED THEN UPDATE SET \"SRV\"=R.\"SRV\",\"SRVTYPE\"=R.\"SRVTYPE\",\"EXTID\"=R.\"EXTID\",\"T1\"=R.\"T1\",\"T2\"=R.\"T2\",\"T3\"=R.\"T3\",\"T4\"=R.\"T4\",\"T5\"=R.\"T5\",\"T6\"=R.\"T6\",\"T7\"=R.\"T7\",\"T8\"=R.\"T8\",\"T9\"=R.\"T9\",\"T10\"=R.\"T10\", \"TFA\"=R.\"TFA\",\"VFA\"=R.\"VFA\", \"CA1\"=R.\"CA1\",\"CA2\"=R.\"CA2\",\"CA3\"=R.\"CA3\",\"CA4\"=R.\"CA4\",\"CA5\"=R.\"CA5\",\"CA6\"=R.\"CA6\",\"CA7\"=R.\"CA7\",\"CA8\"=R.\"CA8\",\"CA9\"=R.\"CA9\",\"CA10\"=R.\"CA10\",\"CA11\"=R.\"CA11\",\"CA12\"=R.\"CA12\",\"CA13\"=R.\"CA13\",\"CA14\"=R.\"CA14\",\"CA15\"=R.\"CA15\" WHEN NOT MATCHED THEN INSERT (ID_E,SRV,SRVTYPE,EXTID,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10, TFA,VFA, CA1,CA2,CA3,CA4,CA5,CA6,CA7,CA8,CA9,CA10,CA11,CA12,CA13,CA14,CA15) VALUES (R.ID_E,R.SRV,R.SRVTYPE,R.EXTID,R.T1,R.T2,R.T3,R.T4,R.T5,R.T6,R.T7,R.T8,R.T9,R.T10, R.TFA,R.VFA, R.CA1,R.CA2,R.CA3,R.CA4,R.CA5,R.CA6,R.CA7,R.CA8,R.CA9,R.CA10,R.CA11,R.CA12,R.CA13,R.CA14,R.CA15)";
        this.SQL_CREATE_TEMP_IDS = "CREATE TABLE EVENTS_TEMP (ID CHAR(36) DEFAULT '' NOT NULL)";
        this.SQL_REPLACE_AgOutPolicies = "MERGE INTO O_AGENTS USING (SELECT ? \"ID\",? \"AGENTID\",? \"PATTERNS\",? \"STARTTIME\",? \"EXPDURATION\", ? \"ENDTIME\",? \"ENABLED\",? \"DISABLEDBY\",? \"ACTION\",? \"POSTACTION\",? \"INTERVAL\" FROM DUAL) R ON (R.\"ID\" = O_AGENTS.\"ID\")  WHEN MATCHED THEN UPDATE SET \"AGENTID\"=R.\"AGENTID\", \"PATTERNS\"=R.\"PATTERNS\", \"STARTTIME\"=R.\"STARTTIME\", \"EXPDURATION\"=R.\"EXPDURATION\", \"ENDTIME\"=R.\"ENDTIME\", \"ENABLED\"=R.\"ENABLED\", \"DISABLEDBY\"=R.\"DISABLEDBY\", \"ACTION\"=R.\"ACTION\", \"POSTACTION\"=R.\"POSTACTION\", \"INTERVAL\"=R.\"INTERVAL\"  WHEN NOT MATCHED THEN INSERT (\"ID\",\"AGENTID\",\"PATTERNS\",\"STARTTIME\",\"EXPDURATION\",\"ENDTIME\",\"ENABLED\",\"DISABLEDBY\",\"ACTION\",\"POSTACTION\",\"INTERVAL\") VALUES (R.\"ID\",R.\"AGENTID\",R.\"PATTERNS\",R.\"STARTTIME\",R.\"EXPDURATION\",R.\"ENDTIME\",R.\"ENABLED\",R.\"DISABLEDBY\",R.\"ACTION\",R.\"POSTACTION\",R.\"INTERVAL\")";
        this.SQL_INSERT_TEMP_IDS = "INSERT INTO EVENTS_TEMP SELECT ID FROM EVENTS WHERE STATE='D' AND ROWNUM < 10000";
        this.SQL_REPLACE_AgentCM = "MERGE INTO AGENTS_EXT USING (SELECT ? \"ID\",? \"EMAIL\",? \"CONTACT\",? \"LIT\",? \"ACID\",? \"EID\",? \"BIGINT1\",? \"BIGINT2\",? \"BIGINT3\",? \"BIGINT4\",? \"BIGINT5\",? \"BIGINT6\",? \"BIGINT7\",? \"BIGINT8\",? \"BIGINT9\",? \"BIGINT10\",? \"INT1\",? \"INT2\",? \"INT3\",? \"INT4\",? \"INT5\",? \"INT6\",? \"INT7\",? \"INT8\",? \"INT9\",? \"INT10\",? \"DOUBLE1\",? \"DOUBLE2\",? \"DOUBLE3\",? \"DOUBLE4\",? \"DOUBLE5\",? \"DOUBLE6\",? \"DOUBLE7\",? \"DOUBLE8\",? \"DOUBLE9\",? \"DOUBLE10\",? \"VARCHAR1\",? \"VARCHAR2\",? \"VARCHAR3\",? \"VARCHAR4\",? \"VARCHAR5\",? \"VARCHAR6\",? \"VARCHAR7\",? \"VARCHAR8\",? \"VARCHAR9\",? \"VARCHAR10\",? \"VARCHAR11\",? \"VARCHAR12\",? \"VARCHAR13\",? \"VARCHAR14\",? \"VARCHAR15\",? \"TIMESTAMP1\",? \"TIMESTAMP2\",? \"TIMESTAMP3\",? \"TIMESTAMP4\",? \"TIMESTAMP5\" FROM DUAL) R ON (R.\"ID\" = AGENTS_EXT.\"ID\")  WHEN MATCHED THEN UPDATE SET \"EMAIL\"=R.\"EMAIL\",\"CONTACT\"=R.\"CONTACT\",\"LIT\"=R.\"LIT\",\"ACID\"=R.\"ACID\",\"EID\"=R.\"EID\",\"BIGINT1\"=R.\"BIGINT1\",\"BIGINT2\"=R.\"BIGINT2\",\"BIGINT3\"=R.\"BIGINT3\",\"BIGINT4\"=R.\"BIGINT4\",\"BIGINT5\"=R.\"BIGINT5\",\"BIGINT6\"=R.\"BIGINT6\",\"BIGINT7\"=R.\"BIGINT7\",\"BIGINT8\"=R.\"BIGINT8\",\"BIGINT9\"=R.\"BIGINT9\",\"BIGINT10\"=R.\"BIGINT10\",\"INT1\"=R.\"INT1\",\"INT2\"=R.\"INT2\",\"INT3\"=R.\"INT3\",\"INT4\"=R.\"INT4\",\"INT5\"=R.\"INT5\",\"INT6\"=R.\"INT6\",\"INT7\"=R.\"INT7\",\"INT8\"=R.\"INT8\",\"INT9\"=R.\"INT9\",\"INT10\"=R.\"INT10\",\"DOUBLE1\"=R.\"DOUBLE1\",\"DOUBLE2\"=R.\"DOUBLE2\",\"DOUBLE3\"=R.\"DOUBLE3\",\"DOUBLE4\"=R.\"DOUBLE4\",\"DOUBLE5\"=R.\"DOUBLE5\",\"DOUBLE6\"=R.\"DOUBLE6\",\"DOUBLE7\"=R.\"DOUBLE7\",\"DOUBLE8\"=R.\"DOUBLE8\",\"DOUBLE9\"=R.\"DOUBLE9\",\"DOUBLE10\"=R.\"DOUBLE10\",\"VARCHAR1\"=R.\"VARCHAR1\",\"VARCHAR2\"=R.\"VARCHAR2\",\"VARCHAR3\"=R.\"VARCHAR3\",\"VARCHAR4\"=R.\"VARCHAR4\",\"VARCHAR5\"=R.\"VARCHAR5\",\"VARCHAR6\"=R.\"VARCHAR6\",\"VARCHAR7\"=R.\"VARCHAR7\",\"VARCHAR8\"=R.\"VARCHAR8\",\"VARCHAR9\"=R.\"VARCHAR9\",\"VARCHAR10\"=R.\"VARCHAR10\",\"VARCHAR11\"=R.\"VARCHAR11\",\"VARCHAR12\"=R.\"VARCHAR12\",\"VARCHAR13\"=R.\"VARCHAR13\",\"VARCHAR14\"=R.\"VARCHAR14\",\"VARCHAR15\"=R.\"VARCHAR15\",\"TIMESTAMP1\"=R.\"TIMESTAMP1\",\"TIMESTAMP2\"=R.\"TIMESTAMP2\",\"TIMESTAMP3\"=R.\"TIMESTAMP3\",\"TIMESTAMP4\"=R.\"TIMESTAMP4\",\"TIMESTAMP5\"=R.\"TIMESTAMP5\"  WHEN NOT MATCHED THEN INSERT (\"ID\",\"EMAIL\",\"CONTACT\",\"LIT\",\"ACID\",\"EID\",\"BIGINT1\",\"BIGINT2\",\"BIGINT3\",\"BIGINT4\",\"BIGINT5\",\"BIGINT6\",\"BIGINT7\",\"BIGINT8\",\"BIGINT9\",\"BIGINT10\",\"INT1\",\"INT2\",\"INT3\",\"INT4\",\"INT5\",\"INT6\",\"INT7\",\"INT8\",\"INT9\",\"INT10\",\"DOUBLE1\",\"DOUBLE2\",\"DOUBLE3\",\"DOUBLE4\",\"DOUBLE5\",\"DOUBLE6\",\"DOUBLE7\",\"DOUBLE8\",\"DOUBLE9\",\"DOUBLE10\",\"VARCHAR1\",\"VARCHAR2\",\"VARCHAR3\",\"VARCHAR4\",\"VARCHAR5\",\"VARCHAR6\",\"VARCHAR7\",\"VARCHAR8\",\"VARCHAR9\",\"VARCHAR10\",\"VARCHAR11\",\"VARCHAR12\",\"VARCHAR13\",\"VARCHAR14\",\"VARCHAR15\",\"TIMESTAMP1\",\"TIMESTAMP2\",\"TIMESTAMP3\",\"TIMESTAMP4\",\"TIMESTAMP5\") VALUES (R.\"ID\",R.\"EMAIL\",R.\"CONTACT\",R.\"LIT\",R.\"ACID\",R.\"EID\",R.\"BIGINT1\",R.\"BIGINT2\",R.\"BIGINT3\",R.\"BIGINT4\",R.\"BIGINT5\",R.\"BIGINT6\",R.\"BIGINT7\",R.\"BIGINT8\",R.\"BIGINT9\",R.\"BIGINT10\",R.\"INT1\",R.\"INT2\",R.\"INT3\",R.\"INT4\",R.\"INT5\",R.\"INT6\",R.\"INT7\",R.\"INT8\",R.\"INT9\",R.\"INT10\",R.\"DOUBLE1\",R.\"DOUBLE2\",R.\"DOUBLE3\",R.\"DOUBLE4\",R.\"DOUBLE5\",R.\"DOUBLE6\",R.\"DOUBLE7\",R.\"DOUBLE8\",R.\"DOUBLE9\",R.\"DOUBLE10\",R.\"VARCHAR1\",R.\"VARCHAR2\",R.\"VARCHAR3\",R.\"VARCHAR4\",R.\"VARCHAR5\",R.\"VARCHAR6\",R.\"VARCHAR7\",R.\"VARCHAR8\",R.\"VARCHAR9\",R.\"VARCHAR10\",R.\"VARCHAR11\",R.\"VARCHAR12\",R.\"VARCHAR13\",R.\"VARCHAR14\",R.\"VARCHAR15\",R.\"TIMESTAMP1\",R.\"TIMESTAMP2\",R.\"TIMESTAMP3\",R.\"TIMESTAMP4\",R.\"TIMESTAMP5\")";
    }

    public ConcurrentHashMap<String, SEventFwd> readActiveMessages(ForwardManager fm, EventOperations eo, ConcurrentHashMap<String, SEventFwd> activeMap) {
        try {
            RTLogger.print(5, this.SQL_SELECT_ACTIVE_EVENTS);
            long start = System.currentTimeMillis();
            this.m_connector.readEvents(this.SQL_SELECT_ACTIVE_EVENTS, activeMap);
            RTLogger.print(5, "DB read active messages in :" + (System.currentTimeMillis() - start) + " ms");
            start = System.currentTimeMillis();
            for (SEventFwd se : activeMap.values()) {
                se.getKeyInternal();
                eo.changeMonHosts(1, se, false);
                if (fm == null) continue;
                fm.checkAllWhileLoading(se);
            }
            RTLogger.print(5, "DB active messages filters processed in :" + (System.currentTimeMillis() - start) + " ms");
            RTLogger.print(5, "Mem Total 1 " + Runtime.getRuntime().totalMemory());
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
        return activeMap;
    }

    public ArchiveDetails readArchiveMessages(long start, long finish, String where, int timeout_seconds) {
        long startms = System.currentTimeMillis();
        ArchiveDetails ad = new ArchiveDetails();
        try {
            LinkedList<Map<String, Object>> row = this.m_connectorArchive.query("SELECT count(*) AS COUNT, min(STIME) as MINSTIME FROM EVENTS_A WHERE STIME<" + start);
            Map<String, Object> r = row.get(0);
            ad.m_restRecords = Integer.parseInt(String.valueOf(r.get("COUNT")));
            Object MINSTIME = r.get("MINSTIME");
            ad.m_minStime = MINSTIME != null ? Long.parseLong(String.valueOf(MINSTIME)) : 0L;
            Object sql = "SELECT EVENTS_A.*, EVENTS_EXT_A.* FROM EVENTS_A LEFT JOIN EVENTS_EXT_A ON EVENTS_A.ID=EVENTS_EXT_A.ID_E";
            sql = (String)sql + " WHERE STIME>=" + start + " AND STIME <" + finish;
            if (where != null && where.length() > 3) {
                sql = (String)sql + where;
            }
            RTLogger.print(5, (String)sql);
            ad.m_events = this.m_connectorArchive.readEvents((String)sql, timeout_seconds);
            RTLogger.print(5, "DB read " + ad.m_events.size() + " archived messages in :" + (System.currentTimeMillis() - startms) + " ms");
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
        }
        return ad;
    }

    public Map<String, Object> getArchiveIDs() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            String sql = "SELECT ID FROM EVENTS_A WHERE STIME > " + (System.currentTimeMillis() - 604800000L);
            LinkedList<Map<String, Object>> rows = this.m_connector4Master.query(sql);
            for (Map map : rows) {
                res.put(String.valueOf(map.get(EVENT_ID)), null);
            }
        }
        catch (SQLException e) {
            RTLogger.print(2, "ARCHIVE Select IDs SQLError: ", e);
        }
        return res;
    }

    public int executeOnArchive(String sql) throws SQLException {
        int res = 0;
        try {
            res = this.m_connectorArchive.execute(sql);
        }
        catch (SQLException e) {
            RTLogger.print(2, "ARCHIVE Delete SQLError: ", e);
            throw e;
        }
        return res;
    }

    public List<String> loadAnnotations(String messageID) throws SQLException {
        ArrayList<String> annotations = new ArrayList<String>();
        LinkedList<Map<String, Object>> annotList = this.m_connectorOperator.query(this.sqlAnnotations + messageID + "'");
        annotations.ensureCapacity(annotList.size());
        for (Map map : annotList) {
            StringBuilder ab = new StringBuilder();
            Long time = Long.valueOf(String.valueOf(map.get(EVENT_TIME)));
            ab.append(map.get("STATUS")).append('|').append(time).append('\n').append(map.get("ANNOTATION").toString());
            annotations.add(ab.toString());
        }
        return annotations;
    }

    public boolean isOnline() {
        return this.m_connector.isReady();
    }

    public ConcurrentHashMap<String, SEventFwd> readAcknowledgedMessages(ForwardManager fm, EventOperations eo, ConcurrentHashMap<String, SEventFwd> closedMap) {
        try {
            RTLogger.print(5, this.SQL_SELECT_CLOSED_EVENTS);
            this.m_connector.readEvents(this.SQL_SELECT_CLOSED_EVENTS, closedMap);
            RTLogger.print(5, "Mem Total 2 " + Runtime.getRuntime().totalMemory());
            RTLogger.print(5, "Start processing closed.");
            for (SEventFwd se : closedMap.values()) {
                eo.changeMonHosts(1, se, true);
                se.setAnnotationFlag(true);
                fm.checkAllWhileLoading(se);
            }
            RTLogger.print(5, "Finished processing closed.");
            RTLogger.print(5, "Mem Total 3 " + Runtime.getRuntime().totalMemory());
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
        return closedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SEventFwd> saveEvents(Map<String, SEventFwd> events) {
        Map<String, SEventFwd> toExtProcessing;
        try {
            Map<String, SEventFwd> map = events;
            synchronized (map) {
                toExtProcessing = new HashMap<String, SEventFwd>(events);
            }
            this.m_connector.insertEvents(this.SQL_REPLACE_EVENTS, toExtProcessing);
            map = events;
            synchronized (map) {
                events.keySet().removeAll(toExtProcessing.keySet());
            }
        }
        catch (SQLException e) {
            try {
                toExtProcessing = this.failoverInsertEvents(events);
            }
            catch (SQLException e1) {
                throw new DBException(e1);
            }
        }
        return toExtProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEventsExt(Map<String, SEventFwd> sefList) {
        try {
            HashMap<String, SEventFwd> toExtProcessing;
            Map<String, SEventFwd> map = sefList;
            synchronized (map) {
                toExtProcessing = new HashMap<String, SEventFwd>(sefList);
            }
            this.m_connector.insertEventsExt(this.SQL_REPLACE_EVENTS_EXT, toExtProcessing);
            map = sefList;
            synchronized (map) {
                sefList.keySet().removeAll(toExtProcessing.keySet());
            }
        }
        catch (SQLException e) {
            try {
                this.failoverInsertEventsExt(sefList);
            }
            catch (SQLException e1) {
                throw new DBException(e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SEventFwd> failoverInsertEvents(Map<String, SEventFwd> events) throws SQLException {
        LinkedHashMap<String, SEventFwd> clone;
        Map<String, SEventFwd> map = events;
        synchronized (map) {
            clone = new LinkedHashMap<String, SEventFwd>(events);
        }
        Map<String, SEventFwd> failed = this.loopInsertEvent(clone);
        if (clone.size() != 0 || failed.size() <= 1) {
            Map<String, SEventFwd> map2 = events;
            synchronized (map2) {
                events.keySet().removeAll(clone.keySet());
                events.keySet().removeAll(failed.keySet());
                ServerEngine.getInstance().getEventsRouter().getEventOperations().markAsFailedInsertOrUpdate(failed.values());
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failoverInsertEventsExt(Map<String, SEventFwd> events) throws SQLException {
        LinkedHashMap<String, SEventFwd> clone;
        Map<String, SEventFwd> map = events;
        synchronized (map) {
            clone = new LinkedHashMap<String, SEventFwd>(events);
        }
        Map<String, SEventFwd> failed = this.loopInsertEventExt(clone);
        if (clone.size() != 0 || failed.size() <= 1) {
            Map<String, SEventFwd> map2 = events;
            synchronized (map2) {
                events.keySet().removeAll(clone.keySet());
                events.keySet().removeAll(failed.keySet());
                ServerEngine.getInstance().getEventsRouter().getEventOperations().markAsFailedInsertOrUpdate(failed.values());
            }
        }
    }

    protected Map<String, SEventFwd> loopInsertEvent(Map<String, SEventFwd> events) throws SQLException {
        if (!this.m_connector.isReady() && !this.m_connector.onOpen()) {
            throw new DBException("Can't connect");
        }
        LinkedHashMap<String, SEventFwd> failed = new LinkedHashMap<String, SEventFwd>();
        try (PreparedStatement ps = this.m_connector.getConnection().prepareStatement(this.SQL_REPLACE_EVENTS);){
            RTLogger.print(6, this.SQL_REPLACE_EVENTS);
            Iterator<Map.Entry<String, SEventFwd>> it = events.entrySet().iterator();
            while (it.hasNext()) {
                SEventFwd se = it.next().getValue();
                ps.clearParameters();
                this.m_connector.prepInsertEvents(ps, se);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    if (this.m_isOracle && errorCode == 1 || !this.m_isOracle && (errorCode == 1062 || errorCode == 1582)) {
                        RTLogger.print(5, "Duplicate entry for key. ErrorCode=" + errorCode);
                        continue;
                    }
                    if (!(this.m_isOracle && errorCode == 12899 || this.m_connector.isReady() || this.m_connector.onOpen())) {
                        throw new DBException("Can't connect");
                    }
                    this.m_toThrow = e;
                    RTLogger.print(1, "DB error Indication insert: " + errorCode, e);
                    StringBuffer sb = new StringBuffer(se.getID());
                    sb.append(' ').append(se.getSource()).append(' ').append(se.getText());
                    RTLogger.print(2, sb);
                    it.remove();
                    failed.put(se.getID(), se);
                }
            }
        }
        return failed;
    }

    protected Map<String, SEventFwd> loopInsertEventExt(Map<String, SEventFwd> events) throws SQLException {
        if (!this.m_connector.isReady() && !this.m_connector.onOpen()) {
            throw new DBException("Can't connect");
        }
        LinkedHashMap<String, SEventFwd> failed = new LinkedHashMap<String, SEventFwd>();
        try (PreparedStatement ps = this.m_connector.getConnection().prepareStatement(this.SQL_REPLACE_EVENTS_EXT);){
            RTLogger.print(6, this.SQL_REPLACE_EVENTS_EXT);
            Iterator<Map.Entry<String, SEventFwd>> it = events.entrySet().iterator();
            while (it.hasNext()) {
                SEventFwd se = it.next().getValue();
                ps.clearParameters();
                this.m_connector.prepInsertEventsExt(ps, se);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    if (this.m_isOracle && errorCode == 1 || !this.m_isOracle && (errorCode == 1062 || errorCode == 1582)) {
                        RTLogger.print(5, "SQLCode: Duplicate entry for key." + errorCode);
                        continue;
                    }
                    if (!this.m_connector.isReady() && !this.m_connector.onOpen()) {
                        throw new DBException("Can't connect");
                    }
                    if (this.m_toThrow == null || !this.m_toThrow.getMessage().equals(e.getMessage())) {
                        this.m_toThrow = e;
                        RTLogger.print(1, "DB error Indication insert or update: " + errorCode, e);
                    }
                    StringBuffer sb = new StringBuffer(" AFI: ");
                    sb.append(se.getID());
                    sb.append(' ').append(se.getSource()).append(' ').append(se.getText());
                    RTLogger.print(2, sb);
                    it.remove();
                    failed.put(se.getID(), se);
                }
            }
        }
        return failed;
    }

    public void tryInsertEvent(Queue<SEventFwd> events, AtomicBoolean saveTrigger) {
        int before = events.size();
        RTLogger.print(3, "unsaved indications queue size:" + before);
        HashMap<Integer, LinkedList<String>> errors = new HashMap<Integer, LinkedList<String>>();
        try (PreparedStatement ps1 = this.m_connector.getConnection().prepareStatement(this.SQL_REPLACE_EVENTS);
             PreparedStatement ps2 = this.m_connector.getConnection().prepareStatement(this.SQL_REPLACE_EVENTS_EXT);){
            Iterator it = events.iterator();
            while (it.hasNext()) {
                SEventFwd sef = (SEventFwd)it.next();
                try {
                    if (sef.getState() == 'D') {
                        it.remove();
                        saveTrigger.set(true);
                        continue;
                    }
                    ps1.clearParameters();
                    this.m_connector.prepInsertEvents(ps1, sef);
                    ps1.executeUpdate();
                    ps2.clearParameters();
                    this.m_connector.prepInsertEventsExt(ps2, sef);
                    ps2.executeUpdate();
                    it.remove();
                    saveTrigger.set(true);
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    LinkedList<String> arr = (LinkedList<String>)errors.get(errorCode);
                    if (arr == null) {
                        arr = new LinkedList<String>();
                        arr.add(e.getMessage());
                        errors.put(errorCode, arr);
                    }
                    arr.add(sef.getID());
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(6, "", e);
        }
    }

    public void storeInFile(Queue<SEventFwd> events) {
        File dir = new File("srv/etc");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File bkpFile = new File(dir, this.m_bkpIndiFile);
        try (NEDataOutputStream dos = new NEDataOutputStream(new FileOutputStream(bkpFile, false));){
            if (events.size() == 0) {
                if (!bkpFile.delete()) {
                    dos.write(0);
                }
            } else {
                for (SEventFwd sef : events) {
                    sef.sendSv2(dos);
                }
                dos.flush();
            }
        }
        catch (Throwable e) {
            RTLogger.print(2, "can't write " + this.m_bkpIndiFile, e);
        }
    }

    public void printInFile(SEventFwd sef) {
        File dir = new File("srv/etc/afi");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(this.m_currentArchIndiFile, true);){
            if (this.m_currentArchIndiFile == null || !this.m_currentArchIndiFile.exists() || this.m_currentArchIndiFile.length() > 0x100000L) {
                File[] files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return DB.this.pattern_m_archIndiFile.matcher(name).matches();
                    }
                });
                int max = 0;
                if (files == null || files.length == 0) {
                    this.m_currentArchIndiFile = new File(dir, this.m_archIndiFile + "." + ++max);
                } else {
                    for (File t : files) {
                        Matcher matcher = this.pattern_m_archIndiFile.matcher(t.getName());
                        if (!matcher.matches()) continue;
                        String intText = matcher.group(1);
                        try {
                            int i = Integer.parseInt(intText);
                            if (i <= max) continue;
                            max = i;
                            this.m_currentArchIndiFile = t;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (this.m_currentArchIndiFile != null && this.m_currentArchIndiFile.length() > 0x100000L) {
                        this.m_currentArchIndiFile = new File(dir, this.m_archIndiFile + "." + ++max);
                    }
                }
            }
            IndicationPrinter ip = new IndicationPrinter();
            ip.export(sef, fos);
        }
        catch (Throwable e) {
            RTLogger.print(2, "can't write " + this.m_archIndiFile, e);
        }
    }

    public ConcurrentLinkedQueue<SEventFwd> loadFromFile() {
        File bkpFile;
        ConcurrentLinkedQueue<SEventFwd> events = new ConcurrentLinkedQueue<SEventFwd>();
        File dir = new File("srv/etc");
        if (dir.exists() && dir.isDirectory() && (bkpFile = new File(dir, this.m_bkpIndiFile)).exists() && bkpFile.canRead()) {
            try (NEDataInputStream dis = new NEDataInputStream(new FileInputStream(bkpFile));){
                while (dis.available() > 0) {
                    SEventFwd sef = new SEventFwd();
                    sef.readSv2(dis);
                    events.offer(sef);
                }
            }
            catch (Exception e) {
                RTLogger.print(3, "Failed to read indications from " + bkpFile.getAbsolutePath());
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveMessages() {
        RTLogger.print(1, "Archiving started");
        long start = System.currentTimeMillis();
        StringBuilder sqlG_go = new StringBuilder();
        sqlG_go.append("DELETE FROM ").append(EVENTS_EXT_A).append(" WHERE ").append(EVENT_ID_E).append(" IN (").append("SELECT ID FROM EVENTS_TEMP)");
        StringBuilder sqlD_go = new StringBuilder();
        sqlD_go.append("DELETE FROM ").append(EVENTS_A_TABLE).append(" WHERE ").append(EVENT_ID).append(" IN (").append("SELECT ID FROM EVENTS_TEMP)");
        int rowcount = 10000;
        while (rowcount >= 9999) {
            try {
                try {
                    this.m_connectorArchive.execute(this.SQL_TRUNCATE_TEMP_IDS);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.m_updateState.writeLock().lock();
                try {
                    rowcount = this.m_connectorUpdate.execute(this.SQL_INSERT_TEMP_IDS);
                }
                finally {
                    this.m_updateState.writeLock().unlock();
                }
                if (this.m_isOracle) {
                    if (this.m_isEventEXT) {
                        this.m_connectorArchive.insertBatchNoTransaction(new String[]{sqlD_go.toString(), this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX, sqlG_go.toString(), this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX_EXT, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX_EXT, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX});
                    } else {
                        this.m_connectorArchive.insertBatchNoTransaction(new String[]{this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX});
                    }
                } else if (this.m_isEventEXT) {
                    this.m_connectorArchive.insertBatchNoTransaction(new String[]{this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX, this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX_EXT, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX_EXT, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX});
                } else {
                    this.m_connectorArchive.insertBatchNoTransaction(new String[]{this.SQL_INSERT_ARCHIVE_EVENTS_PREFIX, this.SQL_DELETE_ARCHIVED_EVENTS_PREFIX});
                }
                RTLogger.print(2, rowcount + " archived indications.");
            }
            catch (SQLException e) {
                RTLogger.print(1, "Failed to archive indications2", e);
                throw new DBException(e.getMessage());
            }
            finally {
                try {
                    this.m_connectorArchive.execute(this.SQL_TRUNCATE_TEMP_IDS);
                }
                catch (Throwable throwable) {}
                RTLogger.print(1, "Archiving finished (" + (System.currentTimeMillis() - start) + ") ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveInDB(Map<String, SEventFwd> events) {
        if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
            try {
                ArrayList<String> origIDs = new ArrayList<String>(events.size());
                Map<String, SEventFwd> map = events;
                synchronized (map) {
                    origIDs.addAll(events.keySet());
                    events.clear();
                }
                try {
                    this.m_updateState.writeLock().lock();
                    try {
                        this.setDeleteFlagPrepared(origIDs);
                    }
                    finally {
                        this.m_updateState.writeLock().unlock();
                    }
                    try {
                        DeleteTask dt = new DeleteTask(ServerEngine.getInstance().getDB());
                        ServerThreadPool.getInstance().submit(dt);
                    }
                    catch (Throwable dt) {}
                }
                catch (Throwable e) {
                    ServerEngine.getInstance().getEventsRouter().getEventOperations().markToSetDeleted(origIDs);
                    RTLogger.print(1, "DB error by archiving: ", e);
                    DBException dbException = new DBException(e.getMessage());
                    dbException.setStackTrace(e.getStackTrace());
                    throw dbException;
                }
            }
            finally {
                this.connectorUpdateIsRunning.compareAndSet(true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteInDB(Map<String, SEventFwd> events) {
        if (!this.connectorUpdateIsRunning.compareAndSet(false, true)) return;
        try {
            ArrayList<String> origIDs = new ArrayList<String>(events.size());
            Map<String, SEventFwd> map = events;
            synchronized (map) {
                origIDs.addAll(events.keySet());
                events.clear();
            }
            int limit = 500;
            ArrayList<String> aT = new ArrayList<String>(limit);
            int i = 0;
            while (i < origIDs.size()) {
                aT.clear();
                for (int j = 0; j < limit && i < origIDs.size(); ++i, ++j) {
                    aT.add((String)origIDs.get(i));
                }
                try {
                    this.deleteEvents(aT);
                }
                catch (Throwable e) {
                    ServerEngine.getInstance().getEventsRouter().getEventOperations().markToDelete(origIDs);
                    RTLogger.print(1, "DB error by deleting: ", e);
                    DBException dbException = new DBException(e.getMessage());
                    dbException.setStackTrace(e.getStackTrace());
                    throw dbException;
                    return;
                }
            }
        }
        finally {
            this.connectorUpdateIsRunning.compareAndSet(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInDBSpecial(Map<String, SEventFwd> events) {
        if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
            try {
                ArrayList<String> origIDs = new ArrayList<String>(events.size());
                Map<String, SEventFwd> map = events;
                synchronized (map) {
                    origIDs.addAll(events.keySet());
                    events.clear();
                }
                int limit = 500;
                ArrayList<String> aT = new ArrayList<String>(limit);
                int i = 0;
                while (i < origIDs.size()) {
                    aT.clear();
                    for (int j = 0; j < limit && i < origIDs.size(); ++i, ++j) {
                        aT.add((String)origIDs.get(i));
                    }
                    try {
                        this.deleteEventsSpecial(aT);
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                this.connectorUpdateIsRunning.compareAndSet(true, false);
            }
        }
    }

    protected void setDeleteFlagPrepared(List<String> events) {
        int size = events.size();
        ArrayList<Object[]> ackList = new ArrayList<Object[]>(size);
        for (String messageID : events) {
            ackList.add(new Object[]{messageID});
        }
        try {
            this.m_connectorUpdate.insertBatchPrepared(this.SQL_SETDELETES_EVENT, ackList);
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error by set deleted: ", e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteEvents(List<String> events) {
        StringBuilder sqlF_go = new StringBuilder();
        sqlF_go.append("DELETE FROM EVENTS_EXT WHERE ID_E IN (");
        StringBuilder sqlB_go = new StringBuilder();
        sqlB_go.append("DELETE FROM EVENTS WHERE ID IN (");
        StringBuilder sqlDelAnnot = new StringBuilder();
        sqlDelAnnot.append("DELETE FROM ANNOTATIONS WHERE ID IN (");
        for (int i = 0; i < events.size(); ++i) {
            String id = events.get(i);
            sqlB_go.append("'").append(id).append("'");
            sqlDelAnnot.append("'").append(id).append("'");
            if (this.m_isEventEXT) {
                sqlF_go.append("'").append(id).append("'");
            }
            if (i != events.size() - 1) {
                sqlB_go.append(',');
                sqlDelAnnot.append(',');
                if (!this.m_isEventEXT) continue;
                sqlF_go.append(',');
                continue;
            }
            sqlB_go.append(')');
            sqlDelAnnot.append(')');
            if (!this.m_isEventEXT) continue;
            sqlF_go.append(')');
        }
        try {
            if (this.m_isEventEXT) {
                this.m_connectorUpdate.insertBatch(new String[]{sqlB_go.toString(), sqlF_go.toString()});
            } else {
                this.m_connectorUpdate.insertBatch(new String[]{sqlB_go.toString()});
            }
            this.m_connectorUpdate.insertBatchNoTransaction(new String[]{sqlDelAnnot.toString()});
        }
        catch (SQLException e) {
            RTLogger.print(5, "Failed to archive indications", e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteEventsSpecial(List<String> events) {
        StringBuilder sqlF_go = new StringBuilder();
        sqlF_go.append("DELETE FROM EVENTS_EXT WHERE ID_E IN (");
        StringBuilder sqlB_go = new StringBuilder();
        sqlB_go.append("DELETE FROM EVENTS WHERE ID IN (");
        for (int i = 0; i < events.size(); ++i) {
            String id = events.get(i);
            sqlB_go.append("'").append(id).append("'");
            if (this.m_isEventEXT) {
                sqlF_go.append("'").append(id).append("'");
            }
            if (i != events.size() - 1) {
                sqlB_go.append(',');
                if (!this.m_isEventEXT) continue;
                sqlF_go.append(',');
                continue;
            }
            sqlB_go.append(')');
            if (!this.m_isEventEXT) continue;
            sqlF_go.append(')');
        }
        try {
            if (this.m_isEventEXT) {
                this.m_connectorUpdate.insertBatch(new String[]{sqlB_go.toString(), sqlF_go.toString()});
            } else {
                this.m_connectorUpdate.insertBatch(new String[]{sqlB_go.toString()});
            }
        }
        catch (SQLException e) {
            RTLogger.print(5, "Failed to clean indications", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActiveDuplicates(Map<String, SEventFwd> events) {
        block14: {
            if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
                try {
                    ArrayList<SEventFwd> tempArr;
                    Map<String, SEventFwd> map = events;
                    synchronized (map) {
                        tempArr = new ArrayList<SEventFwd>(events.values());
                        events.clear();
                    }
                    long start = System.currentTimeMillis();
                    try {
                        this.m_connectorUpdate.updateDuplicates(this.SQL_UPDATE_DUPLICATES_EVENT, tempArr);
                    }
                    catch (Throwable e) {
                        try {
                            ServerEngine.getInstance().getEventsRouter().getEventOperations().markToUpdateInDBCount(tempArr);
                            RTLogger.print(1, "Update DC DB error", e);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            long delta = (System.currentTimeMillis() - start) / 1000L;
                            if (delta > 2L) {
                                RTLogger.print(4, "DB update DC finished. Size: " + tempArr.size());
                            }
                        }
                    }
                    long delta = (System.currentTimeMillis() - start) / 1000L;
                    if (delta > 2L) {
                        RTLogger.print(4, "DB update DC finished. Size: " + tempArr.size());
                    }
                }
                finally {
                    this.connectorUpdateIsRunning.compareAndSet(true, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMessagesByMsg(Map<String, SEventFwd> messages) {
        block10: {
            if (this.connectorUpdateIsRunning.compareAndSet(false, true)) {
                try {
                    LinkedHashMap<String, SEventFwd> messagesTemp = new LinkedHashMap<String, SEventFwd>(messages.size());
                    ArrayList<Object[]> updList = new ArrayList<Object[]>(messages.size());
                    ArrayList<Object[]> updList2 = new ArrayList<Object[]>(messages.size());
                    int size = 0;
                    Map<String, SEventFwd> map = messages;
                    synchronized (map) {
                        size = messages.size();
                        messagesTemp.putAll(messages);
                        messages.clear();
                    }
                    for (Map.Entry entry : messagesTemp.entrySet()) {
                        SEventFwd message = (SEventFwd)entry.getValue();
                        message.setAnnotationFlag(true);
                        updList.add(new Object[]{"" + message.getState(), message.getID()});
                        updList2.add(new String[]{message.getT9(), message.getID()});
                    }
                    if (size <= 0) break block10;
                    try {
                        this.m_connectorUpdate.insertBatchPrepared(this.SQL_CLOSE_EVENT, updList);
                        this.m_connectorUpdate.insertBatchPrepared(this.SQL_CLOSE_EVENT2, updList2);
                    }
                    catch (SQLException e) {
                        ServerEngine.getInstance().getEventsRouter().getEventOperations().markAcknByNewMsg(messagesTemp);
                        RTLogger.print(1, "DB error by closing: ", e);
                        throw new DBException(e.getMessage());
                    }
                }
                finally {
                    this.connectorUpdateIsRunning.compareAndSet(true, false);
                }
            }
        }
    }

    public List<User> readUsers() {
        ArrayList<User> list = new ArrayList<User>();
        try {
            LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_USERS);
            list.ensureCapacity(ll.size());
            for (Map map : ll) {
                User bu = User.createUser(map);
                list.add(bu);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while reading users");
            throw new DBException(e.getMessage());
        }
        return list;
    }

    public void saveUser(User user) {
        try {
            String[] sql = new String[1];
            HashMap<String, Object> m = this.m_connectorOperator.querySimple("SELECT 'COUNT', COUNT(*) FROM USERS WHERE ID = '" + user.getId() + "'");
            String c = m.get("COUNT").toString();
            sql[0] = c.equals("0") ? "INSERT INTO USERS VALUES('" + user.getId() + "','" + user.getLoginName().toLowerCase() + "','" + user.getEncryptedPwd() + "','" + user.getFirstName() + "','" + user.getLastName() + "',(SELECT ID FROM ROLES WHERE ROLENAME = '" + user.getRoleName() + "'),'" + user.getEmail() + "','" + user.getPhone() + "','" + user.getPager() + "'," + user.getActive() + ")" : "UPDATE USERS SET LOGIN = '" + user.getLoginName().toLowerCase() + "', PASSWORD = '" + user.getEncryptedPwd() + "', FIRSTNAME = '" + user.getFirstName() + "', LASTNAME = '" + user.getLastName() + "', ROLE_ID = (SELECT ID FROM ROLES WHERE ROLENAME = '" + user.getRoleName() + "'), EMAIL = '" + user.getEmail() + "', PHONE = '" + user.getPhone() + "', PAGER = '" + user.getPager() + "', ACTIVE = " + user.getActive() + " WHERE ID = '" + user.getId() + "'";
            this.m_connectorOperator.insertBatch(sql);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error saving user " + user.getId() + ", " + user.getLoginName().toLowerCase(), e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteUser(User user) {
        try {
            String sql = "DELETE FROM USERS WHERE ID = '" + user.getId() + "'";
            this.m_connectorOperator.execute(sql);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error deleting user " + user.getId() + ", " + user.getLoginName(), e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteAgent(String agentID) {
        try {
            String sql = "DELETE FROM AGENTS WHERE ID = '" + agentID + "'";
            this.m_connectorOperator.execute(sql);
            this.deleteAgentCM(agentID);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error deleting Agent " + agentID, e);
            throw new DBException(e.getMessage());
        }
    }

    public List<UserRole> readRoles() {
        LinkedList<UserRole> list = new LinkedList<UserRole>();
        try {
            LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_ROLES);
            for (Map map : ll) {
                UserRole role = UserRole.createRole(map);
                role.addRights(this.readUserRights(role.getID()));
                list.add(role);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while reading user: ", e);
            throw new DBException(e.getMessage());
        }
        return list;
    }

    public void saveRole(UserRole role) {
        try {
            HashMap<String, Object> m = this.m_connectorOperator.querySimple("SELECT 'COUNT', COUNT(*) FROM ROLES WHERE ID = '" + role.getID() + "'");
            int c = Integer.parseInt(m.get("COUNT").toString());
            if (c == 0) {
                this.m_connectorOperator.execute(this.SQL_INSERT_USERROLE, new Object[]{role.getID(), role.getName(), role.getDescription()});
            } else {
                this.m_connectorOperator.execute(this.SQL_UPDATE_USERROLE, new Object[]{role.getName(), role.getDescription(), role.getID()});
            }
            List<UserRight> list = role.getRights();
            if (list != null) {
                String[] sqlArr = new String[list.size() + 1];
                sqlArr[0] = "DELETE FROM RIGHTS WHERE ROLE_ID = '" + role.getID() + "'";
                for (int i = 0; i < list.size(); ++i) {
                    UserRight ur = list.get(i);
                    Object sqlRights = "INSERT INTO RIGHTS VALUES (";
                    sqlRights = (String)sqlRights + "'" + ur.getRoleID() + "',";
                    sqlRights = (String)sqlRights + "'" + ur.getItemID() + "',";
                    switch (ur.getLevel()) {
                        case 1: {
                            sqlRights = (String)sqlRights + "1,0,0)";
                            break;
                        }
                        case 2: {
                            sqlRights = (String)sqlRights + "0,1,0)";
                            break;
                        }
                        case 3: {
                            sqlRights = (String)sqlRights + "0,0,1)";
                            break;
                        }
                        default: {
                            sqlRights = (String)sqlRights + "1,0,0)";
                        }
                    }
                    sqlArr[i + 1] = sqlRights;
                }
                this.m_connectorOperator.insertBatch(sqlArr);
            }
        }
        catch (SQLException e) {
            RTLogger.print(5, "error saving role " + role.getID() + ", " + role.getName(), e);
            throw new DBException(e.getMessage());
        }
    }

    public void addItem(int item, String name, String description) {
        try {
            String roleSQL = "INSERT INTO ITEMS VALUES(" + item + ",'" + name + "','" + description + "')";
            this.m_connectorOperator.execute(roleSQL);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error add item " + item, e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteRole(UserRole role) {
        try {
            String sql = "DELETE FROM ROLES WHERE ID = ?";
            this.m_connectorOperator.execute(sql, new Object[]{role.getID()});
            String sqlRights = "DELETE FROM RIGHTS WHERE ROLE_ID = ?";
            this.m_connectorOperator.execute(sqlRights, new Object[]{role.getID()});
        }
        catch (SQLException e) {
            RTLogger.print(5, "error deleting role " + role.getID() + ", " + role.getName(), e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteItem(int itemID) {
        try {
            String sql = "DELETE FROM ITEMS WHERE ID = " + itemID;
            this.m_connectorOperator.execute(sql);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error deleting item " + itemID, e);
            throw new DBException(e.getMessage());
        }
    }

    public void updateItem(int item, String name, String description) {
        try {
            String roleSQL = "UPDATE ITEMS SET NAME='" + name + "', DESCRIPTION='" + description + "' WHERE ID=" + item;
            this.m_connectorOperator.execute(roleSQL);
        }
        catch (SQLException e) {
            RTLogger.print(5, "error updating item " + item, e);
            throw new DBException(e.getMessage());
        }
    }

    public List<UItem> readItems() {
        ArrayList<UItem> list = new ArrayList<UItem>();
        try {
            LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_ITEMS);
            list.ensureCapacity(ll.size());
            for (Map map : ll) {
                UItem uitem = new UItem(map);
                list.add(uitem);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while reading items: ", e);
            throw new DBException(e.getMessage());
        }
        return list;
    }

    public Map<String, PowerGroup> readPowerGroups() throws SQLException {
        HashMap<String, PowerGroup> res = new HashMap<String, PowerGroup>();
        LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_POWERGROUPS);
        for (Map map : ll) {
            PowerGroup pg = new PowerGroup(map);
            LinkedList<Map<String, Object>> li = this.m_connectorOperator.query(this.SQL_SELECT_POWERGROUPS_ITEMS + " WHERE PGID=?", new Object[]{pg.m_ID});
            Iterator it2 = li.iterator();
            while (it2.hasNext()) {
                try {
                    Map m2 = (Map)it2.next();
                    String actionStr = (String)m2.get("PGI");
                    PGItem pgi = PGItem.parse(actionStr);
                    pg.add(pgi);
                }
                catch (Throwable e) {
                    RTLogger.print(1, "PGItem parsing error: ", e);
                }
            }
            res.put(pg.m_ID, pg);
        }
        return res;
    }

    public void savePowerGroups(String roleID, List<PowerGroup> groups) {
        for (PowerGroup pg : groups) {
            try {
                HashMap<String, Object> m = this.m_connectorOperator.querySimple("SELECT 'COUNT', COUNT(*) FROM PGROUPS WHERE ID = '" + pg.m_ID + "'");
                int c = Integer.parseInt(m.get("COUNT").toString());
                if (c == 0) {
                    roleSQL = "INSERT INTO PGROUPS VALUES(?,?,?)";
                    this.m_connectorOperator.execute(roleSQL, new Object[]{pg.m_ID, pg.m_name, pg.m_description});
                } else {
                    roleSQL = "UPDATE PGROUPS SET NAME = ?, DESCRIPTION = ?  WHERE ID = ?";
                    this.m_connectorOperator.execute(roleSQL, new Object[]{pg.m_name, pg.m_description, pg.m_ID});
                }
                List<PGItem> list = pg.getAllItems();
                if (list != null) {
                    String dellOld = "DELETE FROM PGITEMS WHERE PGID = ?";
                    this.m_connectorOperator.execute(dellOld, new Object[]{pg.m_ID});
                    for (PGItem ur : list) {
                        String sqlRights = "INSERT INTO PGITEMS VALUES (?,?)";
                        this.m_connectorOperator.execute(sqlRights, new Object[]{pg.m_ID, ur.toString()});
                    }
                }
                if ((c = Integer.parseInt((m = this.m_connectorOperator.querySimple("SELECT 'COUNT', COUNT(*) FROM PGRIGHTS WHERE ROLEID = '" + roleID + "' and PGID = '" + pg.m_ID + "'")).get("COUNT").toString())) != 0) continue;
                String rightsSQL = "INSERT INTO PGRIGHTS VALUES (?,?)";
                this.m_connectorOperator.execute(rightsSQL, new Object[]{roleID, pg.m_ID});
            }
            catch (SQLException e) {
                RTLogger.print(5, "error saving PG " + pg.m_ID, e);
                throw new DBException(e.getMessage());
            }
        }
    }

    public HashMapMap<String, String> readPGRights() throws SQLException {
        HashMapMap<String, String> map = new HashMapMap<String, String>();
        LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_POWERGROUPS_RIGHTS);
        for (Map map2 : ll) {
            map.putV((String)map2.get("ROLEID"), (String)map2.get("PGID"));
        }
        return map;
    }

    public void savePGRights(String roleID, int pgid) {
        try {
            String sql = "INSERT INTO PGRIGHTS VALUES(?,?)";
            this.m_connectorOperator.execute(sql, new Object[]{roleID, pgid});
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while inserting PGRIGHT: ", e);
        }
    }

    public void deletePGRights(String roleID, List<String> pgidList) {
        try {
            for (String id : pgidList) {
                String sql = "DELETE FROM PGRIGHTS WHERE RoleID=? and PGID=?";
                this.m_connectorOperator.execute(sql, new Object[]{roleID, id});
            }
            String sql = "DELETE FROM PGROUPS WHERE ID NOT IN (SELECT DISTINCT PGID FROM PGRIGHTS)";
            this.m_connectorOperator.execute(sql);
            String sql2 = "DELETE FROM PGITEMS WHERE PGID NOT IN (SELECT DISTINCT ID FROM PGROUPS)";
            this.m_connectorOperator.execute(sql2);
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while deleting PGRIGHT: ", e);
            throw new DBException(e.getMessage());
        }
    }

    protected ArrayList<UserRight> readUserRights(String roleID) {
        ArrayList<UserRight> list = new ArrayList<UserRight>();
        String sql = "SELECT * FROM RIGHTS WHERE ROLE_ID = '" + roleID + "'";
        try {
            LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(sql);
            list.ensureCapacity(ll.size());
            for (Map map : ll) {
                UserRight ur = new UserRight(map);
                list.add(ur);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "DB error while reading user: ", e);
        }
        return list;
    }

    public AgentCard[] readAgentCards() {
        AgentCard[] res = null;
        try {
            LinkedList<Map<String, Object>> ll = this.m_connectorOperator.query(this.SQL_SELECT_AGENTS);
            res = new AgentCard[ll.size()];
            Iterator it = ll.iterator();
            int i = 0;
            while (it.hasNext()) {
                Map m = (Map)it.next();
                res[i] = new AgentCard(m);
                ++i;
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
        return res;
    }

    public void saveAgentCard(AgentCard ac) {
        String sb = "SELECT 'COUNT', COUNT(*) FROM AGENTS WHERE ID = '" + ac.getAgentID() + "'";
        HashMap<String, Object> m = this.m_connectorOperator.querySimple(sb);
        String c = m.get("COUNT").toString();
        try {
            if (c.equals("0")) {
                int app = 0;
                int dis = 0;
                if (ac.isApproved()) {
                    app = 1;
                }
                if (ac.isDisabled()) {
                    dis = 1;
                }
                StringBuffer sb2 = new StringBuffer();
                sb2.append("INSERT INTO ").append(AGENTS_TABLE).append(" VALUES('").append(ac.getAgentID()).append("','").append(ac.getAgentHost()).append("','").append(ac.getAgentIP()).append("',").append(ac.getDefaultModeCombinedWithFlags()).append(",'").append(ac.getDescription().replace("'", "\\'")).append("','").append(ac.getLabel().replace("'", "\\'")).append("','").append(ac.getOSName().replace("'", "\\'")).append("',").append(app).append(',').append(dis);
                if (this.m_isAgentPortHERE) {
                    sb2.append(',').append(ac.getAgentPort());
                }
                sb2.append(')');
                String sql = sb2.toString();
                RTLogger.print(6, sb2);
                this.m_connectorOperator.execute(sql);
            } else {
                int app = 0;
                int dis = 0;
                if (ac.isApproved()) {
                    app = 1;
                }
                if (ac.isDisabled()) {
                    dis = 1;
                }
                Object[] values = null;
                values = this.m_isAgentPortHERE ? new Object[]{ac.getDescription(), ac.getLabel(), ac.getAgentIP(), ac.getAgentHost(), ac.getDefaultModeCombinedWithFlags(), ac.getOSName(), app, dis, ac.getAgentPort(), ac.getAgentID()} : new Object[]{ac.getDescription(), ac.getLabel(), ac.getAgentIP(), ac.getAgentHost(), ac.getDefaultModeCombinedWithFlags(), ac.getOSName(), app, dis, ac.getAgentID()};
                this.m_connectorOperator.execute(this.SQL_UPDATE_AGENT, values);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAnnotations(HashMapMap<String, Annotation> annotations) {
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        try {
            HashMapMap<String, Annotation> hashMapMap = annotations;
            synchronized (hashMapMap) {
                for (Map.Entry en : annotations.entrySet()) {
                    String message_id = (String)en.getKey();
                    Map list = (Map)en.getValue();
                    for (Annotation a : list.keySet()) {
                        data.add(new Object[]{message_id, a.getTime(), a.getStatus(), a.getText()});
                    }
                }
                annotations.clear();
            }
            this.m_connectorArchive.insertBatchPrepared(this.SQL_INSERT_ANNOTATION, data);
        }
        catch (SQLException e) {
            RTLogger.print(2, SQL_ERROR, e);
            for (Object[] arr : data) {
                try {
                    this.m_connectorArchive.execute(this.SQL_INSERT_ANNOTATION, arr);
                }
                catch (Throwable e2) {
                    RTLogger.print(2, SQL_ERROR, e);
                }
            }
        }
    }

    public ConcurrentHashMap<String, String> readHelp() {
        ConcurrentHashMap<String, String> helps = new ConcurrentHashMap<String, String>();
        try {
            LinkedList<Map<String, Object>> l = this.m_connectorOperator.query(this.SQL_SELECT_HELPS);
            l.forEach(m -> {
                String text = (String)m.get("HELP");
                String id = (String)m.get(EVENT_ID);
                if (text != null && id != null) {
                    helps.put(id, text);
                }
            });
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
        return helps;
    }

    public void saveAssignment(String id, String agentID, String assignment, String user, String type, int lock) {
        Object[] data = new Object[]{id, agentID, assignment, type, System.currentTimeMillis(), 0, user, lock};
        ArrayList<Object[]> list = new ArrayList<Object[]>(1);
        list.add(data);
        this.saveAssignments(list);
    }

    public void saveAssignments(List<Object[]> data) {
        try {
            RTLogger.print(5, this.SQL_UPDATE_ASSIGNMENT + String.valueOf(data));
            this.m_connectorOperator.insertBatchPreparedNoTransaction(this.SQL_INSERT_ASSIGNMENT, data);
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void updateAssignment(String id, String assignment, String user, int lock, long utime) {
        Object[] data = new Object[]{assignment, utime, user, lock, id};
        ArrayList<Object[]> list = new ArrayList<Object[]>(1);
        list.add(data);
        this.updateAssignments(list);
    }

    public void updateAssignments(List<Object[]> data) {
        try {
            this.m_connectorOperator.insertBatchPreparedNoTransaction(this.SQL_UPDATE_ASSIGNMENT, data);
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteAssignments(List<Object[]> ids) {
        try {
            this.m_connectorOperator.insertBatchPreparedNoTransaction(this.SQL_DELETE_ASSIGNMENT, ids);
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void renamePackage(String oldname, String newName, String user, long utime) {
        Object[] data = new Object[]{newName, utime, user, oldname};
        try {
            this.m_connectorOperator.execute(this.SQL_RENAME_ASSIGNMENT, data);
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteAssignment(String id) {
        try {
            this.m_connectorOperator.execute(this.SQL_DELETE_ASSIGNMENT, new Object[]{id});
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteAgentAssignments(String agentID) {
        try {
            this.m_connectorOperator.execute(this.SQL_DELETE_ASSIGNMENTS_FOR_AGENT, new Object[]{agentID});
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public void deleteAssignment(String name, String type) {
        try {
            this.m_connectorOperator.execute(this.SQL_DELETE_ASSIGNMENT_BYNAMEANDTYPE, new Object[]{name, type});
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
    }

    public List<Assignment> loadAssignments() {
        ArrayList<Assignment> listRes = new ArrayList<Assignment>();
        try {
            LinkedList<Map<String, Object>> list = this.m_connectorOperator.query(this.SQL_SELECT_ASSIGNMENTS);
            listRes.ensureCapacity(list.size());
            for (Map map : list) {
                Assignment obj = Assignment.getInstance(map);
                if (obj == null) continue;
                listRes.add(obj);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, SQL_ERROR, e);
            throw new DBException(e.getMessage());
        }
        return listRes;
    }

    public void insertPerfData(long time, String fields, String db, String className, String[] values) throws SQLException {
        String originalFields = fields;
        if (this.m_isOraclePERF) {
            fields = "\"" + (String)fields;
            fields = ((String)fields).replace(",", ",\"");
            fields = ((String)fields).replace("/*", "\"/*");
        } else {
            fields = "`" + (String)fields;
            fields = ((String)fields).replace(",", ",`");
            fields = ((String)fields).replace("/*", "`/*");
        }
        Object[] valuesObjArr = new Object[values.length + 1];
        StringBuilder prepsql = new StringBuilder();
        valuesObjArr[0] = time;
        prepsql.append("INSERT INTO ").append(db).append('.').append(className).append(" (").append((String)fields).append(") VALUES (").append("?").append(", ");
        for (int i = 0; i < values.length; ++i) {
            Matcher m2;
            String val = values[i];
            Matcher m = patternDoublesDDF.matcher(val);
            if (m.matches() && !this.m_isOraclePERF) {
                val = val.replace(',', '.');
            }
            if ((m2 = patternDoublesDDF2.matcher(val)).matches() && this.m_isOraclePERF) {
                val = val.replace('.', ',');
            }
            try {
                long v = Long.parseLong(val);
                valuesObjArr[i + 1] = v;
            }
            catch (NumberFormatException e) {
                try {
                    double d = Double.parseDouble(val);
                    valuesObjArr[i + 1] = d;
                }
                catch (NumberFormatException e1) {
                    valuesObjArr[i + 1] = val;
                }
            }
            prepsql.append('?');
            if (i == values.length - 1) continue;
            prepsql.append(", ");
        }
        prepsql.append(')');
        if (RTLogger.getCurrentLevel() >= 6) {
            StringBuffer sb = new StringBuffer("PERF SQL: ");
            sb.append((CharSequence)prepsql);
            sb.append(" ");
            for (Object obj : valuesObjArr) {
                if (obj == null) {
                    obj = "NULL";
                }
                sb.append(obj).append(',');
            }
            RTLogger.print(6, sb);
        }
        PerfSQL psql = new PerfSQL(className, originalFields, prepsql.toString());
        this.m_perfBuffer.queuePerf(psql, valuesObjArr);
        if (this.m_perfThread == null || !this.m_perfThread.isAlive()) {
            this.m_perfThread = new Thread((Runnable)this.m_perfBuffer, "PerfIns");
            this.m_perfThread.start();
        }
    }

    public List<DDFField> getPerfTableMetaData(String tableName) {
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        if (this.m_isOraclePERF) {
            if (tableName.startsWith("\"")) {
                tableName = tableName.substring(1);
            }
            if (tableName.endsWith("\"")) {
                tableName = tableName.substring(0, tableName.length() - 1);
            }
            sb.append(this.m_perfDBName).append(".\"").append(tableName).append("\" where rownum<=1");
        } else {
            if (tableName.startsWith("`")) {
                tableName = tableName.substring(1);
            }
            if (tableName.endsWith("`")) {
                tableName = tableName.substring(0, tableName.length() - 1);
            }
            sb.append(this.m_perfDBName).append(".`").append(tableName).append("` limit 1");
        }
        ArrayList<DDFField> al = new ArrayList<DDFField>();
        try (Statement stMain = this.m_connector_perf2.getConnection().createStatement(1003, 1007);
             ResultSet rs = stMain.executeQuery(sb.toString());){
            ResultSetMetaData rsMD = rs.getMetaData();
            int size = rsMD.getColumnCount();
            al.ensureCapacity(size);
            for (int i = 1; i <= size; ++i) {
                DDFField field = new DDFField(rsMD.getColumnName(i), i - 1);
                field.setType(rsMD.getColumnTypeName(i));
                field.setSize(rsMD.getPrecision(i));
                al.add(field);
            }
        }
        catch (SQLException e) {
            RTLogger.print(3, "Error getting meta information for table: " + tableName, e);
            throw new DBException(e.getMessage());
        }
        return al;
    }

    public HashMapArray<String, DDFField> getPerfTables() {
        HashMapArray<String, DDFField> res = new HashMapArray<String, DDFField>();
        String sql = "SHOW TABLES FROM " + this.m_perfDBName;
        if (this.m_isOraclePERF) {
            try {
                LinkedList<Map<String, Object>> ll = this.m_connector_perf2.query("SELECT TABLE_NAME FROM USER_TABLES");
                for (Map map : ll) {
                    String tableName = (String)map.get("TABLE_NAME");
                    List<DDFField> ddfFields = this.getPerfTableMetaData(tableName);
                    res.put(tableName.toUpperCase(), ddfFields);
                }
            }
            catch (SQLException e) {
                throw new DBException(e.getMessage());
            }
        }
        try {
            LinkedList<Map<String, Object>> l = this.m_connector_perf2.query(sql);
            for (Map map : l) {
                String tableName = (String)map.values().toArray()[0];
                List<DDFField> ddfFields = this.getPerfTableMetaData(tableName);
                res.put(tableName.toUpperCase(), ddfFields);
            }
        }
        catch (SQLException e) {
            throw new DBException(e.getMessage());
        }
        return res;
    }

    public List<String> getPerfTableNames() {
        LinkedList<String> res = new LinkedList<String>();
        String sql = "SHOW TABLES FROM " + this.m_perfDBName;
        if (this.m_isOraclePERF) {
            try {
                LinkedList<Map<String, Object>> ll = this.m_connector_perf2.query("SELECT TABLE_NAME FROM USER_TABLES");
                for (Map map : ll) {
                    String tableName = (String)map.get("TABLE_NAME");
                    res.add(tableName);
                }
            }
            catch (Throwable ll) {}
        } else {
            try {
                LinkedList<Map<String, Object>> l = this.m_connector_perf2.query(sql);
                for (Map map : l) {
                    String tableName = (String)map.values().toArray()[0];
                    res.add(tableName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return res;
    }

    public int executePerf2(String sql) throws SQLException {
        return this.m_connector_perf2.execute(sql);
    }

    public int executePerf2(String sql, int timeoutSec) throws SQLException {
        return this.m_connector_perf2.execute(sql, timeoutSec);
    }

    public List<Map<String, Object>> queryPerf2(String sql) throws SQLException {
        try {
            return this.m_connector_perf2.query(sql);
        }
        catch (SQLException e) {
            RTLogger.print(4, "Error query PERF DB: " + sql, e);
            throw e;
        }
    }

    public List<Map<String, Object>> select(String sql) {
        ArrayList<Map<String, Object>> records = new ArrayList();
        try {
            records = this.m_connector.query(sql);
        }
        catch (SQLException e) {
            RTLogger.print(6, e.getMessage());
        }
        return records;
    }

    public List<Map<String, Object>> selectPerfDirect(String sql, int timeoutSeconds) throws SQLException {
        ArrayList<Map<String, Object>> records = new ArrayList();
        records = this.m_connector_perf2.queryDirect(sql, timeoutSeconds);
        return records;
    }

    public List<Map<String, Object>> selectDirect(String sql, int timeoutSeconds) throws SQLException {
        ArrayList<Map<String, Object>> records = new ArrayList();
        records = this.m_connectorOperator.queryDirect(sql, timeoutSeconds);
        return records;
    }

    public int executeDirect(String sql) throws SQLException {
        return this.m_connectorOperator.execute(sql);
    }

    public List<Map<String, Object>> queryActionRights() {
        return this.select(this.SQL_ACTIONS_RIGHTS);
    }

    public boolean isEnabled() {
        return this.m_dbEnabled.get();
    }

    public void enableDB() {
        if (this.m_dbEnabled.compareAndSet(false, true)) {
            this.m_connector.setEnabled(true);
            this.m_connectorArchive.setEnabled(true);
            this.m_connector4Master.setEnabled(true);
            this.m_connectorOperator.setEnabled(true);
            this.m_connectorUpdate.setEnabled(true);
            SEventFwd sm = SMessage.createMessage(1, 1, "BOOM_SERVER", "DB", "RUNTIME", "DB is enabled");
            sm.setKey("BOOM_SERVER:RUNTIME:DB:ENABLE");
            sm.setCloseMask("BOOM_SERVER:RUNTIME:DB:DISABLE");
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
        }
    }

    public void disableDB() {
        if (this.m_dbEnabled.compareAndSet(true, false)) {
            this.m_connector.setEnabled(false);
            this.m_connectorArchive.setEnabled(false);
            this.m_connector4Master.setEnabled(false);
            this.m_connectorOperator.setEnabled(false);
            this.m_connectorUpdate.setEnabled(false);
            SEventFwd sm = SMessage.createMessage(5, 1, "BOOM_SERVER", "DB", "RUNTIME", "DB is disabled");
            sm.setKey("BOOM_SERVER:RUNTIME:DB:DISABLE");
            sm.setCloseMask("BOOM_SERVER:RUNTIME:DB:ENABLE");
            ServerEngine.getInstance().getEventsRouter().submitNewMessageInternal(sm);
        }
    }

    public void enableDB_PERF() {
        this.m_connector_perf.setEnabled(true);
        this.m_connector_perf2.setEnabled(true);
    }

    public void disableDB_PERF() {
        this.m_connector_perf.setEnabled(false);
        this.m_connector_perf2.setEnabled(false);
    }

    public Connector getConnectorArchive() {
        return this.m_connectorArchive;
    }

    public List<AgentOutagePolicy> readAgentOutagePolicies() {
        LinkedList<AgentOutagePolicy> policies = new LinkedList<AgentOutagePolicy>();
        try {
            LinkedList<Map<String, Object>> res = this.m_connectorOperator.query(this.SQL_selectAgOutPolicies);
            for (Map map : res) {
                AgentOutagePolicy aop = new AgentOutagePolicy(map);
                policies.add(aop);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "Error reading O_AGENTS", e);
        }
        return policies;
    }

    public boolean deleteAgentOutagePolicy(String id) throws SQLException {
        int res = this.m_connectorOperator.execute(this.SQL_deleteAgOutPolicy, new Object[]{id});
        return res > 0;
    }

    public void saveAgentOutagePolicies(List<AgentOutagePolicy> list) throws SQLException {
        ArrayList<Object[]> values = new ArrayList<Object[]>(list.size());
        for (AgentOutagePolicy ap : list) {
            values.add(new Object[]{ap.getID(), ap.getAgentID(), ap.getFiltersAsString(), ap.getTimeInterval().getFirstStart(), ap.getExpectedDuration(), ap.getIsEndTime(), ap.isEnabled() ? 1 : 0, ap.getDisabledBy(), ap.getAction(), ap.getPostAction(), ap.getTimeInterval().getInterval()});
        }
        this.m_connectorOperator.insertBatchPreparedNoTransaction(this.SQL_REPLACE_AgOutPolicies, values);
    }

    public Map<String, AgentCardCM> readAgentCM() {
        HashMap<String, AgentCardCM> result = new HashMap<String, AgentCardCM>();
        try {
            LinkedList<Map<String, Object>> res = this.m_connectorOperator.query(this.SQL_selectAll_AgentCM);
            for (Map map : res) {
                String id = (String)map.remove(EVENT_ID);
                if (id == null) continue;
                AgentCardCM agCM = new AgentCardCM(id);
                for (Map.Entry en : map.entrySet()) {
                    String colName = (String)en.getKey();
                    Object value = en.getValue();
                    if (value == null) continue;
                    try {
                        agCM.add(colName, value);
                    }
                    catch (Exception exception) {}
                }
                result.put(agCM.getID(), agCM);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "Error reading AGENTS_EXT", e);
        }
        return result;
    }

    public AgentCardCM readAgentCM(String id) {
        AgentCardCM agCM = null;
        try {
            LinkedList<Map<String, Object>> res = this.m_connectorOperator.query(this.SQL_select_AgentCM, new Object[]{id});
            for (Map map : res) {
                for (Map.Entry en : map.entrySet()) {
                    String colName = (String)en.getKey();
                    Object value = en.getValue();
                    if (agCM == null) {
                        agCM = new AgentCardCM(id);
                    }
                    if (value == null) continue;
                    try {
                        agCM.add(colName, value);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "Error reading AGENTS_EXT", e);
        }
        return agCM;
    }

    public boolean deleteAgentCM(String id) throws SQLException {
        int res = this.m_connectorOperator.execute(this.SQL_delete_AgentCM, new Object[]{id});
        return res > 0;
    }

    public void saveAgentCMs(Collection<AgentCardCM> list) throws SQLException {
        ArrayList<Object[]> values = new ArrayList<Object[]>(list.size());
        for (AgentCardCM ap : list) {
            values.add(new Object[]{ap.getID(), ap.getValue("EMAIL"), ap.getValue("CONTACT"), ap.getValue("LIT"), ap.getValue("ACID"), ap.getValue("EID"), ap.getValue("BIGINT1"), ap.getValue("BIGINT2"), ap.getValue("BIGINT3"), ap.getValue("BIGINT4"), ap.getValue("BIGINT5"), ap.getValue("BIGINT6"), ap.getValue("BIGINT7"), ap.getValue("BIGINT8"), ap.getValue("BIGINT9"), ap.getValue("BIGINT10"), ap.getValue("INT1"), ap.getValue("INT2"), ap.getValue("INT3"), ap.getValue("INT4"), ap.getValue("INT5"), ap.getValue("INT6"), ap.getValue("INT7"), ap.getValue("INT8"), ap.getValue("INT9"), ap.getValue("INT10"), ap.getValue("DOUBLE1"), ap.getValue("DOUBLE2"), ap.getValue("DOUBLE3"), ap.getValue("DOUBLE4"), ap.getValue("DOUBLE5"), ap.getValue("DOUBLE6"), ap.getValue("DOUBLE7"), ap.getValue("DOUBLE8"), ap.getValue("DOUBLE9"), ap.getValue("DOUBLE10"), ap.getValue("VARCHAR1"), ap.getValue("VARCHAR2"), ap.getValue("VARCHAR3"), ap.getValue("VARCHAR4"), ap.getValue("VARCHAR5"), ap.getValue("VARCHAR6"), ap.getValue("VARCHAR7"), ap.getValue("VARCHAR8"), ap.getValue("VARCHAR9"), ap.getValue("VARCHAR10"), ap.getValue("VARCHAR11"), ap.getValue("VARCHAR12"), ap.getValue("VARCHAR13"), ap.getValue("VARCHAR14"), ap.getValue("VARCHAR15"), ap.getValue("TIMESTAMP1"), ap.getValue("TIMESTAMP2"), ap.getValue("TIMESTAMP3"), ap.getValue("TIMESTAMP4"), ap.getValue("TIMESTAMP5")});
        }
        this.m_connectorOperator.insertBatchPreparedNoTransaction(this.SQL_REPLACE_AgentCM, values);
    }

    public Map<String, String> readAgentCMLabel() {
        HashMap<String, String> labels = new HashMap<String, String>();
        try {
            LinkedList<Map<String, Object>> res = this.m_connectorOperator.query(this.SQL_selectAgentExtLabels);
            for (Map map : res) {
                String colName = (String)map.get("COLUMNNAME");
                String colLabel = (String)map.get("LABEL");
                if (colName == null || colLabel == null) continue;
                labels.put(colName, colLabel);
            }
        }
        catch (SQLException e) {
            RTLogger.print(1, "Error reading AGENTS_EXT_LABELS", e);
        }
        return labels;
    }
}

