/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.db;

import com.blixx.log.RTLogger;
import com.blixx.server.db.Bytes;
import com.blixx.server.db.Connector;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OraConnector
extends Connector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean onOpen() {
        if (!this.isEnabled.get()) {
            return false;
        }
        boolean isOK = false;
        Statement st = null;
        try {
            DriverManager.setLoginTimeout(3);
            RTLogger.print(2, "JDBC: " + this.m_props.getJdbc());
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_connection = DriverManager.getConnection(this.m_props.getJdbc(), this.m_props.getLogin(), this.m_props.getPassword());
            this.m_connection.setAutoCommit(true);
            this.m_connection.setCatalog(this.m_props.getDbName());
            try {
                DatabaseMetaData dbmd = this.m_connection.getMetaData();
                RTLogger.print(1, "JDBC Driver Name: " + dbmd.getDriverName());
                RTLogger.print(1, "JDBC Driver Version: " + dbmd.getDriverVersion());
            }
            catch (Throwable dbmd) {
                // empty catch block
            }
            String NLS_NUM = "ALTER SESSION SET NLS_NUMERIC_CHARACTERS = \",.\"";
            st = this.m_connection.createStatement();
            st.execute(NLS_NUM);
            RTLogger.print(5, NLS_NUM);
            String NLS_DATE = "ALTER SESSION SET NLS_DATE_FORMAT = \"YYYY-MM-DD HH24:MI:SS\"";
            st.execute(NLS_DATE);
            RTLogger.print(5, NLS_DATE);
            try {
                String disableRecycleBin = "ALTER SESSION SET RECYCLEBIN=OFF";
                st.execute(disableRecycleBin);
                RTLogger.print(5, disableRecycleBin);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            st.close();
            isOK = true;
        }
        catch (SQLException ex) {
            RTLogger.print(1, "Connection Error. DB: " + this.m_props.getDbName(), ex);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return isOK;
    }

    public OraConnector(File file) {
        super(file);
    }

    public OraConnector(Properties prop) {
        super(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isReady() {
        boolean isready;
        block24: {
            if (!this.isEnabled.get()) {
                return false;
            }
            isready = false;
            if (this.m_connection != null) {
                Statement stMain = null;
                ResultSet rs = null;
                try {
                    if (this.m_connection.isClosed()) break block24;
                    long delta = System.currentTimeMillis() - this.m_lastQueryIsReady;
                    if (delta > 30000L) {
                        stMain = this.m_connection.createStatement(1003, 1007);
                        rs = stMain.executeQuery("SELECT 1 FROM DUAL");
                        rs.next();
                        try {
                            rs.next();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        isready = true;
                        rs.close();
                        this.m_lastQueryIsReady = System.currentTimeMillis();
                        break block24;
                    }
                    isready = true;
                }
                catch (Throwable e) {
                    RTLogger.print(2, "Oracle connection is not ready. " + e.getMessage());
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable delta) {}
                    }
                    if (stMain != null) {
                        try {
                            stMain.close();
                        }
                        catch (Throwable delta) {}
                    }
                }
            }
        }
        return isready;
    }

    @Override
    public Statement getStatementForReadArchived() throws SQLException {
        Statement stMain = this.m_connection.createStatement(1003, 1007);
        try {
            stMain.setFetchSize(1000);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stMain;
    }

    @Override
    protected Map<String, Object> processRS(ResultSet rsOra, ResultSetMetaData rsMD) throws SQLException {
        OracleResultSet rs = (OracleResultSet)rsOra;
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= rsMD.getColumnCount(); ++i) {
            Object valueObj = null;
            Object name = rsMD.getColumnName(i);
            name = ((String)name).replace('\'', ' ');
            name = ((String)name).replace('\"', ' ');
            name = ((String)name).trim();
            if (rsMD.getColumnType(i) == 2004 || rsMD.getColumnType(i) == -4) {
                try {
                    BLOB b = rs.getBLOB(i);
                    if (b != null) {
                        byte[] arr = this.toByteArray((Blob)b);
                        byte[] arrclean = OraConnector.cleanBytes(arr);
                        Bytes value = new Bytes(arrclean);
                        valueObj = value;
                        name = "*" + (String)name;
                    }
                }
                catch (Throwable e1) {
                    RTLogger.print(3, "DB blob read failed.", e1);
                }
            } else if (rsMD.getColumnType(i) == 2005) {
                CLOB clob = rs.getCLOB(i);
                try {
                    valueObj = OraConnector.ClobToString(clob);
                }
                catch (IOException e) {
                    valueObj = "";
                }
            } else {
                valueObj = rsMD.getColumnType(i) == 91 || rsMD.getColumnType(i) == 93 ? rs.getTimestamp(i) : rs.getObject(i);
            }
            if (valueObj instanceof String && "".equals(valueObj)) {
                valueObj = "";
            }
            row.put((String)name, valueObj);
        }
        return row;
    }

    public static String ClobToString(CLOB cl) throws IOException, SQLException {
        if (cl == null) {
            return "";
        }
        StringBuffer strOut = new StringBuffer();
        try (BufferedReader br = new BufferedReader(cl.getCharacterStream());){
            String aux;
            while ((aux = br.readLine()) != null) {
                strOut.append(aux).append('\n');
            }
        }
        String res = strOut.toString();
        return res.substring(0, res.length() - 1);
    }

    private byte[] toByteArray(Blob fromBlob) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byArray = this.toByteArrayImpl(fromBlob, baos);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        baos.close();
        return byArray;
    }

    private byte[] toByteArrayImpl(Blob fromBlob, ByteArrayOutputStream baos) throws SQLException, IOException {
        byte[] buf = new byte[4000];
        try (InputStream is = fromBlob.getBinaryStream();){
            int dataSize;
            while ((dataSize = is.read(buf)) != -1) {
                baos.write(buf, 0, dataSize);
            }
        }
        return baos.toByteArray();
    }

    public static byte[] cleanBytes(byte[] array) {
        int i;
        byte[] res = null;
        Vector<Byte> v = new Vector<Byte>();
        for (i = 0; i < array.length; ++i) {
            byte curr = array[i];
            if (curr != 92) {
                v.add(curr);
                continue;
            }
            if (array[i + 1] == 39 || array[i + 1] == 92 || array[i + 1] == 34 || array[i + 1] == 48 || array[i + 1] == 0) {
                if ((curr = array[++i]) == 48) {
                    curr = 0;
                }
                v.add(curr);
                continue;
            }
            v.add(curr);
        }
        res = new byte[v.size()];
        for (i = 0; i < v.size(); ++i) {
            res[i] = (Byte)v.get(i);
        }
        return res;
    }
}

