/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.ext;

import com.blixx.server.UserManager;
import com.blixx.server.ext.ForwardManager;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.UserRole;
import java.util.Collection;
import java.util.Iterator;

public class EventIterator
implements Iterator<SEventFwd> {
    Iterator<SEventFwd> m_it = null;
    ForwardManager m_fm = null;
    SEventFwd m_ev = null;
    int m_prev = 0;
    int m_curr = 0;
    String m_user = null;
    String m_userRoleNameInBrackets = "[]";
    boolean m_useForwardManagerFiltering = false;
    boolean m_usePowerGroupFiltering = false;
    Collection<String> m_agentIDs = null;

    public EventIterator(Iterator<SEventFwd> it, ForwardManager fm, String user) {
        this.m_it = it;
        this.m_fm = fm;
        this.m_user = user;
        UserRole ur = UserManager.getInstance().getRoleForUser(this.m_user);
        if (ur != null) {
            this.m_userRoleNameInBrackets = ur.getNameInBrackets();
        }
        this.m_useForwardManagerFiltering = fm.isUserIndicationsFiltered(this.m_user);
        this.m_usePowerGroupFiltering = UserManager.getInstance().isUserNodeGroupFiltered(user);
        if (this.m_usePowerGroupFiltering) {
            this.m_agentIDs = UserManager.getInstance().getVisibleAgentsIDs(user);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.m_useForwardManagerFiltering && !this.m_usePowerGroupFiltering) {
            return this.m_it.hasNext();
        }
        boolean hasNext = false;
        if (this.m_ev != null && this.m_prev == this.m_curr - 1) {
            return true;
        }
        while (this.m_it.hasNext()) {
            SEventFwd ie = this.m_it.next();
            boolean isMatched = this.m_fm.isMatchedByFilteredAgents(ie, this.m_agentIDs);
            if (!isMatched) continue;
            if (this.m_useForwardManagerFiltering) {
                Collection<String> userList = null;
                userList = this.m_fm.checkAll(ie, false, false);
                boolean filteredByServerPolicy = userList != null && (userList.contains(this.m_userRoleNameInBrackets) || userList.contains(this.m_user));
                if (!filteredByServerPolicy) continue;
                hasNext = true;
                this.foundNext(ie);
                break;
            }
            hasNext = true;
            this.foundNext(ie);
            break;
        }
        return hasNext;
    }

    private void foundNext(SEventFwd ie) {
        this.m_ev = ie;
        ++this.m_curr;
    }

    @Override
    public SEventFwd next() {
        if (!this.m_useForwardManagerFiltering && !this.m_usePowerGroupFiltering) {
            return this.m_it.next();
        }
        ++this.m_prev;
        return this.m_ev;
    }

    @Override
    public void remove() {
        this.m_it.remove();
    }
}

