/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.ext;

import com.blixx.log.RTLogger;
import com.blixx.server.ext.FilterCacheElement;
import com.blixx.server.utils.BkpFile;
import com.blixx.shared.IEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.FPolicyFactory;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.utils.Diff;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class FiltersCache {
    protected Map<String, FilterCacheElement> m_applications = new ConcurrentHashMap<String, FilterCacheElement>(100, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_nodes = new ConcurrentHashMap<String, FilterCacheElement>(200, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_msggrps = new ConcurrentHashMap<String, FilterCacheElement>(100, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_objects = new ConcurrentHashMap<String, FilterCacheElement>(500, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_services = new ConcurrentHashMap<String, FilterCacheElement>(100, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca1 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca2 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca3 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca4 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca5 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca6 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca7 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca8 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca9 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca10 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca11 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca12 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca13 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca14 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca15 = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_source = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_text = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_slaveServers = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_severity = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_key = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_agentHost = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<String, FilterCacheElement> m_ca = new ConcurrentHashMap<String, FilterCacheElement>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_appl_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_nodes_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_mg_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_obj_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_serv_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_ca1_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca2_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca3_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca4_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca5_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca6_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca7_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca8_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca9_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca10_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca11_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca12_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca13_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca14_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_ca15_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.9f, 3);
    protected Map<Integer, ForwardFilter> m_nodeGroups_filters = new ConcurrentHashMap<Integer, ForwardFilter>(100, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_source_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_text_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_slaveServers_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_severity_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_key_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_agentID_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_agentHost_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    protected Map<Integer, ForwardFilter> m_ca_filters = new ConcurrentHashMap<Integer, ForwardFilter>(10, 0.8f, 3);
    private final ReentrantReadWriteLock reentrantRWLock = new ReentrantReadWriteLock();
    private final HashSet<String> cas = new HashSet();
    private final Path dir;
    private Supplier<List<ForwardPolicy>> serverForwardPoliciesSupplier = null;
    private AtomicLong optimizationTime = new AtomicLong(0L);
    private static AtomicBoolean m_greenToOptimize = new AtomicBoolean(true);

    public FiltersCache(Path dir, Supplier<List<ForwardPolicy>> serverForwardPoliciesSupplier) {
        this.serverForwardPoliciesSupplier = serverForwardPoliciesSupplier;
        for (int j = 1; j <= 15; ++j) {
            this.cas.add("CA" + j);
        }
        this.dir = dir == null ? Paths.get(".", new String[0]) : dir;
        this.init(this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(Path dir) {
        this.reentrantRWLock.writeLock().lock();
        try {
            this.cleanCache();
            this.cleanFilters();
            FPolicyFactory pf = new FPolicyFactory();
            List<ForwardFilter> al = pf.initFilters(this.getFgfFile());
            if (al != null) {
                for (ForwardFilter ff : al) {
                    this.addFilter(ff);
                }
            }
        }
        finally {
            this.reentrantRWLock.writeLock().unlock();
        }
    }

    public File getFgfFile() {
        return this.getFgfPath().toFile();
    }

    public Path getFgfPath() {
        return this.dir.resolve("filters.fgf.xml");
    }

    public int isExist(Integer number) {
        if (this.m_appl_filters.containsKey(number)) {
            return 1;
        }
        if (this.m_mg_filters.containsKey(number)) {
            return 2;
        }
        if (this.m_obj_filters.containsKey(number)) {
            return 3;
        }
        if (this.m_nodes_filters.containsKey(number)) {
            return 4;
        }
        if (this.m_serv_filters.containsKey(number)) {
            return 5;
        }
        if (this.m_ca1_filters.containsKey(number)) {
            return 6;
        }
        if (this.m_ca2_filters.containsKey(number)) {
            return 7;
        }
        if (this.m_ca3_filters.containsKey(number)) {
            return 8;
        }
        if (this.m_ca4_filters.containsKey(number)) {
            return 9;
        }
        if (this.m_ca5_filters.containsKey(number)) {
            return 10;
        }
        if (this.m_ca6_filters.containsKey(number)) {
            return 11;
        }
        if (this.m_ca7_filters.containsKey(number)) {
            return 12;
        }
        if (this.m_ca8_filters.containsKey(number)) {
            return 13;
        }
        if (this.m_ca9_filters.containsKey(number)) {
            return 14;
        }
        if (this.m_ca10_filters.containsKey(number)) {
            return 15;
        }
        if (this.m_ca11_filters.containsKey(number)) {
            return 16;
        }
        if (this.m_ca12_filters.containsKey(number)) {
            return 17;
        }
        if (this.m_ca13_filters.containsKey(number)) {
            return 18;
        }
        if (this.m_ca14_filters.containsKey(number)) {
            return 19;
        }
        if (this.m_ca15_filters.containsKey(number)) {
            return 20;
        }
        if (this.m_nodeGroups_filters.containsKey(number)) {
            return 21;
        }
        if (this.m_source_filters.containsKey(number)) {
            return 22;
        }
        if (this.m_text_filters.containsKey(number)) {
            return 23;
        }
        if (this.m_slaveServers_filters.containsKey(number)) {
            return 34;
        }
        if (this.m_severity_filters.containsKey(number)) {
            return 24;
        }
        if (this.m_key_filters.containsKey(number)) {
            return 25;
        }
        if (this.m_agentID_filters.containsKey(number)) {
            return 26;
        }
        if (this.m_agentHost_filters.containsKey(number)) {
            return 27;
        }
        if (this.m_ca_filters.containsKey(number)) {
            return 28;
        }
        return 0;
    }

    public ForwardFilter getForwardFilter(Integer number) {
        ForwardFilter ff = null;
        ff = this.m_agentID_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_nodeGroups_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_appl_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_mg_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_obj_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_nodes_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_serv_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca1_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca2_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca3_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca4_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca5_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca6_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca7_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca8_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca9_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca10_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca11_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca12_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca13_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca14_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca15_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_source_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_text_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_slaveServers_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_severity_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_key_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_agentHost_filters.get(number);
        if (ff != null) {
            return ff;
        }
        ff = this.m_ca_filters.get(number);
        if (ff != null) {
            return ff;
        }
        return ff;
    }

    @Deprecated
    void removeFilter(ForwardFilter ff) {
        switch (ff.getType()) {
            case 1: {
                this.m_appl_filters.remove(ff.getNumber());
                break;
            }
            case 2: {
                this.m_mg_filters.remove(ff.getNumber());
                break;
            }
            case 3: {
                this.m_obj_filters.remove(ff.getNumber());
                break;
            }
            case 4: {
                this.m_nodes_filters.remove(ff.getNumber());
                break;
            }
            case 5: {
                this.m_serv_filters.remove(ff.getNumber());
                break;
            }
            case 6: {
                this.m_ca1_filters.remove(ff.getNumber());
                break;
            }
            case 7: {
                this.m_ca2_filters.remove(ff.getNumber());
                break;
            }
            case 8: {
                this.m_ca3_filters.remove(ff.getNumber());
                break;
            }
            case 9: {
                this.m_ca4_filters.remove(ff.getNumber());
                break;
            }
            case 10: {
                this.m_ca5_filters.remove(ff.getNumber());
                break;
            }
            case 11: {
                this.m_ca6_filters.remove(ff.getNumber());
                break;
            }
            case 12: {
                this.m_ca7_filters.remove(ff.getNumber());
                break;
            }
            case 13: {
                this.m_ca8_filters.remove(ff.getNumber());
                break;
            }
            case 14: {
                this.m_ca9_filters.remove(ff.getNumber());
                break;
            }
            case 15: {
                this.m_ca10_filters.remove(ff.getNumber());
                break;
            }
            case 16: {
                this.m_ca11_filters.remove(ff.getNumber());
                break;
            }
            case 17: {
                this.m_ca12_filters.remove(ff.getNumber());
                break;
            }
            case 18: {
                this.m_ca13_filters.remove(ff.getNumber());
                break;
            }
            case 19: {
                this.m_ca14_filters.remove(ff.getNumber());
                break;
            }
            case 20: {
                this.m_ca15_filters.remove(ff.getNumber());
                break;
            }
            case 21: {
                this.m_nodeGroups_filters.remove(ff.getNumber());
                break;
            }
            case 22: {
                this.m_source_filters.remove(ff.getNumber());
                break;
            }
            case 23: {
                this.m_text_filters.remove(ff.getNumber());
                break;
            }
            case 34: {
                this.m_slaveServers_filters.remove(ff.getNumber());
                break;
            }
            case 24: {
                this.m_severity_filters.remove(ff.getNumber());
                break;
            }
            case 25: {
                this.m_key_filters.remove(ff.getNumber());
                break;
            }
            case 26: {
                this.m_agentID_filters.remove(ff.getNumber());
                break;
            }
            case 27: {
                this.m_agentHost_filters.remove(ff.getNumber());
                break;
            }
            case 28: {
                this.m_ca_filters.remove(ff.getNumber());
                break;
            }
        }
    }

    @Deprecated
    public void addFilter(ForwardFilter ff) {
        switch (ff.getType()) {
            case 1: {
                this.addApplFilter(ff);
                break;
            }
            case 2: {
                this.addMsgGrpFilter(ff);
                break;
            }
            case 3: {
                this.addObjFilter(ff);
                break;
            }
            case 4: {
                this.addNodeFilter(ff);
                break;
            }
            case 5: {
                this.addServiceFilter(ff);
                break;
            }
            case 6: {
                this.m_ca1_filters.put(ff.getNumber(), ff);
                break;
            }
            case 7: {
                this.m_ca2_filters.put(ff.getNumber(), ff);
                break;
            }
            case 8: {
                this.m_ca3_filters.put(ff.getNumber(), ff);
                break;
            }
            case 9: {
                this.m_ca4_filters.put(ff.getNumber(), ff);
                break;
            }
            case 10: {
                this.m_ca5_filters.put(ff.getNumber(), ff);
                break;
            }
            case 11: {
                this.m_ca6_filters.put(ff.getNumber(), ff);
                break;
            }
            case 12: {
                this.m_ca7_filters.put(ff.getNumber(), ff);
                break;
            }
            case 13: {
                this.m_ca8_filters.put(ff.getNumber(), ff);
                break;
            }
            case 14: {
                this.m_ca9_filters.put(ff.getNumber(), ff);
                break;
            }
            case 15: {
                this.m_ca10_filters.put(ff.getNumber(), ff);
                break;
            }
            case 16: {
                this.m_ca11_filters.put(ff.getNumber(), ff);
                break;
            }
            case 17: {
                this.m_ca12_filters.put(ff.getNumber(), ff);
                break;
            }
            case 18: {
                this.m_ca13_filters.put(ff.getNumber(), ff);
                break;
            }
            case 19: {
                this.m_ca14_filters.put(ff.getNumber(), ff);
                break;
            }
            case 20: {
                this.m_ca15_filters.put(ff.getNumber(), ff);
                break;
            }
            case 21: {
                this.m_nodeGroups_filters.put(ff.getNumber(), ff);
                break;
            }
            case 22: {
                this.m_source_filters.put(ff.getNumber(), ff);
                break;
            }
            case 23: {
                this.m_text_filters.put(ff.getNumber(), ff);
                break;
            }
            case 34: {
                this.m_slaveServers_filters.put(ff.getNumber(), ff);
                break;
            }
            case 24: {
                this.m_severity_filters.put(ff.getNumber(), ff);
                break;
            }
            case 25: {
                this.m_key_filters.put(ff.getNumber(), ff);
                break;
            }
            case 26: {
                this.m_agentID_filters.put(ff.getNumber(), ff);
                break;
            }
            case 27: {
                this.m_agentHost_filters.put(ff.getNumber(), ff);
                break;
            }
            case 28: {
                this.m_ca_filters.put(ff.getNumber(), ff);
                break;
            }
        }
    }

    protected void addApplFilter(ForwardFilter ff) {
        this.m_appl_filters.put(ff.getNumber(), ff);
    }

    protected void addNodeFilter(ForwardFilter ff) {
        this.m_nodes_filters.put(ff.getNumber(), ff);
    }

    protected void addMsgGrpFilter(ForwardFilter ff) {
        this.m_mg_filters.put(ff.getNumber(), ff);
    }

    protected void addObjFilter(ForwardFilter ff) {
        this.m_obj_filters.put(ff.getNumber(), ff);
    }

    protected void addServiceFilter(ForwardFilter ff) {
        this.m_serv_filters.put(ff.getNumber(), ff);
    }

    protected List<Integer> checkCache(String text, Map<String, FilterCacheElement> cacheMap, Map<Integer, ForwardFilter> filters) {
        FilterCacheElement el = cacheMap.get(text);
        if (el == null) {
            el = new FilterCacheElement();
            for (Map.Entry<Integer, ForwardFilter> en : filters.entrySet()) {
                ForwardFilter ff = en.getValue();
                if (!ff.check(text).isMatch()) continue;
                el.list.add(ff.getNumber());
            }
            cacheMap.put(text, el);
        } else {
            el.accessCount.incrementAndGet();
            el.lastTime.set(System.currentTimeMillis());
        }
        if (cacheMap.size() > 3000 && System.currentTimeMillis() - this.optimizationTime.get() > 60000L) {
            this.optimizeCache(cacheMap);
        }
        return el.list;
    }

    public void optimizeCache(Map<String, FilterCacheElement> cacheMap) {
        if (m_greenToOptimize.compareAndSet(true, false)) {
            OptimizeFilterCache run = new OptimizeFilterCache(this, cacheMap, m_greenToOptimize);
            Thread optThr = new Thread((Runnable)run, "OptimusFiCa");
            optThr.start();
        }
    }

    public List<Integer> checkApplication(String appl) {
        return this.checkCache(appl, this.m_applications, this.m_appl_filters);
    }

    public List<Integer> checkNode(String node) {
        return this.checkCache(node, this.m_nodes, this.m_nodes_filters);
    }

    public List<Integer> checkMsgGrp(String msggrp) {
        return this.checkCache(msggrp, this.m_msggrps, this.m_mg_filters);
    }

    public List<Integer> checkObject(String obj) {
        return this.checkCache(obj, this.m_objects, this.m_obj_filters);
    }

    List<Integer> checkService(String service) {
        return this.checkCache(service, this.m_services, this.m_serv_filters);
    }

    List<Integer> checkCA1(String str) {
        return this.checkCache(str, this.m_ca1, this.m_ca1_filters);
    }

    List<Integer> checkCA2(String str) {
        return this.checkCache(str, this.m_ca2, this.m_ca2_filters);
    }

    List<Integer> checkCA3(String str) {
        return this.checkCache(str, this.m_ca3, this.m_ca3_filters);
    }

    List<Integer> checkCA4(String str) {
        return this.checkCache(str, this.m_ca4, this.m_ca4_filters);
    }

    List<Integer> checkCA5(String str) {
        return this.checkCache(str, this.m_ca5, this.m_ca5_filters);
    }

    List<Integer> checkCA6(String str) {
        return this.checkCache(str, this.m_ca6, this.m_ca6_filters);
    }

    List<Integer> checkCA7(String str) {
        return this.checkCache(str, this.m_ca7, this.m_ca7_filters);
    }

    List<Integer> checkCA8(String str) {
        return this.checkCache(str, this.m_ca8, this.m_ca8_filters);
    }

    List<Integer> checkCA9(String str) {
        return this.checkCache(str, this.m_ca9, this.m_ca9_filters);
    }

    List<Integer> checkCA10(String str) {
        return this.checkCache(str, this.m_ca10, this.m_ca10_filters);
    }

    List<Integer> checkCA11(String str) {
        return this.checkCache(str, this.m_ca11, this.m_ca11_filters);
    }

    List<Integer> checkCA12(String str) {
        return this.checkCache(str, this.m_ca12, this.m_ca12_filters);
    }

    List<Integer> checkCA13(String str) {
        return this.checkCache(str, this.m_ca13, this.m_ca13_filters);
    }

    List<Integer> checkCA14(String str) {
        return this.checkCache(str, this.m_ca14, this.m_ca14_filters);
    }

    List<Integer> checkCA15(String str) {
        return this.checkCache(str, this.m_ca15, this.m_ca15_filters);
    }

    List<Integer> checkNodeGroups(SEventFwd sef) {
        LinkedList<Integer> al = new LinkedList<Integer>();
        for (Map.Entry<Integer, ForwardFilter> en : this.m_nodeGroups_filters.entrySet()) {
            ForwardFilter ff = en.getValue();
            if (!ff.checkEventR(sef).isMatch()) continue;
            al.add(ff.getNumber());
        }
        return al;
    }

    List<Integer> checkSource(String str) {
        return this.checkCache(str, this.m_source, this.m_source_filters);
    }

    List<Integer> checkText(String str) {
        return this.checkCache(str, this.m_text, this.m_text_filters);
    }

    List<Integer> checkSlaveServer(String str) {
        return this.checkCache(str, this.m_slaveServers, this.m_slaveServers_filters);
    }

    private Collection<? extends Integer> checkCA(Map<String, String> customAttributes) {
        LinkedList<Integer> al = new LinkedList<Integer>();
        for (Map.Entry<Integer, ForwardFilter> en : this.m_ca_filters.entrySet()) {
            ForwardFilter ff = en.getValue();
            for (Map.Entry<String, String> enVar : customAttributes.entrySet()) {
                if (!this.cas.contains(enVar.getKey()) || !ff.check(enVar.getValue()).isMatch()) continue;
                al.add(ff.getNumber());
            }
        }
        return al;
    }

    private Collection<? extends Integer> checkAgentID(String t1) {
        LinkedList<Integer> al = new LinkedList<Integer>();
        for (Map.Entry<Integer, ForwardFilter> en : this.m_agentID_filters.entrySet()) {
            ForwardFilter ff = en.getValue();
            if (!ff.check(t1).isMatch()) continue;
            al.add(ff.getNumber());
        }
        return al;
    }

    private Collection<? extends Integer> checkAgentHost(String agentNode) {
        return this.checkCache(agentNode, this.m_agentHost, this.m_agentHost_filters);
    }

    private Collection<? extends Integer> checkSeverity(String severityStr) {
        return this.checkCache(severityStr, this.m_severity, this.m_severity_filters);
    }

    private Collection<? extends Integer> checkKey(String keyConfigured) {
        return this.checkCache(keyConfigured, this.m_key, this.m_key_filters);
    }

    public int getTotalFilterCount() {
        return this.m_appl_filters.size() + this.m_mg_filters.size() + this.m_obj_filters.size() + this.m_nodes_filters.size() + this.m_serv_filters.size() + this.m_ca1_filters.size() + this.m_ca2_filters.size() + this.m_ca3_filters.size() + this.m_ca4_filters.size() + this.m_ca5_filters.size() + this.m_ca6_filters.size() + this.m_ca7_filters.size() + this.m_ca8_filters.size() + this.m_ca9_filters.size() + this.m_ca10_filters.size() + this.m_ca11_filters.size() + this.m_ca12_filters.size() + this.m_ca13_filters.size() + this.m_ca14_filters.size() + this.m_ca15_filters.size() + this.m_nodeGroups_filters.size() + this.m_source_filters.size() + this.m_text_filters.size() + this.m_slaveServers_filters.size() + this.m_severity_filters.size() + this.m_key_filters.size() + this.m_agentID_filters.size() + this.m_agentHost_filters.size() + this.m_ca_filters.size();
    }

    public int getTotalCacheSize() {
        return this.m_applications.size() + this.m_msggrps.size() + this.m_objects.size() + this.m_nodes.size() + this.m_services.size() + this.m_ca1.size() + this.m_ca2.size() + this.m_ca3.size() + this.m_ca4.size() + this.m_ca5.size() + this.m_ca6.size() + this.m_ca7.size() + this.m_ca8.size() + this.m_ca9.size() + this.m_ca10.size() + this.m_ca11.size() + this.m_ca12.size() + this.m_ca13.size() + this.m_ca14.size() + this.m_ca15.size() + this.m_source.size() + this.m_text.size() + this.m_slaveServers.size() + this.m_severity.size() + this.m_key.size() + this.m_agentHost.size() + this.m_ca.size();
    }

    void cleanNodeGroupCache() {
    }

    void cleanAgentIDCache() {
    }

    private void cleanCache() {
        this.m_applications.clear();
        this.m_msggrps.clear();
        this.m_objects.clear();
        this.m_nodes.clear();
        this.m_services.clear();
        this.m_ca1.clear();
        this.m_ca2.clear();
        this.m_ca3.clear();
        this.m_ca4.clear();
        this.m_ca5.clear();
        this.m_ca6.clear();
        this.m_ca7.clear();
        this.m_ca8.clear();
        this.m_ca9.clear();
        this.m_ca10.clear();
        this.m_ca11.clear();
        this.m_ca12.clear();
        this.m_ca13.clear();
        this.m_ca14.clear();
        this.m_ca15.clear();
        this.m_source.clear();
        this.m_text.clear();
        this.m_slaveServers.clear();
        this.m_severity.clear();
        this.m_key.clear();
        this.m_agentHost.clear();
        this.m_ca.clear();
    }

    private void cleanFilters() {
        this.m_appl_filters.clear();
        this.m_mg_filters.clear();
        this.m_obj_filters.clear();
        this.m_nodes_filters.clear();
        this.m_serv_filters.clear();
        this.m_ca1_filters.clear();
        this.m_ca2_filters.clear();
        this.m_ca3_filters.clear();
        this.m_ca4_filters.clear();
        this.m_ca5_filters.clear();
        this.m_ca6_filters.clear();
        this.m_ca7_filters.clear();
        this.m_ca8_filters.clear();
        this.m_ca9_filters.clear();
        this.m_ca10_filters.clear();
        this.m_ca11_filters.clear();
        this.m_ca12_filters.clear();
        this.m_ca13_filters.clear();
        this.m_ca14_filters.clear();
        this.m_ca15_filters.clear();
        this.m_nodeGroups_filters.clear();
        this.m_source_filters.clear();
        this.m_text_filters.clear();
        this.m_slaveServers_filters.clear();
        this.m_severity_filters.clear();
        this.m_key_filters.clear();
        this.m_agentID_filters.clear();
        this.m_agentHost_filters.clear();
        this.m_ca_filters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(IEvent se, List<Integer> types, List<Integer> filters) {
        boolean match = false;
        this.reentrantRWLock.readLock().lock();
        try {
            match = filters == null || filters.isEmpty() || this._check(se, types, filters);
        }
        finally {
            this.reentrantRWLock.readLock().unlock();
        }
        return match;
    }

    private boolean _check(IEvent se, List<Integer> types, List<Integer> filters) {
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        HashSet<? extends Integer> all = new HashSet<Integer>();
        block33: for (int type : types) {
            switch (type) {
                case 1: {
                    all.addAll(this.checkApplication(se.getApplication()));
                    continue block33;
                }
                case 2: {
                    all.addAll(this.checkMsgGrp(se.getGroup()));
                    continue block33;
                }
                case 3: {
                    all.addAll(this.checkObject(se.getObject()));
                    continue block33;
                }
                case 4: {
                    all.addAll(this.checkNode(se.getNode()));
                    continue block33;
                }
                case 5: {
                    all.addAll(this.checkService(se.getService()));
                    continue block33;
                }
                case 22: {
                    all.addAll(this.checkSource(se.getSource()));
                    continue block33;
                }
                case 23: {
                    all.addAll(this.checkText(se.getText()));
                    continue block33;
                }
                case 25: {
                    all.addAll(this.checkKey(se.getKeyConfigured()));
                    continue block33;
                }
                case 24: {
                    all.addAll(this.checkSeverity(se.getSeverity()));
                    continue block33;
                }
                case 27: {
                    all.addAll(this.checkAgentHost(se.getAgentNode()));
                    continue block33;
                }
            }
            if (!(se instanceof SEventFwd)) continue;
            SEventFwd sef = (SEventFwd)se;
            switch (type) {
                case 6: {
                    all.addAll(this.checkCA1(sef.getCA1()));
                    break;
                }
                case 7: {
                    all.addAll(this.checkCA2(sef.getCA2()));
                    break;
                }
                case 8: {
                    all.addAll(this.checkCA3(sef.getCA3()));
                    break;
                }
                case 9: {
                    all.addAll(this.checkCA4(sef.getCA4()));
                    break;
                }
                case 10: {
                    all.addAll(this.checkCA5(sef.getCA5()));
                    break;
                }
                case 11: {
                    all.addAll(this.checkCA6(sef.getCA6()));
                    break;
                }
                case 12: {
                    all.addAll(this.checkCA7(sef.getCA7()));
                    break;
                }
                case 13: {
                    all.addAll(this.checkCA8(sef.getCA8()));
                    break;
                }
                case 14: {
                    all.addAll(this.checkCA9(sef.getCA9()));
                    break;
                }
                case 15: {
                    all.addAll(this.checkCA10(sef.getCA10()));
                    break;
                }
                case 16: {
                    all.addAll(this.checkCA11(sef.getCA11()));
                    break;
                }
                case 17: {
                    all.addAll(this.checkCA12(sef.getCA12()));
                    break;
                }
                case 18: {
                    all.addAll(this.checkCA13(sef.getCA13()));
                    break;
                }
                case 19: {
                    all.addAll(this.checkCA14(sef.getCA14()));
                    break;
                }
                case 20: {
                    all.addAll(this.checkCA15(sef.getCA15()));
                    break;
                }
                case 21: {
                    all.addAll(this.checkNodeGroups(sef));
                    break;
                }
                case 34: {
                    all.addAll(this.checkSlaveServer(sef.getSrv()));
                    break;
                }
                case 26: {
                    all.addAll(this.checkAgentID(sef.getT1()));
                    break;
                }
                case 28: {
                    all.addAll(this.checkCA(sef.m_CustomAttributes));
                }
            }
        }
        TreeSet<Integer> checkedFilters = new TreeSet<Integer>(filters);
        checkedFilters.removeAll(all);
        return checkedFilters.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewFile(Path path) {
        File inFile = path.toFile();
        this.reentrantRWLock.writeLock().lock();
        try {
            FPolicyFactory pf = new FPolicyFactory();
            BkpFile.backup(this.getFgfFile());
            List<ForwardFilter> al = pf.initFilters(inFile);
            List<ForwardFilter> oldList = this.getForwardFiltersInMemory();
            Diff<ForwardFilter> diff = new Diff<ForwardFilter>(al, oldList);
            if (diff.deletedObjects != null && diff.deletedObjects.size() > 0) {
                List<ForwardPolicy> policies = this.serverForwardPoliciesSupplier == null ? Collections.emptyList() : this.serverForwardPoliciesSupplier.get();
                HashSet<Integer> ffNumbersUsed = new HashSet<Integer>();
                for (ForwardPolicy fp : policies) {
                    ffNumbersUsed.addAll(fp.getFilters());
                }
                StringBuilder sb = new StringBuilder();
                for (ForwardFilter ff : diff.deletedObjects.values()) {
                    if (!ffNumbersUsed.contains(ff.getNumber())) continue;
                    if (sb.length() == 0) {
                        sb.append("Can't delete filter(s):\n");
                    }
                    sb.append('(').append(ff.getNumber()).append(") ").append(ff.getName()).append('\n');
                }
                if (sb.length() != 0) {
                    sb.append("linked to at least one Server Filter Policy.");
                    throw new RuntimeException(sb.toString());
                }
            }
            this.cleanCache();
            this.cleanFilters();
            for (ForwardFilter newFF : al) {
                this.addFilter(newFF);
            }
            this.storeFilters(al);
            this.reentrantRWLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            this.reentrantRWLock.writeLock().unlock();
            try {
                Files.deleteIfExists(inFile.toPath());
            }
            catch (Exception e) {
                RTLogger.print(5, "error deleting temp incoming filter file {}", path, e);
            }
            throw throwable;
        }
        try {
            Files.deleteIfExists(inFile.toPath());
        }
        catch (Exception e) {
            RTLogger.print(5, "error deleting temp incoming filter file {}", path, e);
        }
    }

    public void storeFilters(List<ForwardFilter> al) {
        new FPolicyFactory().storeFilters(al, this.getFgfFile());
    }

    public List<ForwardFilter> getForwardFiltersInMemory() {
        ArrayList<ForwardFilter> all = new ArrayList<ForwardFilter>(this.getTotalFilterCount());
        all.addAll(this.m_appl_filters.values());
        all.addAll(this.m_mg_filters.values());
        all.addAll(this.m_obj_filters.values());
        all.addAll(this.m_nodes_filters.values());
        all.addAll(this.m_serv_filters.values());
        all.addAll(this.m_ca1_filters.values());
        all.addAll(this.m_ca2_filters.values());
        all.addAll(this.m_ca3_filters.values());
        all.addAll(this.m_ca4_filters.values());
        all.addAll(this.m_ca5_filters.values());
        all.addAll(this.m_ca6_filters.values());
        all.addAll(this.m_ca7_filters.values());
        all.addAll(this.m_ca8_filters.values());
        all.addAll(this.m_ca9_filters.values());
        all.addAll(this.m_ca10_filters.values());
        all.addAll(this.m_ca11_filters.values());
        all.addAll(this.m_ca12_filters.values());
        all.addAll(this.m_ca13_filters.values());
        all.addAll(this.m_ca14_filters.values());
        all.addAll(this.m_ca15_filters.values());
        all.addAll(this.m_nodeGroups_filters.values());
        all.addAll(this.m_source_filters.values());
        all.addAll(this.m_text_filters.values());
        all.addAll(this.m_slaveServers_filters.values());
        all.addAll(this.m_severity_filters.values());
        all.addAll(this.m_key_filters.values());
        all.addAll(this.m_agentID_filters.values());
        all.addAll(this.m_agentHost_filters.values());
        all.addAll(this.m_ca_filters.values());
        return all;
    }

    public class OptimizeFilterCache
    implements Runnable {
        Map<String, FilterCacheElement> cacheMap = null;
        AtomicBoolean cleanWhenFinished = null;

        public OptimizeFilterCache(FiltersCache this$0, Map<String, FilterCacheElement> cacheMap, AtomicBoolean cleanWhenFinished) {
            this.cacheMap = cacheMap;
            this.cleanWhenFinished = cleanWhenFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                double avrg = 0.0;
                long start = System.currentTimeMillis();
                for (Map.Entry<String, FilterCacheElement> en : this.cacheMap.entrySet()) {
                    avrg += en.getValue().getRate();
                }
                if ((avrg /= (double)this.cacheMap.size()) > 1.0) {
                    Iterator<Map.Entry<String, FilterCacheElement>> it = this.cacheMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, FilterCacheElement> en;
                        en = it.next();
                        if (!(en.getValue().getRate() > avrg)) continue;
                        it.remove();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("Optimize filter cache - ");
                    sb.append(System.currentTimeMillis() - start);
                    sb.append(" ms. Avrg: ").append(avrg).append(" size: ").append(this.cacheMap.size());
                    RTLogger.print(4, sb);
                }
            }
            finally {
                this.cleanWhenFinished.set(true);
            }
        }
    }
}

