/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.server.ext;

import com.blixx.log.RTLogger;
import com.blixx.server.AgentCard;
import com.blixx.server.ServerEngine;
import com.blixx.server.ext.ForwardAction;
import com.blixx.server.ext.ForwardTask;
import com.blixx.server.notify.NotifierManager;
import com.blixx.shared.BM;
import com.blixx.shared.IEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.SupportedVariablesS;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.notify.NotifierQueueFull;
import com.blixx.shared.notify.NotifierStopped;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.UrlEncoded;

public class ForwardActionsManager {
    public LinkedBlockingQueue<ForwardAction> m_queue = new LinkedBlockingQueue();
    private ForwardTask m_task = null;
    private static volatile ForwardActionsManager m_fmgr = null;
    private HashMap<String, String> m_failedJavaClasses = new HashMap();

    private ForwardActionsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ForwardActionsManager getInstance() {
        if (m_fmgr != null) return m_fmgr;
        Class<ForwardActionsManager> clazz = ForwardActionsManager.class;
        synchronized (ForwardActionsManager.class) {
            if (m_fmgr != null) return m_fmgr;
            ForwardActionsManager fmgr = new ForwardActionsManager();
            fmgr.m_task = new ForwardTask("ForwardTask", fmgr);
            ServerEngine.getInstance().getScheduler().addTask(fmgr.m_task, 0L);
            m_fmgr = fmgr;
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_fmgr;
        }
    }

    public void addAction(String type, String to, String xsend, SEventFwd se) {
        if (type.equals(ForwardCondition.TYPE_EXEC)) {
            String exec = ForwardActionsManager.prepareString(se, to, true);
            ForwardAction fa = new ForwardAction(ForwardCondition.TYPE_EXEC, exec);
            this.m_queue.add(fa);
        } else if (type.equals(ForwardCondition.TYPE_JAVA)) {
            String[] arr = to.split("\\s+");
            String className = arr[0];
            if (this.m_failedJavaClasses.containsKey(className)) {
                return;
            }
            try {
                Class<?> action = Class.forName(className);
                Constructor<?> constr = action.getConstructor(String.class, String.class);
                String message = ForwardActionsManager.prepareString(se, xsend, false);
                Object obj = constr.newInstance(to, message);
                this.m_queue.add((ForwardAction)obj);
            }
            catch (Throwable e) {
                this.m_failedJavaClasses.put(className, "");
                RTLogger.print(3, "Error Java Forward Action.", e);
            }
        } else if (type.equals(ForwardCondition.TYPE_NOTIFICATION)) {
            try {
                NotifierManager.getInstance().sendAsNotification(to, se, null);
            }
            catch (NotifierStopped e) {
                StringBuilder sb = new StringBuilder("Notifier: ").append(to);
                sb.append("\n").append("Message id: ").append(se.getID()).append(" was not processed.");
                sb.append("Error: Notifier is not started");
                RTLogger.print(2, sb);
            }
            catch (NotifierQueueFull e) {
                StringBuilder sb = new StringBuilder("Notifier: ").append(to);
                sb.append("\n").append("Message id: ").append(se.getID()).append(" was not processed.");
                sb.append("Error: Notifier queue is full");
                RTLogger.print(2, sb);
            }
        }
    }

    public static String prepareString(SEventFwd sef, String message, boolean quotedOneLine) {
        if (message == null || sef == null) {
            return message;
        }
        AgentCard ac = null;
        if (sef.getT1() != null && sef.getT1().length() > 30) {
            ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(sef.getT1());
            message = message.replace("<$AGENT_ID>", sef.getT1());
        }
        if (ac == null) {
            ac = ServerEngine.getInstance().getAgentRepository().getAgentCard(sef.getAgentNode(), 0);
        }
        message = message.replace("<$AGENT_HOST>", sef.getAgentNode());
        if (ac != null) {
            message = message.replace("<$AGENT_IP>", ac.getAgentIP());
        }
        message = sef.getNode().equals("") ? message.replace("<$HOST>", ForwardActionsManager.getQuoted(ServerEngine.getInstance().getServerProps().getHostname(), quotedOneLine)) : message.replace("<$HOST>", ForwardActionsManager.getQuoted(sef.getNode(), quotedOneLine));
        message = message.replace("<$OBJECT>", ForwardActionsManager.getQuoted(sef.getObject(), quotedOneLine));
        message = message.replace("<$SEVERITY>", sef.getSeverity());
        message = message.replace("<$SEVERITY_INT>", "" + sef.getSeverityInt());
        message = message.replace("<$NAME>", ForwardActionsManager.getQuoted(sef.getMonitor(), quotedOneLine));
        message = message.replace("<$SOURCE>", ForwardActionsManager.getQuoted(sef.getSource(), quotedOneLine));
        message = message.replace("<$VALUE>", "" + sef.getValue());
        message = message.replace("<$APPLICATION>", ForwardActionsManager.getQuoted(sef.getApplication(), quotedOneLine));
        message = message.replace("<$GROUP>", ForwardActionsManager.getQuoted(sef.getGroup(), quotedOneLine));
        if ((message = message.replace("<$IID>", sef.getID())).contains("TIME_STR>")) {
            message = message.replace("<$TIME_STR>", ForwardActionsManager.getQuoted(BM.m_sdf.format(new Date(sef.getTime())), quotedOneLine));
            message = message.replace("<$STIME_STR>", ForwardActionsManager.getQuoted(BM.m_sdf.format(new Date(sef.getSTime())), quotedOneLine));
            message = message.replace("<$FTIME_STR>", ForwardActionsManager.getQuoted(BM.m_sdf.format(new Date(sef.getFirstTime())), quotedOneLine));
        }
        if (message.contains("TIME>")) {
            message = message.replace("<$TIME>", "" + sef.getTime());
            message = message.replace("<$STIME>", "" + sef.getSTime());
            message = message.replace("<$FTIME>", "" + sef.getFirstTime());
        }
        message = message.replace("<$TYPE_A>", "" + sef.getTypeA());
        message = message.replace("<$TYPE_K>", "" + sef.getTypeK());
        message = message.replace("<$DUPLICATES>", "" + sef.getDuplicates());
        message = message.replace("<$KEY>", ForwardActionsManager.getQuoted(sef.getKeyConfigured(), quotedOneLine));
        message = message.replace("<$AKEY>", ForwardActionsManager.getQuoted(sef.getCloseMask(), quotedOneLine));
        String text = sef.getText();
        if (quotedOneLine) {
            text = sef.getText().replace("\r", "").replace('\n', ' ').replace("\"", "\\\"");
        }
        message = message.replace("<$TEXT>", ForwardActionsManager.getQuoted(text, quotedOneLine));
        message = message.replace("<$SMSG_TEXT>", ForwardActionsManager.getQuoted(text, quotedOneLine));
        String firstLine = sef.getText();
        int firstNL = firstLine.indexOf(10);
        if (firstNL != -1) {
            firstLine = firstLine.substring(0, firstNL);
        }
        message = message.replace("<$TEXT_1LINE>", ForwardActionsManager.getQuoted(firstLine, quotedOneLine));
        if (text != null && text.length() > 255) {
            text = text.substring(0, 256);
        }
        message = message.replace("<$TEXT_255>", ForwardActionsManager.getQuoted(text, quotedOneLine));
        if (text != null && text.length() > 80) {
            text = text.substring(0, 80);
        }
        message = message.replace("<$TEXT_80>", ForwardActionsManager.getQuoted(text, quotedOneLine));
        if (text != null && text.length() > 40) {
            text = text.substring(0, 40);
        }
        message = message.replace("<$TEXT_40>", ForwardActionsManager.getQuoted(text, quotedOneLine));
        message = message.replace("<$BOOM_SERVER>", ServerEngine.getInstance().getServerProps().getHostname());
        if ((message = message.replace("<$BOOM_SERVER_IP>", ServerEngine.getInstance().getServerProps().getIP())).contains("<$")) {
            StringBuilder sb;
            String ca1 = sef.getCA1();
            message = message.replace("<$CA1>", ForwardActionsManager.getQuoted(ca1, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca1);
            String ca2 = sef.getCA2();
            message = message.replace("<$CA2>", ForwardActionsManager.getQuoted(ca2, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca2);
            String ca3 = sef.getCA3();
            message = message.replace("<$CA3>", ForwardActionsManager.getQuoted(ca3, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca3);
            String ca4 = sef.getCA4();
            message = message.replace("<$CA4>", ForwardActionsManager.getQuoted(ca4, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca4);
            String ca5 = sef.getCA5();
            message = message.replace("<$CA5>", ForwardActionsManager.getQuoted(ca5, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca5);
            String ca6 = sef.getCA6();
            message = message.replace("<$CA6>", ForwardActionsManager.getQuoted(ca6, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca6);
            String ca7 = sef.getCA7();
            message = message.replace("<$CA7>", ForwardActionsManager.getQuoted(ca7, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca7);
            String ca8 = sef.getCA8();
            message = message.replace("<$CA8>", ForwardActionsManager.getQuoted(ca8, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca8);
            String ca9 = sef.getCA9();
            message = message.replace("<$CA9>", ForwardActionsManager.getQuoted(ca9, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca9);
            String ca10 = sef.getCA10();
            message = message.replace("<$CA10>", ForwardActionsManager.getQuoted(ca10, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca10);
            String ca11 = sef.getCA11();
            message = message.replace("<$CA11>", ForwardActionsManager.getQuoted(ca11, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca11);
            String ca12 = sef.getCA12();
            message = message.replace("<$CA12>", ForwardActionsManager.getQuoted(ca12, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca12);
            String ca13 = sef.getCA13();
            message = message.replace("<$CA13>", ForwardActionsManager.getQuoted(ca13, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca13);
            String ca14 = sef.getCA14();
            message = message.replace("<$CA14>", ForwardActionsManager.getQuoted(ca14, quotedOneLine));
            message = ForwardActionsManager.replaceCAbyName(message, ca14);
            String ca15 = sef.getCA15();
            message = message.replace("<$CA15>", ForwardActionsManager.getQuoted(ca15, quotedOneLine));
            if ((message = ForwardActionsManager.replaceCAbyName(message, ca15)).indexOf("<$CA_CSV>") != -1) {
                sb = new StringBuilder();
                ForwardActionsManager.addCA(ca1, ", ", sb);
                ForwardActionsManager.addCA(ca2, ", ", sb);
                ForwardActionsManager.addCA(ca3, ", ", sb);
                ForwardActionsManager.addCA(ca4, ", ", sb);
                ForwardActionsManager.addCA(ca5, ", ", sb);
                ForwardActionsManager.addCA(ca6, ", ", sb);
                ForwardActionsManager.addCA(ca7, ", ", sb);
                ForwardActionsManager.addCA(ca8, ", ", sb);
                ForwardActionsManager.addCA(ca9, ", ", sb);
                ForwardActionsManager.addCA(ca10, ", ", sb);
                ForwardActionsManager.addCA(ca11, ", ", sb);
                ForwardActionsManager.addCA(ca12, ", ", sb);
                ForwardActionsManager.addCA(ca13, ", ", sb);
                ForwardActionsManager.addCA(ca14, ", ", sb);
                ForwardActionsManager.addCA(ca15, ", ", sb);
                message = message.replace("<$CA_CSV>", ForwardActionsManager.getQuoted(sb.toString(), quotedOneLine));
            }
            if (message.indexOf("<$CA_NL>") != -1) {
                sb = new StringBuilder();
                ForwardActionsManager.addCA(ca1, "\n", sb);
                ForwardActionsManager.addCA(ca2, "\n", sb);
                ForwardActionsManager.addCA(ca3, "\n", sb);
                ForwardActionsManager.addCA(ca4, "\n", sb);
                ForwardActionsManager.addCA(ca5, "\n", sb);
                ForwardActionsManager.addCA(ca6, "\n", sb);
                ForwardActionsManager.addCA(ca7, "\n", sb);
                ForwardActionsManager.addCA(ca8, "\n", sb);
                ForwardActionsManager.addCA(ca9, "\n", sb);
                ForwardActionsManager.addCA(ca10, "\n", sb);
                ForwardActionsManager.addCA(ca11, "\n", sb);
                ForwardActionsManager.addCA(ca12, "\n", sb);
                ForwardActionsManager.addCA(ca13, "\n", sb);
                ForwardActionsManager.addCA(ca14, "\n", sb);
                ForwardActionsManager.addCA(ca15, "\n", sb);
                message = message.replace("<$CA_NL>", ForwardActionsManager.getQuoted(sb.toString(), quotedOneLine));
            }
        }
        String attachmentPattern = "<\\$AttachmentInBody(.*)>";
        Pattern p = Pattern.compile(attachmentPattern);
        Matcher m = p.matcher(message);
        ArrayList<String> attachments = new ArrayList<String>();
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                String attachmentLine = m.group(i);
                attachments.add(attachmentLine);
            }
        }
        StringBuilder attachmentContent = new StringBuilder();
        double totalFileSize = 0.0;
        for (String attachment : attachments) {
            double bytes;
            double fileSize;
            String fileName = attachment.replace("<$AttachmentInBody(", "").replace(")>", "");
            File file = new File(fileName);
            if (!file.exists()) {
                if (fileName.contains("=")) {
                    file = new File(fileName = fileName.split("=")[1]);
                    if (!file.exists()) {
                        attachmentContent.append("File does not exist : " + fileName).append("\r\n");
                        RTLogger.print(3, "File does not exist : " + fileName);
                        continue;
                    }
                } else {
                    attachmentContent.append("File does not exist : " + fileName).append("\r\n");
                    RTLogger.print(3, "File does not exist : " + fileName);
                    continue;
                }
            }
            if ((totalFileSize += (fileSize = (bytes = (double)file.length()) / 1024.0)) > 2048.0) {
                attachmentContent.append("Attachments size can not exceed 2Mb, File contents until 2Mb is added.").append("\r\n");
                RTLogger.print(3, "File size can not exceed 2Mb");
                break;
            }
            try {
                attachmentContent.append(new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8)).append("\r\n");
            }
            catch (IOException e) {
                attachmentContent.append("Error while reading file : " + fileName).append("\r\n");
                RTLogger.print(3, "Error while reading file", e);
            }
        }
        for (int i = 0; i < attachments.size(); ++i) {
            message = i == 0 ? message.replace((CharSequence)attachments.get(i), attachmentContent.toString()) : message.replace((CharSequence)attachments.get(i), "");
        }
        return message;
    }

    private static void addCA(String ca, String splitStr, StringBuilder sb) {
        if (ca != null) {
            if (splitStr != null && sb.length() > 0) {
                sb.append(splitStr);
            }
            sb.append(ca);
        }
    }

    public static String prepareStringURLEncoded(IEvent se, String message) {
        SEventFwd sef;
        AgentCard ac = null;
        if (se instanceof SEventFwd && (sef = (SEventFwd)se).getT1() != null && sef.getT1().length() > 30) {
            ac = ServerEngine.getInstance().getAgentRepository().getAgentCardByID(sef.getT1());
            message = message.replace("<$AGENT_ID>", sef.getT1());
        }
        if (ac == null) {
            ac = ServerEngine.getInstance().getAgentRepository().getAgentCard(se.getAgentNode(), 0);
        }
        message = message.replace("<$AGENT_HOST>", ForwardActionsManager.getURLEncoded(se.getAgentNode()));
        if (ac != null) {
            message = message.replace("<$AGENT_IP>", ForwardActionsManager.getURLEncoded(ac.getAgentIP()));
        }
        message = se.getNode().equals("") ? message.replace("<$HOST>", ForwardActionsManager.getURLEncoded(ServerEngine.getInstance().getServerProps().getHostname())) : message.replace("<$HOST>", ForwardActionsManager.getURLEncoded(se.getNode()));
        message = message.replace("<$OBJECT>", ForwardActionsManager.getURLEncoded(se.getObject()));
        message = message.replace("<$SEVERITY>", se.getSeverity());
        message = message.replace("<$SEVERITY_INT>", "" + se.getSeverityInt());
        message = message.replace("<$NAME>", ForwardActionsManager.getURLEncoded(se.getMonitor()));
        message = message.replace("<$SOURCE>", ForwardActionsManager.getURLEncoded(se.getSource()));
        message = message.replace("<$VALUE>", ForwardActionsManager.getURLEncoded("" + se.getValue()));
        message = message.replace("<$APPLICATION>", ForwardActionsManager.getURLEncoded(se.getApplication()));
        message = message.replace("<$GROUP>", ForwardActionsManager.getURLEncoded(se.getGroup()));
        if ((message = message.replace("<$IID>", se.getID())).contains("TIME_STR>")) {
            message = message.replace("<$TIME_STR>", ForwardActionsManager.getURLEncoded(BM.m_sdf.format(new Date(se.getTime()))));
            message = message.replace("<$STIME_STR>", ForwardActionsManager.getURLEncoded(BM.m_sdf.format(new Date(se.getSTime()))));
            message = message.replace("<$FTIME_STR>", ForwardActionsManager.getURLEncoded(BM.m_sdf.format(new Date(se.getFirstTime()))));
        }
        if (message.contains("TIME>")) {
            message = message.replace("<$TIME>", "" + se.getTime());
            message = message.replace("<$STIME>", "" + se.getSTime());
            message = message.replace("<$FTIME>", "" + se.getFirstTime());
        }
        message = message.replace("<$TYPE_A>", "" + se.getTypeA());
        message = message.replace("<$TYPE_K>", "" + se.getTypeK());
        message = message.replace("<$DUPLICATES>", "" + se.getDuplicates());
        message = message.replace("<$KEY>", ForwardActionsManager.getURLEncoded(se.getKeyConfigured()));
        message = message.replace("<$AKEY>", ForwardActionsManager.getURLEncoded(se.getCloseMask()));
        String text = se.getText().replace("\r", "").replace('\n', ' ').replace("\"", "\\\"");
        message = message.replace("<$TEXT>", ForwardActionsManager.getURLEncoded(text));
        message = message.replace("<$SMSG_TEXT>", ForwardActionsManager.getURLEncoded(text));
        String firstLine = se.getText();
        int firstNL = firstLine.indexOf(10);
        if (firstNL != -1) {
            firstLine = firstLine.substring(0, firstNL);
        }
        message = message.replace("<$TEXT_1LINE>", ForwardActionsManager.getURLEncoded(firstLine));
        if (text.length() > 255) {
            text = text.substring(0, 255);
        }
        message = message.replace("<$TEXT_255>", ForwardActionsManager.getURLEncoded(text));
        if (text.length() > 80) {
            text = text.substring(0, 80);
        }
        message = message.replace("<$TEXT_80>", ForwardActionsManager.getURLEncoded(text));
        if (text.length() > 40) {
            text = text.substring(0, 40);
        }
        message = message.replace("<$TEXT_40>", ForwardActionsManager.getURLEncoded(text));
        message = message.replace("<$BOOM_SERVER>", ForwardActionsManager.getURLEncoded(ServerEngine.getInstance().getServerProps().getHostname()));
        message = message.replace("<$BOOM_SERVER_IP>", ForwardActionsManager.getURLEncoded(ServerEngine.getInstance().getServerProps().getIP()));
        if (se instanceof SEventFwd && message.contains("<$")) {
            StringBuilder sb;
            SEventFwd sef2 = (SEventFwd)se;
            String ca1 = sef2.getCA1();
            message = message.replace("<$CA1>", ForwardActionsManager.getURLEncoded(ca1));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca1);
            String ca2 = sef2.getCA2();
            message = message.replace("<$CA2>", ForwardActionsManager.getURLEncoded(ca2));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca2);
            String ca3 = sef2.getCA3();
            message = message.replace("<$CA3>", ForwardActionsManager.getURLEncoded(ca3));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca3);
            String ca4 = sef2.getCA4();
            message = message.replace("<$CA4>", ForwardActionsManager.getURLEncoded(ca4));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca4);
            String ca5 = sef2.getCA5();
            message = message.replace("<$CA5>", ForwardActionsManager.getURLEncoded(ca5));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca5);
            String ca6 = sef2.getCA6();
            message = message.replace("<$CA6>", ForwardActionsManager.getURLEncoded(ca6));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca6);
            String ca7 = sef2.getCA7();
            message = message.replace("<$CA7>", ForwardActionsManager.getURLEncoded(ca7));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca7);
            String ca8 = sef2.getCA8();
            message = message.replace("<$CA8>", ForwardActionsManager.getURLEncoded(ca8));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca8);
            String ca9 = sef2.getCA9();
            message = message.replace("<$CA9>", ForwardActionsManager.getURLEncoded(ca9));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca9);
            String ca10 = sef2.getCA10();
            message = message.replace("<$CA10>", ForwardActionsManager.getURLEncoded(ca10));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca10);
            String ca11 = sef2.getCA11();
            message = message.replace("<$CA11>", ForwardActionsManager.getURLEncoded(ca11));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca11);
            String ca12 = sef2.getCA12();
            message = message.replace("<$CA12>", ForwardActionsManager.getURLEncoded(ca12));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca12);
            String ca13 = sef2.getCA13();
            message = message.replace("<$CA13>", ForwardActionsManager.getURLEncoded(ca13));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca13);
            String ca14 = sef2.getCA14();
            message = message.replace("<$CA14>", ForwardActionsManager.getURLEncoded(ca14));
            message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca14);
            String ca15 = sef2.getCA15();
            message = message.replace("<$CA15>", ForwardActionsManager.getURLEncoded(ca15));
            if ((message = ForwardActionsManager.replaceCAbyNameURLEncoded(message, ca15)).indexOf("<$CA_CSV>") != -1) {
                sb = new StringBuilder();
                ForwardActionsManager.addCA(ca1, ", ", sb);
                ForwardActionsManager.addCA(ca2, ", ", sb);
                ForwardActionsManager.addCA(ca3, ", ", sb);
                ForwardActionsManager.addCA(ca4, ", ", sb);
                ForwardActionsManager.addCA(ca5, ", ", sb);
                ForwardActionsManager.addCA(ca6, ", ", sb);
                ForwardActionsManager.addCA(ca7, ", ", sb);
                ForwardActionsManager.addCA(ca8, ", ", sb);
                ForwardActionsManager.addCA(ca9, ", ", sb);
                ForwardActionsManager.addCA(ca10, ", ", sb);
                ForwardActionsManager.addCA(ca11, ", ", sb);
                ForwardActionsManager.addCA(ca12, ", ", sb);
                ForwardActionsManager.addCA(ca13, ", ", sb);
                ForwardActionsManager.addCA(ca14, ", ", sb);
                ForwardActionsManager.addCA(ca15, ", ", sb);
                message = message.replace("<$CA_CSV>", ForwardActionsManager.getURLEncoded(sb.toString()));
            }
            if (message.indexOf("<$CA_NL>") != -1) {
                sb = new StringBuilder();
                ForwardActionsManager.addCA(ca1, "\n", sb);
                ForwardActionsManager.addCA(ca2, "\n", sb);
                ForwardActionsManager.addCA(ca3, "\n", sb);
                ForwardActionsManager.addCA(ca4, "\n", sb);
                ForwardActionsManager.addCA(ca5, "\n", sb);
                ForwardActionsManager.addCA(ca6, "\n", sb);
                ForwardActionsManager.addCA(ca7, "\n", sb);
                ForwardActionsManager.addCA(ca8, "\n", sb);
                ForwardActionsManager.addCA(ca9, "\n", sb);
                ForwardActionsManager.addCA(ca10, "\n", sb);
                ForwardActionsManager.addCA(ca11, "\n", sb);
                ForwardActionsManager.addCA(ca12, "\n", sb);
                ForwardActionsManager.addCA(ca13, "\n", sb);
                ForwardActionsManager.addCA(ca14, "\n", sb);
                ForwardActionsManager.addCA(ca15, "\n", sb);
                message = message.replace("<$CA_NL>", ForwardActionsManager.getURLEncoded(sb.toString()));
            }
        }
        String attachmentPattern = "<\\$AttachmentInBody(.*)>";
        Pattern p = Pattern.compile(attachmentPattern);
        Matcher m = p.matcher(message);
        ArrayList<String> attachments = new ArrayList<String>();
        while (m.find()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                String attachmentLine = m.group(i);
                attachments.add(attachmentLine);
            }
        }
        StringBuilder attachmentContent = new StringBuilder();
        double totalFileSize = 0.0;
        for (String attachment : attachments) {
            double bytes;
            double fileSize;
            String fileName = attachment.replace("<$AttachmentInBody(", "").replace(")>", "");
            File file = new File(fileName);
            if (!file.exists()) {
                if (fileName.contains("=")) {
                    file = new File(fileName = fileName.split("=")[1]);
                    if (!file.exists()) {
                        attachmentContent.append("File does not exist : " + fileName).append("\r\n");
                        RTLogger.print(3, "File does not exist : " + fileName);
                        continue;
                    }
                } else {
                    attachmentContent.append("File does not exist : " + fileName).append("\r\n");
                    RTLogger.print(3, "File does not exist : " + fileName);
                    continue;
                }
            }
            if ((totalFileSize += (fileSize = (bytes = (double)file.length()) / 1024.0)) > 2048.0) {
                attachmentContent.append("Attachments size can not exceed 2Mb, File contents until 2Mb is added.").append("\r\n");
                RTLogger.print(3, "File size can not exceed 2Mb");
                break;
            }
            try {
                attachmentContent.append(new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8)).append("\r\n");
            }
            catch (IOException e) {
                attachmentContent.append("Error while reading file : " + fileName).append("\r\n");
                RTLogger.print(3, "Error while reading file", e);
            }
        }
        for (int i = 0; i < attachments.size(); ++i) {
            message = i == 0 ? message.replace((CharSequence)attachments.get(i), ForwardActionsManager.getURLEncoded(attachmentContent.toString())) : message.replace((CharSequence)attachments.get(i), "");
        }
        return message;
    }

    private static String replaceCAbyName(String message, String ca1) {
        return SupportedVariablesS.replaceCAbyName(message, ca1);
    }

    private static String replaceCAbyNameURLEncoded(String message, String ca1) {
        try {
            int eq = ca1.indexOf(61);
            if (eq != -1) {
                String name = ca1.substring(0, eq);
                String value = ca1.substring(eq + 1);
                message = message.replace("<$" + name + ">", ForwardActionsManager.getURLEncoded(value));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public static String prepareQuotes(String in) {
        if (in == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '\\' || in.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    public static String getQuoted(String in, boolean quotedOneLine) {
        if (!quotedOneLine) {
            return in;
        }
        StringBuilder sb = new StringBuilder("\"");
        if (in != null) {
            for (int i = 0; i < in.length(); ++i) {
                if (in.charAt(i) == '\\' || in.charAt(i) == '\"') {
                    sb.append('\\');
                }
                sb.append(in.charAt(i));
            }
        } else {
            sb.append("null");
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String getURLEncoded(String in) {
        return UrlEncoded.encodeString((String)in, (Charset)Charset.forName("UTF-8"));
    }
}

